/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.formplugin.invoice;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.pmgt.pmbs.common.enums.ContractStatusEnum;
import kd.pmgt.pmbs.common.enums.OutInvoiceStatusEnum;
import kd.pmgt.pmbs.common.utils.ProjectPermissionHelper;
import kd.pmgt.pmbs.common.utils.TextHelper;
import kd.pmgt.pmct.common.utils.InvoiceUtils;

public class OutInvoiceListPlugin
extends AbstractListPlugin {
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "download": {
                List orgIds = ((ListView)this.getView()).getSelectedMainOrgIds();
                if (orgIds != null && orgIds.size() != 0) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("formId", "pmct_daterange");
                    FormShowParameter parameter = FormShowParameter.createFormShowParameter(map);
                    parameter.getOpenStyle().setShowType(ShowType.Modal);
                    CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "pmct_daterange");
                    HashMap<String, String> customParams = new HashMap<String, String>(16);
                    customParams.put("direction", "out");
                    parameter.setCustomParams(customParams);
                    parameter.setCloseCallBack(callBack);
                    this.getView().showForm(parameter);
                    break;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ec4\u7ec7\u3002", (String)"OutInvoiceListPlugin_24", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                break;
            }
            case "claim": {
                ListSelectedRowCollection selCols = ((ListView)this.getView()).getSelectedRows().getBillListSelectedRowCollection();
                boolean flag = this.verifyClaim(selCols);
                DynamicObject selectProject = null;
                ArrayList<Long> list = new ArrayList<Long>();
                HashSet<Long> objects = new HashSet<Long>();
                if (!flag) {
                    args.setCancel(true);
                    return;
                }
                int size = selCols.size();
                if (size > 1) {
                    Object[] primaryKeyValues = selCols.getPrimaryKeyValues();
                    DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((Object[])primaryKeyValues, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmct_outinvoice"));
                    boolean verifyOrg = this.verifyOrg(dynamicObjects, objects);
                    boolean sameProjectFlag = this.verifyProjectOnly(dynamicObjects);
                    if (sameProjectFlag) {
                        selectProject = dynamicObjects[0].getDynamicObject("project");
                    }
                    list = new ArrayList<Long>(objects);
                    if (!verifyOrg) {
                        args.setCancel(true);
                        return;
                    }
                }
                if (size == 1) {
                    DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)selCols.get(0).getPrimaryKeyValue(), (String)"pmct_outinvoice");
                    Object orgpk = dynamicObject.getDynamicObject("org").getPkValue();
                    list.add(Long.valueOf(orgpk.toString()));
                }
                RefObject contractId = new RefObject();
                if (operate.getOption().tryGetVariableValue("contract_id", contractId)) break;
                ListShowParameter parameter = ShowFormHelper.createShowListForm((String)"pmct_contractf7", (boolean)true, (int)2);
                parameter.setShowUsed(true);
                parameter.setShowApproved(true);
                parameter.setMultiSelect(false);
                QFilter contractFilter = ProjectPermissionHelper.getPermContractFilter(list, (boolean)false, (DynamicObject)selectProject, (String)"pmct_outinvoice", (String)operateKey);
                parameter.getListFilterParameter().getQFilters().add(contractFilter);
                QFilter paydirection = new QFilter("paydirection", "=", (Object)"in");
                parameter.getListFilterParameter().getQFilters().add(paydirection);
                QFilter contractStatusQfilter = new QFilter("contractstatus.number", "=", (Object)ContractStatusEnum.RUNNING.getValue()).or(new QFilter("contractstatus.number", "=", (Object)ContractStatusEnum.CLOSED.getValue()));
                parameter.getListFilterParameter().getQFilters().add(contractStatusQfilter);
                CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "pmct_incontract");
                parameter.setCloseCallBack(callBack);
                this.getView().showForm((FormShowParameter)parameter);
                args.setCancel(true);
                break;
            }
            case "noncontclaim": {
                ListSelectedRowCollection selCols = ((ListView)this.getView()).getSelectedRows().getBillListSelectedRowCollection();
                boolean flag = this.verifyClaim(selCols);
                if (!flag) {
                    args.setCancel(true);
                    return;
                }
                RefObject projectId = new RefObject();
                if (operate.getOption().tryGetVariableValue("project_id", projectId)) break;
                ListShowParameter parameter = ShowFormHelper.createShowListForm((String)"bd_project", (boolean)true, (int)2);
                parameter.setShowUsed(true);
                parameter.setShowApproved(true);
                parameter.setMultiSelect(false);
                long orgId = RequestContext.get().getOrgId();
                List orgIds = OrgServiceHelper.getAllSubordinateOrgs((long)orgId, (boolean)true);
                QFilter orgFilter = new QFilter("org", "in", (Object)orgIds);
                parameter.getListFilterParameter().getQFilters().add(orgFilter);
                CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "bd_project");
                parameter.setCloseCallBack(callBack);
                this.getView().showForm((FormShowParameter)parameter);
                args.setCancel(true);
                break;
            }
        }
    }

    private boolean verifyProjectOnly(DynamicObject[] outInvoices) {
        if (outInvoices != null && outInvoices.length > 1) {
            HashSet<Long> projectIds = new HashSet<Long>();
            for (DynamicObject outInvoice : outInvoices) {
                DynamicObject project = outInvoice.getDynamicObject("project");
                if (project == null) {
                    return false;
                }
                projectIds.add(project.getLong("id"));
            }
            return projectIds.size() == 1;
        }
        return false;
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if ("claim".equals(operateKey) || "unclaim".equals(operateKey) || "noncontclaim".equals(operateKey)) {
            this.getView().invokeOperation("refresh");
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        ListSelectedRowCollection rows;
        super.closedCallBack(event);
        if (event.getActionId().equals("pmct_daterange") && event.getReturnData() != null) {
            QFilter enableFilter;
            List orgIds = ((ListView)this.getView()).getSelectedMainOrgIds();
            Map map = (Map)event.getReturnData();
            Date beginDate = (Date)map.get("beginDate");
            Date endDate = (Date)map.get("endDate");
            String selectType = null;
            if (map.get("selectType") != null) {
                selectType = map.get("selectType").toString();
            }
            String appId = null;
            String appSecret = null;
            String encryptKey = null;
            String taxNo = null;
            QFilter filter = new QFilter("org", "=", orgIds.get(0));
            DynamicObject config = BusinessDataServiceHelper.loadSingle((String)"pmct_invoiceconfig", (String)"appid,appsecret,encryptkey,taxno", (QFilter[])new QFilter[]{filter, enableFilter = new QFilter("enable", "=", (Object)"1")});
            if (config != null) {
                appId = config.getString("appid");
                appSecret = config.getString("appsecret");
                encryptKey = config.getString("encryptkey");
                taxNo = config.getString("taxno");
            } else {
                config = BusinessDataServiceHelper.loadSingle((String)"er_bd_kdinvoicecloudcfg", (String)"client_id,client_secret,encrypt_key,taxregnum", (QFilter[])new QFilter[]{filter, enableFilter});
                if (config != null) {
                    appId = config.getString("client_id");
                    appSecret = config.getString("client_secret");
                    encryptKey = config.getString("encrypt_key");
                    taxNo = config.getString("taxregnum");
                }
            }
            if (config == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u6ca1\u6709\u7ef4\u62a4\u53d1\u7968\u4e91\u914d\u7f6e\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"OutInvoiceListPlugin_22", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                return;
            }
            String url = null;
            DynamicObject invoiceUrl = BusinessDataServiceHelper.loadSingle((String)"pmct_inoviceurl", (String)"url", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)"invoiceurlbillno")});
            if (invoiceUrl != null) {
                url = (String)invoiceUrl.get("url");
            } else {
                filter = new QFilter("config_key", "=", (Object)"dim_imc_config_fpy_url");
                DynamicObject urlConfig = BusinessDataServiceHelper.loadSingle((String)"invsm_param_configuration", (String)"config_value", (QFilter[])new QFilter[]{filter});
                if (urlConfig != null) {
                    url = urlConfig.getString("config_value");
                }
            }
            if (StringUtils.isEmpty((CharSequence)url)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u7ef4\u62a4\u53d1\u7968\u4e91\u6388\u6743\u914d\u7f6e\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"OutInvoiceListPlugin_23", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                return;
            }
            String resultString = InvoiceUtils.getToken((String)appId, (String)appSecret, (String)url);
            if (resultString == null || resultString.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8fde\u63a5\u53d1\u7968\u4e91\u5931\u8d25\u3002", (String)"OutInvoiceListPlugin_2", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                return;
            }
            JSONObject result = JSONObject.parseObject((String)resultString);
            if (result == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8fde\u63a5\u53d1\u7968\u4e91\u5931\u8d25\u3002", (String)"OutInvoiceListPlugin_2", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                return;
            }
            String errCode = result.getString("errcode");
            if (StringUtils.isEmpty((CharSequence)errCode) || !"0000".equals(errCode)) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u53d1\u7968\u4e91Token\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"OutInvoiceListPlugin_20", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), result.getString("description")));
                return;
            }
            String token = result.getString("access_token");
            String responseString = InvoiceUtils.queryOutInvoiceInfo((String)token, (String)encryptKey, (Date)beginDate, (Date)endDate, (String)selectType, (String)taxNo, (String)url);
            if (StringUtils.isEmpty((CharSequence)responseString)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8fde\u63a5\u53d1\u7968\u4e91\u5931\u8d25\u3002", (String)"OutInvoiceListPlugin_2", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                return;
            }
            JSONObject response = JSONObject.parseObject((String)responseString);
            String responseErrCode = response.getString("errcode");
            if (!StringUtils.isEmpty((CharSequence)responseErrCode) && !"0000".equals(responseErrCode)) {
                String description = response.getString("description");
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u9519\u8bef\u7801\uff1a%1$s\uff0c\u9519\u8bef\u4fe1\u606f\uff1a%2$s", (String)"OutInvoiceListPlugin_19", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), responseErrCode, description));
            } else {
                this.processInvoice(JSONObject.parseObject((String)responseString), (Long)orgIds.get(0));
                BillList x = (BillList)this.getView().getControl("billlistap");
                x.refresh();
            }
        } else if ("pmct_incontract".equals(event.getActionId()) && event.getReturnData() != null && (rows = (ListSelectedRowCollection)event.getReturnData()).size() > 0) {
            String contractId = rows.get(0).getPrimaryKeyValue().toString();
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("contract_id", contractId);
            this.getView().invokeOperation("claim", operateOption);
        }
    }

    private void processInvoice(JSONObject object, Long org) {
        ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> insertList = new ArrayList<DynamicObject>();
        JSONArray invoiceArray = object.getJSONArray("data");
        if (invoiceArray != null && invoiceArray.size() > 0) {
            for (int index = 0; index < invoiceArray.size(); ++index) {
                QFilter saleFilter;
                DynamicObject saler;
                QFilter buyerFilter;
                DynamicObject buyer;
                String invoiceNo;
                JSONObject invoice = invoiceArray.getJSONObject(index);
                String invoiceCode = invoice.getString("invoiceCode");
                QFilter invoiceFilter = new QFilter("invoicecode", "=", (Object)invoiceCode).and(new QFilter("invoiceno", "=", (Object)(invoiceNo = invoice.getString("invoiceNo"))));
                DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"pmct_outinvoice", (String)"invoicestatus", (QFilter[])new QFilter[]{invoiceFilter});
                if (dynamicObject != null) {
                    dynamicObject.set("invoicestatus", (Object)invoice.getString("invoiceStatus"));
                    updateList.add(dynamicObject);
                    continue;
                }
                dynamicObject = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmct_outinvoice"));
                dynamicObject.set("invoicetype", (Object)invoice.getString("invoiceType"));
                dynamicObject.set("org", (Object)org);
                Long loginOrg = RequestContext.get().getOrgId();
                long userId = Long.parseLong(RequestContext.get().getUserId());
                List userDepartment = UserServiceHelper.getUserDepartment((long)userId, (boolean)false);
                if (userDepartment.contains(loginOrg)) {
                    dynamicObject.set("createorg", (Object)loginOrg);
                } else {
                    long userMainOrgId = UserServiceHelper.getUserMainOrgId((long)userId);
                    dynamicObject.set("createorg", (Object)userMainOrgId);
                }
                CodeRuleInfo codeRuleInfo = CodeRuleServiceHelper.getCodeRule((String)"pmct_outinvoice", (DynamicObject)dynamicObject, (String)String.valueOf(RequestContext.get().getOrgId()));
                if (null != codeRuleInfo) {
                    dynamicObject.set("billno", (Object)CodeRuleServiceHelper.getNumber((CodeRuleInfo)codeRuleInfo, (DynamicObject)dynamicObject));
                } else {
                    dynamicObject.set("billno", (Object)invoice.getString("serialNo"));
                }
                dynamicObject.set("source", (Object)"01");
                dynamicObject.set("invoicecode", (Object)invoice.getString("invoiceCode"));
                dynamicObject.set("invoiceno", (Object)invoice.getString("invoiceNo"));
                dynamicObject.set("invoicedate", (Object)invoice.getDate("invoiceDate"));
                dynamicObject.set("invoicestatus", (Object)invoice.getString("invoiceStatus"));
                dynamicObject.set("totalamount", (Object)invoice.getBigDecimal("invoiceAmount"));
                dynamicObject.set("totaltax", (Object)invoice.getBigDecimal("totalTaxAmount"));
                dynamicObject.set("totaloftaxamount", (Object)invoice.getBigDecimal("totalAmount"));
                String buyerName = invoice.getString("buyerName");
                if (buyerName != null && !buyerName.isEmpty() && (buyer = BusinessDataServiceHelper.loadSingle((String)"bd_bizpartner", (String)"name", (QFilter[])new QFilter[]{buyerFilter = new QFilter("name", "=", (Object)buyerName)})) != null) {
                    dynamicObject.set("buyer", (Object)buyer);
                }
                dynamicObject.set("buyertaxno", (Object)invoice.getString("buyerTaxNo"));
                String buyerBankAccount = invoice.getString("buyerAccount");
                dynamicObject.set("buyerbank", (Object)TextHelper.getBankName((String)buyerBankAccount));
                dynamicObject.set("buyeraccount", (Object)TextHelper.getPhoneNum((String)buyerBankAccount));
                String buyerAddressPhone = invoice.getString("buyerAddressPhone");
                dynamicObject.set("buyeraddress", (Object)TextHelper.getAddress((String)buyerAddressPhone));
                dynamicObject.set("buyerphone", (Object)TextHelper.getPhoneNum((String)buyerAddressPhone));
                String saleName = invoice.getString("salerName");
                if (saleName != null && !saleName.isEmpty() && (saler = BusinessDataServiceHelper.loadSingle((String)"bos_org", (String)"name", (QFilter[])new QFilter[]{saleFilter = new QFilter("name", "=", (Object)saleName)})) != null) {
                    dynamicObject.set("seller", (Object)saler);
                }
                String salerBankAccount = invoice.getString("salerAccount");
                dynamicObject.set("sellerbank", (Object)TextHelper.getBankName((String)salerBankAccount));
                dynamicObject.set("selleraccount", (Object)TextHelper.getBankNum((String)salerBankAccount));
                String salerAddressPhone = invoice.getString("salerAddressPhone");
                dynamicObject.set("selleraddress", (Object)TextHelper.getAddress((String)salerAddressPhone));
                dynamicObject.set("sellerphone", (Object)TextHelper.getPhoneNum((String)salerAddressPhone));
                dynamicObject.set("billstatus", (Object)"C");
                dynamicObject.set("isused", (Object)false);
                dynamicObject.set("createtime", (Object)new Date());
                DynamicObjectCollection entryentitys = dynamicObject.getDynamicObjectCollection("entryentity");
                DynamicObjectCollection collection = new DynamicObjectCollection(entryentitys.getDynamicObjectType(), (Object)dynamicObject);
                JSONArray items = invoice.getJSONArray("items");
                if (items != null && items.size() > 0) {
                    for (int i = 0; i < items.size(); ++i) {
                        QFilter unitFilter;
                        DynamicObject unit;
                        JSONObject item = items.getJSONObject(i);
                        DynamicObject entry = new DynamicObject(entryentitys.getDynamicObjectType());
                        entry.set("name", (Object)item.getString("goodsName"));
                        entry.set("model", (Object)item.getString("specModel"));
                        String unitName = item.getString("unit");
                        if (unitName != null && !unitName.isEmpty() && (unit = BusinessDataServiceHelper.loadSingle((String)"bd_measureunits", (String)"name", (QFilter[])new QFilter[]{unitFilter = new QFilter("name", "=", (Object)unitName)})) != null) {
                            entry.set("unit", (Object)unit);
                        }
                        entry.set("qty", (Object)item.getBigDecimal("num"));
                        BigDecimal price = item.getBigDecimal("unitPrice");
                        entry.set("price", (Object)price);
                        BigDecimal amount = item.getBigDecimal("detailAmount");
                        entry.set("amount", (Object)amount);
                        BigDecimal tax = item.getBigDecimal("taxRate");
                        if (tax != null) {
                            QFilter taxFilter = new QFilter("taxrate", "=", (Object)tax.multiply(new BigDecimal("100")));
                            DynamicObject[] taxRate = BusinessDataServiceHelper.load((String)"bd_taxrate", (String)"name", (QFilter[])new QFilter[]{taxFilter});
                            if (taxRate != null && taxRate.length == 1) {
                                entry.set("taxrate", (Object)taxRate);
                            }
                            entry.set("taxvalue", (Object)tax.multiply(new BigDecimal("100")));
                            if (price != null) {
                                entry.set("oftaxprice", (Object)price.multiply(new BigDecimal("1").add(tax)));
                            }
                        }
                        BigDecimal taxAmount = item.getBigDecimal("taxAmount");
                        entry.set("tax", (Object)taxAmount);
                        if (amount != null && taxAmount != null) {
                            entry.set("oftaxamount", (Object)amount.add(taxAmount));
                        }
                        collection.add((Object)entry);
                    }
                }
                dynamicObject.set("entryentity", (Object)collection);
                insertList.add(dynamicObject);
            }
        }
        SaveServiceHelper.save((DynamicObject[])updateList.toArray(new DynamicObject[updateList.size()]));
        SaveServiceHelper.save((DynamicObject[])insertList.toArray(new DynamicObject[insertList.size()]));
        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4e0b\u8f7d%1$s\u6761\u6570\u636e\uff0c\u66f4\u65b0%2$s\u6761\u6570\u636e\u3002", (String)"OutInvoiceListPlugin_15", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), insertList.size(), updateList.size()));
    }

    private boolean verifyClaim(ListSelectedRowCollection selCols) {
        StringBuffer rowIndexs;
        ArrayList<Integer> rowIndexList = new ArrayList<Integer>();
        ArrayList<Integer> rowCancelIndexList = new ArrayList<Integer>();
        for (ListSelectedRow selRow : selCols) {
            Object invPk = selRow.getPrimaryKeyValue();
            DynamicObject outv = BusinessDataServiceHelper.loadSingle((Object)invPk, (String)"pmct_outinvoice", (String)"name,number,isclaimed,invoicestatus");
            boolean isClaimed = outv.getBoolean("isclaimed");
            String invoiceStatus = outv.getString("invoicestatus");
            if (isClaimed) {
                rowIndexList.add(selRow.getRowKey());
            }
            if (!OutInvoiceStatusEnum.CANCEL_6.getValue().equals(invoiceStatus)) continue;
            rowCancelIndexList.add(selRow.getRowKey());
        }
        Collections.sort(rowIndexList);
        if (rowIndexList.size() > 0) {
            rowIndexs = new StringBuffer();
            for (int i = 0; i < rowIndexList.size(); ++i) {
                rowIndexs.append((Integer)rowIndexList.get(i) + 1);
                if (i == rowIndexList.size() - 1) continue;
                rowIndexs.append("\u3001");
            }
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u53d1\u7968\u5df2\u8ba4\u9886\uff0c\u65e0\u6cd5\u518d\u6b21\u8ba4\u9886\u3002", (String)"OutInvoiceListPlugin_27", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), rowIndexs));
            return false;
        }
        Collections.sort(rowCancelIndexList);
        if (rowCancelIndexList.size() > 0) {
            rowIndexs = new StringBuffer();
            for (int i = 0; i < rowCancelIndexList.size(); ++i) {
                rowIndexs.append((Integer)rowCancelIndexList.get(i) + 1);
                if (i == rowCancelIndexList.size() - 1) continue;
                rowIndexs.append("\u3001");
            }
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u53d1\u7968\u5df2\u4f5c\u5e9f\uff0c\u65e0\u6cd5\u8fdb\u884c\u5408\u540c\u8ba4\u9886\u3002", (String)"OutInvoiceListPlugin_17", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), rowIndexs));
            return false;
        }
        return true;
    }

    private boolean verifyOrg(DynamicObject[] dynamicObjects, HashSet<Long> objects) {
        for (DynamicObject dynamicObject : dynamicObjects) {
            DynamicObject org = dynamicObject.getDynamicObject("org");
            Object pkValue = org.getPkValue();
            objects.add(Long.valueOf(pkValue.toString()));
        }
        if (objects.size() != 1) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u53d1\u7968\u4e0d\u5c5e\u4e8e\u540c\u4e00\u7ec4\u7ec7\uff0c\u4e0d\u80fd\u6279\u91cf\u8ba4\u9886\u3002", (String)"OutInvoiceListPlugin_21", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }
}

