/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.formplugin.manage;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.pmgt.pmbs.common.enums.ContractStatusEnum;
import kd.pmgt.pmbs.common.enums.PayDirectionEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmct.business.manage.MonthlyFundPlanExcelSupport;
import kd.pmgt.pmct.formplugin.base.AbstractPmctFormPlugin;
import org.jetbrains.annotations.NotNull;

public class FundPlanExcelImportPlugin
extends AbstractPmctFormPlugin
implements UploadListener {
    private static final String KEY_ATTACHMENTPANEL = "attachmentpanel";
    private static final String OPERATION_DOWNLOAD_TEMPLATE = "downloadtemplate";
    private static final String OPERATION_CONFIRM = "confirm";
    private static final String PAGE_CACHE_UPLOAD_FILE_URL = "uploadfileurl";
    private MonthlyFundPlanExcelSupport excelSupport = new MonthlyFundPlanExcelSupport();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getView().getControl(KEY_ATTACHMENTPANEL);
        attachmentPanel.addUploadListener((UploadListener)this);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "downloadtemplate": {
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("isExportData", false);
                String entryKey = this.getEntryKey();
                params.put("entryKey", entryKey);
                params.put("entitynumber", this.getView().getParentView().getEntityId());
                params.put("parentpageid", this.getView().getParentView().getPageId());
                String url = this.excelSupport.executeExportTask(params);
                this.getView().download(url);
                break;
            }
            case "confirm": {
                HashMap<String, String> params = new HashMap<String, String>();
                String url = this.getPageCache().get(PAGE_CACHE_UPLOAD_FILE_URL);
                params.put("url", url);
                String entryKey = this.getEntryKey();
                params.put("entryKey", entryKey);
                params.put("entitynumber", this.getView().getParentView().getEntityId());
                params.put("parentpageid", this.getView().getParentView().getPageId());
                params.put("appId", this.getView().getParentView().getEntityId());
                params.put("pageid", this.getView().getPageId());
                DynamicObjectCollection importDataList = this.excelSupport.executeImportTask(params);
                if (importDataList == null) {
                    this.getView().showErrorNotification(ResManager.loadKDStringExt((String)"\u5bfc\u5165\u6570\u636e\u6709\u8bef\uff0c\u8bf7\u4fee\u6539\u6570\u636e\u540e\u91cd\u65b0\u5bfc\u5165\u3002", (String)"FundPlanExcelImportPlugin_3", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (StringUtils.equals((CharSequence)"incontractplanentity", (CharSequence)entryKey)) {
                    for (DynamicObject entry : importDataList) {
                        Object pkValue = entry.getDynamicObject("incontract").getPkValue();
                        QFilter pkFilter = new QFilter("id", "=", pkValue);
                        QFilter payDirectionFilter = new QFilter("paydirection", "=", (Object)PayDirectionEnum.IN.getValue());
                        List<QFilter> contractFilter = this.getContractFilter();
                        contractFilter.add(pkFilter);
                        contractFilter.add(payDirectionFilter);
                        DynamicObject[] contracts = BusinessDataServiceHelper.load((String)"pmct_incontractf7", (String)"id", (QFilter[])contractFilter.toArray(new QFilter[0]));
                        if (contracts.length != 0) continue;
                        this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5408\u540c%s\u4e0d\u6ee1\u8db3\u88ab\u9009\u4e2d\u6761\u4ef6\uff0c\u8bf7\u4fee\u6539\u6570\u636e\u540e\u5bfc\u5165\u3002", (String)"FundPlanExcelImportPlugin_1", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), entry.getDynamicObject("incontract").getString("billno")));
                        return;
                    }
                } else if (StringUtils.equals((CharSequence)"outcontractplanentity", (CharSequence)entryKey)) {
                    for (DynamicObject entry : importDataList) {
                        Object pkValue = entry.getDynamicObject("outcontract").getPkValue();
                        QFilter pkFilter = new QFilter("id", "=", pkValue);
                        QFilter payDirectionFilter = new QFilter("paydirection", "=", (Object)PayDirectionEnum.OUT.getValue());
                        List<QFilter> contractFilter = this.getContractFilter();
                        contractFilter.add(pkFilter);
                        contractFilter.add(payDirectionFilter);
                        DynamicObject[] contracts = BusinessDataServiceHelper.load((String)"pmct_outcontractf7", (String)"id", (QFilter[])contractFilter.toArray(new QFilter[0]));
                        if (contracts.length != 0) continue;
                        this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5408\u540c%s\u4e0d\u6ee1\u8db3\u88ab\u9009\u4e2d\u6761\u4ef6\uff0c\u8bf7\u4fee\u6539\u6570\u636e\u540e\u5bfc\u5165\u3002", (String)"FundPlanExcelImportPlugin_1", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), entry.getDynamicObject("outcontract").getString("billno")));
                        return;
                    }
                }
                if (this.checkDuplicateData(importDataList)) {
                    return;
                }
                DynamicObjectType dt = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmct_monthlyfundplan")).getDynamicObjectCollection(entryKey).getDynamicObjectType();
                String returnData = DynamicObjectSerializeUtil.serialize((Object[])importDataList.toArray(), (DynamicObjectType)dt);
                this.getView().returnDataToParent((Object)returnData);
                this.getView().invokeOperation("close");
                break;
            }
        }
    }

    protected boolean checkDuplicateData(DynamicObjectCollection importDataList) {
        boolean hasDuplicateData = false;
        String entryFormId = importDataList.getDynamicObjectType().getName();
        if (StringUtils.equals((CharSequence)entryFormId, (CharSequence)"incontractplanentity")) {
            hasDuplicateData = importDataList.stream().map(entry -> entry.getDynamicObject("incontract").getPkValue().toString()).distinct().count() < (long)importDataList.size();
        } else if (StringUtils.equals((CharSequence)entryFormId, (CharSequence)"outcontractplanentity")) {
            hasDuplicateData = importDataList.stream().map(entry -> entry.getDynamicObject("outcontract").getPkValue().toString()).distinct().count() < (long)importDataList.size();
        } else if (StringUtils.equals((CharSequence)entryFormId, (CharSequence)"innoncontractplanentity")) {
            hasDuplicateData = importDataList.stream().map(entry -> entry.getString("nonincomeitem")).distinct().count() < (long)importDataList.size();
        } else if (StringUtils.equals((CharSequence)entryFormId, (CharSequence)"outnoncontractplanentity")) {
            boolean bl = hasDuplicateData = importDataList.stream().map(entry -> entry.getString("nonoutcomeitem")).distinct().count() < (long)importDataList.size();
        }
        if (hasDuplicateData) {
            this.getView().showErrorNotification(ResManager.loadKDStringExt((String)"\u5bfc\u5165\u6570\u636e\u5b58\u5728\u91cd\u590d\u7684\u5408\u540c\uff0c\u8bf7\u4fee\u6539\u6570\u636e\u540e\u5bfc\u5165\u3002", (String)"FundPlanExcelImportPlugin_2", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    protected List<QFilter> getContractFilter() {
        QFilter contStatusFilter = this.getContractStatus();
        DynamicObject[] contStatusList = BusinessDataServiceHelper.load((String)"pmct_contractstatus", (String)"id", (QFilter[])new QFilter[]{contStatusFilter});
        QFilter contractStatusFilter = new QFilter("contractstatus", "in", Arrays.stream(contStatusList).map(DataEntityBase::getPkValue).collect(Collectors.toList()));
        QFilter billStatusFilter = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(contractStatusFilter);
        filters.add(billStatusFilter);
        return filters;
    }

    protected QFilter getContractStatus() {
        return new QFilter("number", "in", Arrays.asList(ContractStatusEnum.RUNNING.getValue(), ContractStatusEnum.CLOSED.getValue()));
    }

    @NotNull
    private String getEntryKey() {
        String payDirection = (String)this.getView().getFormShowParameter().getCustomParam("payDirection");
        String billType = (String)this.getView().getFormShowParameter().getCustomParam("billType");
        String entryKey = "incontractplanentity";
        if (StringUtils.equals((CharSequence)payDirection, (CharSequence)PayDirectionEnum.IN.getValue()) && StringUtils.equals((CharSequence)billType, (CharSequence)"contract")) {
            entryKey = "incontractplanentity";
        } else if (StringUtils.equals((CharSequence)payDirection, (CharSequence)PayDirectionEnum.OUT.getValue()) && StringUtils.equals((CharSequence)billType, (CharSequence)"contract")) {
            entryKey = "outcontractplanentity";
        } else if (StringUtils.equals((CharSequence)payDirection, (CharSequence)PayDirectionEnum.IN.getValue()) && StringUtils.equals((CharSequence)billType, (CharSequence)"nonContract")) {
            entryKey = "innoncontractplanentity";
        } else if (StringUtils.equals((CharSequence)payDirection, (CharSequence)PayDirectionEnum.OUT.getValue()) && StringUtils.equals((CharSequence)billType, (CharSequence)"nonContract")) {
            entryKey = "outnoncontractplanentity";
        }
        return entryKey;
    }

    public void upload(UploadEvent evt) {
        Object[] urls = evt.getUrls();
        if (urls != null && urls.length == 1) {
            String url = (String)((Map)urls[0]).get("url");
            this.getPageCache().put(PAGE_CACHE_UPLOAD_FILE_URL, url);
        }
    }
}

