/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.formplugin.manage;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.chart.ItemValue;
import kd.bos.form.chart.PieChart;
import kd.bos.form.chart.PieSeries;
import kd.bos.form.chart.Position;
import kd.bos.form.chart.XAlign;
import kd.bos.form.chart.YAlign;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.pmgt.pmbs.common.enums.PayDirectionEnum;
import kd.pmgt.pmbs.common.utils.DetailBillUtils;
import kd.pmgt.pmct.business.manage.FundPlanPayItemService;
import kd.pmgt.pmct.business.manage.IContractFillBackService;
import kd.pmgt.pmct.business.manage.IContractFundPlanningService;
import kd.pmgt.pmct.business.manage.InContractFillBackService;
import kd.pmgt.pmct.business.manage.InContractFundPlanningService;
import kd.pmgt.pmct.business.manage.OutContractFillBackService;
import kd.pmgt.pmct.business.manage.OutContractFundPlanningService;
import kd.pmgt.pmct.formplugin.base.AbstractPmctBillPlugin;

public class FundPlanningEditPlugin
extends AbstractPmctBillPlugin
implements RowClickEventListener,
BeforeF7SelectListener {
    private static final Log logger = LogFactory.getLog(FundPlanningEditPlugin.class);
    private static final String OPERATION_AUTO_PLANNING = "autoplanning";
    private static final String OPERATION_CONFIRM = "confirm";
    private static final String OPERATION_SELECT_CONTRACT = "inselectcontract";
    private static final String OPERATION_DELETE_ENTRY = "deleteentry";
    private static final String OPERATION_OUT_DELETE_ENTRY = "outdeleteentry";
    private static final String VIEW_PIE_CHART_AP = "piechartap";
    private static final String VIEW_IN_CONTRACT_PLAN_ENTITY = "incontractplanentity";
    private static final String VIEW_OUT_CONTRACT_PLAN_ENTITY = "outcontractplanentity";
    private static final String VIEW_PAY_ITEM_TAB_AP = "payitemtabap";
    private static final String VIEW_IN_TOOL_BAR_AP = "intoolbarap";
    private static final String VIEW_OUT_TOOL_BAR_AP = "outtoolbarap";
    private static final String VIEW_INCOME_ITEM_TAB_AP = "incomeitemtabap";
    private static final String CALLBACK_SELECT_CONTRACT = "selectcontract";
    protected IContractFillBackService contractFillBackService;
    protected IContractFundPlanningService contractFundPlanningService;
    protected FundPlanPayItemService fundPlanPayItemService = new FundPlanPayItemService();
    protected int MAX_SHOW_PIE_ITEMS = 9;

    public void initialize() {
        String payDirection = (String)this.getView().getFormShowParameter().getCustomParam("paydirection");
        if (StringUtils.equals((CharSequence)payDirection, (CharSequence)PayDirectionEnum.IN.getValue())) {
            this.contractFundPlanningService = new InContractFundPlanningService();
            this.contractFillBackService = new InContractFillBackService();
        } else {
            this.contractFundPlanningService = new OutContractFundPlanningService();
            this.contractFillBackService = new OutContractFillBackService();
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid outContractPlanEntityEntry = (EntryGrid)this.getControl(VIEW_OUT_CONTRACT_PLAN_ENTITY);
        outContractPlanEntityEntry.addRowClickListener((RowClickEventListener)this);
        EntryGrid inContractPlanEntity = (EntryGrid)this.getControl(VIEW_IN_CONTRACT_PLAN_ENTITY);
        inContractPlanEntity.addRowClickListener((RowClickEventListener)this);
        this.changeContractF7ShowForm("incontract", "pmct_incontract");
        this.changeContractF7ShowForm("outcontract", "pmct_outcontract");
    }

    private void changeContractF7ShowForm(String contractFormId, String formBillId) {
        BasedataEdit contract = (BasedataEdit)this.getView().getControl(contractFormId);
        if (contract != null) {
            contract.addBeforeF7SelectListener((BeforeF7SelectListener)this);
            contract.addBeforeF7ViewDetailListener(beforeF7ViewDetailEvent -> {
                beforeF7ViewDetailEvent.setCancel(true);
                this.getView().showForm((FormShowParameter)DetailBillUtils.viewDetail((String)formBillId, (Object)beforeF7ViewDetailEvent.getPkId()));
            });
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        String stdCurrency = (String)this.getView().getFormShowParameter().getCustomParam("stdcurrency");
        String payDirection = (String)this.getView().getFormShowParameter().getCustomParam("paydirection");
        if (StringUtils.isBlank((CharSequence)stdCurrency) || StringUtils.isBlank((CharSequence)payDirection)) {
            return;
        }
        this.getModel().setValue("plancurrency", (Object)Long.parseLong(stdCurrency));
        this.getModel().setValue("stdcurrency", (Object)Long.parseLong(stdCurrency));
        this.getView().updateView("plancurrency");
        List comboItems = this.contractFundPlanningService.initStaticDimensions();
        ComboEdit dimensionComboEdit = (ComboEdit)this.getControl("dimension");
        dimensionComboEdit.setComboItems(comboItems);
        this.getModel().setValue("dimension", (Object)((ComboItem)comboItems.get(0)).getValue());
        if (StringUtils.equals((CharSequence)payDirection, (CharSequence)PayDirectionEnum.IN.getValue())) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{VIEW_IN_CONTRACT_PLAN_ENTITY, VIEW_INCOME_ITEM_TAB_AP, VIEW_IN_TOOL_BAR_AP, "incomeitemradio"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{VIEW_OUT_CONTRACT_PLAN_ENTITY, VIEW_PAY_ITEM_TAB_AP, VIEW_OUT_TOOL_BAR_AP, "radiofield2"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{VIEW_IN_CONTRACT_PLAN_ENTITY, VIEW_INCOME_ITEM_TAB_AP, VIEW_IN_TOOL_BAR_AP, "incomeitemradio"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{VIEW_OUT_CONTRACT_PLAN_ENTITY, VIEW_OUT_TOOL_BAR_AP, VIEW_PAY_ITEM_TAB_AP, "radiofield2"});
        }
        String contractsString = (String)this.getView().getFormShowParameter().getCustomParam("selectedcontract");
        if (StringUtils.isBlank((CharSequence)contractsString)) {
            return;
        }
        DynamicObjectCollection contractPlanEntries = this.contractFillBackService.fillFundPlanData2BillEntry(this.getView(), this.getModel(), contractsString);
        this.getModel().updateEntryCache(contractPlanEntries);
        this.getView().updateView(VIEW_IN_CONTRACT_PLAN_ENTITY);
        JSONObject orgJson = (JSONObject)this.getView().getFormShowParameter().getCustomParam("org");
        JSONObject projectJson = (JSONObject)this.getView().getFormShowParameter().getCustomParam("project");
        if (orgJson != null) {
            Object orgPk = orgJson.get((Object)"id");
            this.getModel().setValue("org", orgPk);
        }
        if (projectJson != null) {
            Object projectPk = projectJson.get((Object)"id");
            this.getModel().setValue("project", projectPk);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initFieldCaption();
        BigDecimal periodPlanAmt = this.contractFundPlanningService.calculatePeriodPlanAmt(this.getModel());
        this.getModel().setValue("periodplanamt", (Object)periodPlanAmt);
        this.getView().updateView("periodplanamt");
        this.drawChart();
    }

    protected void initFieldCaption() {
        String payDirection = (String)this.getView().getFormShowParameter().getCustomParam("paydirection");
        if (StringUtils.equals((CharSequence)payDirection, (CharSequence)PayDirectionEnum.IN.getValue())) {
            ((FieldEdit)this.getView().getControl("distributedamt")).setCaption(new LocaleString(ResManager.loadKDString((String)"\u6536\u5165\uff08\u5f85\u5206\u914d\uff09\u76ee\u6807", (String)"FundPlanningEditPlugin_6", (String)"pmgt-pmct-formplugin", (Object[])new Object[0])));
            ((FieldEdit)this.getView().getControl("radiofield")).setCaption(new LocaleString(ResManager.loadKDString((String)"\u6309\u5f00\u7968\u672a\u6536", (String)"FundPlanningEditPlugin_7", (String)"pmgt-pmct-formplugin", (Object[])new Object[0])));
            ((FieldEdit)this.getView().getControl("radiofield1")).setCaption(new LocaleString(ResManager.loadKDString((String)"\u6309\u7ed3\u7b97\u672a\u6536", (String)"FundPlanningEditPlugin_8", (String)"pmgt-pmct-formplugin", (Object[])new Object[0])));
        } else {
            ((FieldEdit)this.getView().getControl("distributedamt")).setCaption(new LocaleString(ResManager.loadKDString((String)"\u652f\u51fa\uff08\u5f85\u5206\u914d\uff09\u76ee\u6807", (String)"FundPlanningEditPlugin_9", (String)"pmgt-pmct-formplugin", (Object[])new Object[0])));
            ((FieldEdit)this.getView().getControl("radiofield")).setCaption(new LocaleString(ResManager.loadKDString((String)"\u6309\u6536\u7968\u672a\u4ed8", (String)"FundPlanningEditPlugin_10", (String)"pmgt-pmct-formplugin", (Object[])new Object[0])));
            ((FieldEdit)this.getView().getControl("radiofield1")).setCaption(new LocaleString(ResManager.loadKDString((String)"\u6309\u7ed3\u7b97\u672a\u4ed8", (String)"FundPlanningEditPlugin_11", (String)"pmgt-pmct-formplugin", (Object[])new Object[0])));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "autoplanning": {
                boolean preConditionOk;
                int[] selectRows;
                String payDirection = (String)this.getView().getFormShowParameter().getCustomParam("paydirection");
                BigDecimal distributedAmt = (BigDecimal)this.getModel().getValue("distributedamt");
                String msg = StringUtils.equals((CharSequence)PayDirectionEnum.IN.getValue(), (CharSequence)payDirection) ? ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6536\u5165\uff08\u5f85\u5206\u914d\uff09\u76ee\u6807\u3002", (String)"FundPlanningEditPlugin_15", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u8bf7\u5148\u8f93\u5165\u652f\u51fa\uff08\u5f85\u5206\u914d\uff09\u76ee\u6807\u3002", (String)"FundPlanningEditPlugin_0", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]);
                if (distributedAmt.compareTo(BigDecimal.ZERO) <= 0) {
                    this.getView().showTipNotification(msg);
                    return;
                }
                if (StringUtils.equals((CharSequence)PayDirectionEnum.IN.getValue(), (CharSequence)payDirection)) {
                    selectRows = ((EntryGrid)this.getControl(VIEW_IN_CONTRACT_PLAN_ENTITY)).getSelectRows();
                    preConditionOk = this.checkInPlanningPreCondition(selectRows);
                } else {
                    selectRows = ((EntryGrid)this.getControl(VIEW_OUT_CONTRACT_PLAN_ENTITY)).getSelectRows();
                    preConditionOk = this.checkOutPlanningPreCondition(selectRows);
                }
                if (!preConditionOk) {
                    return;
                }
                this.contractFundPlanningService.doFundPlanning(distributedAmt, selectRows, this.getModel());
                for (int selectRow : selectRows) {
                    if (StringUtils.equals((CharSequence)PayDirectionEnum.IN.getValue(), (CharSequence)payDirection)) {
                        this.getView().updateView("inperiodplanamt", selectRow);
                        this.getView().updateView("inperiodplanamtstd", selectRow);
                        continue;
                    }
                    this.getView().updateView("outperiodplanamt", selectRow);
                    this.getView().updateView("outperiodplanamtstd", selectRow);
                }
                this.getModel().setValue("periodplanamt", (Object)this.contractFundPlanningService.calculatePeriodPlanAmt(this.getModel()));
                this.getView().updateView("periodplanamt");
                this.drawChart();
                break;
            }
            case "inselectcontract": {
                ListShowParameter listShowParameter = this.contractFundPlanningService.showContractListView(this.getView(), this.getModel(), new CloseCallBack((IFormPlugin)this, CALLBACK_SELECT_CONTRACT));
                this.getView().showForm((FormShowParameter)listShowParameter);
                break;
            }
            case "confirm": {
                String returnData = this.contractFundPlanningService.getReturnData(this.getModel());
                this.getView().returnDataToParent((Object)returnData);
                this.getView().invokeOperation("close");
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey;
        super.afterDoOperation(afterDoOperationEventArgs);
        switch (operateKey = afterDoOperationEventArgs.getOperateKey()) {
            case "deleteentry": 
            case "outdeleteentry": {
                BigDecimal periodPlanAmt = this.contractFundPlanningService.calculatePeriodPlanAmt(this.getModel());
                this.getModel().setValue("periodplanamt", (Object)periodPlanAmt);
                this.getView().updateView("periodplanamt");
                this.drawChart();
                this.getModel().deleteEntryData("payitementry");
                break;
            }
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        String sourceKey;
        int clickRowIndex = evt.getRow();
        Control source = (Control)evt.getSource();
        switch (sourceKey = source.getKey()) {
            case "incontractplanentity": {
                if (clickRowIndex < 0) break;
                this.getModel().deleteEntryData("subincomeitementity");
                DynamicObjectCollection inContractPlanEntities = this.getModel().getDataEntity(true).getDynamicObjectCollection(VIEW_IN_CONTRACT_PLAN_ENTITY);
                DynamicObject clickRowObject = (DynamicObject)inContractPlanEntities.get(clickRowIndex);
                DynamicObjectCollection incomeItemEntryEntity = this.getModel().getEntryEntity("subincomeitementity");
                this.fundPlanPayItemService.loadIncomeItemEntry(clickRowObject.getDynamicObject("incontract"), incomeItemEntryEntity);
                this.getModel().updateEntryCache(inContractPlanEntities);
                this.getView().updateView("subincomeitementity");
                break;
            }
            case "outcontractplanentity": {
                if (clickRowIndex < 0) break;
                this.getModel().deleteEntryData("payitementry");
                DynamicObjectCollection outContractPlanEntities = this.getModel().getDataEntity(true).getDynamicObjectCollection(VIEW_OUT_CONTRACT_PLAN_ENTITY);
                DynamicObject clickRowObject = (DynamicObject)outContractPlanEntities.get(clickRowIndex);
                DynamicObjectCollection payItemEntryEntity = this.getModel().getEntryEntity("payitementry");
                this.fundPlanPayItemService.loadPayItemEntry(clickRowObject.getDynamicObject("outcontract"), payItemEntryEntity);
                this.getModel().updateEntryCache(outContractPlanEntities);
                this.getView().updateView("payitementry");
                break;
            }
        }
    }

    private boolean checkInPlanningPreCondition(int[] selectRows) {
        if (selectRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u52fe\u9009\u81f3\u5c11\u4e00\u6761\u5206\u5f55\u884c\u3002", (String)"FundPlanningEditPlugin_1", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
            return false;
        }
        boolean sameCurrency = false;
        for (int selectRow : selectRows) {
            DynamicObject rowEntity = this.getModel().getEntryRowEntity(VIEW_IN_CONTRACT_PLAN_ENTITY, selectRow);
            DynamicObject planCurrency = (DynamicObject)this.getModel().getValue("plancurrency");
            sameCurrency = StringUtils.equals((CharSequence)rowEntity.getDynamicObject("incurrency").getPkValue().toString(), (CharSequence)planCurrency.getPkValue().toString());
            if (!sameCurrency) break;
        }
        if (!sameCurrency) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e0e\u8ba1\u5212\u5e01\u79cd\u76f8\u540c\u7684\u5408\u540c\u7b7e\u7ea6\u5e01\u79cd\u3002", (String)"FundPlanningEditPlugin_16", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean checkOutPlanningPreCondition(int[] selectRows) {
        if (selectRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u52fe\u9009\u81f3\u5c11\u4e00\u6761\u5206\u5f55\u884c\u3002", (String)"FundPlanningEditPlugin_1", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
            return false;
        }
        boolean sameCurrency = false;
        for (int selectRow : selectRows) {
            DynamicObject rowEntity = this.getModel().getEntryRowEntity(VIEW_OUT_CONTRACT_PLAN_ENTITY, selectRow);
            DynamicObject planCurrency = (DynamicObject)this.getModel().getValue("plancurrency");
            sameCurrency = StringUtils.equals((CharSequence)rowEntity.getDynamicObject("outcurrency").getPkValue().toString(), (CharSequence)planCurrency.getPkValue().toString());
            if (!sameCurrency) break;
        }
        if (!sameCurrency) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e0e\u8ba1\u5212\u5e01\u79cd\u76f8\u540c\u7684\u5408\u540c\u7b7e\u7ea6\u5e01\u79cd\u3002", (String)"FundPlanningEditPlugin_16", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean drawChart() {
        String entryProp = this.contractFundPlanningService.dimension2EntryProp(this.getModel());
        this.getView().updateView("dimension");
        if (StringUtils.isBlank((CharSequence)entryProp)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5c5e\u6027\u5b58\u5728\u6ca1\u6709\u6570\u636e\u7684\u5206\u5f55\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"FundPlanningEditPlugin_5", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            return false;
        }
        List itemValues = this.contractFundPlanningService.getChartData(this.getModel(), entryProp);
        PieChart pieChart = (PieChart)this.getControl(VIEW_PIE_CHART_AP);
        pieChart.clearData();
        HashMap<String, String> titleMap = new HashMap<String, String>();
        titleMap.put("color", "#999999");
        pieChart.setTitlePropValue("textStyle", titleMap);
        pieChart.setTitlePropValue("x", (Object)"center");
        pieChart.setTitlePropValue("y", (Object)"bottom");
        pieChart.setMargin(Position.bottom, "50");
        PieSeries series = pieChart.createPieSeries(ResManager.loadKDString((String)"\u672c\u671f\u8ba1\u5212\u91d1\u989d\uff08\u672c\u4f4d\u5e01\uff09", (String)"FundPlanningEditPlugin_3", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
        ItemValue otherItem = new ItemValue(ResManager.loadKDString((String)"\u5176\u4ed6", (String)"FundPlanningEditPlugin_4", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), (Number)BigDecimal.ZERO);
        for (int i = 0; i < itemValues.size(); ++i) {
            if (i > this.MAX_SHOW_PIE_ITEMS - 1) {
                otherItem.setValue((Number)(otherItem.getValue().doubleValue() + ((ItemValue)itemValues.get(i)).getValue().doubleValue()));
                continue;
            }
            series.addData((ItemValue)itemValues.get(i));
        }
        if (otherItem.getValue().doubleValue() != 0.0) {
            series.addData(otherItem);
        }
        series.setRadius("50%", "70%");
        Map titleData = pieChart.getTitleData();
        String title = this.getChartTitle();
        titleData.put("text", title);
        titleData.put("x", "center");
        titleData.put("y", "center");
        pieChart.setShowTooltip(true);
        pieChart.setLegendAlign(XAlign.right, YAlign.center);
        pieChart.setLegendPropValue("x", (Object)"75%");
        pieChart.bindData(null);
        return true;
    }

    protected String getChartTitle() {
        BigDecimal periodPlanAmt = (BigDecimal)this.getModel().getValue("periodplanamt");
        DynamicObject currency = (DynamicObject)this.getModel().getValue("stdcurrency");
        int amtPrecision = currency.getInt("amtprecision");
        double amountDouble = periodPlanAmt.doubleValue();
        String precisionMark = "";
        for (int i = 1; i < amtPrecision; ++i) {
            precisionMark = String.format("%s%s", precisionMark, "#");
        }
        DecimalFormat amountFormat = new DecimalFormat(String.format("%s%s", "#.", precisionMark));
        DecimalFormat bigAmountFormat = new DecimalFormat("#.00");
        String amountStr = amountDouble > 0.0 && amountDouble < 1000000.0 ? amountFormat.format(amountDouble) : (amountDouble >= 1000000.0 ? String.format(ResManager.loadKDString((String)"%s\u4e07", (String)"FundPlanningEditPlugin_14", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), bigAmountFormat.format(amountDouble / 10000.0)) : "0");
        return String.format("%s%s", currency.getString("sign"), amountStr);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        Object oldValue = e.getChangeSet()[0].getOldValue();
        switch (name) {
            case "inperiodplanamtstd": 
            case "outperiodplanamtstd": {
                BigDecimal periodPlanAmt = this.contractFundPlanningService.calculatePeriodPlanAmt(this.getModel());
                this.getModel().setValue("periodplanamt", (Object)periodPlanAmt);
                this.getView().updateView("periodplanamt");
                this.drawChart();
                break;
            }
            case "dimension": {
                boolean succeed = this.drawChart();
                if (succeed) break;
                this.getModel().setValue("dimension", oldValue);
                this.getView().updateView("dimension");
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (actionId.equals(CALLBACK_SELECT_CONTRACT)) {
            ListSelectedRowCollection selectedRows = (ListSelectedRowCollection)returnData;
            if (selectedRows == null) {
                return;
            }
            EntryGrid entryGrid = this.contractFillBackService instanceof InContractFillBackService ? (EntryGrid)this.getControl(VIEW_IN_CONTRACT_PLAN_ENTITY) : (EntryGrid)this.getControl(VIEW_OUT_CONTRACT_PLAN_ENTITY);
            int[] selectRows = entryGrid.getSelectRows();
            DynamicObjectCollection contractPlanEntries = this.contractFillBackService.fillBillEntryByContractF7(this.getView(), this.getModel(), selectedRows);
            this.getModel().updateEntryCache(contractPlanEntries);
            this.contractFillBackService.updateView(this.getView());
            if (selectRows.length != 0) {
                entryGrid.selectRows(selectRows, selectRows[0]);
            }
            this.drawChart();
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
    }
}

