/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.formplugin.manage;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.pmgt.pmbs.common.enums.PayDirectionEnum;
import kd.pmgt.pmbs.common.utils.DetailBillUtils;
import kd.pmgt.pmbs.common.utils.EcPeriodUtils;
import kd.pmgt.pmct.business.manage.IContractFillBackService;
import kd.pmgt.pmct.business.manage.IContractFundPlanningService;
import kd.pmgt.pmct.business.manage.INonContractFundPlanningService;
import kd.pmgt.pmct.business.manage.InContractFillBackService;
import kd.pmgt.pmct.business.manage.InContractFundPlanningService;
import kd.pmgt.pmct.business.manage.InNonContractFundPlanningService;
import kd.pmgt.pmct.business.manage.MonthlyFundPlanEditService;
import kd.pmgt.pmct.business.manage.MonthlyFundPlanExcelSupport;
import kd.pmgt.pmct.business.manage.OutContractFillBackService;
import kd.pmgt.pmct.business.manage.OutContractFundPlanningService;
import kd.pmgt.pmct.business.manage.OutNonContractFundPlanningService;
import kd.pmgt.pmct.formplugin.base.AbstractPmctBillPlugin;
import org.jetbrains.annotations.NotNull;

public class MonthlyFundPlanEditPlugin
extends AbstractPmctBillPlugin
implements RowClickEventListener,
BeforeF7SelectListener {
    private static final String OPERATION_IN_FUND_PLANING = "infundplaning";
    private static final String OPERATION_OUT_FUND_PLANING = "outfundplaning";
    private static final String OPERATION_IN_SELECT_CONTRACT = "inselectcontract";
    private static final String OPERATION_OUT_SELECT_CONTRACT = "outselectcontract";
    private static final String OPERATION_SAVE = "save";
    private static final String OPERATION_SUBMIT = "submit";
    private static final String OPERATION_UN_SUBMIT = "unsubmit";
    private static final String OPERATION_UN_AUDIT = "unaudit";
    private static final String OPERATION_IN_IMPORT_EXCEL = "inimportentry";
    private static final String OPERATION_IN_EXPORT_EXCEL = "inexportentry";
    private static final String OPERATION_OUT_IMPORT_EXCEL = "outimportentry";
    private static final String OPERATION_OUT_EXPORT_EXCEL = "outexportentry";
    private static final String OPERATION_IN_NON_IMPORT_EXCEL = "innonimportdata";
    private static final String OPERATION_IN_NON_EXPORT_EXCEL = "innonexportdata";
    private static final String OPERATION_OUT_NON_IMPORT_EXCEL = "outnonimportdata";
    private static final String OPERATION_OUT_NON_EXPORT_EXCEL = "outnonexportdata";
    private static final String OPERATION_IN_NON_NEW_ENTRY = "innonnewentry";
    private static final String OPERATION_OUT_NON_NEW_ENTRY = "outnonnewentry";
    private static final String OPERATION_IN_CONTRACT_DELETE_ENTRY = "incontractdeleteentry";
    private static final String OPERATION_OUT_CONTRACT_DELETE_ENTRY = "outcontractdeleteentry";
    private static final String OPERATION_IN_NON_DELETE_ENTRY = "innondeleteentry";
    private static final String OPERATION_OUT_NON_DELETE_ENTRY = "outnondeleteentry";
    private static final String CALLBACK_IN_SELECT_CONTRACT = "inselectcontract";
    private static final String CALLBACK_OUT_SELECT_CONTRACT = "outselectcontract";
    private static final String CALLBACK_IN_PLAN_PLANNING = "inplanplanning";
    private static final String CALLBACK_OUT_PLAN_PLANNING = "outplanplanning";
    private static final String CALLBACK_IMPORT_IN_CONTRACT_PLAN_ENTRY = "inimportincontractplanentry";
    private static final String CALLBACK_IMPORT_OUT_CONTRACT_PLAN_ENTRY = "outimportincontractplanentry";
    private static final String CALLBACK_IMPORT_IN_NON_CONTRACT_PLAN_ENTRY = "innonimportincontractplanentry";
    private static final String CALLBACK_IMPORT_OUT_NON_CONTRACT_PLAN_ENTRY = "outnonimportincontractplanentry";
    private static final String CALLBACK_PROJECT_CHANGED = "projectchanged";
    private static final String CALLBACK_PERIOD_CHANGED = "periodchanged";
    private static final String CALLBACK_SAVE_CREATE_NEW = "savecreatenew";
    private static final String CALLBACK_SUBMIT_CREATE_NEW = "submitcreatenew";
    private static final String CTRL_IN_CONTRACT_PLAN_ENTITY = "incontractplanentity";
    private static final String CTRL_OUT_CONTRACT_PLAN_ENTITY = "outcontractplanentity";
    private static final String PAGE_CACHE_NEED_CHECK_PERIOD_AND_ORG = "checkperiodandorg";
    private static final List<String> OPERATIONS_NEED_CHECK_PERIOD = Arrays.asList("save", "submit");
    private IContractFillBackService contractFillBackService;
    private IContractFundPlanningService contractFundPlanningService;
    private INonContractFundPlanningService nonContractFundPlanningService;
    private MonthlyFundPlanEditService monthlyFundPlanEditService = new MonthlyFundPlanEditService();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid outPlanEntityGrid = (EntryGrid)this.getControl(CTRL_OUT_CONTRACT_PLAN_ENTITY);
        outPlanEntityGrid.addRowClickListener((RowClickEventListener)this);
        EntryGrid inPlanEntityGrid = (EntryGrid)this.getControl(CTRL_IN_CONTRACT_PLAN_ENTITY);
        inPlanEntityGrid.addRowClickListener((RowClickEventListener)this);
        this.changeContractF7ShowForm("incontract", "pmct_incontract");
        this.changeContractF7ShowForm("outcontract", "pmct_outcontract");
    }

    private void changeContractF7ShowForm(String contractFormId, String formBillId) {
        BasedataEdit inContract = (BasedataEdit)this.getView().getControl(contractFormId);
        if (inContract != null) {
            inContract.addBeforeF7SelectListener((BeforeF7SelectListener)this);
            inContract.addBeforeF7ViewDetailListener(beforeF7ViewDetailEvent -> {
                beforeF7ViewDetailEvent.setCancel(true);
                this.getView().showForm((FormShowParameter)DetailBillUtils.viewDetail((String)formBillId, (Object)beforeF7ViewDetailEvent.getPkId()));
            });
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Object billPeriod = this.getModel().getValue("period");
        if (billPeriod == null) {
            DynamicObject currentPeriod = EcPeriodUtils.getCurrentPeriod();
            this.getModel().setValue("period", (Object)currentPeriod);
            this.getView().updateView("period");
        }
        this.getModel().setDataChanged(false);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        Object period = this.getModel().getValue("period");
        if (period == null && OPERATIONS_NEED_CHECK_PERIOD.contains(operateKey)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u671f\u95f4\u3002", (String)"MonthlyFundPlanEditPlugin_11", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            return;
        }
        switch (operateKey) {
            case "infundplaning": {
                FormShowParameter formShowParameter = this.showFundPlanningView(CTRL_IN_CONTRACT_PLAN_ENTITY, PayDirectionEnum.IN, CALLBACK_IN_PLAN_PLANNING);
                this.getView().showForm(formShowParameter);
                break;
            }
            case "outfundplaning": {
                this.getModel().deleteEntryData("payitementry");
                FormShowParameter formShowParameter = this.showFundPlanningView(CTRL_OUT_CONTRACT_PLAN_ENTITY, PayDirectionEnum.OUT, CALLBACK_OUT_PLAN_PLANNING);
                this.getView().showForm(formShowParameter);
                break;
            }
            case "inselectcontract": {
                this.contractFundPlanningService = new InContractFundPlanningService();
                ListShowParameter listShowParameter = this.contractFundPlanningService.showContractListView(this.getView(), this.getModel(), new CloseCallBack((IFormPlugin)this, "inselectcontract"));
                this.getView().showForm((FormShowParameter)listShowParameter);
                break;
            }
            case "outselectcontract": {
                this.contractFundPlanningService = new OutContractFundPlanningService();
                ListShowParameter listShowParameter = this.contractFundPlanningService.showContractListView(this.getView(), this.getModel(), new CloseCallBack((IFormPlugin)this, "outselectcontract"));
                this.getView().showForm((FormShowParameter)listShowParameter);
                break;
            }
            case "inimportentry": {
                FormShowParameter importExcelFormParameter = new FormShowParameter();
                importExcelFormParameter.setFormId("pmct_fundplanentryimport");
                importExcelFormParameter.getOpenStyle().setShowType(ShowType.Modal);
                importExcelFormParameter.setCustomParam("payDirection", (Object)PayDirectionEnum.IN.getValue());
                importExcelFormParameter.setCustomParam("billType", (Object)"contract");
                importExcelFormParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALLBACK_IMPORT_IN_CONTRACT_PLAN_ENTRY));
                this.getView().showForm(importExcelFormParameter);
                break;
            }
            case "outimportentry": {
                FormShowParameter importExcelFormParameter = new FormShowParameter();
                importExcelFormParameter.setFormId("pmct_fundplanentryimport");
                importExcelFormParameter.setCustomParam("payDirection", (Object)PayDirectionEnum.OUT.getValue());
                importExcelFormParameter.setCustomParam("billType", (Object)"contract");
                importExcelFormParameter.getOpenStyle().setShowType(ShowType.Modal);
                importExcelFormParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALLBACK_IMPORT_OUT_CONTRACT_PLAN_ENTRY));
                this.getView().showForm(importExcelFormParameter);
                break;
            }
            case "innonimportdata": {
                FormShowParameter importExcelFormParameter = new FormShowParameter();
                importExcelFormParameter.setFormId("pmct_fundplanentryimport");
                importExcelFormParameter.setCustomParam("payDirection", (Object)PayDirectionEnum.IN.getValue());
                importExcelFormParameter.setCustomParam("billType", (Object)"nonContract");
                importExcelFormParameter.getOpenStyle().setShowType(ShowType.Modal);
                importExcelFormParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALLBACK_IMPORT_IN_NON_CONTRACT_PLAN_ENTRY));
                this.getView().showForm(importExcelFormParameter);
                break;
            }
            case "outnonimportdata": {
                FormShowParameter importExcelFormParameter = new FormShowParameter();
                importExcelFormParameter.setFormId("pmct_fundplanentryimport");
                importExcelFormParameter.setCustomParam("payDirection", (Object)PayDirectionEnum.OUT.getValue());
                importExcelFormParameter.setCustomParam("billType", (Object)"nonContract");
                importExcelFormParameter.getOpenStyle().setShowType(ShowType.Modal);
                importExcelFormParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALLBACK_IMPORT_OUT_NON_CONTRACT_PLAN_ENTRY));
                this.getView().showForm(importExcelFormParameter);
                break;
            }
            case "inexportentry": {
                MonthlyFundPlanExcelSupport monthlyFundPlanExcelSupport = new MonthlyFundPlanExcelSupport();
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("parentpageid", this.getView().getPageId());
                params.put("isExportData", true);
                params.put("entitynumber", "pmct_monthlyfundplan");
                params.put("entryKey", CTRL_IN_CONTRACT_PLAN_ENTITY);
                String url = monthlyFundPlanExcelSupport.executeExportTask(params);
                this.getView().download(url);
                break;
            }
            case "outexportentry": {
                MonthlyFundPlanExcelSupport monthlyFundPlanExcelSupport = new MonthlyFundPlanExcelSupport();
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("parentpageid", this.getView().getPageId());
                params.put("isExportData", true);
                params.put("entitynumber", "pmct_monthlyfundplan");
                params.put("entryKey", CTRL_OUT_CONTRACT_PLAN_ENTITY);
                String url = monthlyFundPlanExcelSupport.executeExportTask(params);
                this.getView().download(url);
                break;
            }
            case "innonexportdata": {
                MonthlyFundPlanExcelSupport monthlyFundPlanExcelSupport = new MonthlyFundPlanExcelSupport();
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("parentpageid", this.getView().getPageId());
                params.put("isExportData", true);
                params.put("entitynumber", "pmct_monthlyfundplan");
                params.put("entryKey", "innoncontractplanentity");
                String url = monthlyFundPlanExcelSupport.executeExportTask(params);
                this.getView().download(url);
                break;
            }
            case "outnonexportdata": {
                MonthlyFundPlanExcelSupport monthlyFundPlanExcelSupport = new MonthlyFundPlanExcelSupport();
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("parentpageid", this.getView().getPageId());
                params.put("isExportData", true);
                params.put("entitynumber", "pmct_monthlyfundplan");
                params.put("entryKey", "outnoncontractplanentity");
                String url = monthlyFundPlanExcelSupport.executeExportTask(params);
                this.getView().download(url);
                break;
            }
            case "save": {
                this.beforeSaveAndSubmit(args, (DynamicObject)period, CALLBACK_SAVE_CREATE_NEW);
                break;
            }
            case "submit": {
                this.beforeSaveAndSubmit(args, (DynamicObject)period, CALLBACK_SUBMIT_CREATE_NEW);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        switch (operateKey = args.getOperateKey()) {
            case "innonnewentry": {
                int currentRowIndex = this.getModel().getEntryCurrentRowIndex("innoncontractplanentity");
                this.nonContractFundPlanningService = new InNonContractFundPlanningService();
                this.nonContractFundPlanningService.setDefaultExchangeFields(this.getModel());
                this.getView().updateView("innoncurrency", currentRowIndex);
                this.getView().updateView("noninexratetable", currentRowIndex);
                this.getView().updateView("noninexchangedate", currentRowIndex);
                break;
            }
            case "outnonnewentry": {
                int currentRowIndex = this.getModel().getEntryCurrentRowIndex("outnoncontractplanentity");
                this.nonContractFundPlanningService = new OutNonContractFundPlanningService();
                this.nonContractFundPlanningService.setDefaultExchangeFields(this.getModel());
                this.getView().updateView("outnoncurrency", currentRowIndex);
                this.getView().updateView("nonoutexratetable", currentRowIndex);
                this.getView().updateView("nonoutexchangedate", currentRowIndex);
                break;
            }
            case "outcontractdeleteentry": {
                this.contractFundPlanningService = new OutContractFundPlanningService();
                BigDecimal totalPeriodPlanAmt = this.contractFundPlanningService.calculatePeriodPlanAmt(this.getModel());
                BigDecimal nonContractTotalPeriodPlanAmt = this.contractFundPlanningService.calculateNonContractPeriodPlanAmt(this.getModel());
                this.getModel().setValue("periodplanoutcome", (Object)totalPeriodPlanAmt.add(nonContractTotalPeriodPlanAmt));
                this.getView().updateView("periodplanoutcome");
                this.getModel().deleteEntryData("payitementry");
                break;
            }
            case "outnondeleteentry": {
                this.contractFundPlanningService = new OutContractFundPlanningService();
                BigDecimal totalPeriodPlanAmt = this.contractFundPlanningService.calculatePeriodPlanAmt(this.getModel());
                BigDecimal nonContractTotalPeriodPlanAmt = this.contractFundPlanningService.calculateNonContractPeriodPlanAmt(this.getModel());
                this.getModel().setValue("periodplanoutcome", (Object)totalPeriodPlanAmt.add(nonContractTotalPeriodPlanAmt));
                this.getView().updateView("periodplanoutcome");
                break;
            }
            case "incontractdeleteentry": 
            case "innondeleteentry": {
                this.contractFundPlanningService = new InContractFundPlanningService();
                BigDecimal totalPeriodPlanAmt = this.contractFundPlanningService.calculatePeriodPlanAmt(this.getModel());
                BigDecimal nonContractTotalPeriodPlanAmt = this.contractFundPlanningService.calculateNonContractPeriodPlanAmt(this.getModel());
                this.getModel().setValue("periodplanincome", (Object)totalPeriodPlanAmt.add(nonContractTotalPeriodPlanAmt));
                this.getView().updateView("periodplanincome");
                break;
            }
            case "unsubmit": 
            case "unaudit": {
                this.getView().getPageCache().put(PAGE_CACHE_NEED_CHECK_PERIOD_AND_ORG, "true");
                break;
            }
        }
    }

    private void beforeSaveAndSubmit(BeforeDoOperationEventArgs args, DynamicObject period, String callbackSymbol) {
        boolean hasSame;
        String needCheck = this.getView().getPageCache().get(PAGE_CACHE_NEED_CHECK_PERIOD_AND_ORG);
        String billId = this.getModel().getValue("id").toString();
        if (StringUtils.equals((CharSequence)needCheck, (CharSequence)"false")) {
            return;
        }
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        DynamicObject[] sameOrgAndPeriodBills = this.monthlyFundPlanEditService.getSameOrgAndPeriodBill(org, period);
        if (sameOrgAndPeriodBills.length > 0 && (hasSame = Arrays.stream(sameOrgAndPeriodBills).anyMatch(bill -> !StringUtils.equals((CharSequence)bill.getPkValue().toString(), (CharSequence)billId)))) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u672c\u7ec4\u7ec7\u5f53\u6708\u5df2\u7f16\u5236\u8d44\u91d1\u8ba1\u5212\uff0c\u662f\u5426\u9700\u8981\u91cd\u65b0\u7f16\u5236\uff1f\uff08\u4ee5\u65b0\u8ba1\u5212\u4e3a\u51c6\u3002\uff09", (String)"MonthlyFundPlanEditPlugin_12", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(callbackSymbol, (IFormPlugin)this));
            args.setCancel(true);
        }
    }

    @NotNull
    private FormShowParameter showFundPlanningView(String entryFormId, PayDirectionEnum payDirection, String callbackId) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("pmct_fundplanning");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        StyleCss css = new StyleCss();
        css.setHeight("800px");
        css.setWidth("1500px");
        formShowParameter.getOpenStyle().setInlineStyleCss(css);
        DynamicObjectType dt = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmct_monthlyfundplan")).getDynamicObjectCollection(entryFormId).getDynamicObjectType();
        DynamicObjectCollection entryContract = this.getModel().getEntryEntity(entryFormId);
        formShowParameter.setCustomParam("selectedcontract", (Object)DynamicObjectSerializeUtil.serialize((Object[])entryContract.toArray(), (DynamicObjectType)dt));
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        formShowParameter.setCustomParam("stdcurrency", (Object)currency.getPkValue().toString());
        formShowParameter.setCustomParam("paydirection", (Object)payDirection.getValue());
        formShowParameter.setCustomParam("org", this.getModel().getValue("org"));
        formShowParameter.setCustomParam("project", this.getModel().getValue("project"));
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, callbackId));
        return formShowParameter;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        Object oldValue = e.getChangeSet()[0].getOldValue();
        switch (name) {
            case "period": {
                boolean allEntityIsEmpty = this.checkAllEntityData();
                if (!allEntityIsEmpty) break;
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u671f\u95f4\u5c06\u6e05\u7a7a\u6536\u5165\u9879\u8ba1\u5212\u548c\u652f\u4ed8\u9879\u8ba1\u5212\uff0c\u662f\u5426\u786e\u8ba4\u5207\u6362\uff1f", (String)"MonthlyFundPlanEditPlugin_13", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(CALLBACK_PERIOD_CHANGED));
                break;
            }
            case "project": {
                boolean allEntityIsEmpty = this.checkAllEntityData();
                if (!allEntityIsEmpty) break;
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u9879\u76ee\u5c06\u6e05\u7a7a\u6536\u5165\u9879\u8ba1\u5212\u548c\u652f\u4ed8\u9879\u8ba1\u5212\uff0c\u662f\u5426\u786e\u8ba4\u5207\u6362\uff1f", (String)"MonthlyFundPlanEditPlugin_14", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(CALLBACK_PROJECT_CHANGED));
                break;
            }
            case "inperiodplanamtstd": {
                this.contractFundPlanningService = new InContractFundPlanningService();
                BigDecimal totalPeriodPlanAmt = this.contractFundPlanningService.calculatePeriodPlanAmt(this.getModel());
                BigDecimal nonContractTotalPeriodPlanAmt = this.contractFundPlanningService.calculateNonContractPeriodPlanAmt(this.getModel());
                this.getModel().setValue("periodplanincome", (Object)totalPeriodPlanAmt.add(nonContractTotalPeriodPlanAmt));
                this.getView().updateView("periodplanincome");
                break;
            }
            case "noninperiodplanamtstd": {
                boolean flag;
                int curIndex = this.getModel().getEntryCurrentRowIndex("innoncontractplanentity");
                DynamicObject rowEntity = this.getModel().getEntryRowEntity("innoncontractplanentity", curIndex);
                boolean bl = flag = this.checkExRateTable(rowEntity, "noninexratetable") || this.checkExChangeDate(rowEntity, "noninexchangedate");
                if (flag) {
                    this.getModel().setValue("noninperiodplanamtstd", (Object)BigDecimal.ZERO);
                    return;
                }
                this.contractFundPlanningService = new InContractFundPlanningService();
                BigDecimal totalPeriodPlanAmt = this.contractFundPlanningService.calculatePeriodPlanAmt(this.getModel());
                BigDecimal nonContractTotalPeriodPlanAmt = this.contractFundPlanningService.calculateNonContractPeriodPlanAmt(this.getModel());
                this.getModel().setValue("periodplanincome", (Object)totalPeriodPlanAmt.add(nonContractTotalPeriodPlanAmt));
                this.getView().updateView("periodplanincome");
                break;
            }
            case "outperiodplanamtstd": {
                this.contractFundPlanningService = new OutContractFundPlanningService();
                BigDecimal totalPeriodPlanAmt = this.contractFundPlanningService.calculatePeriodPlanAmt(this.getModel());
                BigDecimal nonContractTotalPeriodPlanAmt = this.contractFundPlanningService.calculateNonContractPeriodPlanAmt(this.getModel());
                this.getModel().setValue("periodplanoutcome", (Object)totalPeriodPlanAmt.add(nonContractTotalPeriodPlanAmt));
                this.getView().updateView("periodplanoutcome");
                break;
            }
            case "nonoutperiodplanamtstd": {
                boolean flag;
                int curIndex = this.getModel().getEntryCurrentRowIndex("outnoncontractplanentity");
                DynamicObject rowEntity = this.getModel().getEntryRowEntity("outnoncontractplanentity", curIndex);
                boolean bl = flag = this.checkExRateTable(rowEntity, "nonoutexratetable") || this.checkExChangeDate(rowEntity, "nonoutexchangedate");
                if (flag) {
                    this.getModel().setValue("nonoutperiodplanamtstd", (Object)BigDecimal.ZERO);
                    return;
                }
                this.contractFundPlanningService = new OutContractFundPlanningService();
                BigDecimal totalPeriodPlanAmt = this.contractFundPlanningService.calculatePeriodPlanAmt(this.getModel());
                BigDecimal nonContractTotalPeriodPlanAmt = this.contractFundPlanningService.calculateNonContractPeriodPlanAmt(this.getModel());
                this.getModel().setValue("periodplanoutcome", (Object)totalPeriodPlanAmt.add(nonContractTotalPeriodPlanAmt));
                this.getView().updateView("periodplanoutcome");
                break;
            }
            case "innoncurrency": 
            case "noninexratetable": 
            case "noninexchangedate": {
                if (e.getChangeSet()[0].getNewValue() == null) {
                    this.getModel().setValue(e.getProperty().getName(), oldValue);
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MonthlyFundPlanEditPlugin_10", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), e.getProperty().getDisplayName().getLocaleValue()));
                    return;
                }
                int curIndex = this.getModel().getEntryCurrentRowIndex("innoncontractplanentity");
                DynamicObject rowEntity = this.getModel().getEntryRowEntity("innoncontractplanentity", curIndex);
                DynamicObject nonCurrency = rowEntity.getDynamicObject("innoncurrency");
                DynamicObject nonExRateTable = rowEntity.getDynamicObject("noninexratetable");
                Date nonExchangeDate = rowEntity.getDate("noninexchangedate");
                if (nonCurrency == null) {
                    return;
                }
                if (nonExRateTable == null) {
                    return;
                }
                if (nonExchangeDate == null) {
                    return;
                }
                this.nonContractFundPlanningService = new InNonContractFundPlanningService();
                BigDecimal nonPeriodPlanAmtStd = this.nonContractFundPlanningService.calculateNonPeriodPlanAmtStd(this.getModel());
                this.getModel().setValue("noninperiodplanamtstd", (Object)nonPeriodPlanAmtStd);
                this.getView().updateView("noninperiodplanamtstd", curIndex);
                break;
            }
            case "noninperiodplanamt": {
                boolean flag;
                int curIndex = this.getModel().getEntryCurrentRowIndex("innoncontractplanentity");
                DynamicObject rowEntity = this.getModel().getEntryRowEntity("innoncontractplanentity", curIndex);
                boolean bl = flag = this.checkExRateTable(rowEntity, "noninexratetable") || this.checkExChangeDate(rowEntity, "noninexchangedate");
                if (flag) {
                    this.getModel().setValue("noninperiodplanamt", (Object)BigDecimal.ZERO);
                    return;
                }
                this.nonContractFundPlanningService = new InNonContractFundPlanningService();
                BigDecimal nonPeriodPlanAmtStd = this.nonContractFundPlanningService.calculateNonPeriodPlanAmtStd(this.getModel());
                this.getModel().setValue("noninperiodplanamtstd", (Object)nonPeriodPlanAmtStd);
                this.getView().updateView("noninperiodplanamtstd", curIndex);
                break;
            }
            case "outnoncurrency": 
            case "nonoutexratetable": 
            case "nonoutexchangedate": {
                if (e.getChangeSet()[0].getNewValue() == null) {
                    this.getModel().setValue(e.getProperty().getName(), oldValue);
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MonthlyFundPlanEditPlugin_10", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), e.getProperty().getDisplayName().getLocaleValue()));
                    return;
                }
                int curIndex = this.getModel().getEntryCurrentRowIndex("outnoncontractplanentity");
                DynamicObject rowEntity = this.getModel().getEntryRowEntity("outnoncontractplanentity", curIndex);
                DynamicObject nonCurrency = rowEntity.getDynamicObject("outnoncurrency");
                DynamicObject nonExRateTable = rowEntity.getDynamicObject("nonoutexratetable");
                Date nonExchangeDate = rowEntity.getDate("nonoutexchangedate");
                if (nonCurrency == null) {
                    return;
                }
                if (nonExRateTable == null) {
                    return;
                }
                if (nonExchangeDate == null) {
                    return;
                }
                this.nonContractFundPlanningService = new OutNonContractFundPlanningService();
                BigDecimal nonPeriodPlanAmtStd = this.nonContractFundPlanningService.calculateNonPeriodPlanAmtStd(this.getModel());
                this.getModel().setValue("nonoutperiodplanamtstd", (Object)nonPeriodPlanAmtStd);
                this.getView().updateView("nonoutperiodplanamtstd", curIndex);
                break;
            }
            case "nonoutperiodplanamt": {
                boolean flag;
                int curIndex = this.getModel().getEntryCurrentRowIndex("outnoncontractplanentity");
                DynamicObject rowEntity = this.getModel().getEntryRowEntity("outnoncontractplanentity", curIndex);
                boolean bl = flag = this.checkExRateTable(rowEntity, "nonoutexratetable") || this.checkExChangeDate(rowEntity, "nonoutexchangedate");
                if (flag) {
                    this.getModel().setValue("nonoutperiodplanamt", (Object)BigDecimal.ZERO);
                    return;
                }
                this.nonContractFundPlanningService = new OutNonContractFundPlanningService();
                BigDecimal nonPeriodPlanAmtStd = this.nonContractFundPlanningService.calculateNonPeriodPlanAmtStd(this.getModel());
                this.getModel().setValue("nonoutperiodplanamtstd", (Object)nonPeriodPlanAmtStd);
                this.getView().updateView("nonoutperiodplanamtstd", curIndex);
                break;
            }
            case "periodplanincome": 
            case "periodplanoutcome": {
                BigDecimal periodPlanIncome = (BigDecimal)this.getModel().getValue("periodplanincome");
                BigDecimal periodPlanOutcome = (BigDecimal)this.getModel().getValue("periodplanoutcome");
                this.getModel().setValue("periodfundcost", (Object)periodPlanIncome.subtract(periodPlanOutcome));
                this.getView().updateView("periodfundcost");
                break;
            }
        }
    }

    private boolean checkAllEntityData() {
        DynamicObjectCollection inContractPlanEntities = this.getModel().getEntryEntity(CTRL_IN_CONTRACT_PLAN_ENTITY);
        DynamicObjectCollection outContractPlanEntities = this.getModel().getEntryEntity(CTRL_OUT_CONTRACT_PLAN_ENTITY);
        DynamicObjectCollection inNonContractPlanEntities = this.getModel().getEntryEntity("innoncontractplanentity");
        DynamicObjectCollection outNonContractPlanEntities = this.getModel().getEntryEntity("outnoncontractplanentity");
        return !inContractPlanEntities.isEmpty() || !outContractPlanEntities.isEmpty() || !inNonContractPlanEntities.isEmpty() || !outNonContractPlanEntities.isEmpty();
    }

    private boolean checkExRateTable(DynamicObject rowEntity, String exRateTableFormId) {
        DynamicObject exRateTable = rowEntity.getDynamicObject(exRateTableFormId);
        if (exRateTable == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6c47\u7387\u8868\u3002", (String)"MonthlyFundPlanEditPlugin_15", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private boolean checkExChangeDate(DynamicObject rowEntity, String exChangeDateFormId) {
        Date exChangeDate = rowEntity.getDate(exChangeDateFormId);
        if (exChangeDate == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6c47\u7387\u65e5\u671f\u3002", (String)"MonthlyFundPlanEditPlugin_16", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    public void entryRowClick(RowClickEvent evt) {
        String sourceKey;
        int clickRowIndex = evt.getRow();
        Control source = (Control)evt.getSource();
        switch (sourceKey = source.getKey()) {
            case "incontractplanentity": {
                if (clickRowIndex < 0) break;
                this.getModel().deleteEntryData("subincomeitementity");
                this.contractFundPlanningService = new InContractFundPlanningService();
                this.contractFundPlanningService.loadPayItemEntry(this.getView(), clickRowIndex);
                break;
            }
            case "outcontractplanentity": {
                if (clickRowIndex < 0) break;
                this.getModel().deleteEntryData("payitementry");
                this.contractFundPlanningService = new OutContractFundPlanningService();
                this.contractFundPlanningService.loadPayItemEntry(this.getView(), clickRowIndex);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        switch (actionId) {
            case "inselectcontract": {
                ListSelectedRowCollection selectedRows = (ListSelectedRowCollection)returnData;
                if (selectedRows == null) {
                    return;
                }
                this.contractFillBackService = new InContractFillBackService();
                DynamicObjectCollection contractPlanEntries = this.contractFillBackService.fillBillEntryByContractF7(this.getView(), this.getModel(), selectedRows);
                this.getModel().updateEntryCache(contractPlanEntries);
                this.getView().updateView(CTRL_IN_CONTRACT_PLAN_ENTITY);
                break;
            }
            case "outselectcontract": {
                ListSelectedRowCollection selectedRows = (ListSelectedRowCollection)returnData;
                if (selectedRows == null) {
                    return;
                }
                this.contractFillBackService = new OutContractFillBackService();
                DynamicObjectCollection outContractPlanEntries = this.contractFillBackService.fillBillEntryByContractF7(this.getView(), this.getModel(), selectedRows);
                this.getModel().updateEntryCache(outContractPlanEntries);
                this.getView().updateView(CTRL_OUT_CONTRACT_PLAN_ENTITY);
                break;
            }
            case "inplanplanning": {
                if (StringUtils.isBlank((Object)returnData)) {
                    return;
                }
                this.contractFillBackService = new InContractFillBackService();
                DynamicObjectCollection contractPlanEntries = this.contractFillBackService.fillFundPlanData2BillEntry(this.getView(), this.getModel(), returnData.toString());
                this.getModel().updateEntryCache(contractPlanEntries);
                this.contractFundPlanningService = new InContractFundPlanningService();
                BigDecimal totalPeriodPlanAmt = this.contractFundPlanningService.calculatePeriodPlanAmt(this.getModel());
                BigDecimal nonContractTotalPeriodPlanAmt = this.contractFundPlanningService.calculateNonContractPeriodPlanAmt(this.getModel());
                this.getModel().setValue("periodplanincome", (Object)totalPeriodPlanAmt.add(nonContractTotalPeriodPlanAmt));
                this.getView().updateView(CTRL_IN_CONTRACT_PLAN_ENTITY);
                this.getView().updateView("periodplanincome");
                break;
            }
            case "outplanplanning": {
                if (StringUtils.isBlank((Object)returnData)) {
                    return;
                }
                this.contractFillBackService = new OutContractFillBackService();
                DynamicObjectCollection outContractPlanEntries = this.contractFillBackService.fillFundPlanData2BillEntry(this.getView(), this.getModel(), returnData.toString());
                this.contractFundPlanningService = new OutContractFundPlanningService();
                this.getModel().updateEntryCache(outContractPlanEntries);
                BigDecimal totalPeriodPlanAmt = this.contractFundPlanningService.calculatePeriodPlanAmt(this.getModel());
                BigDecimal nonContractTotalPeriodPlanAmt = this.contractFundPlanningService.calculateNonContractPeriodPlanAmt(this.getModel());
                this.getModel().setValue("periodplanoutcome", (Object)totalPeriodPlanAmt.add(nonContractTotalPeriodPlanAmt));
                this.getView().updateView(CTRL_OUT_CONTRACT_PLAN_ENTITY);
                this.getView().updateView("periodplanoutcome");
                break;
            }
            case "inimportincontractplanentry": {
                if (StringUtils.isBlank((Object)returnData)) {
                    return;
                }
                this.contractFillBackService = new InContractFillBackService();
                DynamicObjectCollection contractPlanEntries = this.contractFillBackService.fillImportData2BillEntry(this.getView(), this.getModel(), returnData.toString());
                this.getModel().updateEntryCache(contractPlanEntries);
                this.contractFundPlanningService = new InContractFundPlanningService();
                BigDecimal totalPeriodPlanAmt = this.contractFundPlanningService.calculatePeriodPlanAmt(this.getModel());
                BigDecimal nonContractTotalPeriodPlanAmt = this.contractFundPlanningService.calculateNonContractPeriodPlanAmt(this.getModel());
                this.getModel().setValue("periodplanincome", (Object)totalPeriodPlanAmt.add(nonContractTotalPeriodPlanAmt));
                this.getView().updateView(CTRL_IN_CONTRACT_PLAN_ENTITY);
                this.getView().updateView("periodplanincome");
                break;
            }
            case "outimportincontractplanentry": {
                if (StringUtils.isBlank((Object)returnData)) {
                    return;
                }
                this.contractFillBackService = new OutContractFillBackService();
                DynamicObjectCollection contractPlanEntries = this.contractFillBackService.fillImportData2BillEntry(this.getView(), this.getModel(), returnData.toString());
                this.getModel().updateEntryCache(contractPlanEntries);
                this.contractFundPlanningService = new OutContractFundPlanningService();
                BigDecimal totalPeriodPlanAmt = this.contractFundPlanningService.calculatePeriodPlanAmt(this.getModel());
                BigDecimal nonContractTotalPeriodPlanAmt = this.contractFundPlanningService.calculateNonContractPeriodPlanAmt(this.getModel());
                this.getModel().setValue("periodplanoutcome", (Object)totalPeriodPlanAmt.add(nonContractTotalPeriodPlanAmt));
                this.getView().updateView(CTRL_OUT_CONTRACT_PLAN_ENTITY);
                this.getView().updateView("periodplanoutcome");
                break;
            }
            case "innonimportincontractplanentry": {
                if (StringUtils.isBlank((Object)returnData)) {
                    return;
                }
                this.nonContractFundPlanningService = new InNonContractFundPlanningService();
                DynamicObjectCollection contractPlanEntries = this.nonContractFundPlanningService.setImportData(this.getModel(), returnData.toString());
                this.getModel().updateEntryCache(contractPlanEntries);
                BigDecimal nonContractTotalPeriodPlanAmt = ((EntryGrid)this.getControl("innoncontractplanentity")).getSum("noninperiodplanamtstd");
                BigDecimal periodPlanIncome = ((EntryGrid)this.getControl(CTRL_IN_CONTRACT_PLAN_ENTITY)).getSum("inperiodplanamtstd");
                this.getModel().setValue("periodplanincome", (Object)periodPlanIncome.add(nonContractTotalPeriodPlanAmt));
                this.getView().updateView("innoncontractplanentity");
                this.getView().updateView("periodplanincome");
                break;
            }
            case "outnonimportincontractplanentry": {
                if (StringUtils.isBlank((Object)returnData)) {
                    return;
                }
                this.nonContractFundPlanningService = new OutNonContractFundPlanningService();
                DynamicObjectCollection contractPlanEntries = this.nonContractFundPlanningService.setImportData(this.getModel(), returnData.toString());
                this.getModel().updateEntryCache(contractPlanEntries);
                BigDecimal nonContractTotalPeriodPlanAmt = ((EntryGrid)this.getControl("outnoncontractplanentity")).getSum("nonoutperiodplanamtstd");
                BigDecimal periodPlanIncome = ((EntryGrid)this.getControl(CTRL_OUT_CONTRACT_PLAN_ENTITY)).getSum("outperiodplanamtstd");
                this.getModel().setValue("periodplanoutcome", (Object)periodPlanIncome.add(nonContractTotalPeriodPlanAmt));
                this.getView().updateView("outnoncontractplanentity");
                this.getView().updateView("periodplanoutcome");
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        switch (callBackId) {
            case "savecreatenew": {
                if (MessageBoxResult.Yes != result) break;
                this.getView().getPageCache().put(PAGE_CACHE_NEED_CHECK_PERIOD_AND_ORG, "false");
                this.getView().invokeOperation(OPERATION_SAVE);
                break;
            }
            case "submitcreatenew": {
                if (MessageBoxResult.Yes != result) break;
                this.getView().getPageCache().put(PAGE_CACHE_NEED_CHECK_PERIOD_AND_ORG, "false");
                this.getView().invokeOperation(OPERATION_SUBMIT);
                break;
            }
            case "projectchanged": 
            case "periodchanged": {
                if (MessageBoxResult.Yes != result) break;
                this.getModel().deleteEntryData(CTRL_IN_CONTRACT_PLAN_ENTITY);
                this.getModel().deleteEntryData(CTRL_OUT_CONTRACT_PLAN_ENTITY);
                this.getModel().deleteEntryData("innoncontractplanentity");
                this.getModel().deleteEntryData("outnoncontractplanentity");
                this.getModel().deleteEntryData("payitementry");
                this.getModel().setValue("periodplanincome", (Object)BigDecimal.ZERO);
                this.getModel().setValue("periodplanoutcome", (Object)BigDecimal.ZERO);
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        super.beforeF7Select(event);
    }
}

