/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.formplugin.register;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmgt.pmct.business.manage.MultiSettleAmtService;
import kd.pmgt.pmct.common.utils.InComeUtils;

public class IncomeRegisterListPlugin
extends AbstractListPlugin {
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        ListSelectedRowCollection listSelectedData = args.getListSelectedData();
        if (("submit".equals(operateKey) || "unsubmit".equals(operateKey) || "audit".equals(operateKey) || "unaudit".equals(operateKey)) && listSelectedData.size() > 0) {
            Object[] primaryKeyValues = args.getListSelectedData().getPrimaryKeyValues();
            HashSet<Object> keySet = new HashSet<Object>(16);
            keySet.addAll(Arrays.asList(primaryKeyValues));
            ArrayList<DynamicObject> inComeRegisterList = new ArrayList<DynamicObject>(10);
            String names = "";
            for (Object e : keySet) {
                DynamicObject inComeRegister = BusinessDataServiceHelper.loadSingle(e, (String)"pmct_incomeregister");
                if (inComeRegister.getBoolean("pushed")) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\uff1a\u7531\u8bf7\u6b3e\u5355\u4e0b\u63a8\u7684\u6536\u6b3e\u767b\u8bb0\u5355\uff0c\u4e0d\u80fd\u8fdb\u884c\u8be5\u64cd\u4f5c\u3002", (String)"IncomeRegisterListPlugin_3", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), inComeRegister.getString("billno")));
                    args.setCancel(true);
                    return;
                }
                DynamicObjectCollection contractInComeCollection = inComeRegister.getDynamicObjectCollection("entryentity");
                DynamicObject org = inComeRegister.getDynamicObject("org");
                DynamicObject period = inComeRegister.getDynamicObject("period");
                String contractName = "";
                boolean flag = false;
                if (contractInComeCollection.size() > 0) {
                    for (DynamicObject contractPay : contractInComeCollection) {
                        DynamicObject contract = contractPay.getDynamicObject("entrycontract");
                        DynamicObject entryContPro = contractPay.getDynamicObject("contpro");
                        if (contract != null) {
                            BigDecimal totalApplyOfTaxAmount;
                            BigDecimal totalRealOfTaxAmount;
                            BigDecimal totalSettleOfTaxAmount;
                            contract = BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmct_outcontract"));
                            if (contractPay.getBigDecimal("totaloftaxamount").compareTo(contract.getBigDecimal("totaloftaxamount")) != 0) {
                                flag = true;
                                contractPay.set("totaloftaxamount", (Object)contract.getBigDecimal("totaloftaxamount"));
                            }
                            boolean multiPartSettlement = contract.getBoolean("multipartsettlement");
                            String multiPayType = contract.getString("multipaytype");
                            if (multiPartSettlement && StringUtils.equals((CharSequence)multiPayType, (CharSequence)"separatepay")) {
                                MultiSettleAmtService multiSettleAmtService = new MultiSettleAmtService();
                                totalSettleOfTaxAmount = multiSettleAmtService.getMultiSettleAmount(org, entryContPro, contract, period, null);
                                totalRealOfTaxAmount = multiSettleAmtService.getMultiIncomeAmount(org, entryContPro, contract, period);
                                totalApplyOfTaxAmount = multiSettleAmtService.getMultiIncomeApplyAmount(org, entryContPro, contract, period);
                            } else {
                                InComeUtils inComeUtils = new InComeUtils();
                                totalSettleOfTaxAmount = inComeUtils.totalsettleoftaxamount(contract, period, null);
                                totalRealOfTaxAmount = inComeUtils.totalrealoftaxamount(contract, period, null);
                                totalApplyOfTaxAmount = inComeUtils.totalApplyOfTaxAmount(contract, period, null);
                            }
                            if (contractPay.getBigDecimal("totalsettleoftaxamount").compareTo(totalSettleOfTaxAmount) != 0) {
                                flag = true;
                                contractPay.set("totalsettleoftaxamount", (Object)totalSettleOfTaxAmount);
                            }
                            if (contractPay.getBigDecimal("totalrealoftaxamount").compareTo(totalRealOfTaxAmount) != 0) {
                                flag = true;
                                contractPay.set("totalrealoftaxamount", (Object)totalRealOfTaxAmount);
                            }
                            if (contractPay.getBigDecimal("preapplyoftaxamtsum").compareTo(totalApplyOfTaxAmount) != 0) {
                                flag = true;
                                contractPay.set("preapplyoftaxamtsum", (Object)totalApplyOfTaxAmount);
                            }
                            contractPay.set("totalunreceiptamount", (Object)totalSettleOfTaxAmount.subtract(totalRealOfTaxAmount));
                        }
                        if (!flag) continue;
                        if (StringUtils.isNotEmpty((CharSequence)contractName)) {
                            contractName = contractName + "," + contract.getString("billname");
                            continue;
                        }
                        contractName = contractName + contract.getString("billname");
                    }
                    this.getView().getPageCache().put("contractName", contractName);
                }
                if (!StringUtils.isNotEmpty((CharSequence)contractName)) continue;
                inComeRegisterList.add(inComeRegister);
                if (names.isEmpty()) {
                    names = inComeRegister.getString("billno") + ":" + contractName;
                    continue;
                }
                names = names + ";" + inComeRegister.getString("billno") + ":" + contractName;
            }
            if (inComeRegisterList.size() > 0) {
                SaveServiceHelper.update((DynamicObject[])inComeRegisterList.toArray(new DynamicObject[0]));
                this.getView().getPageCache().put("names", names);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if ("submit".equals(operateKey) || "audit".equals(operateKey)) {
            String[] billNames;
            String flagNames = this.getView().getPageCache().get("names");
            this.getView().getPageCache().remove("names");
            if (afterDoOperationEventArgs.getOperationResult().isSuccess() && StringUtils.isNotEmpty((CharSequence)flagNames) && (billNames = flagNames.split(";")).length > 0) {
                for (String contractName : billNames) {
                    String[] names = contractName.split(":");
                    if (names.length <= 0) continue;
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%1$s\uff1a\u201c\u6536\u6b3e\u4fe1\u606f\u201d\u4e2d\u5408\u540c\u201c%2$s\u201d\u7684\u7d2f\u8ba1\u91d1\u989d\u6709\u53d8\u52a8\uff0c\u8bf7\u6ce8\u610f\u8c03\u6574\u201c\u672c\u6b21\u5b9e\u6536\u542b\u7a0e\u603b\u91d1\u989d\u201d\u3002", (String)"IncomeRegisterListPlugin_2", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), names[0], names[1]));
                }
            }
        }
    }
}

