/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.formplugin.revision;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.report.CellStyle;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.bill.BillView;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.pmgt.pmbs.business.helper.ContractCollectItemHelper;
import kd.pmgt.pmbs.business.helper.ContractPayItemHelper;
import kd.pmgt.pmbs.business.helper.FileAttachmentHelper;
import kd.pmgt.pmbs.common.enums.CompletionStatusEnum;
import kd.pmgt.pmbs.common.enums.ContractPayItemSourceEnum;
import kd.pmgt.pmbs.common.enums.ContractStatusEnum;
import kd.pmgt.pmbs.common.enums.DefaultEnum;
import kd.pmgt.pmbs.common.enums.NodeSettingSourceEnum;
import kd.pmgt.pmbs.common.enums.PayDirectionEnum;
import kd.pmgt.pmbs.common.enums.PayPlanSourceEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmbs.common.enums.TaskCompleteStateEnum;
import kd.pmgt.pmbs.common.utils.DetailBillUtils;
import kd.pmgt.pmbs.common.utils.NumberHelper;
import kd.pmgt.pmct.business.helper.ContractEditHelper;
import kd.pmgt.pmct.common.utils.ContractSupplierHelper;
import kd.pmgt.pmct.formplugin.base.AbstractPmctBillPlugin;

public class ContractRevisionEditPlugin
extends AbstractPmctBillPlugin
implements BeforeF7SelectListener {
    private static final Log LOG = LogFactory.getLog(ContractRevisionEditPlugin.class);
    private static final String REVISECONFIRM_CALLBACK = "REVISECONFIRM_CALLBACK";
    private static final String PAYAMOUNT_CALLBACK = "payamountcallback";
    private static final String OUT_PAYPLAN_FLEX = "advconap1";
    private static final String IN_PAYPLAN_FLEX = "advconap";
    private static final String ATTACHMENTPANEL = "attachmentpanel";
    private static final String TEXTATTACHMENTPANEL = "textattachmentpanel";
    private static final String PAGE_CACHE_CONTRACT_ID = "contractId";
    private static final String PAGE_CACHE_PAY_DIRECTION = "paydirection";
    private static final String PAGE_CACHE_CONTRACT = "contractCache";
    private static final String OPERATION_DELETE_INCOME_ENTRY = "deleteincomeentry";
    private static final String OPERATION_DELETE_PAY_ENTRY = "deletepayentry";
    private static final String OPERATION_SHOW_INCOME_COMPARE = "showincomecompare";
    private static final String OPERATION_SHOW_COMPARE = "showcompare";
    private static final String OPERATION_SUBMIT = "submit";
    private static final String OPERATION_SAVE = "save";
    private static final String OPERATION_UNSUBMIT = "unsubmit";
    private static final String OPERATION_UNAUDIT = "unaudit";
    private static final String IS_FIRST_INIT = "isfirstInit";
    private boolean existRevisonContract = false;
    private static final String CTRL_NEWPAYENTRY = "newpayentry";
    private static final int PERCENT_OK = 100;
    private static final String ADJUST = "adjust";
    private static final String NEWINCOMEENTRY = "newincomeentry";
    private static final String DELETEINCOMEENTRY = "deleteincomeentry";
    private static final String NEWPAYENTRY = "newpayentry";
    private static final String DELETEPAYENTRY = "deletepayentry";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit supplierEdit = (BasedataEdit)this.getControl("supplier");
        supplierEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit contract = (BasedataEdit)this.getView().getControl("contract");
        contract.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit nodeSettingEdit = (BasedataEdit)this.getControl("nodesetting");
        nodeSettingEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        nodeSettingEdit.addBeforeF7ViewDetailListener(evt -> {
            DynamicObject nodeSetting;
            evt.setCancel(true);
            Object pkId = evt.getPkId();
            if (null != pkId && QueryServiceHelper.exists((String)NodeSettingSourceEnum.PMBS_TASK.getValue(), (Object)pkId) && !(nodeSetting = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)NodeSettingSourceEnum.PMBS_TASK.getValue())).getBoolean("islatest")) {
                DynamicObject sourceTask = nodeSetting.getDynamicObject("sourcetask");
                nodeSetting = BusinessDataServiceHelper.loadSingle((String)NodeSettingSourceEnum.PMBS_TASK.getValue(), (String)String.join((CharSequence)",", new CharSequence[0]), (QFilter[])new QFilter[]{new QFilter("sourcetask", "=", sourceTask.getPkValue()), new QFilter("islatest", "=", (Object)true)});
                pkId = nodeSetting.getPkValue();
            }
            this.getView().showForm((FormShowParameter)DetailBillUtils.viewDetail((String)"pmpt_reporttaskview", (String)"id", (Object)pkId));
        });
        BasedataEdit incomeNodeSettingEdit = (BasedataEdit)this.getControl("incomenodesetting");
        incomeNodeSettingEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        incomeNodeSettingEdit.addBeforeF7ViewDetailListener(evt -> {
            DynamicObject nodeSetting;
            evt.setCancel(true);
            Object pkId = evt.getPkId();
            if (null != pkId && QueryServiceHelper.exists((String)NodeSettingSourceEnum.PMBS_TASK.getValue(), (Object)pkId) && !(nodeSetting = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)NodeSettingSourceEnum.PMBS_TASK.getValue())).getBoolean("islatest")) {
                DynamicObject sourceTask = nodeSetting.getDynamicObject("sourcetask");
                nodeSetting = BusinessDataServiceHelper.loadSingle((String)NodeSettingSourceEnum.PMBS_TASK.getValue(), (String)String.join((CharSequence)",", new CharSequence[0]), (QFilter[])new QFilter[]{new QFilter("sourcetask", "=", sourceTask.getPkValue()), new QFilter("islatest", "=", (Object)true)});
                pkId = nodeSetting.getPkValue();
            }
            this.getView().showForm((FormShowParameter)DetailBillUtils.viewDetail((String)"pmpt_reporttaskview", (String)"id", (Object)pkId));
        });
    }

    public void createNewData(BizDataEventArgs e) {
        super.createNewData(e);
        Object contractId = this.getView().getFormShowParameter().getCustomParam(PAGE_CACHE_CONTRACT_ID);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("contract", "=", contractId).and("billstatus", "!=", (Object)StatusEnum.CHECKED.getValue()));
        DynamicObject contractRevision = BusinessDataServiceHelper.loadSingle((String)"pmct_contractrevision", (String)"", (QFilter[])qFilters.toArray(new QFilter[0]));
        if (contractRevision != null) {
            this.existRevisonContract = true;
            DynamicObject dataEntity = BusinessDataServiceHelper.loadSingle((Object)contractRevision.getPkValue(), (String)"pmct_contractrevision");
            e.setDataEntity((Object)dataEntity);
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        Object pkValue = dataEntity.getPkValue();
        if (pkValue == null || (Long)pkValue == 0L) {
            long contractRevisionId = ORM.create().genLongId("pmct_contractrevision");
            dataEntity.set("id", (Object)contractRevisionId);
        }
        DynamicObject contract = this.getContract();
        String payDirection = contract.getString(PAGE_CACHE_PAY_DIRECTION);
        Object contractId = contract.getPkValue();
        QFilter contractIdFilter = new QFilter("contract", "=", contractId != null ? Long.valueOf(Long.parseLong(contractId.toString())) : null);
        DynamicObject[] contractRevisions = BusinessDataServiceHelper.load((String)"pmct_contractrevision", (String)"billno, billstatus, creator, auditor, modifier, auditdate, createtime, modifytime, contract, contractno, contractname, payrate, currency, versionnumber, description", (QFilter[])new QFilter[]{contractIdFilter}, (String)"versionnumber desc");
        String destinationFormId = "pmct_contractrevision";
        Object destinationBillId = this.getModel().getDataEntity().getPkValue();
        if (contractRevisions.length > 0) {
            Object contractRevisionId = contractRevisions[0].getPkValue();
            if (contractRevisionId != null) {
                String srcFormId = "pmct_contractrevision";
                String srcBillId = contractRevisionId.toString();
                FileAttachmentHelper.copyFileFromAToB((String)srcFormId, (Object)srcBillId, (String)ATTACHMENTPANEL, (String)destinationFormId, (Object)destinationBillId, (String)ATTACHMENTPANEL, (IFormView)this.getView());
                FileAttachmentHelper.copyFileFromAToB((String)srcFormId, (Object)srcBillId, (String)TEXTATTACHMENTPANEL, (String)destinationFormId, (Object)destinationBillId, (String)TEXTATTACHMENTPANEL, (IFormView)this.getView());
                this.getView().updateView(ATTACHMENTPANEL);
                this.getView().updateView(TEXTATTACHMENTPANEL);
            }
        } else {
            String srcFormId = PayDirectionEnum.OUT.getValue().equals(payDirection) ? "pmct_outcontract" : "pmct_incontract";
            if (contractId == null) {
                return;
            }
            String srcBillId = contractId.toString();
            FileAttachmentHelper.copyFileFromAToB((String)srcFormId, (Object)srcBillId, (String)ATTACHMENTPANEL, (String)destinationFormId, (Object)destinationBillId, (String)ATTACHMENTPANEL, (IFormView)this.getView());
            FileAttachmentHelper.copyFileFromAToB((String)srcFormId, (Object)srcBillId, (String)TEXTATTACHMENTPANEL, (String)destinationFormId, (Object)destinationBillId, (String)TEXTATTACHMENTPANEL, (IFormView)this.getView());
            this.getView().updateView(ATTACHMENTPANEL);
            this.getView().updateView(TEXTATTACHMENTPANEL);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        BillShowParameter billShowParameter = (BillShowParameter)((BillView)e.getSource()).getFormShowParameter();
        DynamicObject[] contractRevisions = BusinessDataServiceHelper.load((Object[])new Object[]{billShowParameter.getPkId()}, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmct_contractrevision"));
        if (contractRevisions != null && contractRevisions.length > 0) {
            this.existRevisonContract = true;
        }
        DynamicObject contract = this.getContract();
        String payDirection = contract.getString(PAGE_CACHE_PAY_DIRECTION);
        if (PayDirectionEnum.OUT.getValue().equals(payDirection)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{IN_PAYPLAN_FLEX});
        } else if (PayDirectionEnum.IN.getValue().equals(payDirection)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{OUT_PAYPLAN_FLEX});
        }
        if (!this.existRevisonContract) {
            this.loadHeadFields(contract);
            this.loadRiskEntry(contract);
            if (PayDirectionEnum.OUT.getValue().equals(payDirection)) {
                this.loadOutContPlanEntry(contract);
            } else if (PayDirectionEnum.IN.getValue().equals(payDirection)) {
                this.loadIncomePlanEntry(contract);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "deleteincomeentry": {
                this.recountPayPlan();
                EntryGrid grid = (EntryGrid)this.getView().getControl("incontpayplanentry");
                int[] selectRows = grid.getSelectRows();
                DynamicObjectCollection contractPayPlanEntries = this.getModel().getEntryEntity("incontpayplanentry");
                this.checkIncomeEntry(args, selectRows, contractPayPlanEntries);
                break;
            }
            case "deletepayentry": {
                this.recountPayPlan();
                EntryGrid grid = (EntryGrid)this.getView().getControl("outcontpayplanentry");
                int[] selectRows = grid.getSelectRows();
                DynamicObjectCollection outContractPayPlanEntries = this.getModel().getEntryEntity("outcontpayplanentry");
                this.checkPayEntry(args, selectRows, outContractPayPlanEntries);
                break;
            }
            case "showincomecompare": {
                this.showIncomeCompare();
                break;
            }
            case "showcompare": {
                this.showCompare();
                break;
            }
            case "unaudit": {
                DynamicObject contractf7 = this.getModel().getDataEntity().getDynamicObject("contract");
                contractf7 = BusinessDataServiceHelper.loadSingle((Object)contractf7.getPkValue(), (String)"pmct_contracttpl");
                DynamicObject contStatus = contractf7.getDynamicObject("contractstatus");
                List statusNums = Stream.of(ContractStatusEnum.CLOSED.getValue()).collect(Collectors.toList());
                if (!statusNums.contains(contStatus.getString("number"))) break;
                String tip = String.format(ResManager.loadKDString((String)"\u5408\u540c\u72b6\u6001\u4e3a%s\uff0c\u65e0\u6cd5\u53cd\u5ba1\u6838\u3002", (String)"ContractRevisionEditPlugin_13", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), contStatus.getString("name"));
                this.getView().showTipNotification(tip);
                args.setCancel(true);
                return;
            }
            case "adjust": {
                DynamicObject contract = this.getContract();
                String payDirection = contract.getString(PAGE_CACHE_PAY_DIRECTION);
                HashMap<String, String> paramMap = new HashMap<String, String>(16);
                if (PayDirectionEnum.OUT.getValue().equals(payDirection)) {
                    paramMap.put("direction", PayDirectionEnum.OUT.getValue());
                    paramMap.put("planEntry", "outcontpayplanentry");
                    paramMap.put("percentModel", "outpercentmodel");
                    paramMap.put("payPercent", "paypercent");
                    paramMap.put("payAmount", "payamount");
                    paramMap.put("Originaloftaxamount", "originaloftaxamount");
                    ContractEditHelper.adjustPayPlan((IFormView)this.getView(), paramMap);
                    break;
                }
                if (!PayDirectionEnum.IN.getValue().equals(payDirection)) break;
                paramMap.put("direction", PayDirectionEnum.IN.getValue());
                paramMap.put("planEntry", "incontpayplanentry");
                paramMap.put("percentModel", "inpercentmodel");
                paramMap.put("payPercent", "incomepercent");
                paramMap.put("payAmount", "incomeamount");
                paramMap.put("Originaloftaxamount", "originaloftaxamount");
                ContractEditHelper.adjustPayPlan((IFormView)this.getView(), paramMap);
                break;
            }
            case "newincomeentry": 
            case "newpayentry": {
                this.recountPayPlan();
                break;
            }
        }
    }

    private void checkPayEntry(BeforeDoOperationEventArgs args, int[] selectRows, DynamicObjectCollection outContractPayPlanEntries) {
        List selectedOutContractPayPlanEntries = Arrays.stream(selectRows).boxed().map(arg_0 -> outContractPayPlanEntries.get(arg_0)).filter(entry -> entry.getLong("conpayitemid") != 0L).collect(Collectors.toList());
        for (DynamicObject selectPlanEntry : selectedOutContractPayPlanEntries) {
            long conPayItemId = selectPlanEntry.getLong("conpayitemid");
            DynamicObject contractPayItem = BusinessDataServiceHelper.loadSingle((Object)conPayItemId, (String)"pmbs_contractpayitem");
            BigDecimal reimbursedComAmt = contractPayItem.getBigDecimal("reimbursedcomamt");
            if (reimbursedComAmt.compareTo(BigDecimal.ZERO) > 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ed8\u6b3e\u8ba1\u5212\u5df2\u53d1\u751f\u62a5\u9500\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"ContractRevisionEditPlugin_14", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                break;
            }
            BigDecimal paidComAmt = contractPayItem.getBigDecimal("paidcomamt");
            if (paidComAmt.compareTo(BigDecimal.ZERO) > 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ed8\u6b3e\u8ba1\u5212\u5df2\u53d1\u751f\u4ed8\u6b3e\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"ContractRevisionEditPlugin_15", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                break;
            }
            long payItemId = selectPlanEntry.getLong("conpayitemid");
            boolean exists = QueryServiceHelper.exists((String)"pmbs_contractpayitem", (Object)payItemId);
            if (!exists) continue;
            DynamicObject payItem = BusinessDataServiceHelper.loadSingle((Object)payItemId, (String)"pmbs_contractpayitem");
            String payItemName = payItem.getString("name");
            Map targetBillIds = BFTrackerServiceHelper.findTargetBills((String)"pmbs_contractpayitembook", (Long[])new Long[]{payItem.getLong("id")});
            if (!targetBillIds.isEmpty()) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u5df2\u88ab\u5f15\u7528\u6216\u4e0b\u63a8\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"ContractRevisionEditPlugin_16", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), payItemName));
                args.setCancel(true);
                break;
            }
            BigDecimal appliedComAmt = payItem.getBigDecimal("appliedcomamt");
            if (NumberHelper.isNullZero((BigDecimal)appliedComAmt)) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ed8\u6b3e\u8ba1\u5212\u5df2\u53d1\u751f\u4ed8\u6b3e\u7533\u8bf7\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"ContractRevisionEditPlugin_17", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
    }

    private void checkIncomeEntry(BeforeDoOperationEventArgs args, int[] selectRows, DynamicObjectCollection contractPayPlanEntries) {
        List selectedIncomeContractPayPlanEntries = Arrays.stream(selectRows).boxed().map(arg_0 -> contractPayPlanEntries.get(arg_0)).filter(entry -> entry.getLong("conincomeitemid") != 0L).collect(Collectors.toList());
        for (DynamicObject selectPlanEntry : selectedIncomeContractPayPlanEntries) {
            long conPayItemId = selectPlanEntry.getLong("conincomeitemid");
            DynamicObject contractPayItem = BusinessDataServiceHelper.loadSingle((Object)conPayItemId, (String)"pmbs_contractcollectitem");
            BigDecimal paidComAmt = contractPayItem.getBigDecimal("collectedcomamt");
            if (paidComAmt.compareTo(BigDecimal.ZERO) > 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6536\u6b3e\u8ba1\u5212\u5df2\u53d1\u751f\u6536\u6b3e\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"ContractRevisionEditPlugin_18", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                break;
            }
            String payItemName = contractPayItem.getString("name");
            Map targetBillIds = BFTrackerServiceHelper.findTargetBills((String)"pmbs_contractcolitembook", (Long[])new Long[]{contractPayItem.getLong("id")});
            if (!targetBillIds.isEmpty()) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u5df2\u88ab\u5f15\u7528\u6216\u4e0b\u63a8\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"ContractRevisionEditPlugin_21", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), payItemName));
                args.setCancel(true);
                return;
            }
            BigDecimal appliedComAmt = contractPayItem.getBigDecimal("appliedcomamt");
            if (NumberHelper.isNullZero((BigDecimal)appliedComAmt)) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6536\u6b3e\u8ba1\u5212\u5df2\u53d1\u751f\u8bf7\u6b3e\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"ContractRevisionEditPlugin_22", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        OperationResult operationResult;
        super.afterDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"newpayentry")) {
            DynamicObjectCollection entries = this.getModel().getEntryEntity("outcontpayplanentry");
            int rowIndex = entries.size() - 1;
            DynamicObject contract = (DynamicObject)this.getModel().getValue("contract");
            if (contract != null) {
                contract = BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmct_outcontract"));
                this.getModel().setValue("supplier", (Object)contract.getDynamicObject("partb"), rowIndex);
            }
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"ctrlstrategy"});
        } else if ((StringUtils.equals((CharSequence)operateKey, (CharSequence)OPERATION_SUBMIT) || StringUtils.equals((CharSequence)operateKey, (CharSequence)OPERATION_UNSUBMIT) || StringUtils.equals((CharSequence)operateKey, (CharSequence)OPERATION_UNAUDIT)) && (operationResult = args.getOperationResult()).isSuccess()) {
            this.getView().invokeOperation("refresh");
        }
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        ContractPayItemHelper.setBillNameInPayPlanEntry((IDataModel)this.getModel());
        ContractCollectItemHelper.setBillNameInContractCollectEntry((IDataModel)this.getModel());
    }

    private void showCompare() {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("sourceid", this.getModel().getDataEntity().getPkValue());
        param.put("contractid", ((DynamicObject)this.getModel().getValue("contract")).getPkValue());
        param.put("changetype", PayPlanSourceEnum.REVISE.getValue());
        param.put("formId", "pmct_contractrevision");
        DynamicObjectType dt = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmct_contractrevision")).getDynamicObjectCollection("outcontpayplanentry").getDynamicObjectType();
        DynamicObjectCollection outContractPayPlanEntries = this.getModel().getEntryEntity("outcontpayplanentry");
        param.put("entrydata", DynamicObjectSerializeUtil.serialize((Object[])outContractPayPlanEntries.toArray(), (DynamicObjectType)dt));
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId("pmct_fundplanchange");
        showParameter.setCustomParams(param);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setStatus(OperationStatus.VIEW);
        showParameter.setCaption(ResManager.loadKDString((String)"\u4ed8\u6b3e\u8ba1\u5212\u53d8\u66f4\u5bf9\u6bd4", (String)"ContractRevisionEditPlugin_3", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void showIncomeCompare() {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("sourceid", this.getModel().getDataEntity().getPkValue());
        param.put("contractid", ((DynamicObject)this.getModel().getValue("contract")).getPkValue());
        param.put("changetype", PayPlanSourceEnum.REVISE.getValue());
        param.put("formId", "pmct_contractrevision");
        DynamicObjectType dt = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmct_contractrevision")).getDynamicObjectCollection("incontpayplanentry").getDynamicObjectType();
        DynamicObjectCollection contractPayPlanEntries = this.getModel().getEntryEntity("incontpayplanentry");
        param.put("entrydata", DynamicObjectSerializeUtil.serialize((Object[])contractPayPlanEntries.toArray(), (DynamicObjectType)dt));
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId("pmct_incomeplanchange");
        showParameter.setCustomParams(param);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setStatus(OperationStatus.VIEW);
        showParameter.setCaption(ResManager.loadKDString((String)"\u6536\u6b3e\u8ba1\u5212\u53d8\u66f4\u5bf9\u6bd4", (String)"ContractRevisionEditPlugin_4", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private DynamicObject getContract() {
        DynamicObject contract;
        Object contractId = this.getView().getFormShowParameter().getCustomParam(PAGE_CACHE_CONTRACT_ID);
        String payDirection = (String)this.getView().getFormShowParameter().getCustomParam(PAGE_CACHE_PAY_DIRECTION);
        if (contractId == null || payDirection == null) {
            contract = (DynamicObject)this.getModel().getValue("contract");
            contractId = contract.getPkValue();
            payDirection = contract.getString(PAGE_CACHE_PAY_DIRECTION);
        }
        String contractInfo = this.getPageCache().get(PAGE_CACHE_CONTRACT);
        String formBillId = StringUtils.equals((CharSequence)PayDirectionEnum.OUT.getValue(), (CharSequence)payDirection) ? "pmct_outcontract" : "pmct_incontract";
        DynamicObjectType dt = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)formBillId)).getDynamicObjectType();
        if (StringUtils.isNotEmpty((CharSequence)contractInfo)) {
            contract = (DynamicObject)DynamicObjectSerializeUtil.deserialize((String)contractInfo, (DynamicObjectType)dt)[0];
        } else {
            contract = BusinessDataServiceHelper.loadSingle((Object)contractId, (String)formBillId);
            contractInfo = DynamicObjectSerializeUtil.serialize((Object[])new DynamicObject[]{contract}, (DynamicObjectType)dt);
            this.getPageCache().put(PAGE_CACHE_CONTRACT, contractInfo);
        }
        return contract;
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObject contract = this.getContract();
        Object contractId = contract.getPkValue();
        boolean fromDatabase = this.getModel().getDataEntity().getDataEntityState().getFromDatabase();
        if (!fromDatabase) {
            this.getModel().setValue("org", contract.get("org"));
        }
        String payDirection = contract.getString(PAGE_CACHE_PAY_DIRECTION);
        BigDecimal totalOfTaxAmount = contract.getBigDecimal("totaloftaxamount");
        this.getModel().setValue("originaloftaxamount", (Object)totalOfTaxAmount);
        DynamicObject signCurrency = contract.getDynamicObject("currency");
        this.getModel().setValue("currency", (Object)signCurrency);
        ContractPayItemHelper.setBillNameInPayPlanEntry((IDataModel)this.getModel());
        ContractCollectItemHelper.setBillNameInContractCollectEntry((IDataModel)this.getModel());
        DynamicObjectCollection payPlanEntrys = this.getModel().getEntryEntity("outcontpayplanentry");
        Map completeMap = ContractPayItemHelper.getSrcObjCompleteMap((DynamicObject[])((DynamicObject[])payPlanEntrys.toArray((Object[])new DynamicObject[payPlanEntrys.size()])));
        Map mapData = (Map)completeMap.get(NodeSettingSourceEnum.PMBS_TASK.getValue());
        for (DynamicObject payPlanEntry : payPlanEntrys) {
            DynamicObject nodeSetting = payPlanEntry.getDynamicObject("nodesetting");
            if (null == nodeSetting || !QueryServiceHelper.exists((String)NodeSettingSourceEnum.PMBS_TASK.getValue(), (Object)nodeSetting.getPkValue())) continue;
            nodeSetting = BusinessDataServiceHelper.loadSingle((Object)nodeSetting.getPkValue(), (String)NodeSettingSourceEnum.PMBS_TASK.getValue());
            payPlanEntry.set("taskcompletestate", mapData.get(nodeSetting.getLong("id")));
            Long payItemId = payPlanEntry.getLong("conpayitemid");
            if (0L == payItemId || QueryServiceHelper.exists((String)"pmbs_contractpayitem", (Object)payItemId)) continue;
            payPlanEntry.set("conpayitemid", null);
        }
        this.getView().updateView("outcontpayplanentry");
        DynamicObjectCollection incomePlanEntrys = this.getModel().getEntryEntity("incontpayplanentry");
        Map<String, Map<Object, String>> inCompleteMap = this.getSrcObjCompleteMap((DynamicObject[])incomePlanEntrys.toArray((Object[])new DynamicObject[incomePlanEntrys.size()]));
        Map<Object, String> inMapData = inCompleteMap.get(NodeSettingSourceEnum.PMBS_TASK.getValue());
        for (DynamicObject incomePlanEntry : incomePlanEntrys) {
            DynamicObject nodeSetting = incomePlanEntry.getDynamicObject("incomenodesetting");
            if (null == nodeSetting || !QueryServiceHelper.exists((String)NodeSettingSourceEnum.PMBS_TASK.getValue(), (Object)nodeSetting.getPkValue())) continue;
            nodeSetting = BusinessDataServiceHelper.loadSingle((Object)nodeSetting.getPkValue(), (String)NodeSettingSourceEnum.PMBS_TASK.getValue());
            incomePlanEntry.set("incomecompletestate", (Object)inMapData.get(nodeSetting.getLong("id")));
            Long incomeItemId = incomePlanEntry.getLong("conincomeitemid");
            if (0L == incomeItemId || QueryServiceHelper.exists((String)"pmbs_contractcollectitem", (Object)incomeItemId)) continue;
            incomePlanEntry.set("conincomeitemid", null);
        }
        this.getView().updateView("incontpayplanentry");
        BillShowParameter billShowParameter = (BillShowParameter)((BillView)e.getSource()).getFormShowParameter();
        if (BillOperationStatus.AUDIT.getValue() == billShowParameter.getBillStatus().getValue()) {
            String description;
            BigDecimal payRate;
            Object contractRevisionPk = billShowParameter.getPkId();
            DynamicObject currentRevision = BusinessDataServiceHelper.loadSingle((Object)contractRevisionPk, (String)"pmct_contractrevision");
            QFilter contractRevisionFilter = new QFilter("contract", "=", (Object)Long.parseLong(contractId.toString())).and("billstatus", "=", (Object)StatusEnum.CHECKED.getValue()).and("versionnumber", "=", (Object)currentRevision.getBigDecimal("versionnumber").subtract(BigDecimal.ONE));
            DynamicObject[] revisions = BusinessDataServiceHelper.load((String)"pmct_contractrevision", (String)"", (QFilter[])new QFilter[]{contractRevisionFilter});
            DynamicObject preContract = null;
            if (revisions.length > 0) {
                preContract = revisions[0];
                preContract = BusinessDataServiceHelper.loadSingle((Object)preContract.getPkValue(), (String)"pmct_contractrevision");
            }
            if (preContract == null) {
                return;
            }
            String contName = (String)this.getModel().getValue("contractname");
            HashMap<String, String> styleMap = new HashMap<String, String>();
            if (contName != null && !contName.equals(preContract.get("contractname"))) {
                styleMap.put("fc", "#FF0000");
                this.getView().updateControlMetadata("contractname", styleMap);
            }
            if ((payRate = (BigDecimal)this.getModel().getValue("payrate")) != null && payRate.compareTo((BigDecimal)preContract.get("payrate")) != 0) {
                styleMap.put("fc", "#FF0000");
                this.getView().updateControlMetadata("payrate", styleMap);
            }
            if ((description = (String)this.getModel().getValue("description")) != null && !description.equals(preContract.get("description"))) {
                styleMap.put("fc", "#FF0000");
                this.getView().updateControlMetadata("description", styleMap);
            }
            this.compareRiskEntry(preContract);
            if (PayDirectionEnum.IN.getValue().equals(payDirection)) {
                this.compareInEntry(preContract);
            } else {
                this.comparePayEntry(preContract);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        int currentInRowIndex = this.getModel().getEntryCurrentRowIndex("incontpayplanentry");
        int currentOutRowIndex = this.getModel().getEntryCurrentRowIndex("outcontpayplanentry");
        DynamicObject inContPayPlanEntry = this.getModel().getEntryRowEntity("incontpayplanentry", currentInRowIndex);
        DynamicObject outContPayPlanEntry = this.getModel().getEntryRowEntity("outcontpayplanentry", currentOutRowIndex);
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        Object newValue = e.getChangeSet()[0].getNewValue();
        Object oldValue = e.getChangeSet()[0].getOldValue();
        if (StringUtils.equals((CharSequence)name, (CharSequence)"payamount")) {
            this.recountPayPlan();
            BigDecimal originalOfTaxAmount = (BigDecimal)this.getModel().getValue("originaloftaxamount");
            BigDecimal payAmount = outContPayPlanEntry.getBigDecimal("payamount");
            this.getModel().beginInit();
            this.getModel().setValue("paypercent", (Object)payAmount.divide(originalOfTaxAmount, 10, RoundingMode.HALF_UP).multiply(new BigDecimal(100)));
            this.getModel().endInit();
            this.getView().updateView("paypercent", currentOutRowIndex);
        } else if (StringUtils.equals((CharSequence)name, (CharSequence)"paypercent")) {
            this.recountPayPlan();
            BigDecimal originalOfTaxAmount = (BigDecimal)this.getModel().getValue("originaloftaxamount");
            BigDecimal payPercent = outContPayPlanEntry.getBigDecimal("paypercent");
            this.getModel().beginInit();
            this.getModel().setValue("payamount", (Object)originalOfTaxAmount.multiply(payPercent.divide(BigDecimal.valueOf(100L), 6, RoundingMode.HALF_UP)));
            this.getModel().endInit();
            this.getView().updateView("payamount", currentOutRowIndex);
        } else if (StringUtils.equals((CharSequence)name, (CharSequence)"incomepercent")) {
            this.recountPayPlan();
            BigDecimal originalOfTaxAmount = (BigDecimal)this.getModel().getValue("originaloftaxamount");
            BigDecimal payPercent = inContPayPlanEntry.getBigDecimal("incomepercent");
            this.getModel().beginInit();
            this.getModel().setValue("incomeamount", (Object)originalOfTaxAmount.multiply(payPercent.divide(BigDecimal.valueOf(100L), 10, RoundingMode.HALF_UP)));
            this.getModel().endInit();
            this.getView().updateView("incomeamount", currentInRowIndex);
        } else if (StringUtils.equals((CharSequence)name, (CharSequence)"incomeamount")) {
            this.recountPayPlan();
            BigDecimal originalOfTaxAmount = (BigDecimal)this.getModel().getValue("originaloftaxamount");
            if (originalOfTaxAmount != null && originalOfTaxAmount.compareTo(BigDecimal.ZERO) != 0) {
                BigDecimal payAmount = inContPayPlanEntry.getBigDecimal("incomeamount");
                this.getModel().beginInit();
                this.getModel().setValue("incomepercent", (Object)payAmount.divide(originalOfTaxAmount, 10, RoundingMode.HALF_UP).multiply(new BigDecimal(100)));
                this.getModel().endInit();
                this.getView().updateView("incomepercent", currentInRowIndex);
            }
        } else if (StringUtils.equals((CharSequence)name, (CharSequence)"nodesetting")) {
            this.nodeSettingChange(rowIndex, newValue, oldValue);
        } else if (StringUtils.equals((CharSequence)name, (CharSequence)"ctrlstrategy")) {
            this.ctrlStrategyChange(rowIndex, newValue, oldValue);
        } else if (StringUtils.equals((CharSequence)name, (CharSequence)"incomenodesetting")) {
            this.incomeNodeSettingChange(rowIndex, newValue, oldValue);
        } else if (StringUtils.equals((CharSequence)name, (CharSequence)"incomectrlstrategy")) {
            this.incomeCtrlStrategyChange(rowIndex, newValue, oldValue);
        }
    }

    protected void nodeSettingChange(int rowIndex, Object newValue, Object oldValue) {
        if (newValue == oldValue) {
            return;
        }
        DynamicObject rowEntry = this.getModel().getEntryRowEntity("outcontpayplanentry", rowIndex);
        if (null == rowEntry) {
            return;
        }
        Long sourceId = rowEntry.getLong("conpayitemid");
        DynamicObject payItem = sourceId == 0L ? null : BusinessDataServiceHelper.loadSingle((Object)sourceId, (String)"pmbs_contractpayitem");
        String payItemName = null == payItem ? null : payItem.getString("name");
        Long payItemNodeId = null;
        if (null != payItem && null != payItem.getDynamicObject("nodesetting")) {
            payItemNodeId = payItem.getDynamicObject("nodesetting").getLong("id");
        }
        if (sourceId != 0L && null == this.getPageCache().get("rowIndex") && null != oldValue && null != payItemNodeId && ((DynamicObject)oldValue).getLong("id") == payItemNodeId.longValue()) {
            this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u6761\u76ee\u540d\u79f0\uff1a%s\u7684\u6536\u6b3e\u8282\u70b9\u8bbe\u7f6e\u5df2\u4fee\u6539\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"ContractRevisionEditPlugin_19", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), payItemName), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("nodesetting", (IFormPlugin)this));
            String nodeSettingOldId = oldValue != null ? ((DynamicObject)oldValue).getString("id") : null;
            this.getPageCache().put("oldValue", nodeSettingOldId);
            this.getPageCache().put("rowIndex", String.valueOf(rowIndex));
        } else {
            this.getPageCache().remove("oldValue");
            this.getPageCache().remove("rowIndex");
        }
        if (newValue == null) {
            this.getModel().setValue("ctrlstrategy", null, rowIndex);
            this.getModel().setValue("taskcompletestate", null, rowIndex);
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"ctrlstrategy"});
            return;
        }
        this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"ctrlstrategy"});
        DynamicObject nodeSetting = (DynamicObject)newValue;
        if (null == nodeSetting.getDynamicObjectType().getProperty("completionstatus") && QueryServiceHelper.exists((String)NodeSettingSourceEnum.PMBS_TASK.getValue(), (Object)nodeSetting.getPkValue())) {
            nodeSetting = BusinessDataServiceHelper.loadSingle((Object)nodeSetting.getPkValue(), (String)NodeSettingSourceEnum.PMBS_TASK.getValue());
        }
        String completionStatus = nodeSetting.getString("completionstatus");
        String status = CompletionStatusEnum.OVERDUECOMPLETE.getValue().equals(completionStatus) || CompletionStatusEnum.ONTIMECOMPLETE.getValue().equals(completionStatus) ? TaskCompleteStateEnum.COMPLETE.getValue() : TaskCompleteStateEnum.INCOMPLETE.getValue();
        this.getModel().setValue("taskcompletestate", (Object)status, rowIndex);
    }

    protected void incomeCtrlStrategyChange(int rowIndex, Object newValue, Object oldValue) {
        String incomeItemStrategy;
        if (newValue == oldValue) {
            return;
        }
        DynamicObject rowEntry = this.getModel().getEntryRowEntity("incontpayplanentry", rowIndex);
        Long sourceId = rowEntry.getLong("conincomeitemid");
        DynamicObject incomeItem = sourceId == 0L ? null : BusinessDataServiceHelper.loadSingle((Object)sourceId, (String)"pmbs_contractcollectitem");
        String incomeItemName = null == incomeItem ? null : incomeItem.getString("name");
        String string = incomeItemStrategy = null == incomeItem ? null : incomeItem.getString("ctrlstrategy");
        if (sourceId != 0L && null == this.getPageCache().get("rowIndex") && null != oldValue && incomeItemStrategy != null && incomeItemStrategy.equals(oldValue.toString())) {
            this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u6761\u76ee\u540d\u79f0\uff1a%s\u7684\u63a7\u5236\u7b56\u7565\u5df2\u4fee\u6539\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"ContractRevisionEditPlugin_20", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), incomeItemName), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("incomectrlstrategy", (IFormPlugin)this));
            String ctrlStrategyOldValue = oldValue.toString();
            this.getPageCache().put("oldValue", ctrlStrategyOldValue);
            this.getPageCache().put("rowIndex", String.valueOf(rowIndex));
        } else {
            this.getPageCache().remove("oldValue");
            this.getPageCache().remove("rowIndex");
        }
        if (newValue == null) {
            this.getModel().setValue("incomecompletestate", null, rowIndex);
        }
    }

    protected void incomeNodeSettingChange(int rowIndex, Object newValue, Object oldValue) {
        if (newValue == oldValue) {
            return;
        }
        DynamicObject rowEntry = this.getModel().getEntryRowEntity("incontpayplanentry", rowIndex);
        Long sourceId = rowEntry.getLong("conincomeitemid");
        DynamicObject incomeItem = sourceId == 0L ? null : BusinessDataServiceHelper.loadSingle((Object)sourceId, (String)"pmbs_contractcollectitem");
        String incomeItemName = null == incomeItem ? null : incomeItem.getString("name");
        Long incomeItemNodeId = null;
        if (null != incomeItem && null != incomeItem.getDynamicObject("nodesetting")) {
            incomeItemNodeId = incomeItem.getDynamicObject("nodesetting").getLong("id");
        }
        if (sourceId != 0L && null == this.getPageCache().get("rowIndex") && null != oldValue && null != incomeItemNodeId && ((DynamicObject)oldValue).getLong("id") == incomeItemNodeId.longValue()) {
            this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u6761\u76ee\u540d\u79f0\uff1a%s\u7684\u6536\u6b3e\u8282\u70b9\u8bbe\u7f6e\u5df2\u4fee\u6539\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"ContractRevisionEditPlugin_19", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), incomeItemName), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("incomenodesetting", (IFormPlugin)this));
            String nodeSettingOldId = oldValue != null ? ((DynamicObject)oldValue).getString("id") : null;
            this.getPageCache().put("oldValue", nodeSettingOldId);
            this.getPageCache().put("rowIndex", String.valueOf(rowIndex));
        } else {
            this.getPageCache().remove("oldValue");
            this.getPageCache().remove("rowIndex");
        }
        if (newValue == null) {
            this.getModel().setValue("incomectrlstrategy", null, rowIndex);
            this.getModel().setValue("incomecompletestate", null, rowIndex);
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"incomectrlstrategy"});
            return;
        }
        this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"incomectrlstrategy"});
        DynamicObject nodeSetting = (DynamicObject)newValue;
        if (null == nodeSetting.getDynamicObjectType().getProperty("completionstatus") && QueryServiceHelper.exists((String)NodeSettingSourceEnum.PMBS_TASK.getValue(), (Object)nodeSetting.getPkValue())) {
            nodeSetting = BusinessDataServiceHelper.loadSingle((Object)nodeSetting.getPkValue(), (String)NodeSettingSourceEnum.PMBS_TASK.getValue());
        }
        String completionStatus = nodeSetting.getString("completionstatus");
        String status = CompletionStatusEnum.OVERDUECOMPLETE.getValue().equals(completionStatus) || CompletionStatusEnum.ONTIMECOMPLETE.getValue().equals(completionStatus) ? TaskCompleteStateEnum.COMPLETE.getValue() : TaskCompleteStateEnum.INCOMPLETE.getValue();
        this.getModel().setValue("incomecompletestate", (Object)status, rowIndex);
    }

    private void ctrlStrategyChange(int rowIndex, Object newValue, Object oldValue) {
        String payItemStrategy;
        if (newValue == oldValue) {
            return;
        }
        DynamicObject rowEntry = this.getModel().getEntryRowEntity("outcontpayplanentry", rowIndex);
        Long sourceId = rowEntry.getLong("conpayitemid");
        DynamicObject payItem = sourceId == 0L ? null : BusinessDataServiceHelper.loadSingle((Object)sourceId, (String)"pmbs_contractpayitem");
        String payItemName = null == payItem ? null : payItem.getString("name");
        String string = payItemStrategy = null == payItem ? null : payItem.getString("ctrlstrategy");
        if (sourceId != 0L && null == this.getPageCache().get("rowIndex") && null != oldValue && StringUtils.equals((CharSequence)payItemStrategy, (CharSequence)oldValue.toString())) {
            this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u6761\u76ee\u540d\u79f0\uff1a%s\u7684\u63a7\u5236\u7b56\u7565\u5df2\u4fee\u6539\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"ContractRevisionEditPlugin_20", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), payItemName), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("ctrlstrategy", (IFormPlugin)this));
            String ctrlStrategyOldValue = oldValue.toString();
            this.getPageCache().put("oldValue", ctrlStrategyOldValue);
            this.getPageCache().put("rowIndex", String.valueOf(rowIndex));
        } else {
            this.getPageCache().remove("oldValue");
            this.getPageCache().remove("rowIndex");
        }
        if (newValue == null) {
            this.getModel().setValue("taskcompletestate", null, rowIndex);
        }
    }

    private void compareInEntry(DynamicObject cont) {
        DynamicObjectCollection contInEntries = cont.getDynamicObjectCollection("incontpayplanentry");
        Map contInEntryMap = contInEntries.stream().collect(Collectors.toMap(o -> (Long)o.getPkValue(), Function.identity()));
        int entryRowCount = this.getModel().getEntryRowCount("incontpayplanentry");
        EntryGrid entryGrid = (EntryGrid)this.getControl("incontpayplanentry");
        if (!contInEntries.isEmpty()) {
            for (int i = 0; i < entryRowCount; ++i) {
                DynamicObject inEntry = this.getModel().getEntryRowEntity("incontpayplanentry", i);
                Object resourceId = inEntry.get("insourceid");
                if (resourceId != null && contInEntryMap.get(resourceId) != null) {
                    DynamicObject contInEntry = (DynamicObject)contInEntryMap.get(resourceId);
                    BigDecimal inAmount = Optional.ofNullable(inEntry.getBigDecimal("incomeamount")).orElse(BigDecimal.ZERO);
                    Object inType = Optional.ofNullable(inEntry.get("incometype")).orElse("");
                    BigDecimal inPercent = Optional.ofNullable(inEntry.getBigDecimal("incomepercent")).orElse(BigDecimal.ZERO);
                    Object inPlanTime = Optional.ofNullable(inEntry.get("planincometime")).orElse("");
                    Object inDescription = Optional.ofNullable(inEntry.get("incomedescription")).orElse("");
                    Object incomeMethod = Optional.ofNullable(inEntry.get("incomemethod")).orElse("");
                    if (inAmount.compareTo(contInEntry.getBigDecimal("incomeamount")) != 0) {
                        entryGrid.setRowBackcolor("red", new int[]{i});
                        continue;
                    }
                    if (!inType.equals(contInEntry.get("incometype"))) {
                        entryGrid.setRowBackcolor("red", new int[]{i});
                        continue;
                    }
                    if (inPercent.compareTo(contInEntry.getBigDecimal("incomepercent")) != 0) {
                        entryGrid.setRowBackcolor("red", new int[]{i});
                        continue;
                    }
                    if (!inPlanTime.equals(contInEntry.get("planincometime"))) {
                        entryGrid.setRowBackcolor("red", new int[]{i});
                        continue;
                    }
                    if (!inDescription.equals(contInEntry.get("incomedescription"))) {
                        entryGrid.setRowBackcolor("red", new int[]{i});
                        continue;
                    }
                    if (incomeMethod.equals(contInEntry.get("incomemethod"))) continue;
                    entryGrid.setRowBackcolor("red", new int[]{i});
                    continue;
                }
                entryGrid.setRowBackcolor("green", new int[]{i});
            }
        } else {
            int i = 0;
            while (i < entryRowCount) {
                entryGrid.setRowBackcolor("green", new int[]{i++});
            }
        }
    }

    private void comparePayEntry(DynamicObject cont) {
        DynamicObjectCollection contPayEntries = cont.getDynamicObjectCollection("outcontpayplanentry");
        Map contPayEntryMap = contPayEntries.stream().collect(Collectors.toMap(o -> (Long)o.getPkValue(), Function.identity()));
        int entryRowCount = this.getModel().getEntryRowCount("outcontpayplanentry");
        EntryGrid entryGrid = (EntryGrid)this.getControl("outcontpayplanentry");
        if (!contPayEntries.isEmpty()) {
            for (int i = 0; i < entryRowCount; ++i) {
                DynamicObject viewPayEntry = this.getModel().getEntryRowEntity("outcontpayplanentry", i);
                Long viewPaySourceId = viewPayEntry.getLong("payplansourceid");
                BigDecimal viewPayAmount = Optional.ofNullable(viewPayEntry.getBigDecimal("payamount")).orElse(BigDecimal.ZERO);
                String viewPayType = Optional.ofNullable(viewPayEntry.getString("paytype")).orElse("");
                BigDecimal viewPayPercent = Optional.ofNullable(viewPayEntry.getBigDecimal("paypercent")).orElse(BigDecimal.ZERO);
                Date viewPlanPayTime = viewPayEntry.getDate("planpaytime");
                String viewPayDescription = Optional.ofNullable(viewPayEntry.getString("paydescription")).orElse("");
                String viewPayMethod = Optional.ofNullable(viewPayEntry.getString("paymethod")).orElse("");
                LOG.info("pk:{}, viewPaySourceId:{}, viewPayPercent:{}", new Object[]{viewPayEntry.getPkValue(), viewPaySourceId, viewPayPercent});
                if (viewPaySourceId != 0L && contPayEntryMap.get(viewPaySourceId) != null) {
                    DynamicObject contPayEntry = (DynamicObject)contPayEntryMap.get(viewPaySourceId);
                    if (viewPayAmount.compareTo(contPayEntry.getBigDecimal("payamount")) != 0) {
                        entryGrid.setRowBackcolor("red", new int[]{i});
                        continue;
                    }
                    if (!viewPayType.equals(contPayEntry.get("paytype"))) {
                        entryGrid.setRowBackcolor("red", new int[]{i});
                        continue;
                    }
                    if (viewPayPercent.compareTo(contPayEntry.getBigDecimal("paypercent")) != 0) {
                        entryGrid.setRowBackcolor("red", new int[]{i});
                        continue;
                    }
                    if (viewPlanPayTime == null && contPayEntry.getDate("planpaytime") != null) {
                        entryGrid.setRowBackcolor("red", new int[]{i});
                        continue;
                    }
                    if (viewPlanPayTime != null && contPayEntry.getDate("planpaytime") == null) {
                        entryGrid.setRowBackcolor("red", new int[]{i});
                        continue;
                    }
                    if (viewPlanPayTime != null && contPayEntry.getDate("planpaytime") != null && viewPlanPayTime.compareTo(contPayEntry.getDate("planpaytime")) != 0) {
                        entryGrid.setRowBackcolor("red", new int[]{i});
                        continue;
                    }
                    if (!viewPayDescription.equals(contPayEntry.get("paydescription"))) {
                        entryGrid.setRowBackcolor("red", new int[]{i});
                        continue;
                    }
                    if (viewPayMethod.equals(contPayEntry.get("paymethod"))) continue;
                    entryGrid.setRowBackcolor("red", new int[]{i});
                    continue;
                }
                entryGrid.setRowBackcolor("green", new int[]{i});
            }
        } else {
            int i = 0;
            while (i < entryRowCount) {
                entryGrid.setRowBackcolor("green", new int[]{i++});
            }
        }
    }

    private void compareRiskEntry(DynamicObject cont) {
        DynamicObjectCollection riskEntry = cont.getDynamicObjectCollection("riskentry");
        Map contRiskEntryMap = riskEntry.stream().collect(Collectors.toMap(o -> o.get("id"), Function.identity()));
        int entryRowCount = this.getModel().getEntryRowCount("riskentry");
        EntryGrid entryGrid = (EntryGrid)this.getControl("riskentry");
        if (!riskEntry.isEmpty()) {
            for (int i = 0; i < entryRowCount; ++i) {
                DynamicObject risk = this.getModel().getEntryRowEntity("riskentry", i);
                Object resourceId = risk.get("risksourceid");
                if (resourceId != null && contRiskEntryMap.get(resourceId) != null) {
                    DynamicObject contRiskEntry = (DynamicObject)contRiskEntryMap.get(resourceId);
                    Object riskName = Optional.ofNullable(risk.get("riskname")).orElse("");
                    Object measures = Optional.ofNullable(risk.get("measures")).orElse("");
                    Object isLegalRisk = Optional.ofNullable(risk.get("islegalrisk")).orElse("");
                    Object riskDesc = Optional.ofNullable(risk.get("riskdesc")).orElse("");
                    Object riskType = Optional.ofNullable(risk.get("risktype")).orElse("");
                    if (!riskName.equals(contRiskEntry.get("riskname"))) {
                        this.setCellColor(entryGrid, i, "riskname", "#dee5f7");
                    }
                    if (!measures.equals(contRiskEntry.get("measures"))) {
                        this.setCellColor(entryGrid, i, "measures", "#dee5f7");
                    }
                    if (!isLegalRisk.equals(contRiskEntry.get("islegalrisk"))) {
                        this.setCellColor(entryGrid, i, "islegalrisk", "#dee5f7");
                    }
                    if (!riskDesc.equals(contRiskEntry.get("riskdesc"))) {
                        this.setCellColor(entryGrid, i, "riskdesc", "#dee5f7");
                    }
                    if (riskType.equals(contRiskEntry.get("risktype"))) continue;
                    this.setCellColor(entryGrid, i, "risktype", "#dee5f7");
                    continue;
                }
                entryGrid.setRowBackcolor("#e5f1e9", new int[]{i});
            }
        } else {
            int i = 0;
            while (i < entryRowCount) {
                entryGrid.setRowBackcolor("#e5f1e9", new int[]{i++});
            }
        }
    }

    private void setCellColor(EntryGrid entryGrid, int i, String field, String color) {
        ArrayList<CellStyle> csList = new ArrayList<CellStyle>();
        CellStyle cs = new CellStyle();
        cs.setBackColor(color);
        cs.setFieldKey(field);
        cs.setRow(i);
        csList.add(cs);
        entryGrid.setCellStyle(csList);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        switch (callBackId) {
            case "REVISECONFIRM_CALLBACK": {
                this.getView().close();
                break;
            }
            case "payamountcallback": {
                if (MessageBoxResult.Yes != result) break;
                this.getView().invokeOperation(OPERATION_SUBMIT);
                break;
            }
            case "nodesetting": {
                if (result != MessageBoxResult.Cancel) break;
                Long oldValue = null != this.getPageCache().get("oldValue") ? Long.valueOf(Long.parseLong(this.getPageCache().get("oldValue"))) : null;
                int rowIndex = Integer.parseInt(this.getPageCache().get("rowIndex"));
                this.getModel().setValue("nodesetting", (Object)oldValue, rowIndex);
                break;
            }
            case "ctrlstrategy": {
                if (result != MessageBoxResult.Cancel) break;
                String oldValue = this.getPageCache().get("oldValue");
                int rowIndex = Integer.parseInt(this.getPageCache().get("rowIndex"));
                this.getModel().setValue("ctrlstrategy", (Object)oldValue, rowIndex);
                break;
            }
            case "incomenodesetting": {
                if (result != MessageBoxResult.Cancel) break;
                Long oldValue = null != this.getPageCache().get("oldValue") ? Long.valueOf(Long.parseLong(this.getPageCache().get("oldValue"))) : null;
                int rowIndex = Integer.parseInt(this.getPageCache().get("rowIndex"));
                this.getModel().setValue("incomenodesetting", (Object)oldValue, rowIndex);
                break;
            }
            case "incomectrlstrategy": {
                if (result != MessageBoxResult.Cancel) break;
                String oldValue = this.getPageCache().get("oldValue");
                int rowIndex = Integer.parseInt(this.getPageCache().get("rowIndex"));
                this.getModel().setValue("incomectrlstrategy", (Object)oldValue, rowIndex);
                break;
            }
        }
    }

    private void loadIncomePlanEntry(DynamicObject contract) {
        DynamicObjectCollection viewInContractPayPlanEntries = this.getModel().getEntryEntity("incontpayplanentry");
        if (viewInContractPayPlanEntries.size() > 0) {
            viewInContractPayPlanEntries.clear();
        }
        Object contractPk = contract.getPkValue();
        QFilter contractPkFilter = new QFilter("contract", "=", contractPk);
        QFilter autoGeneratedFilter = new QFilter("autogenerated", "=", (Object)false);
        QFilter sourceFilter = new QFilter("sourcebilltype", "!=", (Object)PayPlanSourceEnum.PERFORM.getValue());
        DynamicObject[] contractPayItemIds = BusinessDataServiceHelper.load((String)"pmbs_contractcollectitem", (String)"id", (QFilter[])new QFilter[]{contractPkFilter, autoGeneratedFilter, sourceFilter});
        DynamicObject[] contractPayItems = BusinessDataServiceHelper.load((Object[])Arrays.stream(contractPayItemIds).map(DataEntityBase::getPkValue).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmbs_contractcollectitem"));
        Arrays.stream(contractPayItems).sorted(Comparator.comparing(o -> o.getDate("createtime"))).forEach(item -> {
            DynamicObject viewConPlanEntry = viewInContractPayPlanEntries.addNew();
            viewConPlanEntry.set("conincomeitemid", item.getPkValue());
            viewConPlanEntry.set("incometype", item.get("collecttype"));
            viewConPlanEntry.set("incomemethod", item.get("collectfeq"));
            viewConPlanEntry.set("incomepercent", item.get("collectpercent"));
            viewConPlanEntry.set("incomeamount", item.get("collectamount"));
            viewConPlanEntry.set("planincometime", item.get("plancollecttime"));
            viewConPlanEntry.set("incomedescription", item.get("remarks"));
            viewConPlanEntry.set("customer", item.get("customer"));
            viewConPlanEntry.set("incomeway", item.get("collectway"));
            viewConPlanEntry.set("incomeplansourceid", item.get("sourcebill"));
            viewConPlanEntry.set("insourceid", item.get("sourcebill"));
            DynamicObject nodeSetting = item.getDynamicObject("nodesetting");
            viewConPlanEntry.set("incomenodesetting", (Object)nodeSetting);
            viewConPlanEntry.set("incomesource", (Object)item.getString("nodesettingsource"));
            viewConPlanEntry.set("incomectrlstrategy", (Object)item.getString("ctrlstrategy"));
            viewConPlanEntry.set("incomeitemname", (Object)item.getString("name"));
        });
        for (int i = 0; i < viewInContractPayPlanEntries.size(); ++i) {
            this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"supplier"});
            DynamicObject entryEntity = (DynamicObject)viewInContractPayPlanEntries.get(i);
            if (null != entryEntity.get("incomenodesetting")) continue;
            this.getView().setEnable(Boolean.FALSE, i, new String[]{"incomectrlstrategy"});
        }
    }

    private void loadOutContPlanEntry(DynamicObject contract) {
        DynamicObjectCollection entries = this.getModel().getEntryEntity("outcontpayplanentry");
        if (entries.size() > 0) {
            entries.clear();
        }
        Object contractPk = contract.getPkValue();
        QFilter contractPkFilter = new QFilter("contract", "=", contractPk);
        QFilter autoGeneratedFilter = new QFilter("autogenerated", "=", (Object)false);
        QFilter sourceFilter = new QFilter("source", "=", (Object)ContractPayItemSourceEnum.PAYPLAN.getValue());
        DynamicObject[] contractPayItemIds = BusinessDataServiceHelper.load((String)"pmbs_contractpayitem", (String)"id", (QFilter[])new QFilter[]{contractPkFilter, autoGeneratedFilter, sourceFilter});
        DynamicObject[] contractPayItems = BusinessDataServiceHelper.load((Object[])Arrays.stream(contractPayItemIds).map(DataEntityBase::getPkValue).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmbs_contractpayitem"));
        Arrays.stream(contractPayItems).sorted(Comparator.comparing(o -> o.getDate("createtime"))).forEach(item -> {
            DynamicObject conPlanEntry = entries.addNew();
            conPlanEntry.set("conpayitemid", item.getPkValue());
            conPlanEntry.set("paytype", item.get("paytype"));
            conPlanEntry.set("paymethod", item.get("payfeq"));
            conPlanEntry.set("paypercent", item.get("paypercent"));
            conPlanEntry.set("payamount", item.get("payamount"));
            conPlanEntry.set("planpaytime", item.get("planpaytime"));
            conPlanEntry.set("paydescription", item.get("remarks"));
            conPlanEntry.set("supplier", item.get("supplier"));
            conPlanEntry.set("payway", item.get("payway"));
            conPlanEntry.set("payplansourceid", item.get("payplanentryid"));
            conPlanEntry.set("paysourceid", item.get("payplanentryid"));
            DynamicObject nodeSetting = item.getDynamicObject("nodesetting");
            conPlanEntry.set("nodesetting", (Object)nodeSetting);
            if (null != nodeSetting && QueryServiceHelper.exists((String)NodeSettingSourceEnum.PMBS_TASK.getValue(), (Object)nodeSetting.getPkValue())) {
                nodeSetting = BusinessDataServiceHelper.loadSingle((Object)nodeSetting.getPkValue(), (String)NodeSettingSourceEnum.PMBS_TASK.getValue());
                String completionStatus = nodeSetting.getString("completionstatus");
                String status = CompletionStatusEnum.ONTIMECOMPLETE.getValue().equals(completionStatus) || CompletionStatusEnum.OVERDUECOMPLETE.getValue().equals(completionStatus) ? TaskCompleteStateEnum.COMPLETE.getValue() : TaskCompleteStateEnum.INCOMPLETE.getValue();
                conPlanEntry.set("taskcompletestate", (Object)status);
            }
            conPlanEntry.set("nodesettingsource", (Object)item.getString("nodesettingsource"));
            conPlanEntry.set("ctrlstrategy", (Object)item.getString("ctrlstrategy"));
            conPlanEntry.set("conpayitemid", (Object)item.getPkValue().toString());
        });
        boolean isMultiContract = contract.getBoolean("ismulticontract");
        if (!isMultiContract) {
            for (int i = 0; i < entries.size(); ++i) {
                this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"supplier"});
                DynamicObject entryEntity = (DynamicObject)entries.get(i);
                if (null != entryEntity.get("nodesetting")) continue;
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"ctrlstrategy"});
            }
        }
    }

    private void supplierByMultiContract(DynamicObject contract) {
        boolean isMultiContract = contract.getBoolean("ismulticontract");
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"supplier"});
        if (isMultiContract) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"supplier"});
        }
    }

    private void loadRiskEntry(DynamicObject contract) {
        DynamicObjectCollection entries = this.getModel().getEntryEntity("riskentry");
        DynamicObjectCollection riskEntries = contract.getDynamicObjectCollection("riskentry");
        QFilter contFilter = new QFilter("contract", "=", contract.getPkValue()).and("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
        DynamicObject[] contractRevisions = BusinessDataServiceHelper.load((String)"pmct_contractrevision", (String)String.join((CharSequence)",", "id"), (QFilter[])new QFilter[]{contFilter}, (String)"versionnumber desc");
        if (contractRevisions.length > 0) {
            for (DynamicObject contractRevision : contractRevisions) {
                DynamicObjectCollection revisionRiskEntries = (contractRevision = BusinessDataServiceHelper.loadSingle((Object)contractRevision.getPkValue(), (String)"pmct_contractrevision")).getDynamicObjectCollection("riskentry");
                if (revisionRiskEntries == null || revisionRiskEntries.isEmpty()) continue;
                riskEntries = revisionRiskEntries;
                break;
            }
        }
        entries.clear();
        DynamicObjectType dt = entries.getDynamicObjectType();
        for (DynamicObject riskEntry : riskEntries) {
            DynamicObject item = new DynamicObject(dt);
            item.set("risktype", riskEntry.get("risktype"));
            item.set("riskname", riskEntry.get("riskname"));
            item.set("riskdesc", riskEntry.get("riskdesc"));
            item.set("risksourceid", riskEntry.getPkValue());
            item.set("measures", riskEntry.get("measures"));
            item.set("islegalrisk", riskEntry.get("islegalrisk"));
            entries.add((Object)item);
        }
    }

    private void loadHeadFields(DynamicObject contract) {
        Object contractPk = contract.getPkValue();
        this.getModel().setValue("contract", contractPk);
        this.getModel().setValue("contractname", contract.get("billname"));
        this.getModel().setValue("contractno", contract.get("billno"));
        String payDirection = contract.getString(PAGE_CACHE_PAY_DIRECTION);
        if (payDirection.equalsIgnoreCase(PayDirectionEnum.OUT.getValue())) {
            this.getModel().setValue("payrate", contract.get("payrate"));
            this.getModel().setValue("outpercentmodel", contract.get("percentmodel"));
        } else {
            this.getModel().setValue("inpercentmodel", contract.get("percentmodel"));
        }
        this.getModel().setValue("description", contract.get("description"));
        this.getModel().setValue("versionnumber", (Object)contract.getBigDecimal("versionnumber").add(BigDecimal.valueOf(1L)));
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        super.beforeF7Select(event);
        String name = event.getProperty().getName();
        if (StringUtils.equals((CharSequence)"supplier", (CharSequence)name)) {
            Object contractId = this.getView().getFormShowParameter().getCustomParam(PAGE_CACHE_CONTRACT_ID);
            DynamicObject contract = BusinessDataServiceHelper.loadSingle((Object)contractId, (String)"pmct_outcontract");
            DynamicObject partB = contract.getDynamicObject("partb");
            DynamicObjectCollection otherParts = contract.getDynamicObjectCollection("otherpart");
            QFilter supplierIdFilter = ContractSupplierHelper.getContractSupplierFilter((DynamicObject)partB, (DynamicObjectCollection)otherParts);
            event.addCustomQFilter(supplierIdFilter);
        } else if (StringUtils.equals((CharSequence)"nodesetting", (CharSequence)name)) {
            this.beforeSelectNodeSetting((ListShowParameter)event.getFormShowParameter(), "nodesetting");
        } else if (StringUtils.equals((CharSequence)"incomenodesetting", (CharSequence)name)) {
            this.beforeSelectNodeSetting((ListShowParameter)event.getFormShowParameter(), "incomenodesetting");
        }
    }

    protected void beforeSelectNodeSetting(ListShowParameter param, String fieldKey) {
        DynamicObject contract = this.getModel().getDataEntity().getDynamicObject("contract");
        if (null == contract) {
            return;
        }
        DynamicObject project = contract.getDynamicObject("project");
        param.setFormId("bos_listf7");
        QFilter qFilter = new QFilter("project", "=", null != project ? project.getPkValue() : Long.valueOf(1L));
        param.getListFilterParameter().getQFilters().add(qFilter);
        QFilter txTypeFilter = "nodesetting".equals(fieldKey) ? new QFilter("number", "=", (Object)"004") : new QFilter("number", "=", (Object)"003");
        DynamicObject txType = BusinessDataServiceHelper.loadSingle((String)"pmpt_transactiontype", (String)"id", (QFilter[])new QFilter[]{txTypeFilter});
        qFilter = new QFilter(String.join((CharSequence)".", "transactiontype", "fbasedataid_id"), "in", txType.getPkValue());
        param.getListFilterParameter().getQFilters().add(qFilter);
        qFilter = new QFilter("islatest", "=", (Object)true);
        param.getListFilterParameter().getQFilters().add(qFilter);
    }

    public Map<String, Map<Object, String>> getSrcObjCompleteMap(DynamicObject[] incomeItems) {
        Set taskSet;
        HashMap sourceToObjIdsMap = new HashMap(3);
        for (DynamicObject incomeItem : incomeItems) {
            Set<Object> nodeObjSet;
            DynamicObject[] incomeNodeSetting = incomeItem.getDynamicObject("incomenodesetting");
            if (incomeNodeSetting == null) continue;
            String nodeSettingSource = incomeItem.getString("incomesource");
            if (sourceToObjIdsMap.containsKey(nodeSettingSource)) {
                nodeObjSet = (Set)sourceToObjIdsMap.get(nodeSettingSource);
                nodeObjSet.add(incomeNodeSetting.getPkValue());
                continue;
            }
            nodeObjSet = new HashSet();
            nodeObjSet.add(incomeNodeSetting.getPkValue());
            sourceToObjIdsMap.put(nodeSettingSource, nodeObjSet);
        }
        HashMap<String, Map<Object, String>> srcObjCompleteMap = new HashMap<String, Map<Object, String>>(3);
        if (sourceToObjIdsMap.containsKey(NodeSettingSourceEnum.PMBS_TASK.getValue()) && (taskSet = (Set)sourceToObjIdsMap.get(NodeSettingSourceEnum.PMBS_TASK.getValue())) != null && !taskSet.isEmpty()) {
            DynamicObject[] tasks = BusinessDataServiceHelper.load((String)NodeSettingSourceEnum.PMBS_TASK.getValue(), (String)"percent,completionstatus,islatest,sourcetask", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)taskSet)});
            HashMap<Long, Object> srcToCurTaskMap = new HashMap<Long, Object>(tasks.length);
            for (DynamicObject task : tasks) {
                srcToCurTaskMap.put(task.getLong("sourcetask.id"), task.getPkValue());
            }
            taskSet = Arrays.stream(tasks).map(o -> o.getLong("sourcetask.id")).collect(Collectors.toSet());
            tasks = BusinessDataServiceHelper.load((String)NodeSettingSourceEnum.PMBS_TASK.getValue(), (String)"percent,completionstatus,islatest,sourcetask", (QFilter[])new QFilter[]{new QFilter("sourcetask", "in", taskSet), new QFilter("islatest", "=", (Object)DefaultEnum.YES.getValue())});
            HashMap nodeObjCompMap = new HashMap();
            for (DynamicObject task : tasks) {
                String completionStatus = task.getString("completionstatus");
                int percent = task.getInt("percent");
                if (StringUtils.equals((CharSequence)completionStatus, (CharSequence)CompletionStatusEnum.ONTIMECOMPLETE.getValue()) || StringUtils.equals((CharSequence)completionStatus, (CharSequence)CompletionStatusEnum.OVERDUECOMPLETE.getValue()) || percent == 100) {
                    nodeObjCompMap.put(srcToCurTaskMap.get(task.getLong("sourcetask.id")), TaskCompleteStateEnum.COMPLETE.getValue());
                    continue;
                }
                nodeObjCompMap.put(srcToCurTaskMap.get(task.getLong("sourcetask.id")), TaskCompleteStateEnum.INCOMPLETE.getValue());
            }
            srcObjCompleteMap.put(NodeSettingSourceEnum.PMBS_TASK.getValue(), nodeObjCompMap);
        }
        return srcObjCompleteMap;
    }

    private void recountPayPlan() {
        DynamicObject contract = this.getContract();
        String payDirection = contract.getString(PAGE_CACHE_PAY_DIRECTION);
        HashMap<String, String> paramMap = new HashMap<String, String>(16);
        if (PayDirectionEnum.OUT.getValue().equals(payDirection)) {
            paramMap.put("planEntry", "outcontpayplanentry");
            paramMap.put("percentModel", "outpercentmodel");
            paramMap.put("payPercent", "paypercent");
            paramMap.put("payAmount", "payamount");
            paramMap.put("Originaloftaxamount", "originaloftaxamount");
            ContractEditHelper.recountPayPlan((IFormView)this.getView(), paramMap);
        } else if (PayDirectionEnum.IN.getValue().equals(payDirection)) {
            paramMap.put("planEntry", "incontpayplanentry");
            paramMap.put("percentModel", "inpercentmodel");
            paramMap.put("payPercent", "incomepercent");
            paramMap.put("payAmount", "incomeamount");
            paramMap.put("Originaloftaxamount", "originaloftaxamount");
            ContractEditHelper.recountPayPlan((IFormView)this.getView(), paramMap);
        }
    }
}

