/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.formplugin.task;

import java.util.Date;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmgt.pmbs.common.enums.AgreementStatusEnum;
import kd.pmgt.pmbs.common.enums.DefaultEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;

public class StrategicAgreementTask
extends AbstractTask {
    public void execute(RequestContext arg0, Map<String, Object> arg1) throws KDException {
        this.updateStatus();
    }

    public void updateStatus() {
        Date currentDate = new Date();
        String[] filter = new String[]{AgreementStatusEnum.CANCEL.getValue(), AgreementStatusEnum.SUSPEND.getValue()};
        QFilter statusFilter = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue()).and("issign", "=", (Object)DefaultEnum.YES.getValue()).and("agreementstate", "not in", (Object)filter);
        StringBuilder selectors = new StringBuilder();
        selectors.append("agreementvaliddate").append(',').append("agreementexpiredate").append(',').append("agreementstate");
        DynamicObject[] agreements = BusinessDataServiceHelper.load((String)"pmct_strategicagreement", (String)selectors.toString(), (QFilter[])new QFilter[]{statusFilter});
        if (agreements.length > 0) {
            for (DynamicObject agreement : agreements) {
                Date startDate = agreement.getDate("agreementvaliddate");
                Date endDate = agreement.getDate("agreementexpiredate");
                if (currentDate.before(startDate)) {
                    agreement.set("agreementstate", (Object)AgreementStatusEnum.UNEFFECT.getValue());
                    continue;
                }
                if (currentDate.compareTo(startDate) >= 0 && currentDate.compareTo(endDate) <= 0) {
                    agreement.set("agreementstate", (Object)AgreementStatusEnum.EFFECTING.getValue());
                    continue;
                }
                if (!currentDate.after(endDate)) continue;
                agreement.set("agreementstate", (Object)AgreementStatusEnum.EXPIRE.getValue());
            }
            SaveServiceHelper.update((DynamicObject[])agreements);
        }
    }
}

