/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.formplugin.writeback;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.botp.plugin.args.AfterSaveSourceBillEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmct.formplugin.base.AbstractPmctWriteBackPlugin;

public class PaymentRegisterWriteBackPlugin
extends AbstractPmctWriteBackPlugin {
    public void afterSaveSourceBill(AfterSaveSourceBillEventArgs e) {
        super.afterSaveSourceBill(e);
        for (DynamicObject entity : e.getSrcDataEntities()) {
            ArrayList<DynamicObject> itemList = new ArrayList<DynamicObject>();
            Object pkValue = entity.getPkValue();
            DynamicObject paymentApply = BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)"pmct_paymentapply");
            DynamicObjectCollection entryEntity = paymentApply.getDynamicObjectCollection("entryentity");
            for (DynamicObject contractInfo : entryEntity) {
                DynamicObject payItem = contractInfo.getDynamicObject("payitem");
                if (payItem == null) continue;
                BigDecimal paidAmount = this.getPaymentApplyPaidAmountByItemId(payItem.getLong("id"));
                payItem.set("paidamount", (Object)paidAmount);
                itemList.add(payItem);
            }
            SaveServiceHelper.save((DynamicObject[])itemList.toArray(new DynamicObject[0]));
        }
    }

    private BigDecimal getPaymentApplyPaidAmountByItemId(Long itemId) {
        QFilter itemIdFilter = new QFilter("entryentity.payitem", "=", (Object)itemId);
        QFilter statusFilter = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
        DynamicObject[] list = BusinessDataServiceHelper.load((String)"pmct_paymentapply", (String)"id", (QFilter[])new QFilter[]{itemIdFilter, statusFilter});
        Object[] pkArray = Arrays.stream(list).map(dyn -> dyn.get("id")).toArray();
        DynamicObject[] paymentApplyList = BusinessDataServiceHelper.load((Object[])pkArray, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmct_paymentapply"));
        BigDecimal paidAmount = BigDecimal.ZERO;
        for (DynamicObject apply : paymentApplyList) {
            DynamicObjectCollection entryEntity = apply.getDynamicObjectCollection("entryentity");
            for (DynamicObject info : entryEntity) {
                DynamicObject payItem = info.getDynamicObject("payitem");
                if (payItem == null || payItem.getLong("id") != itemId.longValue()) continue;
                paidAmount = paidAmount.add(info.getBigDecimal("entrypaidamount"));
            }
        }
        return paidAmount;
    }
}

