/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmdc.opplugin.collectmanage;

import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmgt.pmbs.common.enums.EnableEnum;
import kd.pmgt.pmdc.opplugin.validate.CollectManageValidator;

public class CollectManageOp
extends AbstractOperationServicePlugIn {
    private static final Log log = LogFactory.getLog(CollectManageOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("fileno");
        e.getFieldKeys().add("creator");
        e.getFieldKeys().add("createtime");
        e.getFieldKeys().add("modifytime");
        e.getFieldKeys().add("modifier");
        e.getFieldKeys().add("billstatus");
        e.getFieldKeys().add("docitem");
        e.getFieldKeys().add("group");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.getValidators().add(new CollectManageValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        String operateKey = e.getOperationKey();
        DynamicObject[] entities = e.getDataEntities();
        switch (operateKey) {
            case "audit": {
                for (DynamicObject entity : entities) {
                    DynamicObject[] collectRecords;
                    DynamicObjectCollection collectRecordCollection = entity.getDynamicObjectCollection("collectentry");
                    QFilter pkFilter = new QFilter("id", "in", collectRecordCollection.stream().map(DataEntityBase::getPkValue).collect(Collectors.toSet()));
                    for (DynamicObject collectRecord : collectRecords = BusinessDataServiceHelper.load((String)"pmdc_collectrecord", (String)"id, doclibname, collectperson, createtime, group, status, docitem, enable", (QFilter[])new QFilter[]{pkFilter})) {
                        DynamicObject docDirectory = collectRecord.getDynamicObject("group");
                        docDirectory = BusinessDataServiceHelper.loadSingle((Object)docDirectory.getPkValue(), (String)"pmdc_docdirectory");
                        collectRecord.set("name", collectRecord.getDynamicObject("docitem").get("name"));
                        collectRecord.set("doclibname", (Object)docDirectory.getDynamicObject("doclibname"));
                        collectRecord.set("collectperson", entity.get("creator"));
                        collectRecord.set("createtime", entity.get("createtime"));
                        collectRecord.set("status", entity.get("billstatus"));
                        collectRecord.set("enable", (Object)EnableEnum.ENABLE.getValue());
                    }
                    SaveServiceHelper.update((DynamicObject[])collectRecords);
                }
                break;
            }
            case "unaudit": {
                for (DynamicObject entity : entities) {
                    DynamicObject[] collectRecords;
                    DynamicObjectCollection collectRecordCollection = entity.getDynamicObjectCollection("collectentry");
                    QFilter pkFilter = new QFilter("id", "in", collectRecordCollection.stream().map(DataEntityBase::getPkValue).collect(Collectors.toSet()));
                    for (DynamicObject collectRecord : collectRecords = BusinessDataServiceHelper.load((String)"pmdc_collectrecord", (String)"id, doclibname, collectperson, createtime, group, status, enable, modifier, modifytime", (QFilter[])new QFilter[]{pkFilter})) {
                        collectRecord.set("modifier", entity.get("modifier"));
                        collectRecord.set("modifytime", entity.get("modifytime"));
                        collectRecord.set("status", entity.get("billstatus"));
                        collectRecord.set("enable", (Object)EnableEnum.DISABLE.getValue());
                    }
                    SaveServiceHelper.update((DynamicObject[])collectRecords);
                }
                break;
            }
        }
    }
}

