/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmdc.opplugin.docapply;

import java.util.Arrays;
import java.util.Date;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentDto;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.attachment.AttachmentFieldServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmgt.pmbs.common.enums.EnableEnum;
import kd.pmgt.pmdc.opplugin.validate.DocApplyValidator;
import org.jetbrains.annotations.NotNull;

public class DocApplyOp
extends AbstractOperationServicePlugIn {
    private static final Log log = LogFactory.getLog(DocApplyOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("billstatus");
        e.getFieldKeys().add("billno");
        e.getFieldKeys().add("billname");
        e.getFieldKeys().add("project");
        e.getFieldKeys().add("org");
        e.getFieldKeys().add("attachment");
        e.getFieldKeys().add("fileno");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.getValidators().add(new DocApplyValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        String operateKey = e.getOperationKey();
        DynamicObject[] entities = e.getDataEntities();
        switch (operateKey) {
            case "unaudit": {
                for (DynamicObject entity : entities) {
                    DynamicObject[] docItems;
                    for (DynamicObject docItem : docItems = this.setDocItemStatus(entity)) {
                        docItem.set("enable", (Object)EnableEnum.ENABLE.getValue());
                        docItem.set("status", entity.get("billstatus"));
                    }
                    SaveServiceHelper.update((DynamicObject[])docItems);
                }
                break;
            }
            case "audit": {
                for (DynamicObject entity : entities) {
                    DynamicObject[] docItems = this.setDocItemStatus(entity);
                    DynamicObjectCollection docItemCollection = entity.getDynamicObjectCollection("entryentity");
                    for (DynamicObject docItemEntry : docItemCollection) {
                        MulBasedataDynamicObjectCollection att = (MulBasedataDynamicObjectCollection)docItemEntry.get("attachment");
                        AttachmentDto attachmentInfoByAttPk = AttachmentFieldServiceHelper.getAttachmentInfoByAttPk((Object)((DynamicObject)att.get(0)).get("fbasedataId_id"));
                        DynamicObject docItem = Arrays.stream(docItems).filter(it -> it.getPkValue().toString().equals(docItemEntry.getPkValue().toString())).findFirst().orElse(null);
                        if (docItem == null) continue;
                        docItem.set("resourcepath", (Object)attachmentInfoByAttPk.getResourcePath());
                        docItem.set("number", (Object)attachmentInfoByAttPk.getFilename());
                        docItem.set("name", (Object)attachmentInfoByAttPk.getFilename());
                        docItem.set("enable", (Object)EnableEnum.ENABLE.getValue());
                    }
                    SaveServiceHelper.update((DynamicObject[])docItems);
                }
                break;
            }
        }
    }

    @NotNull
    private DynamicObject[] setDocItemStatus(DynamicObject entity) {
        DynamicObject[] docItems;
        Object billStatus = entity.get("billstatus");
        DynamicObjectCollection docItemCollection = entity.getDynamicObjectCollection("entryentity");
        QFilter pkFilter = new QFilter("id", "in", docItemCollection.stream().map(DataEntityBase::getPkValue).collect(Collectors.toSet()));
        for (DynamicObject docItem : docItems = BusinessDataServiceHelper.load((String)"pmdc_docitem", (String)"id, status, enable, doctype, resourcepath, sourcebill, createtime, org, createorg, useorg, project, billdataid, sourcebillno", (QFilter[])new QFilter[]{pkFilter})) {
            DynamicObject docItemEntry = docItemCollection.stream().filter(it -> it.getPkValue().toString().equals(docItem.getPkValue().toString())).findFirst().orElse(null);
            if (docItemEntry == null) continue;
            MulBasedataDynamicObjectCollection att = (MulBasedataDynamicObjectCollection)docItemEntry.get("attachment");
            if (!att.isEmpty()) {
                ILocaleString attName = ((DynamicObject)((DynamicObject)att.get(0)).get("fbasedataid")).getLocaleString("name");
                docItem.set("number", (Object)attName);
                docItem.set("name", (Object)attName);
            }
            docItem.set("org", (Object)entity.getDynamicObject("org"));
            docItem.set("createorg", (Object)entity.getDynamicObject("org"));
            docItem.set("useorg", (Object)entity.getDynamicObject("org"));
            docItem.set("project", (Object)entity.getDynamicObject("project"));
            docItem.set("createtime", (Object)new Date());
            docItem.set("status", billStatus);
            docItem.set("doctype", (Object)2);
            docItem.set("sourcebill", (Object)entity.getDynamicObjectType().getName());
            docItem.set("billdataid", entity.getPkValue());
            docItem.set("sourcebillno", (Object)entity.getString("billno"));
        }
        return docItems;
    }
}

