/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmdc.opplugin.validate;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class CollectManageValidator
extends AbstractValidator {
    public void validate() {
        String operateKey = this.getOperateKey();
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        switch (operateKey) {
            case "save": {
                for (ExtendedDataEntity entity : dataEntities) {
                    DynamicObject bill = entity.getDataEntity();
                    DynamicObjectCollection entries = bill.getDynamicObjectCollection("collectentry");
                    if (!entries.isEmpty()) continue;
                    this.addErrorMessage(entity, ResManager.loadKDString((String)"\u8bf7\u6dfb\u52a0\u9644\u4ef6\u3002", (String)"CollectManageValidator_0", (String)"pmgt-pmdc-opplugin", (Object[])new Object[0]));
                }
                break;
            }
            case "submit": {
                List docItemPkAndDocLibNamePkStringList = Arrays.stream(dataEntities).map(ExtendedDataEntity::getDataEntity).map(it -> it.getDynamicObjectCollection("collectentry")).flatMap(Collection::stream).filter(it -> it.getDynamicObject("group") != null).filter(it -> StringUtils.isNotBlank((CharSequence)it.getString("fileno"))).map(it -> String.format("%s,%s", it.getDynamicObject("group").getDynamicObject("doclibname").getPkValue().toString(), it.getString("fileno"))).collect(Collectors.toList());
                HashSet docItemPkAndDocLibNamePkStringSet = new HashSet(docItemPkAndDocLibNamePkStringList);
                if (docItemPkAndDocLibNamePkStringList.size() != docItemPkAndDocLibNamePkStringSet.size()) {
                    for (ExtendedDataEntity entity : dataEntities) {
                        this.addErrorMessage(entity, ResManager.loadKDString((String)"\u5b58\u5728\u91cd\u590d\u5f52\u6863\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"CollectManageValidator_3", (String)"pmgt-pmdc-opplugin", (Object[])new Object[0]));
                    }
                } else {
                    for (ExtendedDataEntity entity : dataEntities) {
                        DynamicObject bill = entity.getDataEntity();
                        DynamicObjectCollection entries = bill.getDynamicObjectCollection("collectentry");
                        if (entries.isEmpty()) {
                            this.addErrorMessage(entity, ResManager.loadKDString((String)"\u8bf7\u6dfb\u52a0\u9644\u4ef6\u3002", (String)"CollectManageValidator_0", (String)"pmgt-pmdc-opplugin", (Object[])new Object[0]));
                            continue;
                        }
                        StringBuilder tips = new StringBuilder();
                        for (int i = 0; i < entries.size(); ++i) {
                            Object docLibInDocItem;
                            QFilter idFilter;
                            QFilter fileNoFilter;
                            DynamicObject collectManageEntry = (DynamicObject)entries.get(i);
                            String fileNo = collectManageEntry.getString("fileno");
                            if (StringUtils.isEmpty((CharSequence)fileNo)) continue;
                            DynamicObject docDirectory = collectManageEntry.getDynamicObject("group");
                            DynamicObject docLibName = docDirectory.getDynamicObject("doclibname");
                            QFilter docLibNameFilter = new QFilter("doclibname", "=", docLibName.getPkValue());
                            boolean exists = QueryServiceHelper.exists((String)"pmdc_collectrecord", (QFilter[])new QFilter[]{docLibNameFilter, fileNoFilter = new QFilter("fileno", "=", (Object)fileNo), idFilter = new QFilter("id", "!=", collectManageEntry.getPkValue())});
                            if (exists) {
                                tips.append(String.format(ResManager.loadKDString((String)"\u9644\u4ef6\u7b2c%1$s\u884c\uff0c%2$s\u5e93%3$s\u76ee\u5f55\u4e0b\uff0c\u6863\u6848\u53f7\u6709\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u3002%n", (String)"CollectManageValidator_2", (String)"pmgt-pmdc-opplugin", (Object[])new Object[0]), i + 1, docLibName.getLocaleString("name").getLocaleValue(), docDirectory.getLocaleString("name").getLocaleValue()));
                                continue;
                            }
                            QFilter docLibNamePksFilter = new QFilter("group.doclibname", "=", docLibName.getPkValue());
                            fileNoFilter = new QFilter("fileno", "=", (Object)fileNo);
                            QFilter docTypeFilter = new QFilter("doctype", "=", (Object)"2");
                            QFilter pkFilter = new QFilter("id", "!=", collectManageEntry.getPkValue());
                            exists = QueryServiceHelper.exists((String)"pmdc_docitem", (QFilter[])new QFilter[]{pkFilter, docLibNamePksFilter, fileNoFilter, docTypeFilter});
                            if (exists) {
                                tips.append(String.format(ResManager.loadKDString((String)"\u9644\u4ef6\u7b2c%1$s\u884c\uff0c%2$s\u5e93%3$s\u76ee\u5f55\u4e0b\uff0c\u6863\u6848\u53f7\u6709\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u3002%n", (String)"CollectManageValidator_2", (String)"pmgt-pmdc-opplugin", (Object[])new Object[0]), i + 1, docLibName.getLocaleString("name").getLocaleValue(), docDirectory.getLocaleString("name").getLocaleValue()));
                            }
                            if ((docLibInDocItem = (docDirectory = BusinessDataServiceHelper.loadSingle((Object)collectManageEntry.getDynamicObject("docitem").getDynamicObject("group").getPkValue(), (String)"pmdc_docdirectory")).getDynamicObject("doclibname").getPkValue()) == null || !StringUtils.equals((CharSequence)docLibInDocItem.toString(), (CharSequence)docLibName.getPkValue().toString())) continue;
                            tips.append(String.format(ResManager.loadKDString((String)"\u9644\u4ef6\u7b2c%1$s\u884c\uff0c\u5728%2$s\u5e93\u4e2d\u5b58\u5728\u91cd\u590d\u5f52\u6863\uff0c\u8bf7\u4fee\u6539\u3002%n", (String)"CollectManageValidator_4", (String)"pmgt-pmdc-opplugin", (Object[])new Object[0]), i + 1, docLibName.getLocaleString("name").getLocaleValue()));
                        }
                        if (!StringUtils.isNotEmpty((CharSequence)tips.toString())) continue;
                        this.addErrorMessage(entity, tips.toString());
                    }
                }
                break;
            }
        }
    }
}

