/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmdc.opplugin.validate;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.pmgt.pmbs.common.enums.EnableEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;

public class DocApplyValidator
extends AbstractValidator {
    private static final String ORIGINAL_DOC_LIB_NUMBER = "originaldoclib";

    public void validate() {
        String operateKey = this.getOperateKey();
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        switch (operateKey) {
            case "save": {
                for (ExtendedDataEntity entity : dataEntities) {
                    DynamicObject bill = entity.getDataEntity();
                    DynamicObjectCollection entries = bill.getDynamicObjectCollection("entryentity");
                    if (!entries.isEmpty()) continue;
                    this.addErrorMessage(entity, ResManager.loadKDString((String)"\u8bf7\u6dfb\u52a0\u9644\u4ef6\u3002", (String)"DocApplyValidator_0", (String)"pmgt-pmdc-opplugin", (Object[])new Object[0]));
                }
                break;
            }
            case "submit": {
                List docItemPkAndDocLibNamePkStringList = Arrays.stream(dataEntities).map(ExtendedDataEntity::getDataEntity).map(it -> it.getDynamicObjectCollection("entryentity")).flatMap(Collection::stream).filter(it -> it.getDynamicObject("docdirectory") != null).filter(it -> StringUtils.isNotBlank((CharSequence)it.getString("fileno"))).map(it -> String.format("%s,%s", it.getDynamicObject("docdirectory").getDynamicObject("doclibname").getPkValue().toString(), it.getString("fileno"))).collect(Collectors.toList());
                HashSet docItemPkAndDocLibNamePkStringSet = new HashSet(docItemPkAndDocLibNamePkStringList);
                if (docItemPkAndDocLibNamePkStringList.size() != docItemPkAndDocLibNamePkStringSet.size()) {
                    for (ExtendedDataEntity entity : dataEntities) {
                        this.addErrorMessage(entity, ResManager.loadKDString((String)"\u5b58\u5728\u91cd\u590d\u5f52\u6863\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"DocApplyValidator_1", (String)"pmgt-pmdc-opplugin", (Object[])new Object[0]));
                    }
                } else {
                    for (ExtendedDataEntity entity : dataEntities) {
                        DynamicObject bill = entity.getDataEntity();
                        DynamicObjectCollection entries = bill.getDynamicObjectCollection("entryentity");
                        if (entries.isEmpty()) {
                            this.addErrorMessage(entity, ResManager.loadKDString((String)"\u8bf7\u6dfb\u52a0\u9644\u4ef6\u3002", (String)"DocApplyValidator_0", (String)"pmgt-pmdc-opplugin", (Object[])new Object[0]));
                            continue;
                        }
                        StringBuilder tips = new StringBuilder();
                        for (int i = 0; i < entries.size(); ++i) {
                            QFilter fileNoFilter;
                            DynamicObject docApplyEntry = (DynamicObject)entries.get(i);
                            String fileNo = docApplyEntry.getString("fileno");
                            if (StringUtils.isEmpty((CharSequence)fileNo)) continue;
                            DynamicObject docDirectory = docApplyEntry.getDynamicObject("docdirectory");
                            DynamicObject docLibName = docDirectory.getDynamicObject("doclibname");
                            QFilter docLibNameFilter = new QFilter("doclibname", "=", docLibName.getPkValue());
                            boolean exists = QueryServiceHelper.exists((String)"pmdc_collectrecord", (QFilter[])new QFilter[]{docLibNameFilter, fileNoFilter = new QFilter("fileno", "=", (Object)fileNo)});
                            if (exists) {
                                tips.append(String.format(ResManager.loadKDString((String)"\u9644\u4ef6\u7b2c%1$s\u884c\uff0c%2$s\u5e93%3$s\u76ee\u5f55\u4e0b\uff0c\u6863\u6848\u53f7\u6709\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u3002%n", (String)"DocApplyValidator_2", (String)"pmgt-pmdc-opplugin", (Object[])new Object[0]), i + 1, docLibName.getLocaleString("name").getLocaleValue(), docDirectory.getLocaleString("name").getLocaleValue()));
                                continue;
                            }
                            QFilter docLibNamePksFilter = new QFilter("group.doclibname", "=", docLibName.getPkValue());
                            fileNoFilter = new QFilter("fileno", "=", (Object)fileNo);
                            QFilter docTypeFilter = new QFilter("doctype", "=", (Object)"2");
                            QFilter pkFilter = new QFilter("id", "!=", docApplyEntry.getPkValue());
                            exists = QueryServiceHelper.exists((String)"pmdc_docitem", (QFilter[])new QFilter[]{pkFilter, docLibNamePksFilter, fileNoFilter, docTypeFilter});
                            if (!exists) continue;
                            tips.append(String.format(ResManager.loadKDString((String)"\u9644\u4ef6\u7b2c%1$s\u884c\uff0c%2$s\u5e93%3$s\u76ee\u5f55\u4e0b\uff0c\u6863\u6848\u53f7\u6709\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u3002%n", (String)"DocApplyValidator_2", (String)"pmgt-pmdc-opplugin", (Object[])new Object[0]), i + 1, docLibName.getLocaleString("name").getLocaleValue(), docDirectory.getLocaleString("name").getLocaleValue()));
                        }
                        if (!StringUtils.isNotEmpty((CharSequence)tips.toString())) continue;
                        this.addErrorMessage(entity, tips.toString());
                    }
                }
                break;
            }
            case "unaudit": {
                for (ExtendedDataEntity entity : dataEntities) {
                    StringBuilder tips;
                    QFilter enableFilter;
                    QFilter statusFilter;
                    DynamicObject bill = entity.getDataEntity();
                    DynamicObjectCollection entries = bill.getDynamicObjectCollection("entryentity");
                    Set docItemPks = entries.stream().map(DataEntityBase::getPkValue).collect(Collectors.toSet());
                    QFilter docItemFilter = new QFilter("docitem", "in", docItemPks);
                    DynamicObject[] collectRecordDb = BusinessDataServiceHelper.load((String)"pmdc_collectrecord", (String)"id, docitem", (QFilter[])new QFilter[]{docItemFilter, statusFilter = new QFilter("status", "=", (Object)StatusEnum.CHECKED.getValue()), enableFilter = new QFilter("enable", "=", (Object)EnableEnum.ENABLE.getValue())});
                    if (collectRecordDb != null && collectRecordDb.length > 0) {
                        Set recordDocItemDbPks = Arrays.stream(collectRecordDb).map(it -> it.getDynamicObject("docitem").getPkValue().toString()).collect(Collectors.toSet());
                        for (int i = 0; i < entries.size(); ++i) {
                            if (!recordDocItemDbPks.contains(((DynamicObject)entries.get(i)).getPkValue().toString())) continue;
                            this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u8d44\u6599\u5df2\u5f52\u6863\uff0c\u65e0\u6cd5\u53cd\u5ba1\u6838\uff0c\u8bf7\u5148\u5728\u539f\u59cb\u5e93\u6e05\u9664\u5f52\u6863\u5173\u7cfb\u3002", (String)"DocApplyValidator_4", (String)"pmgt-pmdc-opplugin", (Object[])new Object[0]), i + 1));
                        }
                    }
                    if (!StringUtils.isNotEmpty((CharSequence)(tips = this.getUnauditTips(new DynamicObject[]{bill})).toString())) continue;
                    this.addWarningMessage(entity, tips.toString());
                }
                break;
            }
        }
    }

    private StringBuilder getUnauditTips(DynamicObject[] docApplyArrays) {
        List docItemPks = Arrays.stream(docApplyArrays).map(it -> it.getDynamicObjectCollection("entryentity")).flatMap(Collection::stream).map(it -> Long.parseLong(it.getPkValue().toString())).collect(Collectors.toList());
        QFilter docItemFilter = new QFilter("borrowlistentry.docitemid", "in", docItemPks);
        QFilter checkedFilter = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
        DynamicObject[] borrowArray = BusinessDataServiceHelper.load((String)"pmdc_docborrow", (String)"id, borrowlistentry.docitemid", (QFilter[])new QFilter[]{docItemFilter, checkedFilter});
        StringBuilder tips = new StringBuilder();
        if (borrowArray != null && borrowArray.length > 0) {
            Set borrowDocItemPks = Arrays.stream(borrowArray).map(it -> it.getDynamicObjectCollection("borrowlistentry")).flatMap(Collection::stream).map(it -> it.getDynamicObject("docitemid").getPkValue().toString()).collect(Collectors.toSet());
            for (DynamicObject docApply : docApplyArrays) {
                DynamicObjectCollection docItemFromDocApply = docApply.getDynamicObjectCollection("entryentity");
                for (int i = 0; i < docItemFromDocApply.size(); ++i) {
                    DynamicObject docItem = (DynamicObject)docItemFromDocApply.get(i);
                    if (!borrowDocItemPks.contains(docItem.getPkValue().toString())) continue;
                    tips.append(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u8d44\u6599\u88ab\u501f\u9605\uff0c\u53cd\u5ba1\u6838\u4f1a\u5f71\u54cd\u501f\u9605\u8d44\u6599\u7684\u67e5\u770b\uff0c\u662f\u5426\u7ee7\u7eed\u3002", (String)"DocApplyValidator_5", (String)"pmgt-pmdc-opplugin", (Object[])new Object[0]), i + 1));
                }
            }
        }
        return tips;
    }
}

