/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmdc.report.form;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.IReportListModel;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.org.model.StatusEnum;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.report.filter.ReportFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.url.UrlService;
import kd.pmgt.pmbs.common.enums.EnableEnum;
import kd.pmgt.pmbs.common.utils.ProjectPermissionHelper;
import kd.pmgt.pmdc.report.base.AbstractPmdcReportFormPlugin;

public class DocLibQueryFormPlugin
extends AbstractPmdcReportFormPlugin
implements HyperLinkClickListener {
    public boolean verifyQuery(ReportQueryParam queryParam) {
        FilterInfo filterCondition = queryParam.getFilter();
        FilterItemInfo searchname = filterCondition.getFilterItem("searchname");
        FilterItemInfo searchfileno = filterCondition.getFilterItem("searchfileno");
        if ("".equals(searchname.getValue()) && "".equals(searchfileno.getValue())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9700\u8981\u8f93\u5165\u67e5\u8be2\u503c\u3002", (String)"DocLibQueryFormPlugin_2", (String)"pmgt-pmdc-report", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void afterQuery(ReportQueryParam queryParam) {
        super.afterQuery(queryParam);
        ReportFilter reportFilter = (ReportFilter)this.getControl("reportfilterap");
        reportFilter.setCollapse(false);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Control reportlistap = this.getControl("reportlistap");
        if (reportlistap != null) {
            ((ReportList)reportlistap).addHyperClickListener((HyperLinkClickListener)this);
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent args) {
        String fieldName = args.getFieldName();
        if ("itemname".equals(fieldName)) {
            QFilter docLibFilter;
            DynamicObject rowData = args.getRowData();
            Object docItemId = rowData.get("docitemid");
            Object docLib = rowData.get("doclib");
            Object docDirectory = rowData.get("docdirectory");
            DynamicObject docItem = BusinessDataServiceHelper.loadSingle((Object)docItemId, (String)"pmdc_docitem");
            boolean hasDocLib = false;
            List hashPermOrgUnits = ProjectPermissionHelper.getAllPermOrgsByPermItem((String)"15", (String)RequestContext.get().getUserId(), (String)"pmdc", (String)"pmdc_doclibname", (String)"47150e89000000ac");
            QFilter hasPermOrgFilter = new QFilter("useorg", "in", (Object)hashPermOrgUnits);
            QFilter hasOrgEntry = new QFilter("authorizedorgentry.authorgid", "in", (Object)hashPermOrgUnits);
            QFilter hasUserEntry = new QFilter("authuserentry.authuserid", "=", (Object)UserServiceHelper.getCurrentUserId());
            QFilter permissionFilter = hasPermOrgFilter.or(hasOrgEntry).or(hasUserEntry);
            QFilter enableFilter = new QFilter("enable", "=", (Object)EnableEnum.ENABLE.getValue());
            DynamicObject docLibPermDO = BusinessDataServiceHelper.loadSingle((String)"pmdc_doclibname", (QFilter[])new QFilter[]{enableFilter, permissionFilter, docLibFilter = new QFilter("id", "=", ((DynamicObject)docLib).getPkValue())});
            if (docLibPermDO != null) {
                hasDocLib = true;
            }
            boolean hasOnePermission = hasDocLib;
            boolean hasBorrow = false;
            if (!hasOnePermission) {
                DynamicObject borrow;
                QFilter userFilter = new QFilter("borrowuser", "=", (Object)UserServiceHelper.getCurrentUserId());
                QFilter docItemIdFilter = new QFilter("borrowlistentry.docitemid", "=", docItemId);
                Date time = this.getNowDate();
                QFilter beginFilter = new QFilter("begindate", "<=", (Object)time);
                QFilter endFilter = new QFilter("enddate", ">=", (Object)time);
                QFilter checkedFilter = new QFilter("billstatus", "=", (Object)StatusEnum.Checked);
                QFilter allFilter = userFilter.and(docItemIdFilter).and(beginFilter).and(endFilter).and(checkedFilter);
                Object docLibPk = ((DynamicObject)docLib).getPkValue();
                docLibFilter = new QFilter("borrowlistentry.doclib", "=", docLibPk);
                allFilter = allFilter.and(docLibFilter);
                if (docDirectory != null) {
                    Object docDirectoryPK = ((DynamicObject)docDirectory).getPkValue();
                    QFilter docDirectoryFilter = new QFilter("borrowlistentry.docdirectory", "=", docDirectoryPK);
                    allFilter = allFilter.and(docDirectoryFilter);
                }
                if ((borrow = BusinessDataServiceHelper.loadSingle((String)"pmdc_docborrow", (QFilter[])new QFilter[]{allFilter})) != null) {
                    hasBorrow = true;
                }
            }
            boolean bl = hasOnePermission = hasOnePermission || hasBorrow;
            if (hasOnePermission) {
                String attachmentDownloadUrl = UrlService.getAttachmentDownloadUrl((String)docItem.getString("resourcepath"));
                this.getView().download(attachmentDownloadUrl);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u5f53\u524d\u8d44\u6599\u7684\u6743\u9650\uff0c\u65e0\u6cd5\u67e5\u770b\u6216\u4e0b\u8f7d\u8d44\u6599\uff0c\u8bf7\u7533\u8bf7\u6743\u9650\u6216\u5237\u65b0\u67e5\u8be2\u7ed3\u679c\u3002", (String)"DocLibQueryFormPlugin_3", (String)"pmgt-pmdc-report", (Object[])new Object[0]));
            }
        }
    }

    public void packageData(PackageDataEvent evt) {
        boolean hasPermission = false;
        Object haspermission = evt.getRowData().get("haspermission");
        if ("1".equals(haspermission)) {
            hasPermission = true;
        }
        if (!hasPermission && evt.getFormatValue() != null && evt.getFormatValue().equals(evt.getRowData().get("itemname"))) {
            evt.getNoLinkKey().add(((ReportColumn)evt.getSource()).getFieldKey());
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if ("doborrow".equals(operateKey)) {
            ReportList reportList = (ReportList)this.getControl("reportlistap");
            int[] rows = reportList.getEntryState().getSelectedRows();
            if (rows.length < 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u4e2d\u9700\u8981\u501f\u9605\u7684\u8d44\u6599\u8bb0\u5f55\u3002", (String)"DocLibQueryFormPlugin_0", (String)"pmgt-pmdc-report", (Object[])new Object[0]));
                return;
            }
            ArrayList<DynamicObject> paramsList = new ArrayList<DynamicObject>();
            HashSet<Long> docLibPKQuerySet = new HashSet<Long>();
            HashSet<Long> docItemPKQuerySet = new HashSet<Long>(rows.length);
            HashSet<Long> docDirectoryPKQuerySet = new HashSet<Long>();
            IReportListModel reportModel = reportList.getReportModel();
            DynamicObjectCollection rowDatas = reportModel.getRowData(0, reportModel.getRowCount(), true);
            for (DynamicObject rowData : rowDatas) {
                DynamicObject docLib = rowData.getDynamicObject("doclib");
                Long docItemId = rowData.getLong("docitemid");
                DynamicObject docDirectory = rowData.getDynamicObject("docdirectory");
                docItemPKQuerySet.add(docItemId);
                if (docLib != null) {
                    Long docLibPk = docLib.getLong("id");
                    docLibPKQuerySet.add(docLibPk);
                }
                if (docDirectory == null) continue;
                Long docDirectoryPK = docDirectory.getLong("id");
                docDirectoryPKQuerySet.add(docDirectoryPK);
            }
            long currentUserId = UserServiceHelper.getCurrentUserId();
            List hashPermOrgUnits = ProjectPermissionHelper.getAllPermOrgsByPermItem((String)"15", (String)String.valueOf(currentUserId), (String)"pmdc", (String)"pmdc_doclibname", (String)"47150e89000000ac");
            QFilter hasPermOrgFilter = new QFilter("useorg", "in", (Object)hashPermOrgUnits);
            QFilter hasOrgEntry = new QFilter("authorizedorgentry.authorgid", "in", (Object)hashPermOrgUnits);
            QFilter hasUserEntry = new QFilter("authuserentry.authuserid", "=", (Object)currentUserId);
            QFilter permissionFilter = hasPermOrgFilter.or(hasOrgEntry).or(hasUserEntry);
            QFilter enableFilter = new QFilter("enable", "=", (Object)EnableEnum.ENABLE.getValue());
            QFilter docLibIdFilter = new QFilter("id", "in", docLibPKQuerySet);
            DynamicObject[] docLibDOs = BusinessDataServiceHelper.load((String)"pmdc_doclibname", (String)"id", (QFilter[])new QFilter[]{enableFilter, permissionFilter, docLibIdFilter});
            Set docLibIds = Arrays.stream(docLibDOs).map(o -> (Long)o.getPkValue()).collect(Collectors.toSet());
            QFilter userFilter = new QFilter("borrowuser", "=", (Object)currentUserId);
            QFilter docItemIdFilter = new QFilter("borrowlistentry.docitemid", "in", docItemPKQuerySet);
            Date time = this.getNowDate();
            QFilter beginFilter = new QFilter("begindate", "<=", (Object)time);
            QFilter endFilter = new QFilter("enddate", ">=", (Object)time);
            QFilter checkedFilter = new QFilter("billstatus", "=", (Object)StatusEnum.Checked);
            QFilter docLibFilter = new QFilter("borrowlistentry.doclib", "in", docLibPKQuerySet);
            QFilter docDirectoryFilter = new QFilter("borrowlistentry.docdirectory", "in", docDirectoryPKQuerySet);
            QFilter allFilter = userFilter.and(docItemIdFilter).and(beginFilter).and(endFilter).and(checkedFilter).and(docLibFilter).and(docDirectoryFilter);
            DynamicObject[] borrowDOs = BusinessDataServiceHelper.load((String)"pmdc_docborrow", (String)"borrowlistentry.docitemid,borrowlistentry.doclib,borrowlistentry.docdirectory", (QFilter[])new QFilter[]{allFilter});
            HashSet<Long> docLibPKBorrowSet = new HashSet<Long>();
            HashSet<Long> docItemPKBorrowSet = new HashSet<Long>();
            HashSet<Long> docDirectoryPKBorrowSet = new HashSet<Long>();
            for (DynamicObject rowData : rowDatas) {
                DynamicObject docLib = rowData.getDynamicObject("doclib");
                Long docItemId = rowData.getLong("docitemid");
                DynamicObject docDirectory = rowData.getDynamicObject("docdirectory");
                Long docDirectoryId = docDirectory.getLong("id");
                Long docLibId = docLib.getLong("id");
                boolean hasOnePermission = docLibIds.contains(docLibId);
                boolean hasBorrow = false;
                if (!hasOnePermission) {
                    for (DynamicObject borrowDO : borrowDOs) {
                        DynamicObjectCollection borrowListEntry = borrowDO.getDynamicObjectCollection("borrowlistentry");
                        for (DynamicObject borrowDocItem : borrowListEntry) {
                            Long docItemIDBorrow = (Long)((DynamicObject)borrowDocItem.get("docitemid")).getPkValue();
                            Long docLibIDBorrow = (Long)((DynamicObject)borrowDocItem.get("doclib")).getPkValue();
                            Long docDirectoryIDBorrow = (Long)((DynamicObject)borrowDocItem.get("docdirectory")).getPkValue();
                            if (docItemId.compareTo(docItemIDBorrow) == 0 && docLibId.compareTo(docLibIDBorrow) == 0 && docDirectoryId.compareTo(docDirectoryIDBorrow) == 0) {
                                hasBorrow = true;
                            }
                            if (!hasBorrow) continue;
                            break;
                        }
                        if (hasBorrow) break;
                    }
                }
                if (hasOnePermission = hasOnePermission || hasBorrow) continue;
                paramsList.add(rowData);
                docLibPKBorrowSet.add(docLibId);
                docItemPKBorrowSet.add(docItemId);
                docDirectoryPKBorrowSet.add(docDirectoryId);
            }
            if (paramsList.size() < 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6709\u8d44\u6599\u7684\u6743\u9650\uff0c\u65e0\u9700\u501f\u9605\u3002", (String)"DocLibQueryFormPlugin_1", (String)"pmgt-pmdc-report", (Object[])new Object[0]));
                return;
            }
            BillShowParameter showParameter = new BillShowParameter();
            showParameter.setFormId("pmdc_docborrow");
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setStatus(OperationStatus.ADDNEW);
            showParameter.setCustomParam("paramsList", paramsList);
            showParameter.setCustomParam("docLibPKBorrowSet", docLibPKBorrowSet);
            showParameter.setCustomParam("docItemPKBorrowSet", docItemPKBorrowSet);
            showParameter.setCustomParam("docDirectoryPKBorrowSet", docDirectoryPKBorrowSet);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    public Date getNowDate() {
        Calendar c = Calendar.getInstance();
        c.set(11, 0);
        c.set(12, 0);
        c.set(14, 0);
        c.set(13, 0);
        return c.getTime();
    }
}

