/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmdc.formplugin.collectmanage;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleDynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.pmgt.pmbs.common.enums.EnableEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmbs.common.utils.ProjectPermissionHelper;
import kd.pmgt.pmdc.business.directory.DirectoryService;
import kd.pmgt.pmdc.formplugin.base.AbstractPmdcBillPlugin;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.NotNull;

public class CollectManageEditPlugin
extends AbstractPmdcBillPlugin
implements BeforeF7SelectListener,
HyperLinkClickListener {
    private static final Log logger = LogFactory.getLog(CollectManageEditPlugin.class);
    private static final String ORIGINAL_DOC_LIB_NUMBER = "originaldoclib";
    private static final String ModifyEntry_ActionID = "modifycatalog_entry";
    private static final String KEY_ADDROW = "addrow";
    private static final String KEY_BATCHSETCOLLECT = "batchsetcollect";
    private DirectoryService directoryService = new DirectoryService();

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        List allPermOrgsByPermItem = ProjectPermissionHelper.getAllPermOrgsByPermItem((String)"15", (String)String.valueOf(UserServiceHelper.getCurrentUserId()), (String)"pmdc", (String)"pmdc_originaldoclibdir", (String)"47156aff000000ac");
        if (CollectionUtils.isEmpty((Collection)allPermOrgsByPermItem)) {
            e.setCancelMessage(ResManager.loadKDString((String)"\u975e\u8d44\u6599\u7ba1\u7406\u5458\uff0c\u65e0\u6cd5\u5f52\u6863\u3002", (String)"CollectManageEditPlugin_2", (String)"pmgt-pmdc-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
        }
    }

    public void registerListener(EventObject e) {
        EntryGrid collectEntryGird;
        super.registerListener(e);
        BasedataEdit docDir = (BasedataEdit)this.getControl("group");
        if (docDir != null) {
            docDir.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((collectEntryGird = (EntryGrid)this.getControl("collectentry")) != null) {
            collectEntryGird.addHyperClickListener((HyperLinkClickListener)this);
        }
    }

    public void beforeBindData(EventObject e) {
        String billStatus = (String)this.getModel().getValue("billstatus");
        if (StatusEnum.TEMPSAVE.getValue().equals(billStatus)) {
            this.fillCollectEntryFromDocItem();
            if (this.getModel().getValue("businessdate") == null) {
                this.getModel().setValue("businessdate", (Object)new Date());
            }
        }
    }

    protected void fillCollectEntryFromDocItem() {
        Map customMap = this.getView().getFormShowParameter().getCustomParams();
        String attachmentPks = (String)customMap.get("docitempks");
        if (attachmentPks == null || attachmentPks.length() == 0) {
            return;
        }
        String[] pks = attachmentPks.split(",");
        DynamicObject[] docItems = BusinessDataServiceHelper.load((Object[])Arrays.stream(pks).map(Long::parseLong).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmdc_docitem"));
        this.addEntryData(docItems);
    }

    protected void addEntryData(DynamicObject[] docItems) {
        DynamicObjectCollection collectEntry = this.getModel().getEntryEntity("collectentry");
        DynamicObjectType entryDT = collectEntry.getDynamicObjectType();
        for (DynamicObject docItem : docItems) {
            DynamicObject entry = new DynamicObject(entryDT);
            entry.set("docitem", (Object)docItem);
            collectEntry.add((Object)entry);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        super.beforeF7Select(event);
        String key = event.getProperty().getName();
        int currentRow = event.getRow();
        switch (key) {
            case "group": {
                ListShowParameter parameter = (ListShowParameter)event.getFormShowParameter();
                CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, ModifyEntry_ActionID);
                parameter.setCloseCallBack(callBack);
                parameter.setCustomParam("viewStatus", (Object)OperationStatus.VIEW);
                parameter.setMultiSelect(false);
                parameter.setCustomParam("chooseSource", (Object)"collect");
                parameter.getListFilterParameter().getQFilters().add(new QFilter("enable", "=", (Object)EnableEnum.ENABLE.getValue()));
                if ("getLookUpList".equals(event.getSourceMethod())) {
                    parameter.getListFilterParameter().getQFilters().add(new QFilter("doclibname.number", "!=", (Object)ORIGINAL_DOC_LIB_NUMBER));
                    parameter.getListFilterParameter().getQFilters().add(new QFilter("isleaf", "=", (Object)"1"));
                    Set authorizedDocLibNameList = this.directoryService.getAuthorizedDocLibNameList();
                    parameter.getListFilterParameter().getQFilters().add(new QFilter("doclibname", "in", (Object)authorizedDocLibNameList));
                }
                DynamicObjectCollection collectRecordEntries = this.getModel().getEntryEntity("collectentry");
                DynamicObject currentCollectRecord = (DynamicObject)collectRecordEntries.get(currentRow);
                List docLibNamePks = collectRecordEntries.stream().filter(it -> it.getDynamicObject("docitem") != null).filter(it -> it.getDynamicObject("docitem").getPkValue().toString().equals(currentCollectRecord.getDynamicObject("docitem").getPkValue().toString())).filter(it -> it.getDynamicObject("group") != null).map(it -> it.getDynamicObject("group").getDynamicObject("doclibname").getPkValue()).collect(Collectors.toList());
                parameter.getListFilterParameter().getQFilters().add(new QFilter("doclibname.id", "not in", docLibNamePks));
                parameter.getOpenStyle().setShowType(ShowType.Modal);
                break;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        FormOperate operate = (FormOperate)args.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "addrow": {
                ListShowParameter parameter = ShowFormHelper.createShowListForm((String)"pmdc_docitem", (boolean)true, (int)3);
                parameter.setCustomParam("openby", (Object)"pmdc_collectmanage");
                parameter.getOpenStyle().setShowType(ShowType.Modal);
                StyleCss css = new StyleCss();
                css.setHeight("650");
                css.setWidth("1200");
                parameter.getOpenStyle().setInlineStyleCss(css);
                parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "pmdc_docitem"));
                this.getView().showForm((FormShowParameter)parameter);
                break;
            }
            case "batchsetcollect": {
                void var16_19;
                EntryGrid entryGrid = (EntryGrid)this.getView().getControl("collectentry");
                int[] selectRows = entryGrid.getSelectRows();
                if (selectRows.length == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u4e2d\u5f52\u6863\u6587\u6863\u3002", (String)"CollectManageEditPlugin_0", (String)"pmgt-pmdc-formplugin", (Object[])new Object[0]));
                    break;
                }
                ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)"pmdc_docdirectory", (boolean)false, (int)3);
                CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, ModifyEntry_ActionID);
                listShowParameter.setCloseCallBack(callBack);
                listShowParameter.getOpenStyle().setShowType(ShowType.Modal);
                DynamicObjectCollection collectRecordEntries = this.getModel().getEntryEntity("collectentry");
                ArrayList<Object> selectedData = new ArrayList<Object>(selectRows.length);
                Object object = selectRows;
                int n = ((int[])object).length;
                boolean bl = false;
                while (var16_19 < n) {
                    int selectRow = object[var16_19];
                    selectedData.add(collectRecordEntries.get(selectRow));
                    ++var16_19;
                }
                object = selectedData.iterator();
                while (object.hasNext()) {
                    DynamicObject selectedDatum = (DynamicObject)object.next();
                    collectRecordEntries.remove((Object)selectedDatum);
                }
                HashSet excludeDocLibName = new HashSet();
                for (DynamicObject dynamicObject : selectedData) {
                    excludeDocLibName.addAll(collectRecordEntries.stream().filter(it -> it.getDynamicObject("group") != null).filter(it -> it.getDynamicObject("docitem").getPkValue().toString().equals(selectedDatum.getDynamicObject("docitem").getPkValue().toString())).map(it -> it.getDynamicObject("group").getDynamicObject("doclibname").getPkValue()).collect(Collectors.toSet()));
                }
                listShowParameter.getListFilterParameter().getQFilters().add(new QFilter("doclibname.id", "not in", excludeDocLibName));
                listShowParameter.setCustomParam("chooseSource", (Object)"collect");
                this.getView().showForm((FormShowParameter)listShowParameter);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        Object oldValue = changeData.getOldValue();
        Object newValue = changeData.getNewValue();
        int rowIndex = changeData.getRowIndex();
        switch (name) {
            case "group": {
                String billNo;
                String formId = "pmdc_fileno";
                DynamicObject goal = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)formId));
                if (newValue == null) {
                    this.getModel().setValue("fileno", null, rowIndex);
                    this.getView().updateView("fileno", rowIndex);
                    break;
                }
                DynamicObject docDirectory = (DynamicObject)newValue;
                goal.set("doclibname", (Object)docDirectory.getDynamicObject("doclibname"));
                goal.set("docdirectory", (Object)docDirectory);
                boolean isExistCodeRule = CodeRuleServiceHelper.isExist((String)formId, (DynamicObject)goal, (String)String.valueOf(RequestContext.get().getOrgId()));
                if (!isExistCodeRule || (billNo = CodeRuleServiceHelper.getNumber((String)formId, (DynamicObject)goal, (String)String.valueOf(RequestContext.get().getOrgId()))) == null) break;
                this.getModel().setValue("fileno", (Object)billNo, rowIndex);
                this.getView().updateView("fileno", rowIndex);
                break;
            }
            case "fileno": {
                if (newValue == null || StringUtils.isEmpty((CharSequence)newValue.toString())) {
                    return;
                }
                LocaleString newLocale = this.getLocaleString((LocaleDynamicObjectCollection)newValue, "fileno");
                LocaleString oldLocale = this.getLocaleString((LocaleDynamicObjectCollection)oldValue, "fileno");
                if (StringUtils.isBlank((CharSequence)newLocale.getLocaleValue())) {
                    return;
                }
                DynamicObjectCollection docItems = this.getModel().getDataEntity(true).getDynamicObjectCollection("collectentry");
                for (int i = 0; i < docItems.size(); ++i) {
                    if (i == rowIndex || !newLocale.getLocaleValue().equals(((DynamicObject)docItems.get(i)).getLocaleString("fileno").getLocaleValue())) continue;
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u6863\u6848\u53f7\u5b58\u5728\u91cd\u590d\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\u3002", (String)"CollectManageEditPlugin_1", (String)"pmgt-pmdc-formplugin", (Object[])new Object[0]));
                    this.getModel().setValue("fileno", (Object)oldLocale, rowIndex);
                }
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String key;
        super.afterDoOperation(args);
        super.afterDoOperation(args);
        switch (key = args.getOperateKey()) {
            case "unaudit": {
                DynamicObjectCollection collectEntities = this.getModel().getDataEntity(true).getDynamicObjectCollection("collectentry");
                for (DynamicObject collectEntity : collectEntities) {
                    collectEntity.set("collectenable", (Object)EnableEnum.ENABLE.getValue());
                }
                this.getView().updateView("collectentry");
                break;
            }
        }
    }

    @NotNull
    private LocaleString getLocaleString(LocaleDynamicObjectCollection newValue, String fieldName) {
        LocaleDynamicObjectCollection newFileNo = newValue;
        HashMap<String, String> nameMap = new HashMap<String, String>(16);
        for (DynamicObject dyn : newFileNo) {
            nameMap.put(dyn.getString("localeid"), dyn.getString(fieldName));
        }
        return LocaleString.fromMap(nameMap);
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        String actionId = event.getActionId();
        if (ModifyEntry_ActionID.equalsIgnoreCase(actionId)) {
            Map returnData = (Map)event.getReturnData();
            if (returnData == null || returnData.size() == 0) {
                return;
            }
            DynamicObject docDir = (DynamicObject)returnData.get("parent");
            if (docDir == null) {
                return;
            }
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl("collectentry");
            for (int row : entryGrid.getSelectRows()) {
                this.getModel().setValue("group", (Object)docDir, row);
            }
        } else if ("pmdc_docitem".equalsIgnoreCase(actionId)) {
            Object returnData = event.getReturnData();
            if (returnData == null) {
                return;
            }
            Object[] rowsPk = ((ListSelectedRowCollection)returnData).getPrimaryKeyValues();
            if (rowsPk.length < 1) {
                return;
            }
            DynamicObject[] docItems = BusinessDataServiceHelper.load((Object[])rowsPk, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmdc_docitem"));
            DynamicObjectCollection collectEntry = this.getModel().getEntryEntity("collectentry");
            for (DynamicObject docItem : docItems) {
                DynamicObject newEntry = collectEntry.addNew();
                newEntry.set("docitem", (Object)docItem);
            }
            this.getModel().updateEntryCache(collectEntry);
            this.getView().updateView("collectentry");
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        this.getView().returnDataToParent((Object)"refresh");
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        String fieldName = hyperLinkClickEvent.getFieldName();
        if (StringUtils.equals((CharSequence)"sourcebillno", (CharSequence)fieldName)) {
            int rowIndex = hyperLinkClickEvent.getRowIndex();
            DynamicObject collectEntryObj = this.getModel().getEntryRowEntity("collectentry", rowIndex);
            DynamicObject docItem = collectEntryObj.getDynamicObject("docitem");
            if (docItem != null) {
                String sourceBillFormIId = docItem.getDynamicObject("sourcebill").getPkValue().toString();
                String sourceBillDataId = docItem.getString("billdataid");
                BillShowParameter showParameter = new BillShowParameter();
                showParameter.setPkId((Object)sourceBillDataId);
                showParameter.setFormId(sourceBillFormIId);
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                showParameter.setStatus(OperationStatus.VIEW);
                this.getView().showForm((FormShowParameter)showParameter);
            }
        }
    }
}

