/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmdc.formplugin.directory;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.basedataref.BaseDataRefenceKey;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.SelectRowsEventListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ITreeListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.org.utils.DynamicObjectUtils;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataRefrenceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmgt.pmdc.business.directory.DirectoryService;
import kd.pmgt.pmdc.business.directory.DocDirectoryTreeEntryGrid;

public class DocDirectoryListPlugin
extends AbstractTreeListPlugin
implements HyperLinkClickListener,
SelectRowsEventListener,
RowClickEventListener,
TreeNodeClickListener,
CellClickListener,
SearchEnterListener {
    public static final String KEY_TREEENTRYGRID = "outtreeentryentity";
    private int indexNo = 0;
    public static final String FORM_ID = "pmdc_docdirectory";
    public static final String FIELD_LIBNO = "number";
    public static final String SELECTED_FIELDS = "id,number,name,isleaf,enable,parent,level";
    public static final String FIELD_ENABLE = "enable";
    public static final String FIELD_NUMBER = "number";
    public static final String FIELD_PARENT = "parent";
    public static final String FIELD_ID = "id";
    public static final String FIELD_ISLEAF = "isleaf";
    private DirectoryService directoryService = new DirectoryService();
    private static final String DOCLIBNAME_LIST_CACHE_KEY = "DOCLIBNAME_LIST_CACHE_KEY";
    private static final String DOCLIBNAME_LIST_DATA_CACHE_KEY = "DOCLIBNAME_LIST_DATA_CACHE_KEY";
    private static final String NEED_TO_REBUILD_TREE = "NEED_TO_REBUILD_TREE";
    private static final String TREE_VIEW = "treeview";
    private static final String RETURN_DATA = "doreturndata";
    private static final String OPERATE_REFRESH = "refresh";
    private static final String OPERATE_DONEW = "donew";
    private static final String OPERATE_ENABLE = "doenable";
    private static final String OPERATE_DISABLE = "domydisable";
    private static final String OPERATE_DELETE = "dodelete";
    private static final String OPERATE_IMPORT = "doimport";
    private static final String CALLBACKKEY_DELETE = "projectkind_delete";
    private static final String CALLBACKKEY_IMPORT = "import";
    private static final String CALLBACKKEY_ADDNEW = "doclibtpl_addnew";
    private static final String CALLBACKKEY_EDIT = "doclibtpl_edit";
    private static final String CALLBACKKEY_DISABLE = "projectkind_disable";
    private static final String selectrows = "selectrows_tplplugin";
    private static final String fixedSeletedRowMapKey = "fixedseletedrowmap";
    public static final String OLD_TREE_SEARCH_TEXT_KEY = "old_tree_search_text_key";
    private static List<Object> searchResult = new ArrayList<Object>();
    private static final String SEARCH_RESULT_LIST_POSITION = "search_result_list_position";

    public void initialize() {
        this.getView().addCustomControls(new String[]{KEY_TREEENTRYGRID});
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Search search = (Search)this.getView().getControl("treesearchap");
        if (search != null) {
            search.addEnterListener((SearchEnterListener)this);
        }
    }

    public void onGetControl(OnGetControlArgs e) {
        TreeEntryGrid treeEntryGrid;
        if (StringUtils.equalsIgnoreCase((CharSequence)KEY_TREEENTRYGRID, (CharSequence)e.getKey()) && (treeEntryGrid = this.newTreeEntryGrid()) != null) {
            treeEntryGrid.addHyperClickListener((HyperLinkClickListener)this);
            treeEntryGrid.addCellClickListener((CellClickListener)this);
            e.setControl((Control)treeEntryGrid);
        }
    }

    private TreeEntryGrid newTreeEntryGrid() {
        DocDirectoryTreeEntryGrid newTreeEntryGrid = new DocDirectoryTreeEntryGrid();
        Container container = (Container)this.getView().getControl("treeflex");
        if (container != null) {
            TreeEntryGrid oldTreeEntryGrid = (TreeEntryGrid)container.getItems().get(this.indexNo);
            newTreeEntryGrid.getItems().addAll(oldTreeEntryGrid.getItems());
            newTreeEntryGrid.setKey(oldTreeEntryGrid.getKey());
            newTreeEntryGrid.setEntryKey(oldTreeEntryGrid.getEntryKey());
            IDataModel model = oldTreeEntryGrid.getModel();
            model.setDataChanged(false);
            newTreeEntryGrid.setModel(model);
            newTreeEntryGrid.setView(oldTreeEntryGrid.getView());
        }
        return newTreeEntryGrid;
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        String fieldName = hyperLinkClickEvent.getFieldName();
        DynamicObjectCollection gridRows = this.getModel().getEntryEntity(KEY_TREEENTRYGRID);
        int rowIndex = hyperLinkClickEvent.getRowIndex();
        if ("number".equals(fieldName)) {
            BillShowParameter showParameter = new BillShowParameter();
            showParameter.setPkId(((DynamicObject)gridRows.get(rowIndex)).getPkValue());
            showParameter.setFormId(FORM_ID);
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            Object viewStatus = formShowParameter.getCustomParam("viewStatus");
            if (viewStatus != null) {
                showParameter.setStatus(OperationStatus.VIEW);
            } else {
                showParameter.setStatus(OperationStatus.EDIT);
            }
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALLBACKKEY_EDIT));
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    public void beforeBindData(EventObject e) {
        this.enableTreeEntryGridSplitPage();
        super.beforeBindData(e);
    }

    private void enableTreeEntryGridSplitPage() {
        Container container = (Container)this.getView().getControl("treeflex");
        TreeEntryGrid treeEntryGrid = this.newTreeEntryGrid();
        if (container != null && treeEntryGrid != null) {
            container.getItems().set(this.indexNo, treeEntryGrid);
            treeEntryGrid.setCollapse(false);
        }
    }

    public void setFilter(SetFilterEvent e) {
        IPageCache pageCache = this.getPageCache();
        String preCacheKey = this.getView().getPageId() + "-";
        pageCache.remove(preCacheKey + "filterCnt");
        List mergeQFilters = e.getMergeQFilters();
        int index = 0;
        for (QFilter filter : mergeQFilters) {
            if (filter == null) continue;
            String property = filter.getProperty();
            if (FIELD_PARENT.equalsIgnoreCase(property)) {
                QFilter docDirectoryFilter = new QFilter("doclibname", filter.getCP(), filter.getValue());
                pageCache.put(preCacheKey + index, docDirectoryFilter.toSerializedString());
                ++index;
                continue;
            }
            pageCache.put(preCacheKey + index, filter.toSerializedString());
            ++index;
        }
        String docLibNameDataCache = this.getPageCache().get(DOCLIBNAME_LIST_DATA_CACHE_KEY);
        if (docLibNameDataCache != null) {
            List docLibNames = SerializationUtils.fromJsonStringToList((String)docLibNameDataCache, Long.class);
            QFilter docLibNameFilter = new QFilter("doclibname", "in", (Object)docLibNames);
            pageCache.put(preCacheKey + index, docLibNameFilter.toSerializedString());
            ++index;
        }
        pageCache.put(preCacheKey + "filterCnt", String.valueOf(index));
        this.getView().updateView(KEY_TREEENTRYGRID);
        super.setFilter(e);
    }

    public void createNewData(BizDataEventArgs e) {
        this.getPageCache().put(NEED_TO_REBUILD_TREE, Boolean.TRUE.toString());
    }

    protected TreeNode rebuildDocLibNameTreeRoot() {
        TreeNode root = new TreeNode();
        root.setId("8609760E-EF83-4775-A9FF-CCDEC7C0B689");
        root.setText(ResManager.loadKDString((String)"\u5168\u90e8", (String)"DocDirectoryListPlugin_35", (String)"pmgt-pmdc-formplugin", (Object[])new Object[0]));
        return root;
    }

    protected void rebuildDocLibNameTree(ITreeListView treeListView, TreeNode root, String focusNodeId) {
        List childrenNodes;
        if (this.getTreeListView() == null || this.getTreeListView().getTreeModel() == null || this.getTreeListView().getTreeModel().getRoot() == null) {
            return;
        }
        this.getPageCache().put(NEED_TO_REBUILD_TREE, Boolean.FALSE.toString());
        String docLibNameTreeCache = this.getPageCache().get(DOCLIBNAME_LIST_CACHE_KEY);
        treeListView.getTreeView().deleteAllNodes();
        treeListView.getTreeView().addNode(root);
        if (StringUtils.isBlank((CharSequence)docLibNameTreeCache)) {
            DynamicObject[] authorizedDirectoryList = this.directoryService.getAuthorizedDirectoryList(null);
            IPageCache pageCache = this.getPageCache();
            List directoryIdList = Arrays.stream(authorizedDirectoryList).map(o -> o.getLong(FIELD_ID)).collect(Collectors.toList());
            pageCache.put(DOCLIBNAME_LIST_DATA_CACHE_KEY, SerializationUtils.toJsonString(directoryIdList));
            childrenNodes = this.directoryService.getNodes(authorizedDirectoryList);
        } else {
            childrenNodes = SerializationUtils.fromJsonStringToList((String)this.getPageCache().get(DOCLIBNAME_LIST_CACHE_KEY), TreeNode.class);
        }
        if (!childrenNodes.isEmpty()) {
            root.setChildren(childrenNodes);
        }
        root.setIsOpened(true);
        TreeView treeView = (TreeView)this.getControl(TREE_VIEW);
        treeView.treeNodeClick(null, focusNodeId);
        treeView.focusNode(root.getTreeNode(focusNodeId));
    }

    public void afterBindData(EventObject e) {
        String[] treeEntryKeyArray;
        FormShowParameter formShowParameter;
        Object KindTree;
        super.afterBindData(e);
        boolean needToRebuildTree = Boolean.parseBoolean(this.getPageCache().get(NEED_TO_REBUILD_TREE));
        if (needToRebuildTree) {
            TreeNode root = this.rebuildDocLibNameTreeRoot();
            this.rebuildDocLibNameTree(this.getTreeListView(), root, root.getId());
        }
        boolean hasKindTree = (KindTree = (formShowParameter = this.getView().getFormShowParameter()).getCustomParam("kindTree")) == null || (Boolean)KindTree != false;
        this.getView().setVisible(Boolean.valueOf(hasKindTree), new String[]{"flexpanelapleft"});
        this.getView().setStatus(OperationStatus.VIEW);
        for (String treekey : treeEntryKeyArray = this.getTreeEntryKeyArray()) {
            String cacheKey = this.getCacheKey(treekey);
            Set<Integer> selectRows = this.getSelectRows(treekey);
            this.getPageCache().put(cacheKey, JSON.toJSONString(selectRows));
        }
    }

    public String[] getTreeEntryKeyArray() {
        return new String[]{KEY_TREEENTRYGRID};
    }

    protected String getCacheKey(String treekey) {
        return "selectrows_tplplugin_" + treekey;
    }

    private Set<Integer> getSelectRows(String treeKey) {
        int[] selectedRows;
        TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getControl(treeKey);
        HashSet<Integer> selectRows = new HashSet<Integer>();
        if (treeEntryGrid != null && (selectedRows = treeEntryGrid.getEntryState().getSelectedRows()) != null && selectedRows.length > 0) {
            selectRows.addAll(Arrays.stream(selectedRows).boxed().collect(Collectors.toSet()));
        }
        return selectRows;
    }

    private void addAllSons(Set<Object> ids, Set<Object> parentIds) {
        DynamicObject[] sons = BusinessDataServiceHelper.load((String)FORM_ID, (String)SELECTED_FIELDS, (QFilter[])new QFilter[]{new QFilter(FIELD_PARENT, "in", parentIds)});
        HashSet<Object> parentPkList = new HashSet<Object>();
        if (sons != null && sons.length > 0) {
            for (DynamicObject son : sons) {
                if (!son.getBoolean(FIELD_ISLEAF)) {
                    parentPkList.add(son.getPkValue());
                }
                ids.add(son.getPkValue());
            }
            this.addAllSons(ids, parentPkList);
        }
    }

    private void deleteDirectory(Set<Object> deleteIds, DynamicObject[] parents) {
        this.addAllSons(deleteIds, deleteIds);
        DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)FORM_ID), (Object[])deleteIds.toArray(new Object[0]));
        LinkedList<DynamicObject> updateList = new LinkedList<DynamicObject>();
        ORM orm = ORM.create();
        for (DynamicObject parent : parents) {
            QFilter qFilter = new QFilter(FIELD_PARENT, "=", parent.getPkValue());
            boolean isExist = orm.exists(FORM_ID, new QFilter[]{qFilter});
            if (isExist) continue;
            parent.set(FIELD_ISLEAF, (Object)Boolean.TRUE);
            updateList.add(parent);
        }
        SaveServiceHelper.save((DynamicObject[])updateList.toArray(new DynamicObject[0]));
    }

    /*
     * WARNING - void declaration
     */
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        Object currentNodeId = this.getTreeModel().getCurrentNodeId();
        boolean isRoot = this.getTreeModel().getRoot().getId().equals(currentNodeId);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        DynamicObjectCollection gridRows = this.getModel().getEntryEntity(KEY_TREEENTRYGRID);
        TreeEntryGrid grid = (TreeEntryGrid)this.getView().getControl(KEY_TREEENTRYGRID);
        int[] selectRows = grid.getSelectRows();
        ArrayList<Object> pkList = new ArrayList<Object>();
        if (selectRows != null && (selectRows.length != 1 || selectRows[0] != -1)) {
            for (int rowIndex : selectRows) {
                pkList.add(((DynamicObject)gridRows.get(rowIndex)).get(FIELD_ID));
            }
        }
        DynamicObject[] docDirectories = BusinessDataServiceHelper.load((String)FORM_ID, (String)SELECTED_FIELDS, (QFilter[])new QFilter[]{new QFilter(FIELD_ID, "in", pkList)});
        int failCount = 0;
        StringBuilder failMessage = new StringBuilder();
        boolean showConfirm = false;
        HashSet<Object> deleteIds = new HashSet<Object>();
        ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>();
        switch (operateKey) {
            case "doreturndata": {
                if (selectRows == null || selectRows.length == 0) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u6ca1\u6709\u9009\u4e2d\u884c\u3002", (String)"DocDirectoryListPlugin_1", (String)"pmgt-pmdc-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
                boolean multiSelect = listShowParameter.isMultiSelect();
                if (!multiSelect && selectRows.length > 1) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u4e2d1\u884c\u3002", (String)"DocDirectoryListPlugin_2", (String)"pmgt-pmdc-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                HashMap<String, Object> returnMap = new HashMap<String, Object>();
                if (!multiSelect) {
                    int selectRow = selectRows[0];
                    returnMap.put(FIELD_PARENT, gridRows.get(selectRow));
                } else {
                    void var25_36;
                    DynamicObject[] importDirectory = new DynamicObject[selectRows.length];
                    int index = 0;
                    int[] nArray = selectRows;
                    int n = nArray.length;
                    boolean bl = false;
                    while (var25_36 < n) {
                        DynamicObject importCurr;
                        int selectIndex = nArray[var25_36];
                        importDirectory[index] = importCurr = (DynamicObject)gridRows.get(selectIndex);
                        ++index;
                        ++var25_36;
                    }
                    returnMap.put("importDirectory", importDirectory);
                }
                this.getView().returnDataToParent(returnMap);
                this.getView().invokeOperation("close");
                break;
            }
            case "refresh": {
                this.getPageCache().put(NEED_TO_REBUILD_TREE, Boolean.TRUE.toString());
                this.getTreeModel().setCurrentNodeId((Object)this.getTreeModel().getRoot().getId());
                break;
            }
            case "donew": {
                if (isRoot) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u5177\u4f53\u8d44\u6599\u5e93\u3002", (String)"DocDirectoryListPlugin_20", (String)"pmgt-pmdc-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                BillShowParameter parameter = new BillShowParameter();
                parameter.setFormId(FORM_ID);
                parameter.setBillStatus(BillOperationStatus.ADDNEW);
                parameter.setStatus(OperationStatus.ADDNEW);
                parameter.getOpenStyle().setShowType(ShowType.Modal);
                parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALLBACKKEY_ADDNEW));
                HashMap<String, DynamicObject> paramMap = new HashMap<String, DynamicObject>();
                DynamicObject docLibNameDO = BusinessDataServiceHelper.loadSingle((Object)Long.valueOf(currentNodeId.toString()), (String)"pmdc_doclibname");
                paramMap.put("docLibName", docLibNameDO);
                if (selectRows != null && selectRows.length == 1) {
                    DynamicObject projectKind = docDirectories[0];
                    paramMap.put(FIELD_PARENT, projectKind);
                }
                parameter.setCustomParams(paramMap);
                this.getView().showForm((FormShowParameter)parameter);
                break;
            }
            case "doenable": {
                if (selectRows == null || selectRows.length == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"DocDirectoryListPlugin_4", (String)"pmgt-pmdc-formplugin", (Object[])new Object[0]));
                    return;
                }
                String oneFailMessage = "";
                for (DynamicObject directory : docDirectories) {
                    String isEnable = directory.getString(FIELD_ENABLE);
                    if ("1".equals(isEnable)) {
                        failMessage.append(String.format(ResManager.loadKDString((String)"%s\uff1a\u6570\u636e\u5df2\u4e3a\u53ef\u7528\u72b6\u6001\u3002", (String)"DocDirectoryListPlugin_26", (String)"pmgt-pmdc-formplugin", (Object[])new Object[0]) + "\r\n", directory.getString("number")));
                        oneFailMessage = ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e3a\u53ef\u7528\u72b6\u6001\u3002", (String)"DocDirectoryListPlugin_27", (String)"pmgt-pmdc-formplugin", (Object[])new Object[0]);
                        ++failCount;
                        continue;
                    }
                    DynamicObject parent = directory.getDynamicObject(FIELD_PARENT);
                    if (parent != null && "0".equals(parent.getString(FIELD_ENABLE))) {
                        failMessage.append(String.format(ResManager.loadKDString((String)"%s\uff1a\u7236\u8282\u70b9\u672a\u542f\u7528\u3002", (String)"DocDirectoryListPlugin_6", (String)"pmgt-pmdc-formplugin", (Object[])new Object[0]) + "\r\n", directory.getString("number")));
                        oneFailMessage = ResManager.loadKDString((String)"\u542f\u7528\u5931\u8d25\uff0c\u7236\u8282\u70b9\u672a\u542f\u7528\u3002", (String)"DocDirectoryListPlugin_36", (String)"pmgt-pmdc-formplugin", (Object[])new Object[0]);
                        ++failCount;
                        continue;
                    }
                    directory.set(FIELD_ENABLE, (Object)"1");
                    updateList.add(directory);
                }
                SaveServiceHelper.save((DynamicObject[])updateList.toArray(new DynamicObject[0]));
                if (failCount > 0) {
                    if (selectRows.length == 1) {
                        this.getView().showTipNotification(oneFailMessage);
                    } else {
                        String string = String.format(ResManager.loadKDString((String)"\u5171%1$s\u5f20\u5355\u636e\uff0c\u6210\u529f\u542f\u7528%2$s\u5f20\uff0c\u5931\u8d25%3$s\u5f20\u3002", (String)"DocDirectoryListPlugin_7", (String)"pmgt-pmdc-formplugin", (Object[])new Object[0]), selectRows.length, selectRows.length - failCount, failCount);
                        this.getView().showConfirm(string, failMessage.toString(), MessageBoxOptions.OK, ConfirmTypes.Default, null);
                    }
                } else {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u542f\u7528\u6210\u529f\u3002", (String)"DocDirectoryListPlugin_8", (String)"pmgt-pmdc-formplugin", (Object[])new Object[0]));
                }
                this.getView().updateView(KEY_TREEENTRYGRID);
                break;
            }
            case "domydisable": {
                if (selectRows == null || selectRows.length == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"DocDirectoryListPlugin_4", (String)"pmgt-pmdc-formplugin", (Object[])new Object[0]));
                    return;
                }
                for (DynamicObject directory : docDirectories) {
                    boolean isLeaf = directory.getBoolean(FIELD_ISLEAF);
                    if (isLeaf) continue;
                    showConfirm = true;
                    break;
                }
                if (showConfirm) {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u7981\u7528\u63d0\u793a", (String)"DocDirectoryListPlugin_9", (String)"pmgt-pmdc-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u9009\u4e2d\u76ee\u5f55\u6709\u4e0b\u7ea7\u76ee\u5f55\uff0c\u6b64\u6b21\u7981\u7528\u5c06\u7981\u7528\u5176\u6240\u6709\u4e0b\u7ea7\u76ee\u5f55\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"DocDirectoryListPlugin_10", (String)"pmgt-pmdc-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener(CALLBACKKEY_DISABLE, (IFormPlugin)this));
                    break;
                }
                String oneFailMessage = "";
                for (DynamicObject directory : docDirectories) {
                    String isEnable = directory.getString(FIELD_ENABLE);
                    if ("0".equals(isEnable)) {
                        failMessage.append(String.format(ResManager.loadKDString((String)"%s\uff1a\u6570\u636e\u5df2\u4e3a\u7981\u7528\u72b6\u6001\u3002", (String)"DocDirectoryListPlugin_11", (String)"pmgt-pmdc-formplugin", (Object[])new Object[0]) + "\r\n", directory.getString(FIELD_ID)));
                        oneFailMessage = ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e3a\u7981\u7528\u72b6\u6001\u3002", (String)"DocDirectoryListPlugin_28", (String)"pmgt-pmdc-formplugin", (Object[])new Object[0]);
                        ++failCount;
                        continue;
                    }
                    boolean isRefrenced = false;
                    String formId = "";
                    List refList = BaseDataRefrenceHelper.getAllRefs((String)FORM_ID, (Object)directory.getPkValue());
                    for (BaseDataRefenceKey baseDataRefenceKey : refList) {
                        String refFormId = baseDataRefenceKey.getRefEntityKey();
                        if (!"pmdc_docapply".equalsIgnoreCase(refFormId) && !"pmdc_collectrecord".equalsIgnoreCase(refFormId)) continue;
                        isRefrenced = true;
                        formId = refFormId;
                    }
                    if (isRefrenced) {
                        if ("pmdc_docapply".equalsIgnoreCase(formId)) {
                            failMessage.append(String.format(ResManager.loadKDString((String)"%s\uff1a\u5f53\u524d\u76ee\u5f55\u4e0b\u5df2\u6709\u8d44\u6599\u7533\u8bf7\u8d44\u6599\uff0c\u65e0\u6cd5\u7981\u7528\uff0c\u8bf7\u5148\u5220\u9664\u5176\u4e0b\u8d44\u6599\u7533\u8bf7\u8d44\u6599\u540e\u518d\u8bd5\u3002", (String)"DocDirectoryListPlugin_37", (String)"pmgt-pmdc-formplugin", (Object[])new Object[0]) + "\r\n", directory.getString("number")));
                            oneFailMessage = ResManager.loadKDString((String)"\u5f53\u524d\u76ee\u5f55\u4e0b\u5df2\u6709\u8d44\u6599\u7533\u8bf7\u8d44\u6599\uff0c\u65e0\u6cd5\u7981\u7528\uff0c\u8bf7\u5148\u5220\u9664\u5176\u4e0b\u8d44\u6599\u7533\u8bf7\u8d44\u6599\u540e\u518d\u8bd5\u3002", (String)"DocDirectoryListPlugin_38", (String)"pmgt-pmdc-formplugin", (Object[])new Object[0]);
                            ++failCount;
                            continue;
                        }
                        if ("pmdc_collectrecord".equalsIgnoreCase(formId)) {
                            failMessage.append(String.format(ResManager.loadKDString((String)"%s\uff1a\u5f53\u524d\u76ee\u5f55\u4e0b\u5df2\u6709\u5f52\u6863\u8d44\u6599\uff0c\u65e0\u6cd5\u7981\u7528\uff0c\u8bf7\u5148\u5220\u9664\u5176\u4e0b\u5f52\u6863\u8d44\u6599\u540e\u518d\u8bd5\u3002", (String)"DocDirectoryListPlugin_39", (String)"pmgt-pmdc-formplugin", (Object[])new Object[0]) + "\r\n", directory.getString("number")));
                            oneFailMessage = ResManager.loadKDString((String)"\u5f53\u524d\u76ee\u5f55\u4e0b\u5df2\u6709\u5f52\u6863\u8d44\u6599\uff0c\u65e0\u6cd5\u7981\u7528\uff0c\u8bf7\u5148\u5220\u9664\u5176\u4e0b\u5f52\u6863\u8d44\u6599\u540e\u518d\u8bd5\u3002", (String)"DocDirectoryListPlugin_40", (String)"pmgt-pmdc-formplugin", (Object[])new Object[0]);
                            ++failCount;
                            continue;
                        }
                    }
                    directory.set(FIELD_ENABLE, (Object)"0");
                    updateList.add(directory);
                }
                SaveServiceHelper.save((DynamicObject[])updateList.toArray(new DynamicObject[0]));
                if (failCount > 0) {
                    if (selectRows.length == 1) {
                        this.getView().showTipNotification(oneFailMessage);
                    } else {
                        String string = String.format(ResManager.loadKDString((String)"\u5171%1$s\u5f20\u5355\u636e\uff0c\u6210\u529f\u7981\u7528%2$s\u5f20\uff0c\u5931\u8d25%3$s\u5f20\u3002", (String)"DocDirectoryListPlugin_12", (String)"pmgt-pmdc-formplugin", (Object[])new Object[0]), selectRows.length, updateList.size(), failCount);
                        this.getView().showConfirm(string, failMessage.toString(), MessageBoxOptions.OK, ConfirmTypes.Default, null);
                    }
                } else {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u7981\u7528\u6210\u529f\u3002", (String)"DocDirectoryListPlugin_13", (String)"pmgt-pmdc-formplugin", (Object[])new Object[0]));
                }
                this.getView().updateView(KEY_TREEENTRYGRID);
                break;
            }
            case "dodelete": {
                if (selectRows == null || selectRows.length == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"DocDirectoryListPlugin_4", (String)"pmgt-pmdc-formplugin", (Object[])new Object[0]));
                    return;
                }
                for (DynamicObject directory : docDirectories) {
                    boolean isLeaf = directory.getBoolean(FIELD_ISLEAF);
                    if (isLeaf) continue;
                    showConfirm = true;
                    break;
                }
                if (showConfirm) {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u5220\u9664\u63d0\u793a", (String)"DocDirectoryListPlugin_14", (String)"pmgt-pmdc-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u9009\u4e2d\u76ee\u5f55\u6709\u4e0b\u7ea7\u76ee\u5f55\uff0c\u6b64\u6b21\u5220\u9664\u5c06\u5220\u9664\u5176\u6240\u6709\u4e0b\u7ea7\u76ee\u5f55\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"DocDirectoryListPlugin_15", (String)"pmgt-pmdc-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Delete, new ConfirmCallBackListener(CALLBACKKEY_DELETE, (IFormPlugin)this));
                    break;
                }
                String oneFailMessage = "";
                LinkedList<Object> linkedList = new LinkedList<Object>();
                for (DynamicObject directory : docDirectories) {
                    boolean isDisable;
                    String isEnable = directory.getString(FIELD_ENABLE);
                    if ("0".equals(isEnable)) {
                        failMessage.append(String.format(ResManager.loadKDString((String)"%s\uff1a\u6570\u636e\u5df2\u7981\u7528\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"DocDirectoryListPlugin_41", (String)"pmgt-pmdc-formplugin", (Object[])new Object[0]) + "\r\n", directory.getString("number")));
                        oneFailMessage = ResManager.loadKDString((String)"\u6570\u636e\u5df2\u7981\u7528\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"DocDirectoryListPlugin_16", (String)"pmgt-pmdc-formplugin", (Object[])new Object[0]);
                        ++failCount;
                        continue;
                    }
                    boolean isRefrenced = false;
                    String formId = "";
                    List refList = BaseDataRefrenceHelper.getAllRefs((String)FORM_ID, (Object)directory.getPkValue());
                    for (BaseDataRefenceKey baseDataRefenceKey : refList) {
                        String refFormId = baseDataRefenceKey.getRefEntityKey();
                        if (!"pmdc_docapply".equalsIgnoreCase(refFormId) && !"pmdc_collectrecord".equalsIgnoreCase(refFormId)) continue;
                        isRefrenced = true;
                        formId = refFormId;
                    }
                    if (isRefrenced) {
                        if ("pmdc_docapply".equalsIgnoreCase(formId)) {
                            failMessage.append(String.format(ResManager.loadKDString((String)"%s\uff1a\u5f53\u524d\u76ee\u5f55\u4e0b\u5df2\u6709\u8d44\u6599\u7533\u8bf7\u8d44\u6599\uff0c\u65e0\u6cd5\u5220\u9664\uff0c\u8bf7\u5148\u5220\u9664\u5176\u4e0b\u8d44\u6599\u7533\u8bf7\u8d44\u6599\u540e\u518d\u8bd5\u3002", (String)"DocDirectoryListPlugin_42", (String)"pmgt-pmdc-formplugin", (Object[])new Object[0]) + "\r\n", directory.getString("number")));
                            oneFailMessage = ResManager.loadKDString((String)"\u5f53\u524d\u76ee\u5f55\u4e0b\u5df2\u6709\u8d44\u6599\u7533\u8bf7\u8d44\u6599\uff0c\u65e0\u6cd5\u5220\u9664\uff0c\u8bf7\u5148\u5220\u9664\u5176\u4e0b\u8d44\u6599\u7533\u8bf7\u8d44\u6599\u540e\u518d\u8bd5\u3002", (String)"DocDirectoryListPlugin_43", (String)"pmgt-pmdc-formplugin", (Object[])new Object[0]);
                            ++failCount;
                            continue;
                        }
                        if ("pmdc_collectrecord".equalsIgnoreCase(formId)) {
                            failMessage.append(String.format(ResManager.loadKDString((String)"%s\uff1a\u5f53\u524d\u76ee\u5f55\u4e0b\u5df2\u6709\u5f52\u6863\u8d44\u6599\uff0c\u65e0\u6cd5\u5220\u9664\uff0c\u8bf7\u5148\u5220\u9664\u5176\u4e0b\u5f52\u6863\u8d44\u6599\u540e\u518d\u8bd5\u3002", (String)"DocDirectoryListPlugin_44", (String)"pmgt-pmdc-formplugin", (Object[])new Object[0]) + "\r\n", directory.getString("number")));
                            oneFailMessage = ResManager.loadKDString((String)"\u5f53\u524d\u76ee\u5f55\u4e0b\u5df2\u6709\u5f52\u6863\u8d44\u6599\uff0c\u65e0\u6cd5\u5220\u9664\uff0c\u8bf7\u5148\u5220\u9664\u5176\u4e0b\u5f52\u6863\u8d44\u6599\u540e\u518d\u8bd5\u3002", (String)"DocDirectoryListPlugin_45", (String)"pmgt-pmdc-formplugin", (Object[])new Object[0]);
                            ++failCount;
                            continue;
                        }
                    }
                    if (isDisable = "0".equals(directory.get(FIELD_ENABLE))) {
                        failMessage.append(String.format(ResManager.loadKDString((String)"%s\uff1a\u5176\u4e0b\u7ea7\u76ee\u5f55\u5df2\u88ab\u7981\u7528\u3002", (String)"DocDirectoryListPlugin_29", (String)"pmgt-pmdc-formplugin", (Object[])new Object[0]) + "\r\n", directory.getString("number")));
                        oneFailMessage = ResManager.loadKDString((String)"\u5176\u4e0b\u7ea7\u76ee\u5f55\u5df2\u88ab\u7981\u7528\u3002", (String)"DocDirectoryListPlugin_46", (String)"pmgt-pmdc-formplugin", (Object[])new Object[0]);
                        ++failCount;
                        continue;
                    }
                    deleteIds.add(directory.getPkValue());
                    DynamicObject parent = directory.getDynamicObject(FIELD_PARENT);
                    if (parent == null) continue;
                    linkedList.add(parent.getPkValue());
                }
                QFilter qFilter = new QFilter(FIELD_ID, "in", linkedList);
                DynamicObject[] parents = BusinessDataServiceHelper.load((String)FORM_ID, (String)SELECTED_FIELDS, (QFilter[])new QFilter[]{qFilter});
                this.deleteDirectory(deleteIds, parents);
                if (failCount > 0) {
                    if (selectRows.length == 1) {
                        this.getView().showTipNotification(oneFailMessage);
                    } else {
                        String msg = String.format(ResManager.loadKDString((String)"\u5171%1$s\u5f20\u5355\u636e\uff0c\u6210\u529f\u5220\u9664%2$s\u5f20\uff0c\u5931\u8d25%3$s\u5f20\u3002", (String)"DocDirectoryListPlugin_18", (String)"pmgt-pmdc-formplugin", (Object[])new Object[0]), selectRows.length, deleteIds.size(), failCount);
                        this.getView().showConfirm(msg, failMessage.toString(), MessageBoxOptions.OK, ConfirmTypes.Default, null);
                    }
                } else {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"DocDirectoryListPlugin_19", (String)"pmgt-pmdc-formplugin", (Object[])new Object[0]));
                }
                this.getView().updateView(KEY_TREEENTRYGRID);
                break;
            }
            case "doimport": {
                if (isRoot) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u5177\u4f53\u8d44\u6599\u5e93\u3002", (String)"DocDirectoryListPlugin_20", (String)"pmgt-pmdc-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)"pmdc_docdirectorytpl", (boolean)true, (int)3, (boolean)true);
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, CALLBACKKEY_IMPORT);
                listShowParameter.setCloseCallBack(closeCallBack);
                listShowParameter.setCaption(ResManager.loadKDString((String)"\u8d44\u6599\u76ee\u5f55\u6a21\u677f\u5217\u8868", (String)"DocDirectoryListPlugin_21", (String)"pmgt-pmdc-formplugin", (Object[])new Object[0]));
                listShowParameter.getListFilterParameter().getQFilters().add(new QFilter(FIELD_ENABLE, "=", (Object)true));
                DynamicObject[] numbers = BusinessDataServiceHelper.load((String)FORM_ID, (String)"number", (QFilter[])new QFilter[]{new QFilter("doclibname", "=", (Object)Long.valueOf(currentNodeId.toString()))});
                HashSet<String> numberSet = new HashSet<String>(numbers.length);
                for (DynamicObject o : numbers) {
                    numberSet.add((String)o.get("number"));
                }
                listShowParameter.setCustomParam("numberSet", numberSet);
                listShowParameter.getListFilterParameter().getQFilters().add(new QFilter("number", "not in", numberSet));
                listShowParameter.setCustomParam("viewStatus", (Object)OperationStatus.VIEW);
                this.getView().showForm((FormShowParameter)listShowParameter);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object currentNodeId = this.getTreeListView().getTreeModel().getCurrentNodeId();
        switch (actionId) {
            case "doclibtpl_addnew": {
                this.getView().updateView(KEY_TREEENTRYGRID);
                break;
            }
            case "doclibtpl_edit": {
                this.getView().updateView(KEY_TREEENTRYGRID);
                break;
            }
            case "import": {
                int index;
                HashMap map;
                Object importDirectory;
                Object returnMap = closedCallBackEvent.getReturnData();
                if (returnMap == null || (importDirectory = (map = (HashMap)returnMap).getOrDefault("importDirectory", null)) == null) break;
                DynamicObject[] importDirectorys = importDirectory;
                TreeEntryGrid grid = (TreeEntryGrid)this.getView().getControl(KEY_TREEENTRYGRID);
                int[] selectRows = grid.getSelectRows();
                DynamicObjectCollection gridRows = this.getModel().getEntryEntity(KEY_TREEENTRYGRID);
                StringBuilder failMessage = new StringBuilder();
                boolean isFail = false;
                if (selectRows != null && selectRows.length == 1) {
                    int index2 = selectRows[0];
                    DynamicObject upImportDO = BusinessDataServiceHelper.loadSingle((Object)((DynamicObject)((DynamicObject)gridRows.get(index2)).get("number")).getPkValue(), (String)FORM_ID);
                    HashSet<Long> ids = new HashSet<Long>(importDirectorys.length);
                    for (DynamicObject importDirectoryDo : importDirectorys) {
                        ids.add(Long.parseLong(importDirectoryDo.getPkValue().toString()));
                    }
                    DynamicObject docLibNameKindDO = BusinessDataServiceHelper.loadSingle((Object)Long.valueOf(currentNodeId.toString()), (String)"pmdc_doclibname");
                    QFilter idsQfilter = new QFilter(FIELD_ID, "in", ids);
                    DynamicObject[] toAddDirectorys = BusinessDataServiceHelper.load((String)"pmdc_docdirectorytpl", (String)"createtime,creator,enable,id,isleaf,kind,level,longnumber,masterid,modifier,modifytime,name,note,number,parent,status", (QFilter[])new QFilter[]{idsQfilter});
                    HashMap<Long, Integer> parentMap = new HashMap<Long, Integer>(toAddDirectorys.length);
                    DynamicObject[] newDirectory = new DynamicObject[toAddDirectorys.length + 1];
                    ORM orm = ORM.create();
                    long[] entryIds = orm.genLongIds((IDataEntityType)EntityMetadataCache.getDataEntityType((String)FORM_ID), toAddDirectorys.length);
                    for (index2 = 0; index2 < toAddDirectorys.length; ++index2) {
                        DynamicObject newDirectoryDO = BusinessDataServiceHelper.newDynamicObject((String)FORM_ID);
                        DynamicObjectUtils.copy((DynamicObject)toAddDirectorys[index2], (DynamicObject)newDirectoryDO);
                        long pkid = entryIds[index2];
                        newDirectoryDO.set(FIELD_ID, (Object)pkid);
                        newDirectoryDO.set("masterid", (Object)pkid);
                        newDirectoryDO.set("doclibname", (Object)docLibNameKindDO);
                        newDirectoryDO.set("level", (Object)((Integer)upImportDO.get("level") + 1));
                        newDirectoryDO.set("remark", toAddDirectorys[index2].get("note"));
                        parentMap.put(Long.parseLong(toAddDirectorys[index2].getPkValue().toString()), index2);
                        newDirectory[index2] = newDirectoryDO;
                    }
                    for (index2 = 0; index2 < toAddDirectorys.length; ++index2) {
                        Object parent = newDirectory[index2].get(FIELD_PARENT);
                        if (parent != null && ids.contains(((DynamicObject)parent).getPkValue())) {
                            Object parentID = ((DynamicObject)parent).getPkValue();
                            Integer parentIndex = parentMap.getOrDefault((Long)parentID, -1);
                            if (parentIndex == -1) continue;
                            newDirectory[index2].set(FIELD_PARENT, (Object)newDirectory[parentIndex]);
                            continue;
                        }
                        newDirectory[index2].set(FIELD_PARENT, (Object)upImportDO);
                    }
                    newDirectory[index2] = upImportDO;
                    upImportDO.set(FIELD_ISLEAF, (Object)false);
                    SaveServiceHelper.save((DynamicObject[])newDirectory);
                    this.getView().updateView(KEY_TREEENTRYGRID);
                    break;
                }
                HashSet<Long> ids = new HashSet<Long>(importDirectorys.length);
                for (DynamicObject importDirectoryDo : importDirectorys) {
                    ids.add(Long.parseLong(importDirectoryDo.getPkValue().toString()));
                }
                DynamicObject docLibNameKindDO = BusinessDataServiceHelper.loadSingle((Object)Long.valueOf(currentNodeId.toString()), (String)"pmdc_doclibname");
                QFilter idsQfilter = new QFilter(FIELD_ID, "in", ids);
                DynamicObject[] toAddDirectorys = BusinessDataServiceHelper.load((String)"pmdc_docdirectorytpl", (String)"createtime,creator,enable,id,isleaf,kind,level,longnumber,masterid,modifier,modifytime,name,note,number,parent,status", (QFilter[])new QFilter[]{idsQfilter});
                HashMap<Long, Integer> parentMap = new HashMap<Long, Integer>(toAddDirectorys.length);
                DynamicObject[] newDirectory = new DynamicObject[toAddDirectorys.length];
                ORM orm = ORM.create();
                long[] entryIds = orm.genLongIds((IDataEntityType)EntityMetadataCache.getDataEntityType((String)FORM_ID), toAddDirectorys.length);
                for (index = 0; index < toAddDirectorys.length; ++index) {
                    DynamicObject newDirectoryDO = BusinessDataServiceHelper.newDynamicObject((String)FORM_ID);
                    DynamicObjectUtils.copy((DynamicObject)toAddDirectorys[index], (DynamicObject)newDirectoryDO);
                    long pkid = entryIds[index];
                    newDirectoryDO.set(FIELD_ID, (Object)pkid);
                    newDirectoryDO.set("masterid", (Object)pkid);
                    newDirectoryDO.set("doclibname", (Object)docLibNameKindDO);
                    newDirectoryDO.set("remark", toAddDirectorys[index].get("note"));
                    parentMap.put(Long.parseLong(toAddDirectorys[index].getPkValue().toString()), index);
                    newDirectory[index] = newDirectoryDO;
                }
                for (index = 0; index < toAddDirectorys.length; ++index) {
                    Object parentID;
                    Integer parentIndex;
                    Object parent = newDirectory[index].get(FIELD_PARENT);
                    if (parent == null || (parentIndex = parentMap.getOrDefault((Long)(parentID = ((DynamicObject)parent).getPkValue()), -1)) == -1) continue;
                    newDirectory[index].set(FIELD_PARENT, (Object)newDirectory[parentIndex]);
                }
                SaveServiceHelper.save((DynamicObject[])newDirectory);
                this.getView().updateView(KEY_TREEENTRYGRID);
                break;
            }
        }
    }

    private void addAllEnableSons(Set<DynamicObject> enableSonList, List<Object> parentIds) {
        if (parentIds.size() > 0) {
            QFilter qFilter = new QFilter(FIELD_PARENT, "in", parentIds);
            qFilter.and(new QFilter(FIELD_ENABLE, "=", (Object)"1"));
            DynamicObject[] enableSons = BusinessDataServiceHelper.load((String)FORM_ID, (String)SELECTED_FIELDS, (QFilter[])new QFilter[]{qFilter});
            ArrayList<Object> parentPkList = new ArrayList<Object>();
            if (enableSons != null && enableSons.length > 0) {
                for (DynamicObject son : enableSons) {
                    son.set(FIELD_ENABLE, (Object)"0");
                    enableSonList.add(son);
                    parentPkList.add(son.getPkValue());
                }
            }
            this.addAllEnableSons(enableSonList, parentPkList);
        }
    }

    private void getAllLeafSons(Set<DynamicObject> leafSons, List<Object> parentIds) {
        if (parentIds.size() > 0) {
            QFilter qFilter = new QFilter(FIELD_PARENT, "in", parentIds);
            DynamicObject[] sons = BusinessDataServiceHelper.load((String)FORM_ID, (String)SELECTED_FIELDS, (QFilter[])new QFilter[]{qFilter});
            ArrayList<Object> parentPkList = new ArrayList<Object>();
            if (sons != null && sons.length > 0) {
                for (DynamicObject son : sons) {
                    if (son.getBoolean(FIELD_ISLEAF)) {
                        leafSons.add(son);
                        continue;
                    }
                    parentPkList.add(son.getPkValue());
                }
            }
            this.addAllEnableSons(leafSons, parentPkList);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        DynamicObjectCollection gridRows = this.getModel().getEntryEntity(KEY_TREEENTRYGRID);
        TreeEntryGrid grid = (TreeEntryGrid)this.getView().getControl(KEY_TREEENTRYGRID);
        int[] selectRows = grid.getSelectRows();
        ArrayList<Object> pkList = new ArrayList<Object>();
        for (int rowIndex : selectRows) {
            pkList.add(((DynamicObject)gridRows.get(rowIndex)).get(FIELD_ID));
        }
        DynamicObject[] docDirectories = BusinessDataServiceHelper.load((String)FORM_ID, (String)SELECTED_FIELDS, (QFilter[])new QFilter[]{new QFilter(FIELD_ID, "in", pkList)});
        int failCount = 0;
        StringBuilder failMessage = new StringBuilder();
        HashSet<DynamicObject> updateList = new HashSet<DynamicObject>();
        HashSet<Object> deleteIds = new HashSet<Object>();
        if (CALLBACKKEY_DISABLE.equals(callBackId) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            String oneFailMessage = "";
            ArrayList<Object> parentIds = new ArrayList<Object>();
            for (DynamicObject directory : docDirectories) {
                String isEnable = directory.getString(FIELD_ENABLE);
                if ("0".equals(isEnable)) {
                    failMessage.append(String.format(ResManager.loadKDString((String)"%s\uff1a\u6570\u636e\u5df2\u4e3a\u7981\u7528\u72b6\u6001\u3002", (String)"DocDirectoryListPlugin_11", (String)"pmgt-pmdc-formplugin", (Object[])new Object[0]) + "\r\n", directory.getString("number")));
                    oneFailMessage = ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e3a\u7981\u7528\u72b6\u6001\u3002", (String)"DocDirectoryListPlugin_28", (String)"pmgt-pmdc-formplugin", (Object[])new Object[0]);
                    ++failCount;
                    continue;
                }
                boolean isLeaf = directory.getBoolean(FIELD_ISLEAF);
                if (!isLeaf) {
                    HashSet<DynamicObject> leafSons = new HashSet<DynamicObject>();
                    ArrayList<Object> queryParentList = new ArrayList<Object>();
                    queryParentList.add(directory.getPkValue());
                    this.getAllLeafSons(leafSons, queryParentList);
                    boolean isRefrenced = false;
                    Object formId = "";
                    for (DynamicObject leaf : leafSons) {
                        List refList = BaseDataRefrenceHelper.getAllRefs((String)FORM_ID, (Object)leaf.getPkValue());
                        for (BaseDataRefenceKey baseDataRefenceKey : refList) {
                            String refFormId = baseDataRefenceKey.getRefEntityKey();
                            if (!"pmdc_docapply".equalsIgnoreCase(refFormId) && !"pmdc_collectrecord".equalsIgnoreCase(refFormId)) continue;
                            isRefrenced = true;
                            formId = refFormId;
                        }
                        boolean isDisable = "0".equals(leaf.get(FIELD_ENABLE));
                        if (!isDisable && !isRefrenced) continue;
                        break;
                    }
                    if (isRefrenced) {
                        if ("pmdc_docapply".equalsIgnoreCase((String)formId)) {
                            failMessage.append(String.format(ResManager.loadKDString((String)"%s\uff1a\u5f53\u524d\u76ee\u5f55\u4e0b\u5df2\u6709\u8d44\u6599\u7533\u8bf7\u8d44\u6599\uff0c\u65e0\u6cd5\u7981\u7528\uff0c\u8bf7\u5148\u5220\u9664\u5176\u4e0b\u8d44\u6599\u7533\u8bf7\u8d44\u6599\u540e\u518d\u8bd5\u3002", (String)"DocDirectoryListPlugin_37", (String)"pmgt-pmdc-formplugin", (Object[])new Object[0]) + "\r\n", directory.getString("number")));
                            oneFailMessage = ResManager.loadKDString((String)"\u5f53\u524d\u76ee\u5f55\u4e0b\u5df2\u6709\u8d44\u6599\u7533\u8bf7\u8d44\u6599\uff0c\u65e0\u6cd5\u7981\u7528\uff0c\u8bf7\u5148\u5220\u9664\u5176\u4e0b\u5f52\u6863\u8d44\u6599\u540e\u518d\u8bd5\u3002", (String)"DocDirectoryListPlugin_47", (String)"pmgt-pmdc-formplugin", (Object[])new Object[0]);
                            ++failCount;
                            continue;
                        }
                        if ("pmdc_collectrecord".equalsIgnoreCase((String)formId)) {
                            failMessage.append(String.format(ResManager.loadKDString((String)"%s\uff1a\u5f53\u524d\u76ee\u5f55\u4e0b\u5df2\u6709\u5f52\u6863\u8d44\u6599\uff0c\u65e0\u6cd5\u7981\u7528\uff0c\u8bf7\u5148\u5220\u9664\u5176\u4e0b\u5f52\u6863\u8d44\u6599\u540e\u518d\u8bd5\u3002", (String)"DocDirectoryListPlugin_39", (String)"pmgt-pmdc-formplugin", (Object[])new Object[0]) + "\r\n", directory.getString("number")));
                            oneFailMessage = ResManager.loadKDString((String)"\u5f53\u524d\u76ee\u5f55\u4e0b\u5df2\u6709\u5f52\u6863\u8d44\u6599\uff0c\u65e0\u6cd5\u7981\u7528\uff0c\u8bf7\u5148\u5220\u9664\u5176\u4e0b\u5f52\u6863\u8d44\u6599\u540e\u518d\u8bd5\u3002", (String)"DocDirectoryListPlugin_40", (String)"pmgt-pmdc-formplugin", (Object[])new Object[0]);
                            ++failCount;
                            continue;
                        }
                    }
                    parentIds.add(directory.getPkValue());
                } else {
                    boolean isRefrenced = false;
                    String formId = "";
                    List refList = BaseDataRefrenceHelper.getAllRefs((String)FORM_ID, (Object)directory.getPkValue());
                    for (BaseDataRefenceKey baseDataRefenceKey : refList) {
                        String refFormId = baseDataRefenceKey.getRefEntityKey();
                        if (!"pmdc_docapply".equalsIgnoreCase(refFormId) && !"pmdc_collectrecord".equalsIgnoreCase(refFormId)) continue;
                        isRefrenced = true;
                        formId = refFormId;
                    }
                    if (isRefrenced) {
                        if ("pmdc_docapply".equalsIgnoreCase(formId)) {
                            failMessage.append(String.format(ResManager.loadKDString((String)"%s\uff1a\u5f53\u524d\u76ee\u5f55\u4e0b\u5df2\u6709\u8d44\u6599\u7533\u8bf7\u8d44\u6599\uff0c\u65e0\u6cd5\u7981\u7528\uff0c\u8bf7\u5148\u5220\u9664\u5176\u4e0b\u8d44\u6599\u7533\u8bf7\u8d44\u6599\u540e\u518d\u8bd5\u3002", (String)"DocDirectoryListPlugin_37", (String)"pmgt-pmdc-formplugin", (Object[])new Object[0]) + "\r\n", directory.getString("number")));
                            oneFailMessage = ResManager.loadKDString((String)"\u5f53\u524d\u76ee\u5f55\u4e0b\u5df2\u6709\u8d44\u6599\u7533\u8bf7\u8d44\u6599\uff0c\u65e0\u6cd5\u7981\u7528\uff0c\u8bf7\u5148\u5220\u9664\u5176\u4e0b\u5f52\u6863\u8d44\u6599\u540e\u518d\u8bd5\u3002", (String)"DocDirectoryListPlugin_47", (String)"pmgt-pmdc-formplugin", (Object[])new Object[0]);
                            ++failCount;
                            continue;
                        }
                        if ("pmdc_collectrecord".equalsIgnoreCase(formId)) {
                            failMessage.append(String.format(ResManager.loadKDString((String)"%s\uff1a\u5f53\u524d\u76ee\u5f55\u4e0b\u5df2\u6709\u5f52\u6863\u8d44\u6599\uff0c\u65e0\u6cd5\u7981\u7528\uff0c\u8bf7\u5148\u5220\u9664\u5176\u4e0b\u5f52\u6863\u8d44\u6599\u540e\u518d\u8bd5\u3002", (String)"DocDirectoryListPlugin_39", (String)"pmgt-pmdc-formplugin", (Object[])new Object[0]) + "\r\n", directory.getString("number")));
                            oneFailMessage = ResManager.loadKDString((String)"\u5f53\u524d\u76ee\u5f55\u4e0b\u5df2\u6709\u5f52\u6863\u8d44\u6599\uff0c\u65e0\u6cd5\u7981\u7528\uff0c\u8bf7\u5148\u5220\u9664\u5176\u4e0b\u5f52\u6863\u8d44\u6599\u540e\u518d\u8bd5\u3002", (String)"DocDirectoryListPlugin_40", (String)"pmgt-pmdc-formplugin", (Object[])new Object[0]);
                            ++failCount;
                            continue;
                        }
                    }
                }
                directory.set(FIELD_ENABLE, (Object)"0");
                updateList.add(directory);
            }
            this.addAllEnableSons(updateList, parentIds);
            SaveServiceHelper.save((DynamicObject[])updateList.toArray(new DynamicObject[0]));
            if (failCount > 0) {
                if (selectRows.length == 1) {
                    this.getView().showTipNotification(oneFailMessage);
                } else {
                    String msg = String.format(ResManager.loadKDString((String)"\u5171%1$s\u5f20\u5355\u636e\uff0c\u6210\u529f\u7981\u7528%2$s\u5f20\uff0c\u5931\u8d25%3$s\u5f20\u3002", (String)"DocDirectoryListPlugin_12", (String)"pmgt-pmdc-formplugin", (Object[])new Object[0]), updateList.size() + failCount, updateList.size(), failCount);
                    this.getView().showConfirm(msg, failMessage.toString(), MessageBoxOptions.OK, ConfirmTypes.Default, null);
                }
            } else {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u7981\u7528\u6210\u529f\u3002", (String)"DocDirectoryListPlugin_13", (String)"pmgt-pmdc-formplugin", (Object[])new Object[0]));
            }
            this.getView().updateView(KEY_TREEENTRYGRID);
        } else if (CALLBACKKEY_DELETE.equals(callBackId) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            String oneFailMessage = "";
            LinkedList<Object> parentIdList = new LinkedList<Object>();
            for (DynamicObject directory : docDirectories) {
                String isEnable = directory.getString(FIELD_ENABLE);
                if ("0".equals(isEnable)) {
                    failMessage.append(String.format(ResManager.loadKDString((String)"%s\uff1a\u6570\u636e\u5df2\u7981\u7528\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"DocDirectoryListPlugin_41", (String)"pmgt-pmdc-formplugin", (Object[])new Object[0]) + "\r\n", directory.getString("number")));
                    oneFailMessage = ResManager.loadKDString((String)"\u6570\u636e\u5df2\u7981\u7528\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"DocDirectoryListPlugin_16", (String)"pmgt-pmdc-formplugin", (Object[])new Object[0]);
                    ++failCount;
                    continue;
                }
                boolean isLeaf = directory.getBoolean(FIELD_ISLEAF);
                if (!isLeaf) {
                    DynamicObject children;
                    DynamicObject[] allChildren;
                    HashSet<DynamicObject> leafSons = new HashSet<DynamicObject>();
                    ArrayList<Object> queryParentList = new ArrayList<Object>();
                    queryParentList.add(directory.getPkValue());
                    this.getAllLeafSons(leafSons, queryParentList);
                    boolean isRefrenced = false;
                    String formId = "";
                    boolean isDisable = false;
                    for (DynamicObject leaf : leafSons) {
                        List refList = BaseDataRefrenceHelper.getAllRefs((String)FORM_ID, (Object)leaf.getPkValue());
                        for (BaseDataRefenceKey baseDataRefenceKey : refList) {
                            String refFormId = baseDataRefenceKey.getRefEntityKey();
                            if (!"pmdc_docapply".equalsIgnoreCase(refFormId) && !"pmdc_collectrecord".equalsIgnoreCase(refFormId)) continue;
                            isRefrenced = true;
                            formId = refFormId;
                        }
                        isDisable = "0".equals(leaf.get(FIELD_ENABLE));
                        if (!isDisable && !isRefrenced) continue;
                        break;
                    }
                    if (isRefrenced) {
                        if ("pmdc_docapply".equalsIgnoreCase(formId)) {
                            failMessage.append(String.format(ResManager.loadKDString((String)"%s\uff1a\u5f53\u524d\u76ee\u5f55\u4e0b\u5df2\u6709\u8d44\u6599\u7533\u8bf7\u8d44\u6599\uff0c\u65e0\u6cd5\u5220\u9664\uff0c\u8bf7\u5148\u5220\u9664\u5176\u4e0b\u8d44\u6599\u7533\u8bf7\u8d44\u6599\u540e\u518d\u8bd5\u3002", (String)"DocDirectoryListPlugin_42", (String)"pmgt-pmdc-formplugin", (Object[])new Object[0]) + "\r\n", directory.getString("number")));
                            oneFailMessage = ResManager.loadKDString((String)"\u5f53\u524d\u76ee\u5f55\u4e0b\u5df2\u6709\u8d44\u6599\u7533\u8bf7\u8d44\u6599\uff0c\u65e0\u6cd5\u5220\u9664\uff0c\u8bf7\u5148\u5220\u9664\u5176\u4e0b\u8d44\u6599\u7533\u8bf7\u8d44\u6599\u540e\u518d\u8bd5\u3002", (String)"DocDirectoryListPlugin_43", (String)"pmgt-pmdc-formplugin", (Object[])new Object[0]);
                            ++failCount;
                            continue;
                        }
                        if ("pmdc_collectrecord".equalsIgnoreCase(formId)) {
                            failMessage.append(String.format(ResManager.loadKDString((String)"%s\uff1a\u5f53\u524d\u76ee\u5f55\u4e0b\u5df2\u6709\u5f52\u6863\u8d44\u6599\uff0c\u65e0\u6cd5\u5220\u9664\uff0c\u8bf7\u5148\u5220\u9664\u5176\u4e0b\u5f52\u6863\u8d44\u6599\u540e\u518d\u8bd5\u3002", (String)"DocDirectoryListPlugin_44", (String)"pmgt-pmdc-formplugin", (Object[])new Object[0]) + "\r\n", directory.getString("number")));
                            oneFailMessage = ResManager.loadKDString((String)"\u5f53\u524d\u76ee\u5f55\u4e0b\u5df2\u6709\u5f52\u6863\u8d44\u6599\uff0c\u65e0\u6cd5\u5220\u9664\uff0c\u8bf7\u5148\u5220\u9664\u5176\u4e0b\u5f52\u6863\u8d44\u6599\u540e\u518d\u8bd5\u3002", (String)"DocDirectoryListPlugin_45", (String)"pmgt-pmdc-formplugin", (Object[])new Object[0]);
                            ++failCount;
                            continue;
                        }
                    }
                    HashSet<Object> childrenIds = new HashSet<Object>();
                    childrenIds.add(directory.getPkValue());
                    this.addAllSons(childrenIds, childrenIds);
                    DynamicObject[] dynamicObjectArray = allChildren = BusinessDataServiceHelper.load((Object[])childrenIds.toArray(new Object[0]), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)FORM_ID));
                    int n = dynamicObjectArray.length;
                    for (int i = 0; i < n && !(isDisable = "0".equals((children = dynamicObjectArray[i]).get(FIELD_ENABLE))); ++i) {
                    }
                    if (isDisable) {
                        failMessage.append(String.format(ResManager.loadKDString((String)"%s\uff1a\u5176\u4e0b\u7ea7\u76ee\u5f55\u5df2\u88ab\u7981\u7528\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"DocDirectoryListPlugin_48", (String)"pmgt-pmdc-formplugin", (Object[])new Object[0]) + "\r\n", directory.getString("number")));
                        oneFailMessage = ResManager.loadKDString((String)"\u5176\u4e0b\u7ea7\u76ee\u5f55\u5df2\u88ab\u7981\u7528\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"DocDirectoryListPlugin_49", (String)"pmgt-pmdc-formplugin", (Object[])new Object[0]);
                        ++failCount;
                        continue;
                    }
                } else {
                    boolean isDisable;
                    boolean isRefrenced = false;
                    String formId = "";
                    List refList = BaseDataRefrenceHelper.getAllRefs((String)FORM_ID, (Object)directory.getPkValue());
                    for (BaseDataRefenceKey baseDataRefenceKey : refList) {
                        String refFormId = baseDataRefenceKey.getRefEntityKey();
                        if (!"pmdc_docapply".equalsIgnoreCase(refFormId) && !"pmdc_collectrecord".equalsIgnoreCase(refFormId)) continue;
                        isRefrenced = true;
                        formId = refFormId;
                    }
                    if (isRefrenced) {
                        if ("pmdc_docapply".equalsIgnoreCase(formId)) {
                            failMessage.append(String.format(ResManager.loadKDString((String)"%s\uff1a\u5f53\u524d\u76ee\u5f55\u4e0b\u5df2\u6709\u8d44\u6599\u7533\u8bf7\u8d44\u6599\uff0c\u65e0\u6cd5\u5220\u9664\uff0c\u8bf7\u5148\u5220\u9664\u5176\u4e0b\u8d44\u6599\u7533\u8bf7\u8d44\u6599\u540e\u518d\u8bd5\u3002", (String)"DocDirectoryListPlugin_42", (String)"pmgt-pmdc-formplugin", (Object[])new Object[0]) + "\r\n", directory.getString("number")));
                            oneFailMessage = ResManager.loadKDString((String)"\u5f53\u524d\u76ee\u5f55\u4e0b\u5df2\u6709\u8d44\u6599\u7533\u8bf7\u8d44\u6599\uff0c\u65e0\u6cd5\u5220\u9664\uff0c\u8bf7\u5148\u5220\u9664\u5176\u4e0b\u8d44\u6599\u7533\u8bf7\u8d44\u6599\u540e\u518d\u8bd5\u3002", (String)"DocDirectoryListPlugin_43", (String)"pmgt-pmdc-formplugin", (Object[])new Object[0]);
                            ++failCount;
                            continue;
                        }
                        if ("pmdc_collectrecord".equalsIgnoreCase(formId)) {
                            failMessage.append(String.format(ResManager.loadKDString((String)"%s\uff1a\u5f53\u524d\u76ee\u5f55\u4e0b\u5df2\u6709\u5f52\u6863\u8d44\u6599\uff0c\u65e0\u6cd5\u5220\u9664\uff0c\u8bf7\u5148\u5220\u9664\u5176\u4e0b\u5f52\u6863\u8d44\u6599\u540e\u518d\u8bd5\u3002", (String)"DocDirectoryListPlugin_44", (String)"pmgt-pmdc-formplugin", (Object[])new Object[0]) + "\r\n", directory.getString("number")));
                            oneFailMessage = ResManager.loadKDString((String)"\u5f53\u524d\u76ee\u5f55\u4e0b\u5df2\u6709\u5f52\u6863\u8d44\u6599\uff0c\u65e0\u6cd5\u5220\u9664\uff0c\u8bf7\u5148\u5220\u9664\u5176\u4e0b\u5f52\u6863\u8d44\u6599\u540e\u518d\u8bd5\u3002", (String)"DocDirectoryListPlugin_45", (String)"pmgt-pmdc-formplugin", (Object[])new Object[0]);
                            ++failCount;
                            continue;
                        }
                    }
                    if (isDisable = "0".equals(directory.get(FIELD_ENABLE))) {
                        failMessage.append(String.format(ResManager.loadKDString((String)"%s\uff1a\u5176\u4e0b\u7ea7\u76ee\u5f55\u5df2\u88ab\u7981\u7528\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"DocDirectoryListPlugin_48", (String)"pmgt-pmdc-formplugin", (Object[])new Object[0]) + "\r\n", directory.getString("number")));
                        oneFailMessage = ResManager.loadKDString((String)"\u5176\u4e0b\u7ea7\u76ee\u5f55\u5df2\u88ab\u7981\u7528\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"DocDirectoryListPlugin_49", (String)"pmgt-pmdc-formplugin", (Object[])new Object[0]);
                        ++failCount;
                        continue;
                    }
                }
                deleteIds.add(directory.getPkValue());
                DynamicObject parent = directory.getDynamicObject(FIELD_PARENT);
                if (parent == null) continue;
                parentIdList.add(parent.getPkValue());
            }
            QFilter qFilter = new QFilter(FIELD_ID, "in", parentIdList);
            DynamicObject[] parents = BusinessDataServiceHelper.load((String)FORM_ID, (String)SELECTED_FIELDS, (QFilter[])new QFilter[]{qFilter});
            this.deleteDirectory(deleteIds, parents);
            if (failCount > 0) {
                if (selectRows.length == 1) {
                    this.getView().showTipNotification(oneFailMessage);
                } else {
                    String msg = String.format(ResManager.loadKDString((String)"\u5171%1$s\u5f20\u5355\u636e\uff0c\u6210\u529f\u5220\u9664%2$s\u5f20\uff0c\u5931\u8d25%3$s\u5f20\u3002", (String)"DocDirectoryListPlugin_18", (String)"pmgt-pmdc-formplugin", (Object[])new Object[0]), selectRows.length, deleteIds.size(), failCount);
                    this.getView().showConfirm(msg, failMessage.toString(), MessageBoxOptions.OK, ConfirmTypes.Default, null);
                }
            } else {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"DocDirectoryListPlugin_19", (String)"pmgt-pmdc-formplugin", (Object[])new Object[0]));
            }
            this.getView().updateView(KEY_TREEENTRYGRID);
        }
    }

    public void cellClick(CellClickEvent arg0) {
        String fieldKey = arg0.getFieldKey();
        String formId = this.getView().getFormShowParameter().getFormId();
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        boolean isMultiSelect = listShowParameter.isMultiSelect();
        TreeEntryGrid grid = (TreeEntryGrid)arg0.getSource();
        int row = arg0.getRow();
        int[] selectRows = grid.getSelectRows();
        if (!isMultiSelect && selectRows != null && selectRows.length > 0) {
            grid.selectRows(new int[]{row}, row);
            Object chooseSource = listShowParameter.getCustomParam("chooseSource");
            if ("collect".equals(chooseSource)) {
                DynamicObject rowEntity = (DynamicObject)this.getModel().getEntryEntity(KEY_TREEENTRYGRID).get(row);
                DynamicObject docDirectory = (DynamicObject)rowEntity.get("number");
                if ("false".equals(docDirectory.get(FIELD_ISLEAF).toString())) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u53f6\u5b50\u8282\u70b9\u3002", (String)"DocDirectoryListPlugin_33", (String)"pmgt-pmdc-formplugin", (Object[])new Object[0]));
                    grid.selectRows(new int[0], 0);
                } else {
                    grid.selectRows(new int[]{row}, row);
                }
            } else {
                grid.selectRows(new int[]{row}, row);
            }
        }
        if (isMultiSelect && "pmdc_docdirectoryf7".equals(formId)) {
            if (!(arg0.getSource() instanceof TreeEntryGrid)) {
                return;
            }
            this.processAutoSelect((EventObject)arg0, fieldKey);
        }
    }

    private synchronized void processAutoSelect(EventObject evt, String fieldKey) {
        Map<String, int[]> treeFixedSeletedRowMap;
        int[] ints;
        Boolean includetree;
        TreeEntryGrid treeEntryGrid = (TreeEntryGrid)evt.getSource();
        Control control = this.getControl("includetreeclick");
        if (control != null && !(includetree = (Boolean)this.getModel().getValue("includetreeclick")).booleanValue()) {
            return;
        }
        String treekey = treeEntryGrid.getKey();
        String cacheKey = this.getCacheKey(treekey);
        Set<Integer> selectRows = this.getSelectRows(treekey);
        if (selectRows.size() == 0 && (ints = (treeFixedSeletedRowMap = this.getTreeFixedSeletedRowMap()).get(treekey)) != null && ints.length > 0) {
            Set<Integer> fixedSelectedRow = Arrays.stream(ints).boxed().collect(Collectors.toSet());
            this.unSelectAll(treeEntryGrid, this.getCacheKey(treekey), selectRows, fixedSelectedRow);
        }
        this.autoSelect(treekey, cacheKey);
    }

    public Map<String, int[]> getTreeFixedSeletedRowMap() {
        Map<String, Object> map = new HashMap<String, int[]>();
        String fixedSelectedRowMapCahceStr = this.getPageCache().get(fixedSeletedRowMapKey);
        if (fixedSelectedRowMapCahceStr != null) {
            map = (Map)JSON.parseObject((String)fixedSelectedRowMapCahceStr, (TypeReference)new TypeReference<HashMap<String, int[]>>(){}, (Feature[])new Feature[0]);
        }
        return map;
    }

    private void unSelectAll(TreeEntryGrid treeEntryGrid, String cacheKey, Set<Integer> selectRows, Set<Integer> fixedSelectedRow) {
        selectRows.addAll(fixedSelectedRow);
        this.getPageCache().put(cacheKey, JSON.toJSONString(selectRows));
        int[] ints1 = selectRows.stream().mapToInt(o -> o).toArray();
        treeEntryGrid.selectRows(ints1, ints1[0]);
    }

    private Set<Integer> getParents(DynamicObjectCollection entries, DynamicObject curRow, Set<Integer> resultRows) {
        Long pid = (Long)curRow.get("pid");
        if (pid == null || pid.equals(0L)) {
            return resultRows;
        }
        Object[] rowparent = this.findRowEntiy(entries, pid);
        if (rowparent == null) {
            return resultRows;
        }
        Integer prow = (Integer)rowparent[0];
        DynamicObject parent = (DynamicObject)rowparent[1];
        if (rowparent[1] != null) {
            resultRows.add(prow);
            return this.getParents(entries, parent, resultRows);
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u76ee\u5f55\u6811\u5f02\u5e38", (String)"DocDirectoryListPlugin_24", (String)"pmgt-pmdc-formplugin", (Object[])new Object[0]));
    }

    private void autoSelect(String treekey, String cacheKey) {
        Optional clickRowOption;
        String selectRowsStr = this.getPageCache().get(cacheKey);
        Set selectCache = new HashSet();
        if (selectRowsStr != null) {
            selectCache = (Set)JSON.parseObject((String)selectRowsStr, (TypeReference)new TypeReference<HashSet<Integer>>(){}, (Feature[])new Feature[0]);
        }
        Set<Integer> selectRows = this.getSelectRows(treekey);
        Set<Integer> newSelectRows = this.getSelectRows(treekey);
        int clickRow = -1;
        boolean isSelect = false;
        if (selectRows.size() > selectCache.size()) {
            isSelect = true;
            selectRows.removeAll(selectCache);
            clickRowOption = selectRows.stream().findFirst();
        } else {
            isSelect = false;
            selectCache.removeAll(selectRows);
            clickRowOption = selectCache.stream().findFirst();
        }
        if (!clickRowOption.isPresent()) {
            return;
        }
        clickRow = (Integer)clickRowOption.get();
        DynamicObject rowEntity = this.getModel().getEntryRowEntity(treekey, clickRow);
        DynamicObjectCollection entries = this.getModel().getEntryEntity(treekey);
        if (isSelect) {
            Set<Integer> parents = this.getParents(entries, rowEntity, new HashSet<Integer>());
            Set<Integer> children = this.getChildren(entries, rowEntity, new HashSet<Integer>());
            newSelectRows.addAll(parents);
            newSelectRows.addAll(children);
        } else if (!this.isFixedSelectRow(treekey, clickRow)) {
            this.removeNoChildrenParents(entries, rowEntity, clickRow, newSelectRows);
            Set<Integer> children = this.getChildren(entries, rowEntity, new HashSet<Integer>());
            newSelectRows.removeAll(children);
        } else {
            newSelectRows.add(clickRow);
        }
        int[] ints = newSelectRows.stream().mapToInt(o -> o).toArray();
        TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getControl(treekey);
        treeEntryGrid.selectRows(ints, clickRow);
        this.getPageCache().put(cacheKey, JSON.toJSONString(newSelectRows));
    }

    private void removeNoChildrenParents(DynamicObjectCollection entries, DynamicObject rowEntity, int curRow, Set<Integer> selectRows) {
        if (rowEntity == null) {
            return;
        }
        Long pid = (Long)rowEntity.get("pid");
        selectRows.remove(curRow);
        if (pid == null || pid.equals(0L)) {
            return;
        }
        boolean hasChildren = false;
        int row = -1;
        DynamicObject noChildrenParent = null;
        for (int i = 0; i < entries.size(); ++i) {
            DynamicObject entity = (DynamicObject)entries.get(i);
            Long pid1 = (Long)entity.get("pid");
            Long id = (Long)entity.get(FIELD_ID);
            if (row == -1 && pid.equals(id)) {
                noChildrenParent = entity;
                row = i;
            }
            if (!pid.equals(pid1) || !selectRows.contains(i)) continue;
            hasChildren = true;
        }
        if (hasChildren) {
            return;
        }
        this.removeNoChildrenParents(entries, noChildrenParent, row, selectRows);
    }

    private boolean isFixedSelectRow(String treeKey, int row) {
        long count;
        Map<String, int[]> treeFixedSeletedRowMap = this.getTreeFixedSeletedRowMap();
        int[] ints = treeFixedSeletedRowMap.get(treeKey);
        return ints != null && (count = Arrays.stream(ints).filter(i -> i == row).count()) > 0L;
    }

    private Set<Integer> getChildren(DynamicObjectCollection entries, DynamicObject curRow, Set<Integer> resultRows) {
        if (curRow == null) {
            return resultRows;
        }
        Long id = (Long)curRow.get(FIELD_ID);
        List<Object[]> children = this.findChildren(entries, id);
        if (children != null && children.size() > 0) {
            for (Object[] child : children) {
                resultRows.add((Integer)child[0]);
                this.getChildren(entries, (DynamicObject)child[1], resultRows);
            }
            return resultRows;
        }
        return resultRows;
    }

    private List<Object[]> findChildren(DynamicObjectCollection entries, Long id) {
        ArrayList<Object[]> rowObjects = new ArrayList<Object[]>();
        for (int i = 0; i < entries.size(); ++i) {
            DynamicObject rowEntity = (DynamicObject)entries.get(i);
            if (!id.equals(rowEntity.getLong("pid"))) continue;
            Object[] rowObject = new Object[]{i, rowEntity};
            rowObjects.add(rowObject);
        }
        return rowObjects;
    }

    private Object[] findRowEntiy(DynamicObjectCollection entries, Long id) {
        Object[] rowObject = null;
        for (int i = 0; i < entries.size(); ++i) {
            DynamicObject rowEntity = (DynamicObject)entries.get(i);
            if (!id.equals(rowEntity.getLong(FIELD_ID))) continue;
            rowObject = new Object[]{i, rowEntity};
            break;
        }
        return rowObject;
    }

    public void cellDoubleClick(CellClickEvent cellClickEvent) {
    }

    public void search(SearchEnterEvent evt) {
        Search search = (Search)evt.getSource();
        String searchText = evt.getText();
        IPageCache pageCache = this.getPageCache();
        String searchKey = search.getKey();
        if (null == searchText || searchText.length() == 0) {
            return;
        }
        if ("treesearchap".equals(searchKey)) {
            Long node;
            String searchPos;
            String oldSearchText = pageCache.get(OLD_TREE_SEARCH_TEXT_KEY);
            if (oldSearchText == null || !oldSearchText.equals(searchText)) {
                pageCache.put(OLD_TREE_SEARCH_TEXT_KEY, searchText);
                ArrayList<QFilter> filterList = new ArrayList<QFilter>();
                filterList.add(new QFilter("name", "like", (Object)("%" + searchText + "%")));
                DynamicObject[] authorizedDirectoryList = this.directoryService.getAuthorizedDirectoryList(filterList);
                searchResult = Arrays.stream(authorizedDirectoryList).map(DataEntityBase::getPkValue).collect(Collectors.toList());
                searchPos = "0";
                pageCache.put(SEARCH_RESULT_LIST_POSITION, searchPos);
            } else {
                searchPos = pageCache.get(SEARCH_RESULT_LIST_POSITION);
            }
            if (searchResult == null || searchResult.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u641c\u7d22\u5df2\u5b8c\u6210\uff0c\u672a\u627e\u5230\u5339\u914d\u9879\u3002", (String)"DocDirectoryListPlugin_34", (String)"pmgt-pmdc-formplugin", (Object[])new Object[0]));
                return;
            }
            if (Integer.parseInt(searchPos) < searchResult.size() && (node = (Long)searchResult.get(Integer.parseInt(searchPos))) != null) {
                TreeView treeView = (TreeView)this.getView().getControl(TREE_VIEW);
                TreeNode searchPosNode = new TreeNode("", node.toString(), "");
                treeView.focusNode(searchPosNode);
                treeView.showNode(searchPosNode.getId());
                treeView.treeNodeClick("", searchPosNode.getId());
            }
            if (Integer.parseInt(searchPos) + 1 >= searchResult.size()) {
                pageCache.put(SEARCH_RESULT_LIST_POSITION, "0");
            } else {
                pageCache.put(SEARCH_RESULT_LIST_POSITION, Integer.parseInt(searchPos) + 1 + "");
            }
        }
    }
}

