/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmdc.formplugin.docapply;

import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleDynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentDto;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.attachment.AttachmentFieldServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmgt.pmbs.common.enums.EnableEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmdc.business.directory.DirectoryService;
import kd.pmgt.pmdc.formplugin.base.AbstractPmdcBillPlugin;
import org.jetbrains.annotations.NotNull;

public class DocApplyEditPlugin
extends AbstractPmdcBillPlugin
implements BeforeF7SelectListener {
    private static final Log logger = LogFactory.getLog(DocApplyEditPlugin.class);
    private static final String ORIGINAL_DOC_LIB_NUMBER = "originaldoclib";
    private DirectoryService directoryService = new DirectoryService();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit docDir = (BasedataEdit)this.getControl("docdirectory");
        if (docDir != null) {
            docDir.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        String billStatus = (String)this.getModel().getValue("billstatus");
        if (StatusEnum.TEMPSAVE.getValue().equals(billStatus)) {
            String billNo;
            Map customMap;
            String docDirectoryPk;
            if (this.getModel().getValue("date") == null) {
                this.getModel().setValue("date", (Object)new Date());
            }
            if (StringUtils.isEmpty((CharSequence)(docDirectoryPk = (String)(customMap = this.getView().getFormShowParameter().getCustomParams()).get("docdirectorypk")))) {
                return;
            }
            DynamicObject docDirectory = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(docDirectoryPk), (String)"pmdc_docdirectory");
            DynamicObjectCollection docApplyEntries = this.getModel().getEntryEntity("entryentity");
            DynamicObjectType entryDT = docApplyEntries.getDynamicObjectType();
            DynamicObject entry = new DynamicObject(entryDT);
            entry.set("docdirectory", (Object)docDirectory);
            String formId = "pmdc_fileno";
            DynamicObject goal = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)formId));
            goal.set("doclibname", (Object)docDirectory.getDynamicObject("doclibname"));
            goal.set("docdirectory", (Object)docDirectory);
            boolean isExistCodeRule = CodeRuleServiceHelper.isExist((String)formId, (DynamicObject)goal, (String)String.valueOf(RequestContext.get().getOrgId()));
            if (isExistCodeRule && (billNo = CodeRuleServiceHelper.getNumber((String)formId, (DynamicObject)goal, (String)String.valueOf(RequestContext.get().getOrgId()))) != null) {
                entry.set("fileno", (Object)billNo);
            }
            docApplyEntries.add((Object)entry);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        Object newValue = changeData.getNewValue();
        Object oldValue = changeData.getOldValue();
        int rowIndex = changeData.getRowIndex();
        switch (name) {
            case "attachment": {
                MulBasedataDynamicObjectCollection attachments = (MulBasedataDynamicObjectCollection)newValue;
                if (attachments.size() == 1) {
                    Object attachmentId = ((DynamicObject)attachments.get(0)).get("fbasedataid_id");
                    this.getModel().setValue("bdattachment", attachmentId, rowIndex);
                }
                if (!attachments.isEmpty()) break;
                this.getModel().setValue("bdattachment", null, rowIndex);
                break;
            }
            case "docdirectory": {
                String billNo;
                DynamicObject docDirectory = (DynamicObject)newValue;
                if (newValue == null) {
                    return;
                }
                String formId = "pmdc_fileno";
                DynamicObject goal = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)formId));
                goal.set("doclibname", (Object)docDirectory.getDynamicObject("doclibname"));
                goal.set("docdirectory", (Object)docDirectory);
                boolean isExistCodeRule = CodeRuleServiceHelper.isExist((String)formId, (DynamicObject)goal, (String)String.valueOf(RequestContext.get().getOrgId()));
                if (!isExistCodeRule || (billNo = CodeRuleServiceHelper.getNumber((String)formId, (DynamicObject)goal, (String)String.valueOf(RequestContext.get().getOrgId()))) == null) break;
                this.getModel().setValue("fileno", (Object)billNo, rowIndex);
                this.getView().updateView("fileno", rowIndex);
                break;
            }
            case "fileno": {
                if (newValue == null || StringUtils.isEmpty((CharSequence)newValue.toString())) {
                    return;
                }
                LocaleString newLocale = this.getLocaleString((LocaleDynamicObjectCollection)newValue, "fileno");
                LocaleString oldLocale = this.getLocaleString((LocaleDynamicObjectCollection)oldValue, "fileno");
                if (StringUtils.isBlank((CharSequence)newLocale.getLocaleValue())) {
                    return;
                }
                DynamicObjectCollection docItems = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
                for (int i = 0; i < docItems.size(); ++i) {
                    if (i == rowIndex || !newLocale.getLocaleValue().equals(((DynamicObject)docItems.get(i)).getLocaleString("fileno").getLocaleValue())) continue;
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u6863\u6848\u53f7\u5b58\u5728\u91cd\u590d\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\u3002", (String)"DocApplyEditPlugin_0", (String)"pmgt-pmdc-formplugin", (Object[])new Object[0]));
                    this.getModel().setValue("fileno", (Object)oldLocale, rowIndex);
                }
                break;
            }
        }
    }

    @NotNull
    private LocaleString getLocaleString(LocaleDynamicObjectCollection newValue, String fieldName) {
        LocaleDynamicObjectCollection newFileNo = newValue;
        HashMap<String, String> nameMap = new HashMap<String, String>(16);
        for (DynamicObject dyn : newFileNo) {
            nameMap.put(dyn.getString("localeid"), dyn.getString(fieldName));
        }
        return LocaleString.fromMap(nameMap);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        switch (operateKey = args.getOperateKey()) {
            case "submit": 
            case "unsubmit": 
            case "unaudit": {
                DynamicObject[] docItems = this.setDocItemStatus();
                SaveServiceHelper.update((DynamicObject[])docItems);
                DynamicObjectCollection collectEntities = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
                for (DynamicObject collectEntity : collectEntities) {
                    collectEntity.set("docitemenable", (Object)EnableEnum.ENABLE.getValue());
                }
                this.getView().updateView("entryentity");
                break;
            }
            case "audit": {
                DynamicObject[] docItems = this.setDocItemStatus();
                DynamicObjectCollection docItemCollection = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
                for (DynamicObject docItemEntry : docItemCollection) {
                    MulBasedataDynamicObjectCollection att = (MulBasedataDynamicObjectCollection)docItemEntry.get("attachment");
                    AttachmentDto attachmentInfoByAttPk = AttachmentFieldServiceHelper.getAttachmentInfoByAttPk((Object)((DynamicObject)att.get(0)).get("fbasedataId_id"));
                    DynamicObject docItem = Arrays.stream(docItems).filter(it -> it.getPkValue().toString().equals(docItemEntry.getPkValue().toString())).findFirst().orElse(null);
                    if (docItem == null) continue;
                    docItem.set("resourcepath", (Object)attachmentInfoByAttPk.getResourcePath());
                    docItem.set("number", (Object)attachmentInfoByAttPk.getFilename());
                    docItem.set("name", (Object)attachmentInfoByAttPk.getFilename());
                }
                SaveServiceHelper.update((DynamicObject[])docItems);
                break;
            }
        }
    }

    @NotNull
    private DynamicObject[] setDocItemStatus() {
        DynamicObject[] docItems;
        Object billStatus = this.getModel().getValue("billstatus");
        DynamicObjectCollection docItemCollection = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        QFilter pkFilter = new QFilter("id", "in", docItemCollection.stream().map(DataEntityBase::getPkValue).collect(Collectors.toSet()));
        for (DynamicObject docItem : docItems = BusinessDataServiceHelper.load((String)"pmdc_docitem", (String)"id, status, enable, doctype, resourcepath, sourcebill, createtime", (QFilter[])new QFilter[]{pkFilter})) {
            DynamicObject docItemEntry = docItemCollection.stream().filter(it -> it.getPkValue().toString().equals(docItem.getPkValue().toString())).findFirst().orElse(null);
            if (docItemEntry == null) continue;
            MulBasedataDynamicObjectCollection att = (MulBasedataDynamicObjectCollection)docItemEntry.get("attachment");
            if (!att.isEmpty()) {
                ILocaleString attName = ((DynamicObject)((DynamicObject)att.get(0)).get("fbasedataid")).getLocaleString("name");
                docItem.set("number", (Object)attName);
                docItem.set("name", (Object)attName);
            }
            docItem.set("createtime", (Object)new Date());
            docItem.set("status", billStatus);
            docItem.set("doctype", (Object)2);
            docItem.set("sourcebill", (Object)this.getView().getFormShowParameter().getFormId());
        }
        return docItems;
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String key;
        super.beforeF7Select(event);
        switch (key = event.getProperty().getName()) {
            case "docdirectory": {
                ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
                CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "docdirectory");
                showParameter.setCustomParam("chooseSource", (Object)"collect");
                showParameter.getListFilterParameter().getQFilters().add(new QFilter("enable", "=", (Object)EnableEnum.ENABLE.getValue()));
                showParameter.setCustomParam("viewStatus", (Object)OperationStatus.VIEW);
                if ("getLookUpList".equals(event.getSourceMethod())) {
                    Set authorizedDocLibNameList = this.directoryService.getAuthorizedDocLibNameList();
                    showParameter.getListFilterParameter().getQFilters().add(new QFilter("doclibname", "in", (Object)authorizedDocLibNameList));
                    showParameter.getListFilterParameter().getQFilters().add(new QFilter("doclibname.number", "!=", (Object)ORIGINAL_DOC_LIB_NUMBER));
                    showParameter.getListFilterParameter().getQFilters().add(new QFilter("isleaf", "=", (Object)"1"));
                }
                showParameter.setMultiSelect(false);
                showParameter.setCloseCallBack(callBack);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        String actionId = event.getActionId();
        if ("docdirectory".equalsIgnoreCase(actionId)) {
            Map returnData = (Map)event.getReturnData();
            if (returnData == null || returnData.size() == 0) {
                return;
            }
            DynamicObject docDir = (DynamicObject)returnData.get("parent");
            if (docDir == null) {
                return;
            }
            int rowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
            this.getModel().setValue("docdirectory", (Object)docDir, rowIndex);
        }
    }
}

