/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmdc.formplugin.docborrow;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.form.FormShowParameter;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pmgt.pmbs.business.helper.UserOrgRangeHelper;
import kd.pmgt.pmdc.formplugin.base.AbstractPmdcBillPlugin;

public class DocBorrowEditPlugin
extends AbstractPmdcBillPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit docBorrowUser = (BasedataEdit)this.getControl("borrowuser");
        if (docBorrowUser != null) {
            docBorrowUser.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent args) {
        super.beforeF7Select(args);
        String key = args.getProperty().getName();
        ListShowParameter param = (ListShowParameter)args.getFormShowParameter();
        if ("borrowuser".equals(key)) {
            List qFilterList = param.getListFilterParameter().getQFilters();
            long currUserId = RequestContext.get().getCurrUserId();
            QFilter userOrgFilter = UserOrgRangeHelper.loadUserOrgRanges((Long)currUserId, (Long)0L);
            qFilterList.add(userOrgFilter);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        OperationStatus status = parameter.getStatus();
        if (OperationStatus.ADDNEW.equals((Object)status)) {
            JSONArray paramsList = (JSONArray)parameter.getCustomParam("paramsList");
            JSONArray docLibPKBorrowSet = (JSONArray)parameter.getCustomParam("docLibPKBorrowSet");
            JSONArray docItemPKBorrowSet = (JSONArray)parameter.getCustomParam("docItemPKBorrowSet");
            JSONArray docDirectoryPKBorrowSet = (JSONArray)parameter.getCustomParam("docDirectoryPKBorrowSet");
            if (paramsList != null) {
                int index = 0;
                DynamicObjectCollection borrowEntry = this.getModel().getEntryEntity("borrowlistentry");
                QFilter docLibIdFilter = new QFilter("id", "in", (Object)docLibPKBorrowSet);
                DynamicObject[] docLibs = BusinessDataServiceHelper.load((String)"pmdc_doclibname", (String)"", (QFilter[])new QFilter[]{docLibIdFilter});
                HashMap<Long, DynamicObject> docLibMap = new HashMap<Long, DynamicObject>(docLibs.length);
                for (DynamicObject dynamicObject : docLibs) {
                    docLibMap.put(dynamicObject.getLong("id"), dynamicObject);
                }
                QFilter docItemIdFilter = new QFilter("id", "in", (Object)docItemPKBorrowSet);
                DynamicObject[] docItems = BusinessDataServiceHelper.load((String)"pmdc_docitem", (String)"sourcebill,sourcebillno,relateobject,uploadperson,uploaddate", (QFilter[])new QFilter[]{docItemIdFilter});
                HashMap<Long, DynamicObject> docItemMap = new HashMap<Long, DynamicObject>(docItems.length);
                for (DynamicObject dynamicObject : docItems) {
                    docItemMap.put(dynamicObject.getLong("id"), dynamicObject);
                }
                QFilter qFilter = new QFilter("id", "in", (Object)docDirectoryPKBorrowSet);
                DynamicObject[] directories = BusinessDataServiceHelper.load((String)"pmdc_docdirectory", (String)"", (QFilter[])new QFilter[]{qFilter});
                HashMap<Long, DynamicObject> docDirectoryMap = new HashMap<Long, DynamicObject>(directories.length);
                for (DynamicObject directory : directories) {
                    docDirectoryMap.put(directory.getLong("id"), directory);
                }
                DynamicObjectType dynamicObjectType = borrowEntry.getDynamicObjectType();
                while (index < paramsList.size()) {
                    JSONObject rowData = (JSONObject)paramsList.get(index);
                    Long docItemId = rowData.getLong("docitemid");
                    Long docLib = ((JSONObject)rowData.get((Object)"doclib")).getLong("id");
                    Long docDirectory = ((JSONObject)rowData.get((Object)"docdirectory")).getLong("id");
                    Object fileNo = rowData.get((Object)"fileno");
                    DynamicObject item = new DynamicObject(dynamicObjectType);
                    DynamicObject docItemDO = (DynamicObject)docItemMap.get(docItemId);
                    DynamicObject docLibDO = (DynamicObject)docLibMap.get(docLib);
                    DynamicObject docDirectoryDO = (DynamicObject)docDirectoryMap.get(docDirectory);
                    item.set("docitemid", (Object)docItemDO);
                    item.set("doclib", (Object)docLibDO);
                    item.set("docdirectory", (Object)docDirectoryDO);
                    item.set("docfileno", fileNo);
                    borrowEntry.add((Object)item);
                    ++index;
                }
                this.getModel().updateEntryCache(borrowEntry);
                this.getView().updateView("borrowlistentry");
            }
        }
    }
}

