/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmdc.formplugin.doclib;

import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.pmgt.pmdc.formplugin.base.AbstractPmdcFormPlugin;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class DirFieldConfigFormPlugin
extends AbstractPmdcFormPlugin {
    private static String CUSTOM_KEY_ORIGINAL_DOC_LIB_PK = "originaldoclibpk";
    private static String PAGE_CACHE_ORIGINAL_DOC_LIB = "originaldoclib";

    public void registerListener(EventObject e) {
        TextEdit statusFieldEdit;
        TextEdit billNameFieldEdit;
        super.registerListener(e);
        TextEdit billNoFieldEdit = (TextEdit)this.getView().getControl("billnofield");
        if (billNoFieldEdit != null) {
            billNoFieldEdit.addButtonClickListener((ClickListener)this);
        }
        if ((billNameFieldEdit = (TextEdit)this.getView().getControl("billnamefield")) != null) {
            billNameFieldEdit.addButtonClickListener((ClickListener)this);
        }
        if ((statusFieldEdit = (TextEdit)this.getView().getControl("billstatusfield")) != null) {
            statusFieldEdit.addButtonClickListener((ClickListener)this);
        }
    }

    public void beforeBindData(EventObject e) {
        this.init();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObject originalDocLibDir = this.getOriginalDocLib();
        String filterProp = "commonfilter";
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(filterProp);
        String filterData = originalDocLibDir.getString("filterdata");
        if (StringUtils.isNotEmpty((CharSequence)filterData)) {
            FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterData, FilterCondition.class);
            filterGrid.SetValue(filterCondition);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (StringUtils.equals((CharSequence)"confirm", (CharSequence)operateKey)) {
            boolean needCancel = false;
            Object billStatusField = this.getModel().getValue("billstatusfield");
            FilterGrid filterGrid = (FilterGrid)this.getView().getControl("commonfilter");
            FilterCondition filterCondition = filterGrid.getFilterGridState().getFilterCondition();
            if (billStatusField == null || StringUtils.isEmpty((CharSequence)billStatusField.toString())) {
                if (filterCondition != null && CollectionUtils.isNotEmpty((Collection)filterCondition.getFilterRow())) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u51c6\u5165\u6761\u4ef6\u8bbe\u7f6e\u9700\u5148\u914d\u7f6e\u5355\u636e\u72b6\u6001\u5b57\u6bb5\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u3002", (String)"DirFieldConfigFormPlugin_1", (String)"pmgt-pmdc-formplugin", (Object[])new Object[0]));
                    needCancel = true;
                }
            } else {
                List filterRow = filterCondition.getFilterRow();
                Set fieldNames = filterRow.stream().map(SimpleFilterRow::getFieldName).collect(Collectors.toSet());
                if (CollectionUtils.isEmpty(fieldNames)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6839\u636e\u5355\u636e\u72b6\u6001\u5b57\u6bb5\u914d\u7f6e\u51c6\u5165\u6761\u4ef6\u3002", (String)"DirFieldConfigFormPlugin_2", (String)"pmgt-pmdc-formplugin", (Object[])new Object[0]));
                    needCancel = true;
                }
                if (!(needCancel || fieldNames.size() <= 1 && fieldNames.contains(billStatusField.toString()))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u51c6\u5165\u6761\u4ef6\u4ec5\u652f\u6301\u914d\u7f6e\u7684\u5355\u636e\u72b6\u6001\u5b57\u6bb5\uff0c\u8bf7\u68c0\u914d\u7f6e\u3002", (String)"DirFieldConfigFormPlugin_3", (String)"pmgt-pmdc-formplugin", (Object[])new Object[0]));
                    needCancel = true;
                }
            }
            args.setCancel(needCancel);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (StringUtils.equals((CharSequence)"confirm", (CharSequence)operateKey)) {
            DynamicObject originalDocLib = this.getOriginalDocLib();
            if (originalDocLib == null) {
                return;
            }
            FilterGrid filterGrid = (FilterGrid)this.getView().getControl("commonfilter");
            FilterCondition filterCondition = filterGrid.getFilterGridState().getFilterCondition();
            String filterData = SerializationUtils.toJsonString((Object)filterCondition);
            String billNoField = this.getModel().getDataEntity(true).getString("billnofield");
            String billNameField = this.getModel().getDataEntity(true).getString("billnamefield");
            String billStatusField = this.getModel().getDataEntity(true).getString("billstatusfield");
            String originalDocLibDirPk = originalDocLib.getPkValue().toString();
            DirFieldConfig dirFieldConfig = new DirFieldConfig(billNoField, billNameField, billStatusField, filterData, originalDocLibDirPk);
            ListSelectedRowCollection collection = new ListSelectedRowCollection();
            ListSelectedRow selectedRow = new ListSelectedRow();
            selectedRow.setPrimaryKeyValue((Object)dirFieldConfig);
            collection.add((Object)selectedRow);
            this.getView().returnDataToParent((Object)collection);
            this.getView().invokeOperation("close");
        }
    }

    private void init() {
        DynamicObject originalDocLibDir = this.getOriginalDocLib();
        if (originalDocLibDir == null) {
            return;
        }
        this.buildField(originalDocLibDir);
    }

    private void buildField(DynamicObject originalDocLibDir) {
        this.getModel().setValue("billnofield", (Object)originalDocLibDir.getString("billnofield"));
        this.getModel().setValue("billnamefield", (Object)originalDocLibDir.getString("billnamefield"));
        this.getModel().setValue("billstatusfield", (Object)originalDocLibDir.getString("billstatusfield"));
        String filterProp = "commonfilter";
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(filterProp);
        String entityNumber = originalDocLibDir.getString("number");
        filterGrid.setEntityNumber(entityNumber);
    }

    private DynamicObject getOriginalDocLib() {
        DynamicObject originalDocLibDir;
        String originalDocLibString = this.getPageCache().get(PAGE_CACHE_ORIGINAL_DOC_LIB);
        Long originalDocLibPk = (Long)this.getView().getFormShowParameter().getCustomParam(CUSTOM_KEY_ORIGINAL_DOC_LIB_PK);
        if (originalDocLibPk == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u6307\u5b9a\u539f\u59cb\u5e93\u76ee\u5f55\u4fe1\u606f\u3002", (String)"DirFieldConfigFormPlugin_0", (String)"pmgt-pmdc-formplugin", (Object[])new Object[0]));
        }
        MainEntityType dt = MetadataServiceHelper.getDataEntityType((String)"pmdc_originaldoclibdir");
        if (StringUtils.isEmpty((CharSequence)originalDocLibString)) {
            originalDocLibDir = BusinessDataServiceHelper.loadSingle((Object)originalDocLibPk, (String)"pmdc_originaldoclibdir");
            this.getPageCache().put(PAGE_CACHE_ORIGINAL_DOC_LIB, DynamicObjectSerializeUtil.serialize((Object[])new Object[]{originalDocLibDir}, (DynamicObjectType)dt));
        } else {
            originalDocLibDir = (DynamicObject)DynamicObjectSerializeUtil.deserialize((String)originalDocLibString, (DynamicObjectType)dt)[0];
        }
        return originalDocLibDir;
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "billnofield": 
            case "billnamefield": 
            case "billstatusfield": {
                this.showField(key);
                break;
            }
        }
    }

    private void showField(String actionId) {
        Long originalDocLibPk = (Long)this.getView().getFormShowParameter().getCustomParam(CUSTOM_KEY_ORIGINAL_DOC_LIB_PK);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("pmbs_eventfield");
        HashMap<String, Object> customs = new HashMap<String, Object>(2);
        customs.put("sourceformiddataid", originalDocLibPk);
        customs.put("formtype", "field");
        showParameter.setCustomParams(customs);
        CloseCallBack fieldCloseCallBack = new CloseCallBack((IFormPlugin)this, actionId);
        showParameter.setCloseCallBack(fieldCloseCallBack);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData != null) {
            Object number = ((Map)returnData).get("longnumber");
            this.getModel().setValue(actionId, number);
        }
    }

    static class DirFieldConfig {
        private String billNoField;
        private String billNameField;
        private String billStatusField;
        private String filterData;
        private String originalDocLibDirPk;

        public DirFieldConfig(String billNoField, String billNameField, String billStatusField, String filterData, String originalDocLibDirPk) {
            this.billNoField = billNoField;
            this.billNameField = billNameField;
            this.billStatusField = billStatusField;
            this.filterData = filterData;
            this.originalDocLibDirPk = originalDocLibDirPk;
        }

        public String getFilterData() {
            return this.filterData;
        }

        public void setFilterData(String filterData) {
            this.filterData = filterData;
        }

        public String getBillNoField() {
            return this.billNoField;
        }

        public void setBillNoField(String billNoField) {
            this.billNoField = billNoField;
        }

        public String getBillNameField() {
            return this.billNameField;
        }

        public void setBillNameField(String billNameField) {
            this.billNameField = billNameField;
        }

        public String getBillStatusField() {
            return this.billStatusField;
        }

        public void setBillStatusField(String billStatusField) {
            this.billStatusField = billStatusField;
        }

        public String getOriginalDocLibDirPk() {
            return this.originalDocLibDirPk;
        }

        public void setOriginalDocLibDirPk(String originalDocLibDirPk) {
            this.originalDocLibDirPk = originalDocLibDirPk;
        }
    }
}

