/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmdc.formplugin.doclib;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ITreeModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.tree.TreeNode;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterContainer;
import kd.bos.filter.FilterGridView;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.mvc.list.TreeListModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.bos.url.UrlService;
import kd.pmgt.pmbs.business.helper.RandomHelper;
import kd.pmgt.pmbs.common.enums.EnableEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmbs.common.enums.budgetreg.EventBillTreeTypeEnum;
import kd.pmgt.pmbs.common.param.PermCheckParam;
import kd.pmgt.pmbs.common.utils.BuildCommonFilterList;
import kd.pmgt.pmbs.common.utils.CheckPermissionHelper;
import kd.pmgt.pmbs.common.utils.OpenPageUtils;
import kd.pmgt.pmbs.common.utils.OrgTreeUtils;
import kd.pmgt.pmbs.common.utils.ProjectPermissionHelper;
import kd.pmgt.pmbs.formplugin.base.AbstractPmgtTreeListPlugin;
import kd.pmgt.pmdc.business.doclib.DocItemService;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.NotNull;

public class DocLibListPlugin
extends AbstractPmgtTreeListPlugin
implements ClickListener,
TreeNodeClickListener,
TabSelectListener {
    private static final String CURRENT_PAGE_TAB_ID = "currentpagetabid";
    private static final String PAGE_CACHE_ORIGINAL_DOC_LIB_PK = "originaldoclibpk";
    private static final String PAGE_CACHE_ORIGINAL_DOC_LIB = "originaldoclib";
    private static final String REDIS_CACHE_CURRENT_TAB_ID = "DocLibList:currentTabId";
    private static final String REDIS_CACHE_ORIGINAL_DOC_LIB_PK = "DocLibList:originaldoclibpk";
    private static final String CONTROL_TAB_AP = "tabap";
    private static final String BTN_ADD = "tblnew";
    private static final String BTN_COLLECT = "tblcollect";
    private static final String BTN_COLLECTRECORD = "tblcollectrecord";
    private static final String BTN_CLEARCOLLECTRECORD = "tblclearcollectrecord";
    private static final String OPERATION_ADD = "add";
    private static final String OPERATION_DOWNLOAD = "download";
    private static final String OPERATION_COLLECT = "collect";
    private static final String OPERATION_COLLECTRECORD = "collectrecord";
    private static final String OPERATION_CLEARCOLLECTRECORD = "clearcollectrecord";
    private static final String OPERATION_DELETEDOCITEM = "deletedocitem";
    private static final String ROOT_NODE_ID = "8609760E-EF83-4775-A9FF-CCDEC7C0B689";
    private static final String ORIGINAL_DOC_LIB_NUMBER = "originaldoclib";
    private static final String PMDC_APP_ID = "3NPG91XG=/YI";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Tab tab = (Tab)this.getControl(CONTROL_TAB_AP);
        if (tab != null) {
            tab.addTabSelectListener((TabSelectListener)this);
        }
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        AppInfo info = AppMetadataCache.getAppInfo((String)"pmdc");
        LicenseCheckResult lr = LicenseServiceHelper.checkByAppAndBizObj((String)info.getId(), (String)"pmdc_docitem", (Long)UserServiceHelper.getCurrentUserId());
        if (!lr.getHasLicense().booleanValue()) {
            e.setCancel(true);
            e.setCancelMessage(lr.getMsg());
            e.setCancelFormShowParameter(lr.getCancelFormShowParameter());
        }
    }

    public void initialize() {
        super.initialize();
        this.getPageCache().put("noticeAddCtrlstrategy", "1");
        this.getPageCache().put("isSwitchedMultiOrg", "1");
        this.getView().setVisible(Boolean.FALSE, new String[]{"iscontainnow", "iscontainlower"});
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        FilterContainer filterContainer = (FilterContainer)this.getControl("filtercontainerap");
        List filterControlList = filterContainer.getItems();
        CommonFilterColumn orgFilterColumn = null;
        FilterGridView filterGridView = filterControlList.stream().filter(control -> control instanceof FilterGridView).findFirst().orElse(null);
        if (filterGridView != null) {
            orgFilterColumn = filterGridView.getItems().stream().filter(item -> StringUtils.equals((CharSequence)((CommonFilterColumn)item).getFilterField().getSrcFieldKey(), (CharSequence)"createorg")).map(item -> (CommonFilterColumn)item).collect(Collectors.toList()).stream().findFirst().orElse(null);
        }
        if (orgFilterColumn == null) {
            return;
        }
        List<Long> orgList = this.getAllPermOrgByPermItemFromCache("pmdc_docitem", "47150e89000000ac", false);
        QFilter qFilter = new QFilter("id", "in", orgList);
        List orgComboItems = BuildCommonFilterList.buildComboItem((String)"bos_org", (QFilter)qFilter);
        orgFilterColumn.setComboItems(orgComboItems);
        orgFilterColumn.setDefaultValue(String.valueOf(RequestContext.get().getOrgId()));
        this.getPageCache().put("createOrg", String.valueOf(RequestContext.get().getOrgId()));
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        if ("bos_org".equals(args.getRefEntityId())) {
            QFilter idFilter = args.getQfilters().stream().filter(it -> it.getProperty().equals("id")).findFirst().orElse(null);
            if (idFilter != null) {
                args.getQfilters().remove(idFilter);
            }
            List<Long> orgList = this.getAllPermOrgByPermItemFromCache("pmdc_docitem", "47150e89000000ac", false);
            QFilter qFilter = new QFilter("id", "in", orgList);
            args.getQfilters().add(qFilter);
        }
    }

    private List<Long> getAllPermOrgByPermItemFromCache(String formId, String permId, boolean useCache) {
        List orgList;
        if (useCache) {
            String cacheKey = "permorglist:" + formId + ":" + permId;
            String permOrgListString = this.getPageCache().get(cacheKey);
            if (StringUtils.isEmpty((CharSequence)permOrgListString)) {
                orgList = ProjectPermissionHelper.getAllPermOrgsByPermItem((String)"15", (String)String.valueOf(UserServiceHelper.getCurrentUserId()), (String)this.getView().getFormShowParameter().getAppId(), (String)formId, (String)permId);
                this.getPageCache().put(cacheKey, String.join((CharSequence)",", orgList.stream().map(String::valueOf).collect(Collectors.toSet())));
            } else {
                orgList = Arrays.stream(permOrgListString.split(",")).map(Long::parseLong).collect(Collectors.toList());
            }
        } else {
            orgList = ProjectPermissionHelper.getAllPermOrgsByPermItem((String)"15", (String)String.valueOf(UserServiceHelper.getCurrentUserId()), (String)this.getView().getFormShowParameter().getAppId(), (String)formId, (String)permId);
        }
        return orgList;
    }

    public void refreshNode(RefreshNodeEvent e) {
        super.refreshNode(e);
        TreeListModel treeModel = (TreeListModel)this.getTreeModel();
        treeModel.getQueryParas().put("order", "number");
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String operateKey = ((AbstractOperate)args.getSource()).getOperateKey();
        Object[] pkIds = ((IListView)this.getView()).getSelectedRows().getPrimaryKeyValues();
        switch (operateKey) {
            case "add": {
                QFilter numberFilter = new QFilter("number", "=", (Object)"pmdc_docapply");
                boolean exists = QueryServiceHelper.exists((String)"pmdc_docdirectory", (QFilter[])new QFilter[]{numberFilter});
                if (!exists) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u6cd5\u65b0\u589e\uff0c\u7531\u4e8e\u539f\u59cb\u5e93\u4e2d\u672a\u6dfb\u52a0\u9879\u76ee\u4e91\u4e0b\u7684\u8d44\u6599\u7533\u8bf7\u5355\u636e\uff0c\u8bf7\u5148\u5728\u57fa\u7840\u8bbe\u7f6e->\u539f\u59cb\u5e93\u76ee\u5f55\u8bbe\u7f6e\u4e2d\u6dfb\u52a0\u540e\u518d\u8bd5\u3002", (String)"DocLibListPlugin_16", (String)"pmgt-pmdc-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    break;
                }
                String currentNodeId = this.getTreeModel().getCurrentNodeId().toString();
                if (ROOT_NODE_ID.equals(currentNodeId)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u5b9a\u660e\u7ec6\u76ee\u5f55\u3002", (String)"DocLibListPlugin_3", (String)"pmgt-pmdc-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    break;
                }
                DynamicObject docDirectory = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(currentNodeId), (String)"pmdc_docdirectory");
                if (docDirectory.getBoolean("isleaf")) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u5b9a\u660e\u7ec6\u76ee\u5f55\u3002", (String)"DocLibListPlugin_3", (String)"pmgt-pmdc-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                break;
            }
            case "refresh": {
                this.getPageCache().put("alreadyinittab", "false");
                Tab tab = (Tab)this.getView().getControl(CONTROL_TAB_AP);
                String currentTab = tab.getCurrentTab();
                if (!StringUtils.isNotBlank((CharSequence)currentTab)) break;
                currentTab = currentTab.split("#")[0];
                this.putCurrentTabIdInCache(currentTab);
                break;
            }
            case "collect": {
                this.showCollectBill(args.getListSelectedData());
                break;
            }
            case "collectrecord": {
                if (pkIds.length > 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u591a\u9009\uff0c\u8bf7\u9009\u4e2d\u4e00\u6761\u8bb0\u5f55\u8fdb\u884c\u67e5\u8be2\u3002", (String)"DocLibListPlugin_4", (String)"pmgt-pmdc-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    break;
                }
                if (pkIds.length != 0) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u9009\u62e9\u8d44\u6599\u6761\u76ee\uff0c\u8bf7\u9009\u62e9\u4e00\u6761\u3002", (String)"DocLibListPlugin_5", (String)"pmgt-pmdc-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                break;
            }
            case "clearcollectrecord": {
                if (pkIds.length > 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u591a\u9009\uff0c\u8bf7\u9009\u4e2d\u4e00\u6761\u8bb0\u5f55\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"DocLibListPlugin_6", (String)"pmgt-pmdc-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    break;
                }
                if (pkIds.length != 0) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u9009\u62e9\u8d44\u6599\u6761\u76ee\uff0c\u8bf7\u9009\u62e9\u4e00\u6761\u3002", (String)"DocLibListPlugin_5", (String)"pmgt-pmdc-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                break;
            }
            case "deletedocitem": {
                boolean isOriginalTab = this.getCurrentTabId().equals(this.getOriginalDocLibPk());
                if (isOriginalTab) {
                    args.setCancel(true);
                    break;
                }
                if (pkIds.length == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u4e2d\u9644\u4ef6\u8bb0\u5f55\u3002", (String)"DocLibListPlugin_7", (String)"pmgt-pmdc-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    break;
                }
                String msg = ResManager.loadKDString((String)"\u5220\u9664\u9009\u4e2d\u8bb0\u5f55\u540e\u5c06\u65e0\u6cd5\u6062\u590d\uff0c\u786e\u5b9a\u5220\u9664\u8bb0\u5f55\u5417\uff1f", (String)"DocLibListPlugin_10", (String)"pmgt-pmdc-formplugin", (Object[])new Object[0]);
                this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener(OPERATION_DELETEDOCITEM, (IFormPlugin)this));
                break;
            }
        }
    }

    private void putCurrentTabIdInCache(String currentTab) {
        this.getPageCache().put(CURRENT_PAGE_TAB_ID, currentTab);
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache();
        if (currentTab != null) {
            cache.put(REDIS_CACHE_CURRENT_TAB_ID, (Object)currentTab);
        }
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        String currentTabId = this.getCurrentTabId();
        ArrayList<String> excludeField = new ArrayList<String>();
        excludeField.add("fileno");
        excludeField.add("relateobject");
        if (this.getOriginalDocLibPk().equals(currentTabId)) {
            args.getListColumns().removeIf(listColumn -> excludeField.contains(listColumn.getListFieldKey()));
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        String alreadyInitTab = this.getPageCache().get("alreadyinittab");
        if ("true".equals(alreadyInitTab)) {
            return;
        }
        Object openBy = this.getView().getFormShowParameter().getCustomParam("openby");
        if (openBy == null || !"pmdc_collectmanage".equals(openBy.toString())) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{CONTROL_TAB_AP});
            this.buildDocLibTab();
        }
    }

    private void buildDocLibTab() {
        ArrayList<DynamicObject> docLibNames = new ArrayList<DynamicObject>();
        List<Long> orgsUserJoin = this.getAllPermOrgByPermItemFromCache("pmdc_originaldoclibdir", "47156aff000000ac", false);
        if (CollectionUtils.isNotEmpty(orgsUserJoin)) {
            DynamicObject originalDocLib = this.getOriginalDocLib();
            docLibNames.add(originalDocLib);
        }
        DynamicObject[] docLibNameArray = this.getCustomDocLibName();
        Collections.addAll(docLibNames, docLibNameArray);
        Set docLibNameIds = docLibNames.stream().map(it -> it.getPkValue().toString()).collect(Collectors.toSet());
        boolean needBuildTab = true;
        String hasPermDocLibNamePks = this.getPageCache().get("haspermdoclibnamepks");
        if (StringUtils.isNotEmpty((CharSequence)hasPermDocLibNamePks)) {
            String[] pageCacheDocLibNamePks = StringUtils.split((String)hasPermDocLibNamePks, (String)",");
            boolean bl = needBuildTab = !CollectionUtils.isEqualCollection((Collection)Arrays.stream(pageCacheDocLibNamePks).collect(Collectors.toSet()), docLibNameIds);
        }
        if (!needBuildTab) {
            this.getPageCache().put("alreadyinittab", "true");
            return;
        }
        if (StringUtils.isNotEmpty((CharSequence)hasPermDocLibNamePks)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d44\u6599\u5e93\u6709\u53d8\u52a8\uff0c\u8bf7\u9000\u51fa\u8d44\u6599\u5e93\u5217\u8868\u4ee5\u52a0\u8f7d\u6700\u65b0\u7684\u8d44\u6599\u5e93\u4fe1\u606f\u3002", (String)"DocLibListPlugin_19", (String)"pmgt-pmdc-formplugin", (Object[])new Object[0]));
            return;
        }
        for (DynamicObject docLibName : docLibNames) {
            this.buildTabPage(docLibName);
        }
        this.getPageCache().put("haspermdoclibnamepks", String.join((CharSequence)",", docLibNameIds));
        this.getPageCache().put("alreadyinittab", "true");
    }

    @NotNull
    private DynamicObject[] getCustomDocLibName() {
        List orgsUserJoin = ProjectPermissionHelper.getAllPermOrgsByPermItem((String)"15", (String)String.valueOf(UserServiceHelper.getCurrentUserId()), (String)this.getView().getFormShowParameter().getAppId(), (String)"pmdc_doclibname", (String)"47150e89000000ac");
        QFilter orgFilter = new QFilter("authorizedorgentry.authorgid", "in", (Object)orgsUserJoin);
        QFilter userFilter = new QFilter("authuserentry.authuserid", "in", (Object)RequestContext.get().getCurrUserId());
        QFilter useOrgFilter = new QFilter("useorg", "in", (Object)orgsUserJoin);
        QFilter enableFilter = new QFilter("enable", "=", (Object)EnableEnum.ENABLE.getValue());
        DynamicObject[] docLibNameArray = BusinessDataServiceHelper.load((String)"pmdc_doclibname", (String)"id, number, name", (QFilter[])new QFilter[]{orgFilter.or(userFilter).or(useOrgFilter), enableFilter});
        Arrays.sort(docLibNameArray, (o1, o2) -> {
            Collator instance = Collator.getInstance();
            String source = o1.getLocaleString("name").getLocaleValue() != null ? o1.getLocaleString("name").getLocaleValue() : "";
            String target = o2.getLocaleString("name").getLocaleValue() != null ? o2.getLocaleString("name").getLocaleValue() : "";
            return instance.compare(source, target);
        });
        return docLibNameArray;
    }

    private void buildTabPage(DynamicObject docLibName) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.NewTabPage);
        formShowParameter.getOpenStyle().setTargetKey(CONTROL_TAB_AP);
        formShowParameter.setFormId("pmdc_emptylist");
        formShowParameter.setCaption(docLibName.getLocaleString("name").getLocaleValue());
        Map customParams = formShowParameter.getCustomParams();
        customParams.put("tabKey", docLibName.getString("number"));
        formShowParameter.setCustomParams(customParams);
        String docLibNameId = docLibName.getPkValue().toString();
        String uuid = RandomHelper.random((int)16);
        formShowParameter.setPageId(docLibNameId + "#" + uuid);
        this.getView().showForm(formShowParameter);
    }

    public void buildTreeListFilter(BuildTreeListFilterEvent e) {
        TreeNode root = this.getTreeModel().getRoot();
        String currentTabId = this.getCurrentTabId();
        QFilter billFilter = new QFilter("doclibname", "=", (Object)Long.parseLong(currentTabId));
        DynamicObject[] billOriginalDocLibList = BusinessDataServiceHelper.load((String)"pmdc_originaldoclibdir", (String)"id, number, parent, billtype", (QFilter[])billFilter.toArray());
        List<String> pkList = Arrays.stream(billOriginalDocLibList).map(it -> it.getPkValue().toString()).collect(Collectors.toList());
        this.removeBillNode(root, pkList);
        this.addFormIdOnNode(root, (DynamicObject[])Arrays.stream(billOriginalDocLibList).toArray(DynamicObject[]::new));
        this.getTreeModel().setRoot(root);
    }

    private void addFormIdOnNode(TreeNode node, DynamicObject[] billOriginalDocLibList) {
        List children;
        if (node == null) {
            return;
        }
        if (!ROOT_NODE_ID.equals(node.getId())) {
            DynamicObject docLib = Arrays.stream(billOriginalDocLibList).filter(it -> it.getPkValue().toString().equals(node.getId())).findFirst().orElse(null);
            if (docLib == null) {
                return;
            }
            if (!node.getText().contains(String.format("(%s)", docLib.getString("number")))) {
                node.setText(node.getText() + String.format("(%s)", docLib.getString("number")));
            }
            node.setData((Object)docLib);
        }
        if (CollectionUtils.isNotEmpty((Collection)(children = node.getChildren()))) {
            for (TreeNode child : children) {
                this.addFormIdOnNode(child, billOriginalDocLibList);
            }
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        List qFilters = e.getQFilters();
        qFilters.removeIf(it -> it.getProperty().equals("group"));
        String currentNodeId = this.getTreeModel().getCurrentNodeId().toString();
        List<DynamicObject> needQueryOriginalDocLibDirList = this.getAllNodeDocDirectory(currentNodeId);
        QFilter statusFilter = new QFilter("status", "=", (Object)StatusEnum.CHECKED.getValue());
        QFilter enableFilter = new QFilter("enable", "=", (Object)EnableEnum.ENABLE.getValue());
        Object openBy = this.getView().getFormShowParameter().getCustomParam("openby");
        if (openBy != null && "pmdc_collectmanage".equals(openBy.toString())) {
            QFilter orgFilter = qFilters.stream().filter(it -> "createorg.id".equals(it.getProperty())).findFirst().orElse(null);
            qFilters.remove(orgFilter);
        }
        List<Object> queryOrgList = new ArrayList();
        boolean hasOrgFilter = qFilters.stream().anyMatch(it -> "createorg.id".equals(it.getProperty()));
        if (!hasOrgFilter) {
            queryOrgList = this.getAllPermOrgByPermItemFromCache("pmdc_docitem", "47150e89000000ac", false);
        } else {
            QFilter orgFilter = qFilters.stream().filter(it -> "createorg.id".equals(it.getProperty())).findFirst().orElse(null);
            if (orgFilter != null) {
                if (StringUtils.equalsIgnoreCase((CharSequence)orgFilter.getCP(), (CharSequence)"=")) {
                    queryOrgList.add(Long.valueOf(orgFilter.getValue().toString()));
                }
                if (StringUtils.equalsIgnoreCase((CharSequence)orgFilter.getCP(), (CharSequence)"in")) {
                    queryOrgList.addAll((Collection)orgFilter.getValue());
                }
                qFilters.remove(orgFilter);
            }
        }
        e.getQFilters().add(new QFilter("createorg", "in", queryOrgList));
        List originalDocLibPks = needQueryOriginalDocLibDirList.stream().map(it -> Long.parseLong(it.getPkValue().toString())).collect(Collectors.toList());
        Set<Object> docItemPks = new HashSet();
        if (CollectionUtils.isNotEmpty(originalDocLibPks)) {
            QFilter docDirectoryFilter;
            QFilter docTypeFilter = new QFilter("doctype", "=", (Object)"2");
            boolean isOriginalTab = this.getCurrentTabId().equals(this.getOriginalDocLibPk());
            if (isOriginalTab) {
                QFilter numberFilter = new QFilter("number", "=", (Object)"pmdc_docapply");
                DynamicObject docApplyOriginalDocLib = BusinessDataServiceHelper.loadSingle((String)"pmdc_originaldoclibdir", (QFilter[])new QFilter[]{numberFilter});
                docDirectoryFilter = new QFilter("group", "in", originalDocLibPks);
                if (docApplyOriginalDocLib != null && originalDocLibPks.contains(Long.valueOf(docApplyOriginalDocLib.getPkValue().toString()))) {
                    docDirectoryFilter.or(docTypeFilter);
                }
                DynamicObject[] docItems = BusinessDataServiceHelper.load((String)"pmdc_docitem", (String)"id", (QFilter[])new QFilter[]{docDirectoryFilter, statusFilter, enableFilter});
                docItemPks = Arrays.stream(docItems).map(DataEntityBase::getPkValue).collect(Collectors.toSet());
            } else {
                docDirectoryFilter = new QFilter("group", "in", originalDocLibPks);
                DynamicObject[] collectRecord = BusinessDataServiceHelper.load((String)"pmdc_collectrecord", (String)"id, docitem", (QFilter[])new QFilter[]{docDirectoryFilter, statusFilter, enableFilter});
                docItemPks.addAll(Arrays.stream(collectRecord).filter(it -> it.getDynamicObject("docitem") != null).map(it -> it.getDynamicObject("docitem")).map(DataEntityBase::getPkValue).collect(Collectors.toSet()));
                docDirectoryFilter = new QFilter("group", "in", originalDocLibPks);
                DynamicObject[] docItems = BusinessDataServiceHelper.load((String)"pmdc_docitem", (String)"id", (QFilter[])new QFilter[]{docDirectoryFilter.and(docTypeFilter), statusFilter, enableFilter});
                docItemPks.addAll(Arrays.stream(docItems).map(DataEntityBase::getPkValue).collect(Collectors.toSet()));
            }
        }
        QFilter pkFilter = new QFilter("id", "in", docItemPks);
        qFilters.add(0, pkFilter);
        qFilters.add(statusFilter);
        qFilters.add(enableFilter);
    }

    @NotNull
    private List<DynamicObject> getAllNodeDocDirectory(String currentNodeId) {
        ArrayList<DynamicObject> docDirectories = new ArrayList<DynamicObject>();
        TreeNode root = this.getTreeListView().getTreeModel().getRoot();
        this.getAllNodeId(root.getTreeNode(currentNodeId), docDirectories);
        return docDirectories;
    }

    private void getAllNodeId(TreeNode node, List<DynamicObject> result) {
        if (node == null) {
            return;
        }
        if (CollectionUtils.isEmpty((Collection)node.getChildren())) {
            if (!ROOT_NODE_ID.equals(node.getId())) {
                result.add(this.getNodeData(node.getId()));
            }
            return;
        }
        List children = node.getChildren();
        for (TreeNode child : children) {
            result.add(this.getNodeData(child.getId()));
            this.getAllNodeId(child, result);
        }
    }

    private DynamicObject getNodeData(String nodeId) {
        TreeNode node = OrgTreeUtils.getNode((Object)nodeId, (ITreeModel)this.getTreeModel());
        if (node.getData() == null) {
            DynamicObject originalDocLib = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(node.getId()), (String)"pmdc_originaldoclibdir");
            node.setData((Object)originalDocLib);
        }
        if (node.getData() instanceof Map) {
            String id = ((Map)node.getData()).get("id").toString();
            DynamicObject originalDocLib = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(id), (String)"pmdc_originaldoclibdir");
            node.setData((Object)originalDocLib);
        }
        return (DynamicObject)node.getData();
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int arg0, int arg1) {
                DynamicObjectCollection collection = super.getData(arg0, arg1);
                if (CollectionUtils.isNotEmpty((Collection)collection)) {
                    DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache();
                    String currentTabId = (String)cache.get(DocLibListPlugin.REDIS_CACHE_CURRENT_TAB_ID);
                    String originalDocLibPk = (String)cache.get(DocLibListPlugin.REDIS_CACHE_ORIGINAL_DOC_LIB_PK);
                    if (StringUtils.isEmpty((CharSequence)currentTabId) || originalDocLibPk.equals(currentTabId)) {
                        return collection;
                    }
                    QFilter statusFilter = new QFilter("status", "=", (Object)StatusEnum.CHECKED.getValue());
                    QFilter enableFilter = new QFilter("enable", "=", (Object)EnableEnum.ENABLE.getValue());
                    QFilter docLibNameFilter = new QFilter("doclibname", "=", (Object)Long.valueOf(currentTabId));
                    for (DynamicObject docItem : collection) {
                        ArrayList<String> excludeField = new ArrayList<String>();
                        excludeField.add("fileno");
                        excludeField.add("relateobject");
                        boolean hasExcludeField = docItem.getDynamicObjectType().getProperties().stream().map(IMetadata::getName).anyMatch(excludeField::contains);
                        if (!hasExcludeField) continue;
                        QFilter docItemFilter = new QFilter("docitem", "=", docItem.getPkValue());
                        DynamicObject[] collectRecords = BusinessDataServiceHelper.load((String)"pmdc_collectrecord", (String)"id, fileno, relateobject", (QFilter[])new QFilter[]{docItemFilter, docLibNameFilter, statusFilter, enableFilter}, (String)"createtime desc");
                        if (collectRecords.length <= 0) continue;
                        docItem.set("fileno", collectRecords[0].get("fileno"));
                        docItem.set("relateobject", collectRecords[0].get("relateobject"));
                    }
                }
                return collection;
            }
        });
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Object showToolBar = this.getView().getFormShowParameter().getCustomParam("showtoolbar");
        if (showToolBar != null && "false".equals(showToolBar.toString())) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap3", "flexpanelap"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"flexpanelap4"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap4"});
        }
        Tab tab = (Tab)this.getView().getControl(CONTROL_TAB_AP);
        if (tab == null) {
            return;
        }
        String currentTab = tab.getCurrentTab();
        if (StringUtils.isNotBlank((CharSequence)currentTab)) {
            currentTab = currentTab.split("#")[0];
            this.putCurrentTabIdInCache(currentTab);
        }
        this.getView().setVisible(Boolean.valueOf(StringUtils.equals((CharSequence)currentTab, (CharSequence)this.getOriginalDocLibPk())), new String[]{BTN_COLLECT, BTN_COLLECTRECORD, BTN_CLEARCOLLECTRECORD});
        this.getView().setVisible(Boolean.valueOf(!StringUtils.equals((CharSequence)currentTab, (CharSequence)this.getOriginalDocLibPk())), new String[]{BTN_ADD, "tbldelete"});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"tbldownload"});
        Tab tabAp = (Tab)this.getControl(CONTROL_TAB_AP);
        String needActiveTab = this.getView().getPageCache().get("needActiveTab");
        tabAp.activeTab(needActiveTab);
    }

    private String getCurrentTabId() {
        String currentPageId = this.getPageCache().get(CURRENT_PAGE_TAB_ID);
        Object openBy = this.getView().getFormShowParameter().getCustomParam("openby");
        if (openBy == null || !"pmdc_collectmanage".equals(openBy.toString())) {
            currentPageId = StringUtils.isNotBlank((CharSequence)currentPageId) ? currentPageId.split("#")[0] : this.getOriginalDocLibPk();
        }
        return StringUtils.isNotBlank((CharSequence)currentPageId) ? currentPageId.split("#")[0] : this.getOriginalDocLibPk();
    }

    private void removeBillNode(TreeNode treeNode, List<String> pkList) {
        if (CollectionUtils.isEmpty(pkList)) {
            treeNode.setChildren(null);
        }
        List children = treeNode.getChildren();
        treeNode.setExpend(true);
        treeNode.setIsOpened(true);
        if (CollectionUtils.isEmpty((Collection)children)) {
            return;
        }
        List collect = children.stream().filter(it -> pkList.contains(it.getId())).collect(Collectors.toList());
        if (collect.isEmpty()) {
            treeNode.setChildren(null);
            return;
        }
        treeNode.setChildren(collect);
        for (TreeNode node : collect) {
            this.removeBillNode(node, pkList);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operation;
        super.afterDoOperation(afterDoOperationEventArgs);
        switch (operation = afterDoOperationEventArgs.getOperateKey()) {
            case "download": {
                Object[] pkIds = ((IListView)this.getView()).getSelectedRows().getPrimaryKeyValues();
                if (pkIds == null || pkIds.length == 0) {
                    return;
                }
                Map downLoadPerm = ProjectPermissionHelper.getPermObj((String)"pmdc_docitem", (String)OPERATION_DOWNLOAD);
                String permItemId = downLoadPerm.get("id").toString();
                StringBuilder sb = new StringBuilder();
                DynamicObject[] selectedDocItems = BusinessDataServiceHelper.load((Object[])pkIds, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"pmdc_docitem"));
                DynamicObject[] docDirectoryArray = BusinessDataServiceHelper.load((Object[])Arrays.stream(selectedDocItems).map(it -> it.getDynamicObject("group")).map(DataEntityBase::getPkValue).distinct().toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"pmdc_originaldoclibdir"));
                Map<String, DynamicObject> docItemMap = Arrays.stream(selectedDocItems).collect(Collectors.toMap(it -> it.getPkValue().toString(), it -> it));
                Map<String, DynamicObject> docDirectoryMap = Arrays.stream(docDirectoryArray).collect(Collectors.toMap(it -> it.getPkValue().toString(), it -> it));
                for (Object pkId : pkIds) {
                    DynamicObject docDirectory;
                    DynamicObject docItem = docItemMap.get(pkId.toString());
                    boolean exists = this.checkBillAvailable(docItem, docDirectory = docDirectoryMap.get(docItem.getDynamicObject("group").getPkValue().toString()));
                    if (!exists) {
                        sb.append(String.format(ResManager.loadKDString((String)"%s\u5df2\u7ecf\u4e0d\u5b58\u5728\u6216\u4e0d\u4e3a\u5ba1\u6838\u72b6\u6001\uff0c\u8bf7\u68c0\u67e5\u540e\u518d\u4e0b\u8f7d\u3002%n", (String)"DocLibListPlugin_17", (String)"pmgt-pmdc-formplugin", (Object[])new Object[0]), docItem.getString("number")));
                        continue;
                    }
                    this.doDownload(docItem, permItemId);
                }
                if (!StringUtils.isNotEmpty((CharSequence)sb.toString())) break;
                this.getView().showTipNotification(sb.toString());
                break;
            }
            case "collectrecord": {
                this.showCollectRecord();
                break;
            }
            case "clearcollectrecord": {
                ListShowParameter parameter = ShowFormHelper.createShowListForm((String)"pmdc_collectrecord", (boolean)true, (int)3);
                Object[] pkIds = ((IListView)this.getView()).getSelectedRows().getPrimaryKeyValues();
                DynamicObject docItem = BusinessDataServiceHelper.loadSingle((Object)pkIds[0], (String)"pmdc_docitem");
                QFilter pkFilter = new QFilter("docitem", "=", docItem.getPkValue());
                QFilter enableFilter = new QFilter("enable", "=", (Object)EnableEnum.ENABLE.getValue());
                QFilter statusFilter = new QFilter("status", "=", (Object)StatusEnum.CHECKED.getValue());
                parameter.getListFilterParameter().getQFilters().add(pkFilter.and(enableFilter).and(statusFilter));
                parameter.setCaption(ResManager.loadKDString((String)"\u6e05\u9664\u5f52\u6863\u5173\u7cfb", (String)"DocLibListPlugin_1", (String)"pmgt-pmdc-formplugin", (Object[])new Object[0]));
                parameter.getListFilterParameter().setOrderBy("createtime desc");
                CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, OPERATION_CLEARCOLLECTRECORD);
                parameter.setCloseCallBack(callBack);
                this.getView().showForm((FormShowParameter)parameter);
                break;
            }
            case "add": {
                this.showDocLibApply();
                break;
            }
            case "confirm": {
                BillList grid = (BillList)this.getView().getControl("billlistap");
                ListSelectedRowCollection selectedRows = grid.getSelectedRows();
                HashMap returnData = new HashMap();
                HashMap itemMap = new HashMap();
                Object[] primaryKeyValues = selectedRows.getPrimaryKeyValues();
                DynamicObject[] docItems = BusinessDataServiceHelper.load((String)"pmdc_docitem", (String)"id, group", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)primaryKeyValues)});
                if (this.getCurrentTabId().equals(this.getOriginalDocLibPk())) {
                    for (DynamicObject item : docItems) {
                        HashMap<String, Object> singleDocItemData = new HashMap<String, Object>();
                        singleDocItemData.put("id", item.getPkValue());
                        singleDocItemData.put("docdirectory", item.getDynamicObject("group").getPkValue());
                        singleDocItemData.put("doclibname", item.getDynamicObject("group").getDynamicObject("doclibname").getPkValue());
                        itemMap.put(item.getPkValue(), singleDocItemData);
                    }
                } else {
                    for (Object primaryKeyValue : primaryKeyValues) {
                        QFilter statusFilter;
                        QFilter enableFilter;
                        QFilter pkFilter = new QFilter("docitem", "=", primaryKeyValue);
                        QFilter docLibNameFilter = new QFilter("group.doclibname", "=", (Object)Long.parseLong(this.getCurrentTabId()));
                        DynamicObject[] collectRecord = BusinessDataServiceHelper.load((String)"pmdc_collectrecord", (String)"id, group", (QFilter[])new QFilter[]{pkFilter, docLibNameFilter, enableFilter = new QFilter("enable", "=", (Object)EnableEnum.ENABLE.getValue()), statusFilter = new QFilter("status", "=", (Object)StatusEnum.CHECKED.getValue())});
                        if (collectRecord.length == 0) continue;
                        HashMap<String, Object> singleDocItemData = new HashMap<String, Object>();
                        singleDocItemData.put("id", primaryKeyValue);
                        singleDocItemData.put("docdirectory", collectRecord[0].getDynamicObject("group").getPkValue());
                        singleDocItemData.put("doclibname", collectRecord[0].getDynamicObject("group").getDynamicObject("doclibname").getPkValue());
                        itemMap.put(primaryKeyValue, singleDocItemData);
                    }
                }
                returnData.put("returnData", itemMap);
                this.getView().returnDataToParent(returnData);
                this.getView().invokeOperation("close");
                break;
            }
        }
    }

    private void doDownload(DynamicObject docItem, String permItemId) {
        String attachmentDownloadUrl = UrlService.getAttachmentDownloadUrl((String)docItem.getString("resourcepath"));
        PermCheckParam permCheckParam = new PermCheckParam(attachmentDownloadUrl, this.getView().getEntityId(), this.getView().getFormShowParameter().getAppId(), permItemId);
        CheckPermissionHelper.setFileUrlPermCheckParam((PermCheckParam)permCheckParam);
        this.getView().download(attachmentDownloadUrl);
    }

    protected void showDocLibApply() {
        BillShowParameter parameter = new BillShowParameter();
        parameter.setFormId("pmdc_docapply");
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("formId", "pmdc_collectmanage");
        map.put("docdirectorypk", this.getTreeModel().getCurrentNodeId().toString());
        parameter.setCustomParams(map);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "pmdc_docapply"));
        this.getView().showForm((FormShowParameter)parameter);
    }

    protected void showCollectRecord() {
        ListShowParameter parameter = ShowFormHelper.createShowListForm((String)"pmdc_collectrecord", (boolean)false, (int)3);
        Object[] pkIds = ((IListView)this.getView()).getSelectedRows().getPrimaryKeyValues();
        DynamicObject docItem = BusinessDataServiceHelper.loadSingle((Object)pkIds[0], (String)"pmdc_docitem");
        QFilter pkFilter = new QFilter("docitem", "=", docItem.getPkValue());
        QFilter enableFilter = new QFilter("enable", "=", (Object)EnableEnum.ENABLE.getValue());
        QFilter statusFilter = new QFilter("status", "=", (Object)StatusEnum.CHECKED.getValue());
        parameter.getListFilterParameter().getQFilters().add(pkFilter.and(enableFilter).and(statusFilter));
        parameter.setCustomParam("showbottombtn", (Object)"false");
        this.getView().showForm((FormShowParameter)parameter);
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        String currentTabId = this.getCurrentTabId();
        String currentNodeId = this.getTreeModel().getCurrentNodeId().toString();
        if (this.getOriginalDocLibPk().equals(currentTabId)) {
            boolean needLoadFromBizBill;
            if (ROOT_NODE_ID.equals(currentNodeId)) {
                return;
            }
            DynamicObject docDirectory = this.getNodeData(currentNodeId);
            boolean bl = needLoadFromBizBill = EventBillTreeTypeEnum.BILL.getNumber().equals(docDirectory.getString("billtype")) && !"pmdc_docapply".equals(docDirectory.getString("number"));
            if (needLoadFromBizBill) {
                new DocItemService().updateDocItem(Collections.singletonList(docDirectory));
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        if (callBackId.equals(OPERATION_DELETEDOCITEM) && MessageBoxResult.Yes.equals((Object)result)) {
            DynamicObject[] docItems;
            ArrayList<DynamicObject> deleteDocItems = new ArrayList<DynamicObject>();
            ArrayList<DynamicObject> deleteRecordItems = new ArrayList<DynamicObject>();
            StringBuilder tips = new StringBuilder();
            Object[] primaryKeyValues = ((IListView)this.getView()).getSelectedRows().getPrimaryKeyValues();
            QFilter pkFilter = new QFilter("id", "in", (Object)primaryKeyValues);
            for (DynamicObject docItem : docItems = BusinessDataServiceHelper.load((String)"pmdc_docitem", (String)"id, doctype, enable", (QFilter[])new QFilter[]{pkFilter})) {
                boolean canDeleteDocItem = true;
                QFilter docItemFilter = new QFilter("docitem", "=", docItem.getPkValue());
                QFilter enableFilter = new QFilter("enable", "=", (Object)EnableEnum.ENABLE.getValue());
                QFilter statusFilter = new QFilter("status", "=", (Object)StatusEnum.CHECKED.getValue());
                DynamicObject[] collectRecords = BusinessDataServiceHelper.load((String)"pmdc_collectrecord", (String)"id, docitem, doclibname, enable", (QFilter[])new QFilter[]{docItemFilter, enableFilter, statusFilter});
                if (this.getCurrentTabId().equals(this.getOriginalDocLibPk())) {
                    if (collectRecords != null && collectRecords.length > 0) {
                        tips.append(String.format(ResManager.loadKDString((String)"%s\u8d44\u6599\u5df2\u5f52\u6863\uff0c\u65e0\u6cd5\u5220\u9664\uff0c\u8bf7\u5148\u6e05\u9664\u5f52\u6863\u5173\u7cfb\u540e\u518d\u8bd5\u3002%n", (String)"DocLibListPlugin_9", (String)"pmgt-pmdc-formplugin", (Object[])new Object[0]), docItem.get("name")));
                        canDeleteDocItem = false;
                    }
                } else if (docItem.getInt("doctype") == 2) {
                    if (collectRecords != null && collectRecords.length > 0) {
                        tips.append(String.format(ResManager.loadKDString((String)"%s\u8d44\u6599\u5df2\u5f52\u6863\uff0c\u65e0\u6cd5\u5220\u9664\uff0c\u8bf7\u5230\u539f\u59cb\u5e93\u9879\u76ee\u4e91->\u8d44\u6599\u7ba1\u7406\u76ee\u5f55\u4e0b\uff0c\u627e\u5230\u5bf9\u5e94\u8d44\u6599\u8bb0\u5f55\uff0c\u6e05\u9664\u5f52\u6863\u5173\u7cfb\u540e\u518d\u8bd5\u3002%n", (String)"DocLibListPlugin_11", (String)"pmgt-pmdc-formplugin", (Object[])new Object[0]), docItem.get("name")));
                        canDeleteDocItem = false;
                    }
                } else {
                    DynamicObject collectRecord = Arrays.stream(collectRecords).filter(it -> it.getDynamicObject("doclibname").getPkValue().toString().equals(this.getCurrentTabId())).findFirst().orElse(null);
                    if (collectRecord == null) continue;
                    canDeleteDocItem = false;
                    collectRecord.set("enable", (Object)EnableEnum.DISABLE.getValue());
                    deleteRecordItems.add(collectRecord);
                }
                if (!canDeleteDocItem) continue;
                docItem.set("enable", (Object)EnableEnum.DISABLE.getValue());
                deleteDocItems.add(docItem);
            }
            if (StringUtils.isNotEmpty((CharSequence)tips.toString())) {
                this.getView().showTipNotification(tips.toString());
            }
            if (CollectionUtils.isNotEmpty(deleteDocItems) || CollectionUtils.isNotEmpty(deleteRecordItems)) {
                SaveServiceHelper.update((DynamicObject[])deleteDocItems.toArray(new DynamicObject[0]));
                SaveServiceHelper.update((DynamicObject[])deleteRecordItems.toArray(new DynamicObject[0]));
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"DocLibListPlugin_12", (String)"pmgt-pmdc-formplugin", (Object[])new Object[0]));
                this.getView().invokeOperation("refresh");
            }
        }
    }

    protected void showCollectBill(ListSelectedRowCollection listSelectedData) {
        Object[] primaryKeyValues = listSelectedData.getPrimaryKeyValues();
        StringBuilder sb = new StringBuilder();
        for (Object pk : primaryKeyValues) {
            sb.append(pk.toString()).append(",");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("formId", "pmdc_collectmanage");
        map.put("docitempks", sb.toString());
        FormShowParameter parameter = FormShowParameter.createFormShowParameter(map);
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setCaption(ResManager.loadKDString((String)"\u5f52\u6863\u9875\u9762", (String)"DocLibListPlugin_13", (String)"pmgt-pmdc-formplugin", (Object[])new Object[0]));
        parameter.setAppId(this.getView().getFormShowParameter().getAppId());
        this.getView().showForm(parameter);
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        String actionId = event.getActionId();
        if (OPERATION_CLEARCOLLECTRECORD.equalsIgnoreCase(actionId)) {
            DynamicObject[] collectRecords;
            Object returnData = event.getReturnData();
            if (returnData == null) {
                return;
            }
            Object[] primaryKeyValues = ((ListSelectedRowCollection)returnData).getPrimaryKeyValues();
            for (DynamicObject collectRecord : collectRecords = BusinessDataServiceHelper.load((String)"pmdc_collectrecord", (String)"id, enable", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)primaryKeyValues)})) {
                collectRecord.set("enable", (Object)EnableEnum.DISABLE.getValue());
            }
            SaveServiceHelper.save((DynamicObject[])collectRecords);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5f52\u6863\u5173\u7cfb\u6e05\u9664\u6210\u529f\u3002", (String)"DocLibListPlugin_15", (String)"pmgt-pmdc-formplugin", (Object[])new Object[0]));
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        Object openBy = this.getView().getFormShowParameter().getCustomParam("openby");
        args.setCancel(true);
        if (openBy != null && "pmdc_collectmanage".equals(openBy.toString())) {
            return;
        }
        String fieldName = args.getFieldName();
        ListSelectedRow currentSelectedRowInfo = ((BillList)args.getHyperLinkClickEvent().getSource()).getCurrentSelectedRowInfo();
        Object primaryKeyValue = currentSelectedRowInfo.getPrimaryKeyValue();
        switch (fieldName) {
            case "name": {
                DynamicObject originalDocLib;
                Map downLoadPerm = ProjectPermissionHelper.getPermObj((String)"pmdc_docitem", (String)OPERATION_DOWNLOAD);
                String permItemId = downLoadPerm.get("id").toString();
                List<Long> hasPermOrgUnits = this.getAllPermOrgByPermItemFromCache("pmdc_docitem", permItemId, false);
                if (CollectionUtils.isEmpty(hasPermOrgUnits)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u8d44\u6599\u5e93\u5217\u8868\u201d\u7684\u201c\u4e0b\u8f7d\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"DocLibListPlugin_14", (String)"pmgt-pmdc-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    break;
                }
                DynamicObject docItem = BusinessDataServiceHelper.loadSingle((Object)primaryKeyValue, (String)"pmdc_docitem");
                boolean exists = this.checkBillAvailable(docItem, originalDocLib = BusinessDataServiceHelper.loadSingle((Object)docItem.getDynamicObject("group").getPkValue(), (String)"pmdc_originaldoclibdir"));
                if (!exists) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u5df2\u7ecf\u4e0d\u5b58\u5728\u6216\u4e0d\u4e3a\u5ba1\u6838\u72b6\u6001\uff0c\u8bf7\u68c0\u67e5\u540e\u518d\u4e0b\u8f7d\u3002", (String)"DocLibListPlugin_18", (String)"pmgt-pmdc-formplugin", (Object[])new Object[0]), docItem.getString("number")));
                    args.setCancel(true);
                    break;
                }
                this.doDownload(docItem, permItemId);
                break;
            }
            case "sourcebillno": {
                DynamicObject docItem = BusinessDataServiceHelper.loadSingle((Object)primaryKeyValue, (String)"pmdc_docitem");
                String formId = docItem.getDynamicObject("sourcebill").getPkValue().toString();
                Object billDataId = docItem.get("billdataid");
                BillShowParameter showParam = OpenPageUtils.buildBillShowParam((Object)billDataId, (String)formId);
                this.getView().showForm((FormShowParameter)showParam);
                break;
            }
        }
    }

    private boolean checkBillAvailable(DynamicObject docItem, DynamicObject originalDocLib) {
        String billStatusField;
        QFilter billEffectiveFilter;
        String formId = docItem.getDynamicObject("sourcebill").getPkValue().toString();
        Object billDataId = docItem.get("billdataid");
        String filterData = originalDocLib.getString("filterdata");
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)docItem.getDynamicObject("sourcebill").getString("number"));
        if (StringUtils.isNotEmpty((CharSequence)filterData)) {
            FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterData, FilterCondition.class);
            FilterBuilder filterBuilder = new FilterBuilder(dt, filterCondition);
            filterBuilder.buildFilter();
            billEffectiveFilter = filterBuilder.getQFilter();
        } else {
            billStatusField = this.getBillStatusField(dt, originalDocLib);
            billEffectiveFilter = new QFilter(billStatusField, "=", (Object)StatusEnum.CHECKED.getValue());
        }
        if (billEffectiveFilter == null) {
            billStatusField = this.getBillStatusField(dt, originalDocLib);
            billEffectiveFilter = new QFilter(billStatusField, "=", (Object)StatusEnum.CHECKED.getValue());
        }
        QFilter idFilter = new QFilter("id", "=", billDataId);
        return QueryServiceHelper.exists((String)formId, (QFilter[])new QFilter[]{idFilter, billEffectiveFilter});
    }

    private String getBillStatusField(MainEntityType dt, DynamicObject originalDocDir) {
        String billStatus = originalDocDir.getString("billstatusfield");
        if (StringUtils.isEmpty((CharSequence)billStatus) && dt instanceof BillEntityType) {
            billStatus = ((BillEntityType)dt).getBillStatus();
        }
        if (StringUtils.isEmpty((CharSequence)billStatus)) {
            ArrayList<String> statusFields = new ArrayList<String>();
            statusFields.add("status");
            statusFields.add("billstatus");
            billStatus = statusFields.stream().filter(it -> dt.getProperties().stream().map(IMetadata::getName).collect(Collectors.toSet()).contains(it)).findFirst().orElse(null);
        }
        return billStatus;
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        String alreadyInitTab = this.getPageCache().get("alreadyinittab");
        if (!"true".equals(alreadyInitTab)) {
            return;
        }
        Tab tab = (Tab)this.getView().getControl(CONTROL_TAB_AP);
        String currentTab = tab.getCurrentTab();
        this.getView().getPageCache().put("needActiveTab", currentTab);
        currentTab = currentTab.split("#")[0];
        this.putCurrentTabIdInCache(currentTab);
        this.getView().setVisible(Boolean.valueOf(StringUtils.equals((CharSequence)currentTab, (CharSequence)this.getOriginalDocLibPk())), new String[]{BTN_COLLECT, BTN_COLLECTRECORD, BTN_CLEARCOLLECTRECORD});
        this.getView().setVisible(Boolean.valueOf(!StringUtils.equals((CharSequence)currentTab, (CharSequence)this.getOriginalDocLibPk())), new String[]{BTN_ADD});
        this.getTreeListView().focusRootNode();
        this.getTreeListView().refresh();
        BillList billListAp = (BillList)this.getControl("billlistap");
        billListAp.refresh();
    }

    private String getOriginalDocLibPk() {
        String originalDocLibPk = this.getPageCache().get(PAGE_CACHE_ORIGINAL_DOC_LIB_PK);
        if (StringUtils.isEmpty((CharSequence)originalDocLibPk)) {
            DynamicObject originalDocLib = this.getOriginalDocLib();
            originalDocLibPk = originalDocLib.getPkValue().toString();
            this.getPageCache().put(PAGE_CACHE_ORIGINAL_DOC_LIB_PK, originalDocLibPk);
            DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache();
            cache.put(REDIS_CACHE_ORIGINAL_DOC_LIB_PK, (Object)originalDocLibPk);
        }
        return originalDocLibPk;
    }

    private DynamicObject getOriginalDocLib() {
        DynamicObject originalDocLib;
        String originalDocLibString = this.getPageCache().get("originaldoclib");
        MainEntityType dt = MetadataServiceHelper.getDataEntityType((String)"pmdc_doclibname");
        if (StringUtils.isEmpty((CharSequence)originalDocLibString)) {
            originalDocLib = BusinessDataServiceHelper.loadSingle((String)"pmdc_doclibname", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"originaldoclib")});
            this.getPageCache().put("originaldoclib", DynamicObjectSerializeUtil.serialize((Object[])new DynamicObject[]{originalDocLib}, (DynamicObjectType)dt));
        } else {
            originalDocLib = (DynamicObject)DynamicObjectSerializeUtil.deserialize((String)originalDocLibString, (DynamicObjectType)dt)[0];
        }
        return originalDocLib;
    }
}

