/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmdc.formplugin.doclib;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.mvc.list.TreeListModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmgt.pmbs.common.enums.EnableEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmbs.common.enums.budgetreg.EventBillTreeTypeEnum;
import kd.pmgt.pmbs.common.tree.DynamicInfoCollection;
import kd.pmgt.pmbs.formplugin.base.AbstractPmgtTreeListPlugin;
import kd.pmgt.pmdc.formplugin.doclib.DirFieldConfigFormPlugin;
import org.apache.commons.collections4.CollectionUtils;

public class OriginalDocLibListPlugin
extends AbstractPmgtTreeListPlugin {
    private String BILL_TYPE_CLOUD = EventBillTreeTypeEnum.CLOUD.getNumber();
    private String BILL_TYPE_APPLICATION = EventBillTreeTypeEnum.APPLICATION.getNumber();
    private String BILL_TYPE_BILL = EventBillTreeTypeEnum.BILL.getNumber();
    private static final String BTN_ADD = "add";
    private static final String BTN_FIELD_CONFIG = "fieldconfig";

    public void initialize() {
        super.initialize();
        this.getView().setVisible(Boolean.FALSE, new String[]{"iscontainnow"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().setFormTitle(new LocaleString(ResManager.loadKDString((String)"\u539f\u59cb\u5e93\u76ee\u5f55\u8bbe\u7f6e", (String)"OriginalDocLibListPlugin_0", (String)"pmgt-pmdc-formplugin", (Object[])new Object[0])));
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{"iscontainnow"});
    }

    public void buildTreeListFilter(BuildTreeListFilterEvent e) {
        super.buildTreeListFilter(e);
        TreeNode root = this.getTreeModel().getRoot();
        List<QFilter> qFilters = this.getCommonQFilters();
        QFilter billFilter = new QFilter("billtype", "=", (Object)this.BILL_TYPE_BILL);
        qFilters.add(billFilter);
        DynamicObject[] billOriginalDocLibList = BusinessDataServiceHelper.load((String)"pmdc_originaldoclibdir", (String)"id", (QFilter[])qFilters.toArray(new QFilter[0]));
        List<String> pkList = Arrays.stream(billOriginalDocLibList).map(it -> it.getPkValue().toString()).collect(Collectors.toList());
        this.removeBillNode(root, pkList);
        this.getTreeModel().setRoot(root);
    }

    public void refreshNode(RefreshNodeEvent e) {
        super.refreshNode(e);
        TreeListModel treeModel = (TreeListModel)this.getTreeModel();
        treeModel.getQueryParas().put("order", "number");
    }

    private List<QFilter> getCommonQFilters() {
        ArrayList<QFilter> qFilter = new ArrayList<QFilter>();
        QFilter statusFilter = new QFilter("status", "=", (Object)StatusEnum.CHECKED.getValue());
        QFilter enableFilter = new QFilter("enable", "=", (Object)EnableEnum.ENABLE.getValue());
        qFilter.add(statusFilter);
        qFilter.add(enableFilter);
        return qFilter;
    }

    private void removeBillNode(TreeNode treeNode, List<String> pkList) {
        if (CollectionUtils.isEmpty(pkList)) {
            treeNode.setChildren(null);
        }
        List children = treeNode.getChildren();
        treeNode.setExpend(true);
        treeNode.setIsOpened(true);
        if (CollectionUtils.isEmpty((Collection)children)) {
            return;
        }
        List collect = children.stream().filter(it -> !pkList.contains(it.getId())).collect(Collectors.toList());
        if (collect.isEmpty()) {
            treeNode.setChildren(null);
            return;
        }
        treeNode.setChildren(collect);
        for (TreeNode node : collect) {
            if (!node.getId().equals(this.getTreeModel().getRoot().getId()) && !node.getText().contains(node.getLongNumber().replace(treeNode.getLongNumber() + ".", "("))) {
                node.setText(node.getText() + String.format("(%s)", node.getLongNumber()).replace(treeNode.getLongNumber() + ".", ""));
            }
            this.removeBillNode(node, pkList);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        ListSelectedRowCollection listSelectedData = args.getListSelectedData();
        switch (operateKey) {
            case "add": {
                this.showBillForm();
                this.getView().setVisible(Boolean.FALSE, new String[]{"iscontainnow"});
                break;
            }
            case "customdelete": {
                StringBuilder tips = new StringBuilder();
                Object[] originalDocLibDirIdArray = listSelectedData.stream().map(ListSelectedRow::getPrimaryKeyValue).toArray();
                QFilter docDirectoryPkFilter = new QFilter("group", "in", (Object)originalDocLibDirIdArray);
                QFilter statusFilter = new QFilter("status", "=", (Object)StatusEnum.CHECKED.getValue());
                QFilter enableFilter = new QFilter("enable", "=", (Object)EnableEnum.ENABLE.getValue());
                DynamicObject[] docItemArray = BusinessDataServiceHelper.load((String)"pmdc_docitem", (String)"id, group, doctype", (QFilter[])new QFilter[]{docDirectoryPkFilter, statusFilter, enableFilter});
                DynamicObject[] docItemFromDocApplyArray = BusinessDataServiceHelper.load((String)"pmdc_docitem", (String)"id, group, doctype", (QFilter[])new QFilter[]{new QFilter("doctype", "=", (Object)"2"), statusFilter, enableFilter});
                List docItemList = Stream.concat(Arrays.stream(docItemArray), Arrays.stream(docItemFromDocApplyArray)).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(docItemList)) {
                    DynamicObject[] docDirectoryArray = BusinessDataServiceHelper.load((Object[])originalDocLibDirIdArray, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"pmdc_docdirectory"));
                    Set canNotDeletePks = docItemList.stream().map(it -> it.getDynamicObject("group").getPkValue().toString()).collect(Collectors.toSet());
                    DynamicObject docApplyDocDirectory = Arrays.stream(docDirectoryArray).filter(it -> it.getString("number").equals("pmdc_docapply")).findFirst().orElse(null);
                    List docItemFromDocApply = docItemList.stream().filter(it -> it.getString("doctype").equals("2")).collect(Collectors.toList());
                    if (CollectionUtils.isNotEmpty(docItemFromDocApply) && docApplyDocDirectory != null) {
                        canNotDeletePks.add(docApplyDocDirectory.getPkValue().toString());
                    }
                    for (String canNotDeletePk : canNotDeletePks) {
                        DynamicObject docDirectory = Arrays.stream(docDirectoryArray).filter(it -> it.getPkValue().toString().equals(canNotDeletePk)).findFirst().orElse(null);
                        if (docDirectory == null) continue;
                        tips.append(String.format(ResManager.loadKDString((String)"%s\u76ee\u5f55\u4e0b\u5df2\u6709\u8d44\u6599\u8bb0\u5f55\uff0c\u65e0\u6cd5\u5220\u9664\uff0c\u8bf7\u5148\u6e05\u9664\u5176\u4e0b\u8d44\u6599\u8bb0\u5f55\u540e\u518d\u8bd5\u3002%n", (String)"OriginalDocLibListPlugin_8", (String)"pmgt-pmdc-formplugin", (Object[])new Object[0]), docDirectory.get("name")));
                    }
                }
                if (!StringUtils.isNotEmpty((CharSequence)tips.toString())) break;
                this.getView().showErrorNotification(tips.toString());
                args.setCancel(true);
                break;
            }
            case "refresh": {
                this.getTreeListView().refreshTreeNode(this.getTreeModel().getRoot().getId());
                break;
            }
            case "fieldconfig": {
                BillList billListAp = (BillList)this.getControl("billlistap");
                ListSelectedRowCollection selectedRows = billListAp.getSelectedRows();
                Object[] pkIds = selectedRows.getPrimaryKeyValues();
                if (pkIds.length > 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u591a\u9009\uff0c\u8bf7\u9009\u4e2d\u4e00\u6761\u539f\u59cb\u5e93\u76ee\u5f55\u8fdb\u884c\u914d\u7f6e\u3002", (String)"OriginalDocLibListPlugin_5", (String)"pmgt-pmdc-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    break;
                }
                if (pkIds.length != 0) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u9009\u62e9\u539f\u59cb\u5e93\u76ee\u5f55\uff0c\u8bf7\u9009\u62e9\u4e00\u6761\u3002", (String)"OriginalDocLibListPlugin_6", (String)"pmgt-pmdc-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        BillList billListAp = (BillList)this.getControl("billlistap");
        switch (operateKey) {
            case "customdelete": {
                ListSelectedRowCollection selectedRows = billListAp.getSelectedRows();
                Object[] pkIds = selectedRows.getPrimaryKeyValues();
                DeleteServiceHelper.delete((IDataEntityType)MetadataServiceHelper.getDataEntityType((String)"pmdc_docdirectory"), (Object[])pkIds);
                this.deleteParent(this.BILL_TYPE_APPLICATION);
                this.deleteParent(this.BILL_TYPE_CLOUD);
                this.getView().invokeOperation("refresh");
                this.getTreeListView().focusRootNode();
                break;
            }
            case "fieldconfig": {
                ListSelectedRowCollection selectedRows = billListAp.getSelectedRows();
                Object[] pkIds = selectedRows.getPrimaryKeyValues();
                this.showFieldConfig(pkIds[0]);
                break;
            }
        }
    }

    private void showFieldConfig(Object originalDocDirPk) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("pmdc_dirfieldconfig");
        parameter.setStatus(OperationStatus.ADDNEW);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, BTN_FIELD_CONFIG);
        parameter.setCloseCallBack(closeCallBack);
        parameter.setCustomParam("originaldoclibpk", originalDocDirPk);
        this.getView().showForm(parameter);
    }

    public void listRowClick(ListRowClickEvent evt) {
        if (CollectionUtils.isEmpty((Collection)evt.getListSelectedRowCollection())) {
            this.getTreeListView().focusRootNode();
            return;
        }
        if (evt.getCurrentListSelectedRow() == null) {
            return;
        }
        Object primaryKeyValue = evt.getCurrentListSelectedRow().getPrimaryKeyValue();
        DynamicObject originalDocLibDir = BusinessDataServiceHelper.loadSingle((Object)primaryKeyValue, (String)"pmdc_originaldoclibdir");
        String parent = originalDocLibDir.getDynamicObject("parent").getPkValue().toString();
        List treeNodeChildren = this.getTreeModel().getRoot().getChildren();
        TreeNode treeNode = null;
        for (TreeNode treeNodeChild : treeNodeChildren) {
            for (TreeNode child : treeNodeChild.getChildren()) {
                if (child == null || !child.getId().equals(parent)) continue;
                treeNode = child;
                break;
            }
            if (treeNode == null) continue;
            break;
        }
        if (treeNode != null) {
            this.getTreeListView().getTreeView().focusNode(treeNode);
        }
    }

    private void deleteParent(String billType) {
        List<QFilter> commonQFilters = this.getCommonQFilters();
        DynamicObject[] originalDocLibArray = BusinessDataServiceHelper.load((String)"pmdc_originaldoclibdir", (String)"parent, billtype", (QFilter[])commonQFilters.toArray(new QFilter[0]));
        Set parentIds = Arrays.stream(originalDocLibArray).filter(it -> it.getDynamicObject("parent") != null).map(it -> (Long)it.getDynamicObject("parent").getPkValue()).collect(Collectors.toSet());
        Set applicationPks = Arrays.stream(originalDocLibArray).filter(it -> billType.equals(it.getString("billtype"))).map(it -> Long.parseLong(it.getPkValue().toString())).collect(Collectors.toSet());
        applicationPks.removeAll(parentIds);
        DeleteServiceHelper.delete((String)"pmdc_originaldoclibdir", (QFilter[])new QFilter[]{new QFilter("id", "in", applicationPks)});
    }

    private void showBillForm() {
        ListShowParameter formShowParameter = ShowFormHelper.createShowListForm((String)"pmbs_addinsidebill", (boolean)true);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "addbill");
        formShowParameter.setCloseCallBack(closeCallBack);
        formShowParameter.setStatus(OperationStatus.ADDNEW);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u65b0\u589e\u4e1a\u52a1\u4e91\u76ee\u5f55", (String)"OriginalDocLibListPlugin_2", (String)"pmgt-pmdc-formplugin", (Object[])new Object[0]));
        HashMap<String, String> customParams = new HashMap<String, String>(10);
        customParams.put("showExt", "true");
        customParams.put("showFormBillByMenuOrder", "true");
        formShowParameter.setCustomParams(customParams);
        QFilter billFilter = new QFilter("billtype", "=", (Object)this.BILL_TYPE_BILL);
        List<QFilter> qFilters = this.getCommonQFilters();
        qFilters.add(billFilter);
        DynamicObject[] originalDocLibArray = BusinessDataServiceHelper.load((String)"pmdc_originaldoclibdir", (String)"id,formmeta", (QFilter[])qFilters.toArray(new QFilter[0]));
        Object[] pkIds = Arrays.stream(originalDocLibArray).filter(it -> it.getDynamicObject("formmeta") != null).map(it -> it.getDynamicObject("formmeta").getPkValue().toString()).toArray();
        QFilter qBillNumFilter = new QFilter("id", "in", (Object)pkIds);
        DynamicObjectCollection formMetas = QueryServiceHelper.query((String)"bos_formmeta", (String)"id,number,name", (QFilter[])new QFilter[]{qBillNumFilter});
        formShowParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "not in", (Object)formMetas.stream().map(it -> it.get("id")).distinct().toArray()));
        QFilter modelTypeFilter = new QFilter("modeltype", "in", (Object)"BillFormModel");
        ArrayList<String> specialBill = new ArrayList<String>();
        specialBill.add("pmpt_reporttaskview");
        QFilter numberFilter = new QFilter("number", "in", specialBill);
        modelTypeFilter.or(numberFilter);
        formShowParameter.getListFilterParameter().getQFilters().add(modelTypeFilter);
        StyleCss css = new StyleCss();
        css.setHeight("650");
        css.setWidth("1200");
        formShowParameter.getOpenStyle().setInlineStyleCss(css);
        this.getView().showForm((FormShowParameter)formShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object backData = null;
        switch (actionId) {
            case "addbill": {
                backData = closedCallBackEvent.getReturnData();
                if (backData != null && backData.getClass().equals(ListSelectedRowCollection.class)) {
                    List<String> billNum = ((ListSelectedRowCollection)backData).stream().map(ListSelectedRow::getNumber).collect(Collectors.toList());
                    this.addBill(billNum);
                    this.getTreeListView().focusRootNode();
                    this.getTreeListView().refreshTreeView();
                }
                this.getView().setVisible(Boolean.FALSE, new String[]{"iscontainnow"});
                break;
            }
            case "fieldconfig": {
                backData = closedCallBackEvent.getReturnData();
                Object primaryKeyValue = null;
                if (backData != null) {
                    primaryKeyValue = ((ListSelectedRowCollection)backData).getPrimaryKeyValues()[0];
                }
                if (backData == null || !(primaryKeyValue instanceof DirFieldConfigFormPlugin.DirFieldConfig)) break;
                DirFieldConfigFormPlugin.DirFieldConfig dirFieldConfig = (DirFieldConfigFormPlugin.DirFieldConfig)primaryKeyValue;
                DynamicObject originalDocLibDir = BusinessDataServiceHelper.loadSingle((Object)dirFieldConfig.getOriginalDocLibDirPk(), (String)"pmdc_originaldoclibdir");
                String billNoField = dirFieldConfig.getBillNoField();
                originalDocLibDir.set("billnofield", (Object)billNoField);
                String billNameField = dirFieldConfig.getBillNameField();
                originalDocLibDir.set("billnamefield", (Object)billNameField);
                String billStatusField = dirFieldConfig.getBillStatusField();
                originalDocLibDir.set("billstatusfield", (Object)billStatusField);
                String filterData = dirFieldConfig.getFilterData();
                originalDocLibDir.set("filterdata", (Object)filterData);
                FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterData, FilterCondition.class);
                FilterBuilder filterBuilder = new FilterBuilder(EntityMetadataCache.getDataEntityType((String)originalDocLibDir.getString("number")), filterCondition);
                filterBuilder.buildFilter();
                QFilter qFilter = filterBuilder.getQFilter();
                boolean isFieldConfig = StringUtils.isNotEmpty((CharSequence)billNoField) || StringUtils.isNotEmpty((CharSequence)billNameField) || StringUtils.isNotEmpty((CharSequence)billStatusField) || qFilter != null;
                originalDocLibDir.set("isfieldconfig", (Object)isFieldConfig);
                SaveServiceHelper.update((DynamicObject)originalDocLibDir);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5b57\u6bb5\u914d\u7f6e\u6210\u529f\u3002", (String)"OriginalDocLibListPlugin_7", (String)"pmgt-pmdc-formplugin", (Object[])new Object[0]));
                BillList billList = (BillList)this.getControl("billlistap");
                billList.refresh();
                break;
            }
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        List qFilters = e.getQFilters();
        if (!qFilters.isEmpty()) {
            DynamicObject[] originalDocLibArray = BusinessDataServiceHelper.load((String)"pmdc_originaldoclibdir", (String)"id,parent,isleaf", (QFilter[])this.getCommonQFilters().toArray(new QFilter[0]));
            TreeNode root = this.getTreeModel().getRoot();
            String currentNodeId = this.getTreeModel().getCurrentNodeId().toString();
            ArrayList<Long> leafIds = new ArrayList();
            if (!root.getId().equals(currentNodeId)) {
                DynamicObject currentOriginalDocLib = Arrays.stream(originalDocLibArray).filter(it -> it.getPkValue().toString().equals(currentNodeId)).findFirst().orElse(null);
                if (currentOriginalDocLib != null && currentOriginalDocLib.getBoolean("isleaf")) {
                    return;
                }
                this.getLeafId(Arrays.stream(originalDocLibArray).collect(Collectors.toList()), currentOriginalDocLib, leafIds);
            } else {
                leafIds = Arrays.stream(originalDocLibArray).filter(it -> it.getBoolean("isleaf")).map(it -> Long.parseLong(it.getPkValue().toString())).collect(Collectors.toList());
            }
            qFilters.removeIf(it -> it.getProperty().equals("parent"));
            QFilter leafIdFilter = new QFilter("id", "in", leafIds);
            qFilters.add(leafIdFilter);
        }
    }

    private void getLeafId(List<DynamicObject> docLibs, DynamicObject currentLib, List<Long> leafIds) {
        if (currentLib == null) {
            return;
        }
        Long currentLibPkValue = Long.parseLong(currentLib.getPkValue().toString());
        boolean isLeaf = currentLib.getBoolean("isleaf");
        if (isLeaf) {
            leafIds.add(Long.parseLong(currentLib.getPkValue().toString()));
        } else {
            for (DynamicObject docLib : docLibs) {
                DynamicObject parent = docLib.getDynamicObject("parent");
                if (parent == null || Long.parseLong(parent.getPkValue().toString()) != currentLibPkValue) continue;
                this.getLeafId(docLibs, docLib, leafIds);
            }
        }
    }

    private void addBill(List<String> needUpdateBill) {
        List neededCloud;
        Object name;
        QFilter qBillNumFilter = new QFilter("number", "in", (Object)needUpdateBill.toArray());
        DynamicObject[] formMetas = BusinessDataServiceHelper.load((String)"bos_formmeta", (String)"id,number,name,bizappid", (QFilter[])new QFilter[]{qBillNumFilter});
        HashSet<String> appOrCloudInfos = new HashSet<String>(16);
        DynamicInfoCollection newEntityInfos = new DynamicInfoCollection(ResManager.loadKDString((String)"\u6682\u5b58\u8981\u521b\u5efa\u884c\u7684\u6570\u636e\u4fe1\u606f", (String)"OriginalDocLibListPlugin_3", (String)"pmgt-pmdc-formplugin", (Object[])new Object[0]), new String[]{"name", "number", "parentNum", "billTreeNodeType", "billTreeNode", "formmeta"});
        Map allAppMenus = AppMetadataCache.getAllAppMenus();
        DynamicObjectCollection apps = BizAppServiceHelp.getAllBizApps();
        for (DynamicObject formMetaIInfo : formMetas) {
            ILocaleString name2 = formMetaIInfo.getLocaleString("name");
            String billNumber = formMetaIInfo.getString("number");
            String bizAppId = null;
            for (Map.Entry entry : allAppMenus.entrySet()) {
                List appMenuInfos = (List)entry.getValue();
                boolean contain = appMenuInfos.stream().filter(it -> StringUtils.isNotEmpty((CharSequence)it.getFormId())).anyMatch(it -> it.getFormId().equals(billNumber));
                if (!contain) continue;
                DynamicObject app = apps.stream().filter(it -> it.getString("number").equals(entry.getKey())).findFirst().orElse(null);
                bizAppId = app != null ? app.getString("id") : null;
                break;
            }
            if (StringUtils.isEmpty(bizAppId)) {
                bizAppId = formMetaIInfo.getString("bizappid");
            }
            newEntityInfos.addInfo(new Object[]{name2, billNumber, bizAppId, this.BILL_TYPE_BILL, null, formMetaIInfo});
            appOrCloudInfos.add(bizAppId);
        }
        QFilter idFilter = new QFilter("id", "in", (Object)appOrCloudInfos.toArray());
        DynamicObject[] appInfos = BusinessDataServiceHelper.load((String)"bos_devportal_bizapp", (String)"id,number,name,bizcloud.number,bizcloud.name", (QFilter[])new QFilter[]{idFilter});
        appOrCloudInfos.clear();
        for (DynamicObject app : appInfos) {
            String id = app.getString("id");
            name = app.getLocaleString("name");
            String appNumber = app.getString("number");
            String cloudNum = app.getString("bizcloud.number");
            ILocaleString cloudName = app.getLocaleString("bizcloud.name");
            if (appOrCloudInfos.add(cloudNum)) {
                String rootId = this.getTreeModel().getRoot().getId();
                newEntityInfos.addInfo(new Object[]{cloudName, cloudNum, rootId, this.BILL_TYPE_CLOUD, null, null});
            }
            newEntityInfos.getAllInfoByOneProp("parentNum", (Object)id).forEach(info -> info.setValueByPropName("parentNum", (Object)(appNumber + "-" + this.BILL_TYPE_APPLICATION)));
            newEntityInfos.addInfo(new Object[]{name, appNumber, cloudNum + "-" + this.BILL_TYPE_CLOUD, this.BILL_TYPE_APPLICATION, null, null});
        }
        DynamicInfoCollection regedRowInfos = new DynamicInfoCollection(ResManager.loadKDString((String)"\u5df2\u6ce8\u518c\u884c\u7684\u4fe1\u606f", (String)"OriginalDocLibListPlugin_4", (String)"pmgt-pmdc-formplugin", (Object[])new Object[0]), new String[]{"id", "number", "billtype"});
        QFilter qApp = new QFilter("billtype", "=", (Object)this.BILL_TYPE_APPLICATION);
        qApp.and("number", "in", (Object)newEntityInfos.getAllValOfOnePropByAnotherProp("number", "billTreeNodeType", (Object)this.BILL_TYPE_APPLICATION).toArray());
        QFilter qCloud = new QFilter("billtype", "=", (Object)this.BILL_TYPE_CLOUD);
        qCloud.and("number", "in", (Object)newEntityInfos.getAllValOfOnePropByAnotherProp("number", "billTreeNodeType", (Object)this.BILL_TYPE_CLOUD).toArray());
        qApp.or(qCloud);
        QFilter qBill = new QFilter("billtype", "=", (Object)this.BILL_TYPE_BILL);
        qBill.and("number", "in", (Object)newEntityInfos.getAllValOfOnePropByAnotherProp("number", "billTreeNodeType", (Object)this.BILL_TYPE_BILL).toArray());
        qApp.or(qBill);
        DataSet data = QueryServiceHelper.queryDataSet((String)"OriginalDocLibList", (String)"pmdc_originaldoclibdir", (String)"id,number,billtype", (QFilter[])new QFilter[]{qApp}, null);
        name = null;
        try {
            while (data.hasNext()) {
                Row rowData = data.next();
                String id = rowData.getString("id");
                String number = rowData.getString("number");
                String billType = rowData.getString("billtype");
                regedRowInfos.addInfo(new Object[]{id, number, billType});
            }
        }
        catch (Throwable rowData) {
            name = rowData;
            throw rowData;
        }
        finally {
            if (data != null) {
                if (name != null) {
                    try {
                        data.close();
                    }
                    catch (Throwable rowData) {
                        ((Throwable)name).addSuppressed(rowData);
                    }
                } else {
                    data.close();
                }
            }
        }
        if (!regedRowInfos.isEmpty()) {
            List regAppNums = regedRowInfos.getAllValOfOnePropByAnotherProp("number", "billtype", (Object)this.BILL_TYPE_APPLICATION);
            List regCloudNums = regedRowInfos.getAllValOfOnePropByAnotherProp("number", "billtype", (Object)this.BILL_TYPE_CLOUD);
            List regBillNums = regedRowInfos.getAllValOfOnePropByAnotherProp("number", "billtype", (Object)this.BILL_TYPE_BILL);
            Iterator iterator = newEntityInfos.getValues().iterator();
            DynamicInfoCollection.InfoObject infoObject = null;
            while (iterator.hasNext()) {
                infoObject = (DynamicInfoCollection.InfoObject)iterator.next();
                String type = (String)infoObject.getValueByPropName("billTreeNodeType");
                String num = (String)infoObject.getValueByPropName("number");
                if (type.equals(this.BILL_TYPE_APPLICATION)) {
                    if (!regAppNums.contains(num)) continue;
                    iterator.remove();
                    continue;
                }
                if (type.equals(this.BILL_TYPE_CLOUD)) {
                    if (!regCloudNums.contains(num)) continue;
                    iterator.remove();
                    continue;
                }
                if (!type.equals(this.BILL_TYPE_BILL) || !regBillNums.contains(num)) continue;
                iterator.remove();
            }
        }
        if ((neededCloud = newEntityInfos.getAllValOfOnePropByAnotherProp("parentNum", "billTreeNodeType", (Object)this.BILL_TYPE_APPLICATION)) != null) {
            Iterator iterator = newEntityInfos.getValues().iterator();
            while (iterator.hasNext()) {
                DynamicInfoCollection.InfoObject infoObject = (DynamicInfoCollection.InfoObject)iterator.next();
                String type = (String)infoObject.getValueByPropName("billTreeNodeType");
                String num = infoObject.getValueByPropName("number") + "-cloud";
                if (!type.equals(this.BILL_TYPE_CLOUD) || neededCloud.contains(num)) continue;
                iterator.remove();
            }
        }
        this.batchCreateNode(newEntityInfos, regedRowInfos, this.BILL_TYPE_CLOUD);
        this.batchCreateNode(newEntityInfos, regedRowInfos, this.BILL_TYPE_APPLICATION);
        this.batchCreateNode(newEntityInfos, null, this.BILL_TYPE_BILL);
        DynamicObject originalDocLib = BusinessDataServiceHelper.loadSingle((String)"pmdc_doclibname", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"originaldoclib")});
        List billEntities = newEntityInfos.getAllValOfOneProp("billTreeNode");
        for (Object billEntity : billEntities) {
            DynamicObject entity = (DynamicObject)billEntity;
            DynamicObject parentEntity = billEntities.stream().map(it -> (DynamicObject)it).filter(it -> it.getPkValue().toString().equals(entity.getString("parent"))).findFirst().orElse(null);
            this.buildLongNum(entity, parentEntity, billEntities);
            entity.set("doclibname", (Object)originalDocLib);
        }
        SaveServiceHelper.save((DynamicObject[])billEntities.toArray(new DynamicObject[0]));
    }

    private void buildLongNum(DynamicObject child, DynamicObject parent, List<Object> billEntities) {
        if (child == null) {
            return;
        }
        if (parent == null) {
            if (StringUtils.isEmpty((CharSequence)child.getString("longnumber"))) {
                child.set("longnumber", (Object)child.getString("number"));
            }
            return;
        }
        String parentLongNumber = parent.getString("longnumber");
        if (StringUtils.isEmpty((CharSequence)parentLongNumber)) {
            String parentOfParent = parent.getString("parent");
            DynamicObject parentOfParentObj = billEntities.stream().map(it -> (DynamicObject)it).filter(it -> it.getPkValue().toString().equals(parentOfParent)).findFirst().orElse(null);
            this.buildLongNum(parent, parentOfParentObj, billEntities);
        }
        child.set("longnumber", (Object)String.format("%s.%s", parent.getString("longnumber"), child.getString("number")));
    }

    private void batchCreateNode(DynamicInfoCollection newBillInfo, DynamicInfoCollection regedRowInfos, String billType) {
        List newNodes = newBillInfo.getAllInfoByOneProp("billTreeNodeType", (Object)billType);
        if (!newNodes.isEmpty()) {
            newNodes.forEach(newNode -> {
                DynamicInfoCollection.InfoObject parentInfoObject;
                String num = (String)newNode.getValueByPropName("number");
                ILocaleString name = (ILocaleString)newNode.getValueByPropName("name");
                String parentId = (String)newNode.getValueByPropName("parentNum");
                String longNumber = null;
                if (StringUtils.isNotEmpty((CharSequence)parentId) && regedRowInfos != null && (parentInfoObject = regedRowInfos.getInfoByOneProp("id", (Object)parentId)) != null) {
                    longNumber = String.format("%s.%s", parentInfoObject.getValueByPropName("number"), num);
                }
                DynamicObject formMeta = (DynamicObject)newNode.getValueByPropName("formmeta");
                DynamicObject node = this.createNode(name, num, parentId, longNumber, null, billType, formMeta);
                if (regedRowInfos != null) {
                    regedRowInfos.addInfo(new Object[]{node.getString("id"), num, billType});
                }
                newNode.setValueByPropName("billTreeNode", (Object)node);
            });
        }
        if (regedRowInfos != null) {
            List regNodeInfo = regedRowInfos.getAllInfoByOneProp("billtype", (Object)billType);
            regNodeInfo.forEach(node -> {
                String aid = (String)node.getValueByPropIndex(0);
                String num = (String)node.getValueByPropIndex(1);
                List newBills = newBillInfo.getAllInfoByOneProp("parentNum", (Object)(num + "-" + billType));
                newBills.forEach(bill -> bill.setValueByPropName("parentNum", (Object)aid));
            });
        }
    }

    private DynamicObject createNode(ILocaleString name, String number, String parentId, String longNumber, String longName, String billType, DynamicObject formMeta) {
        Long userId = RequestContext.get().getCurrUserId();
        DynamicObject originalDocLib = BusinessDataServiceHelper.newDynamicObject((String)"pmdc_originaldoclibdir");
        originalDocLib.set("id", (Object)DBServiceHelper.genGlobalLongId());
        originalDocLib.set("name", (Object)name);
        originalDocLib.set("number", (Object)number);
        originalDocLib.set("creator", (Object)userId);
        Date createTime = new Date();
        originalDocLib.set("createtime", (Object)createTime);
        originalDocLib.set("enable", (Object)EnableEnum.ENABLE.getValue());
        originalDocLib.set("status", (Object)StatusEnum.CHECKED.getValue());
        originalDocLib.set("modifytime", (Object)createTime);
        originalDocLib.set("isleaf", (Object)0);
        originalDocLib.set("longnumber", (Object)longNumber);
        originalDocLib.set("billtype", (Object)billType);
        originalDocLib.set("parent", (Object)(StringUtils.isEmpty((CharSequence)parentId) ? "0" : parentId));
        originalDocLib.set("fullname", (Object)longName);
        if (formMeta != null) {
            formMeta = BusinessDataServiceHelper.loadSingle((Object)formMeta.get("id"), (String)"bos_formmeta");
            originalDocLib.set("formmeta", (Object)formMeta);
        }
        if (billType != null && billType.equals(this.BILL_TYPE_BILL)) {
            originalDocLib.set("isleaf", (Object)1);
        }
        if (this.BILL_TYPE_CLOUD.equals(billType)) {
            originalDocLib.set("level", (Object)1);
        }
        if (this.BILL_TYPE_APPLICATION.equals(billType)) {
            originalDocLib.set("level", (Object)2);
        }
        if (this.BILL_TYPE_BILL.equals(billType)) {
            originalDocLib.set("level", (Object)3);
        }
        return originalDocLib;
    }
}

