/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmdc.business.directory;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.tree.TreeNode;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.pmgt.pmbs.common.enums.EnableEnum;
import kd.pmgt.pmbs.common.utils.ProjectPermissionHelper;

public class DirectoryService {
    public static final String ROOT_NODE_ID = "8609760E-EF83-4775-A9FF-CCDEC7C0B689";

    public List<TreeNode> getAuthorizedDirectoryNodeList() {
        return this.getNodes(this.getAuthorizedDirectoryList(null));
    }

    public DynamicObject[] getAuthorizedDirectoryList(List<QFilter> filterList) {
        QFilter enableFilter = new QFilter("enable", "=", (Object)EnableEnum.ENABLE.getValue());
        if (filterList == null) {
            filterList = new ArrayList<QFilter>(2);
        }
        filterList.add(enableFilter);
        List hashPermOrgUnits = ProjectPermissionHelper.getAllPermOrgsByPermItem((String)"15", (String)RequestContext.get().getUserId(), (String)"pmdc", (String)"pmdc_doclibname", (String)"47150e89000000ac");
        QFilter hasPermOrgFilter = new QFilter("useorg", "in", (Object)hashPermOrgUnits);
        QFilter hasOrgEntry = new QFilter("authorizedorgentry.authorgid", "in", (Object)hashPermOrgUnits);
        QFilter hasUserEntry = new QFilter("authuserentry.authuserid", "in", (Object)UserServiceHelper.getCurrentUserId());
        QFilter permissonFilter = hasPermOrgFilter.or(hasOrgEntry).or(hasUserEntry);
        filterList.add(permissonFilter);
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"pmdc_doclibname", (String)"", (QFilter[])filterList.toArray(new QFilter[0]));
        Arrays.sort(dynamicObjects, new Comparator<DynamicObject>(){

            @Override
            public int compare(DynamicObject o1, DynamicObject o2) {
                Collator instance = Collator.getInstance();
                String source = o1.getLocaleString("name").getLocaleValue() != null ? o1.getLocaleString("name").getLocaleValue() : "";
                String target = o2.getLocaleString("name").getLocaleValue() != null ? o2.getLocaleString("name").getLocaleValue() : "";
                return instance.compare(source, target);
            }
        });
        return dynamicObjects;
    }

    public List<TreeNode> getNodes(DynamicObject[] directories) {
        ArrayList<TreeNode> treeNodeList = new ArrayList<TreeNode>(10);
        for (DynamicObject treeData : directories) {
            TreeNode treeNode = this.constructTreeNode(treeData, null);
            treeNodeList.add(treeNode);
        }
        return treeNodeList;
    }

    private TreeNode constructTreeNode(DynamicObject treeData, String parentId) {
        MainEntityType refMainType = EntityMetadataCache.getDataEntityType((String)"bd_projectkind");
        String nameProperty = ((BasedataEntityType)refMainType).getNameProperty();
        nameProperty = StringUtils.isBlank((CharSequence)nameProperty) ? "name" : nameProperty;
        String treeNodeName = treeData.get(nameProperty).toString();
        TreeNode treeNode = new TreeNode(parentId, treeData.getPkValue().toString(), treeNodeName, true);
        treeNode.setChildren(null);
        return treeNode;
    }

    public Set<Object> getAuthorizedDocLibNameList() {
        QFilter enableFilter = new QFilter("enable", "=", (Object)EnableEnum.ENABLE.getValue());
        List hashPermOrgUnits = ProjectPermissionHelper.getAllPermOrgsByPermItem((String)"15", (String)RequestContext.get().getUserId(), (String)"pmdc", (String)"pmdc_doclibname", (String)"47150e89000000ac");
        QFilter hasPermOrgFilter = new QFilter("useorg", "in", (Object)hashPermOrgUnits);
        QFilter hasOrgEntry = new QFilter("authorizedorgentry.authorgid", "in", (Object)hashPermOrgUnits);
        QFilter hasUserEntry = new QFilter("authuserentry.authuserid", "in", (Object)UserServiceHelper.getCurrentUserId());
        QFilter permissionFilter = hasPermOrgFilter.or(hasOrgEntry).or(hasUserEntry);
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"pmdc_doclibname", (String)"", (QFilter[])new QFilter[]{enableFilter, permissionFilter});
        Set<Object> docLibIdSet = Arrays.stream(dynamicObjects).map(o -> o.get("id")).collect(Collectors.toSet());
        return docLibIdSet;
    }
}

