/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmdc.business.directory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.datamodel.RaiseEventType;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.property.SubEntryProp;
import kd.bos.entity.rule.RaiseEventSource;
import kd.bos.entity.rule.RuleContainer;
import kd.bos.entity.rule.RuleExecuteContext;
import kd.bos.form.BindingContext;
import kd.bos.form.IPageCache;
import kd.bos.form.control.EntryData;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.rule.FormRuleExecuteContext;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class DocDirectoryTreeEntryGrid
extends TreeEntryGrid {
    private static final String formId = "pmdc_docdirectory";
    public static final String FILTER_COUNT_CACHE = "filterCnt";
    private Set<String> rootDataIdSet = new HashSet<String>();

    public boolean isNeedPaged() {
        return true;
    }

    protected boolean onFetchPageData(int pageIndex, int pageRows) {
        return true;
    }

    protected int getRowCount() {
        int totalCnt = 0;
        if (this.rootDataIdSet.size() <= 0) {
            this.getAllRootBillDataIds();
        }
        return totalCnt += this.rootDataIdSet.size();
    }

    private void getAllRootBillDataIds() {
        String selectFields = "id, number, name, parent, longnumber, isleaf,status,enable,remark,level";
        List<QFilter> qFilters = this.getListFilters();
        DynamicObjectCollection filterDOColletion = QueryServiceHelper.query((String)formId, (String)selectFields, (QFilter[])qFilters.toArray(new QFilter[1]), (String)"number");
        HashSet<Long> nodePkSet = new HashSet<Long>(filterDOColletion.size());
        for (DynamicObject filterDO : filterDOColletion) {
            nodePkSet.add((Long)filterDO.get("id"));
        }
        for (DynamicObject filterDO : filterDOColletion) {
            if (nodePkSet.contains((Long)filterDO.get("parent"))) continue;
            this.rootDataIdSet.add(filterDO.get("id").toString());
        }
    }

    private List<QFilter> getListFilters() {
        String preCacheKey;
        String cacheKey;
        IPageCache pageCache = this.getView().getPageCache();
        String filterCntStr = pageCache.get(cacheKey = (preCacheKey = this.getView().getPageId() + "-") + FILTER_COUNT_CACHE);
        int filterCnt = StringUtils.isBlank((CharSequence)filterCntStr) ? 0 : Integer.parseInt(filterCntStr);
        ArrayList<QFilter> filterArr = new ArrayList<QFilter>(filterCnt);
        for (int i = 0; i < filterCnt; ++i) {
            String filterStr = pageCache.get(preCacheKey + i);
            QFilter tempFilter = QFilter.fromSerializedString((String)filterStr);
            filterArr.add(tempFilter);
        }
        return filterArr;
    }

    public EntryData getEntryData(int rowCount, int startIndex, int endIndex, int pageCount, int pageRows, int currPageIndex, Boolean needPaged) {
        ArrayList<RowDataEntity> objs = new ArrayList<RowDataEntity>();
        ArrayList<List> rows = new ArrayList<List>();
        DynamicObject[] dataEntitys = this.getEntryDataEntities(startIndex, endIndex);
        DynamicObjectCollection dynamicObjectCollection = this.getModel().getDataEntity(true).getDynamicObjectCollection(this.getEntryKey());
        if (dataEntitys != null && dataEntitys.length > 0) {
            IDataEntityType entityType = (IDataEntityType)this.getModel().getDataEntityType().getAllEntities().get(this.getEntryKey());
            DynamicObjectCollection allBillDataColl = this.getAllBillDatas(dataEntitys);
            dynamicObjectCollection.clear();
            dynamicObjectCollection.addAll((Collection)allBillDataColl);
            dynamicObjectCollection.setStartRowIndex(startIndex);
            int rootBillDataCnt = dataEntitys.length;
            int subBillDataCnt = allBillDataColl.size() - rootBillDataCnt;
            for (int rowIndex = 0; rowIndex < endIndex + subBillDataCnt - startIndex; ++rowIndex) {
                objs.add(new RowDataEntity(rowIndex + startIndex, (DynamicObject)allBillDataColl.get(rowIndex)));
            }
            if (super.getRuleCount() > 0) {
                RuleContainer ruleContaiber = (RuleContainer)this.view.getService(RuleContainer.class);
                ruleContaiber.raise(new RaiseEventSource(RaiseEventType.Initialized, objs, entityType), (RuleExecuteContext)new FormRuleExecuteContext(this.view));
            }
            for (RowDataEntity obj : objs) {
                BindingContext bindCtx = new BindingContext(entityType, obj.getDataEntity(), obj.getRowIndex());
                rows.add(super.getRowBindValue(bindCtx));
            }
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("rowcount", rowCount);
        data.put("rows", rows);
        data.put("pagerows", pageRows);
        data.put("pageindex", currPageIndex);
        data.put("isSplitPage", needPaged);
        data.put("phide", needPaged == false);
        data.put("pagecount", pageCount);
        data.put("datacount", rowCount);
        data.put("dataindex", this.getDataIndex());
        this.fireBindEntryGridDataEvent(objs, data, startIndex);
        IDataEntityProperty property = this.getModel().getProperty(this.getEntryKey());
        if (property instanceof SubEntryProp) {
            data.put("pr", this.getModel().getEntryCurrentRowIndex(property.getParent().getName()));
        }
        return new EntryData(this.getEntryKey(), startIndex, endIndex, pageCount, dataEntitys, data, null);
    }

    protected DynamicObject[] getEntryDataEntities(int startIndex, int endIndex) {
        Object[] allRootBillDatas = this.getAllRootBillDatas();
        DynamicObject[] rootBillDatas = (DynamicObject[])ArrayUtils.subarray((Object[])allRootBillDatas, (int)startIndex, (int)endIndex);
        return rootBillDatas;
    }

    private DynamicObject[] getAllRootBillDatas() {
        String selectFields = "id, number, name, parent, longnumber, isleaf,status,enable,remark,level";
        HashSet<Long> ids = new HashSet<Long>(this.rootDataIdSet.size());
        for (String idString : this.rootDataIdSet) {
            ids.add(Long.parseLong(idString));
        }
        QFilter filter = new QFilter("id", "in", ids);
        DynamicObject[] allRootBillDatas = BusinessDataServiceHelper.load((String)formId, (String)selectFields, (QFilter[])filter.toArray(), (String)"number");
        return allRootBillDatas;
    }

    private DynamicObjectCollection getAllBillDatas(DynamicObject[] rootBillDatas) {
        DynamicObjectCollection allBillDataColl = new DynamicObjectCollection();
        for (DynamicObject tempObj : rootBillDatas) {
            allBillDataColl.add((Object)this.transBizData2TreeEntryData(tempObj, 0));
            allBillDataColl.addAll((Collection)this.getAllSubBillDatas(tempObj.getPkValue()));
        }
        return allBillDataColl;
    }

    private DynamicObjectCollection getAllSubBillDatas(Object parentId) {
        DynamicObject[] tempSubBillDatas;
        DynamicObjectCollection allSubBillDataColl = new DynamicObjectCollection();
        String selectFields = "id, number, name, parent, longnumber, isleaf,status,enable,remark,level";
        QFilter filter = new QFilter("parent", "=", parentId);
        List<QFilter> filterList = this.getListFilters();
        filterList.add(filter);
        for (DynamicObject tempObj : tempSubBillDatas = BusinessDataServiceHelper.load((String)formId, (String)selectFields, (QFilter[])filterList.toArray(new QFilter[0]), (String)"number")) {
            allSubBillDataColl.add((Object)this.transBizData2TreeEntryData(tempObj, parentId));
            allSubBillDataColl.addAll((Collection)this.getAllSubBillDatas(tempObj.getPkValue()));
        }
        return allSubBillDataColl;
    }

    private DynamicObject transBizData2TreeEntryData(DynamicObject sourceBillData, Object parentId) {
        EntityType entityType = (EntityType)this.getModel().getDataEntityType().getAllEntities().get(this.getEntryKey());
        DynamicObject treeRowObj = new DynamicObject((DynamicObjectType)entityType);
        treeRowObj.set("id", sourceBillData.getPkValue());
        treeRowObj.set("pid", parentId);
        treeRowObj.set(4, (Object)"false");
        treeRowObj.set("number", (Object)sourceBillData);
        treeRowObj.set("enable", sourceBillData.get("enable"));
        treeRowObj.set("remark", sourceBillData.get("remark"));
        return treeRowObj;
    }
}

