/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmdc.business.directory;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.AppMenuInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.pmgt.pmbs.common.enums.EnableEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmbs.common.enums.budgetreg.EventBillTreeTypeEnum;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class OriginalDirectoryService {
    public DynamicObject[] getNoPermDocDirectoryInOriginalDocLibByAppNum(String appNum) {
        if (StringUtils.isEmpty((CharSequence)appNum)) {
            return new DynamicObject[0];
        }
        HashSet<String> noPermFormId = new HashSet<String>(16);
        QFilter billFilter = new QFilter("billtype", "=", (Object)EventBillTreeTypeEnum.BILL.getNumber());
        DynamicObject[] appOriginalDocLibArray = BusinessDataServiceHelper.load((String)"pmdc_originaldoclibdir", (String)"in", (QFilter[])new QFilter[]{billFilter});
        String appId = BizAppServiceHelp.getAppIdByAppNumber((String)appNum);
        List allNoPermMenuIdsByAppId = PermissionServiceHelper.getAllNoPermMenuIdsByAppId((Long)RequestContext.get().getCurrUserId(), (String)appId);
        List appMenusInfoByAppNum = AppMetadataCache.getAppMenusInfoByAppNum((String)appNum);
        for (String menuId : allNoPermMenuIdsByAppId) {
            AppMenuInfo menu = appMenusInfoByAppNum.stream().filter(it -> it.getId().equals(menuId)).findFirst().orElse(null);
            if (menu == null) continue;
            noPermFormId.add(menu.getFormId());
        }
        return (DynamicObject[])Arrays.stream(appOriginalDocLibArray).filter(it -> noPermFormId.contains(it.getString("number"))).toArray(DynamicObject[]::new);
    }

    public DynamicObject[] getNoPermDocDirectoryInOriginalDocLib() {
        HashSet<String> noPermFormId = new HashSet<String>();
        DynamicObjectCollection apps = BizAppServiceHelp.getAllBizApps();
        DynamicObject[] appOriginalDocLibArray = BusinessDataServiceHelper.load((String)"pmdc_originaldoclibdir", (String)"in", (QFilter[])new QFilter[]{new QFilter("billtype", "=", (Object)"application")});
        Set appNums = Arrays.stream(appOriginalDocLibArray).map(it -> it.getString("number")).collect(Collectors.toSet());
        Set targetAppIds = apps.stream().filter(it -> appNums.contains(it.getString("number"))).map(it -> it.getString("id")).collect(Collectors.toSet());
        Map userNoPermMenuByBatchApp = PermissionServiceHelper.getUserNoPermMenuByBatchApp((Long)RequestContext.get().getCurrUserId(), targetAppIds);
        for (Map.Entry appAndNoPermMenu : userNoPermMenuByBatchApp.entrySet()) {
            Set menuIds = (Set)appAndNoPermMenu.getValue();
            for (String menuId : menuIds) {
                AppMenuInfo menu = AppMetadataCache.getAppMenuInfo((String)((String)appAndNoPermMenu.getKey()), (String)menuId);
                if (menu == null) continue;
                noPermFormId.add(menu.getFormId());
            }
        }
        return BusinessDataServiceHelper.load((String)"pmdc_originaldoclibdir", (String)"in", (QFilter[])new QFilter[]{new QFilter("number", "in", noPermFormId)});
    }

    public DynamicObject[] getNoPermDocDirectoryInOriginalDocLib(String app) {
        HashSet<String> noPermFormId = new HashSet<String>();
        HashSet<String> targetAppIds = new HashSet<String>(1);
        targetAppIds.add(app);
        Map userNoPermMenuByBatchApp = PermissionServiceHelper.getUserNoPermMenuByBatchApp((Long)RequestContext.get().getCurrUserId(), targetAppIds);
        for (Map.Entry appAndNoPermMenu : userNoPermMenuByBatchApp.entrySet()) {
            Set menuIds = (Set)appAndNoPermMenu.getValue();
            for (String menuId : menuIds) {
                AppMenuInfo menu = AppMetadataCache.getAppMenuInfo((String)((String)appAndNoPermMenu.getKey()), (String)menuId);
                if (menu == null) continue;
                noPermFormId.add(menu.getFormId());
            }
        }
        return BusinessDataServiceHelper.load((String)"pmdc_originaldoclibdir", (String)"in", (QFilter[])new QFilter[]{new QFilter("number", "in", noPermFormId)});
    }

    public List<DynamicObject> hasPermOriginalDocLibs(List<Long> hasPermOrgs) {
        String dimTypeNum = "DIM_ORG";
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>(100);
        Long userId = RequestContext.get().getCurrUserId();
        DataSet assignPermInfo = null;
        DataSet appInfo = null;
        DataSet cloudInfo = null;
        DataSet finalDs = null;
        StringBuilder orgIdStr = new StringBuilder();
        if (CollectionUtils.isEmpty(hasPermOrgs)) {
            return result;
        }
        for (Long org : hasPermOrgs) {
            orgIdStr.append(org).append(",");
        }
        orgIdStr.deleteCharAt(orgIdStr.length() - 1);
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT up.fid, up.forgid, up.fisincludesuborg, upd.fbizappid, upd.fentitytypeid, upd.fpermitemid, pit.fnumber permitemnum FROM t_perm_userperm up ").append(" JOIN t_perm_userpermdetail upd ON up.fid = upd.fid ").append("LEFT JOIN t_perm_permitem pit ON pit.fid = upd.fpermitemid ").append("WHERE up.fuserid = ").append(userId).append(" AND up.fdimtype = '").append(dimTypeNum).append("' ").append(" AND up.forgid IN ( ").append((CharSequence)orgIdStr).append(") ").append(" AND upd.fpermitemid = '47150e89000000ac'");
        assignPermInfo = DB.queryDataSet((String)"queryAssignPermInfo", (DBRoute)DBRoute.permission, (String)sb.toString());
        sb.setLength(0);
        sb.append("SELECT fid, fnumber appnum, fseq aseq, fbizcloudid FROM t_meta_bizapp WHERE ftype <> '2' ");
        appInfo = DB.queryDataSet((String)"queryAppInfo", (DBRoute)DBRoute.meta, (String)sb.toString());
        assignPermInfo = assignPermInfo.leftJoin(appInfo).on("fbizappid", "fid").select(new String[]{"fid", "forgid", "fisincludesuborg", "fbizappid", "fentitytypeid", "fpermitemid", "permitemnum"}, new String[]{"appnum", "aseq", "fbizcloudid"}).finish();
        sb.setLength(0);
        sb.append("SELECT fid, fnumber cloudnum, fseq cseq FROM t_meta_bizcloud ");
        cloudInfo = DB.queryDataSet((String)"queryCoudInfo", (DBRoute)DBRoute.meta, (String)sb.toString());
        finalDs = assignPermInfo.leftJoin(cloudInfo).on("fbizcloudid", "fid").select(new String[]{"fid", "forgid", "fisincludesuborg", "fbizcloudid", "fbizappid", "fentitytypeid", "fpermitemid", "permitemnum", "appnum", "aseq"}, new String[]{"cloudnum", "cseq"}).finish().orderBy(new String[]{"forgid"});
        HashSet<String> cloudNumSet = new HashSet<String>(16);
        HashSet<String> appNumSet = new HashSet<String>(16);
        HashSet<String> entityNumSet = new HashSet<String>(16);
        while (finalDs.hasNext()) {
            Row row = finalDs.next();
            String cloudNum = row.getString("cloudnum");
            String bizAppNum = row.getString("appnum");
            String entityNum = row.getString("fentitytypeid");
            if (entityNumSet.contains(entityNum)) continue;
            cloudNumSet.add(cloudNum);
            appNumSet.add(bizAppNum);
            entityNumSet.add(entityNum);
        }
        cloudNumSet.addAll(appNumSet);
        cloudNumSet.addAll(entityNumSet);
        QFilter numberFilter = new QFilter("number", "in", cloudNumSet);
        QFilter statusFilter = new QFilter("status", "=", (Object)StatusEnum.CHECKED.getValue());
        QFilter enableFilter = new QFilter("enable", "=", (Object)EnableEnum.ENABLE.getValue());
        DynamicObject[] originalDocLibArrays = BusinessDataServiceHelper.load((String)"pmdc_originaldoclibdir", (String)"id, name, number, parent, billtype", (QFilter[])new QFilter[]{numberFilter, statusFilter, enableFilter});
        return Arrays.stream(originalDocLibArrays).collect(Collectors.toList());
    }
}

