/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmdc.business.doclib;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmgt.pmdc.business.doclib.SingleFormDocItemHelper;

public class DocItemService {
    public void updateDocItem(List<DynamicObject> docDirectories) {
        ArrayList<DynamicObject> docItems = new ArrayList<DynamicObject>();
        for (DynamicObject originalDirectory : docDirectories) {
            String formId = originalDirectory.getString("number");
            MainEntityType dt = EntityMetadataCache.getDataEntityType((String)formId);
            QFilter sourceBillFilter = new QFilter("sourcebill", "=", (Object)formId);
            DynamicObject[] excludeDocItems = BusinessDataServiceHelper.load((String)"pmdc_docitem", (String)"id, billdataid", (QFilter[])new QFilter[]{sourceBillFilter});
            Set<Long> excludeBillIds = Arrays.stream(excludeDocItems).map(it -> it.getLong("billdataid")).collect(Collectors.toSet());
            docItems.addAll(new SingleFormDocItemHelper(originalDirectory, (DynamicObjectType)dt, excludeBillIds).getDocItems());
            for (DynamicObject docItem : docItems) {
                docItem.set("group", originalDirectory.getPkValue());
            }
        }
        SaveServiceHelper.save((DynamicObject[])docItems.toArray(new DynamicObject[0]));
    }
}

