/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmdc.business.doclib;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.property.AttachmentProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.OrgProp;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentDto;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.attachment.AttachmentFieldServiceHelper;
import kd.pmgt.pmbs.common.enums.EnableEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;

public class SingleFormDocItemHelper {
    private static final Log logger = LogFactory.getLog(SingleFormDocItemHelper.class);
    DynamicObjectType dt;
    Set<Long> excludeBillIds;
    DynamicObject bill;
    DynamicObject originalDocDir;
    String orgField;
    String projectField;
    String billStatusField;
    String billNoField;
    String billNameField;
    AttachmentFieldInfo attachmentFieldInfo = new AttachmentFieldInfo();
    List<DynamicObject> result = new ArrayList<DynamicObject>();

    public SingleFormDocItemHelper(DynamicObject originalDocDir, DynamicObjectType dt, Set<Long> excludeBillIds) {
        this.dt = dt;
        this.excludeBillIds = excludeBillIds;
        this.originalDocDir = originalDocDir;
    }

    public List<DynamicObject> getDocItems() {
        String alias = this.dt.getAlias();
        if (StringUtils.isEmpty((CharSequence)alias)) {
            return this.result;
        }
        this.findFieldSymbol();
        MainEntityType docItemDt = EntityMetadataCache.getDataEntityType((String)"pmdc_docitem");
        this.getDocItemOnAttachmentPanel(docItemDt);
        QFilter qFilter = this.getBillFilter();
        QFilter excludeQFilter = new QFilter("id", "not in", this.excludeBillIds);
        DynamicObject[] ids = BusinessDataServiceHelper.load((String)this.dt.getName(), (String)"id", (QFilter[])new QFilter[]{qFilter, excludeQFilter});
        DynamicObject[] businessData = BusinessDataServiceHelper.load((Object[])Arrays.stream(ids).map(DataEntityBase::getPkValue).toArray(), (DynamicObjectType)this.dt);
        this.findDocItemTargetField();
        DynamicObject[] dynamicObjectArray = businessData;
        int n = dynamicObjectArray.length;
        for (int i = 0; i < n; ++i) {
            DynamicObject data;
            this.bill = data = dynamicObjectArray[i];
            this.getDocItemOnAttachmentField(docItemDt);
        }
        return this.result;
    }

    private QFilter getBillFilter() {
        QFilter qFilter;
        String filterData = this.originalDocDir.getString("filterdata");
        if (StringUtils.isNotEmpty((CharSequence)filterData)) {
            FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterData, FilterCondition.class);
            FilterBuilder filterBuilder = new FilterBuilder(EntityMetadataCache.getDataEntityType((String)this.dt.getName()), filterCondition);
            filterBuilder.buildFilter();
            qFilter = filterBuilder.getQFilter();
        } else {
            if (StringUtils.isEmpty((CharSequence)this.billStatusField)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u65e0\u6cd5\u83b7\u53d6%s\u7684\u72b6\u6001\u5b57\u6bb5\uff0c\u8bf7\u5728\u539f\u59cb\u5e93\u76ee\u5f55\u4e2d\u8bbe\u7f6e\u8be5\u5355\u636e\u7684\u5b57\u6bb5\u914d\u7f6e\u3002", (String)"SingleFormDocItemHelper_0", (String)"pmgt-pmdc-business", (Object[])new Object[0]), this.dt.getName()));
            }
            qFilter = new QFilter(this.billStatusField, "=", (Object)StatusEnum.CHECKED.getValue());
        }
        if (qFilter == null) {
            qFilter = new QFilter(this.billStatusField, "=", (Object)StatusEnum.CHECKED.getValue());
        }
        return qFilter;
    }

    private void findFieldSymbol() {
        this.billNoField = this.originalDocDir.getString("billnofield");
        this.billNameField = this.originalDocDir.getString("billnamefield");
        this.billStatusField = this.getBillStatusField();
        if (StringUtils.isEmpty((CharSequence)this.billNameField)) {
            ArrayList<String> nameFields = new ArrayList<String>(){};
            nameFields.add("name");
            nameFields.add("billname");
            this.billNameField = nameFields.stream().filter(it -> this.dt.getProperties().stream().map(IMetadata::getName).collect(Collectors.toSet()).contains(it)).findFirst().orElse(null);
        }
        if (StringUtils.isEmpty((CharSequence)this.billNoField) && this.dt instanceof BillEntityType) {
            this.billNoField = ((BillEntityType)this.dt).getBillNo();
        }
        if (StringUtils.isEmpty((CharSequence)this.billNoField)) {
            this.billNoField = "billno";
        }
        if (this.dt instanceof MainEntityType) {
            this.orgField = ((MainEntityType)this.dt).getMainOrg();
        }
        for (IDataEntityProperty property : this.dt.getProperties()) {
            if (property instanceof OrgProp && StringUtils.isEmpty((CharSequence)this.orgField)) {
                this.orgField = property.getName();
            }
            if (!(property instanceof BasedataProp) || !"bd_project".equals(((BasedataProp)property).getBaseEntityId()) || !StringUtils.isEmpty((CharSequence)this.projectField)) continue;
            this.projectField = property.getName();
        }
    }

    private String getBillStatusField() {
        String billStatus = this.originalDocDir.getString("billstatusfield");
        if (StringUtils.isEmpty((CharSequence)billStatus) && this.dt instanceof BillEntityType) {
            billStatus = ((BillEntityType)this.dt).getBillStatus();
        }
        if (StringUtils.isEmpty((CharSequence)billStatus)) {
            ArrayList<String> statusFields = new ArrayList<String>();
            statusFields.add("status");
            statusFields.add("billstatus");
            billStatus = statusFields.stream().filter(it -> this.dt.getProperties().stream().map(IMetadata::getName).collect(Collectors.toSet()).contains(it)).findFirst().orElse(null);
        }
        return billStatus;
    }

    public void findDocItemTargetField() {
        DataEntityPropertyCollection properties = this.dt.getProperties();
        for (IDataEntityProperty iDataEntityProperty : properties) {
            DynamicProperty property = (DynamicProperty)iDataEntityProperty;
            if (property instanceof EntryProp) {
                this.entryInfo(property);
            }
            if (!(property instanceof AttachmentProp)) continue;
            AttachmentEntryFieldInfo attachmentEntryFieldInfo = new AttachmentEntryFieldInfo();
            attachmentEntryFieldInfo.entry = null;
            attachmentEntryFieldInfo.subEntry = null;
            attachmentEntryFieldInfo.property = property.getName();
            attachmentEntryFieldInfo.attachmentFieldTable = property.getAlias();
            this.attachmentFieldInfo.entryFieldInfo.add(attachmentEntryFieldInfo);
        }
    }

    private void getDocItemOnAttachmentField(MainEntityType SDT) {
        for (AttachmentEntryFieldInfo entryFieldInfo : this.attachmentFieldInfo.entryFieldInfo) {
            if (entryFieldInfo.isBillHeadField()) {
                this.doGetDocItemOnAttachmentField(this.bill.getDynamicObjectCollection(entryFieldInfo.property), SDT);
            }
            if (entryFieldInfo.isEntryField()) {
                for (DynamicObject entry : this.bill.getDynamicObjectCollection(entryFieldInfo.entry)) {
                    this.doGetDocItemOnAttachmentField(entry.getDynamicObjectCollection(entryFieldInfo.property), SDT);
                }
            }
            if (!entryFieldInfo.isSubEntryField()) continue;
            for (DynamicObject entry : this.bill.getDynamicObjectCollection(entryFieldInfo.entry)) {
                for (DynamicObject subEntry : entry.getDynamicObjectCollection(entryFieldInfo.subEntry)) {
                    this.doGetDocItemOnAttachmentField(subEntry.getDynamicObjectCollection(entryFieldInfo.property), SDT);
                }
            }
        }
    }

    private void getDocItemOnAttachmentPanel(MainEntityType SDT) {
        DynamicObject[] billDataArray;
        DynamicObject[] bosAttachments;
        block4: {
            QFilter interIdFilter = new QFilter("finterid", "!=", (Object)" ");
            QFilter excludeBizBillIdFilter = new QFilter("finterid", "not in", this.excludeBillIds.stream().map(String::valueOf).collect(Collectors.toSet()));
            QFilter billTypeFilter = new QFilter("fbilltype", "=", (Object)this.dt.getName());
            bosAttachments = BusinessDataServiceHelper.load((String)"bos_attachment", (String)"id,finterid,fcreatemen", (QFilter[])new QFilter[]{billTypeFilter, interIdFilter, excludeBizBillIdFilter});
            if (bosAttachments == null || bosAttachments.length == 0) {
                return;
            }
            Set billDataId = Arrays.stream(bosAttachments).filter(it -> it.get("finterid") != null).map(it -> Long.parseLong(it.getString("finterid"))).collect(Collectors.toSet());
            QFilter qFilter = this.getBillFilter();
            QFilter idFilter = new QFilter("id", "in", billDataId);
            billDataArray = new DynamicObject[]{};
            try {
                billDataArray = BusinessDataServiceHelper.load((String)this.dt.getName(), (String)String.join((CharSequence)",", this.billNoField, this.projectField, this.orgField, this.billNameField), (QFilter[])new QFilter[]{qFilter, idFilter});
            }
            catch (KDException e) {
                if (!"bos.sQLTableNotExist".equals(e.getErrorCode().getCode())) break block4;
                logger.info("\u5143\u6570\u636e%s\u8868\u4e0d\u5b58\u5728", (Object)this.dt.getName());
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5143\u6570\u636e%s\u8868\u4e0d\u5b58\u5728", (String)"SingleFormDocItemHelper_1", (String)"pmgt-pmdc-business", (Object[])new Object[0]), this.dt.getName()));
            }
        }
        Set passedBillIds = Arrays.stream(billDataArray).map(it -> it.getPkValue().toString()).collect(Collectors.toSet());
        for (DynamicObject bosAttachment : bosAttachments) {
            if (bosAttachment.get("finterid") == null || !passedBillIds.contains(bosAttachment.getString("finterid"))) continue;
            DynamicObject docItem = new DynamicObject((DynamicObjectType)SDT);
            DynamicObject billForBosAttachment = Arrays.stream(billDataArray).filter(it -> it.getPkValue().toString().equals(bosAttachment.getString("finterid"))).findFirst().orElse(null);
            if (billForBosAttachment == null || this.excludeBillIds.contains(Long.parseLong(billForBosAttachment.getPkValue().toString()))) continue;
            this.bill = billForBosAttachment;
            AttachmentDto attachmentInfoByAttPk = AttachmentServiceHelper.getAttachmentInfoByAttPk((Object)bosAttachment.getPkValue());
            this.buildDocItem(attachmentInfoByAttPk, docItem, 1, bosAttachment.get("fcreatemen"));
            this.result.add(docItem);
        }
    }

    private void doGetDocItemOnAttachmentField(DynamicObjectCollection attachmentFieldValue, MainEntityType SDT) {
        for (DynamicObject field : attachmentFieldValue) {
            DynamicObject baseDataId = field.getDynamicObject("fbasedataId");
            long id = baseDataId.getLong("id");
            AttachmentDto attachmentInfoByAttPk = AttachmentFieldServiceHelper.getAttachmentInfoByAttPk((Object)id);
            DynamicObject docItem = new DynamicObject((DynamicObjectType)SDT);
            DynamicObject bdAttachment = BusinessDataServiceHelper.loadSingle((Object)id, (String)"bd_attachment");
            this.buildDocItem(attachmentInfoByAttPk, docItem, 2, bdAttachment.get("creator"));
            this.result.add(docItem);
        }
    }

    private void buildDocItem(AttachmentDto attachmentInfoByAttPk, DynamicObject docItem, int attachmentType, Object createUserId) {
        docItem.set("attachmenttype", (Object)attachmentType);
        docItem.set("doctype", (Object)1);
        docItem.set("status", (Object)StatusEnum.CHECKED.getValue());
        docItem.set("enable", (Object)EnableEnum.ENABLE.getValue());
        docItem.set("relateobject", (Object)0);
        docItem.set("name", (Object)attachmentInfoByAttPk.getFilename());
        docItem.set("number", (Object)attachmentInfoByAttPk.getFilename());
        docItem.set("resourcepath", (Object)attachmentInfoByAttPk.getResourcePath());
        docItem.set("uploadperson", createUserId);
        docItem.set("uploaddate", (Object)attachmentInfoByAttPk.getCreateTime());
        docItem.set("sourcebill", (Object)this.dt.getName());
        docItem.set("billdataid", this.bill.getPkValue());
        String billNo = this.bill.getString(this.billNoField);
        if (StringUtils.isEmpty((CharSequence)billNo) && StringUtils.isNotEmpty((CharSequence)this.billNameField)) {
            billNo = this.bill.getString(this.billNameField);
        }
        docItem.set("sourcebillno", (Object)billNo);
        if (StringUtils.isNotEmpty((CharSequence)this.orgField)) {
            DynamicObject org = this.bill.getDynamicObject(this.orgField);
            docItem.set("useorg", (Object)org);
            docItem.set("createorg", (Object)org);
            docItem.set("org", (Object)org);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.projectField)) {
            docItem.set("project", (Object)this.bill.getDynamicObject(this.projectField));
        }
    }

    private void entryInfo(DynamicProperty property) {
        this.attachmentFieldInfo.formId = this.dt.getName();
        EntryType entryDT = (EntryType)((EntryProp)property).getDynamicCollectionItemPropertyType();
        DataEntityPropertyCollection entryProperties = entryDT.getProperties();
        for (IDataEntityProperty iDataEntityProperty : entryProperties) {
            DynamicProperty entryProperty = (DynamicProperty)iDataEntityProperty;
            if (entryProperty instanceof EntryProp) {
                EntryType subEntryDT = (EntryType)((EntryProp)entryProperty).getDynamicCollectionItemPropertyType();
                DataEntityPropertyCollection subEntryProperties = subEntryDT.getProperties();
                for (IDataEntityProperty dataEntityProperty : subEntryProperties) {
                    DynamicProperty subEntryProperty = (DynamicProperty)dataEntityProperty;
                    if (!(subEntryProperty instanceof AttachmentProp)) continue;
                    AttachmentEntryFieldInfo attachmentEntryFieldInfo = new AttachmentEntryFieldInfo();
                    attachmentEntryFieldInfo.entry = property.getName();
                    attachmentEntryFieldInfo.subEntry = subEntryDT.getName();
                    attachmentEntryFieldInfo.property = subEntryProperty.getName();
                    attachmentEntryFieldInfo.attachmentFieldTable = property.getAlias();
                    this.attachmentFieldInfo.entryFieldInfo.add(attachmentEntryFieldInfo);
                }
                continue;
            }
            if (!(entryProperty instanceof AttachmentProp)) continue;
            AttachmentEntryFieldInfo attachmentEntryFieldInfo = new AttachmentEntryFieldInfo();
            attachmentEntryFieldInfo.entry = property.getName();
            attachmentEntryFieldInfo.subEntry = null;
            attachmentEntryFieldInfo.property = entryProperty.getName();
            attachmentEntryFieldInfo.attachmentFieldTable = property.getAlias();
            this.attachmentFieldInfo.entryFieldInfo.add(attachmentEntryFieldInfo);
        }
    }

    static class AttachmentEntryFieldInfo {
        public String entry;
        public String subEntry;
        public String property;
        public String attachmentFieldTable;

        AttachmentEntryFieldInfo() {
        }

        public boolean isBillHeadField() {
            return StringUtils.isEmpty((CharSequence)this.entry);
        }

        public boolean isEntryField() {
            return StringUtils.isNotEmpty((CharSequence)this.entry) && StringUtils.isEmpty((CharSequence)this.subEntry);
        }

        public boolean isSubEntryField() {
            return StringUtils.isNotEmpty((CharSequence)this.subEntry);
        }
    }

    static class AttachmentFieldInfo {
        public String formId;
        public List<AttachmentEntryFieldInfo> entryFieldInfo = new ArrayList<AttachmentEntryFieldInfo>();

        AttachmentFieldInfo() {
        }
    }
}

