/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmfs.common.utils.poi;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.pmgt.pmbs.common.utils.poi.POIHelper;
import kd.pmgt.pmfs.common.utils.vo.ExcelPropertiesVO;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.DVConstraint;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import org.apache.poi.hssf.usermodel.HSSFComment;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFDataValidation;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFPatriarch;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.OfficeXmlFileException;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddressList;

public class PmfsPOIHelper
extends POIHelper {
    private static final Log logger = LogFactory.getLog(PmfsPOIHelper.class);

    public static String exportExcel(String fileName, String sheetName, String[] header, String[] columnKey, List<String> mustFillColumn, List<ExcelPropertiesVO> tipVOList, JSONArray data) {
        Cell nameCell;
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet(sheetName);
        HSSFRow columnKeyHashRow = sheet.createRow(0);
        columnKeyHashRow.setHeight((short)0);
        Cell columnKeyHashCell = columnKeyHashRow.createCell(0);
        HSSFCellStyle columnKeyHashCellCss = wb.createCellStyle();
        HSSFDataFormat columnKeyHashCellFormat = wb.createDataFormat();
        columnKeyHashCellCss.setDataFormat(columnKeyHashCellFormat.getFormat("@"));
        columnKeyHashCell.setCellStyle((CellStyle)columnKeyHashCellCss);
        columnKeyHashCell.setCellValue(PmfsPOIHelper.stringArrayToHash((String[])columnKey));
        HSSFRow columnKeyRow = sheet.createRow(1);
        columnKeyRow.setHeight((short)0);
        HSSFRow nameRow = sheet.createRow(2);
        PmfsPOIHelper.setExcelTip(sheet, tipVOList);
        HSSFCellStyle titleCellStyle = wb.createCellStyle();
        titleCellStyle.setAlignment(HorizontalAlignment.CENTER);
        titleCellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        titleCellStyle.setBorderTop(BorderStyle.THIN);
        titleCellStyle.setBorderLeft(BorderStyle.THIN);
        titleCellStyle.setBorderRight(BorderStyle.THIN);
        titleCellStyle.setBorderBottom(BorderStyle.THIN);
        titleCellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        titleCellStyle.setFillForegroundColor(IndexedColors.PALE_BLUE.getIndex());
        for (int i = 0; i < header.length; ++i) {
            sheet.setColumnWidth(i, header[i].getBytes(StandardCharsets.UTF_8).length * 2 * 256);
            Cell columnKeyCell = columnKeyRow.createCell(i);
            columnKeyCell.setCellValue(columnKey[i]);
            columnKeyCell.setCellStyle((CellStyle)titleCellStyle);
            nameCell = nameRow.createCell(i);
            if (mustFillColumn != null && mustFillColumn.contains(header[i])) {
                HSSFCellStyle mustFillColumnStyle = wb.createCellStyle();
                mustFillColumnStyle.setAlignment(HorizontalAlignment.CENTER);
                mustFillColumnStyle.setVerticalAlignment(VerticalAlignment.CENTER);
                mustFillColumnStyle.setBorderTop(BorderStyle.THIN);
                mustFillColumnStyle.setBorderLeft(BorderStyle.THIN);
                mustFillColumnStyle.setBorderRight(BorderStyle.THIN);
                mustFillColumnStyle.setBorderBottom(BorderStyle.THIN);
                mustFillColumnStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                mustFillColumnStyle.setFillForegroundColor(IndexedColors.PALE_BLUE.getIndex());
                HSSFFont mheadFont = wb.createFont();
                mheadFont.setColor(IndexedColors.RED.getIndex());
                mustFillColumnStyle.setFont((Font)mheadFont);
                nameCell.setCellValue(header[i] + "*");
                nameCell.setCellStyle((CellStyle)mustFillColumnStyle);
            } else {
                nameCell.setCellValue(header[i]);
                nameCell.setCellStyle((CellStyle)titleCellStyle);
            }
            if (!header[i].equals(ResManager.loadKDString((String)"WBS\u540d\u79f0", (String)"PmfsPOIHelper_4", (String)"pmgt-pmfs-common", (Object[])new Object[0]))) continue;
            HSSFPatriarch patr = sheet.createDrawingPatriarch();
            HSSFComment comment = patr.createCellComment((ClientAnchor)new HSSFClientAnchor(0, 0, 0, 0, 4, 2, 5, 5));
            comment.setString((RichTextString)new HSSFRichTextString(ResManager.loadKDString((String)"\u540d\u79f0\u4e0d\u53ef\u91cd\u590d\u3002", (String)"PmfsPOIHelper_7", (String)"pmgt-pmfs-common", (Object[])new Object[0])));
            nameCell.setCellComment((Comment)comment);
            comment.setVisible(false);
        }
        HSSFCellStyle cellStyle = wb.createCellStyle();
        cellStyle.setBorderTop(BorderStyle.THIN);
        cellStyle.setBorderLeft(BorderStyle.THIN);
        cellStyle.setBorderRight(BorderStyle.THIN);
        cellStyle.setBorderBottom(BorderStyle.THIN);
        if (data != null && !data.isEmpty()) {
            for (int i = 0; i < data.size(); ++i) {
                JSONObject jsonObject = data.getJSONObject(i);
                nameRow = sheet.createRow(i + 3);
                for (int j = 0; j < columnKey.length; ++j) {
                    nameCell = nameRow.createCell(j);
                    nameCell.setCellValue(jsonObject.get((Object)columnKey[j]) == null ? null : jsonObject.get((Object)columnKey[j]).toString());
                    nameCell.setCellStyle((CellStyle)cellStyle);
                }
            }
        }
        fileName = StringUtils.isBlank((CharSequence)fileName) ? System.currentTimeMillis() + ".xls" : fileName + ".xls";
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            wb.write((OutputStream)os);
        }
        catch (IOException e) {
            logger.error((Throwable)e);
        }
        byte[] content = os.toByteArray();
        ByteArrayInputStream in = new ByteArrayInputStream(content);
        String url = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName, (InputStream)in, 5000);
        if (wb != null) {
            try {
                wb.close();
            }
            catch (IOException e) {
                logger.error((Throwable)e);
            }
        }
        return url;
    }

    public static void setExcelTip(HSSFSheet sheet, List<ExcelPropertiesVO> propertiesVOList) {
        for (ExcelPropertiesVO propertiesVO : propertiesVOList) {
            CellRangeAddressList addressList = new CellRangeAddressList(propertiesVO.getRow(), propertiesVO.getLastRow(), propertiesVO.getCol(), propertiesVO.getLastCol());
            DVConstraint dvConstraint = DVConstraint.createCustomFormulaConstraint((String)"BB1");
            if (null != propertiesVO.getDATA_LIST() && propertiesVO.getDATA_LIST().length > 0) {
                dvConstraint = DVConstraint.createExplicitListConstraint((String[])propertiesVO.getDATA_LIST());
            }
            HSSFDataValidation dataValidation = new HSSFDataValidation(addressList, (DataValidationConstraint)dvConstraint);
            dataValidation.createErrorBox(ResManager.loadKDString((String)"\u9519\u8bef\u63d0\u793a", (String)"PmfsPOIHelper_0", (String)"pmgt-pmfs-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8f93\u5165\u7684\u683c\u5f0f\u4e0d\u7b26\u5408\u89c4\u8303\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"PmfsPOIHelper_8", (String)"pmgt-pmfs-common", (Object[])new Object[0]));
            dataValidation.setSuppressDropDownArrow(false);
            if (propertiesVO.getTip() != null) {
                dataValidation.createPromptBox(ResManager.loadKDString((String)"\u8f93\u5165\u63d0\u793a", (String)"PmfsPOIHelper_2", (String)"pmgt-pmfs-common", (Object[])new Object[0]), propertiesVO.getTip());
            }
            dataValidation.setShowPromptBox(true);
            sheet.addValidationData((DataValidation)dataValidation);
        }
    }

    public static JSONArray importExcel(String url, String coulmnHashCode) {
        JSONArray jsonArray = new JSONArray();
        if (StringUtils.isNotBlank((CharSequence)url)) {
            TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
            InputStream in = cache.getInputStream(url);
            try {
                POIFSFileSystem fs = new POIFSFileSystem(in);
                HSSFWorkbook wb = new HSSFWorkbook(fs);
                HSSFSheet sheet = wb.getSheetAt(0);
                int rowNum = sheet.getLastRowNum();
                HSSFRow columnKeyRow = sheet.getRow(1);
                HSSFRow headerRow = sheet.getRow(2);
                HSSFRow columnKeyHashRow = sheet.getRow(0);
                columnKeyHashRow.getCell(0).setCellType(CellType.STRING);
                String columnKeyHashCellValue = columnKeyHashRow.getCell(0).getStringCellValue();
                if (!StringUtils.equals((CharSequence)columnKeyHashCellValue, (CharSequence)coulmnHashCode)) {
                    return jsonArray;
                }
                int columnNum = columnKeyRow.getLastCellNum();
                for (int j = 3; j <= rowNum; ++j) {
                    JSONArray jsonRow = new JSONArray();
                    HSSFRow iRow = sheet.getRow(j);
                    if (iRow == null) continue;
                    for (int i = 0; i < columnNum; ++i) {
                        JSONObject jsonObject = new JSONObject();
                        HSSFCell columnKeyRowCell = columnKeyRow.getCell(i);
                        HSSFCell headRowCell = headerRow.getCell(i);
                        columnKeyRowCell.setCellType(CellType.STRING);
                        headRowCell.setCellType(CellType.STRING);
                        jsonObject.put("columnKey", (Object)columnKeyRowCell.getStringCellValue());
                        jsonObject.put("columnName", (Object)headRowCell.getStringCellValue());
                        HSSFCell cell = iRow.getCell(i);
                        if (cell != null) {
                            if (cell.getCellType() == CellType.NUMERIC) {
                                cell.setCellType(CellType.NUMERIC);
                                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                                    jsonObject.put("cellValue", (Object)cell.getDateCellValue());
                                } else {
                                    jsonObject.put("cellValue", (Object)cell.getNumericCellValue());
                                }
                            } else {
                                cell.setCellType(CellType.STRING);
                                jsonObject.put("cellValue", (Object)cell.getStringCellValue());
                            }
                        } else {
                            jsonObject.put("cellValue", null);
                        }
                        jsonRow.add((Object)jsonObject);
                    }
                    jsonArray.add((Object)jsonRow);
                }
            }
            catch (OfficeXmlFileException e) {
                logger.error((Throwable)e);
                throw new KDBizException(ResManager.loadKDString((String)"\u6a21\u677f\u4e0d\u6b63\u786e\uff0c\u8bf7\u4e0b\u8f7d\u6b63\u786e\u6a21\u677f\u5bfc\u5165\u3002", (String)"PmfsPOIHelper_3", (String)"pmgt-pmfs-common", (Object[])new Object[0]));
            }
            catch (IOException e) {
                logger.error((Throwable)e);
            }
        }
        return jsonArray;
    }
}

