/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmfs.opplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmgt.pmbs.common.enums.ConclusionEnum;
import kd.pmgt.pmbs.common.enums.IndexWarnLightEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;

public class FeasReportOp
extends AbstractOperationServicePlugIn {
    private static final String PERCENT = "100";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("project");
        e.getFieldKeys().add("billno");
        e.getFieldKeys().add("fsresult");
        e.getFieldKeys().add("billstatus");
        e.getFieldKeys().add("reportperson");
        e.getFieldKeys().add("reportdate");
        e.getFieldKeys().add("reportorg");
        e.getFieldKeys().add("approvalresult");
        e.getFieldKeys().add("tasknumbers");
        e.getFieldKeys().add("resultnumbers");
        e.getFieldKeys().add("outestimate");
        e.getFieldKeys().add("inestimate");
        e.getFieldKeys().add("org");
        e.getFieldKeys().add("desc");
        e.getFieldKeys().add("declarevalue");
        e.getFieldKeys().add("standardindex");
        e.getFieldKeys().add("indexwarnlight");
        e.getFieldKeys().add("tecdesc");
        e.getFieldKeys().add("marketdesc");
        e.getFieldKeys().add("financedesc");
        e.getFieldKeys().add("lawdesc");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator(new AbstractValidator(){

            public void validate() {
                String operateKey = this.getOperateKey();
                ExtendedDataEntity[] dataEntities = this.getDataEntities();
                switch (operateKey) {
                    case "unaudit": {
                        this.validateUnAudit(dataEntities);
                    }
                }
            }

            private void validateUnAudit(ExtendedDataEntity[] dataEntities) {
                block0: for (ExtendedDataEntity dataEntity : dataEntities) {
                    DynamicObject[] projectEvaluations;
                    DynamicObject feasReport = dataEntity.getDataEntity();
                    QFilter proFilter = new QFilter("project", "=", feasReport.getDynamicObject("project").getPkValue());
                    for (DynamicObject projectEvaluation : projectEvaluations = BusinessDataServiceHelper.load((String)"pmsc_projectevaluation", (String)"reportdeclare", (QFilter[])new QFilter[]{proFilter})) {
                        for (DynamicObject index : projectEvaluation.getDynamicObjectCollection("indexentry")) {
                            if (index.getBigDecimal("reportdeclare").compareTo(BigDecimal.ZERO) == 0) continue;
                            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8003\u91cf\u6307\u6807\u7684\u7533\u62a5\u503c\u88ab\u9879\u76ee\u540e\u8bc4\u4ef7\u5355\u636e\u4f7f\u7528\uff0c\u5b58\u5728\u4e0b\u6e38\u5355\u636e\uff0c\u65e0\u6cd5\u53cd\u5ba1\u6838\u3002", (String)"FeasReportOp_11", (String)"pmgt-pmfs-opplugin", (Object[])new Object[0]));
                            continue block0;
                        }
                    }
                }
            }
        });
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        String operationKey = e.getOperationKey();
        DynamicObject[] dataEntities = e.getDataEntities();
        if (StringUtils.equals((CharSequence)operationKey, (CharSequence)"submit")) {
            this.submit(dataEntities);
        } else if (StringUtils.equals((CharSequence)operationKey, (CharSequence)"unsubmit")) {
            this.unSumbit(dataEntities);
        } else if (StringUtils.equals((CharSequence)operationKey, (CharSequence)"audit")) {
            this.audit(dataEntities);
        } else if (StringUtils.equals((CharSequence)operationKey, (CharSequence)"nopass")) {
            for (DynamicObject bill : dataEntities) {
                bill.set("fsresult", (Object)ConclusionEnum.FAILED_S);
                bill.set("billstatus", (Object)StatusEnum.CHECKED.getValue());
            }
            SaveServiceHelper.save((DynamicObject[])dataEntities);
        } else if (StringUtils.equals((CharSequence)operationKey, (CharSequence)"unaudit")) {
            for (DynamicObject bill : dataEntities) {
                this.clearIndexWarnLight(bill);
            }
        }
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        String operationKey = e.getOperationKey();
        DynamicObject[] dataEntities = e.getDataEntities();
        if (StringUtils.equals((CharSequence)operationKey, (CharSequence)"unaudit")) {
            this.unAudit(e, dataEntities);
        }
    }

    private void unAudit(BeforeOperationArgs e, DynamicObject[] dataEntities) {
        ArrayList<DynamicObject> bills = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> deleteReports = new ArrayList<DynamicObject>();
        for (DynamicObject bill : dataEntities) {
            DynamicObject[] delereports;
            QFilter isnewfilter;
            String number = bill.getString("billno");
            DynamicObject project = bill.getDynamicObject("project");
            if (null == project) continue;
            project = BusinessDataServiceHelper.loadSingle((Object)project.getPkValue(), (String)"bd_project", (String)"id,number,name,status,creator,modifier,enable,createtime,modifytime,masterid,longnumber,level,fullname,isleaf,parent,createorg,org,useorg,ctrlstrategy,group,planbegindate,planenddate,prostatus,proaddress");
            QFilter idfilter = new QFilter("billid", "=", (Object)bill.getPkValue().toString());
            DynamicObject[] newReports = BusinessDataServiceHelper.load((String)"pmfs_newreportbill", (String)"id", (QFilter[])new QFilter[]{idfilter, isnewfilter = new QFilter("isnew", "=", (Object)Boolean.FALSE)});
            if (null != newReports && newReports.length > 0) {
                e.setCancel(true);
                e.setCancelMessage(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\uff1a%1$s\u3002\u9879\u76ee\uff1a%2$s\u3002\u5df2\u7531\u4e0a\u7ea7\u7ec4\u7ec7\u5ba1\u6279\uff0c\u8bf7\u52ff\u53cd\u5ba1\u6279\u3002", (String)"FeasReportOp_12", (String)"pmgt-pmfs-opplugin", (Object[])new Object[0]), number, project.getString("name")));
                return;
            }
            String fsresult = bill.getString("fsresult");
            if (!StringUtils.equals((CharSequence)fsresult, (CharSequence)ConclusionEnum.REPORT_S.getValue())) continue;
            bill.set("approvalresult", null);
            bills.add(bill);
            QFilter isturefilter = new QFilter("isnew", "=", (Object)Boolean.TRUE);
            for (DynamicObject report : delereports = BusinessDataServiceHelper.load((String)"pmfs_newreportbill", (String)"id", (QFilter[])new QFilter[]{idfilter, isturefilter})) {
                deleteReports.add(report);
            }
        }
        SaveServiceHelper.save((DynamicObject[])bills.toArray(new DynamicObject[bills.size()]));
        DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"pmfs_newreportbill"), (Object[])deleteReports.toArray());
    }

    private void submit(DynamicObject[] dataEntities) {
        for (DynamicObject bill : dataEntities) {
            DynamicObjectCollection indexEntry = bill.getDynamicObjectCollection("indexentry");
            for (DynamicObject index : indexEntry) {
                BigDecimal declareValue = index.getBigDecimal("declarevalue");
                BigDecimal standardIndex = index.getBigDecimal("standardindex");
                if (declareValue.compareTo(BigDecimal.ZERO) == 0 || standardIndex.compareTo(BigDecimal.ZERO) == 0) {
                    index.set("indexwarnlight", null);
                    continue;
                }
                if (declareValue.compareTo(standardIndex) >= 0) {
                    index.set("indexwarnlight", (Object)IndexWarnLightEnum.PASS.getValue());
                    continue;
                }
                index.set("indexwarnlight", (Object)IndexWarnLightEnum.NO_PASS.getValue());
            }
        }
    }

    private void unSumbit(DynamicObject[] dataEntities) {
        for (DynamicObject bill : dataEntities) {
            this.clearIndexWarnLight(bill);
        }
    }

    private void audit(DynamicObject[] dataEntities) {
        for (DynamicObject bill : dataEntities) {
            String fsresult;
            DynamicObject project = bill.getDynamicObject("project");
            if (null == project || !StringUtils.equals((CharSequence)(fsresult = bill.getString("fsresult")), (CharSequence)ConclusionEnum.REPORT_S.getValue())) continue;
            bill.set("approvalresult", (Object)ConclusionEnum.APPROVAL_S.getValue());
            DynamicObject newReport = this.createNewRepoertBill(bill);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newReport});
        }
    }

    private DynamicObject createNewRepoertBill(DynamicObject bill) {
        DynamicObject newReport = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmfs_newreportbill"));
        ORM orm = ORM.create();
        Long id = orm.genLongId("pmfs_newreportbill");
        newReport.set("id", (Object)id);
        newReport.set("source", (Object)id);
        newReport.set("billno", (Object)bill.getString("billno"));
        if (null != bill.getDynamicObject("project")) {
            newReport.set("project", bill.getDynamicObject("project").getPkValue());
        }
        if (null != bill.getDynamicObject("org")) {
            newReport.set("declareorg", bill.getDynamicObject("org").getPkValue());
        }
        if (null != bill.getDynamicObject("reportperson")) {
            newReport.set("reportperson", bill.getDynamicObject("reportperson").getPkValue());
        }
        newReport.set("reportdate", (Object)bill.getDate("reportdate"));
        if (null != bill.getDynamicObject("reportorg")) {
            newReport.set("reportorg", bill.getDynamicObject("reportorg").getPkValue());
        }
        newReport.set("desc", (Object)bill.getString("desc"));
        newReport.set("isnew", (Object)Boolean.TRUE);
        newReport.set("billstatus", (Object)StatusEnum.CHECKED.getValue());
        newReport.set("billid", (Object)bill.getPkValue().toString());
        newReport.set("tasknumbers", bill.get("tasknumbers"));
        newReport.set("resultnumbers", bill.get("resultnumbers"));
        newReport.set("outestimate", bill.get("outestimate"));
        newReport.set("inestimate", bill.get("inestimate"));
        newReport.set("tecdesc", (Object)bill.getString("tecdesc"));
        newReport.set("marketdesc", (Object)bill.getString("marketdesc"));
        newReport.set("financedesc", (Object)bill.getString("financedesc"));
        newReport.set("lawdesc", (Object)bill.getString("lawdesc"));
        return newReport;
    }

    private void clearIndexWarnLight(DynamicObject bill) {
        DynamicObjectCollection indexEntry = bill.getDynamicObjectCollection("indexentry");
        for (DynamicObject index : indexEntry) {
            index.set("indexwarnlight", null);
        }
    }
}

