/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmfs.opplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmbs.common.enums.imageProgressreport.PeriodTypeEnum;
import kd.pmgt.pmbs.common.utils.DateUtil;

public class ImageProgressReportOp
extends AbstractOperationServicePlugIn {
    @Deprecated
    protected static final String AUDIT = "audit";
    @Deprecated
    protected static final String SUBMIT = "submit";
    @Deprecated
    protected static final String UNAUDIT = "unaudit";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("project");
        e.getFieldKeys().add("wbs");
        e.getFieldKeys().add("allinvest");
        e.getFieldKeys().add("allprogress");
        e.getFieldKeys().add("mutiwbs");
        e.getFieldKeys().add("periodinvest");
        e.getFieldKeys().add("periodprogress");
        e.getFieldKeys().add("createtime");
        e.getFieldKeys().add("entryentity");
        e.getFieldKeys().add("entryentity.entryallprogress");
        e.getFieldKeys().add("entryentity.entryallinvest");
        e.getFieldKeys().add("entryentity.entryperiodinvest");
        e.getFieldKeys().add("entryentity.entryperiodprogress");
        e.getFieldKeys().add("entryentity.entrywbs");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        String operateKey;
        super.beginOperationTransaction(e);
        switch (operateKey = e.getOperationKey()) {
            case "audit": 
            case "unaudit": {
                this.sycnToProjectinitialize(e);
                break;
            }
        }
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                String operateKey = this.getOperateKey();
                ExtendedDataEntity[] dataEntities = this.getDataEntities();
                switch (operateKey) {
                    case "unaudit": {
                        this.validateUnAudit(dataEntities);
                        break;
                    }
                    case "submit": {
                        this.validateSubmit(dataEntities);
                        break;
                    }
                }
            }

            protected void validateSubmit(ExtendedDataEntity[] dataEntities) {
                for (ExtendedDataEntity dataEntity : dataEntities) {
                    DynamicObject imageProgress = dataEntity.getDataEntity();
                    Date period = imageProgress.getDate("period");
                    if (period == null) {
                        return;
                    }
                    String billStatus = imageProgress.getString("billstatus");
                    if (StringUtils.equals((CharSequence)billStatus, (CharSequence)StatusEnum.UNCHECKED.getValue()) || StringUtils.equals((CharSequence)billStatus, (CharSequence)StatusEnum.CHECKED.getValue())) {
                        return;
                    }
                    ArrayList<DynamicObject> wbsList = new ArrayList<DynamicObject>();
                    boolean multiWbs = imageProgress.getBoolean("mutiwbs");
                    if (multiWbs) {
                        for (DynamicObject wbsEntry : imageProgress.getDynamicObjectCollection("entryentity")) {
                            DynamicObject wbs = wbsEntry.getDynamicObject("entrywbs");
                            if (wbs == null) continue;
                            wbsList.add(wbs);
                        }
                    } else {
                        DynamicObject wbs = imageProgress.getDynamicObject("wbs");
                        if (wbs != null) {
                            wbsList.add(wbs);
                        }
                    }
                    String periodType = imageProgress.getString("periodtype");
                    QFilter periodFilter = new QFilter("periodtype", "=", (Object)periodType);
                    QFilter billStatusFilter = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
                    block2: for (DynamicObject wbs : wbsList) {
                        DynamicObject[] searchImageProgressArray;
                        QFilter wbsFilter = new QFilter("wbs", "=", wbs.getPkValue()).or("entryentity.entrywbs", "=", wbs.getPkValue());
                        String wbsName = wbs.getString("name");
                        for (DynamicObject searchImageProgress : searchImageProgressArray = BusinessDataServiceHelper.load((String)"pmfs_progressreport", (String)"period", (QFilter[])new QFilter[]{billStatusFilter, wbsFilter, periodFilter})) {
                            Date searchPeriod = searchImageProgress.getDate("period");
                            if (!(PeriodTypeEnum.MONTH.getValue().equals(periodType) && DateUtil.compareByMonth((Date)period, (Date)searchPeriod) == 0 || PeriodTypeEnum.DAY.getValue().equals(periodType) && DateUtil.compareByDay((Date)period, (Date)searchPeriod) == 0) && (!PeriodTypeEnum.HOUR.getValue().equals(periodType) || DateUtil.compareByHour((Date)period, (Date)searchPeriod) != 0)) continue;
                            this.addWarningMessage(dataEntity, String.format(ResManager.loadKDString((String)"%s\uff1a\u672c\u671f\u95f4\u5df2\u6709\u8fdb\u5ea6\u6c47\u62a5\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u518d\u6b21\u6c47\u62a5\u3002", (String)"ImageProgressReportOp_5", (String)"pmgt-pmfs-opplugin", (Object[])new Object[0]), wbsName));
                            continue block2;
                        }
                    }
                }
            }

            private void validateUnAudit(ExtendedDataEntity[] dataEntities) {
                for (ExtendedDataEntity dataEntity : dataEntities) {
                    QFilter auditDateFilter;
                    QFilter statusFilter;
                    DynamicObject imageProgress = dataEntity.getDataEntity();
                    DynamicObject project = imageProgress.getDynamicObject("project");
                    QFilter projectFilter = new QFilter("project", "=", project.getPkValue());
                    DynamicObject[] imageProgressReports = BusinessDataServiceHelper.load((String)"pmfs_progressreport", (String)"billno", (QFilter[])new QFilter[]{projectFilter, statusFilter = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue()), auditDateFilter = new QFilter("auditdate", ">", (Object)imageProgress.getDate("auditdate"))});
                    if (imageProgressReports != null && imageProgressReports.length > 0) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u53cd\u5ba1\u6838\u5931\u8d25\u3002\u9879\u76ee\u201c%s\u201d\u5df2\u6709\u65b0\u7684\u5f62\u8c61\u8fdb\u5ea6\u6c47\u62a5\u8bb0\u5f55\uff0c\u65e0\u6cd5\u53cd\u5ba1\u6838\u3002", (String)"ImageProgressReportOp_6", (String)"pmgt-pmfs-opplugin", (Object[])new Object[0]), imageProgress.getString("billno")));
                        break;
                    }
                    this.currentProgressChanged(dataEntity);
                }
            }

            protected void currentProgressChanged(ExtendedDataEntity dataEntity) {
                DynamicObject imageProgressReport = dataEntity.getDataEntity();
                boolean multiWbs = imageProgressReport.getBoolean("mutiwbs");
                if (multiWbs) {
                    DynamicObjectCollection wbsEntries = imageProgressReport.getDynamicObjectCollection("entryentity");
                    StringBuilder errorMsg = new StringBuilder();
                    for (DynamicObject wbsEntry : wbsEntries) {
                        DynamicObject wbs = wbsEntry.getDynamicObject("entrywbs");
                        if (wbs == null) continue;
                        BigDecimal allProgress = wbsEntry.getBigDecimal("entryallprogress");
                        int compareResult = wbs.getBigDecimal("schedule").compareTo(allProgress);
                        if (compareResult == 0) continue;
                        errorMsg.append(String.format(ResManager.loadKDString((String)"\u53cd\u5ba1\u6838\u5931\u8d25\uff0cWBS\u201c%s\u201d\u5b8c\u6210\u8fdb\u5ea6\u5df2\u88ab\u5176\u4ed6\u5355\u636e\u66f4\u65b0\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"ImageProgressReportOp_7", (String)"pmgt-pmfs-opplugin", (Object[])new Object[0]), wbs.getString("name")));
                        errorMsg.append("\n");
                        wbsEntry.set("entrywbs", null);
                    }
                    if (StringUtils.isNotEmpty((CharSequence)errorMsg.toString())) {
                        this.addErrorMessage(dataEntity, errorMsg.toString());
                    }
                } else {
                    DynamicObject wbs = imageProgressReport.getDynamicObject("wbs");
                    if (wbs == null) {
                        return;
                    }
                    BigDecimal allProgress = imageProgressReport.getBigDecimal("allprogress");
                    int compareResult = wbs.getBigDecimal("schedule").compareTo(allProgress);
                    if (compareResult != 0) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u53cd\u5ba1\u6838\u5931\u8d25\uff0cWBS\u201c%s\u201d\u5b8c\u6210\u8fdb\u5ea6\u5df2\u88ab\u5176\u4ed6\u5355\u636e\u66f4\u65b0\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"ImageProgressReportOp_7", (String)"pmgt-pmfs-opplugin", (Object[])new Object[0]), wbs.getString("name")));
                    }
                }
            }
        });
    }

    private void sycnToProjectinitialize(BeginOperationTransactionArgs e) {
        String operateKey = e.getOperationKey();
        DynamicObject[] dynamicObjects = e.getDataEntities();
        ArrayList<DynamicObject> splitList = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> wbsList = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> proStageList = new ArrayList<DynamicObject>();
        for (DynamicObject progressReport : dynamicObjects) {
            boolean multiWbs = progressReport.getBoolean("mutiwbs");
            if (multiWbs) {
                DynamicObjectCollection wbsEntries = progressReport.getDynamicObjectCollection("entryentity");
                for (DynamicObject wbsEntry : wbsEntries) {
                    this.reverseWritingData(true, wbsEntry, splitList, wbsList, proStageList, operateKey);
                }
            } else {
                this.reverseWritingData(false, progressReport, splitList, wbsList, proStageList, operateKey);
            }
            if (!splitList.isEmpty()) {
                SaveServiceHelper.update((DynamicObject[])splitList.toArray(new DynamicObject[0]));
            }
            if (!wbsList.isEmpty()) {
                SaveServiceHelper.update((DynamicObject[])wbsList.toArray(new DynamicObject[0]));
            }
            if (proStageList.isEmpty()) continue;
            SaveServiceHelper.update((DynamicObject[])proStageList.toArray(new DynamicObject[0]));
        }
    }

    private void reverseWritingData(boolean multiWbs, DynamicObject entry, List<DynamicObject> splitList, List<DynamicObject> wbsList, List<DynamicObject> proStageList, String operateKey) {
        DynamicObject wbsBaseData;
        BigDecimal periodProgress;
        BigDecimal periodInvest;
        BigDecimal allProgress;
        BigDecimal allInvest;
        DynamicObject wbs;
        if (multiWbs) {
            wbs = entry.getDynamicObject("entrywbs");
            allInvest = entry.getBigDecimal("entryallinvest");
            allProgress = entry.getBigDecimal("entryallprogress");
            periodInvest = entry.getBigDecimal("entryperiodinvest");
            periodProgress = entry.getBigDecimal("entryperiodprogress");
        } else {
            wbs = entry.getDynamicObject("wbs");
            allInvest = entry.getBigDecimal("allinvest");
            allProgress = entry.getBigDecimal("allprogress");
            periodInvest = entry.getBigDecimal("periodinvest");
            periodProgress = entry.getBigDecimal("periodprogress");
        }
        if (wbs == null) {
            return;
        }
        Object wbsPK = wbs.getPkValue();
        DynamicObject split = this.findSplit(wbs = BusinessDataServiceHelper.loadSingle((Object)wbs.getPkValue(), (String)"pmbs_wbs"));
        if (split != null) {
            DynamicObject proStatus = split.getDynamicObject("splitentry_projectstatus");
            if (AUDIT.equals(operateKey)) {
                split.set("splitentry_completeamt", (Object)allInvest);
                split.set("splitentry_schedule", (Object)allProgress);
                if (proStatus != null) {
                    proStatus.set("statuspercent", (Object)allProgress);
                    proStageList.add(proStatus);
                }
            } else if (UNAUDIT.equals(operateKey)) {
                split.set("splitentry_completeamt", (Object)allInvest.subtract(periodInvest));
                split.set("splitentry_schedule", (Object)allProgress.subtract(periodProgress));
                if (proStatus != null) {
                    proStatus.set("statuspercent", (Object)allProgress);
                    proStageList.add(proStatus);
                }
            }
            splitList.add(split);
        }
        if ((wbsBaseData = BusinessDataServiceHelper.loadSingle((Object)wbsPK, (String)"pmbs_wbs")) != null) {
            if (AUDIT.equals(operateKey)) {
                wbsBaseData.set("completeamt", (Object)allInvest);
                wbsBaseData.set("schedule", (Object)allProgress);
            } else if (UNAUDIT.equals(operateKey)) {
                wbsBaseData.set("completeamt", (Object)allInvest.subtract(periodInvest));
                wbsBaseData.set("schedule", (Object)allProgress.subtract(periodProgress));
            }
            wbsList.add(wbsBaseData);
        }
    }

    private DynamicObject findSplit(DynamicObject wbs) {
        long projectPk = (Long)wbs.getDynamicObject("project").getPkValue();
        QFilter projectPkFilter = new QFilter("project", "=", (Object)projectPk);
        QFilter executiveVersionFilter = new QFilter("executiveversion", "=", (Object)Boolean.TRUE);
        DynamicObject[] projectInitializeArray = BusinessDataServiceHelper.load((String)"pmfs_projectinitialize", (String)"id", (QFilter[])new QFilter[]{projectPkFilter, executiveVersionFilter});
        DynamicObject projectInitialize = BusinessDataServiceHelper.loadSingle((Object)projectInitializeArray[0].getPkValue(), (String)"pmfs_projectinitialize");
        return projectInitialize.getDynamicObjectCollection("splitentry").stream().filter(entry -> entry.getLong("resourcewbsid") == ((Long)wbs.getPkValue()).longValue()).findFirst().orElse(null);
    }
}

