/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmfs.opplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmgt.pmbs.common.enums.ConclusionEnum;
import kd.pmgt.pmbs.common.enums.ProjectStatusEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;

public class MajorapprovalOp
extends AbstractOperationServicePlugIn {
    private static final String PERCENT = "100";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("billno");
        e.getFieldKeys().add("org");
        e.getFieldKeys().add("approvalperson");
        e.getFieldKeys().add("approvaldate");
        e.getFieldKeys().add("listmodelentry");
        e.getFieldKeys().add("project");
        e.getFieldKeys().add("reportbill");
        e.getFieldKeys().add("curreportbill");
        e.getFieldKeys().add("subentryentity");
        e.getFieldKeys().add("desc");
        e.getFieldKeys().add("proresult");
        e.getFieldKeys().add("reportorg");
        e.getFieldKeys().add("approvalresult");
        e.getFieldKeys().add("tecdesc");
        e.getFieldKeys().add("marketdesc");
        e.getFieldKeys().add("financedesc");
        e.getFieldKeys().add("lawdesc");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        String operationKey = e.getOperationKey();
        DynamicObject[] dataEntities = e.getDataEntities();
        if (StringUtils.equals((CharSequence)operationKey, (CharSequence)"save") || StringUtils.equals((CharSequence)operationKey, (CharSequence)"submit")) {
            this.saveAndSubmit(e, dataEntities);
        } else if (StringUtils.equals((CharSequence)operationKey, (CharSequence)"audit")) {
            this.audit(e, dataEntities);
        } else if (StringUtils.equals((CharSequence)operationKey, (CharSequence)"unaudit")) {
            this.unaudit(e, dataEntities);
        } else if (StringUtils.equals((CharSequence)operationKey, (CharSequence)"delete")) {
            this.delete(dataEntities);
        }
    }

    private void saveAndSubmit(BeforeOperationArgs e, DynamicObject[] dataEntities) {
        ArrayList<DynamicObject> billList = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> reportbillList = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> curReportList = new ArrayList<DynamicObject>();
        ORM orm = ORM.create();
        long[] ids = orm.genLongIds("pmfs_majorapproval", dataEntities.length);
        int idIndex = 0;
        for (DynamicObject bill : dataEntities) {
            Long billPk = (Long)bill.getPkValue();
            if (billPk == null || billPk == 0L) {
                bill.set("id", (Object)ids[idIndex++]);
            }
            String number = bill.getString("billno");
            DynamicObjectCollection proEntryCol = bill.getDynamicObjectCollection("listmodelentry");
            for (DynamicObject proEntry : proEntryCol) {
                DynamicObject project = proEntry.getDynamicObject("project");
                DynamicObjectCollection subCardCol = proEntry.getDynamicObjectCollection("subentryentity");
                if (null == subCardCol || subCardCol.isEmpty() || null == project) continue;
                DynamicObject subCard = (DynamicObject)subCardCol.get(0);
                DynamicObject reportbill = proEntry.getDynamicObject("reportbill");
                DynamicObject existReportbill = BusinessDataServiceHelper.loadSingle((String)"pmfs_newreportbill", (String)"", (QFilter[])new QFilter[]{new QFilter("id", "=", reportbill.getPkValue())});
                if (existReportbill == null) {
                    e.setCancel(true);
                    e.setCancelMessage(String.format(ResManager.loadKDString((String)"\u672a\u68c0\u7d22\u5230\u9879\u76ee\u201c%s\u201d\u7684\u7533\u62a5\u8bb0\u5f55\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"MajorapprovalOp_17", (String)"pmgt-pmfs-opplugin", (Object[])new Object[0]), project.getString("name")));
                    return;
                }
                if (null == reportbill) continue;
                reportbill = BusinessDataServiceHelper.loadSingle((Object)reportbill.getPkValue(), (String)"pmfs_newreportbill");
                reportbill.set("isnew", (Object)Boolean.FALSE);
                reportbillList.add(reportbill);
                DynamicObject curReportBill = proEntry.getDynamicObject("curreportbill");
                if (null == curReportBill) {
                    QFilter statusfilter;
                    QFilter isnewfilter;
                    QFilter profilter = new QFilter("project", "=", project.getPkValue());
                    DynamicObject[] curReports = BusinessDataServiceHelper.load((String)"pmfs_newreportbill", (String)"id", (QFilter[])new QFilter[]{profilter, isnewfilter = new QFilter("isnew", "=", (Object)Boolean.TRUE), statusfilter = new QFilter("billstatus", "=", (Object)StatusEnum.TEMPSAVE.getValue())});
                    if (null != curReports && curReports.length > 0) {
                        e.setCancel(true);
                        e.setCancelMessage(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\uff1a%1$s\u3002\u9879\u76ee\uff1a%2$s\u3002\u6b63\u5728\u8fdb\u884c\u7533\u62a5\u3002", (String)"MajorapprovalOp_18", (String)"pmgt-pmfs-opplugin", (Object[])new Object[0]), number, project.getString("name")));
                        return;
                    }
                    DynamicObject newReport = this.createNewRepoertBill(bill, proEntry, subCard, reportbill);
                    curReportList.add(newReport);
                    proEntry.set("curreportbill", (Object)newReport);
                    continue;
                }
                curReportBill = BusinessDataServiceHelper.loadSingle((Object)curReportBill.getPkValue(), (String)"pmfs_newreportbill");
                curReportBill.set("billno", (Object)number);
                curReportBill.set("billid", (Object)bill.getPkValue().toString());
                DynamicObject reportorg = subCard.getDynamicObject("reportorg");
                if (null != reportorg) {
                    curReportBill.set("reportorg", (Object)reportorg.getPkValue().toString());
                }
                if (null != bill.getDynamicObject("approvalperson")) {
                    curReportBill.set("reportperson", bill.getDynamicObject("approvalperson").getPkValue());
                }
                curReportBill.set("reportdate", (Object)bill.getDate("approvaldate"));
                curReportBill.set("desc", (Object)subCard.getString("desc"));
                curReportBill.set("tecdesc", (Object)subCard.getString("tecdesc"));
                curReportBill.set("marketdesc", (Object)subCard.getString("marketdesc"));
                curReportBill.set("financedesc", (Object)subCard.getString("financedesc"));
                curReportBill.set("lawdesc", (Object)subCard.getString("lawdesc"));
                curReportList.add(curReportBill);
            }
            billList.add(bill);
        }
        SaveServiceHelper.save((DynamicObject[])billList.toArray(new DynamicObject[billList.size()]));
        SaveServiceHelper.save((DynamicObject[])reportbillList.toArray(new DynamicObject[reportbillList.size()]));
        SaveServiceHelper.save((DynamicObject[])curReportList.toArray(new DynamicObject[curReportList.size()]));
    }

    private void unaudit(BeforeOperationArgs e, DynamicObject[] dataEntities) {
        ArrayList<DynamicObject> billList = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> curReportbillList = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> kyProjectList = new ArrayList<DynamicObject>();
        ArrayList<String> reportList = new ArrayList<String>();
        for (DynamicObject bill : dataEntities) {
            String number = bill.getString("billno");
            DynamicObjectCollection proEntryCollection = bill.getDynamicObjectCollection("listmodelentry");
            for (DynamicObject proEntry : proEntryCollection) {
                DynamicObject reportbill;
                DynamicObject curReportbill;
                QFilter isnewfilter;
                QFilter[] filters;
                DynamicObject[] projectApprovals;
                DynamicObject project = proEntry.getDynamicObject("project");
                if (null == project) continue;
                DynamicObject prostatus = (project = BusinessDataServiceHelper.loadSingle((Object)project.getPkValue(), (String)"bd_project", (String)"id,number,name,status,creator,modifier,enable,createtime,modifytime,masterid,longnumber,level,fullname,isleaf,parent,createorg,org,useorg,ctrlstrategy,group,planbegindate,planenddate,prostatus,proaddress")).getDynamicObject("prostatus");
                if (null != prostatus && StringUtils.equals((CharSequence)prostatus.getString("number"), (CharSequence)ProjectStatusEnum.FINANCIAL_CLOSE.getValue())) {
                    e.setCancel(true);
                    e.setCancelMessage(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\uff1a%1$s\u3002\u9879\u76ee\uff1a%2$s\u3002\u5df2\u8d22\u52a1\u5173\u95ed\uff0c\u8bf7\u52ff\u53cd\u5ba1\u6279\u3002", (String)"MajorapprovalOp_19", (String)"pmgt-pmfs-opplugin", (Object[])new Object[0]), number, project.getString("name")));
                    return;
                }
                if (null != prostatus && StringUtils.equals((CharSequence)prostatus.getString("number"), (CharSequence)ProjectStatusEnum.BUSSINESS_CLOSE.getValue()) && null != (projectApprovals = BusinessDataServiceHelper.load((String)"pmas_pro_approval", (String)"id,prostatus,changereason", (QFilter[])(filters = new QFilter[]{new QFilter("pro", "=", project.getPkValue())}))) && projectApprovals.length > 0 && !StringUtils.equals((CharSequence)projectApprovals[0].getString("changereason"), (CharSequence)"01")) {
                    e.setCancel(true);
                    e.setCancelMessage(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\uff1a%1$s\u3002\u9879\u76ee\uff1a%2$s\u3002\u4e1a\u52a1\u5df2\u5173\u95ed\uff0c\u8bf7\u52ff\u53cd\u5ba1\u6279\u3002", (String)"MajorapprovalOp_20", (String)"pmgt-pmfs-opplugin", (Object[])new Object[0]), number, project.getString("name")));
                    return;
                }
                QFilter idfilter = new QFilter("billid", "=", (Object)bill.getPkValue().toString());
                DynamicObject[] newReports = BusinessDataServiceHelper.load((String)"pmfs_newreportbill", (String)"id", (QFilter[])new QFilter[]{idfilter, isnewfilter = new QFilter("isnew", "=", (Object)Boolean.FALSE)});
                if (null != newReports && newReports.length > 0) {
                    e.setCancel(true);
                    e.setCancelMessage(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\uff1a%1$s\u3002\u9879\u76ee\uff1a%2$s\u3002\u5df2\u7531\u4e0a\u7ea7\u7ec4\u7ec7\u5ba1\u6279\uff0c\u8bf7\u52ff\u53cd\u5ba1\u6279\u3002", (String)"MajorapprovalOp_21", (String)"pmgt-pmfs-opplugin", (Object[])new Object[0]), number, project.getString("name")));
                    return;
                }
                kyProjectList.add(project);
                DynamicObjectCollection subCol = proEntry.getDynamicObjectCollection("subentryentity");
                if (null == subCol || subCol.isEmpty()) continue;
                DynamicObject sub = (DynamicObject)subCol.get(0);
                String proresult = sub.getString("proresult");
                sub.set("approvalresult", null);
                if (StringUtils.equals((CharSequence)proresult, (CharSequence)ConclusionEnum.REPORT_S.getValue()) && null != (curReportbill = proEntry.getDynamicObject("curreportbill"))) {
                    curReportbill = BusinessDataServiceHelper.loadSingle((Object)curReportbill.getPkValue(), (String)"pmfs_newreportbill", (String)"id,billstatus");
                    curReportbill.set("billstatus", (Object)StatusEnum.TEMPSAVE.getValue());
                    curReportbillList.add(curReportbill);
                }
                if (!StringUtils.equals((CharSequence)proresult, (CharSequence)ConclusionEnum.PASS_S.getValue()) && !StringUtils.equals((CharSequence)proresult, (CharSequence)ConclusionEnum.FAILED_S.getValue()) || null == (reportbill = proEntry.getDynamicObject("reportbill"))) continue;
                reportList.add(reportbill.getPkValue().toString());
            }
            billList.add(bill);
        }
        SaveServiceHelper.save((DynamicObject[])curReportbillList.toArray(new DynamicObject[curReportbillList.size()]));
        this.updateReoprt(kyProjectList, ConclusionEnum.REPORT_S.getValue(), reportList);
        SaveServiceHelper.save((DynamicObject[])billList.toArray(new DynamicObject[billList.size()]));
    }

    private void audit(BeforeOperationArgs e, DynamicObject[] dataEntities) {
        ArrayList<DynamicObject> billList = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> curReportbillList = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> passProjectList = new ArrayList<DynamicObject>();
        ArrayList<String> passReportList = new ArrayList<String>();
        ArrayList<DynamicObject> failedProjectList = new ArrayList<DynamicObject>();
        ArrayList<String> failedReportList = new ArrayList<String>();
        for (DynamicObject bill : dataEntities) {
            DynamicObjectCollection proEntryCol = bill.getDynamicObjectCollection("listmodelentry");
            for (DynamicObject proEntry : proEntryCol) {
                DynamicObject reportbill;
                DynamicObject project = proEntry.getDynamicObject("project");
                DynamicObjectCollection subCol = proEntry.getDynamicObjectCollection("subentryentity");
                if (null == subCol || subCol.isEmpty() || null == project) continue;
                DynamicObject subCard = (DynamicObject)subCol.get(0);
                String proresult = subCard.getString("proresult");
                if (null == proresult) {
                    e.setCancel(true);
                    e.setCancelMessage(String.format(ResManager.loadKDString((String)"%s\u9879\u76ee\uff1a\u8bf7\u586b\u5199\u5ba1\u6279\u7ed3\u8bba\uff0c\u5982\u9700\u8981\u4e0a\u62a5\uff0c\u8bf7\u6307\u5b9a\u4e0a\u62a5\u7ec4\u7ec7\u3002", (String)"MajorapprovalOp_22", (String)"pmgt-pmfs-opplugin", (Object[])new Object[0]), project.getString("name")));
                    return;
                }
                if (StringUtils.equals((CharSequence)proresult, (CharSequence)ConclusionEnum.REPORT_S.getValue())) {
                    DynamicObject reportorg = subCard.getDynamicObject("reportorg");
                    if (null == reportorg) {
                        e.setCancel(true);
                        e.setCancelMessage(String.format(ResManager.loadKDString((String)"%s\u9879\u76ee\uff1a\u8bf7\u586b\u5199\u5ba1\u6279\u7ed3\u8bba\uff0c\u5982\u9700\u8981\u4e0a\u62a5\uff0c\u8bf7\u6307\u5b9a\u4e0a\u62a5\u7ec4\u7ec7\u3002", (String)"MajorapprovalOp_22", (String)"pmgt-pmfs-opplugin", (Object[])new Object[0]), project.getString("name")));
                        return;
                    }
                    DynamicObject curReportbill = proEntry.getDynamicObject("curreportbill");
                    if (null != curReportbill) {
                        curReportbill = BusinessDataServiceHelper.loadSingle((Object)curReportbill.getPkValue(), (String)"pmfs_newreportbill", (String)"project, reportperson, reportdate, declareorg, isnew, source, parent, billstatus, billid, billno, reportorg, desc,tasknumbers,resultnumbers, outestimate, inestimate");
                        curReportbill.set("billstatus", (Object)StatusEnum.CHECKED.getValue());
                        curReportbillList.add(curReportbill);
                    }
                    subCard.set("approvalresult", (Object)ConclusionEnum.APPROVAL_S.getValue());
                    continue;
                }
                if (StringUtils.equals((CharSequence)proresult, (CharSequence)ConclusionEnum.PASS_S.getValue())) {
                    passProjectList.add(project);
                    reportbill = proEntry.getDynamicObject("reportbill");
                    if (null == reportbill) continue;
                    passReportList.add(reportbill.getPkValue().toString());
                    continue;
                }
                if (!StringUtils.equals((CharSequence)proresult, (CharSequence)ConclusionEnum.FAILED_S.getValue())) continue;
                failedProjectList.add(project);
                reportbill = proEntry.getDynamicObject("reportbill");
                if (null == reportbill) continue;
                failedReportList.add(reportbill.getPkValue().toString());
            }
            billList.add(bill);
        }
        SaveServiceHelper.save((DynamicObject[])billList.toArray(new DynamicObject[billList.size()]));
        SaveServiceHelper.save((DynamicObject[])curReportbillList.toArray(new DynamicObject[curReportbillList.size()]));
        this.updateReoprt(passProjectList, ConclusionEnum.PASS_S.getValue(), passReportList);
        this.updateReoprt(failedProjectList, ConclusionEnum.FAILED_S.getValue(), failedReportList);
    }

    private void updateReoprt(List<DynamicObject> projectList, String passOrFailed, List<String> passReportList) {
        if (null != projectList && !projectList.isEmpty() && null != passReportList && !passReportList.isEmpty()) {
            DynamicObject[] allKysbBills;
            DynamicObject[] allKyBills;
            ArrayList<String> proIds = new ArrayList<String>(10);
            for (DynamicObject pro : projectList) {
                proIds.add(pro.getPkValue().toString());
            }
            QFilter filter1 = new QFilter("id", "in", passReportList.stream().map(Long::parseLong).collect(Collectors.toList()));
            DynamicObject[] passReports = BusinessDataServiceHelper.load((String)"pmfs_newreportbill", (String)"project, reportperson, reportdate, declareorg, isnew, source, parent, billstatus, billid, billno, reportorg, desc,tasknumbers,resultnumbers, outestimate, inestimate", (QFilter[])new QFilter[]{filter1});
            ArrayList<Object> passSourceList = new ArrayList<Object>();
            for (DynamicObject passRreport : passReports) {
                DynamicObject[] source = passRreport.getDynamicObject("source");
                if (null == source) continue;
                passSourceList.add(source.getPkValue());
            }
            QFilter filter2 = new QFilter("source", "in", passSourceList);
            DynamicObject[] allReports = BusinessDataServiceHelper.load((String)"pmfs_newreportbill", (String)"project, reportperson, reportdate, declareorg, isnew, source, parent, billstatus, billid, billno, reportorg, desc,tasknumbers,resultnumbers, outestimate, inestimate", (QFilter[])new QFilter[]{filter2});
            ArrayList<Long> allkyBillList = new ArrayList<Long>();
            ArrayList<Long> allkysbEntryBillList = new ArrayList<Long>();
            for (DynamicObject dynamicObject : allReports) {
                String billId = dynamicObject.getString("billid");
                DynamicObject parent = dynamicObject.getDynamicObject("parent");
                if (null != billId && null != parent) {
                    allkysbEntryBillList.add(Long.parseLong(billId));
                    continue;
                }
                if (null == billId || null != parent) continue;
                allkyBillList.add(Long.parseLong(billId));
            }
            ArrayList<DynamicObject> allKyBillList = new ArrayList<DynamicObject>(10);
            QFilter kyfilter = new QFilter("id", "in", allkyBillList);
            for (DynamicObject kyBill : allKyBills = BusinessDataServiceHelper.load((String)"pmfs_reportbill", (String)"billno, billstatus, creator, auditor, org, auditdate, createtime, modifytime, modifier, reportdate, reportperson, project, desc, outestimate, inestimate, profitestimate, tasknumbers, resultnumbers, fsresult, reportorg, approvalresult, approvaldesc,attachmentfield, currency", (QFilter[])new QFilter[]{kyfilter})) {
                if (StringUtils.equals((CharSequence)passOrFailed, (CharSequence)ConclusionEnum.PASS_S.getValue())) {
                    kyBill.set("approvalresult", (Object)ConclusionEnum.PASS_S.getValue());
                } else if (StringUtils.equals((CharSequence)passOrFailed, (CharSequence)ConclusionEnum.FAILED_S.getValue())) {
                    kyBill.set("approvalresult", (Object)ConclusionEnum.FAILED_S.getValue());
                } else if (StringUtils.equals((CharSequence)passOrFailed, (CharSequence)ConclusionEnum.REPORT_S.getValue())) {
                    kyBill.set("approvalresult", (Object)ConclusionEnum.APPROVAL_S.getValue());
                }
                allKyBillList.add(kyBill);
            }
            SaveServiceHelper.save((DynamicObject[])allKyBillList.toArray(new DynamicObject[allKyBillList.size()]));
            ArrayList<DynamicObject> arrayList = new ArrayList<DynamicObject>(10);
            QFilter kyEntryfilter = new QFilter("id", "in", allkysbEntryBillList);
            for (DynamicObject kysbBill : allKysbBills = BusinessDataServiceHelper.load((String)"pmfs_majorapproval", (String)"id", (QFilter[])new QFilter[]{kyEntryfilter})) {
                kysbBill = BusinessDataServiceHelper.loadSingle((Object)kysbBill.getPkValue(), (String)"pmfs_majorapproval");
                DynamicObjectCollection proEntryCollection = kysbBill.getDynamicObjectCollection("listmodelentry");
                for (DynamicObject proEntry : proEntryCollection) {
                    DynamicObjectCollection subCol = proEntry.getDynamicObjectCollection("subentryentity");
                    DynamicObject project = proEntry.getDynamicObject("project");
                    if (null == subCol || subCol.isEmpty() || null == project) continue;
                    String proId = project.getPkValue().toString();
                    DynamicObject sub = (DynamicObject)subCol.get(0);
                    if (StringUtils.equals((CharSequence)passOrFailed, (CharSequence)ConclusionEnum.PASS_S.getValue()) && proIds.contains(proId)) {
                        sub.set("approvalresult", (Object)ConclusionEnum.PASS_S.getValue());
                        proEntry.set("prolabel", (Object)ConclusionEnum.PASS_S.getValue());
                        continue;
                    }
                    if (StringUtils.equals((CharSequence)passOrFailed, (CharSequence)ConclusionEnum.FAILED_S.getValue()) && proIds.contains(proId)) {
                        sub.set("approvalresult", (Object)ConclusionEnum.FAILED_S.getValue());
                        proEntry.set("prolabel", (Object)ConclusionEnum.FAILED_S.getValue());
                        continue;
                    }
                    if (!StringUtils.equals((CharSequence)passOrFailed, (CharSequence)ConclusionEnum.REPORT_S.getValue()) || !proIds.contains(proId)) continue;
                    sub.set("approvalresult", (Object)ConclusionEnum.APPROVAL_S.getValue());
                }
                arrayList.add(kysbBill);
            }
            SaveServiceHelper.save((DynamicObject[])arrayList.toArray(new DynamicObject[arrayList.size()]));
        }
    }

    private void delete(DynamicObject[] dataEntities) {
        ArrayList<DynamicObject> reportbillList = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> deleteReportList = new ArrayList<DynamicObject>();
        for (DynamicObject bill : dataEntities) {
            DynamicObjectCollection proEntryCollection = bill.getDynamicObjectCollection("listmodelentry");
            for (DynamicObject proEntry : proEntryCollection) {
                DynamicObject curReportbill;
                DynamicObjectCollection subCol = proEntry.getDynamicObjectCollection("subentryentity");
                if (null == subCol || subCol.isEmpty()) continue;
                DynamicObject reportbill = proEntry.getDynamicObject("reportbill");
                if (null != reportbill) {
                    reportbill = BusinessDataServiceHelper.loadSingle((Object)reportbill.getPkValue(), (String)"pmfs_newreportbill", (String)"id,isnew");
                    reportbill.set("isnew", (Object)Boolean.TRUE);
                    reportbillList.add(reportbill);
                }
                if (null == (curReportbill = proEntry.getDynamicObject("curreportbill"))) continue;
                deleteReportList.add(curReportbill);
            }
        }
        SaveServiceHelper.save((DynamicObject[])reportbillList.toArray(new DynamicObject[reportbillList.size()]));
        DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"pmfs_newreportbill"), (Object[])deleteReportList.toArray());
    }

    private DynamicObject createNewRepoertBill(DynamicObject bill, DynamicObject proEntry, DynamicObject subCard, DynamicObject reportbill) {
        DynamicObject newReport = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmfs_newreportbill"));
        ORM orm = ORM.create();
        Long id = orm.genLongId("pmfs_newreportbill");
        newReport.set("id", (Object)id);
        newReport.set("billno", (Object)bill.getString("billno"));
        newReport.set("parent", reportbill.getPkValue());
        if (null != reportbill.getDynamicObject("source")) {
            newReport.set("source", reportbill.getDynamicObject("source").getPkValue());
        }
        if (null != proEntry.getDynamicObject("project")) {
            newReport.set("project", proEntry.getDynamicObject("project").getPkValue());
        }
        if (null != bill.getDynamicObject("org")) {
            newReport.set("declareorg", bill.getDynamicObject("org").getPkValue());
        }
        if (null != bill.getDynamicObject("approvalperson")) {
            newReport.set("reportperson", bill.getDynamicObject("approvalperson").getPkValue());
        }
        newReport.set("reportdate", (Object)bill.getDate("approvaldate"));
        if (null != subCard.getDynamicObject("reportorg")) {
            newReport.set("reportorg", subCard.getDynamicObject("reportorg").getPkValue());
        }
        newReport.set("desc", (Object)subCard.getString("desc"));
        newReport.set("tasknumbers", subCard.get("tasknumbers"));
        newReport.set("resultnumbers", subCard.get("resultnumbers"));
        newReport.set("outestimate", subCard.get("outestimate"));
        newReport.set("inestimate", subCard.get("inestimate"));
        newReport.set("isnew", (Object)Boolean.TRUE);
        newReport.set("billstatus", (Object)StatusEnum.TEMPSAVE.getValue());
        newReport.set("billid", (Object)bill.getPkValue().toString());
        newReport.set("tecdesc", (Object)subCard.getString("tecdesc"));
        newReport.set("marketdesc", (Object)subCard.getString("marketdesc"));
        newReport.set("financedesc", (Object)subCard.getString("financedesc"));
        newReport.set("lawdesc", (Object)subCard.getString("lawdesc"));
        return newReport;
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        List validators = e.getValidators();
        boolean isNullCheck = false;
        for (AbstractValidator val : validators) {
            String key = val.getOperateKey();
            if (!"save".equals(key) && !"submit".equals(key) && !"audit".equals(key)) continue;
            isNullCheck = true;
        }
        if (isNullCheck) {
            e.getValidators().add(new AbstractValidator(){

                public void validate() {
                    for (ExtendedDataEntity dataEntity : this.dataEntities) {
                        String errMsg = MajorapprovalOp.this.checkNullValidate(dataEntity.getDataEntity());
                        if (errMsg == null) continue;
                        this.addErrorMessage(dataEntity, errMsg);
                    }
                }
            });
        }
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                String operateKey;
                switch (operateKey = this.getOperateKey()) {
                    case "unaudit": {
                        this.validateUnAudit(this.dataEntities);
                    }
                }
            }

            private void validateUnAudit(ExtendedDataEntity[] dataEntities) {
                for (ExtendedDataEntity dataEntity : dataEntities) {
                    DynamicObject majorApproval = dataEntity.getDataEntity();
                    block1: for (DynamicObject project : majorApproval.getDynamicObjectCollection("listmodelentry")) {
                        DynamicObject[] projectEvaluations;
                        QFilter proFilter = new QFilter("project", "=", project.getDynamicObject("project").getPkValue());
                        for (DynamicObject projectEvaluation : projectEvaluations = BusinessDataServiceHelper.load((String)"pmsc_projectevaluation", (String)"reportdeclare", (QFilter[])new QFilter[]{proFilter})) {
                            for (DynamicObject index : projectEvaluation.getDynamicObjectCollection("indexentry")) {
                                if (index.getBigDecimal("reportdeclare").compareTo(BigDecimal.ZERO) == 0) continue;
                                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u9879\u76ee\u201c%s\u201d\u7684\u8003\u91cf\u6307\u6807\u7533\u62a5\u503c\u5df2\u88ab\u9879\u76ee\u540e\u8bc4\u4ef7\u5355\u636e\u4f7f\u7528\uff0c\u65e0\u6cd5\u53cd\u5ba1\u6838\u3002", (String)"MajorapprovalOp_23", (String)"pmgt-pmfs-opplugin", (Object[])new Object[0]), project.getDynamicObject("project").getString("number")));
                                continue block1;
                            }
                        }
                    }
                }
            }
        });
    }

    private String checkNullValidate(DynamicObject bill) {
        DynamicObjectCollection proEntryCols = bill.getDynamicObjectCollection("listmodelentry");
        for (DynamicObject proEntryObj : proEntryCols) {
            DynamicObject subReportOrg;
            DynamicObjectCollection subCardCol = proEntryObj.getDynamicObjectCollection("subentryentity");
            if (subCardCol == null || subCardCol.isEmpty()) continue;
            DynamicObject subCard = (DynamicObject)subCardCol.get(0);
            String subProResult = subCard.getString("proresult");
            DynamicObject project = proEntryObj.getDynamicObject("project");
            String proName = project.getString("name");
            if (!StringUtils.equals((CharSequence)subProResult, (CharSequence)ConclusionEnum.REPORT_S.getValue()) || (subReportOrg = subCard.getDynamicObject("reportorg")) != null) continue;
            String errMsg = String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u9879\u76ee\u201c%s\u201d\u7684\u4e13\u9879\u5ba1\u6279\u7ec4\u7ec7\u3002", (String)"MajorapprovalOp_24", (String)"pmgt-pmfs-opplugin", (Object[])new Object[0]), proName);
            return errMsg;
        }
        return null;
    }
}

