/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmfs.opplugin;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmgt.pmbs.common.enums.ProjectStatusEnum;

public class RiskTreatOp
extends AbstractOperationServicePlugIn {
    private static final Log LOG = LogFactory.getLog(RiskTreatOp.class);

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator(new AbstractValidator(){

            public void validate() {
                String operateKey = this.getOperateKey();
                ExtendedDataEntity[] dataEntities = this.getDataEntities();
                switch (operateKey) {
                    case "unaudit": {
                        for (ExtendedDataEntity dataEntity : dataEntities) {
                            DynamicObject riskTrack = BusinessDataServiceHelper.loadSingle((Object)dataEntity.getDataEntity().getPkValue(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmfs_risktrack"));
                            DynamicObject project = riskTrack.getDynamicObject("project");
                            if (project == null) continue;
                            project = BusinessDataServiceHelper.loadSingle((Object)project.getPkValue(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_project"));
                            DynamicObject projectStatus = project.getDynamicObject("prostatus");
                            String proStatusNumber = "";
                            if (projectStatus != null) {
                                proStatusNumber = projectStatus.getPkValue().toString();
                            }
                            if (projectStatus != null && (ProjectStatusEnum.BUSSINESS_CLOSE.getId().equals(proStatusNumber) || ProjectStatusEnum.SUSPEND.getId().equals(proStatusNumber) || ProjectStatusEnum.QUIT.getId().equals(proStatusNumber))) {
                                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u9879\u76ee\u5df2%s\uff0c\u65e0\u6cd5\u53cd\u5ba1\u6838\u3002", (String)"RiskTreatOp_3", (String)"pmgt-pmfs-opplugin", (Object[])new Object[0]), projectStatus.getString("name")));
                                continue;
                            }
                            DynamicObjectCollection riskTrackCollection = riskTrack.getDynamicObjectCollection("risktrackentry");
                            if (riskTrackCollection.isEmpty()) continue;
                            for (int i = 0; i < riskTrackCollection.size(); ++i) {
                                DynamicObject risk = (DynamicObject)riskTrackCollection.get(i);
                                if (!risk.getString("treatstatus").equals("HANDLED")) continue;
                                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u98ce\u9669\u5df2\u5904\u7406\uff0c\u65e0\u6cd5\u53cd\u5ba1\u6838\u3002", (String)"RiskTreatOp_4", (String)"pmgt-pmfs-opplugin", (Object[])new Object[0]), i + 1));
                            }
                        }
                        break;
                    }
                }
            }
        });
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        String operationKey = e.getOperationKey();
        DynamicObject[] dataEntities = e.getDataEntities();
        switch (operationKey) {
            case "audit": {
                for (DynamicObject dataEntity : dataEntities) {
                    String projectDecision;
                    DynamicObject riskTrack = BusinessDataServiceHelper.loadSingle((Object)dataEntity.getPkValue(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmfs_risktrack"));
                    if (!riskTrack.getBoolean("isdisadvantages") || StringUtils.equals((CharSequence)"CONTINUEEXECUTE", (CharSequence)(projectDecision = riskTrack.getString("projectdecision")))) continue;
                    DynamicObject project = riskTrack.getDynamicObject("project");
                    project = BusinessDataServiceHelper.loadSingle((Object)project.getPkValue(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_project"));
                    project.set("prostatus", (Object)ProjectStatusEnum.getEnumByValue((Object)projectDecision).getId());
                    try (TXHandle h = TX.requiresNew();){
                        try {
                            SaveServiceHelper.update((DynamicObject)project);
                        }
                        catch (Exception ex) {
                            h.markRollback();
                            String msg = ResManager.loadKDString((String)"\u5ba1\u6838\u5931\u8d25\uff1a\u66f4\u65b0\u9879\u76ee\u72b6\u6001\u5931\u8d25\u3002", (String)"RiskTreatOp_5", (String)"pmgt-pmfs-opplugin", (Object[])new Object[0]);
                            LOG.error(msg, (Throwable)ex);
                        }
                    }
                    DynamicObject projectApproval = BusinessDataServiceHelper.loadSingle((String)"pmas_pro_approval", (String)"prostatus", (QFilter[])new QFilter[]{new QFilter("pro", "=", project.getPkValue())});
                    if (projectApproval != null) {
                        projectApproval.set("prostatus", (Object)ProjectStatusEnum.getEnumByValue((Object)projectDecision).getId());
                        SaveServiceHelper.update((DynamicObject)projectApproval);
                        continue;
                    }
                    DynamicObject sysProject = BusinessDataServiceHelper.loadSingle((Object)project.getPkValue(), (String)"bd_project");
                    if (sysProject == null) continue;
                    sysProject.set("prostatus", (Object)ProjectStatusEnum.getEnumByValue((Object)projectDecision).getId());
                    SaveServiceHelper.update((DynamicObject)sysProject);
                }
                break;
            }
            case "unaudit": {
                for (DynamicObject dataEntity : dataEntities) {
                    DynamicObject riskTrack = BusinessDataServiceHelper.loadSingle((Object)dataEntity.getPkValue(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmfs_risktrack"));
                    if (!riskTrack.getBoolean("isdisadvantages")) continue;
                    String projectDecision = riskTrack.getString("projectdecision");
                    if (!ProjectStatusEnum.FINANCIAL_CLOSE.getValue().equals(projectDecision)) continue;
                    DynamicObject project = riskTrack.getDynamicObject("project");
                    DynamicObject projectStatus = (project = BusinessDataServiceHelper.loadSingle((Object)project.getPkValue(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_project"))).getDynamicObject("prostatus");
                    if (projectStatus == null || !ProjectStatusEnum.FINANCIAL_CLOSE.getId().equals(projectStatus.getPkValue().toString())) continue;
                    project.set("prostatus", (Object)ProjectStatusEnum.APPROVAL_IN.getId());
                    try (TXHandle h = TX.requiresNew();){
                        try {
                            SaveServiceHelper.update((DynamicObject)project);
                        }
                        catch (Exception ex) {
                            h.markRollback();
                            String msg = ResManager.loadKDString((String)"\u5ba1\u6838\u5931\u8d25\uff1a\u66f4\u65b0\u9879\u76ee\u72b6\u6001\u5931\u8d25\u3002", (String)"RiskTreatOp_5", (String)"pmgt-pmfs-opplugin", (Object[])new Object[0]);
                            LOG.error(msg, (Throwable)ex);
                        }
                    }
                    DynamicObject projectApproval = BusinessDataServiceHelper.loadSingle((String)"pmas_pro_approval", (String)"prostatus", (QFilter[])new QFilter[]{new QFilter("pro", "=", project.getPkValue())});
                    projectApproval.set("prostatus", (Object)ProjectStatusEnum.APPROVAL_IN.getId());
                    SaveServiceHelper.update((DynamicObject)projectApproval);
                }
                break;
            }
        }
    }
}

