/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmfs.opplugin.initialize;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.plugin.args.InitOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmgt.pmfs.business.helper.ProjectInitializeHelper;
import kd.pmgt.pmfs.opplugin.base.AbstractPmfsOperationServicePlugin;

public class ProjectInitializeAuditOpPlugin
extends AbstractPmfsOperationServicePlugin {
    protected ProjectInitializeHelper projectInitializeHelper;

    public void initialize(InitOperationArgs e) {
        super.initialize(e);
        this.projectInitializeHelper = new ProjectInitializeHelper();
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("attachtype");
        fieldKeys.add("project");
        fieldKeys.add("org");
        fieldKeys.add("creator");
        fieldKeys.add("modifier");
        fieldKeys.add("version");
        fieldKeys.add("executiveversion");
        fieldKeys.add("resourceprojectinitid");
        fieldKeys.add("splitentry");
        fieldKeys.add("splitentry_wbsnumber");
        fieldKeys.add("splitentry_wbsname");
        fieldKeys.add("splitentry_remark");
        fieldKeys.add("splitentry_type");
        fieldKeys.add("splitentry_milestone");
        fieldKeys.add("splitentry_planstarttime");
        fieldKeys.add("splitentry_planendtime");
        fieldKeys.add("splitentry_qty");
        fieldKeys.add("splitentry_unit");
        fieldKeys.add("splitentry_price");
        fieldKeys.add("splitentry_amount");
        fieldKeys.add("splitentry_schedule");
        fieldKeys.add("splitentry_completeamt");
        fieldKeys.add("pid");
        fieldKeys.add("level");
        fieldKeys.add("isleaf");
        fieldKeys.add("resourcewbsid");
        fieldKeys.add("seq");
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        this.doEndTransaction(e);
    }

    protected void doEndTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] entities;
        for (DynamicObject entity : entities = e.getDataEntities()) {
            entity = BusinessDataServiceHelper.loadSingle((Object)entity.getPkValue(), (String)"pmfs_projectinitialize");
            this.projectInitializeHelper.syncProInitEntry2WBS(entity);
            this.projectInitializeHelper.updateOldModelData(entity, false);
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject[] entities;
        super.afterExecuteOperationTransaction(e);
        for (DynamicObject entity : entities = e.getDataEntities()) {
            DynamicObject model = BusinessDataServiceHelper.loadSingle((Object)entity.getPkValue(), (String)"pmfs_projectinitialize");
            model.set("executiveversion", (Object)Boolean.TRUE);
            SaveServiceHelper.update((DynamicObject)model);
        }
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntries;
                for (ExtendedDataEntity entity : dataEntries = this.getDataEntities()) {
                    List wbsList;
                    DynamicObject dataEntity = entity.getDataEntity();
                    DynamicObject project = dataEntity.getDynamicObject("project");
                    if (project == null || (wbsList = ProjectInitializeAuditOpPlugin.this.projectInitializeHelper.checkSyncProInitEntry2WBSResult(dataEntity = BusinessDataServiceHelper.loadSingle((Object)dataEntity.getPkValue(), (String)"pmfs_projectinitialize"))).isEmpty()) continue;
                    for (DynamicObject wbs : wbsList) {
                        String wbsNumber = wbs.getString("number");
                        String wbsName = wbs.getString("name");
                        this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u53cd\u5ba1\u6838\u5931\u8d25\u3002WBS\uff1a%1$s\u3001%2$s\u5df2\u88ab\u5f15\u7528\uff0c\u65e0\u6cd5\u53cd\u5ba1\u6838\u3002", (String)"ProjectInitializeAuditOpPlugin_1", (String)"pmgt-pmfs-opplugin", (Object[])new Object[0]), wbsNumber, wbsName));
                    }
                }
            }
        });
    }
}

