/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmfs.opplugin.initialize;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.BillStatus;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.pmgt.pmbs.common.enums.projectinitialize.SplitDimensionEnum;
import kd.pmgt.pmbs.common.utils.DateUtil;
import kd.pmgt.pmfs.opplugin.base.AbstractPmfsOperationServicePlugin;

public class ProjectInitializeSubmitOpPlugin
extends AbstractPmfsOperationServicePlugin {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("resourceprojectinitid");
        e.getFieldKeys().add("version");
        e.getFieldKeys().add("splitdimension");
        e.getFieldKeys().add("splitentry_planstarttime");
        e.getFieldKeys().add("splitentry_planendtime");
        e.getFieldKeys().add("splitentry_qty");
        e.getFieldKeys().add("subsplitentry");
        e.getFieldKeys().add("subdate");
        e.getFieldKeys().add("subpercentage");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] entities = this.getDataEntities();
                HashSet<Long> resourceIdSet = new HashSet<Long>(entities.length);
                for (ExtendedDataEntity entity : entities) {
                    DynamicObject model = entity.getDataEntity();
                    Long resourceProjectInitId = model.getLong("resourceprojectinitid");
                    if (0L != resourceProjectInitId) {
                        boolean isExists = QueryServiceHelper.exists((String)"pmfs_projectinitialize", (QFilter[])new QFilter[]{new QFilter("resourceprojectinitid", "=", (Object)resourceProjectInitId).and("version", "=", model.get("version")).and("billstatus", "<>", (Object)BillStatus.A)});
                        if (!resourceIdSet.add(resourceProjectInitId) || isExists) {
                            this.addErrorMessage(entity, ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u76f8\u540c\u7248\u672c\u7684\u9879\u76ee\u521d\u8bbe\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ProjectInitializeSubmitOpPlugin_6", (String)"pmgt-pmfs-opplugin", (Object[])new Object[0]));
                            continue;
                        }
                    } else {
                        QFilter qFilter;
                        boolean hasProjectInit;
                        DynamicObject project = model.getDynamicObject("project");
                        if (project != null && (hasProjectInit = QueryServiceHelper.exists((String)"pmfs_projectinitialize", (QFilter[])new QFilter[]{qFilter = 0L == model.getLong("id") ? new QFilter("project", "=", project.getPkValue()) : new QFilter("project", "=", project.getPkValue()).and("id", "not in", model.getPkValue())}))) {
                            this.addErrorMessage(entity, ResManager.loadKDString((String)"\u672c\u9879\u76ee\u5df2\u6709\u9879\u76ee\u521d\u8bbe\u3002\u5982\u9700\u4fee\u6539\uff0c\u8bf7\u4f7f\u7528\u5355\u636e\u7684\u4fee\u8ba2\u529f\u80fd\u5bf9\u539f\u8bb0\u5f55\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"ProjectInitializeSubmitOpPlugin_7", (String)"pmgt-pmfs-opplugin", (Object[])new Object[0]));
                            continue;
                        }
                    }
                    String splitDimension = model.getString("splitdimension");
                    for (DynamicObject wbsSplit : model.getDynamicObjectCollection("splitentry")) {
                        Date planStartTime = wbsSplit.getDate("splitentry_planstarttime");
                        Date planEndTime = wbsSplit.getDate("splitentry_planendtime");
                        BigDecimal allSubPercentage = BigDecimal.ZERO;
                        BigDecimal qty = wbsSplit.getBigDecimal("splitentry_qty");
                        BigDecimal allSubCount = BigDecimal.ZERO;
                        String wbsNumber = wbsSplit.getString("splitentry_wbsnumber");
                        String wbsName = wbsSplit.getString("splitentry_wbsname");
                        DynamicObjectCollection subSplitEntry = wbsSplit.getDynamicObjectCollection("subsplitentry");
                        int index = 1;
                        for (DynamicObject subWbsSplit : subSplitEntry) {
                            Date subDate = subWbsSplit.getDate("subdate");
                            BigDecimal subPercentage = subWbsSplit.getBigDecimal("subpercentage");
                            allSubPercentage = allSubPercentage.add(subPercentage);
                            BigDecimal subCount = subWbsSplit.getBigDecimal("subcount");
                            allSubCount = allSubCount.add(subCount);
                            if (subDate != null && (planStartTime == null || planEndTime == null || SplitDimensionEnum.BY_MONTH.getValue().equals(splitDimension) && (DateUtil.compareByMonth((Date)subDate, (Date)planStartTime) < 0 || DateUtil.compareByMonth((Date)subDate, (Date)planEndTime) > 0) || SplitDimensionEnum.BY_DAY.getValue().equals(splitDimension) && (DateUtil.compareByDay((Date)subDate, (Date)planStartTime) < 0 || DateUtil.compareByDay((Date)subDate, (Date)planEndTime) > 0) || SplitDimensionEnum.BY_HOUR.getValue().equals(splitDimension) && (DateUtil.compareByHour((Date)subDate, (Date)planStartTime) < 0 || DateUtil.compareByHour((Date)subDate, (Date)planEndTime) > 0))) {
                                this.addWarningMessage(entity, String.format(ResManager.loadKDString((String)"WBS\uff1a%1$s\u3001%2$s\u7684\u660e\u7ec6\u884c%3$s\u7684WBS\u6570\u91cf\u62c6\u5206\u7684\u671f\u95f4\u4e0e\u672c\u9879\u8ba1\u5212\u5f00\u59cb\u5b8c\u6210\u65f6\u95f4\u4e0d\u5339\u914d\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\uff1f", (String)"ProjectInitializeSubmitOpPlugin_8", (String)"pmgt-pmfs-opplugin", (Object[])new Object[0]), wbsNumber, wbsName, index));
                            }
                            ++index;
                        }
                        if (subSplitEntry.size() > 0 && allSubPercentage.compareTo(new BigDecimal(100)) != 0) {
                            this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"WBS\uff1a%1$s\u3001%2$s\u7684\u6570\u91cf\u62c6\u5206\u8bbe\u7f6e\u7684\u671f\u95f4\u767e\u5206\u6bd4\u6c47\u603b\u4e0d\u7b49\u4e8e100\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ProjectInitializeSubmitOpPlugin_9", (String)"pmgt-pmfs-opplugin", (Object[])new Object[0]), wbsNumber, wbsName));
                        }
                        if (subSplitEntry.size() <= 0 || allSubCount.compareTo(qty) == 0) continue;
                        this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"WBS\uff1a%1$s\u3001%2$s\u7684WBS\u6570\u91cf\u62c6\u5206\u8bbe\u7f6e\u7684\u671f\u95f4\u6570\u91cf\u6c47\u603b\u4e0e\u9879\u76ee\u62c6\u5206\u8bbe\u7f6e\u4e2d\u5bf9\u5e94WBS\u7684\u6570\u91cf\u4e0d\u7b26\u3002", (String)"ProjectInitializeSubmitOpPlugin_10", (String)"pmgt-pmfs-opplugin", (Object[])new Object[0]), wbsNumber, wbsName));
                    }
                }
            }
        });
    }
}

