/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmfs.opplugin.initialize;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmfs.business.helper.ProjectInitializeHelper;
import kd.pmgt.pmfs.opplugin.base.AbstractPmfsOperationServicePlugin;

public class ProjectInitializeUnAuditOpPlugin
extends AbstractPmfsOperationServicePlugin {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("version");
        fieldKeys.add("executiveversion");
        fieldKeys.add("resourceprojectinitid");
        fieldKeys.add("splitentry");
        fieldKeys.add("project");
        fieldKeys.add("resourceprojectinitid");
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] entities;
        super.endOperationTransaction(e);
        for (DynamicObject entity : entities = e.getDataEntities()) {
            ProjectInitializeHelper.getInstance().backOffLastVersion(entity, true);
            entity.set("executiveversion", (Object)Boolean.FALSE);
            SaveServiceHelper.update((DynamicObject)entity);
        }
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntries;
                for (ExtendedDataEntity dataEntity : dataEntries = this.getDataEntities()) {
                    DynamicObject model = dataEntity.getDataEntity();
                    DynamicObject[] highVersionBills = ProjectInitializeUnAuditOpPlugin.this.getHighVersionBill(model);
                    if (highVersionBills.length > 0) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53cd\u5ba1\u6838\u5931\u8d25\u3002\u5b58\u5728\u65b0\u7248\u7684\u540c\u6837\u6570\u636e\uff0c\u65e0\u6cd5\u53cd\u5ba1\u6838\u3002", (String)"ProjectInitializeUnAuditOpPlugin_4", (String)"pmgt-pmfs-opplugin", (Object[])new Object[0]));
                    }
                    if (!(model = BusinessDataServiceHelper.loadSingle((Object)model.getPkValue(), (String)"pmfs_projectinitialize")).getBoolean("executiveversion")) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53ea\u6709\u201c\u6267\u884c\u201d\u72b6\u6001\u7684\u7248\u672c\u624d\u80fd\u8fdb\u884c\u76f8\u5173\u64cd\u4f5c\u3002", (String)"ProjectInitializeUnAuditOpPlugin_5", (String)"pmgt-pmfs-opplugin", (Object[])new Object[0]));
                    }
                    DynamicObjectCollection splitEntry = model.getDynamicObjectCollection("splitentry");
                    for (DynamicObject entry : splitEntry) {
                        long wbsId;
                        long l = wbsId = entry.getLong("resourcewbsid") == 0L ? entry.getLong("id") : entry.getLong("resourcewbsid");
                        if (!ProjectInitializeHelper.getInstance().checkWBSIsRefenced(Long.valueOf(wbsId))) continue;
                        String wbsNumber = entry.getString("splitentry_wbsnumber");
                        String wbsName = entry.getString("splitentry_wbsname");
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u53cd\u5ba1\u6838\u5931\u8d25\u3002WBS\uff1a%1$s\u3001%2$s\u5df2\u88ab\u5f15\u7528\uff0c\u65e0\u6cd5\u53cd\u5ba1\u6838\u3002", (String)"ProjectInitializeUnAuditOpPlugin_6", (String)"pmgt-pmfs-opplugin", (Object[])new Object[0]), wbsNumber, wbsName));
                    }
                }
            }
        });
    }

    protected DynamicObject[] getHighVersionBill(DynamicObject model) {
        int version = model.getInt("version");
        QFilter filter = new QFilter("resourceprojectinitid", "=", model.getPkValue()).and("version", ">", (Object)version).and("billstatus", "!=", (Object)StatusEnum.CHECKED.getValue());
        return BusinessDataServiceHelper.load((String)"pmfs_projectinitialize", (String)"id", (QFilter[])new QFilter[]{filter});
    }
}

