/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmfs.opplugin.supervision;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.control.AttachmentPanelAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmgt.pmbs.business.helper.FileAttachmentHelper;
import kd.pmgt.pmbs.business.utils.ProjectSupervisionHelper;
import kd.pmgt.pmbs.common.enums.CompletionStatusEnum;
import kd.pmgt.pmbs.common.enums.OperationEnum;
import kd.pmgt.pmbs.common.utils.DateUtil;
import kd.pmgt.pmbs.common.utils.MetadataUtil;
import kd.pmgt.pmbs.common.utils.task.PmpmTaskUtil;
import kd.pmgt.pmbs.common.utils.task.PmptTaskUtil;

public class SupervisionFinishOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(SupervisionFinishOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("workitem");
        e.getFieldKeys().add("sysbill");
        e.getFieldKeys().add("bizbillid");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities;
                String operateKey = this.getOperateKey();
                for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
                    DynamicObject workItem;
                    DynamicObject supervisdBill;
                    DynamicObject bill = dataEntity.getDataEntity();
                    DynamicObject sysBill = bill.getDynamicObject("sysbill");
                    String bizBillId = bill.getString("bizbillid");
                    if (sysBill != null && bizBillId != null && !bizBillId.isEmpty() && (supervisdBill = BusinessDataServiceHelper.loadSingle((String)sysBill.getString("sysbill_id"), (String)"", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(bizBillId))})) == null) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u76f8\u5173\u4e1a\u52a1\u4fe1\u606f\u5355\u636e\u5df2\u5220\u9664\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"SupervisionFinishOp_2", (String)"pmgt-pmfs-opplugin", (Object[])new Object[0]));
                    }
                    if (!StringUtils.equals((CharSequence)operateKey, (CharSequence)"unaudit") || (workItem = bill.getDynamicObject("workitem")).getDynamicObject("task") == null) continue;
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u9879\u76ee\u8ba1\u5212\u7684\u7763\u5bfc\u5de5\u4f5c\u8bb0\u5f55\u5df2\u6c47\u62a5\uff0c\u65e0\u6cd5\u53cd\u5ba1\u6838\u3002", (String)"SupervisionFinishOp_3", (String)"pmgt-pmfs-opplugin", (Object[])new Object[0]));
                }
            }
        });
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        String operationKey = e.getOperationKey();
        DynamicObject[] dataEntities = e.getDataEntities();
        switch (OperationEnum.getEnumByValue((Object)operationKey)) {
            case AUDIT: {
                this.setLight(dataEntities, OperationEnum.AUDIT.getValue());
                break;
            }
            case UNAUDIT: {
                this.setLight(dataEntities, OperationEnum.UNAUDIT.getValue());
                break;
            }
        }
    }

    private void setLight(DynamicObject[] dataEntities, String operationType) {
        for (DynamicObject dynamicObject : dataEntities) {
            Object workItemId = dynamicObject.getDynamicObject("workitem").getPkValue();
            DynamicObject[] supervisionFinishByWorkItem = OperationEnum.AUDIT.getValue().equals(operationType) ? ProjectSupervisionHelper.getEffectiveSupervisionFinishRecordByWorkItem((Object)Long.parseLong(String.valueOf(workItemId)), (Object)dynamicObject.getPkValue()) : ProjectSupervisionHelper.getEffectiveSupervisionFinishRecordByWorkItem((Object)Long.parseLong(String.valueOf(workItemId)), null);
            DynamicObject workItem = BusinessDataServiceHelper.loadSingle((Object)workItemId, (String)"pmbs_workexecution");
            Date estimateEndTime = workItem.getDate("estimateendtime");
            if (supervisionFinishByWorkItem.length > 0) {
                Date actualEndTime = supervisionFinishByWorkItem[0].getDate("actualendtime");
                String light = ProjectSupervisionHelper.getItemWarnLight((Date)estimateEndTime, (Date)actualEndTime);
                workItem.set("itemwarninglight", (Object)light);
                workItem.set("actualendtime", (Object)actualEndTime);
            } else {
                String light = ProjectSupervisionHelper.getItemWarnLight((Date)estimateEndTime, null);
                workItem.set("itemwarninglight", (Object)light);
                workItem.set("actualendtime", null);
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{workItem});
            this.reportTask(dynamicObject, operationType);
        }
    }

    private void reportTask(DynamicObject bill, String operationType) {
        DynamicObject workItem = bill.getDynamicObject("workitem");
        DynamicObject task = workItem.getDynamicObject("task");
        if (task != null) {
            task = BusinessDataServiceHelper.loadSingle((Object)task.getPkValue(), (String)"pmpt_task");
            switch (operationType) {
                case "audit": {
                    Date realEndTime = bill.getDate("actualendtime");
                    task.set("realendtime", (Object)realEndTime);
                    task.set("percent", (Object)100);
                    Date planEndTime = task.getDate("planendtime");
                    DynamicObject project = task.getDynamicObject("project");
                    BigDecimal realTimeDeviation = null;
                    realTimeDeviation = project != null ? PmpmTaskUtil.getDaysBetweenTwoDate((Object)project.getPkValue(), (Date)realEndTime, (Date)planEndTime) : BigDecimal.valueOf(DateUtil.getDaysBetweenTwoDate((Date)realEndTime, (Date)planEndTime));
                    task.set("realtimedeviation", (Object)realTimeDeviation);
                    if (DateUtil.compareByDay((Date)realEndTime, (Date)planEndTime) <= 0) {
                        task.set("completionstatus", (Object)CompletionStatusEnum.ONTIMECOMPLETE.getValue());
                    } else if (DateUtil.compareByDay((Date)realEndTime, (Date)planEndTime) > 0) {
                        task.set("completionstatus", (Object)CompletionStatusEnum.OVERDUECOMPLETE.getValue());
                    }
                    DynamicObject taskReport = PmptTaskUtil.createNewTaskReportByTask((DynamicObject)task);
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{task});
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{taskReport});
                    String sysBillAttachmentId = "";
                    DynamicObject sysBill = bill.getDynamicObject("sysbill");
                    if (sysBill == null) break;
                    String sysBillId = sysBill.getString("sysbill_id");
                    List controlAps = MetadataUtil.getFormMetadata((String)sysBillId);
                    for (ControlAp controlAp : controlAps) {
                        if (!(controlAp instanceof AttachmentPanelAp)) continue;
                        sysBillAttachmentId = controlAp.getKey();
                        break;
                    }
                    if (!StringUtils.isNotEmpty((CharSequence)sysBillAttachmentId)) break;
                    FileAttachmentHelper.copyFileFromAToB((String)sysBillId, (Object)sysBill.getPkValue(), (String)sysBillAttachmentId, (String)"pmpt_taskreport", (Object)taskReport.getPkValue(), (String)"attachmentpanel");
                    break;
                }
            }
        }
    }
}

