/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmfs.report.form;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.CompareTypeEnum;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.report.ReportView;
import kd.bos.orm.query.QFilter;
import kd.bos.report.IReportView;
import kd.bos.report.ReportList;
import kd.bos.report.filter.ReportFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmgt.pmbs.business.helper.project.ProjectTeamPermissionHelper;
import kd.pmgt.pmbs.business.utils.ProjectSupervisionHelper;
import kd.pmgt.pmbs.common.enums.PlanEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmbs.common.enums.supervision.FinishStatusWarningEnum;
import kd.pmgt.pmfs.report.base.AbstractPmfsReportFormPlugin;
import org.apache.commons.collections4.CollectionUtils;

public class SupervisionWorkbenchFormPlugin
extends AbstractPmfsReportFormPlugin
implements BeforeF7SelectListener,
HyperLinkClickListener,
RowClickEventListener {
    private static final String FINISH_RECORD = "viewworkfinishrecord";
    private static final String AP_REPORT_LIST = "reportlistap";
    private static final String VIEW_BILL = "viewbill";
    private static final String RESET = "reset";
    private static final String REPORT = "report";
    private static final String BIND_TASK = "bindtask";
    private static final String REPORT_CALL_BACK = "reportCallBack";
    private static final String CURRENT_ROW_INDEX = "currentRowIndex";
    private static final String REPORTFILTERAP = "reportfilterap";

    public void registerListener(EventObject e) {
        ReportList reportList;
        EntryGrid entryGrid;
        super.registerListener(e);
        BasedataEdit project = (BasedataEdit)this.getControl("project");
        if (project != null) {
            project.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((entryGrid = (EntryGrid)this.getControl("supervisionreport")) != null) {
            entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        }
        if ((reportList = (ReportList)this.getControl(AP_REPORT_LIST)) != null) {
            reportList.addRowClickListener((RowClickEventListener)this);
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        super.entryRowClick(evt);
        Control source = (Control)evt.getSource();
        int rowIndex = evt.getRow();
        if (StringUtils.equals((CharSequence)AP_REPORT_LIST, (CharSequence)source.getKey())) {
            this.viewBill(rowIndex);
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"supervisionreport"});
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        long userId = RequestContext.get().getCurrUserId();
        ReportView view = (ReportView)this.getView();
        String billFormId = view.getFormId();
        String appId = view.getFormShowParameter().getAppId();
        List orgIds = ProjectTeamPermissionHelper.getAllPermOrgsByPermItem((String)"15", (Long)userId, (String)appId, (String)billFormId, (String)"47150e89000000ac");
        if (orgIds.size() > 0) {
            this.getModel().setValue("org", orgIds.get(0));
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        FilterInfo filterCondition = queryParam.getFilter();
        IReportView view = this.getView();
        DynamicObject org = filterCondition.getDynamicObject("org");
        if (org == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u7ec4\u7ec7\u3002", (String)"SupervisionWorkbenchFormPlugin_0", (String)"pmgt-pmfs-report", (Object[])new Object[0]));
            return false;
        }
        DynamicObject projectCurrency = (DynamicObject)this.getModel().getValue("project");
        DynamicObject project = filterCondition.getDynamicObject("project");
        if (project == null) {
            project = projectCurrency;
            filterCondition.addFilterItem("project", (Object)project, CompareTypeEnum.EQUAL.getId());
        }
        String resetFlag = this.getPageCache().get(RESET);
        this.getPageCache().remove(RESET);
        if (project == null && resetFlag == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9879\u76ee\u3002", (String)"SupervisionWorkbenchFormPlugin_1", (String)"pmgt-pmfs-report", (Object[])new Object[0]));
            return false;
        }
        this.getModel().deleteEntryData("supervisionreport");
        return true;
    }

    public void afterQuery(ReportQueryParam queryParam) {
        super.afterQuery(queryParam);
        this.getView().setVisible(Boolean.TRUE, new String[]{"supervisionreport"});
        ReportFilter reportFilter = (ReportFilter)this.getControl(REPORTFILTERAP);
        reportFilter.setCollapse(false);
        ReportList reportList = (ReportList)this.getControl(AP_REPORT_LIST);
        int rowCount = reportList.getReportModel().getRowCount();
        if (rowCount > 0) {
            this.viewBill(1);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey;
        super.afterDoOperation(afterDoOperationEventArgs);
        switch (operateKey = afterDoOperationEventArgs.getOperateKey()) {
            case "viewworkfinishrecord": {
                this.viewWorkFinishRecord();
                break;
            }
            case "viewbill": {
                int currentRowIndex = this.getModel().getEntryCurrentRowIndex(AP_REPORT_LIST);
                this.viewBill(currentRowIndex);
                break;
            }
            case "report": {
                int currentRowIndex = this.getModel().getEntryCurrentRowIndex(AP_REPORT_LIST);
                this.report(currentRowIndex);
                break;
            }
            case "bindtask": {
                this.showTask();
                break;
            }
            case "refresh": {
                String currentRowIndexStr = this.getPageCache().get(CURRENT_ROW_INDEX);
                ReportList reportList = (ReportList)this.getControl(AP_REPORT_LIST);
                if (reportList.getReportModel().getRowCount() == 0) break;
                int focusRow = StringUtils.isNotEmpty((CharSequence)currentRowIndexStr) ? Integer.parseInt(currentRowIndexStr) : 1;
                this.viewBill(focusRow);
                break;
            }
            case "reset": {
                this.getPageCache().put(RESET, RESET);
                ReportFilter rf = (ReportFilter)this.getView().getControl(REPORTFILTERAP);
                rf.search();
                rf.setCollapse(false);
                break;
            }
        }
    }

    private void showTask() {
        DynamicObjectCollection taskEntities;
        ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)"pmpt_task", (boolean)false, (int)ShowType.Modal.getValue());
        DynamicObject project = (DynamicObject)this.getModel().getValue("project");
        QFilter projectFilter = new QFilter("project", "=", project.getPkValue());
        QFilter statusFilter = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
        QFilter planStatusFilter = new QFilter("planstatus", "=", (Object)PlanEnum.PUBLISHED.getValue());
        List<Object> taskIdList = new ArrayList(16);
        DynamicObject[] masterPlan = BusinessDataServiceHelper.load((String)"pmpt_masterplan", (String)"id,version,taskentity", (QFilter[])new QFilter[]{projectFilter, statusFilter, planStatusFilter}, (String)"version desc");
        if (masterPlan != null && masterPlan.length > 0 && CollectionUtils.isNotEmpty((Collection)(taskEntities = masterPlan[0].getDynamicObjectCollection("taskentity")))) {
            taskIdList = taskEntities.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList());
        }
        QFilter pkFilter = new QFilter("id", "in", taskIdList);
        statusFilter = new QFilter("status", "=", (Object)StatusEnum.CHECKED.getValue());
        QFilter enableFilter = new QFilter("islatest", "=", (Object)"1");
        showParameter.setFormId("bos_listf7");
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, BIND_TASK);
        showParameter.setCloseCallBack(closeCallBack);
        showParameter.getListFilterParameter().setQFilters(Arrays.asList(pkFilter, statusFilter, enableFilter));
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void report(int currentRowIndex) {
        DynamicObject[] dynamicObjects;
        ReportList reportList = (ReportList)this.getControl(AP_REPORT_LIST);
        Date actualEndTime = (Date)reportList.getReportModel().getValue(currentRowIndex, "actualendtime");
        String workItemId = (String)reportList.getReportModel().getValue(currentRowIndex, "workitemid");
        for (DynamicObject dynamicObject : dynamicObjects = ProjectSupervisionHelper.getEffectiveSupervisionFinishRecordByWorkItem((Object)Long.parseLong(workItemId), null)) {
            DynamicObject supervisdBill;
            DynamicObject sysBill = dynamicObject.getDynamicObject("sysbill");
            String billId = dynamicObject.getString("bizbillid");
            String billNo = dynamicObject.getString("billno");
            if (sysBill == null) continue;
            String billFormId = sysBill.getString("sysbill_id");
            if (!StringUtils.isNotEmpty((CharSequence)billId) || (supervisdBill = BusinessDataServiceHelper.loadSingle((String)billFormId, (String)"", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(billId))})) != null) continue;
            String formName = MetadataServiceHelper.getDataEntityType((String)billFormId).getDisplayName().getLocaleValue();
            this.getView().showErrorNotification(String.format(ResManager.loadKDStringExt((String)"\u5355\u636e\uff1a%1$s\uff0c\u5355\u636e\u7f16\u53f7\uff1a%2$s\u5df2\u5220\u9664\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"SupervisionWorkbenchFormPlugin_11", (String)"pmgt-pmfs-report", (Object[])new Object[0]), formName, billNo));
            return;
        }
        if (actualEndTime != null) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u8be5\u5de5\u4f5c\u9879\u5df2\u6c47\u62a5\u4e3a\u5b8c\u6210\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\u586b\u62a5\uff1f", (String)"SupervisionWorkbenchFormPlugin_12", (String)"pmgt-pmfs-report", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(REPORT_CALL_BACK, (IFormPlugin)this));
            this.getPageCache().put(CURRENT_ROW_INDEX, String.valueOf(currentRowIndex));
            return;
        }
        this.createSupervisionFinishBill(currentRowIndex);
    }

    private void viewWorkFinishRecord() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u7ec4\u7ec7\u3002", (String)"SupervisionWorkbenchFormPlugin_0", (String)"pmgt-pmfs-report", (Object[])new Object[0]));
            return;
        }
        DynamicObject project = (DynamicObject)this.getModel().getValue("project");
        if (project == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9879\u76ee\u3002", (String)"SupervisionWorkbenchFormPlugin_1", (String)"pmgt-pmfs-report", (Object[])new Object[0]));
            return;
        }
        HashMap<String, Object> customMap = new HashMap<String, Object>();
        customMap.put("projectId", project.getPkValue());
        customMap.put("orgId", org.getPkValue());
        ListShowParameter parameter = new ListShowParameter();
        parameter.setCustomParams(customMap);
        parameter.setBillFormId("pmfs_supervisionfinish");
        parameter.setFormId("bos_list");
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.getOpenStyle().setTargetKey("_submaintab_");
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void viewBill(int currentRowIndex) {
        DynamicObject[] projectSupervisionArray;
        this.getModel().deleteEntryData("supervisionreport");
        ReportList reportList = (ReportList)this.getControl(AP_REPORT_LIST);
        String workItemId = (String)reportList.getReportModel().getValue(currentRowIndex, "workitemid");
        if (StringUtils.isEmpty((CharSequence)workItemId)) {
            return;
        }
        for (DynamicObject projectSupervision : projectSupervisionArray = ProjectSupervisionHelper.getEffectiveSupervisionFinishRecordByWorkItem((Object)Long.parseLong(workItemId), null)) {
            int rowIndex = this.getModel().createNewEntryRow("supervisionreport");
            DynamicObject sysBill = projectSupervision.getDynamicObject("sysbill");
            String billId = projectSupervision.getString("bizbillid");
            String billNo = projectSupervision.getString("billno");
            if (sysBill != null) {
                DynamicObject supervisdBill;
                String billFormId = sysBill.getString("sysbill_id");
                if (billId != null && !billId.isEmpty() && (supervisdBill = BusinessDataServiceHelper.loadSingle((String)billFormId, (String)"", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(billId))})) == null) {
                    String formName = MetadataServiceHelper.getDataEntityType((String)billFormId).getDisplayName().getLocaleValue();
                    this.getView().showErrorNotification(String.format(ResManager.loadKDStringExt((String)"WBS\uff1a%1$s\u3001%2$s\u5df2\u5220\u9664\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"SupervisionWorkbenchFormPlugin_13", (String)"pmgt-pmfs-report", (Object[])new Object[0]), formName, billNo));
                    return;
                }
            }
            this.getModel().setValue("sysbill", (Object)sysBill, rowIndex);
            this.getModel().setValue("billid", (Object)billId, rowIndex);
            this.getModel().setValue("finishnumber", (Object)billNo, rowIndex);
            this.getModel().setValue("billnumber", (Object)projectSupervision.getString("bizbillno"), rowIndex);
            this.getModel().setValue("finishid", projectSupervision.getPkValue(), rowIndex);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        switch (name = e.getProperty().getName()) {
            case "org": {
                this.getModel().setValue("project", null);
                this.getView().updateView("project");
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "project": {
                DynamicObject org = (DynamicObject)this.getModel().getValue("org");
                if (org != null) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u7ec4\u7ec7\u3002", (String)"SupervisionWorkbenchFormPlugin_0", (String)"pmgt-pmfs-report", (Object[])new Object[0]));
                e.setCancel(true);
                break;
            }
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent e) {
        String fieldName = e.getFieldName();
        int rowIndex = e.getRowIndex();
        switch (fieldName) {
            case "finishnumber": {
                String pkValue = (String)this.getModel().getValue("finishid", rowIndex);
                this.openBill("pmfs_supervisionfinish", pkValue);
                break;
            }
            case "billnumber": {
                DynamicObject sysBill = (DynamicObject)this.getModel().getValue("sysbill", rowIndex);
                String formBillId = sysBill.getDynamicObject("sysbill").getString("number");
                String pkValue = (String)this.getModel().getValue("billid", rowIndex);
                this.openBill(formBillId, pkValue);
                break;
            }
        }
    }

    private void openBill(String formBillId, String pkValue) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("formId", formBillId);
        map.put("pkId", pkValue);
        FormShowParameter parameter = FormShowParameter.createFormShowParameter(map);
        parameter.setStatus(OperationStatus.VIEW);
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm(parameter);
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        String callBackId = e.getCallBackId();
        MessageBoxResult result = e.getResult();
        switch (callBackId) {
            case "reportCallBack": {
                if (result.getValue() != MessageBoxResult.Yes.getValue()) break;
                int currentRowIndex = Integer.parseInt(this.getPageCache().get(CURRENT_ROW_INDEX));
                this.createSupervisionFinishBill(currentRowIndex);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String key = closedCallBackEvent.getActionId();
        ReportList reportList = (ReportList)this.getControl(AP_REPORT_LIST);
        switch (key) {
            case "bindtask": {
                ListSelectedRowCollection returnData = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
                int currentRowIndex = this.getModel().getEntryCurrentRowIndex(AP_REPORT_LIST);
                if (!CollectionUtils.isNotEmpty((Collection)returnData)) break;
                String itemWarningLight = (String)reportList.getReportModel().getValue(currentRowIndex, "itemwarninglight");
                boolean finished = Arrays.asList(FinishStatusWarningEnum.ONTIMEFINISH.getValue(), FinishStatusWarningEnum.OVERDUEFINISH.getValue()).contains(itemWarningLight);
                if (finished) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7763\u5bfc\u4efb\u52a1\u5df2\u5b8c\u6210\u6c47\u62a5\uff0c\u4e0d\u5141\u8bb8\u66f4\u6539\u7ed1\u5b9a\u4efb\u52a1\u3002", (String)"SupervisionWorkbenchFormPlugin_14", (String)"pmgt-pmfs-report", (Object[])new Object[0]));
                    return;
                }
                Object taskId = returnData.get(0).getPrimaryKeyValue();
                DynamicObject oldBindTask = (DynamicObject)reportList.getReportModel().getValue(currentRowIndex, "task");
                DynamicObject newBindTask = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)"pmpt_task");
                if (!newBindTask.getBoolean("isleaf")) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u660e\u7ec6\u4efb\u52a1\u3002", (String)"SupervisionWorkbenchFormPlugin_7", (String)"pmgt-pmfs-report", (Object[])new Object[0]));
                    return;
                }
                int rowCount = reportList.getReportModel().getRowCount();
                boolean repeat = IntStream.range(1, rowCount + 1).filter(rowIndex -> rowIndex != currentRowIndex).mapToObj(rowIndex -> (DynamicObject)reportList.getReportModel().getValue(rowIndex, "task")).filter(Objects::nonNull).anyMatch(task -> task.getPkValue().equals(taskId));
                if (repeat) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u4efb\u52a1\u5df2\u7ed1\u5b9a\u7763\u5bfc\u5de5\u4f5c\u9879\uff0c\u65e0\u6cd5\u91cd\u590d\u7ed1\u5b9a\u3002", (String)"SupervisionWorkbenchFormPlugin_15", (String)"pmgt-pmfs-report", (Object[])new Object[0]));
                    return;
                }
                String workExecutionId = (String)reportList.getReportModel().getValue(currentRowIndex, "workitemid");
                DynamicObject workExecution = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(workExecutionId), (String)"pmbs_workexecution");
                workExecution.set("task", (Object)newBindTask);
                SaveServiceHelper.update((DynamicObject)workExecution);
                ArrayList<DynamicObject> tasks = new ArrayList<DynamicObject>(2);
                if (oldBindTask != null) {
                    oldBindTask = BusinessDataServiceHelper.loadSingle((Object)oldBindTask.getPkValue(), (String)"pmpt_task");
                    oldBindTask.set("workitem", null);
                    tasks.add(oldBindTask);
                }
                newBindTask.set("workitem", workExecution.getPkValue());
                tasks.add(newBindTask);
                SaveServiceHelper.update((DynamicObject[])tasks.toArray(new DynamicObject[0]));
                this.getView().getPageCache().put(CURRENT_ROW_INDEX, String.valueOf(currentRowIndex));
                this.getView().invokeOperation("refresh");
                break;
            }
        }
    }

    private void createSupervisionFinishBill(int currentRowIndex) {
        BillShowParameter formShowParameter = new BillShowParameter();
        formShowParameter.setFormId("pmfs_supervisionfinish");
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.setCustomParam("source", (Object)REPORT);
        Object orgId = ((DynamicObject)this.getModel().getValue("org")).getPkValue();
        formShowParameter.setCustomParam("org", orgId);
        Object projectId = ((DynamicObject)this.getModel().getValue("project")).getPkValue();
        formShowParameter.setCustomParam("project", projectId);
        ReportList reportList = (ReportList)this.getControl(AP_REPORT_LIST);
        String workItemId = (String)reportList.getReportModel().getValue(currentRowIndex, "workitemid");
        formShowParameter.setCustomParam("workitem", (Object)Long.parseLong(workItemId));
        Date actualEndTime = (Date)reportList.getReportModel().getValue(currentRowIndex, "actualendtime");
        formShowParameter.setCustomParam("actualendtime", (Object)actualEndTime);
        String sysBillId = (String)reportList.getReportModel().getValue(currentRowIndex, "sysbillid");
        formShowParameter.setCustomParam("sysbill", (Object)Long.parseLong(sysBillId));
        this.getView().showForm((FormShowParameter)formShowParameter);
    }
}

