/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmfs.business.helper;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.basedataref.BaseDataCheckRefrence;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmgt.pmbs.common.enums.EnableEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmbs.common.enums.projectinitialize.WBSTypeEnum;
import kd.pmgt.pmfs.common.enums.TimeTypeEnum;
import kd.pmgt.pmfs.common.utils.PmfsExcelUtil;
import kd.pmgt.pmfs.common.utils.vo.ExcelPropertiesVO;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectInitializeHelper {
    private static final Log logger = LogFactory.getLog(ProjectInitializeHelper.class);
    public static final String[] COLUMNKEY = new String[]{"splitentry_wbsnumber", "splitentry_wbsname", "splitentry_type", "splitentry_milestone", "splitentry_planstarttime", "splitentry_planendtime", "splitentry_qty", "splitentry_unit", "splitentry_price", "splitentry_remark", "splitentry_schedule", "splitentry_completeamt", "pid"};
    private static ProjectInitializeHelper projectInitializeHelper = new ProjectInitializeHelper();

    public static ProjectInitializeHelper getInstance() {
        return projectInitializeHelper;
    }

    public String getFileName() {
        return ResManager.loadKDString((String)"\u9879\u76ee\u62c6\u5206\u8bbe\u7f6e", (String)"ProjectInitializeHelper_0", (String)"pmgt-pmfs-business", (Object[])new Object[0]);
    }

    public String getSheetName() {
        return ResManager.loadKDString((String)"\u9879\u76ee\u62c6\u5206\u8bbe\u7f6e\u5217\u8868", (String)"ProjectInitializeHelper_1", (String)"pmgt-pmfs-business", (Object[])new Object[0]);
    }

    public String[] getHeaderArray() {
        return new String[]{ResManager.loadKDString((String)"WBS\u7f16\u7801", (String)"ProjectInitializeHelper_2", (String)"pmgt-pmfs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"WBS\u540d\u79f0", (String)"ProjectInitializeHelper_3", (String)"pmgt-pmfs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7c7b\u578b", (String)"ProjectInitializeHelper_4", (String)"pmgt-pmfs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u91cc\u7a0b\u7891", (String)"ProjectInitializeHelper_5", (String)"pmgt-pmfs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8ba1\u5212\u5f00\u59cb\u65f6\u95f4", (String)"ProjectInitializeHelper_6", (String)"pmgt-pmfs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8ba1\u5212\u5b8c\u6210\u65f6\u95f4", (String)"ProjectInitializeHelper_7", (String)"pmgt-pmfs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6570\u91cf", (String)"ProjectInitializeHelper_8", (String)"pmgt-pmfs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5355\u4f4d", (String)"ProjectInitializeHelper_9", (String)"pmgt-pmfs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5355\u4ef7", (String)"ProjectInitializeHelper_10", (String)"pmgt-pmfs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5907\u6ce8", (String)"ProjectInitializeHelper_11", (String)"pmgt-pmfs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5df2\u5b8c\u6210\u8fdb\u5ea6\uff08%\uff09", (String)"ProjectInitializeHelper_22", (String)"pmgt-pmfs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5df2\u5b8c\u6210\u91d1\u989d", (String)"ProjectInitializeHelper_23", (String)"pmgt-pmfs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e0a\u7ea7", (String)"ProjectInitializeHelper_12", (String)"pmgt-pmfs-business", (Object[])new Object[0])};
    }

    private String getYesAlias() {
        return ResManager.loadKDString((String)"\u662f", (String)"ProjectInitializeHelper_13", (String)"pmgt-pmfs-business", (Object[])new Object[0]);
    }

    public void syncProInitEntry2WBS(DynamicObject model) {
        DynamicObjectCollection splitEntryCollection = model.getDynamicObjectCollection("splitentry");
        long projectId = Long.parseLong(model.getDynamicObject("project").getPkValue().toString());
        DynamicObject[] dbWbsCollection = new DynamicObject[]{};
        if (projectId != 0L) {
            QFilter projectFilter = new QFilter("project", "=", (Object)projectId);
            dbWbsCollection = BusinessDataServiceHelper.load((String)"pmbs_wbs", (String)String.join((CharSequence)",", "id", "enable"), (QFilter[])new QFilter[]{projectFilter});
        }
        DynamicObject[] newWbsCollection = new DynamicObject[splitEntryCollection.size()];
        HashMap<Long, DynamicObject> split2DbWbs = new HashMap<Long, DynamicObject>(splitEntryCollection.size());
        for (int index = 0; index < splitEntryCollection.size(); ++index) {
            DynamicObject newWbs2;
            DynamicObject[] splitEntry = (DynamicObject[])splitEntryCollection.get(index);
            DynamicObject dbWbs = this.findDbWbs(dbWbsCollection, (DynamicObject)splitEntry, split2DbWbs);
            newWbsCollection[index] = newWbs2 = this.fillNewWbs(model, (DynamicObject)splitEntry, dbWbs, split2DbWbs);
        }
        Map<Long, DynamicObject> dataMap = Arrays.stream(newWbsCollection).collect(Collectors.toMap(entry -> Long.parseLong(entry.getPkValue().toString()), entry -> entry));
        for (DynamicObject newWbs3 : newWbsCollection) {
            DynamicObject parent = newWbs3.getDynamicObject("parent");
            if (parent != null) {
                long parentId = Long.parseLong(parent.getPkValue().toString());
                String parentLongNumber = dataMap.get(parentId).getString("longnumber");
                String currentLongNumber = String.format("%s.%s", parentLongNumber, newWbs3.get("number"));
                newWbs3.set("longnumber", (Object)currentLongNumber);
                continue;
            }
            newWbs3.set("longnumber", newWbs3.get("number"));
        }
        List<Object> dbWbsDeleteCollection = new ArrayList();
        for (DynamicObject dbWbs : dbWbsCollection) {
            boolean contain = Arrays.stream(newWbsCollection).anyMatch(newWbs -> Long.parseLong(newWbs.getPkValue().toString()) == Long.parseLong(dbWbs.getPkValue().toString()));
            if (contain || dbWbs.getInt("enable") != 1) continue;
            dbWbs.set("enable", (Object)0);
            dbWbsDeleteCollection.add(dbWbs);
        }
        if (CollectionUtils.isNotEmpty(dbWbsDeleteCollection = dbWbsDeleteCollection.stream().filter(Objects::nonNull).collect(Collectors.toList()))) {
            SaveServiceHelper.update((DynamicObject[])dbWbsDeleteCollection.toArray(new DynamicObject[0]));
        }
        SaveServiceHelper.save((DynamicObject[])newWbsCollection);
    }

    /*
     * WARNING - void declaration
     */
    public List<DynamicObject> checkSyncProInitEntry2WBSResult(DynamicObject model) {
        void var12_16;
        DynamicObject[] splitEntry;
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>();
        DynamicObjectCollection splitEntryCollection = model.getDynamicObjectCollection("splitentry");
        long projectId = Long.parseLong(model.getDynamicObject("project").getPkValue().toString());
        DynamicObject[] dbWbsCollection = new DynamicObject[]{};
        if (projectId != 0L) {
            QFilter projectFilter = new QFilter("project", "=", (Object)projectId);
            dbWbsCollection = BusinessDataServiceHelper.load((String)"pmbs_wbs", (String)String.join((CharSequence)",", "id", "enable"), (QFilter[])new QFilter[]{projectFilter});
        }
        DynamicObject[] newWbsCollection = new DynamicObject[splitEntryCollection.size()];
        HashMap<Long, DynamicObject> split2DbWbs = new HashMap<Long, DynamicObject>(splitEntryCollection.size());
        for (int index = 0; index < splitEntryCollection.size(); ++index) {
            DynamicObject dynamicObject;
            splitEntry = (DynamicObject[])splitEntryCollection.get(index);
            DynamicObject dbWbs = this.findDbWbs(dbWbsCollection, (DynamicObject)splitEntry, split2DbWbs);
            newWbsCollection[index] = dynamicObject = this.fillNewWbs(model, (DynamicObject)splitEntry, dbWbs, split2DbWbs);
        }
        Map<Long, DynamicObject> dataMap = Arrays.stream(newWbsCollection).collect(Collectors.toMap(entry -> Long.parseLong(entry.getPkValue().toString()), entry -> entry));
        splitEntry = newWbsCollection;
        int dbWbs = splitEntry.length;
        boolean bl = false;
        while (var12_16 < dbWbs) {
            DynamicObject newWbs3 = splitEntry[var12_16];
            DynamicObject parent = newWbs3.getDynamicObject("parent");
            if (parent != null) {
                long parentId = Long.parseLong(parent.getPkValue().toString());
                String parentLongNumber = dataMap.get(parentId).getString("longnumber");
                String currentLongNumber = String.format("%s.%s", parentLongNumber, newWbs3.get("number"));
                newWbs3.set("longnumber", (Object)currentLongNumber);
            } else {
                newWbs3.set("longnumber", newWbs3.get("number"));
            }
            ++var12_16;
        }
        List<Object> dbWbsDeleteCollection = new ArrayList();
        for (int i = 0; i < dbWbsCollection.length; ++i) {
            DynamicObject dynamicObject = dbWbsCollection[i];
            boolean contain = Arrays.stream(newWbsCollection).anyMatch(newWbs -> Long.parseLong(newWbs.getPkValue().toString()) == Long.parseLong(dbWbs.getPkValue().toString()));
            if (contain || dynamicObject.getInt("enable") != 1) continue;
            dynamicObject.set("enable", (Object)0);
            dbWbsDeleteCollection.add(dynamicObject);
        }
        dbWbsDeleteCollection = dbWbsDeleteCollection.stream().filter(Objects::nonNull).collect(Collectors.toList());
        for (DynamicObject dynamicObject : dbWbsDeleteCollection) {
            if (!projectInitializeHelper.checkWBSIsRefenced((Long)dynamicObject.getPkValue())) continue;
            result.add(dynamicObject);
        }
        return result;
    }

    @NotNull
    private DynamicObject fillNewWbs(DynamicObject model, DynamicObject splitEntry, DynamicObject dbWbs, Map<Long, DynamicObject> split2DbWbs) {
        MainEntityType dynamicObjectType = EntityMetadataCache.getDataEntityType((String)"pmbs_wbs");
        DynamicObject newWbs = new DynamicObject((DynamicObjectType)dynamicObjectType);
        Date now = new Date();
        if (dbWbs != null) {
            newWbs = BusinessDataServiceHelper.loadSingle((Object)dbWbs.getPkValue(), (String)"pmbs_wbs");
        } else {
            newWbs.set("id", splitEntry.getPkValue());
            newWbs.set("masterid", splitEntry.getPkValue());
            newWbs.set("resourcewbsid", splitEntry.getPkValue());
            newWbs.set("createtime", (Object)now);
        }
        newWbs.set("modifytime", (Object)now);
        newWbs.set("project", model.get("project"));
        newWbs.set("projectinitializeid", model.getPkValue());
        newWbs.set("org", model.get("org"));
        newWbs.set("createorg", model.get("org"));
        newWbs.set("useorg", model.get("org"));
        newWbs.set("creator", model.get("creator"));
        newWbs.set("modifier", model.get("modifier"));
        newWbs.set("enable", (Object)EnableEnum.ENABLE.getValue());
        newWbs.set("status", (Object)StatusEnum.CHECKED.getValue());
        newWbs.set("number", splitEntry.get("splitentry_wbsnumber"));
        newWbs.set("name", splitEntry.get("splitentry_wbsname"));
        newWbs.set("remark", splitEntry.get("splitentry_remark"));
        newWbs.set("type", splitEntry.get("splitentry_type"));
        newWbs.set("milestone", splitEntry.get("splitentry_milestone"));
        newWbs.set("planstarttime", splitEntry.get("splitentry_planstarttime"));
        newWbs.set("planendtime", splitEntry.get("splitentry_planendtime"));
        newWbs.set("qty", splitEntry.get("splitentry_qty"));
        newWbs.set("unit", splitEntry.get("splitentry_unit"));
        newWbs.set("price", splitEntry.get("splitentry_price"));
        newWbs.set("amount", splitEntry.get("splitentry_amount"));
        newWbs.set("schedule", splitEntry.get("splitentry_schedule"));
        newWbs.set("completeamt", splitEntry.get("splitentry_completeamt"));
        newWbs.set("level", splitEntry.get("level"));
        newWbs.set("isleaf", splitEntry.get("isleaf"));
        newWbs.set("order", splitEntry.get("seq"));
        newWbs.set("projectstatus", splitEntry.get("splitentry_projectstatus"));
        DynamicObjectCollection splitEntryCollection = model.getDynamicObjectCollection("splitentry");
        Object parentId = splitEntry.get("pid");
        newWbs.set("parent", null);
        if (parentId != null && Long.parseLong(parentId.toString()) != 0L) {
            DynamicObject parentWbs = split2DbWbs.get(Long.parseLong(parentId.toString()));
            if (parentWbs != null) {
                newWbs.set("parent", (Object)parentWbs);
            } else {
                DynamicObject newParent = splitEntryCollection.stream().filter(entry -> StringUtils.equals((CharSequence)entry.getPkValue().toString(), (CharSequence)parentId.toString())).findFirst().orElse(null);
                if (newParent != null) {
                    newWbs.set("parent", (Object)newParent);
                }
            }
        }
        return newWbs;
    }

    @Nullable
    private DynamicObject findDbWbs(DynamicObject[] dbWbsList, DynamicObject splitEntry, Map<Long, DynamicObject> split2DbWbs) {
        DynamicObject originalWbs;
        DynamicObject[] ids;
        DynamicObject wbs = Arrays.stream(dbWbsList).filter(dbWbs -> splitEntry.getLong("resourcewbsid") == dbWbs.getLong("masterid")).findFirst().orElse(null);
        if (wbs == null && (ids = BusinessDataServiceHelper.load((String)"pmbs_wbs", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "=", splitEntry.getPkValue())})).length > 0 && (originalWbs = BusinessDataServiceHelper.loadSingle((Object)splitEntry.getPkValue(), (String)"pmbs_wbs")) != null) {
            wbs = originalWbs;
        }
        split2DbWbs.put(Long.parseLong(splitEntry.getPkValue().toString()), wbs);
        logger.info(String.format("splitEntry#info: %s , findDbWbs#wbs#info: %s", splitEntry, wbs));
        return wbs;
    }

    public void updateOldModelData(DynamicObject model, boolean enabled) {
        Long resourceProjectInitID = model.getLong("resourceprojectinitid");
        if (0L == resourceProjectInitID) {
            return;
        }
        int version = model.getInt("version");
        QFilter filter = new QFilter("resourceprojectinitid", "=", (Object)resourceProjectInitID).or("id", "=", (Object)resourceProjectInitID).and("version", "=", (Object)(version - 1));
        DynamicObject perVersionModel = BusinessDataServiceHelper.loadSingle((String)"pmfs_projectinitialize", (String)this.getSelectProperties(), (QFilter[])new QFilter[]{filter});
        perVersionModel.set("executiveversion", (Object)enabled);
        SaveServiceHelper.update((DynamicObject)perVersionModel);
    }

    public void backOffLastVersion(DynamicObject model, boolean enabled) {
        Long resourceProjectInitID = model.getLong("resourceprojectinitid");
        int version = model.getInt("version");
        QFilter filter = resourceProjectInitID == 0L ? new QFilter("id", "=", model.getPkValue()).and("version", "=", (Object)version) : new QFilter("id", "=", (Object)resourceProjectInitID).and("version", "=", (Object)(version - 1));
        DynamicObject perVersionModel = BusinessDataServiceHelper.loadSingle((String)"pmfs_projectinitialize", (String)this.getSelectProperties(), (QFilter[])new QFilter[]{filter});
        perVersionModel = BusinessDataServiceHelper.loadSingle((Object)perVersionModel.getPkValue(), (String)"pmfs_projectinitialize");
        perVersionModel.set("executiveversion", (Object)enabled);
        SaveServiceHelper.update((DynamicObject)perVersionModel);
        DynamicObject project = model.getDynamicObject("project");
        QFilter projectIdFilter = new QFilter("project", "=", project.getPkValue());
        DynamicObject[] oldWbses = BusinessDataServiceHelper.load((String)"pmbs_wbs", (String)"enable", (QFilter[])new QFilter[]{projectIdFilter});
        MainEntityType dt = MetadataServiceHelper.getDataEntityType((String)"pmbs_wbs");
        for (DynamicObject wbs : oldWbses) {
            wbs.set("enable", (Object)0);
        }
        if (version != 1) {
            SaveServiceHelper.update((DynamicObject[])oldWbses);
        } else {
            DeleteServiceHelper.delete((IDataEntityType)dt, (Object[])Arrays.stream(oldWbses).map(DataEntityBase::getPkValue).toArray());
        }
        if (version != 1) {
            this.syncProInitEntry2WBS(perVersionModel);
        }
    }

    public String getSelectProperties() {
        return String.join((CharSequence)",", "id", "executiveversion", "splitentry");
    }

    public void importTask2ModelEntry(IDataModel dataModel, IFormView view, JSONArray jsonArray) {
        DynamicObject model = dataModel.getDataEntity(true);
        DynamicObjectCollection splitEntry = model.getDynamicObjectCollection("splitentry");
        for (DynamicObject entry : splitEntry) {
            DynamicObjectCollection subSplitEntrys = entry.getDynamicObjectCollection("subsplitentry");
            subSplitEntrys.clear();
            dataModel.updateEntryCache(subSplitEntrys);
        }
        view.updateView("subsplitentry");
        splitEntry.clear();
        HashMap<String, DynamicObjectCollection> parentMap = new HashMap<String, DynamicObjectCollection>();
        StringBuilder errorMsg = new StringBuilder();
        for (int i = 0; i < jsonArray.size(); ++i) {
            Object row = jsonArray.get(i);
            JSONArray rowData = JSONArray.parseArray((String)row.toString());
            DynamicObject entry = splitEntry.addNew();
            Long entryId = this.createID(entry.getDynamicObjectType());
            entry.set("id", (Object)entryId);
            entry.set("resourcewbsid", (Object)entryId);
            StringBuilder columnErrorMsg = new StringBuilder();
            Date planStartTime = null;
            Date planEndTime = null;
            for (Object column : rowData) {
                ArrayList mustInputField;
                JSONObject columnData = JSONArray.parseObject((String)column.toString());
                String columnKey = columnData.getString("columnKey");
                String columnName = columnData.getString("columnName");
                Object cellValue = Optional.ofNullable(columnData.get((Object)"cellValue")).orElse("");
                cellValue = this.handleCellValue(columnKey, cellValue);
                if ("splitentry_planstarttime".equals(columnKey)) {
                    planStartTime = (Date)cellValue;
                }
                if ("splitentry_planendtime".equals(columnKey)) {
                    planEndTime = (Date)cellValue;
                }
                if ((mustInputField = Lists.newArrayList((Object[])new String[]{"splitentry_wbsnumber", "splitentry_wbsname"})).contains(columnKey) && StringUtils.isBlank((Object)cellValue)) {
                    String columnErrorMsgStr = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff0c%2$s\u672a\u586b\u5199\u3002", (String)"ProjectInitializeHelper_30", (String)"pmgt-pmfs-business", (Object[])new Object[0]), i + 4, String.format("\"%s\"", columnName.replace("*", "")));
                    columnErrorMsg.append(columnErrorMsgStr);
                    columnErrorMsg.append("\r\n");
                }
                if ("splitentry_wbsname".equals(columnKey)) {
                    List collect;
                    boolean hasName;
                    String wbsName = (String)cellValue;
                    if (splitEntry.size() > 1 && (hasName = (collect = splitEntry.stream().map(dyn -> dyn.getLocaleString("splitentry_wbsname").getLocaleValue()).collect(Collectors.toList())).contains(wbsName))) {
                        String columnErrorMsgStr = String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\uff0c\u6b64\u884c\u6570\u636e\u6709\u8bef\uff0cWBS\u540d\u79f0\u6709\u91cd\u590d\uff0c\u8bf7\u5f55\u5165\u975e\u91cd\u590dWBS\u540d\u79f0\u3002", (String)"ProjectInitializeHelper_31", (String)"pmgt-pmfs-business", (Object[])new Object[0]), i + 4);
                        columnErrorMsg.append(columnErrorMsgStr);
                        columnErrorMsg.append("\r\n");
                    }
                }
                if (null != cellValue && "pid".equals(columnKey)) {
                    DynamicObjectCollection col = new DynamicObjectCollection();
                    DynamicObjectCollection splitEntryCol = (DynamicObjectCollection)parentMap.get(cellValue.toString());
                    if (null != splitEntryCol) {
                        col = splitEntryCol;
                    }
                    col.add((Object)entry);
                    parentMap.put(cellValue.toString(), col);
                    continue;
                }
                try {
                    if ("splitentry_wbsname".equals(columnKey)) {
                        LocaleString localeString = new LocaleString((String)cellValue);
                        entry.set(columnKey, (Object)localeString);
                        continue;
                    }
                    entry.set(columnKey, cellValue);
                }
                catch (ConversionException e) {
                    String columnErrorMsgStr = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff0c%2$s\u5b57\u6bb5\u6570\u636e\u7c7b\u578b\u4e0d\u5339\u914d\uff0c\u68c0\u67e5\u540e\u4fee\u6539\u3002", (String)"ProjectInitializeHelper_32", (String)"pmgt-pmfs-business", (Object[])new Object[0]), i + 4, columnName);
                    columnErrorMsg.append(columnErrorMsgStr);
                    columnErrorMsg.append("\r\n");
                }
            }
            if (planStartTime != null && planEndTime != null && planStartTime.getTime() > planEndTime.getTime()) {
                String columnErrorMsgStr = String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\uff0c\u8ba1\u5212\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u65e9\u4e8e\u8ba1\u5212\u5f00\u59cb\u65f6\u95f4\u3002", (String)"ProjectInitializeHelper_33", (String)"pmgt-pmfs-business", (Object[])new Object[0]), i + 4);
                columnErrorMsg.append(columnErrorMsgStr);
                columnErrorMsg.append("\r\n");
            }
            if (StringUtils.isNotBlank((CharSequence)columnErrorMsg.toString())) {
                errorMsg.append((CharSequence)columnErrorMsg);
                continue;
            }
            this.handleEntrySpecialData(entry);
        }
        if (StringUtils.isNotBlank((CharSequence)errorMsg.toString())) {
            throw new KDBizException(errorMsg.toString());
        }
        this.handleEntryParentRelation(splitEntry, parentMap);
        dataModel.updateCache();
        EntryGrid entryGrid = (EntryGrid)view.getControl("splitentry");
        entryGrid.setCollapse(false);
        view.updateView("splitentry");
    }

    public void exportModelEntry2Task(IFormView view, DynamicObject model) {
        DynamicObjectCollection splitEntry = model.getDynamicObjectCollection("splitentry");
        PmfsExcelUtil pmfsExcelUtil = new PmfsExcelUtil(COLUMNKEY, this.getFileName(), this.getSheetName(), this.getHeaderArray());
        pmfsExcelUtil.setMustFillColumn(Arrays.asList(ResManager.loadKDString((String)"WBS\u7f16\u7801", (String)"ProjectInitializeHelper_2", (String)"pmgt-pmfs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"WBS\u540d\u79f0", (String)"ProjectInitializeHelper_3", (String)"pmgt-pmfs-business", (Object[])new Object[0])));
        pmfsExcelUtil.setTipVOList(this.getExcelProperties());
        JSONArray data = new JSONArray();
        for (DynamicObject entry : splitEntry) {
            this.handleJsonData(model, entry, data);
        }
        pmfsExcelUtil.exportModel(view, data);
    }

    public Long createID(DynamicObjectType dynamicObjectType) {
        return ORM.create().genLongId((IDataEntityType)dynamicObjectType);
    }

    public boolean checkWBSIsRefenced(Long pk) {
        BaseDataCheckRefrence checkReference = new BaseDataCheckRefrence();
        Set checkRefEntityIds = checkReference.getCheckRefEntityIds();
        this.getRefencedEntityType(checkRefEntityIds);
        Set ignoreRefEntityIds = checkReference.getIgnoreRefEntityIds();
        ignoreRefEntityIds.add("pmbs_wbs");
        checkReference.setDraftValidReference(true);
        BasedataEntityType basedataEntityType = (BasedataEntityType)EntityMetadataCache.getDataEntityType((String)"pmbs_wbs");
        return checkReference.isRefrenced(basedataEntityType, (Object)pk);
    }

    public boolean checkWBSIsRefenced(List<Long> wbsPks) {
        return wbsPks.stream().anyMatch(this::checkWBSIsRefenced);
    }

    public boolean checkWBSIsRefenced(DynamicObject projectInitializeObject) {
        DynamicObjectCollection splitEntry = projectInitializeObject.getDynamicObjectCollection("splitentry");
        return splitEntry.stream().anyMatch(entry -> {
            Long resourceWBSID = entry.getLong("resourcewbsid");
            QFilter filter = resourceWBSID != 0L ? new QFilter("id", "=", (Object)resourceWBSID) : new QFilter("id", "=", entry.getPkValue());
            DynamicObject wbs = BusinessDataServiceHelper.loadSingle((String)"pmbs_wbs", (String)"id", (QFilter[])new QFilter[]{filter});
            return this.checkWBSIsRefenced((Long)wbs.getPkValue());
        });
    }

    public void checkCanRevise(Long pk) {
        DynamicObject projectInitialize = BusinessDataServiceHelper.loadSingle((Object)pk, (String)"pmfs_projectinitialize");
        String billStatus = projectInitialize.getString("billstatus");
        if (!StatusEnum.CHECKED.getValue().equals(billStatus)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001\u4e3a%s\uff0c\u65e0\u6cd5\u4fee\u8ba2\u3002", (String)"ProjectInitializeHelper_34", (String)"pmgt-pmfs-business", (Object[])new Object[0]), StatusEnum.getEnumByValue((Object)billStatus).getName()));
        }
        DynamicObject project = projectInitialize.getDynamicObject("project");
        QFilter projectFilter = new QFilter("project", "=", project.getPkValue());
        QFilter statusFilter = new QFilter("billstatus", "!=", (Object)StatusEnum.CHECKED.getValue());
        if (QueryServiceHelper.exists((String)"pmfs_projectinitialize", (QFilter[])new QFilter[]{projectFilter, statusFilter})) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672c\u9879\u76ee\u5b58\u5728\u5c1a\u672a\u5ba1\u6838\u5b8c\u6bd5\u7684\u4fee\u8ba2\u7248\u672c\uff0c\u4e0d\u53ef\u91cd\u590d\u4fee\u8ba2\u3002", (String)"ProjectInitializeHelper_36", (String)"pmgt-pmfs-business", (Object[])new Object[0]));
        }
    }

    public List<ExcelPropertiesVO> getExcelProperties() {
        return Arrays.asList(new ExcelPropertiesVO("splitentry_wbsnumber", 3, 0, ResManager.loadKDString((String)"\u6587\u672c", (String)"ProjectInitializeHelper_15", (String)"pmgt-pmfs-business", (Object[])new Object[0])), new ExcelPropertiesVO("splitentry_wbsname", 3, 1, ResManager.loadKDString((String)"\u6587\u672c", (String)"ProjectInitializeHelper_15", (String)"pmgt-pmfs-business", (Object[])new Object[0])), new ExcelPropertiesVO("splitentry_type", 3, 2, null, new String[]{WBSTypeEnum.Branch_Project.getName(), WBSTypeEnum.Divide_Project.getName(), WBSTypeEnum.Single_Project.getName(), WBSTypeEnum.Unit_Project.getName()}), new ExcelPropertiesVO("splitentry_milestone", 3, 3, null, new String[]{" ", ResManager.loadKDString((String)"\u662f", (String)"ProjectInitializeHelper_13", (String)"pmgt-pmfs-business", (Object[])new Object[0])}), new ExcelPropertiesVO("splitentry_planstarttime", 3, 4, ResManager.loadKDString((String)"\u65e5\u671f\u683c\u5f0f\uff1ayyyy/MM/dd HH:mm:ss", (String)"ProjectInitializeHelper_16", (String)"pmgt-pmfs-business", (Object[])new Object[0])), new ExcelPropertiesVO("splitentry_planendtime", 3, 5, ResManager.loadKDString((String)"\u65e5\u671f\u683c\u5f0f\uff1ayyyy/MM/dd HH:mm:ss", (String)"ProjectInitializeHelper_16", (String)"pmgt-pmfs-business", (Object[])new Object[0])), new ExcelPropertiesVO("splitentry_unit", 3, 7, ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\uff1a\u652f\u6301\u5f55\u5165\u5355\u4f4d\u540d\u79f0", (String)"ProjectInitializeHelper_17", (String)"pmgt-pmfs-business", (Object[])new Object[0])));
    }

    protected void handleJsonData(DynamicObject model, DynamicObject entry, JSONArray datas) {
        String exportCompleteAmt;
        String exportPrice;
        DynamicObject measureUnit;
        JSONObject jsonObject = new JSONObject();
        String timeType = model.getString("timetype");
        SimpleDateFormat simpleDateFormat = TimeTypeEnum.FORMAT2DAY.getValue().equals(timeType) ? new SimpleDateFormat("yyyy/MM/dd") : new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        jsonObject.put("splitentry_wbsnumber", entry.get("splitentry_wbsnumber"));
        jsonObject.put("splitentry_wbsname", entry.get("splitentry_wbsname"));
        if (entry.getString("splitentry_type") != null && !entry.getString("splitentry_type").isEmpty()) {
            String type = WBSTypeEnum.getEnumByValue((Object)entry.getString("splitentry_type")).getName();
            jsonObject.put("splitentry_type", (Object)type);
        }
        String mileStone = null;
        if ("YES".equals(entry.getString("splitentry_milestone"))) {
            mileStone = ResManager.loadKDString((String)"\u662f", (String)"ProjectInitializeHelper_13", (String)"pmgt-pmfs-business", (Object[])new Object[0]);
        }
        jsonObject.put("splitentry_milestone", mileStone);
        if (null != entry.getDate("splitentry_planstarttime")) {
            String planStartTime = simpleDateFormat.format(entry.getDate("splitentry_planstarttime"));
            jsonObject.put("splitentry_planstarttime", (Object)planStartTime);
        }
        if (null != entry.getDate("splitentry_planendtime")) {
            String planEndTime = simpleDateFormat.format(entry.getDate("splitentry_planendtime"));
            jsonObject.put("splitentry_planendtime", (Object)planEndTime);
        }
        jsonObject.put("splitentry_unit", (measureUnit = entry.getDynamicObject("splitentry_unit")) != null ? measureUnit.get("name") : null);
        BigDecimal qty = entry.getBigDecimal("splitentry_qty");
        jsonObject.put("splitentry_qty", qty.compareTo(BigDecimal.ZERO) == 0 ? Integer.valueOf(0) : qty.stripTrailingZeros().toPlainString());
        BigDecimal price = entry.getBigDecimal("splitentry_price");
        DynamicObject currency = model.getDynamicObject("currency");
        if (currency != null) {
            price = price.setScale(currency.getInt("priceprecision"), 4);
            exportPrice = String.join((CharSequence)"", currency.getString("sign"), String.valueOf(price));
        } else {
            exportPrice = String.valueOf(price);
        }
        jsonObject.put("splitentry_price", (Object)exportPrice);
        jsonObject.put("splitentry_remark", entry.get("splitentry_remark"));
        BigDecimal schedule = entry.getBigDecimal("splitentry_schedule");
        jsonObject.put("splitentry_schedule", (Object)schedule.setScale(2));
        BigDecimal completeAmt = entry.getBigDecimal("splitentry_completeamt");
        if (currency != null) {
            completeAmt = completeAmt.setScale(currency.getInt("amtprecision"), 4);
            exportCompleteAmt = String.join((CharSequence)"", currency.getString("sign"), String.valueOf(completeAmt));
        } else {
            exportCompleteAmt = String.valueOf(completeAmt);
        }
        jsonObject.put("splitentry_completeamt", (Object)exportCompleteAmt);
        if (entry.getLong("pid") != 0L) {
            DynamicObjectCollection splitEntry = model.getDynamicObjectCollection("splitentry");
            for (DynamicObject dy : splitEntry) {
                if (((Long)dy.getPkValue()).longValue() != entry.getLong("pid")) continue;
                jsonObject.put("pid", (Object)dy.getString("splitentry_wbsname"));
            }
        }
        datas.add((Object)jsonObject);
    }

    protected void handleEntrySpecialData(DynamicObject entry) {
        entry.set("splitentry_amount", (Object)entry.getBigDecimal("splitentry_qty").multiply(entry.getBigDecimal("splitentry_price")));
    }

    protected Object handleCellValue(String columnKey, Object cellValue) {
        Object value = null;
        switch (columnKey) {
            case "splitentry_wbsnumber": 
            case "splitentry_wbsname": 
            case "splitentry_remark": {
                if (cellValue instanceof BigDecimal) {
                    value = String.valueOf(((BigDecimal)cellValue).longValue());
                    break;
                }
                value = cellValue;
                break;
            }
            case "splitentry_type": {
                if (WBSTypeEnum.Single_Project.getName().equals(cellValue.toString())) {
                    value = WBSTypeEnum.Single_Project.getValue();
                    break;
                }
                if (WBSTypeEnum.Unit_Project.getName().equals(cellValue.toString())) {
                    value = WBSTypeEnum.Unit_Project.getValue();
                    break;
                }
                if (WBSTypeEnum.Branch_Project.getName().equals(cellValue.toString())) {
                    value = WBSTypeEnum.Branch_Project.getValue();
                    break;
                }
                if (WBSTypeEnum.Divide_Project.getName().equals(cellValue.toString())) {
                    value = WBSTypeEnum.Divide_Project.getValue();
                    break;
                }
                value = null;
                break;
            }
            case "splitentry_planstarttime": 
            case "splitentry_planendtime": {
                if (cellValue instanceof Date) {
                    value = cellValue;
                    break;
                }
                if (cellValue instanceof String) {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
                    try {
                        value = simpleDateFormat.parse(cellValue.toString());
                    }
                    catch (ParseException e) {
                        value = null;
                    }
                    break;
                }
                if (!(cellValue instanceof Long)) break;
                value = new Date((Long)cellValue);
                break;
            }
            case "splitentry_milestone": {
                if (cellValue != null && this.getYesAlias().equals(cellValue)) {
                    value = "YES";
                    break;
                }
                value = null;
                break;
            }
            case "splitentry_unit": {
                if (null == cellValue) break;
                String cellValueStr = cellValue.toString();
                value = BusinessDataServiceHelper.loadSingle((String)"bd_measureunits", (String)String.join((CharSequence)",", "number", "name"), (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)cellValueStr).or("name", "=", (Object)cellValueStr)});
                break;
            }
            default: {
                value = cellValue;
            }
        }
        return value;
    }

    protected void getRefencedEntityType(Set<String> checkRefEntityIds) {
        checkRefEntityIds.add("pmfs_progressreport");
        checkRefEntityIds.add("pmfs_projectaccept");
        checkRefEntityIds.add("pmct_outcontract");
        checkRefEntityIds.add("pmpt_task");
    }

    private void handleEntryParentRelation(DynamicObjectCollection entries, Map<String, DynamicObjectCollection> parentMap) {
        for (DynamicObject entry : entries) {
            if (parentMap.get(entry.getString("splitentry_wbsname")) == null) continue;
            DynamicObjectCollection children = parentMap.get(entry.getString("splitentry_wbsname"));
            for (DynamicObject child : children) {
                child.set("pid", entry.getPkValue());
            }
        }
    }

    public DynamicObject getProjectInitialize(DynamicObject project) {
        if (project == null) {
            return null;
        }
        QFilter statusFilter = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
        QFilter projectInitializeFilter = new QFilter("project", "=", project.getPkValue());
        projectInitializeFilter.and("executiveversion", "=", (Object)true);
        DynamicObject[] projectInitializes = BusinessDataServiceHelper.load((String)"pmfs_projectinitialize", (String)"id", (QFilter[])new QFilter[]{projectInitializeFilter, statusFilter});
        if (projectInitializes.length == 0) {
            return null;
        }
        return BusinessDataServiceHelper.loadSingle((Object)projectInitializes[0].getPkValue(), (String)"pmfs_projectinitialize");
    }
}

