/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmfs.business.helper;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pmgt.pmfs.common.utils.PmfsExcelUtil;
import kd.pmgt.pmfs.common.utils.vo.ExcelPropertiesVO;

public class SupplierIdentHelper {
    private static final Log LOG = LogFactory.getLog(SupplierIdentHelper.class);
    protected String ProjectKind_Installtype = ResManager.loadKDString((String)"\u5efa\u7b51\u5b89\u88c5\u7c7b", (String)"SupplierIdentHelper_0", (String)"pmgt-pmfs-business", (Object[])new Object[0]);
    protected String ProjectKind_Materials = ResManager.loadKDString((String)"\u8bbe\u5907\u6750\u6599\u7c7b", (String)"SupplierIdentHelper_1", (String)"pmgt-pmfs-business", (Object[])new Object[0]);
    protected String ProjectKind_Othertype = ResManager.loadKDString((String)"\u5176\u4ed6\u7c7b", (String)"SupplierIdentHelper_2", (String)"pmgt-pmfs-business", (Object[])new Object[0]);
    public static final String[] COLUMNKEY = new String[]{"projectkind", "bidsection", "bidmethod", "organization", "succeedbidder", "biddersort", "bidderamt", "openbiddate", "evaluateresult"};
    protected String Bidmethod_Open = ResManager.loadKDString((String)"\u516c\u5f00", (String)"SupplierIdentHelper_3", (String)"pmgt-pmfs-business", (Object[])new Object[0]);
    protected String Bidmethod_Invitate = ResManager.loadKDString((String)"\u9080\u8bf7", (String)"SupplierIdentHelper_4", (String)"pmgt-pmfs-business", (Object[])new Object[0]);
    protected String Bidmethod_Others = ResManager.loadKDString((String)"\u5176\u4ed6", (String)"SupplierIdentHelper_5", (String)"pmgt-pmfs-business", (Object[])new Object[0]);
    protected String Organization_Entrustbidder = ResManager.loadKDString((String)"\u59d4\u6258\u62db\u6807", (String)"SupplierIdentHelper_6", (String)"pmgt-pmfs-business", (Object[])new Object[0]);
    protected String Organization_Volumebidder = ResManager.loadKDString((String)"\u81ea\u884c\u62db\u6807", (String)"SupplierIdentHelper_7", (String)"pmgt-pmfs-business", (Object[])new Object[0]);
    public String fileName = ResManager.loadKDString((String)"\u62db\u6807\u4fe1\u606f", (String)"SupplierIdentHelper_8", (String)"pmgt-pmfs-business", (Object[])new Object[0]);
    public String sheetName = ResManager.loadKDString((String)"\u62db\u6807\u4fe1\u606f\u5217\u8868", (String)"SupplierIdentHelper_9", (String)"pmgt-pmfs-business", (Object[])new Object[0]);
    public String[] header = new String[]{ResManager.loadKDString((String)"\u62db\u6807\u9879\u5206\u7c7b", (String)"SupplierIdentHelper_25", (String)"pmgt-pmfs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u62db\u6807\u6807\u7684\uff08\u6807\u6bb5\uff09", (String)"SupplierIdentHelper_11", (String)"pmgt-pmfs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u62db\u6807\u65b9\u5f0f", (String)"SupplierIdentHelper_12", (String)"pmgt-pmfs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7ec4\u7ec7\u65b9\u5f0f", (String)"SupplierIdentHelper_13", (String)"pmgt-pmfs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e2d\u6807\u4eba", (String)"SupplierIdentHelper_14", (String)"pmgt-pmfs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e2d\u6807\u4eba\u5728\u4e2d\u6807\u5efa\u8bae\u8868\u4e2d\u6392\u5e8f", (String)"SupplierIdentHelper_15", (String)"pmgt-pmfs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e2d\u6807\u91d1\u989d\uff08\u4e07\u5143\uff09", (String)"SupplierIdentHelper_16", (String)"pmgt-pmfs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5f00\u6807\u65e5\u671f", (String)"SupplierIdentHelper_17", (String)"pmgt-pmfs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8bc4\u6807\u7ed3\u679c", (String)"SupplierIdentHelper_18", (String)"pmgt-pmfs-business", (Object[])new Object[0])};
    private static SupplierIdentHelper supplierIdentHelper = new SupplierIdentHelper();
    private static PmfsExcelUtil pmfsExcelUtil;

    public static SupplierIdentHelper getInstance() {
        return supplierIdentHelper;
    }

    public void importTask2ModelEntry(IDataModel object, IFormView view, JSONArray jasonArry) {
        DynamicObject model = object.getDataEntity(true);
        DynamicObjectCollection splitEntry = model.getDynamicObjectCollection("entryentity");
        splitEntry.clear();
        for (Object row : jasonArry) {
            JSONArray rowData = JSONArray.parseArray((String)row.toString());
            DynamicObject entry = splitEntry.addNew();
            entry.set("id", (Object)this.createID(entry.getDynamicObjectType()));
            for (Object column : rowData) {
                JSONObject columnData = JSONArray.parseObject((String)column.toString());
                String columnKey = columnData.getString("columnKey");
                Object cellValue = columnData.get((Object)"cellValue");
                cellValue = this.handleCellValue(columnKey, cellValue);
                entry.set(columnKey, cellValue);
            }
        }
        object.updateCache();
        view.updateView();
    }

    public void exportModelEntry2Task(IFormView view, DynamicObject model) {
        DynamicObjectCollection splitEntry = model.getDynamicObjectCollection("entryentity");
        if (null == pmfsExcelUtil) {
            pmfsExcelUtil = new PmfsExcelUtil(COLUMNKEY, this.fileName, this.sheetName, this.header);
            pmfsExcelUtil.setTipVOList(this.getExcelProperties());
        }
        JSONArray datas = new JSONArray();
        for (DynamicObject entry : splitEntry) {
            if (entry == null) continue;
            this.handleJsonData(model, entry, datas);
        }
        pmfsExcelUtil.exportModel(view, datas);
    }

    public Long createID(DynamicObjectType dynamicObjectType) {
        return ORM.create().genLongId((IDataEntityType)dynamicObjectType);
    }

    protected Object handleCellValue(String columnKey, Object cellValue) {
        Object value = null;
        block10 : switch (columnKey) {
            case "projectkind": {
                if (cellValue != null) {
                    switch (cellValue.toString()) {
                        case "\u5efa\u7b51\u5b89\u88c5\u7c7b": {
                            value = "installtype";
                            break block10;
                        }
                        case "\u8bbe\u5907\u6750\u6599\u7c7b": {
                            value = "materials";
                            break block10;
                        }
                        case "\u5176\u4ed6\u7c7b": {
                            value = "othertype";
                            break block10;
                        }
                    }
                    value = null;
                    break;
                }
                value = cellValue;
                break;
            }
            case "bidmethod": {
                if (cellValue != null) {
                    switch (cellValue.toString()) {
                        case "\u516c\u5f00": {
                            value = "open";
                            break block10;
                        }
                        case "\u9080\u8bf7": {
                            value = "invitate";
                            break block10;
                        }
                        case "\u5176\u4ed6": {
                            value = "others";
                            break block10;
                        }
                    }
                    value = null;
                    break;
                }
                value = cellValue;
                break;
            }
            case "organization": {
                if (cellValue != null) {
                    switch (cellValue.toString()) {
                        case "\u59d4\u6258\u62db\u6807": {
                            value = "entrustbidder";
                            break block10;
                        }
                        case "\u81ea\u884c\u62db\u6807": {
                            value = "volumebidder";
                            break block10;
                        }
                    }
                    value = null;
                    break;
                }
                value = cellValue;
                break;
            }
            case "openbiddate": {
                if (cellValue != null) {
                    if (cellValue instanceof Long) {
                        value = cellValue;
                        break;
                    }
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
                    String str = cellValue.toString();
                    try {
                        value = simpleDateFormat.parse(str);
                    }
                    catch (ParseException e) {
                        LOG.error((Throwable)e);
                    }
                    break;
                }
                value = cellValue;
                break;
            }
            case "succeedbidder": {
                if (cellValue == null) break;
                DynamicObject supplier = BusinessDataServiceHelper.loadSingle((String)"bd_supplier", (String)"name", (QFilter[])new QFilter[]{new QFilter("name", "=", (Object)cellValue.toString())});
                value = supplier;
                break;
            }
            case "bidderamt": {
                if (cellValue == null) break;
                try {
                    value = BigDecimal.valueOf(Double.parseDouble(cellValue.toString()));
                    break;
                }
                catch (Exception e) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5excel\u6587\u4ef6\u4e2d\u201c\u4e2d\u6807\u91d1\u989d\u201d\u5217\u662f\u5426\u5305\u542b\u975e\u6570\u503c\u7c7b\u578b\u7684\u6570\u636e\u3002", (String)"SupplierIdentHelper_26", (String)"pmgt-pmfs-business", (Object[])new Object[0]));
                }
            }
            default: {
                value = cellValue;
            }
        }
        return value;
    }

    protected void handleJsonData(DynamicObject model, DynamicObject entry, JSONArray datas) {
        JSONObject jsonObject = new JSONObject();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String kind = null;
        if ("installtype".equals(entry.getString("projectkind"))) {
            kind = this.ProjectKind_Installtype;
        } else if ("materials".equals(entry.getString("projectkind"))) {
            kind = this.ProjectKind_Materials;
        } else if ("othertype".equals(entry.getString("projectkind"))) {
            kind = this.ProjectKind_Othertype;
        }
        jsonObject.put("projectkind", (Object)kind);
        jsonObject.put("bidsection", entry.get("bidsection"));
        String method = null;
        if ("open".equals(entry.getString("bidmethod"))) {
            method = this.Bidmethod_Open;
        } else if ("invitate".equals(entry.getString("bidmethod"))) {
            method = this.Bidmethod_Invitate;
        } else if ("others".equals(entry.getString("bidmethod"))) {
            method = this.Bidmethod_Others;
        }
        jsonObject.put("bidmethod", (Object)method);
        String organization = null;
        if ("entrustbidder".equals(entry.getString("organization"))) {
            organization = this.Organization_Entrustbidder;
        } else if ("volumebidder".equals(entry.getString("organization"))) {
            organization = this.Organization_Volumebidder;
        }
        jsonObject.put("organization", (Object)organization);
        DynamicObject bidder = entry.getDynamicObject("succeedbidder");
        if (bidder != null) {
            jsonObject.put("succeedbidder", (Object)bidder.getString("name"));
        } else {
            jsonObject.put("succeedbidder", null);
        }
        jsonObject.put("biddersort", (Object)entry.getInt("biddersort"));
        BigDecimal decimal = entry.getBigDecimal("bidderamt");
        BigDecimal setScale = decimal.setScale(2, RoundingMode.HALF_UP);
        jsonObject.put("bidderamt", (Object)setScale);
        if (entry.getDate("openbiddate") != null) {
            String biddate = simpleDateFormat.format(entry.getDate("openbiddate"));
            jsonObject.put("openbiddate", (Object)biddate);
        } else {
            jsonObject.put("openbiddate", null);
        }
        jsonObject.put("evaluateresult", (Object)entry.getString("evaluateresult"));
        datas.add((Object)jsonObject);
    }

    public List<ExcelPropertiesVO> getExcelProperties() {
        return Arrays.asList(new ExcelPropertiesVO("projectkind", 3, 0, null, new String[]{this.ProjectKind_Installtype, this.ProjectKind_Materials, this.ProjectKind_Othertype}), new ExcelPropertiesVO("bidsection", 3, 1, ResManager.loadKDString((String)"\u6587\u672c", (String)"SupplierIdentHelper_19", (String)"pmgt-pmfs-business", (Object[])new Object[0])), new ExcelPropertiesVO("bidmethod", 3, 2, null, new String[]{this.Bidmethod_Open, this.Bidmethod_Invitate, this.Bidmethod_Others}), new ExcelPropertiesVO("organization", 3, 3, null, new String[]{this.Organization_Entrustbidder, this.Organization_Volumebidder}), new ExcelPropertiesVO("succeedbidder", 3, 4, ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\uff1a\u7ade\u6807\u673a\u6784\u540d\u79f0", (String)"SupplierIdentHelper_20", (String)"pmgt-pmfs-business", (Object[])new Object[0])), new ExcelPropertiesVO("biddersort", 3, 5, ResManager.loadKDString((String)"\u6574\u6570", (String)"SupplierIdentHelper_21", (String)"pmgt-pmfs-business", (Object[])new Object[0])), new ExcelPropertiesVO("bidderamt", 3, 6, ResManager.loadKDString((String)"\u91d1\u989d\uff1a\u4fdd\u7559\u4e24\u4f4d\u5c0f\u6570", (String)"SupplierIdentHelper_22", (String)"pmgt-pmfs-business", (Object[])new Object[0])), new ExcelPropertiesVO("openbiddate", 3, 7, ResManager.loadKDString((String)"\u683c\u5f0f\uff1ayyyy/MM/dd\u6216yyyy-MM-dd", (String)"SupplierIdentHelper_23", (String)"pmgt-pmfs-business", (Object[])new Object[0])), new ExcelPropertiesVO("evaluateresult", 3, 8, ResManager.loadKDString((String)"\u6587\u672c", (String)"SupplierIdentHelper_19", (String)"pmgt-pmfs-business", (Object[])new Object[0])));
    }
}

