/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmfs.formplugin;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pmgt.pmbs.business.helper.UserOrgRangeHelper;
import kd.pmgt.pmbs.business.utils.ReportConfigUtils;
import kd.pmgt.pmbs.common.enums.BudgetSourceTypeEnum;
import kd.pmgt.pmbs.common.enums.BudgetStageEnum;
import kd.pmgt.pmbs.common.enums.ConclusionEnum;
import kd.pmgt.pmbs.common.enums.PlanEnum;
import kd.pmgt.pmbs.common.enums.ProjectStageEnum;
import kd.pmgt.pmbs.common.enums.ProjectStatusEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmbs.common.enums.approval.ApprovalStatusEnum;
import kd.pmgt.pmbs.common.utils.ProjectPermissionHelper;
import kd.pmgt.pmfs.formplugin.base.AbstractPmfsBillPlugin;

public class FeasReportBillPlugin
extends AbstractPmfsBillPlugin
implements BeforeF7SelectListener,
ClickListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit project = (BasedataEdit)this.getControl("project");
        project.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        Button outestimate = (Button)this.getControl("outestimatelabel");
        outestimate.addClickListener((ClickListener)this);
        Container outflex = (Container)this.getControl("outflex");
        outflex.addClickListener((ClickListener)this);
        Button inestimate = (Button)this.getControl("inestimatelabel");
        inestimate.addClickListener((ClickListener)this);
        Container inflex = (Container)this.getControl("inflex");
        inflex.addClickListener((ClickListener)this);
        Button tasknumbers = (Button)this.getControl("task");
        tasknumbers.addClickListener((ClickListener)this);
        Container taskflex = (Container)this.getControl("taskflex");
        taskflex.addClickListener((ClickListener)this);
        Button resultnumbers = (Button)this.getControl("result");
        resultnumbers.addClickListener((ClickListener)this);
        Container resultflex = (Container)this.getControl("resultflex");
        resultflex.addClickListener((ClickListener)this);
        BasedataEdit indexName = (BasedataEdit)this.getControl("indexname");
        indexName.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit reportPerson = (BasedataEdit)this.getControl("reportperson");
        reportPerson.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        Container projectflex = (Container)this.getControl("projectflex");
        projectflex.addClickListener((ClickListener)this);
    }

    public void afterBindData(EventObject e) {
        String projectId;
        super.afterBindData(e);
        this.setProjectFlexValue();
        this.updateFeasibilityIndex();
        if (OperationStatus.ADDNEW.equals((Object)this.getView().getFormShowParameter().getStatus()) && null != (projectId = (String)this.getView().getFormShowParameter().getCustomParam("projectId")) && projectId.length() > 0) {
            QFilter proFilter = new QFilter("project", "=", (Object)Long.parseLong(projectId));
            DynamicObject[] feasReports = BusinessDataServiceHelper.load((String)"pmfs_reportbill", (String)"id", (QFilter[])new QFilter[]{proFilter});
            if (null != feasReports && feasReports.length > 0) {
                this.getModel().setValue("project", null);
            }
            QFilter[] numberFilter = new QFilter[]{new QFilter("number", "=", (Object)ProjectStageEnum.FEASIBILITYSTUDYSTAGE_S.getValue())};
            DynamicObject[] projectStages = BusinessDataServiceHelper.load((String)"pmbs_projectstage", (String)"number", (QFilter[])numberFilter);
            QFilter[] lxnumberFilter = new QFilter[]{new QFilter("number", "=", (Object)ProjectStageEnum.PROPOSALSTAGE_S.getValue())};
            DynamicObject[] lxStages = BusinessDataServiceHelper.load((String)"pmbs_projectstage", (String)"number", (QFilter[])lxnumberFilter);
            QFilter tgfilters = new QFilter("number", "=", (Object)ProjectStatusEnum.APPROVAL_SUCC.getValue());
            DynamicObject[] tgprostatuses = BusinessDataServiceHelper.load((String)"bd_projectstatus", (String)"id", (QFilter[])new QFilter[]{tgfilters});
            if (null != projectStages && projectStages.length > 0 && null != lxStages && lxStages.length > 0 && null != tgprostatuses && tgprostatuses.length > 0) {
                QFilter filter1 = new QFilter("projectstage", "=", projectStages[0].getPkValue());
                DynamicObject[] stageStatus = BusinessDataServiceHelper.load((String)"pmas_prostatus", (String)"project, projectstage, projectstatus, remarks, stagename, proapproval", (QFilter[])new QFilter[]{proFilter, filter1});
                if (null == stageStatus || stageStatus.length < 1) {
                    this.getModel().setValue("project", null);
                } else {
                    QFilter filter3;
                    QFilter filter2 = new QFilter("projectstage", "=", lxStages[0].getPkValue());
                    DynamicObject[] lxtgPros = BusinessDataServiceHelper.load((String)"pmas_prostatus", (String)"project, projectstage, projectstatus, remarks, stagename, proapproval", (QFilter[])new QFilter[]{filter2, filter3 = new QFilter("projectstatus", "=", tgprostatuses[0].getPkValue()), proFilter});
                    if (null == lxtgPros || lxtgPros.length < 1) {
                        this.getModel().setValue("project", null);
                    }
                }
            }
        }
    }

    protected void updateFeasibilityIndex() {
        DynamicObject project;
        String billStatus = (String)this.getModel().getValue("billstatus");
        if (StringUtils.equals((CharSequence)billStatus, (CharSequence)StatusEnum.TEMPSAVE.getValue()) && (project = (DynamicObject)this.getModel().getValue("project")) != null) {
            this.setEstimate();
            this.setProjectTask();
        }
    }

    private void setApprovalResultVisible() {
        BasedataEdit reportorg = (BasedataEdit)this.getControl("reportorg");
        String fsresult = (String)this.getModel().getValue("fsresult");
        if (StringUtils.equals((CharSequence)fsresult, (CharSequence)ConclusionEnum.REPORT_S.getValue())) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"reportorg"});
            reportorg.setMustInput(true);
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"reportorg"});
            reportorg.setMustInput(false);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String userId = RequestContext.get().getUserId();
        this.getModel().setValue("reportperson", (Object)userId);
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        super.beforeF7Select(event);
        String propertyName = event.getProperty().getName();
        if (StringUtils.equals((CharSequence)propertyName, (CharSequence)"indexname")) {
            DynamicObject project = (DynamicObject)this.getModel().getValue("project");
            if (project == null) {
                this.getView().showErrorNotification(ResManager.loadKDStringExt((String)"\u8bf7\u9009\u62e9\u9879\u76ee\u3002", (String)"FeasReportBillPlugin_15", (String)"pmgt-pmfs-formplugin", (Object[])new Object[0]));
                event.setCancel(true);
            }
        } else if (StringUtils.equals((CharSequence)propertyName, (CharSequence)"reportperson")) {
            QFilter qFilter;
            ListShowParameter param = (ListShowParameter)event.getFormShowParameter();
            param.setF7Style(3);
            List qFilterList = param.getListFilterParameter().getQFilters();
            long currUserId = RequestContext.get().getCurrUserId();
            long projectId = 0L;
            Object projectObj = this.getModel().getValue("project");
            if (projectObj != null) {
                DynamicObject project = (DynamicObject)projectObj;
                projectId = Long.parseLong(project.getPkValue().toString());
            }
            if ((qFilter = UserOrgRangeHelper.loadUserOrgRanges((Long)currUserId, (Long)projectId)) != null) {
                qFilterList.add(qFilter);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"save") || StringUtils.equals((CharSequence)operateKey, (CharSequence)"submit")) {
            DynamicObject project = (DynamicObject)this.getModel().getValue("project");
            if (null != project) {
                QFilter[] filters = new QFilter[]{new QFilter("project", "=", project.getPkValue())};
                DynamicObject[] feasReports = BusinessDataServiceHelper.load((String)"pmfs_reportbill", (String)"id", (QFilter[])filters);
                if (null != feasReports && feasReports.length > 0 && (Long)this.getModel().getDataEntity().get("id") == 0L) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u9879\u76ee\uff1a%s\uff0c\u5df2\u5728\u7533\u62a5\u4e2d\u3002", (String)"FeasReportBillPlugin_16", (String)"pmgt-pmfs-formplugin", (Object[])new Object[0]), project.getString("name")));
                    args.setCancel(true);
                    return;
                }
                this.compareIndexAndUpdate(project);
            }
        } else if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"audit")) {
            this.getModel().setValue("approvalresult", (Object)ConclusionEnum.APPROVAL_S.getValue());
        }
    }

    protected void compareIndexAndUpdate(DynamicObject project) {
        DynamicObject inbudget;
        if (project == null) {
            return;
        }
        QFilter planVersion = new QFilter("planstatus", "=", (Object)PlanEnum.PUBLISHED.getValue());
        QFilter proPlan = new QFilter("project", "=", project.getPkValue());
        QFilter specialtypeFilter = new QFilter("taskentity.specialtype.number", "like", (Object)"%FEASIBILITYSTUDY_S%");
        DynamicObject[] plans = BusinessDataServiceHelper.load((String)"pmpt_specialplan", (String)"id,taskentity,taskentity.specialtype,taskresultdocentry,taskresultdocentry.force", (QFilter[])new QFilter[]{planVersion, proPlan, specialtypeFilter});
        int taskCount = 0;
        int resultTaskCount = 0;
        for (DynamicObject plan : plans) {
            DynamicObjectCollection taskEntries = plan.getDynamicObjectCollection("taskentity");
            if (taskEntries == null || taskEntries.size() <= 0) continue;
            for (DynamicObject entry : taskEntries) {
                if (entry.getDynamicObject("specialtype") == null || !entry.getString("specialtype.number").contains("FEASIBILITYSTUDY_S")) continue;
                ++taskCount;
                DynamicObjectCollection taskResultEntry = entry.getDynamicObjectCollection("taskresultdocentry");
                for (DynamicObject taskResult : taskResultEntry) {
                    if (!taskResult.getBoolean("force")) continue;
                    ++resultTaskCount;
                }
            }
        }
        DynamicObject outbudget = this.getBudget(BudgetSourceTypeEnum.OUT.getValue());
        BigDecimal outTotalamount = BigDecimal.ZERO;
        BigDecimal inTotalamount = BigDecimal.ZERO;
        if (null != outbudget) {
            outTotalamount = outbudget.getBigDecimal("totalamount");
        }
        if (null != (inbudget = this.getBudget(BudgetSourceTypeEnum.IN.getValue()))) {
            inTotalamount = inbudget.getBigDecimal("totalamount");
        }
        int tasknumbers = (Integer)this.getModel().getValue("tasknumbers");
        int resultnumbers = (Integer)this.getModel().getValue("resultnumbers");
        BigDecimal outestimate = (BigDecimal)this.getModel().getValue("outestimate");
        BigDecimal inestimate = (BigDecimal)this.getModel().getValue("inestimate");
        boolean updateFeasIndex = false;
        if (taskCount != tasknumbers || resultTaskCount != resultnumbers || outTotalamount.compareTo(outestimate) != 0 || inTotalamount.compareTo(inestimate) != 0) {
            updateFeasIndex = true;
        }
        if (updateFeasIndex) {
            this.getModel().setValue("tasknumbers", (Object)taskCount);
            this.getModel().setValue("resultnumbers", (Object)resultTaskCount);
            this.getModel().setValue("outestimate", (Object)outTotalamount);
            this.getModel().setValue("inestimate", (Object)inTotalamount);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ef\u7814\u6307\u6807\u6570\u636e\u53d1\u751f\u53d8\u5316\uff0c\u5373\u5c06\u81ea\u52a8\u66f4\u65b0\u3002", (String)"FeasReportBillPlugin_17", (String)"pmgt-pmfs-formplugin", (Object[])new Object[0]));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "submit": 
            case "unaudit": 
            case "unsubmit": {
                boolean validateResult = args.getOperationResult().getValidateResult().isSuccess();
                if (!validateResult) break;
                this.getView().invokeOperation("refresh");
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        Object newValue = changeData.getNewValue();
        Object oldValue = changeData.getOldValue();
        int rowIndex = changeData.getRowIndex();
        DynamicObject project = (DynamicObject)this.getModel().getValue("project");
        if (StringUtils.equals((CharSequence)propertyName, (CharSequence)"project")) {
            this.setProjectCurrency(project);
            this.setProjectFlexValue();
            this.setEstimate();
            this.setProjectTask();
            this.setIndexEntry();
            if (null == project) {
                BigDecimal zero = BigDecimal.ZERO;
                this.getModel().setValue("outestimate", (Object)zero);
                this.getModel().setValue("inestimate", (Object)zero);
                this.getModel().setValue("profitestimate", (Object)zero);
                this.getModel().setValue("tasknumbers", (Object)zero);
                this.getModel().setValue("resultnumbers", (Object)zero);
            }
        } else if (StringUtils.equals((CharSequence)propertyName, (CharSequence)"fsresult")) {
            BasedataEdit reportorg = (BasedataEdit)this.getControl("reportorg");
            String fsresult = (String)this.getModel().getValue("fsresult");
            if (StringUtils.equals((CharSequence)fsresult, (CharSequence)ConclusionEnum.REPORT_S.getValue())) {
                this.setReportOrg(e);
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"reportorg"});
                this.getModel().setValue("reportorg", null);
                reportorg.setMustInput(false);
            }
        } else if (StringUtils.equals((CharSequence)propertyName, (CharSequence)"indexname")) {
            if (null != newValue) {
                DynamicObject kind;
                Object newPK = ((DynamicObject)newValue).getPkValue();
                DynamicObjectCollection indexEntries = this.getModel().getEntryEntity("indexentry");
                for (int index = 0; index < indexEntries.size(); ++index) {
                    DynamicObject indexName = ((DynamicObject)indexEntries.get(index)).getDynamicObject("indexname");
                    if (index == rowIndex || indexName == null || !indexName.getPkValue().equals(newPK)) continue;
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u540c\u540d\u7684\u8003\u91cf\u6307\u6807\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\u3002", (String)"FeasReportBillPlugin_18", (String)"pmgt-pmfs-formplugin", (Object[])new Object[0]));
                    this.getModel().setValue("indexname", oldValue, rowIndex);
                    return;
                }
                if (project != null && (kind = project.getDynamicObject("group")) != null) {
                    QFilter indexFilter;
                    QFilter proKindFilter = new QFilter("projectkind", "=", kind.getPkValue());
                    DynamicObject projectKindControlSetting = BusinessDataServiceHelper.loadSingle((String)"pmbs_prokindctrlsetting", (String)"id,proapplybilltype,proposalctrlapplyamt,applyctrlapprovalamt,budgetauditctrldrawupamt,absolutectrl,projectbugamtctrl,proyearbudgetamtctrl,probudgetctrl,overallctrlyear,projectctrlbudget,investbudgeconamt,outbudgettpl,inbudgettpl,ismajortype,enable,budgetcontrolmode,projectcostcontrol,probilltype,proposalbilltype,entryentity.id,entryentity.fieldname,entryentity.showname,entryentity.fieldtype,entryentity.ismustinput,entryentity.fieldkey,entryentity.assistgroup,spventryentity.id,spventryentity.spvprojectstage,spventryentity.workitem,spventryentity.keyitem,spventryentity.sysbill,spventryentity.keypropconfigid,projectkind,projectstageentry.id,projectstageentry.projectstage,budgetstageentry.id,budgetstageentry.budgetstage,outtreeentryentity.id,outtreeentryentity.outbudgetitem,outtreeentryentity.outbudgetname,intreeentryentity.id,intreeentryentity.inbudgetitem,intreeentryentity.inbudgetname,attachtypeentry.id,attachtypeentry.attachtype,attachtypeentry.necessary,filetypeentry.id,filetypeentry.filetype,filetypeentry.mustrecord,filetypeentry.moreuploads,indexentry.indexname,indexentry.standardindex,indexentry.excellentindex", (QFilter[])new QFilter[]{proKindFilter, indexFilter = new QFilter("indexentry.indexname", "=", newPK)});
                    if (projectKindControlSetting != null) {
                        for (DynamicObject settingIndexEntry : projectKindControlSetting.getDynamicObjectCollection("indexentry")) {
                            if (!settingIndexEntry.getDynamicObject("indexname").getPkValue().equals(((DynamicObject)newValue).getPkValue())) continue;
                            this.getModel().setValue("standardindex", settingIndexEntry.get("standardindex"), rowIndex);
                            this.getModel().setValue("excellentindex", settingIndexEntry.get("excellentindex"), rowIndex);
                            this.getModel().setValue("declarevalue", null, rowIndex);
                        }
                    } else {
                        this.getModel().setValue("standardindex", null, rowIndex);
                        this.getModel().setValue("excellentindex", null, rowIndex);
                        this.getModel().setValue("declarevalue", null, rowIndex);
                    }
                }
            } else {
                this.getModel().setValue("standardindex", null, rowIndex);
                this.getModel().setValue("excellentindex", null, rowIndex);
                this.getModel().setValue("declarevalue", null, rowIndex);
            }
        }
    }

    private void setIndexEntry() {
        this.getModel().deleteEntryData("indexentry");
        DynamicObject project = (DynamicObject)this.getModel().getValue("project");
        if (project != null) {
            QFilter proFilter = new QFilter("pro", "=", project.getPkValue());
            DynamicObject proApp = BusinessDataServiceHelper.loadSingle((String)"pmas_pro_approval", (String)"indexentry,indexentry.indexname,indexentry.declarevalue,indexentry.indexwarnlight,indexentry.standardindex,indexentry.excellentindex", (QFilter[])new QFilter[]{proFilter});
            if (proApp != null) {
                DynamicObjectCollection proIndexEntries = proApp.getDynamicObjectCollection("indexentry");
                this.getModel().beginInit();
                for (DynamicObject proIndexEntry : proIndexEntries) {
                    int row = this.getModel().createNewEntryRow("indexentry");
                    this.getModel().setValue("indexname", proIndexEntry.get("indexname"), row);
                    this.getModel().setValue("declarevalue", proIndexEntry.get("declarevalue"), row);
                    this.getModel().setValue("standardindex", proIndexEntry.get("standardindex"), row);
                    this.getModel().setValue("excellentindex", proIndexEntry.get("excellentindex"), row);
                }
                this.getModel().endInit();
                this.getView().updateView("indexentry");
            }
        }
    }

    private void setProjectCurrency(DynamicObject project) {
        if (null == project) {
            return;
        }
        DynamicObject[] proApps = BusinessDataServiceHelper.load((String)"pmas_pro_approval", (String)"currencyfield", (QFilter[])new QFilter[]{new QFilter("pro", "=", project.getPkValue())});
        if (proApps.length > 0) {
            DynamicObject currency = proApps[0].getDynamicObject("currencyfield");
            this.getModel().setValue("currency", (Object)currency);
        }
    }

    private void setReportOrg(PropertyChangedArgs e) {
        ChangeData changeData = e.getChangeSet()[0];
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        DynamicObject project = (DynamicObject)this.getModel().getValue("project");
        BasedataEdit reportOrgEdit = (BasedataEdit)this.getControl("reportorg");
        reportOrgEdit.setMustInput(true);
        if (org != null && project != null) {
            String orgId;
            DynamicObject kind = project.getDynamicObject("group");
            String kindId = kind != null ? kind.getPkValue().toString() : null;
            DynamicObject reportOrg = ReportConfigUtils.gainReportorg((String)kindId, (String)(orgId = org.getPkValue().toString()), (String)"pmfs_reportbill");
            if (reportOrg != null) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"reportorg"});
                this.getModel().setValue("reportorg", (Object)reportOrg);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u201c\u4e0a\u62a5\u7ec4\u7ec7\u8bbe\u7f6e\u201d\u4e3a\u7a7a\u3002\u8bf7\u5148\u5728\u201c\u9879\u76ee\u4e91>\u57fa\u7840\u8d44\u6599>\u4e0a\u62a5\u7ec4\u7ec7\u5c42\u7ea7\u8bbe\u7f6e\u201d\u4e2d\u7ef4\u62a4\u4e0a\u62a5\u7ec4\u7ec7\u3002", (String)"FeasReportBillPlugin_19", (String)"pmgt-pmfs-formplugin", (Object[])new Object[0]));
                this.getModel().beginInit();
                this.getModel().setValue("fsresult", changeData.getOldValue());
                this.getView().setVisible(Boolean.FALSE, new String[]{"reportorg"});
                this.getModel().beginInit();
                this.getView().updateView("fsresult");
            }
        }
    }

    private void setProjectTask() {
        DynamicObject projectKind;
        DynamicObject project = (DynamicObject)this.getModel().getValue("project");
        if (null != project && (projectKind = project.getDynamicObject("group")) != null) {
            QFilter planVersion = new QFilter("planstatus", "=", (Object)PlanEnum.PUBLISHED.getValue());
            QFilter proPlan = new QFilter("project", "=", project.getPkValue());
            QFilter specialtypeFilter = new QFilter("taskentity.specialtype.number", "like", (Object)"%FEASIBILITYSTUDY_S%");
            DynamicObject[] plans = BusinessDataServiceHelper.load((String)"pmpt_specialplan", (String)"id,taskentity,taskentity.specialtype,taskresultdocentry,taskresultdocentry.force", (QFilter[])new QFilter[]{planVersion, proPlan, specialtypeFilter});
            int taskCount = 0;
            int resultTaskCount = 0;
            for (DynamicObject plan : plans) {
                DynamicObjectCollection taskEntries = plan.getDynamicObjectCollection("taskentity");
                if (taskEntries == null || taskEntries.size() <= 0) continue;
                for (DynamicObject entry : taskEntries) {
                    if (entry.getDynamicObject("specialtype") == null || !entry.getString("specialtype.number").contains("FEASIBILITYSTUDY_S")) continue;
                    ++taskCount;
                    DynamicObjectCollection taskResultEntry = entry.getDynamicObjectCollection("taskresultdocentry");
                    for (DynamicObject taskResult : taskResultEntry) {
                        if (!taskResult.getBoolean("force")) continue;
                        ++resultTaskCount;
                    }
                }
            }
            this.getModel().setValue("tasknumbers", (Object)taskCount);
            this.getModel().setValue("resultnumbers", (Object)resultTaskCount);
        }
    }

    private void setEstimate() {
        DynamicObject inbudget;
        DynamicObject outbudget = this.getBudget(BudgetSourceTypeEnum.OUT.getValue());
        if (null != outbudget) {
            this.getModel().setValue("outestimate", (Object)outbudget.getBigDecimal("totalamount"));
        }
        if (null != (inbudget = this.getBudget(BudgetSourceTypeEnum.IN.getValue()))) {
            this.getModel().setValue("inestimate", (Object)inbudget.getBigDecimal("totalamount"));
        }
        BigDecimal outestimate = (BigDecimal)this.getModel().getValue("outestimate");
        BigDecimal Inestimate = (BigDecimal)this.getModel().getValue("inestimate");
        BigDecimal profitestimate = Inestimate.subtract(outestimate);
        this.getModel().setValue("profitestimate", (Object)profitestimate);
        this.getView().updateView("profitestimate");
        this.getView().updateView("outestimate");
        this.getView().updateView("inestimate");
    }

    private DynamicObject getBudget(String inOrOut) {
        DynamicObject project = (DynamicObject)this.getModel().getValue("project");
        QFilter[] numberFilter = new QFilter[]{new QFilter("number", "=", (Object)BudgetStageEnum.PREINSTALL_2.getValue())};
        DynamicObject[] budgetstages = BusinessDataServiceHelper.load((String)"pmbs_budgetstage", (String)"id", (QFilter[])numberFilter);
        if (null != budgetstages && budgetstages.length > 0 && null != project) {
            QFilter out;
            QFilter budget;
            QFilter isvalid;
            DynamicObject budgetstage = budgetstages[0];
            QFilter proFilter = new QFilter("project", "=", project.getPkValue());
            QFilter[] filters = new QFilter[]{proFilter, isvalid = new QFilter("isvalid", "=", (Object)Boolean.TRUE), budget = new QFilter("budgetstage", "=", budgetstage.getPkValue()), out = new QFilter("sourcetype", "=", (Object)inOrOut)};
            DynamicObject[] budgetBills = BusinessDataServiceHelper.load((String)"pmas_budget", (String)"totalamount", (QFilter[])filters);
            if (null != budgetBills && budgetBills.length > 0) {
                return budgetBills[0];
            }
        }
        return null;
    }

    private void setProjectFlexValue() {
        DynamicObject project = (DynamicObject)this.getModel().getValue("project");
        Label kindlabel = (Label)this.getControl("projectkind");
        if (null != project) {
            this.getModel().setValue("projectname", (Object)project.getString("name"));
            DynamicObject kind = project.getDynamicObject("group");
            if (null != kind) {
                kindlabel.setText(kind.getString("name"));
            }
        } else {
            kindlabel.setText(ResManager.loadKDString((String)"\u9879\u76ee\u5206\u7c7b", (String)"FeasReportBillPlugin_2", (String)"pmgt-pmfs-formplugin", (Object[])new Object[0]));
            this.getModel().setValue("projectname", (Object)ResManager.loadKDString((String)"\u9879\u76ee\u540d\u79f0", (String)"FeasReportBillPlugin_1", (String)"pmgt-pmfs-formplugin", (Object[])new Object[0]));
        }
    }

    public void click(EventObject evt) {
        DynamicObject inbudget;
        super.click(evt);
        Control c = (Control)evt.getSource();
        String key = c.getKey();
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        DynamicObject project = (DynamicObject)this.getModel().getValue("project");
        if (null != project && (StringUtils.equals((CharSequence)key, (CharSequence)"projectname") || StringUtils.equals((CharSequence)key, (CharSequence)"projectflex"))) {
            QFilter proFilter = new QFilter("pro", "=", project.getPkValue());
            String properties = String.join((CharSequence)",", "id", "prostatus", "needapproval", "approvalstatus", "isreport", "repaudstatus", "prostatus");
            DynamicObject[] proApps = BusinessDataServiceHelper.load((String)"pmas_pro_approval", (String)properties, (QFilter[])new QFilter[]{proFilter});
            if (null != proApps && proApps.length > 0) {
                DynamicObject proApp = proApps[0];
                boolean needApproval = proApp.getBoolean("needapproval");
                String approvalStatus = proApp.getString("approvalstatus");
                if (needApproval && !StringUtils.equals((CharSequence)approvalStatus, (CharSequence)ApprovalStatusEnum.PASS.getValue())) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6838\u51c6\u901a\u8fc7\u540e\uff0c\u624d\u80fd\u67e5\u770b\u9879\u76ee\u770b\u677f\u3002", (String)"FeasReportBillPlugin_20", (String)"pmgt-pmfs-formplugin", (Object[])new Object[0]));
                    return;
                }
                DynamicObject proStatus = proApp.getDynamicObject("prostatus");
                if (proStatus == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u9879\u76ee\u7acb\u9879\u5ba1\u6838\u672a\u901a\u8fc7\uff0c\u65e0\u9879\u76ee\u770b\u677f\u3002", (String)"FeasReportBillPlugin_21", (String)"pmgt-pmfs-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (ProjectStatusEnum.APPROVAL_FAIL.getValue().equals(proStatus.getString("number"))) {
                    this.getView().showMessage(ResManager.loadKDStringExt((String)"\u9879\u76ee\u7acb\u9879\u5ba1\u6838\u672a\u901a\u8fc7\uff0c\u65e0\u9879\u76ee\u770b\u677f\u3002", (String)"FeasReportBillPlugin_21", (String)"pmgt-pmfs-formplugin", (Object[])new Object[0]));
                    return;
                }
                HashMap<String, Object> custormMap = new HashMap<String, Object>(16);
                custormMap.put("proAppId", proApp.getPkValue());
                map.put("formId", "pmba_projectkanban");
                map.put("customParams", custormMap);
                FormShowParameter parameter = FormShowParameter.createFormShowParameter(map);
                parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm(parameter);
            }
        } else if ((StringUtils.equals((CharSequence)key, (CharSequence)"task") || StringUtils.equals((CharSequence)key, (CharSequence)"taskflex")) && null != project) {
            DynamicObject projectKind = project.getDynamicObject("group");
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            if (projectKind != null && org != null) {
                String billstatus = (String)this.getModel().getValue("billstatus");
                if (StringUtils.equals((CharSequence)billstatus, (CharSequence)StatusEnum.TEMPSAVE.getValue())) {
                    int taskNumbers = (Integer)this.getModel().getValue("tasknumbers");
                    if (taskNumbers == 0) {
                        QFilter statusFilter = new QFilter("billstatus", "!=", (Object)StatusEnum.CHECKED.getValue());
                        QFilter proFilter = new QFilter("project", "=", project.getPkValue());
                        DynamicObject[] masterplans = BusinessDataServiceHelper.load((String)"pmpt_masterplan", (String)"majortype", (QFilter[])new QFilter[]{proFilter, statusFilter}, (String)"version desc");
                        if (masterplans.length > 0) {
                            Map permObj;
                            DynamicObject projectPlan = masterplans[0];
                            DynamicObject majorType = projectPlan.getDynamicObject("majortype");
                            String number = majorType.getString("number");
                            map.put("pkId", projectPlan.getPkValue().toString());
                            if (StringUtils.equals((CharSequence)number, (CharSequence)"MASTERPLAN_S")) {
                                permObj = ProjectPermissionHelper.getPermObj((String)"pmpt_masterplan", (String)"modify");
                                if (permObj.isEmpty()) {
                                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u4fee\u6539\u201c\u9879\u76ee\u8ba1\u5212\u201d\u7684\u6743\u9650\uff0c\u8bf7\u4e0e\u9879\u76ee\u7ecf\u7406\u8054\u7cfb\u3002", (String)"FeasReportBillPlugin_22", (String)"pmgt-pmfs-formplugin", (Object[])new Object[0]));
                                    return;
                                }
                                map.put("formId", "pmpt_masterplan");
                            } else {
                                permObj = ProjectPermissionHelper.getPermObj((String)"pmpt_specialplan", (String)"modify");
                                if (permObj.isEmpty()) {
                                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u4fee\u6539\u201c\u9879\u76ee\u8ba1\u5212\u201d\u7684\u6743\u9650\uff0c\u8bf7\u4e0e\u9879\u76ee\u7ecf\u7406\u8054\u7cfb\u3002", (String)"FeasReportBillPlugin_22", (String)"pmgt-pmfs-formplugin", (Object[])new Object[0]));
                                    return;
                                }
                                map.put("formId", "pmpt_specialplan");
                            }
                            FormShowParameter showParameter = FormShowParameter.createFormShowParameter(map);
                            showParameter.setStatus(OperationStatus.EDIT);
                            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                            this.getView().showForm(showParameter);
                        } else {
                            statusFilter = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
                            masterplans = BusinessDataServiceHelper.load((String)"pmpt_masterplan", (String)"majortype", (QFilter[])new QFilter[]{proFilter, statusFilter}, (String)"version desc");
                            if (masterplans.length > 0) {
                                this.viewProplanMonitorForm(map, project, org);
                            } else {
                                QFilter defaultVersionFilter;
                                QFilter isIndividuationFilter;
                                Map permObj = ProjectPermissionHelper.getPermObj((String)"pmpt_masterplan", (String)"new");
                                if (permObj.isEmpty()) {
                                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u65b0\u589e\u201c\u9879\u76ee\u8ba1\u5212\u201d\u7684\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u9879\u76ee\u7ecf\u7406\u3002", (String)"FeasReportBillPlugin_23", (String)"pmgt-pmfs-formplugin", (Object[])new Object[0]));
                                    return;
                                }
                                QFilter projectFilter = new QFilter("project", "=", project.getPkValue());
                                DynamicObject projWorkCal = BusinessDataServiceHelper.loadSingle((String)"pmpt_projworkcalendarset", (String)"", (QFilter[])new QFilter[]{projectFilter, isIndividuationFilter = new QFilter("isindividuation", "=", (Object)"0")});
                                if (projWorkCal == null && (projWorkCal = BusinessDataServiceHelper.loadSingle((String)"pmpt_projworkcalendarset", (String)"", (QFilter[])new QFilter[]{defaultVersionFilter = new QFilter("version", "=", (Object)"default"), isIndividuationFilter})) == null) {
                                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u9879\u76ee\u65e5\u5386\u672a\u8bbe\u7f6e\uff0c\u4e14\u65e0\u9ed8\u8ba4\u9879\u76ee\u65e5\u5386\u3002", (String)"FeasReportBillPlugin_24", (String)"pmgt-pmfs-formplugin", (Object[])new Object[0]));
                                    return;
                                }
                                map.put("projectId", project.getPkValue().toString());
                                map.put("formId", "pmpt_masterplan");
                                map.put("orgId", org.getPkValue().toString());
                                FormShowParameter showParameter = FormShowParameter.createFormShowParameter(map);
                                showParameter.setStatus(OperationStatus.ADDNEW);
                                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                                this.getView().showForm(showParameter);
                            }
                        }
                    } else {
                        this.viewProplanMonitorForm(map, project, org);
                    }
                } else {
                    this.viewProplanMonitorForm(map, project, org);
                }
            }
        } else if ((StringUtils.equals((CharSequence)key, (CharSequence)"result") || StringUtils.equals((CharSequence)key, (CharSequence)"resultflex")) && null != project) {
            DynamicObject projectKind = project.getDynamicObject("group");
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            if (projectKind != null && org != null) {
                map.put("orgId", org.getPkValue().toString());
                map.put("proId", project.getPkValue().toString());
                map.put("formId", "pmpt_proresulttrack");
                FormShowParameter showParameter = FormShowParameter.createFormShowParameter(map);
                showParameter.setStatus(OperationStatus.EDIT);
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                showParameter.setCustomParams(map);
                this.getView().showForm(showParameter);
            }
        } else if ((StringUtils.equals((CharSequence)key, (CharSequence)"outestimatelabel") || StringUtils.equals((CharSequence)key, (CharSequence)"outflex")) && null != project) {
            DynamicObject outbudget = this.getBudget(BudgetSourceTypeEnum.OUT.getValue());
            if (null != outbudget) {
                map.put("formId", "pmas_outbudget");
                map.put("pkId", outbudget.getPkValue().toString());
                FormShowParameter showParameter = FormShowParameter.createFormShowParameter(map);
                showParameter.setStatus(OperationStatus.VIEW);
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm(showParameter);
            }
        } else if ((StringUtils.equals((CharSequence)key, (CharSequence)"inestimatelabel") || StringUtils.equals((CharSequence)key, (CharSequence)"inflex")) && null != project && null != (inbudget = this.getBudget(BudgetSourceTypeEnum.IN.getValue()))) {
            map.put("formId", "pmas_inbudget");
            map.put("pkId", inbudget.getPkValue().toString());
            FormShowParameter showParameter = FormShowParameter.createFormShowParameter(map);
            showParameter.setStatus(OperationStatus.VIEW);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm(showParameter);
        }
    }

    protected void viewProplanMonitorForm(HashMap<String, Object> map, DynamicObject project, DynamicObject org) {
        map.put("orgId", org.getPkValue().toString());
        map.put("proId", project.getPkValue().toString());
        map.put("majortypefilter", "true");
        ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)"pmpt_proplanmonitor", (boolean)false, (int)2, (boolean)false);
        listShowParameter.setBillFormId("pmpt_proplanmonitor");
        listShowParameter.setFormId("pmpt_proplanmonitortpl");
        listShowParameter.setCustomParams(map);
        listShowParameter.setStatus(OperationStatus.VIEW);
        listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)listShowParameter);
    }
}

