/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmfs.formplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmgt.pmbs.common.enums.BudgetSourceTypeEnum;
import kd.pmgt.pmbs.common.enums.BudgetStageEnum;
import kd.pmgt.pmbs.common.enums.PlanEnum;
import kd.pmgt.pmfs.formplugin.base.AbstractPmfsListPlugin;

public class FeasReportListPlugin
extends AbstractPmfsListPlugin {
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        ListSelectedRowCollection listSelectedDatas = args.getListSelectedData();
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"save") || StringUtils.equals((CharSequence)operateKey, (CharSequence)"submit")) {
            DynamicObject[] feasBills;
            ArrayList<DynamicObject> updateFeasList = new ArrayList<DynamicObject>(listSelectedDatas.size());
            for (DynamicObject feasBill : feasBills = BusinessDataServiceHelper.load((Object[])listSelectedDatas.getPrimaryKeyValues(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmfs_reportbill"))) {
                boolean updateFeasIndex = this.compareIndexAndUpdate(feasBill);
                if (!updateFeasIndex) continue;
                updateFeasList.add(feasBill);
            }
            if (updateFeasList.size() > 0) {
                SaveServiceHelper.update((DynamicObject[])updateFeasList.toArray(new DynamicObject[0]));
            }
        }
    }

    protected boolean compareIndexAndUpdate(DynamicObject feasBill) {
        DynamicObject inbudget;
        DynamicObject project = feasBill.getDynamicObject("project");
        if (project == null) {
            return false;
        }
        QFilter planVersion = new QFilter("planstatus", "=", (Object)PlanEnum.PUBLISHED.getValue());
        QFilter proPlan = new QFilter("project", "=", project.getPkValue());
        QFilter specialtypeFilter = new QFilter("taskentity.specialtype.number", "like", (Object)"%FEASIBILITYSTUDY_S%");
        DynamicObject[] plans = BusinessDataServiceHelper.load((String)"pmpt_specialplan", (String)"id,taskentity,taskentity.specialtype,taskresultdocentry,taskresultdocentry.force", (QFilter[])new QFilter[]{planVersion, proPlan, specialtypeFilter});
        int taskCount = 0;
        int resultTaskCount = 0;
        for (DynamicObject plan : plans) {
            DynamicObjectCollection taskEntries = plan.getDynamicObjectCollection("taskentity");
            if (taskEntries == null || taskEntries.size() <= 0) continue;
            for (DynamicObject entry : taskEntries) {
                if (entry.getDynamicObject("specialtype") == null || !entry.getString("specialtype.number").contains("FEASIBILITYSTUDY_S")) continue;
                ++taskCount;
                DynamicObjectCollection taskResultEntry = entry.getDynamicObjectCollection("taskresultdocentry");
                for (DynamicObject taskResult : taskResultEntry) {
                    if (!taskResult.getBoolean("force")) continue;
                    ++resultTaskCount;
                }
            }
        }
        DynamicObject outbudget = this.getBudget(project, BudgetSourceTypeEnum.OUT.getValue());
        BigDecimal outTotalamount = BigDecimal.ZERO;
        BigDecimal inTotalamount = BigDecimal.ZERO;
        if (null != outbudget) {
            outTotalamount = outbudget.getBigDecimal("totalamount");
        }
        if (null != (inbudget = this.getBudget(project, BudgetSourceTypeEnum.IN.getValue()))) {
            inTotalamount = inbudget.getBigDecimal("totalamount");
        }
        int tasknumbers = feasBill.getInt("tasknumbers");
        int resultnumbers = feasBill.getInt("resultnumbers");
        BigDecimal outestimate = feasBill.getBigDecimal("outestimate");
        BigDecimal inestimate = feasBill.getBigDecimal("inestimate");
        boolean updateFeasIndex = false;
        if (taskCount != tasknumbers || resultTaskCount != resultnumbers || outTotalamount.compareTo(outestimate) != 0 || inTotalamount.compareTo(inestimate) != 0) {
            updateFeasIndex = true;
        }
        if (updateFeasIndex) {
            feasBill.set("tasknumbers", (Object)taskCount);
            feasBill.set("resultnumbers", (Object)resultTaskCount);
            feasBill.set("outestimate", (Object)outTotalamount);
            feasBill.set("inestimate", (Object)inTotalamount);
        }
        return updateFeasIndex;
    }

    protected DynamicObject getBudget(DynamicObject project, String inOrOut) {
        QFilter[] numberFilter = new QFilter[]{new QFilter("number", "=", (Object)BudgetStageEnum.PREINSTALL_2.getValue())};
        DynamicObject[] budgetstages = BusinessDataServiceHelper.load((String)"pmbs_budgetstage", (String)"id", (QFilter[])numberFilter);
        if (null != budgetstages && budgetstages.length > 0 && null != project) {
            QFilter out;
            QFilter budget;
            QFilter isvalid;
            DynamicObject budgetstage = budgetstages[0];
            QFilter proFilter = new QFilter("project", "=", project.getPkValue());
            QFilter[] filters = new QFilter[]{proFilter, isvalid = new QFilter("isvalid", "=", (Object)Boolean.TRUE), budget = new QFilter("budgetstage", "=", budgetstage.getPkValue()), out = new QFilter("sourcetype", "=", (Object)inOrOut)};
            DynamicObject[] budgetBills = BusinessDataServiceHelper.load((String)"pmas_budget", (String)"totalamount", (QFilter[])filters);
            if (null != budgetBills && budgetBills.length > 0) {
                return budgetBills[0];
            }
        }
        return null;
    }
}

