/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmfs.formplugin;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.ImageList;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateTimeEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.pmgt.pmbs.business.helper.DateControlHelper;
import kd.pmgt.pmbs.business.utils.DateUtils;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmbs.common.enums.imageProgressreport.PeriodTypeEnum;
import kd.pmgt.pmbs.common.enums.projectinitialize.SplitDimensionEnum;
import kd.pmgt.pmbs.common.utils.DateUtil;
import kd.pmgt.pmfs.business.helper.ProjectInitializeHelper;
import kd.pmgt.pmfs.common.enums.TimeTypeEnum;
import kd.pmgt.pmfs.formplugin.base.AbstractPmfsBillPlugin;
import org.jetbrains.annotations.NotNull;

public class ImageProgressReportEditPlugin
extends AbstractPmfsBillPlugin
implements BeforeF7SelectListener,
RowClickEventListener {
    protected static final Log LOG = LogFactory.getLog(ImageProgressReportEditPlugin.class);
    protected static final String MONTH_MASK = "yyyy-MM";
    protected static final String DAY_MASK = "yyyy-MM-dd";
    protected static final String HOUR_MASK = "yyyy-MM-dd HH:mm:ss";
    protected static final String MINUTE_MASK = "yyyy-MM-dd HH:mm";
    protected static final String DO_SUBMIT = "dosubmit";
    protected static final String DELETE_ENTRY = "deleteentry";
    protected static final String NEW_ENTRY = "newentry";
    protected static final String CurrencyField = "currencyfield";
    protected static final String WBS_ENTRY_FLEX = "wbsentryflex";
    protected static final String FS_BASE_INFO = "fs_baseinfo";
    protected static final String MUTI_WBS_CONFIRM_CALL_BACK = "mutiWbsConfirmCallBack";
    protected static final String SAME_PERIOD_CONFIRM_CALL_BACK = "samePeriod";
    protected static final String NEW_MUTI_WBS = "newMutiWbs";
    protected static final String PICTURE_FLEX = "pictureflex";
    protected static final String PICTURE_LIST = "picturelist";
    protected static final String PICTURE_TIP = "picturetip";

    public void registerListener(EventObject e) {
        EntryGrid entryEntity;
        BasedataEdit entryWbs;
        super.registerListener(e);
        BasedataEdit wbs = (BasedataEdit)this.getView().getControl("wbs");
        if (wbs != null) {
            wbs.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((entryWbs = (BasedataEdit)this.getView().getControl("entrywbs")) != null) {
            entryWbs.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((entryEntity = (EntryGrid)this.getView().getControl("entryentity")) != null) {
            entryEntity.addRowClickListener((RowClickEventListener)this);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.periodDateFormat();
        DynamicObject project = (DynamicObject)this.getModel().getValue("project");
        Date period = (Date)this.getModel().getValue("period");
        this.changeStartAndEndTimeFormat(project);
        this.showOrHideEntry((Boolean)this.getModel().getValue("mutiwbs"));
        this.showOrHideSpiltByCountField();
        this.getView().setVisible(Boolean.valueOf(false), new String[]{PICTURE_FLEX});
        String billStatus = (String)this.getModel().getValue("billstatus");
        if (StringUtils.equals((CharSequence)billStatus, (CharSequence)StatusEnum.TEMPSAVE.getValue())) {
            this.getProjectInvestCompletion(project, period);
            this.currentProgressChanged();
        }
    }

    protected void currentProgressChanged() {
        boolean multiWbs = (Boolean)this.getModel().getValue("mutiwbs");
        if (multiWbs) {
            DynamicObjectCollection wbsEntries = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
            StringBuilder tipsMsg = new StringBuilder();
            for (DynamicObject wbsEntry : wbsEntries) {
                DynamicObject wbs = wbsEntry.getDynamicObject("entrywbs");
                BigDecimal currentProgress = wbsEntry.getBigDecimal("entrycurrentprogress");
                BigDecimal wbsSchedule = wbs.getBigDecimal("schedule");
                int compareResult = wbsSchedule.compareTo(currentProgress);
                if (compareResult == 0) continue;
                tipsMsg.append(String.format(ResManager.loadKDString((String)"WBS\uff1a%1$s\u3001%2$s\uff0c\u5f00\u7d2f\u5f53\u524d\u5b8c\u6210\u8fdb\u5ea6\u5df2\u52a0\u8f7d\u4e3a\u6700\u65b0\u6570\u636e\u3002", (String)"ImageProgressReportEditPlugin_13", (String)"pmgt-pmfs-formplugin", (Object[])new Object[0]), wbs.getString("number"), wbs.getString("name")));
                tipsMsg.append("\n");
                wbsEntry.set("entrycurrentprogress", (Object)wbsSchedule);
            }
            if (StringUtils.isNotEmpty((CharSequence)tipsMsg.toString())) {
                this.getView().showTipNotification(tipsMsg.toString());
                this.getModel().updateEntryCache(wbsEntries);
                this.getView().updateView("entryentity");
            }
        } else {
            DynamicObject wbs = (DynamicObject)this.getModel().getValue("wbs");
            if (wbs == null) {
                return;
            }
            BigDecimal currentProgress = (BigDecimal)this.getModel().getValue("currentprogress");
            BigDecimal wbsSchedule = wbs.getBigDecimal("schedule");
            int compareResult = wbsSchedule.compareTo(currentProgress);
            if (compareResult != 0) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"WBS\uff1a%1$s\u3001%2$s\uff0c\u5f00\u7d2f\u5f53\u524d\u5b8c\u6210\u8fdb\u5ea6\u5df2\u52a0\u8f7d\u4e3a\u6700\u65b0\u6570\u636e\u3002", (String)"ImageProgressReportEditPlugin_13", (String)"pmgt-pmfs-formplugin", (Object[])new Object[0]), wbs.getString("number"), wbs.getString("name")));
                this.getModel().setValue("currentprogress", (Object)wbsSchedule);
            }
        }
    }

    private void periodDateFormat() {
        String dateFormat = this.getDateTimeFormatString();
        DateControlHelper.changeDateMask((IFormView)this.getView(), (String)"period", (String)dateFormat);
        DateTimeEdit periodTimeEdit = (DateTimeEdit)this.getControl("period");
        periodTimeEdit.setMustInput(true);
    }

    @NotNull
    private String getDateTimeFormatString() {
        String periodType = (String)this.getModel().getValue("periodtype");
        String dateFormat = "";
        if (PeriodTypeEnum.MONTH.getValue().equals(periodType)) {
            dateFormat = MONTH_MASK;
        } else if (PeriodTypeEnum.DAY.getValue().equals(periodType)) {
            dateFormat = DAY_MASK;
        } else if (PeriodTypeEnum.HOUR.getValue().equals(periodType)) {
            dateFormat = HOUR_MASK;
        }
        return dateFormat;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        switch (name) {
            case "periodtype": {
                this.periodDateFormat();
                this.changePeriodStr();
                this.periodStrUpdatePeriod();
                break;
            }
            case "period": {
                this.changePeriodStr();
                this.setAmountAndPercentageByPeriod();
                DynamicObject project = (DynamicObject)this.getModel().getValue("project");
                this.getProjectInvestCompletion(project, (Date)newValue);
                break;
            }
            case "project": {
                this.changeProject((DynamicObject)newValue);
                this.changCurrency();
                Date period = (Date)this.getModel().getValue("period");
                this.getProjectInvestCompletion((DynamicObject)newValue, period);
                break;
            }
            case "mutiwbs": {
                this.mutiWbsChange((Boolean)newValue);
                break;
            }
            case "wbsprogress": {
                this.resetPictureList(rowIndex);
                break;
            }
            case "entrywbs": {
                this.setAmountAndPercentageByPeriod();
                this.setEntryStartAndEndTime(newValue, rowIndex);
                break;
            }
            case "wbs": {
                this.setAmountAndPercentageByPeriod();
                this.setStartAndEndTime(newValue);
                break;
            }
            case "starttime": 
            case "endtime": {
                this.timeChangeValidate(e);
                break;
            }
        }
    }

    protected void timeChangeValidate(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        Date startTime = (Date)this.getModel().getValue("starttime");
        Date endTime = (Date)this.getModel().getValue("endtime");
        if (StringUtils.equals((CharSequence)name, (CharSequence)"starttime") && (startTime = (Date)newValue) != null && endTime != null && endTime.compareTo(startTime) < 0) {
            this.getModel().setValue(name, null);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672c\u6bb5\u4e1a\u52a1\u5f00\u59cb\u65f6\u95f4\u5e94\u5c0f\u4e8e\u672c\u6bb5\u4e1a\u52a1\u7ed3\u675f\u65f6\u95f4\u3002", (String)"ImageProgressReportEditPlugin_18", (String)"pmgt-pmfs-formplugin", (Object[])new Object[0]));
        }
        if (StringUtils.equals((CharSequence)name, (CharSequence)"endtime")) {
            endTime = (Date)newValue;
            if (startTime != null && endTime != null && endTime.compareTo(startTime) < 0) {
                this.getModel().setValue(name, null);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672c\u6bb5\u4e1a\u52a1\u7ed3\u675f\u65f6\u95f4\u5e94\u5927\u4e8e\u672c\u6bb5\u4e1a\u52a1\u5f00\u59cb\u65f6\u95f4\u3002", (String)"ImageProgressReportEditPlugin_19", (String)"pmgt-pmfs-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void setStartAndEndTime(Object newValue) {
        if (newValue != null) {
            DynamicObject wbs = BusinessDataServiceHelper.loadSingle((Object)((DynamicObject)newValue).getPkValue(), (String)"pmbs_wbs");
            this.getModel().setValue("starttime", wbs.get("planstarttime"));
            this.getModel().setValue("endtime", wbs.get("planendtime"));
        }
    }

    private void setEntryStartAndEndTime(Object newValue, int rowIndex) {
        if (newValue != null) {
            this.getModel().setValue("entrystarttime", ((DynamicObject)newValue).get("planstarttime"), rowIndex);
            this.getModel().setValue("entryendtime", ((DynamicObject)newValue).get("planendtime"), rowIndex);
        }
    }

    private void periodStrUpdatePeriod() {
        String dateFormat = this.getDateTimeFormatString();
        String periodStr = (String)this.getModel().getValue("periodstr");
        Date period = (Date)this.getModel().getValue("period");
        if (StringUtils.isBlank((CharSequence)dateFormat) || StringUtils.isBlank((CharSequence)periodStr) || period == null) {
            return;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
        try {
            this.getModel().setValue("period", (Object)sdf.parse(periodStr));
        }
        catch (ParseException e) {
            throw new KDBizException(e.getMessage());
        }
    }

    private void changeStartAndEndTimeFormat(DynamicObject project) {
        if (project == null) {
            return;
        }
        DynamicObject initialize = ProjectInitializeHelper.getInstance().getProjectInitialize(project);
        if (initialize == null) {
            return;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("type", "datetime");
        String timeType = initialize.getString("timetype");
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        if (timeType != null) {
            if (TimeTypeEnum.FORMAT2DAY.getValue().equals(timeType)) {
                DateControlHelper.changeDateMask((IFormView)this.getView(), (String)"starttime", (String)DAY_MASK);
                DateControlHelper.changeDateMask((IFormView)this.getView(), (String)"endtime", (String)DAY_MASK);
                map.put("mask", DAY_MASK);
            } else if (TimeTypeEnum.FORMAT2HOUR.getValue().equals(timeType)) {
                DateControlHelper.changeDateMask((IFormView)this.getView(), (String)"starttime", (String)HOUR_MASK);
                DateControlHelper.changeDateMask((IFormView)this.getView(), (String)"endtime", (String)HOUR_MASK);
                map.put("mask", HOUR_MASK);
            }
            entryGrid.setColumnProperty("entrystarttime", "editor", map);
            entryGrid.setColumnProperty("entryendtime", "editor", map);
        }
    }

    private void changeProject(DynamicObject project) {
        this.getModel().setValue("wbs", null);
        this.getModel().setValue("currentinvest", null);
        this.getModel().setValue("currentprogress", null);
        this.getModel().deleteEntryData("entryentity");
        this.changeStartAndEndTimeFormat(project);
        if (project != null) {
            DynamicObject projectInitialize = ProjectInitializeHelper.getInstance().getProjectInitialize(project);
            if (projectInitialize == null) {
                return;
            }
            String splitDimension = projectInitialize.getString("splitdimension");
            boolean splitByCount = projectInitialize.getBoolean("splitbycount");
            this.getView().setEnable(Boolean.valueOf(!splitByCount), new String[]{"periodtype"});
            if (SplitDimensionEnum.BY_MONTH.getValue().equals(splitDimension)) {
                this.getModel().setValue("periodtype", (Object)PeriodTypeEnum.MONTH.getValue());
            } else if (SplitDimensionEnum.BY_DAY.getValue().equals(splitDimension)) {
                this.getModel().setValue("periodtype", (Object)PeriodTypeEnum.DAY.getValue());
            } else if (SplitDimensionEnum.BY_HOUR.getValue().equals(splitDimension)) {
                this.getModel().setValue("periodtype", (Object)PeriodTypeEnum.HOUR.getValue());
            }
        }
        this.showOrHideSpiltByCountField();
    }

    protected void showOrHideSpiltByCountField() {
        DynamicObject project = (DynamicObject)this.getModel().getValue("project");
        DynamicObject projectInitialize = ProjectInitializeHelper.getInstance().getProjectInitialize(project);
        if (projectInitialize == null || !projectInitialize.getBoolean("splitbycount")) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"investbyperiod", "allinvestbyperiod", "progressbyperiod", "allprogressbyperiod", "entryinvestbyperiod", "entryallinvestbyperiod", "entryprogressbyperiod", "entryallprogressbyperiod"});
        } else {
            Boolean multiWbs = (Boolean)this.getModel().getValue("mutiwbs");
            if (multiWbs.booleanValue()) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"investbyperiod"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"allinvestbyperiod"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"progressbyperiod"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"allprogressbyperiod"});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"entryinvestbyperiod"});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"entryallinvestbyperiod"});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"entryprogressbyperiod"});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"entryallprogressbyperiod"});
            } else {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"investbyperiod"});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"allinvestbyperiod"});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"progressbyperiod"});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"allprogressbyperiod"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"entryinvestbyperiod"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"entryallinvestbyperiod"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"entryprogressbyperiod"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"entryallprogressbyperiod"});
            }
        }
    }

    private void changCurrency() {
        Object project = this.getModel().getValue("project");
        if (project != null) {
            QFilter proIdFilter = new QFilter("pro", "=", ((DynamicObject)project).getPkValue());
            DynamicObject projectApproval = BusinessDataServiceHelper.loadSingle((String)"pmas_pro_approval", (String)CurrencyField, (QFilter[])new QFilter[]{proIdFilter});
            if (projectApproval != null) {
                this.getModel().setValue(CurrencyField, (Object)projectApproval.getDynamicObject(CurrencyField));
            }
        } else {
            this.getModel().setValue(CurrencyField, null);
        }
        this.getView().updateView();
    }

    public void changePeriodStr() {
        Date period = (Date)this.getModel().getValue("period");
        String periodType = (String)this.getModel().getValue("periodtype");
        if (PeriodTypeEnum.MONTH.getValue().equals(periodType) && period != null) {
            this.getModel().setValue("periodstr", (Object)DateUtils.dateToString2((Date)period));
        } else if (PeriodTypeEnum.DAY.getValue().equals(periodType) && period != null) {
            this.getModel().setValue("periodstr", (Object)DateUtils.dateToString1((Date)period));
        } else if (PeriodTypeEnum.HOUR.getValue().equals(periodType) && period != null) {
            this.getModel().setValue("periodstr", (Object)DateUtils.dateToString3((Date)period));
        }
    }

    protected void setAmountAndPercentageByPeriod() {
        block13: {
            DynamicObject[] imageReports;
            QFilter statusFilter;
            QFilter projectFilter;
            String periodType;
            Date period;
            block12: {
                this.getModel().setValue("investbyperiod", (Object)BigDecimal.ZERO);
                this.getModel().setValue("progressbyperiod", (Object)BigDecimal.ZERO);
                DynamicObjectCollection wbsEntryEntity = this.getModel().getEntryEntity("entryentity");
                for (int index = 0; index < wbsEntryEntity.size(); ++index) {
                    this.getModel().setValue("entryinvestbyperiod", (Object)BigDecimal.ZERO, index);
                    this.getModel().setValue("entryprogressbyperiod", (Object)BigDecimal.ZERO, index);
                }
                DynamicObject project = (DynamicObject)this.getModel().getValue("project");
                period = (Date)this.getModel().getValue("period");
                periodType = (String)this.getModel().getValue("periodtype");
                if (project == null || period == null || periodType == null) {
                    return;
                }
                DynamicObject projectInitialize = ProjectInitializeHelper.getInstance().getProjectInitialize(project);
                if (projectInitialize == null) {
                    return;
                }
                boolean splitByCount = projectInitialize.getBoolean("splitbycount");
                if (!splitByCount) {
                    return;
                }
                if (!this.checkPeriodInRange(projectInitialize, period)) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u201c\u586b\u62a5\u671f\u95f4\u201d\u6240\u9009\u503c\u4e0d\u5c5e\u4e8e\u9879\u76ee%s\u201cWBS\u6570\u91cf\u62c6\u5206\u8bbe\u7f6e\u201d\u7684\u671f\u95f4\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"ImageProgressReportEditPlugin_10", (String)"pmgt-pmfs-formplugin", (Object[])new Object[0]), project.get("number")));
                    this.getModel().setValue("period", null);
                    return;
                }
                projectFilter = new QFilter("project", "=", project.getPkValue());
                statusFilter = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
                if (!((Boolean)this.getModel().getValue("mutiwbs")).booleanValue()) break block12;
                for (int index = 0; index < wbsEntryEntity.size(); ++index) {
                    DynamicObject[] imageReports2;
                    DynamicObject wbs = ((DynamicObject)wbsEntryEntity.get(index)).getDynamicObject("entrywbs");
                    if (wbs == null) continue;
                    Long wbsId = Long.parseLong(String.valueOf(wbs.getPkValue()));
                    QFilter wbsFilter = new QFilter("wbs", "=", wbs.getPkValue()).or("entryentity.entrywbs", "=", wbs.getPkValue());
                    for (DynamicObject imageReport : imageReports2 = BusinessDataServiceHelper.load((String)"pmfs_progressreport", (String)"id", (QFilter[])new QFilter[]{projectFilter, wbsFilter, statusFilter}, (String)"auditdate desc")) {
                        imageReport = BusinessDataServiceHelper.loadSingle((Object)imageReport.getPkValue(), (String)"pmfs_progressreport");
                        Date imageReportPeriod = imageReport.getDate("period");
                        if (!(PeriodTypeEnum.MONTH.getValue().equals(periodType) && DateUtil.compareByMonth((Date)period, (Date)imageReportPeriod) == 0 || PeriodTypeEnum.DAY.getValue().equals(periodType) && DateUtil.compareByDay((Date)period, (Date)imageReportPeriod) == 0) && (!PeriodTypeEnum.HOUR.getValue().equals(periodType) || DateUtil.compareByHour((Date)period, (Date)imageReportPeriod) != 0)) continue;
                        if (imageReport.getBoolean("mutiwbs")) {
                            for (DynamicObject entry : imageReport.getDynamicObjectCollection("entryentity")) {
                                if (!wbsId.equals(entry.getDynamicObject("entrywbs").getPkValue())) continue;
                                this.getModel().setValue("entryinvestbyperiod", (Object)entry.getBigDecimal("entryallinvestbyperiod"), index);
                                this.getModel().setValue("entryprogressbyperiod", (Object)entry.getBigDecimal("entryallprogressbyperiod"), index);
                                return;
                            }
                            continue;
                        }
                        this.getModel().setValue("entryinvestbyperiod", (Object)imageReport.getBigDecimal("allinvestbyperiod"), index);
                        this.getModel().setValue("entryprogressbyperiod", (Object)imageReport.getBigDecimal("allprogressbyperiod"), index);
                        return;
                    }
                }
                break block13;
            }
            DynamicObject wbs = (DynamicObject)this.getModel().getValue("wbs");
            if (wbs == null) break block13;
            Long wbsId = Long.parseLong(String.valueOf(wbs.getPkValue()));
            QFilter wbsFilter = new QFilter("wbs", "=", wbs.getPkValue()).or("entryentity.entrywbs", "=", wbs.getPkValue());
            for (DynamicObject imageReport : imageReports = BusinessDataServiceHelper.load((String)"pmfs_progressreport", (String)"id", (QFilter[])new QFilter[]{projectFilter, wbsFilter, statusFilter}, (String)"auditdate desc")) {
                imageReport = BusinessDataServiceHelper.loadSingle((Object)imageReport.getPkValue(), (String)"pmfs_progressreport");
                Date imageReportPeriod = imageReport.getDate("period");
                if (!(PeriodTypeEnum.MONTH.getValue().equals(periodType) && DateUtil.compareByMonth((Date)period, (Date)imageReportPeriod) == 0 || PeriodTypeEnum.DAY.getValue().equals(periodType) && DateUtil.compareByDay((Date)period, (Date)imageReportPeriod) == 0) && (!PeriodTypeEnum.HOUR.getValue().equals(periodType) || DateUtil.compareByHour((Date)period, (Date)imageReportPeriod) != 0)) continue;
                if (imageReport.getBoolean("mutiwbs")) {
                    for (DynamicObject entry : imageReport.getDynamicObjectCollection("entryentity")) {
                        if (!wbsId.equals(entry.getDynamicObject("entrywbs").getPkValue())) continue;
                        this.getModel().setValue("investbyperiod", (Object)entry.getBigDecimal("entryallinvestbyperiod"));
                        this.getModel().setValue("progressbyperiod", (Object)entry.getBigDecimal("entryallprogressbyperiod"));
                        return;
                    }
                    continue;
                }
                this.getModel().setValue("investbyperiod", (Object)imageReport.getBigDecimal("allinvestbyperiod"));
                this.getModel().setValue("progressbyperiod", (Object)imageReport.getBigDecimal("allprogressbyperiod"));
                return;
            }
        }
    }

    protected boolean checkPeriodInRange(DynamicObject projectInitialize, Date period) {
        if (projectInitialize.getBoolean("splitbycount")) {
            String splitDimension = projectInitialize.getString("splitdimension");
            DynamicObjectCollection splitEntries = projectInitialize.getDynamicObjectCollection("splitentry");
            for (DynamicObject splitEntry : splitEntries) {
                for (DynamicObject subEntry : splitEntry.getDynamicObjectCollection("subsplitentry")) {
                    Date subDate = subEntry.getDate("subdate");
                    if (SplitDimensionEnum.BY_MONTH.getValue().equals(splitDimension) && DateUtil.compareByMonth((Date)period, (Date)subDate) == 0) {
                        return true;
                    }
                    if (SplitDimensionEnum.BY_DAY.getValue().equals(splitDimension) && DateUtil.compareByDay((Date)period, (Date)subDate) == 0) {
                        return true;
                    }
                    if (!SplitDimensionEnum.BY_HOUR.getValue().equals(splitDimension) || DateUtil.compareByHour((Date)period, (Date)subDate) != 0) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String name;
        super.beforeF7Select(event);
        switch (name = event.getProperty().getName()) {
            case "wbs": {
                Set<Object> excludeWbs = this.wbsF7Select(event);
                this.setExcludeFilterAndCustomParam(excludeWbs, event);
                break;
            }
            case "entrywbs": {
                this.entryWbsF7Select(event);
                break;
            }
        }
    }

    private void entryWbsF7Select(BeforeF7SelectEvent event) {
        Set<Object> excludeWbs = this.wbsF7Select(event);
        if (excludeWbs == null) {
            return;
        }
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        for (DynamicObject entry : entryEntity) {
            DynamicObject entryWbs = entry.getDynamicObject("entrywbs");
            if (entryWbs == null) continue;
            excludeWbs.add(entryWbs.getPkValue());
        }
        this.setExcludeFilterAndCustomParam(excludeWbs, event);
    }

    private void setExcludeFilterAndCustomParam(Set<Object> excludeWbs, BeforeF7SelectEvent event) {
        if (excludeWbs != null && !excludeWbs.isEmpty()) {
            QFilter selectFilter = new QFilter("id", "not in", excludeWbs);
            event.addCustomQFilter(selectFilter);
        }
        event.getFormShowParameter().setCustomParam("excludeWbs", excludeWbs);
    }

    private Set<Object> wbsF7Select(BeforeF7SelectEvent event) {
        DynamicObject project = (DynamicObject)this.getModel().getValue("project");
        if (project == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9879\u76ee\u3002", (String)"ImageProgressReportEditPlugin_20", (String)"pmgt-pmfs-formplugin", (Object[])new Object[0]));
            event.setCancel(true);
            return null;
        }
        QFilter projectFilter = new QFilter("project", "=", project.getPkValue());
        DynamicObject[] wbsArr = BusinessDataServiceHelper.load((String)"pmbs_wbs", (String)"id", (QFilter[])new QFilter[]{projectFilter});
        HashSet<Object> wbsIdSet = new HashSet<Object>(wbsArr.length);
        for (DynamicObject wbs : wbsArr) {
            wbsIdSet.add(wbs.getPkValue());
        }
        QFilter selectFilter = new QFilter("id", "in", (Object)wbsIdSet.toArray());
        event.addCustomQFilter(selectFilter);
        QFilter auditFilter = new QFilter("billstatus", "!=", (Object)StatusEnum.CHECKED.getValue());
        QFilter excludeSelf = new QFilter("id", "!=", this.getModel().getDataEntity().getPkValue());
        DynamicObject[] imageProgressArr = BusinessDataServiceHelper.load((String)"pmfs_progressreport", (String)"billno", (QFilter[])new QFilter[]{projectFilter, auditFilter, excludeSelf});
        HashSet<Object> excludeWbs = new HashSet<Object>(10);
        for (DynamicObject imageProgress : imageProgressArr) {
            boolean multiWbs = (imageProgress = BusinessDataServiceHelper.loadSingle((Object)imageProgress.getPkValue(), (String)"pmfs_progressreport")).getBoolean("mutiwbs");
            if (multiWbs) {
                DynamicObjectCollection entryEntity = imageProgress.getDynamicObjectCollection("entryentity");
                for (DynamicObject entry : entryEntity) {
                    DynamicObject entryWbs = entry.getDynamicObject("entrywbs");
                    if (entryWbs == null) continue;
                    excludeWbs.add(entryWbs.getPkValue());
                }
                continue;
            }
            DynamicObject wbs = imageProgress.getDynamicObject("wbs");
            if (wbs == null) continue;
            excludeWbs.add(wbs.getPkValue());
        }
        return excludeWbs;
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        String callBackId;
        super.confirmCallBack(event);
        switch (callBackId = event.getCallBackId()) {
            case "samePeriod": {
                if (!event.getResult().equals((Object)MessageBoxResult.Yes)) break;
                this.getView().invokeOperation("submit");
                break;
            }
            case "mutiWbsConfirmCallBack": {
                this.muitWbsConfirmCallBack(event);
                break;
            }
        }
    }

    protected void showOrHideEntry(Boolean showEntry) {
        if (showEntry.booleanValue()) {
            DynamicObject project = (DynamicObject)this.getModel().getValue("project");
            DynamicObject projectInitialize = ProjectInitializeHelper.getInstance().getProjectInitialize(project);
            boolean noSplitByCount = projectInitialize == null || !projectInitialize.getBoolean("splitbycount");
            this.getView().setVisible(Boolean.valueOf(!noSplitByCount), new String[]{"entryinvestbyperiod", "entryallinvestbyperiod", "entryprogressbyperiod", "entryallprogressbyperiod"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{WBS_ENTRY_FLEX});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"wbs", "starttime", "endtime", "currentinvest", "periodinvest", "allinvest", "currentprogress", "periodprogress", "allprogress", "investbyperiod", "allinvestbyperiod", "progressbyperiod", "allprogressbyperiod"});
            this.getModel().beginInit();
            this.getModel().setValue("wbs", null);
            this.getModel().setValue("starttime", null);
            this.getModel().setValue("endtime", null);
            this.getModel().setValue("currentinvest", null);
            this.getModel().setValue("periodinvest", null);
            this.getModel().setValue("allinvest", null);
            this.getModel().setValue("currentprogress", null);
            this.getModel().setValue("periodprogress", null);
            this.getModel().setValue("allprogress", null);
            this.getModel().setValue("investbyperiod", null);
            this.getModel().setValue("allinvestbyperiod", null);
            this.getModel().setValue("progressbyperiod", null);
            this.getModel().setValue("allprogressbyperiod", null);
            this.getModel().endInit();
            this.getView().updateView(FS_BASE_INFO);
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{WBS_ENTRY_FLEX});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"wbs", "starttime", "endtime", "currentinvest", "periodinvest", "allinvest", "currentprogress", "periodprogress", "allprogress"});
            DynamicObject project = (DynamicObject)this.getModel().getValue("project");
            DynamicObject projectInitialize = ProjectInitializeHelper.getInstance().getProjectInitialize(project);
            if (projectInitialize == null || !projectInitialize.getBoolean("splitbycount")) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"investbyperiod", "allinvestbyperiod", "progressbyperiod", "allprogressbyperiod"});
            } else {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"investbyperiod", "allinvestbyperiod", "progressbyperiod", "allprogressbyperiod"});
            }
            this.getModel().deleteEntryData("entryentity");
            this.getView().setVisible(Boolean.valueOf(false), new String[]{PICTURE_FLEX});
        }
    }

    protected void muitWbsConfirmCallBack(MessageBoxClosedEvent event) {
        boolean newMultiWbs = Boolean.parseBoolean(this.getPageCache().get(NEW_MUTI_WBS));
        if (event.getResult().equals((Object)MessageBoxResult.Cancel)) {
            this.getModel().beginInit();
            this.getModel().setValue("mutiwbs", (Object)(!newMultiWbs ? 1 : 0));
            this.getModel().endInit();
            this.showOrHideEntry(!newMultiWbs);
            this.getView().updateView("mutiwbs");
        } else if (event.getResult().equals((Object)MessageBoxResult.Yes)) {
            this.showOrHideEntry(newMultiWbs);
        }
    }

    private void mutiWbsChange(Boolean newMultiWbs) {
        this.getPageCache().put(NEW_MUTI_WBS, String.valueOf(newMultiWbs));
        if (newMultiWbs.booleanValue()) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u542f\u7528\u591aWBS\u6c47\u62a5\u5c06\u6e05\u9664\u5355\u636e\u5934WBS\u76f8\u5173\u6570\u636e\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\u3002", (String)"ImageProgressReportEditPlugin_21", (String)"pmgt-pmfs-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(MUTI_WBS_CONFIRM_CALL_BACK));
        } else {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u4e0d\u542f\u7528\u591aWBS\u6c47\u62a5\u5c06\u6e05\u9664WBS\u8fdb\u5ea6\u6c47\u62a5\u5206\u5f55\u6570\u636e\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\uff1f", (String)"ImageProgressReportEditPlugin_22", (String)"pmgt-pmfs-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(MUTI_WBS_CONFIRM_CALL_BACK));
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        super.entryRowClick(evt);
        Control source = (Control)evt.getSource();
        int rowIndex = evt.getRow();
        if (StringUtils.equals((CharSequence)"entryentity", (CharSequence)source.getKey())) {
            this.resetPictureList(rowIndex);
        }
    }

    private void resetPictureList(int rowIndex) {
        DynamicObject entry = this.getModel().getEntryRowEntity("entryentity", rowIndex);
        DynamicObjectCollection wbsProgressFiles = entry.getDynamicObjectCollection("wbsprogress");
        ImageList imageList = (ImageList)this.getView().getControl(PICTURE_LIST);
        if (wbsProgressFiles != null && wbsProgressFiles.size() > 0) {
            Label pictureTip = (Label)this.getControl(PICTURE_TIP);
            DynamicObject entryWbs = (DynamicObject)this.getModel().getValue("entrywbs", rowIndex);
            this.getView().setVisible(Boolean.valueOf(true), new String[]{PICTURE_FLEX});
            pictureTip.setText(String.format(ResManager.loadKDString((String)"%1$s%2$s\u5f62\u8c61\u8fdb\u5ea6\u56fe\u7247", (String)"ImageProgressReportEditPlugin_8", (String)"pmgt-pmfs-formplugin", (Object[])new Object[0]), entryWbs != null ? entryWbs.getString("name") : "", entryWbs != null ? ResManager.loadKDString((String)"\u7684", (String)"ImageProgressReportEditPlugin_9", (String)"pmgt-pmfs-formplugin", (Object[])new Object[0]) : ""));
            String[] urls = new String[wbsProgressFiles.size()];
            for (int index = 0; index < wbsProgressFiles.size(); ++index) {
                Long bdAttachmentId = ((DynamicObject)wbsProgressFiles.get(index)).getLong("fbasedataid_id");
                DynamicObject bdAttachment = BusinessDataServiceHelper.loadSingle((Object)bdAttachmentId, (String)"bd_attachment");
                urls[index] = bdAttachment.getString("url");
                LOG.info("resetPictureList index: {}, url: {}", (Object)index, (Object)urls[index]);
            }
            imageList.setImageUrls(urls);
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{PICTURE_FLEX});
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String key;
        switch (key = args.getOperateKey()) {
            case "deleteentry": {
                EntryGrid entryEntity = (EntryGrid)this.getControl("entryentity");
                int[] selectRows = entryEntity.getSelectRows();
                if (selectRows.length > 0) {
                    this.resetPictureList(selectRows[0]);
                    break;
                }
                this.getView().setVisible(Boolean.valueOf(false), new String[]{PICTURE_FLEX});
                break;
            }
            case "newentry": {
                EntryGrid entryEntity = (EntryGrid)this.getControl("entryentity");
                int[] selectRows = entryEntity.getSelectRows();
                if (selectRows.length <= 0) break;
                this.resetPictureList(selectRows[0]);
                break;
            }
            case "unsubmit": 
            case "unaudit": {
                DynamicObject project = (DynamicObject)this.getModel().getValue("project");
                Date period = (Date)this.getModel().getValue("period");
                this.getProjectInvestCompletion(project, period);
                break;
            }
        }
    }

    private void getProjectInvestCompletion(DynamicObject project, Date period) {
        BigDecimal estAmount = BigDecimal.ZERO;
        BigDecimal completedInvestAmount = BigDecimal.ZERO;
        BigDecimal lastYearInvestAmount = BigDecimal.ZERO;
        BigDecimal toLastYearAmount = BigDecimal.ZERO;
        BigDecimal currYInvestAmount = BigDecimal.ZERO;
        BigDecimal toLastMInvestAmount = BigDecimal.ZERO;
        BigDecimal currMInvestAmount = BigDecimal.ZERO;
        if (project != null) {
            QFilter checkedFilter = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
            QFilter executiveVersionFilter = new QFilter("executiveversion", "=", (Object)Boolean.TRUE);
            QFilter projectFilter = new QFilter("project", "=", project.getPkValue());
            DynamicObject projectInitialize = QueryServiceHelper.queryOne((String)"pmfs_projectinitialize", (String)"estamount", (QFilter[])new QFilter[]{projectFilter, executiveVersionFilter, checkedFilter});
            if (projectInitialize != null) {
                estAmount = projectInitialize.getBigDecimal("estamount");
            }
            checkedFilter = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
            projectFilter = new QFilter("project", "=", project.getPkValue());
            DynamicObject[] imageProgressReports = BusinessDataServiceHelper.load((String)"pmfs_progressreport", (String)"id", (QFilter[])new QFilter[]{projectFilter, checkedFilter});
            if (imageProgressReports != null && imageProgressReports.length > 0) {
                DynamicObject[] imageProgressReportArray = BusinessDataServiceHelper.load((Object[])Arrays.stream(imageProgressReports).map(DataEntityBase::getPkValue).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmfs_progressreport"));
                completedInvestAmount = Arrays.stream(imageProgressReportArray).filter(it -> !it.getBoolean("mutiwbs")).map(it -> it.getBigDecimal("periodinvest")).reduce(BigDecimal.ZERO, BigDecimal::add);
                completedInvestAmount = Arrays.stream(imageProgressReportArray).filter(it -> it.getBoolean("mutiwbs")).map(it -> it.getDynamicObjectCollection("entryentity")).flatMap(Collection::stream).map(it -> it.getBigDecimal("entryperiodinvest")).reduce(completedInvestAmount, BigDecimal::add);
                if (period != null) {
                    Calendar nowCalendar = Calendar.getInstance();
                    nowCalendar.setTime(period);
                    lastYearInvestAmount = Arrays.stream(imageProgressReportArray).filter(it -> !it.getBoolean("mutiwbs")).filter(it -> {
                        Calendar dbCalendar = Calendar.getInstance();
                        dbCalendar.setTime(it.getDate("period"));
                        return nowCalendar.get(1) - 1 == dbCalendar.get(1);
                    }).map(it -> it.getBigDecimal("periodinvest")).reduce(BigDecimal.ZERO, BigDecimal::add);
                    lastYearInvestAmount = Arrays.stream(imageProgressReportArray).filter(it -> it.getBoolean("mutiwbs")).filter(it -> {
                        Calendar dbCalendar = Calendar.getInstance();
                        dbCalendar.setTime(it.getDate("period"));
                        return nowCalendar.get(1) - 1 == dbCalendar.get(1);
                    }).map(it -> it.getDynamicObjectCollection("entryentity")).flatMap(Collection::stream).map(it -> it.getBigDecimal("entryperiodinvest")).reduce(lastYearInvestAmount, BigDecimal::add);
                    toLastYearAmount = Arrays.stream(imageProgressReportArray).filter(it -> !it.getBoolean("mutiwbs")).filter(it -> {
                        Calendar dbCalendar = Calendar.getInstance();
                        dbCalendar.setTime(it.getDate("period"));
                        return nowCalendar.get(1) > dbCalendar.get(1);
                    }).map(it -> it.getBigDecimal("periodinvest")).reduce(BigDecimal.ZERO, BigDecimal::add);
                    toLastYearAmount = Arrays.stream(imageProgressReportArray).filter(it -> it.getBoolean("mutiwbs")).filter(it -> {
                        Calendar dbCalendar = Calendar.getInstance();
                        dbCalendar.setTime(it.getDate("period"));
                        return nowCalendar.get(1) > dbCalendar.get(1);
                    }).map(it -> it.getDynamicObjectCollection("entryentity")).flatMap(Collection::stream).map(it -> it.getBigDecimal("entryperiodinvest")).reduce(toLastYearAmount, BigDecimal::add);
                    currYInvestAmount = Arrays.stream(imageProgressReportArray).filter(it -> !it.getBoolean("mutiwbs")).filter(it -> {
                        Calendar dbCalendar = Calendar.getInstance();
                        dbCalendar.setTime(it.getDate("period"));
                        return nowCalendar.get(1) == dbCalendar.get(1);
                    }).map(it -> it.getBigDecimal("periodinvest")).reduce(BigDecimal.ZERO, BigDecimal::add);
                    currYInvestAmount = Arrays.stream(imageProgressReportArray).filter(it -> it.getBoolean("mutiwbs")).filter(it -> {
                        Calendar dbCalendar = Calendar.getInstance();
                        dbCalendar.setTime(it.getDate("period"));
                        return nowCalendar.get(1) == dbCalendar.get(1);
                    }).map(it -> it.getDynamicObjectCollection("entryentity")).flatMap(Collection::stream).map(it -> it.getBigDecimal("entryperiodinvest")).reduce(currYInvestAmount, BigDecimal::add);
                    toLastMInvestAmount = Arrays.stream(imageProgressReportArray).filter(it -> !it.getBoolean("mutiwbs")).filter(it -> {
                        Calendar dbCalendar = Calendar.getInstance();
                        dbCalendar.setTime(it.getDate("period"));
                        return nowCalendar.get(1) == dbCalendar.get(1) && nowCalendar.get(2) > dbCalendar.get(2);
                    }).map(it -> it.getBigDecimal("periodinvest")).reduce(BigDecimal.ZERO, BigDecimal::add);
                    toLastMInvestAmount = Arrays.stream(imageProgressReportArray).filter(it -> it.getBoolean("mutiwbs")).filter(it -> {
                        Calendar dbCalendar = Calendar.getInstance();
                        dbCalendar.setTime(it.getDate("period"));
                        return nowCalendar.get(1) == dbCalendar.get(1) && nowCalendar.get(2) > dbCalendar.get(2);
                    }).map(it -> it.getDynamicObjectCollection("entryentity")).flatMap(Collection::stream).map(it -> it.getBigDecimal("entryperiodinvest")).reduce(toLastMInvestAmount, BigDecimal::add);
                    currMInvestAmount = Arrays.stream(imageProgressReportArray).filter(it -> !it.getBoolean("mutiwbs")).filter(it -> {
                        Calendar dbCalendar = Calendar.getInstance();
                        dbCalendar.setTime(it.getDate("period"));
                        return nowCalendar.get(1) == dbCalendar.get(1) && nowCalendar.get(2) == dbCalendar.get(2);
                    }).map(it -> it.getBigDecimal("periodinvest")).reduce(BigDecimal.ZERO, BigDecimal::add);
                    currMInvestAmount = Arrays.stream(imageProgressReportArray).filter(it -> it.getBoolean("mutiwbs")).filter(it -> {
                        Calendar dbCalendar = Calendar.getInstance();
                        dbCalendar.setTime(it.getDate("period"));
                        return nowCalendar.get(1) == dbCalendar.get(1) && nowCalendar.get(2) == dbCalendar.get(2);
                    }).map(it -> it.getDynamicObjectCollection("entryentity")).flatMap(Collection::stream).map(it -> it.getBigDecimal("entryperiodinvest")).reduce(currMInvestAmount, BigDecimal::add);
                }
            }
        }
        this.getModel().setValue("estamount", (Object)estAmount);
        this.getModel().setValue("completedinvestamount", (Object)completedInvestAmount);
        this.getModel().setValue("lastyearinvestamount", (Object)lastYearInvestAmount);
        this.getModel().setValue("tolastyearamount", (Object)toLastYearAmount);
        this.getModel().setValue("curryinvestamount", (Object)currYInvestAmount);
        this.getModel().setValue("tolastminvestamount", (Object)toLastMInvestAmount);
        this.getModel().setValue("currminvestamount", (Object)currMInvestAmount);
    }
}

