/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmfs.formplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmgt.pmbs.business.helper.UserOrgRangeHelper;
import kd.pmgt.pmbs.business.utils.ReportConfigUtils;
import kd.pmgt.pmbs.common.enums.BudgetSourceTypeEnum;
import kd.pmgt.pmbs.common.enums.BudgetStageEnum;
import kd.pmgt.pmbs.common.enums.ConclusionEnum;
import kd.pmgt.pmbs.common.enums.ProjectStatusEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmbs.common.enums.approval.ApprovalStatusEnum;
import kd.pmgt.pmbs.common.utils.OrgTreeUtils;
import kd.pmgt.pmbs.common.utils.ProjectPermissionHelper;
import kd.pmgt.pmfs.formplugin.base.AbstractPmfsBillPlugin;

public class MajorapprovalBillPlugin
extends AbstractPmfsBillPlugin
implements ClickListener,
RowClickEventListener,
HyperLinkClickListener,
BeforeF7SelectListener {
    private static final String DELETEPRO = "deletepro";
    private static final String ADDPRO = "addpro";
    private static final String INDEX_PANEL = "indexpanel";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String userId = RequestContext.get().getUserId();
        this.getModel().setValue("approvalperson", (Object)userId);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Container projectnamepanela = (Container)this.getControl("projectnamepanela");
        projectnamepanela.addClickListener((ClickListener)this);
        Container outestimatepanela = (Container)this.getControl("outestimatepanela");
        outestimatepanela.addClickListener((ClickListener)this);
        Container inestimatepanela = (Container)this.getControl("inestimatepanela");
        inestimatepanela.addClickListener((ClickListener)this);
        Container taskpanela = (Container)this.getControl("taskpanela");
        taskpanela.addClickListener((ClickListener)this);
        Container resultnumbepanela = (Container)this.getControl("resultnumbepanela");
        resultnumbepanela.addClickListener((ClickListener)this);
        CardEntry cardEntry = (CardEntry)this.getControl("listmodelentry");
        cardEntry.addRowClickListener((RowClickEventListener)this);
        cardEntry.addHyperClickListener((HyperLinkClickListener)this);
        BasedataEdit reportOrg = (BasedataEdit)this.getControl("reportorg");
        reportOrg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit approvalPerson = (BasedataEdit)this.getControl("approvalperson");
        approvalPerson.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterBindData(EventObject e) {
        DynamicObject proEntry;
        super.afterBindData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{INDEX_PANEL});
        CardEntry cardEntry = (CardEntry)this.getControl("listmodelentry");
        DynamicObjectCollection proEntryCol = this.getModel().getEntryEntity("listmodelentry");
        if (proEntryCol != null && !proEntryCol.isEmpty()) {
            cardEntry.selectRows(0, true);
            for (DynamicObject proEntry2 : proEntryCol) {
                DynamicObject project = proEntry2.getDynamicObject("project");
                proEntry2.set("proname", (Object)project.getString("name"));
            }
        }
        if (null != (proEntry = this.getModel().getEntryRowEntity("listmodelentry", 0))) {
            DynamicObjectCollection subCardCol = proEntry.getDynamicObjectCollection("subentryentity");
            if (subCardCol != null && !subCardCol.isEmpty()) {
                DynamicObject subCardObject = (DynamicObject)subCardCol.get(0);
                this.setFeasibleResultPanel(subCardObject);
            }
            this.getView().setVisible(Boolean.TRUE, new String[]{INDEX_PANEL});
        }
        this.getView().updateView("listmodelentry");
    }

    public void entryRowClick(RowClickEvent evt) {
        Control source = (Control)evt.getSource();
        int index = evt.getRow();
        if (index < 0) {
            return;
        }
        if (StringUtils.equals((CharSequence)"listmodelentry", (CharSequence)source.getKey())) {
            DynamicObjectCollection subCardCol;
            DynamicObject proEntry = this.getModel().getEntryRowEntity("listmodelentry", index);
            if (null != proEntry && (subCardCol = proEntry.getDynamicObjectCollection("subentryentity")) != null && !subCardCol.isEmpty()) {
                DynamicObject subCardObject = (DynamicObject)subCardCol.get(0);
                this.setFeasibleResultPanel(subCardObject);
            }
            this.getView().setVisible(Boolean.TRUE, new String[]{INDEX_PANEL});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        Object oldValue = changeSet[0].getOldValue();
        if (StringUtils.equals((CharSequence)propertyName, (CharSequence)"proresult")) {
            int curIndex = this.getModel().getEntryCurrentRowIndex("listmodelentry");
            DynamicObjectCollection proEntries = this.getModel().getDataEntity(true).getDynamicObjectCollection("listmodelentry");
            DynamicObject proEntry = (DynamicObject)proEntries.get(curIndex);
            DynamicObjectCollection subCardCol = proEntry.getDynamicObjectCollection("subentryentity");
            if (subCardCol != null && !subCardCol.isEmpty()) {
                DynamicObject subCardObject = (DynamicObject)subCardCol.get(0);
                this.setFeasibleResultPanel(subCardObject);
                String proResult = subCardObject.getString("proresult");
                if (StringUtils.equals((CharSequence)proResult, (CharSequence)ConclusionEnum.PASS_S.getValue())) {
                    this.getModel().setValue("prolabel", (Object)proResult, curIndex);
                    subCardObject.set("reportorg", null);
                    subCardObject.set("approvalresult", (Object)ConclusionEnum.PASS_S.getValue());
                } else if (StringUtils.equals((CharSequence)proResult, (CharSequence)ConclusionEnum.FAILED_S.getValue())) {
                    this.getModel().setValue("prolabel", (Object)proResult, curIndex);
                    subCardObject.set("reportorg", null);
                    subCardObject.set("approvalresult", (Object)ConclusionEnum.FAILED_S.getValue());
                } else if (StringUtils.equals((CharSequence)proResult, (CharSequence)ConclusionEnum.REPORT_S.getValue())) {
                    this.getModel().setValue("prolabel", (Object)ConclusionEnum.REPORT_S.getValue(), curIndex);
                    subCardObject.set("approvalresult", (Object)ConclusionEnum.APPROVAL_S.getValue());
                    this.setReportOrg(curIndex, oldValue);
                }
                this.getModel().updateEntryCache(proEntries);
            }
        }
    }

    private void setReportOrg(int parentModelIndex, Object oldValue) {
        String orgId;
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        DynamicObject project = (DynamicObject)this.getModel().getValue("project");
        DynamicObject kind = project.getDynamicObject("group");
        String kindId = kind != null ? kind.getPkValue().toString() : null;
        DynamicObject reportOrg = ReportConfigUtils.gainReportorg((String)kindId, (String)(orgId = org != null ? org.getPkValue().toString() : null), (String)"pmfs_majorapproval");
        if (reportOrg != null) {
            this.getModel().setValue("reportorg", (Object)reportOrg, 0, parentModelIndex);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u201c\u4e0a\u62a5\u7ec4\u7ec7\u8bbe\u7f6e\u201d\u4e3a\u7a7a\u3002\u8bf7\u5148\u5728\u201c\u9879\u76ee\u4e91>\u57fa\u7840\u8d44\u6599>\u4e0a\u62a5\u7ec4\u7ec7\u5c42\u7ea7\u8bbe\u7f6e\u201d\u4e2d\u7ef4\u62a4\u4e0a\u62a5\u7ec4\u7ec7\u3002", (String)"MajorapprovalBillPlugin_7", (String)"pmgt-pmfs-formplugin", (Object[])new Object[0]));
            this.getModel().beginInit();
            this.getModel().setValue("proresult", oldValue, 0, parentModelIndex);
            this.getModel().endInit();
            this.getView().updateView("proresult", 0, parentModelIndex);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate opertate = (FormOperate)args.getSource();
        String operateKey = opertate.getOperateKey();
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)ADDPRO)) {
            this.addProjectCardEntry(args);
        } else if (StringUtils.equals((CharSequence)operateKey, (CharSequence)DELETEPRO)) {
            this.deleteProjectCardEntry();
        }
    }

    private void deleteProjectCardEntry() {
        CardEntry projectStage = (CardEntry)this.getControl("listmodelentry");
        int[] rows = projectStage.getSelectRows();
        StringBuilder sb = new StringBuilder();
        if (null != rows) {
            for (int row : rows) {
                DynamicObject project = (DynamicObject)this.getModel().getValue("project", row);
                if (project == null) continue;
                sb.append(project.getString("name")).append(' ');
            }
            if (rows.length > 0) {
                String confirmMessage = String.format(ResManager.loadKDString((String)"\u786e\u8ba4\u5220\u9664\u9879\u76ee%s\uff1f", (String)"MajorapprovalBillPlugin_8", (String)"pmgt-pmfs-formplugin", (Object[])new Object[0]), sb.toString());
                this.getView().showConfirm(confirmMessage, MessageBoxOptions.OKCancel, new ConfirmCallBackListener(DELETEPRO, (IFormPlugin)this));
            }
        }
    }

    private void addProjectCardEntry(BeforeDoOperationEventArgs args) {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (null == org) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u53ef\u7814\u5ba1\u6838\u7ec4\u7ec7\u3002", (String)"MajorapprovalBillPlugin_9", (String)"pmgt-pmfs-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)"pmfs_newreportbill", (boolean)true, (int)3, (boolean)true);
        StyleCss css = new StyleCss();
        css.setHeight("60%");
        css.setWidth("50%");
        QFilter orgFilter = new QFilter("reportorg", "=", org.getPkValue());
        QFilter isNewFilter = new QFilter("isnew", "=", (Object)Boolean.TRUE).and("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
        ArrayList<Long> idList = new ArrayList<Long>();
        int rowCount = this.getModel().getEntryRowCount("listmodelentry");
        for (int i = 0; i < rowCount; ++i) {
            DynamicObject project = (DynamicObject)this.getModel().getValue("project", i);
            if (null == project) continue;
            idList.add(Long.parseLong(project.getPkValue().toString()));
        }
        QFilter idListFilter = new QFilter("project", "not in", idList);
        QFilter filter = idListFilter.and(orgFilter).and(isNewFilter);
        listShowParameter.getListFilterParameter().setFilter(filter);
        listShowParameter.getOpenStyle().setInlineStyleCss(css);
        listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ADDPRO));
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        if (StringUtils.equals((CharSequence)DELETEPRO, (CharSequence)event.getCallBackId()) && event.getResult().equals((Object)MessageBoxResult.Yes)) {
            CardEntry projectStage = (CardEntry)this.getControl("listmodelentry");
            int[] rows = projectStage.getSelectRows();
            ArrayList<DynamicObject> deleteReportList = new ArrayList<DynamicObject>();
            ArrayList<DynamicObject> reportbillList = new ArrayList<DynamicObject>();
            for (int row : rows) {
                DynamicObject reportbill;
                DynamicObject existReportbill;
                DynamicObject curreport = (DynamicObject)this.getModel().getValue("curreportbill", row);
                if (null != curreport) {
                    deleteReportList.add(curreport);
                }
                if ((existReportbill = BusinessDataServiceHelper.loadSingle((String)"pmfs_newreportbill", (String)"", (QFilter[])new QFilter[]{new QFilter("id", "=", (reportbill = (DynamicObject)this.getModel().getValue("reportbill", row)).getPkValue())})) == null || reportbill == null) continue;
                reportbill = BusinessDataServiceHelper.loadSingle((Object)reportbill.getPkValue(), (String)"pmfs_newreportbill", (String)"id, isnew");
                reportbill.set("isnew", (Object)Boolean.TRUE);
                reportbillList.add(reportbill);
            }
            this.getModel().deleteEntryRows("listmodelentry", rows);
            DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"pmfs_newreportbill"), (Object[])deleteReportList.toArray());
            SaveServiceHelper.save((DynamicObject[])reportbillList.toArray(new DynamicObject[reportbillList.size()]));
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if (ADDPRO.equalsIgnoreCase(actionId) && null != e.getReturnData()) {
            ListSelectedRowCollection listSelectedRows = (ListSelectedRowCollection)e.getReturnData();
            ArrayList<Object> ids = new ArrayList<Object>();
            for (ListSelectedRow row : listSelectedRows) {
                Object id = row.getPrimaryKeyValue();
                ids.add(id);
            }
            QFilter idFliter = new QFilter("id", "in", ids);
            QFilter[] filters = new QFilter[]{idFliter};
            String properties = "project, reportperson, reportdate, declareorg, isnew, source, parent, billstatus, billid, billno, reportorg, desc,tasknumbers,resultnumbers, outestimate, inestimate,tecdesc,marketdesc,financedesc,lawdesc";
            DynamicObject[] newReportBills = BusinessDataServiceHelper.load((String)"pmfs_newreportbill", (String)properties, (QFilter[])filters);
            DynamicObjectCollection proEntryCol = this.getModel().getEntryEntity("listmodelentry");
            for (DynamicObject newReportBill : newReportBills) {
                DynamicObject proEntry = new DynamicObject(proEntryCol.getDynamicObjectType());
                this.setProEntry(newReportBill, proEntry);
                proEntryCol.add((Object)proEntry);
            }
            this.getModel().updateEntryCache(proEntryCol);
            this.getView().updateView("listmodelentry");
            if (null != proEntryCol && !proEntryCol.isEmpty()) {
                CardEntry cardEntry = (CardEntry)this.getControl("listmodelentry");
                cardEntry.selectRows(proEntryCol.size() - 1, true);
            }
        }
    }

    private void setProEntry(DynamicObject newReportBill, DynamicObject proEntry) {
        DynamicObject project = newReportBill.getDynamicObject("project");
        if (null != project) {
            proEntry.set("project", (Object)project);
            proEntry.set("proname", (Object)project.getString("name"));
            proEntry.set("reportbill", (Object)newReportBill);
            proEntry.set("prolabel", (Object)ConclusionEnum.PASS_S.getValue());
            DynamicObjectCollection subEntryEntityCol = proEntry.getDynamicObjectCollection("subentryentity");
            DynamicObject subEntry = new DynamicObject(subEntryEntityCol.getDynamicObjectType());
            subEntry.set("seq", (Object)1);
            subEntry.set("proresult", (Object)ConclusionEnum.PASS_S.getValue());
            this.setProSubCardEntry(newReportBill, subEntry);
            subEntryEntityCol.add((Object)subEntry);
            DynamicObjectCollection subIndexEntryEntity = proEntry.getDynamicObjectCollection("subindexentry");
            this.setProSubIndexEntry(project, subIndexEntryEntity);
            this.getModel().updateEntryCache(subEntryEntityCol);
            this.getView().updateView("subentryentity");
        }
    }

    private void setProSubIndexEntry(DynamicObject project, DynamicObjectCollection subIndexEntryEntity) {
        QFilter proFilter = new QFilter("project", "=", project.getPkValue());
        QFilter statusFilter = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
        DynamicObject feasReport = BusinessDataServiceHelper.loadSingle((String)"pmfs_reportbill", (String)"indexentry,indexentry.indexname,indexentry.declarevalue,indexentry.indexwarnlight,indexentry.standardindex,indexentry.excellentindex", (QFilter[])new QFilter[]{proFilter, statusFilter});
        DynamicObjectCollection feasIndexEntries = feasReport.getDynamicObjectCollection("indexentry");
        for (DynamicObject feasIndex : feasIndexEntries) {
            DynamicObject subIndex = subIndexEntryEntity.addNew();
            subIndex.set("indexname", feasIndex.get("indexname"));
            subIndex.set("declarevalue", feasIndex.get("declarevalue"));
            subIndex.set("indexwarnlight", feasIndex.get("indexwarnlight"));
            subIndex.set("standardindex", feasIndex.get("standardindex"));
            subIndex.set("excellentindex", feasIndex.get("excellentindex"));
        }
        this.getView().updateView("subindexentry");
    }

    private void setProSubCardEntry(DynamicObject newReportBill, DynamicObject subEntry) {
        DynamicObject project = newReportBill.getDynamicObject("project");
        if (null != project) {
            BigDecimal outestimate = newReportBill.getBigDecimal("outestimate");
            BigDecimal inestimate = newReportBill.getBigDecimal("inestimate");
            BigDecimal profitestimate = inestimate.subtract(outestimate);
            subEntry.set("projectname", (Object)project);
            subEntry.set("outestimate", (Object)outestimate);
            subEntry.set("inestimate", (Object)inestimate);
            subEntry.set("profitestimate", (Object)profitestimate);
            subEntry.set("tasknumbers", newReportBill.get("tasknumbers"));
            subEntry.set("resultnumbers", newReportBill.get("resultnumbers"));
            this.setFeasibleDeclareInfo(newReportBill, subEntry);
            this.setFeasibleAttchMent(newReportBill, subEntry);
            this.setFeasibleResultPanel(subEntry);
        }
    }

    private DynamicObject getBudget(String inOrOut, DynamicObject project) {
        QFilter[] numberFilter = new QFilter[]{new QFilter("number", "=", (Object)BudgetStageEnum.PREINSTALL_2.getValue())};
        DynamicObject[] budgetstages = BusinessDataServiceHelper.load((String)"pmbs_budgetstage", (String)"id", (QFilter[])numberFilter);
        if (null != budgetstages && budgetstages.length > 0 && null != project) {
            QFilter out;
            QFilter budget;
            QFilter isvalid;
            DynamicObject budgetstage = budgetstages[0];
            QFilter proFilter = new QFilter("project", "=", project.getPkValue());
            QFilter[] filters = new QFilter[]{proFilter, isvalid = new QFilter("isvalid", "=", (Object)Boolean.TRUE), budget = new QFilter("budgetstage", "=", budgetstage.getPkValue()), out = new QFilter("sourcetype", "=", (Object)inOrOut)};
            DynamicObject[] outbudgets = BusinessDataServiceHelper.load((String)"pmas_budget", (String)"totalamount", (QFilter[])filters);
            if (null != outbudgets && outbudgets.length > 0) {
                return outbudgets[0];
            }
        }
        return null;
    }

    private void setFeasibleDeclareInfo(DynamicObject newReportBill, DynamicObject subEntry) {
        if (null != newReportBill) {
            subEntry.set("proreportorg", newReportBill.get("declareorg"));
            subEntry.set("proreportpson", newReportBill.get("reportperson"));
            subEntry.set("proreportdate", newReportBill.get("reportdate"));
            subEntry.set("desc", newReportBill.get("desc"));
            subEntry.set("tecdesc", newReportBill.get("tecdesc"));
            subEntry.set("marketdesc", newReportBill.get("marketdesc"));
            subEntry.set("financedesc", newReportBill.get("financedesc"));
            subEntry.set("lawdesc", newReportBill.get("lawdesc"));
        }
    }

    private void setFeasibleAttchMent(DynamicObject newReportBill, DynamicObject subEntry) {
        block5: {
            DynamicObject project = newReportBill.getDynamicObject("project");
            if (null == project) break block5;
            DynamicObjectCollection newAttchment = subEntry.getDynamicObjectCollection("attachmentfield");
            if (null == newReportBill.getDynamicObject("parent")) {
                DynamicObject kybill = BusinessDataServiceHelper.loadSingle((Object)newReportBill.getLong("billid"), (String)"pmfs_reportbill", (String)"billno, billstatus, creator, auditor, org, auditdate, createtime, modifytime, modifier, reportdate, reportperson, project, desc, outestimate, inestimate, profitestimate, tasknumbers, resultnumbers, fsresult, reportorg, approvalresult, approvaldesc,attachmentfield, currency");
                DynamicObjectCollection attCol = kybill.getDynamicObjectCollection("attachmentfield");
                long[] attchmentIds = DB.genLongIds((String)"t_pmfs_proannexentry", (int)attCol.size());
                int i = 0;
                for (DynamicObject att : attCol) {
                    DynamicObject attchmentEntry = new DynamicObject(newAttchment.getDynamicObjectType());
                    subEntry.getDataEntityType().getPrimaryKey().setValueFast((Object)attchmentEntry, (Object)attchmentIds[i]);
                    ++i;
                    attchmentEntry.set("fbasedataid", (Object)att.getDynamicObject("fbasedataid"));
                    newAttchment.add((Object)attchmentEntry);
                }
            } else {
                DynamicObject kyzxbill = BusinessDataServiceHelper.loadSingle((Object)newReportBill.getLong("billid"), (String)"pmfs_majorapproval", (String)"billno, billstatus, creator, auditor, org, auditdate, createtime, modifytime, modifier, pecialapprtype, approvalperson, approvaldate,listmodelentry.id, listmodelentry.project, subentryentity.id, subentryentity.projectname, subentryentity.outestimate,subentryentity.proreportorg, subentryentity.proreportpson, subentryentity.proreportdate, subentryentity.desc,subentryentity.attachmentfield, subentryentity.proresult, subentryentity.reportorg, subentryentity.approvalresult");
                DynamicObjectCollection proEntryCollection = kyzxbill.getDynamicObjectCollection("listmodelentry");
                for (DynamicObject proEntry : proEntryCollection) {
                    DynamicObjectCollection subCol;
                    DynamicObject entryproject = proEntry.getDynamicObject("project");
                    if (null == entryproject || !StringUtils.equalsIgnoreCase((CharSequence)entryproject.getPkValue().toString(), (CharSequence)project.getPkValue().toString()) || null == (subCol = proEntry.getDynamicObjectCollection("subentryentity")) || subCol.isEmpty()) continue;
                    DynamicObjectCollection oldAttchment = ((DynamicObject)subCol.get(0)).getDynamicObjectCollection("attachmentfield");
                    long[] attchmentIds = DB.genLongIds((String)"t_pmfs_proannexentry", (int)oldAttchment.size());
                    int idIndex = 0;
                    DynamicObject attchmentEntry = null;
                    for (DynamicObject att : oldAttchment) {
                        attchmentEntry = new DynamicObject(newAttchment.getDynamicObjectType());
                        subEntry.getDataEntityType().getPrimaryKey().setValueFast((Object)attchmentEntry, (Object)attchmentIds[idIndex++]);
                        attchmentEntry.set("fbasedataid", (Object)att.getDynamicObject("fbasedataid"));
                        newAttchment.add((Object)attchmentEntry);
                    }
                }
            }
        }
    }

    private void setFeasibleResultPanel(DynamicObject subEntry) {
        int curSubCardIndex = 0;
        String proResult = subEntry.getString("proresult");
        CardEntry subCard = (CardEntry)this.getControl("subentryentity");
        String billStatus = (String)this.getModel().getValue("billstatus");
        HashMap<String, Boolean> propMap = new HashMap<String, Boolean>();
        if (StringUtils.equals((CharSequence)proResult, (CharSequence)ConclusionEnum.REPORT_S.getValue())) {
            subCard.setChildVisible(true, curSubCardIndex, new String[]{"reportorg"});
            propMap.put("mi", Boolean.TRUE);
            if (StringUtils.equals((CharSequence)billStatus, (CharSequence)StatusEnum.CHECKED.getValue())) {
                subCard.setChildVisible(true, curSubCardIndex, new String[]{"approvalresult"});
            } else {
                subCard.setChildVisible(false, curSubCardIndex, new String[]{"approvalresult"});
            }
        } else {
            subCard.setChildVisible(false, curSubCardIndex, new String[]{"reportorg"});
            subCard.setChildVisible(false, curSubCardIndex, new String[]{"approvalresult"});
            propMap.put("mi", Boolean.FALSE);
        }
        this.getView().updateControlMetadata("reportorg", propMap);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        String key = c.getKey();
        HashMap<String, Object> map = new HashMap<String, Object>();
        int curIndex = this.getModel().getEntryCurrentRowIndex("listmodelentry");
        DynamicObject proEntry = this.getModel().getEntryRowEntity("listmodelentry", curIndex);
        DynamicObject project = proEntry.getDynamicObject("project");
        if (null != project) {
            DynamicObject inbudget;
            if (StringUtils.equals((CharSequence)key, (CharSequence)"projectnamepanela")) {
                QFilter proFilter = new QFilter("pro", "=", project.getPkValue());
                String properties = String.join((CharSequence)",", "id", "prostatus", "needapproval", "approvalstatus", "isreport", "repaudstatus", "prostatus");
                DynamicObject[] proApps = BusinessDataServiceHelper.load((String)"pmas_pro_approval", (String)properties, (QFilter[])new QFilter[]{proFilter});
                if (null != proApps && proApps.length > 0) {
                    DynamicObject proApp = proApps[0];
                    boolean needApproval = proApp.getBoolean("needapproval");
                    String approvalStatus = proApp.getString("approvalstatus");
                    if (needApproval && !StringUtils.equals((CharSequence)approvalStatus, (CharSequence)ApprovalStatusEnum.PASS.getValue())) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6838\u51c6\u901a\u8fc7\u540e\uff0c\u624d\u80fd\u67e5\u770b\u9879\u76ee\u770b\u677f\u3002", (String)"MajorapprovalBillPlugin_10", (String)"pmgt-pmfs-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    DynamicObject proStatus = proApp.getDynamicObject("prostatus");
                    if (proStatus == null) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u9879\u76ee\u7acb\u9879\u5ba1\u6838\u672a\u901a\u8fc7\uff0c\u65e0\u9879\u76ee\u770b\u677f\u3002", (String)"MajorapprovalBillPlugin_11", (String)"pmgt-pmfs-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    if (ProjectStatusEnum.APPROVAL_FAIL.getValue().equals(proStatus.getString("number"))) {
                        this.getView().showMessage(ResManager.loadKDStringExt((String)"\u9879\u76ee\u7acb\u9879\u5ba1\u6838\u672a\u901a\u8fc7\uff0c\u65e0\u9879\u76ee\u770b\u677f\u3002", (String)"MajorapprovalBillPlugin_11", (String)"pmgt-pmfs-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    HashMap<String, Object> custormMap = new HashMap<String, Object>(16);
                    custormMap.put("proAppId", proApps[0].getPkValue());
                    map.put("formId", "pmba_projectkanban");
                    map.put("customParams", custormMap);
                    FormShowParameter parameter = FormShowParameter.createFormShowParameter(map);
                    parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                    this.getView().showForm(parameter);
                }
            } else if (StringUtils.equals((CharSequence)key, (CharSequence)"taskpanela")) {
                DynamicObject projectKind = project.getDynamicObject("group");
                DynamicObject org = (DynamicObject)this.getModel().getValue("org");
                if (projectKind != null && org != null) {
                    map.put("orgId", org.getPkValue().toString());
                    map.put("proId", project.getPkValue().toString());
                    map.put("majortypefilter", "true");
                    ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)"pmpt_proplanmonitor", (boolean)false, (int)2, (boolean)false);
                    listShowParameter.setBillFormId("pmpt_proplanmonitor");
                    listShowParameter.setFormId("pmpt_proplanmonitortpl");
                    listShowParameter.setCustomParams(map);
                    listShowParameter.setStatus(OperationStatus.VIEW);
                    listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                    this.getView().showForm((FormShowParameter)listShowParameter);
                }
            } else if (StringUtils.equals((CharSequence)key, (CharSequence)"resultnumbepanela")) {
                DynamicObject projectKind = project.getDynamicObject("group");
                DynamicObject org = (DynamicObject)this.getModel().getValue("org");
                if (projectKind != null && org != null) {
                    map.put("orgId", org.getPkValue().toString());
                    map.put("proId", project.getPkValue().toString());
                    map.put("formId", "pmpt_proresulttrack");
                    FormShowParameter showParameter = FormShowParameter.createFormShowParameter(map);
                    showParameter.setStatus(OperationStatus.EDIT);
                    showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                    showParameter.setCustomParams(map);
                    this.getView().showForm(showParameter);
                }
            } else if (StringUtils.equals((CharSequence)key, (CharSequence)"outestimatepanela")) {
                DynamicObject outbudget = this.getBudget(BudgetSourceTypeEnum.OUT.getValue(), project);
                if (null != outbudget) {
                    map.put("formId", "pmas_outbudget");
                    map.put("pkId", outbudget.getPkValue().toString());
                    FormShowParameter showParameter = FormShowParameter.createFormShowParameter(map);
                    showParameter.setStatus(OperationStatus.VIEW);
                    showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                    this.getView().showForm(showParameter);
                }
            } else if (StringUtils.equals((CharSequence)key, (CharSequence)"inestimatepanela") && null != (inbudget = this.getBudget(BudgetSourceTypeEnum.IN.getValue(), project))) {
                map.put("formId", "pmas_inbudget");
                map.put("pkId", inbudget.getPkValue().toString());
                FormShowParameter showParameter = FormShowParameter.createFormShowParameter(map);
                showParameter.setStatus(OperationStatus.VIEW);
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm(showParameter);
            }
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        DynamicObject proEntry = this.getModel().getEntryRowEntity("listmodelentry", hyperLinkClickEvent.getRowIndex());
        DynamicObject project = proEntry.getDynamicObject("project");
        if (null != project) {
            QFilter proFilter = new QFilter("pro", "=", project.getPkValue());
            String properties = String.join((CharSequence)",", "id", "prostatus", "needapproval", "approvalstatus", "isreport", "repaudstatus", "prostatus");
            DynamicObject[] proApps = BusinessDataServiceHelper.load((String)"pmas_pro_approval", (String)properties, (QFilter[])new QFilter[]{proFilter});
            if (null != proApps && proApps.length > 0) {
                DynamicObject proApp = proApps[0];
                boolean needApproval = proApp.getBoolean("needapproval");
                String approvalStatus = proApp.getString("approvalstatus");
                if (needApproval && !StringUtils.equals((CharSequence)approvalStatus, (CharSequence)ApprovalStatusEnum.PASS.getValue())) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6838\u51c6\u901a\u8fc7\u540e\uff0c\u624d\u80fd\u67e5\u770b\u9879\u76ee\u770b\u677f\u3002", (String)"MajorapprovalBillPlugin_10", (String)"pmgt-pmfs-formplugin", (Object[])new Object[0]));
                    return;
                }
                DynamicObject proStatus = proApp.getDynamicObject("prostatus");
                if (proStatus == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u9879\u76ee\u7acb\u9879\u5ba1\u6838\u672a\u901a\u8fc7\uff0c\u65e0\u9879\u76ee\u770b\u677f\u3002", (String)"MajorapprovalBillPlugin_11", (String)"pmgt-pmfs-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (ProjectStatusEnum.APPROVAL_FAIL.getValue().equals(proStatus.getString("number"))) {
                    this.getView().showMessage(ResManager.loadKDStringExt((String)"\u9879\u76ee\u7acb\u9879\u5ba1\u6838\u672a\u901a\u8fc7\uff0c\u65e0\u9879\u76ee\u770b\u677f\u3002", (String)"MajorapprovalBillPlugin_11", (String)"pmgt-pmfs-formplugin", (Object[])new Object[0]));
                    return;
                }
                HashMap<String, Object> custormMap = new HashMap<String, Object>(16);
                custormMap.put("proAppId", proApps[0].getPkValue());
                map.put("formId", "pmba_projectkanban");
                map.put("customParams", custormMap);
                FormShowParameter parameter = FormShowParameter.createFormShowParameter(map);
                parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm(parameter);
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent arg) {
        super.beforeF7Select(arg);
        ListShowParameter param = (ListShowParameter)arg.getFormShowParameter();
        String propName = arg.getProperty().getName();
        long userId = RequestContext.get().getCurrUserId();
        List userOrgRanges = UserOrgRangeHelper.getUserOrgRanges((Long)userId);
        List qFilters = param.getListFilterParameter().getQFilters();
        if (StringUtils.equals((CharSequence)propName, (CharSequence)"reportorg")) {
            String pattern = ProjectPermissionHelper.getPatternIdByParam((Long)RequestContext.get().getOrgId(), (String)"orgseparate");
            List allSubOrgUnits = ProjectPermissionHelper.getAllSubOrgUnitsByPattern((String)pattern, (List)userOrgRanges, (String)"15");
            if (allSubOrgUnits.size() > 0) {
                List parentByOrgIds = OrgTreeUtils.getParentByOrgIds((List)allSubOrgUnits, (String)"15");
                qFilters.add(new QFilter("id", "in", (Object)parentByOrgIds));
            }
        } else if (StringUtils.equals((CharSequence)propName, (CharSequence)"approvalperson") && userOrgRanges.size() > 0) {
            param.setF7Style(3);
            qFilters.add(new QFilter("entryentity.dpt.id", "in", (Object)userOrgRanges));
        }
    }
}

