/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmfs.formplugin;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pmgt.pmbs.business.helper.UserOrgRangeHelper;
import kd.pmgt.pmbs.common.utils.NumberHelper;
import kd.pmgt.pmfs.formplugin.base.AbstractPmfsBillPlugin;

public class ProjectAcceptBillPlugin
extends AbstractPmfsBillPlugin
implements ClickListener,
RowClickEventListener,
HyperLinkClickListener,
BeforeF7SelectListener {
    protected static final String CALLBACK_PROJECT = "projectCallBack";
    protected static final String CALLBACK_WBS = "WBSCallBack";
    protected static final String CALLBACK_YES = "YESCallBack";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit projectEdit = (BasedataEdit)this.getView().getControl("project");
        projectEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit fieldEdit = (BasedataEdit)this.getView().getControl("contractno");
        fieldEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit wbsEdit = (BasedataEdit)this.getView().getControl("wbsname");
        wbsEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        EntryGrid entryEntity = (EntryGrid)this.getControl("entryentity");
        entryEntity.addHyperClickListener((HyperLinkClickListener)this);
        BasedataEdit manager = (BasedataEdit)this.getControl("acceptorgperson");
        manager.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit participants = (BasedataEdit)this.getControl("acceptparticipant");
        participants.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        HashMap<String, Serializable> prop = new HashMap<String, Serializable>(16);
        prop.put("qan", Boolean.valueOf(false));
        HashMap<String, Boolean> editor = new HashMap<String, Boolean>(16);
        editor.put("qan", false);
        prop.put("item", editor);
        this.getView().updateControlMetadata("suppliername", prop);
    }

    public void hyperLinkClick(HyperLinkClickEvent event) {
        DynamicObject model = this.getModel().getDataEntity(true);
        DynamicObjectCollection rows = model.getDynamicObjectCollection("entryentity");
        DynamicObject curRow = (DynamicObject)rows.get(event.getRowIndex());
        DynamicObject outContractF7 = curRow.getDynamicObject("contractno");
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId("pmct_outcontract");
        showParameter.setBillStatusValue(Integer.valueOf(OperationStatus.VIEW.getValue()));
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setPkId(outContractF7.getPkValue());
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        super.beforeF7Select(e);
        String key = e.getProperty().getName();
        DynamicObject dynamicObject = this.getModel().getDataEntity(true);
        switch (key) {
            case "acceptorgperson": 
            case "acceptparticipant": {
                QFilter qFilter;
                ListShowParameter param = (ListShowParameter)e.getFormShowParameter();
                param.setF7Style(3);
                List qFilterList = param.getListFilterParameter().getQFilters();
                long currUserId = RequestContext.get().getCurrUserId();
                long projectId = 0L;
                Object projectObj = this.getModel().getValue("project");
                if (projectObj != null) {
                    DynamicObject project = (DynamicObject)projectObj;
                    projectId = Long.parseLong(project.getPkValue().toString());
                }
                if ((qFilter = UserOrgRangeHelper.loadUserOrgRanges((Long)currUserId, (Long)projectId)) == null) break;
                qFilterList.add(qFilter);
                break;
            }
            case "project": {
                ListShowParameter projectParam = (ListShowParameter)e.getFormShowParameter();
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, CALLBACK_PROJECT);
                projectParam.setCloseCallBack(closeCallBack);
                break;
            }
            case "wbsname": {
                DynamicObject wbsObject = dynamicObject.getDynamicObject("project");
                if (wbsObject != null) {
                    QFilter projectFilter = new QFilter("project", "=", wbsObject.getPkValue());
                    DynamicObject[] wbsS = BusinessDataServiceHelper.load((String)"pmbs_wbs", (String)String.join((CharSequence)",", "number", "longnumber"), (QFilter[])new QFilter[]{projectFilter});
                    HashSet<Object> wbsIdSet = new HashSet<Object>(10);
                    for (DynamicObject dy : wbsS) {
                        wbsIdSet.add(dy.getPkValue());
                    }
                    QFilter wbsFilter = new QFilter("id", "in", (Object)wbsIdSet.toArray());
                    e.addCustomQFilter(wbsFilter);
                    ListShowParameter wbsParam = (ListShowParameter)e.getFormShowParameter();
                    CloseCallBack WBSCallBack = new CloseCallBack((IFormPlugin)this, CALLBACK_WBS);
                    wbsParam.setCloseCallBack(WBSCallBack);
                    break;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9879\u76ee\u3002", (String)"ProjectAcceptBillPlugin_0", (String)"pmgt-pmfs-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                break;
            }
            case "contractno": {
                DynamicObject projectObject = dynamicObject.getDynamicObject("project");
                if (projectObject != null) {
                    QFilter projectFilter = new QFilter("project", "=", projectObject.getPkValue());
                    DynamicObject[] outcontractS = BusinessDataServiceHelper.load((String)"pmct_outcontract", (String)String.join((CharSequence)",", "billno", "billname", "originaloftaxamount"), (QFilter[])new QFilter[]{projectFilter});
                    HashSet<Object> outcontractIdSet = new HashSet<Object>(10);
                    for (DynamicObject billObject : outcontractS) {
                        outcontractIdSet.add(billObject.getPkValue());
                    }
                    DynamicObjectCollection entrys = dynamicObject.getDynamicObjectCollection("entryentity");
                    for (DynamicObject entry : entrys) {
                        DynamicObject contract = entry.getDynamicObject("contractno");
                        if (null == contract) continue;
                        outcontractIdSet.remove(contract.getPkValue());
                    }
                    QFilter outContractFilter = new QFilter("id", "in", (Object)outcontractIdSet.toArray());
                    e.addCustomQFilter(outContractFilter);
                    break;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9879\u76ee\u3002", (String)"ProjectAcceptBillPlugin_0", (String)"pmgt-pmfs-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        IDataModel model = this.getModel();
        String actionId = e.getActionId();
        ListSelectedRowCollection listSelectedRowCollection = (ListSelectedRowCollection)e.getReturnData();
        switch (actionId) {
            case "projectCallBack": {
                if (listSelectedRowCollection == null) break;
                ListSelectedRow listSelectedRow = listSelectedRowCollection.get(0);
                Object pKValue = listSelectedRow.getPrimaryKeyValue();
                model.setValue("wbsname", null);
                model.setValue("project", pKValue);
                DynamicObject prody = model.getDataEntity(true);
                DynamicObjectCollection entryCol = prody.getDynamicObjectCollection("entryentity");
                entryCol.clear();
                this.getView().updateView("entryentity");
                break;
            }
            case "WBSCallBack": {
                DynamicObject[] wbsDynamicObject;
                if (listSelectedRowCollection == null) break;
                ListSelectedRow listSelectedRow = listSelectedRowCollection.get(0);
                Object pKValue = listSelectedRow.getPrimaryKeyValue();
                DynamicObject acceptObject = model.getDataEntity(true);
                DynamicObject project = acceptObject.getDynamicObject("project");
                QFilter projectQFilter = new QFilter("project", "=", project.getPkValue());
                for (DynamicObject accept : wbsDynamicObject = BusinessDataServiceHelper.load((String)"pmfs_projectaccept", (String)String.join((CharSequence)",", "wbsname"), (QFilter[])new QFilter[]{projectQFilter})) {
                    DynamicObject wbs = accept.getDynamicObject("wbsname");
                    if (wbs == null || !pKValue.equals(wbs.getPkValue())) continue;
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u672c\u9879WBS\u5df2\u5b8c\u6210\u4ea4\u5de5\u9a8c\u6536\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u91cd\u590d\u9a8c\u6536\u3002", (String)"ProjectAcceptBillPlugin_2", (String)"pmgt-pmfs-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CALLBACK_YES));
                    break;
                }
                model.setValue("wbsname", pKValue);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String fieldKey = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        if (StringUtils.equals((CharSequence)"wbsname", (CharSequence)fieldKey)) {
            DynamicObject acceptObject = this.getModel().getDataEntity(true);
            DynamicObject projectObject = acceptObject.getDynamicObject("project");
            if (projectObject != null) {
                DynamicObjectCollection entryCol = acceptObject.getDynamicObjectCollection("entryentity");
                entryCol.clear();
                this.getView().updateView("entryentity");
                DynamicObject wbsObject = acceptObject.getDynamicObject("wbsname");
                if (wbsObject != null) {
                    DynamicObject wbs = BusinessDataServiceHelper.loadSingle((Object)wbsObject.getPkValue(), (String)"pmbs_wbs", (String)String.join((CharSequence)",", "number", "longnumber"));
                    QFilter qFilter = new QFilter("longnumber", "like", (Object)(wbs.getString("longnumber") + "%"));
                    QFilter projectFilter = new QFilter("project", "=", projectObject.getPkValue());
                    DynamicObject[] wbsS = BusinessDataServiceHelper.load((String)"pmbs_wbs", (String)String.join((CharSequence)",", "number"), (QFilter[])new QFilter[]{qFilter, projectFilter});
                    HashSet<Object> wbsIdSet = new HashSet<Object>(10);
                    for (DynamicObject dy : wbsS) {
                        wbsIdSet.add(dy.getPkValue());
                    }
                    QFilter outContractFilter = new QFilter("wbsname", "in", (Object)wbsIdSet.toArray());
                    QFilter projectFiltera = new QFilter("project", "=", projectObject.getPkValue());
                    DynamicObject[] contarctS = BusinessDataServiceHelper.load((String)"pmct_outcontract", (String)"billno, billstatus, creator, auditor, modifier, auditdate, createtime, modifytime, contracttype, org, fiaccountorg, bizaccountorg, ismulticontract, otherpart, ismulticurrency, stdcurrency, currency, exratetable, exchangedate, exchangerate, signamount, stdtaxamount, stdoriginalamount, ismultirate, originaloftaxamount, taxrate, avgtaxrate, taxamount, originalamount, signdate, project, isonlist, contstatus, versionnumber, lastversionnumber, hasconttext, billname, description, totalsettleamount, totalsettleoftaxamount, totalapplyamount, totalapplyoftaxamount, totalrevisionamount, totalrevisionoftaxamount, totalclaimamount, totalclaimoftaxamount, totalamount, totalinvoiceamount, totalinvoiceoftaxamount, totalrealamount, totalrealoftaxamount, performtaxamount, appamount, apptaxamount, totaloftaxamount, totalcalofamt, totalcaloftaxamt, totalnotcalofamt, totalnotcaloftaxamt, paydirection, imageno, refcontract, contractstatus, signaddressdetail, signaddress, auditassign, partaperson, partaphone, partbperson, partbphone, partotherperson, partotherphone, electronicsign, signtype, usersign, customersign, thirdpartysign, totaladditionamount, totaladditionoftaxamt, budgetitem, isincost, parta, partb, payrate, initimport, openedcontract, strategicagreement, wbsname, bidresult", (QFilter[])new QFilter[]{outContractFilter, projectFiltera});
                    if (contarctS.length > 0) {
                        for (DynamicObject dynamicObject : contarctS) {
                            int row = this.getModel().createNewEntryRow("entryentity");
                            this.getModel().setValue("contractno", (Object)dynamicObject, row);
                            this.getModel().setValue("contarctlatestamt", (Object)dynamicObject.getBigDecimal("originaloftaxamount"), row);
                            this.getModel().setValue("currency", (Object)dynamicObject.getDynamicObject("currency"), row);
                        }
                    }
                }
            }
        } else if (StringUtils.equals((CharSequence)"contractno", (CharSequence)fieldKey)) {
            int currentRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
            if (newValue != null) {
                DynamicObject currency = ((DynamicObject)newValue).getDynamicObject("currency");
                this.getModel().setValue("currency", (Object)currency, rowIndex);
                DynamicObject contract = (DynamicObject)newValue;
                BigDecimal appTaxAmount = contract.getBigDecimal("apptaxamount");
                BigDecimal totalOfTaxAmount = contract.getBigDecimal("totaloftaxamount");
                if (NumberHelper.isNullZero((BigDecimal)appTaxAmount)) {
                    this.getModel().setValue("contarctlatestamt", (Object)totalOfTaxAmount, rowIndex);
                } else {
                    this.getModel().setValue("contarctlatestamt", (Object)appTaxAmount, rowIndex);
                }
            } else {
                this.getModel().setValue("currency", null, rowIndex);
                this.getModel().setValue("contarctlatestamt", null, rowIndex);
            }
        }
    }
}

