/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmfs.formplugin;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.pmgt.pmbs.common.enums.EnableEnum;
import kd.pmgt.pmbs.common.enums.IndexWarnLightEnum;
import kd.pmgt.pmbs.common.enums.ProjectStatusEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmfs.formplugin.base.AbstractPmfsFormPlugin;

public class ProjectReportEditPlugin
extends AbstractPmfsFormPlugin
implements BeforeF7SelectListener {
    private static final String PROJECT_APPROVAL = "pmas_proappf7";
    private static final String APPROVAl_APPLY = "pmas_approval_apply_f7";
    private static final String OPERATE_VIEWLATESTINCICATOR = "viewlatestincicator";
    private static final String OLD_PROJECT_VALUE_CACHE = "oldProjectValue";
    private static final String OLD_SELF_RESEARCH_CACHE = "oldSelfResearch";
    private static final String IS_SELF_RESEARCH_CACHE = "isSelfResearch";
    private static final String SELF_RESEARCH_CALLBACK = "selfResearchCallBack";
    private static final String PROJECT_CALLBACK = "projectCallBack";

    public void afterCreateNewData(EventObject e) {
        long orgId = RequestContext.get().getOrgId();
        Map mapOrg = OrgUnitServiceHelper.getCompanyByOrg((Long)orgId, (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE);
        if (mapOrg.size() > 0) {
            orgId = (Long)mapOrg.get("id");
        }
        this.getModel().setValue("org", (Object)orgId);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit selfResearch = (BasedataEdit)this.getControl("selfreserch");
        selfResearch.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit project = (BasedataEdit)this.getControl("project");
        project.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        project.addBeforeF7ViewDetailListener(beforeF7ViewDetailEvent -> {
            beforeF7ViewDetailEvent.setCancel(true);
            this.getView().showForm(this.buildShowProject(beforeF7ViewDetailEvent.getPkId()));
        });
        selfResearch.addBeforeF7ViewDetailListener(beforeF7ViewDetailEvent -> {
            beforeF7ViewDetailEvent.setCancel(true);
            this.getView().showForm(this.buildShowSelf(beforeF7ViewDetailEvent.getPkId()));
        });
    }

    private FormShowParameter buildShowProject(Object pkId) {
        boolean existApply = QueryServiceHelper.exists((String)"pmas_approval_apply", (Object)pkId);
        boolean existApproval = QueryServiceHelper.exists((String)"pmas_pro_approval", (Object)pkId);
        BillShowParameter showParameter = new BillShowParameter();
        if (existApply) {
            showParameter.setPkId(pkId);
            showParameter.setFormId("pmas_approval_apply");
        } else if (existApproval) {
            showParameter.setPkId(pkId);
            showParameter.setFormId("pmas_pro_approval");
        }
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setStatus(OperationStatus.VIEW);
        return showParameter;
    }

    private FormShowParameter buildShowSelf(Object pkId) {
        boolean existSelf = QueryServiceHelper.exists((String)"pmfs_selfresearch", (Object)pkId);
        BillShowParameter showParameter = new BillShowParameter();
        if (existSelf) {
            showParameter.setPkId(pkId);
            showParameter.setFormId("pmfs_selfresearch");
        }
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setStatus(OperationStatus.VIEW);
        return showParameter;
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        super.beforeF7Select(event);
        String propertyName = event.getProperty().getName();
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        ListShowParameter param = (ListShowParameter)event.getFormShowParameter();
        List qFilters = param.getListFilterParameter().getQFilters();
        switch (propertyName) {
            case "project": {
                String projectSource = (String)this.getModel().getValue("projectsource");
                if (org == null) break;
                if (StringUtils.equals((CharSequence)PROJECT_APPROVAL, (CharSequence)projectSource)) {
                    qFilters.add(new QFilter("org", "=", org.getPkValue()));
                    qFilters.add(new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue()));
                    ArrayList<String> excludeStatusIds = new ArrayList<String>();
                    excludeStatusIds.add(ProjectStatusEnum.BUSSINESS_CLOSE.getId());
                    excludeStatusIds.add(ProjectStatusEnum.FINANCIAL_CLOSE.getId());
                    excludeStatusIds.add(ProjectStatusEnum.SUSPEND.getId());
                    excludeStatusIds.add(ProjectStatusEnum.QUIT.getId());
                    qFilters.add(new QFilter("prostatus", "not in", (Object)ProjectReportEditPlugin.stringArrToLongArr(excludeStatusIds.toArray(new String[excludeStatusIds.size()]))));
                    qFilters.add(new QFilter("prostatus", "!=", (Object)0));
                    break;
                }
                if (!StringUtils.equals((CharSequence)APPROVAl_APPLY, (CharSequence)projectSource)) break;
                qFilters.add(new QFilter("company", "=", org.getPkValue()));
                qFilters.add(new QFilter("status", "=", (Object)StatusEnum.CHECKED.getValue()));
                qFilters.add(new QFilter("iscopypro", "=", (Object)Boolean.FALSE));
                break;
            }
            case "selfreserch": {
                if (org == null) break;
                qFilters.add(new QFilter("org", "=", org.getPkValue()));
                qFilters.add(new QFilter("isreport", "=", (Object)Boolean.FALSE));
                break;
            }
        }
    }

    public static Long[] stringArrToLongArr(String[] stringArr) {
        if (stringArr != null && stringArr.length >= 1) {
            Long[] longArray = new Long[stringArr.length];
            for (int i = 0; i < longArray.length; ++i) {
                try {
                    longArray[i] = Long.valueOf(stringArr[i]);
                    continue;
                }
                catch (NumberFormatException var4) {
                    longArray[i] = null;
                }
            }
            return longArray;
        }
        return null;
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        if (StringUtils.equals((CharSequence)PROJECT_CALLBACK, (CharSequence)callBackId)) {
            if (MessageBoxResult.Yes.equals((Object)result)) {
                DynamicObject newValue = (DynamicObject)this.getModel().getValue("project");
                String projectSource = (String)this.getModel().getValue("projectsource");
                this.updateProjectData(projectSource, newValue);
            } else {
                long oldProjectId = Long.parseLong(this.getView().getPageCache().get(OLD_PROJECT_VALUE_CACHE));
                this.getModel().beginInit();
                this.getModel().setValue("project", (Object)oldProjectId);
                this.getModel().endInit();
                this.getView().updateView("project");
            }
        } else if (StringUtils.equals((CharSequence)SELF_RESEARCH_CALLBACK, (CharSequence)callBackId)) {
            if (MessageBoxResult.Yes.equals((Object)result)) {
                DynamicObject newValue = (DynamicObject)this.getModel().getValue("selfreserch");
                if (newValue != null) {
                    DynamicObject selfResearch = BusinessDataServiceHelper.loadSingle((Object)newValue.getPkValue(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmfs_selfresearch"));
                    this.getModel().setValue("projectsource", (Object)selfResearch.getString("projectsource"));
                    this.getModel().setValue("project", (Object)selfResearch.getDynamicObject("project"));
                } else {
                    this.getModel().setValue("projectsource", null);
                }
                this.getPageCache().put(IS_SELF_RESEARCH_CACHE, "true");
            } else {
                Long oldProjectId = Long.parseLong(this.getView().getPageCache().get(OLD_SELF_RESEARCH_CACHE));
                this.getModel().beginInit();
                this.getModel().setValue("selfreserch", (Object)oldProjectId);
                this.getModel().endInit();
                this.getModel().setValue("isself", (Object)true);
                this.getView().updateView("selfreserch");
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        ChangeData changeData = e.getChangeSet()[0];
        switch (name = e.getProperty().getName()) {
            case "project": {
                String projectSource = (String)this.getModel().getValue("projectsource");
                DynamicObject newValue = (DynamicObject)changeData.getNewValue();
                DynamicObject oldValue = (DynamicObject)changeData.getOldValue();
                String isSelfResearch = this.getPageCache().get(IS_SELF_RESEARCH_CACHE);
                this.getPageCache().remove(IS_SELF_RESEARCH_CACHE);
                if (oldValue == null || isSelfResearch != null) {
                    this.updateProjectData(projectSource, newValue);
                    break;
                }
                this.getView().getPageCache().put(OLD_PROJECT_VALUE_CACHE, oldValue.getPkValue().toString());
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u9879\u76ee\u5c06\u6e05\u9664\u6240\u6709\u4fe1\u606f\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\uff1f", (String)"ProjectReportEditPlugin_10", (String)"pmgt-pmfs-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(PROJECT_CALLBACK));
                break;
            }
            case "projectsource": {
                this.deleteProjectData();
                break;
            }
            case "selfreserch": {
                DynamicObject newValue = (DynamicObject)changeData.getNewValue();
                DynamicObject oldValue = (DynamicObject)changeData.getOldValue();
                if (oldValue == null) {
                    if (newValue != null) {
                        DynamicObject selfResearch = BusinessDataServiceHelper.loadSingle((Object)newValue.getPkValue(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmfs_selfresearch"));
                        this.getModel().setValue("projectsource", (Object)selfResearch.getString("projectsource"));
                        this.getModel().setValue("project", (Object)selfResearch.getDynamicObject("project"));
                        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
                        QFilter qFilter = new QFilter("internal_company", "=", org.getPkValue());
                        qFilter.and("status", "=", (Object)StatusEnum.CHECKED.getValue());
                        qFilter.and("enable", "=", (Object)EnableEnum.ENABLE.getValue());
                        DynamicObject supplier = QueryServiceHelper.queryOne((String)"bd_supplier", (String)"id", (QFilter[])new QFilter[]{qFilter});
                        if (supplier == null) break;
                        long supplierId = supplier.getLong("id");
                        this.getModel().setValue("feasreportorg", (Object)supplierId);
                        this.getModel().setValue("riskcontrolorg", (Object)supplierId);
                        this.getModel().setValue("legalproposalorg", (Object)supplierId);
                        this.getModel().setValue("fulfilreportorg", (Object)supplierId);
                        break;
                    }
                    this.getModel().setValue("project", null);
                    this.getModel().setValue("projectsource", null);
                    this.getModel().setValue("feasreportorg", null);
                    this.getModel().setValue("riskcontrolorg", null);
                    this.getModel().setValue("legalproposalorg", null);
                    this.getModel().setValue("fulfilreportorg", null);
                    break;
                }
                this.getView().getPageCache().put(OLD_SELF_RESEARCH_CACHE, oldValue.getPkValue().toString());
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u81ea\u7814\u7f16\u53f7\u5c06\u6e05\u9664\u6240\u6709\u4fe1\u606f\u3002\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\uff1f", (String)"ProjectReportEditPlugin_11", (String)"pmgt-pmfs-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(SELF_RESEARCH_CALLBACK));
                break;
            }
            case "declarevalue": {
                BigDecimal declareValue = (BigDecimal)changeData.getNewValue();
                int rowIndex = this.getModel().getEntryCurrentRowIndex("indexentry");
                DynamicObject IndexName = (DynamicObject)this.getModel().getValue("indexname", rowIndex);
                if (IndexName == null) {
                    return;
                }
                DynamicObject projectKind = (DynamicObject)this.getModel().getValue("projectkind");
                DynamicObject kindControlSetting = BusinessDataServiceHelper.loadSingle((String)"pmbs_prokindctrlsetting", (String)"id", (QFilter[])new QFilter[]{new QFilter("projectkind", "=", projectKind.getPkValue())});
                DynamicObjectCollection settingIndexEntries = (kindControlSetting = BusinessDataServiceHelper.loadSingle((Object)kindControlSetting.getPkValue(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmbs_prokindctrlsetting"))).getDynamicObjectCollection("indexentry");
                if (settingIndexEntries.size() <= 0) break;
                for (DynamicObject settingIndexEntry : settingIndexEntries) {
                    BigDecimal excellent;
                    BigDecimal standard;
                    String indexWarnLight;
                    DynamicObject settingIndexName = settingIndexEntry.getDynamicObject("indexname");
                    if (settingIndexName == null || !settingIndexName.getPkValue().equals(IndexName.getPkValue()) || (indexWarnLight = this.getIndexWarnLight(standard = settingIndexEntry.getBigDecimal("standardindex"), declareValue, excellent = settingIndexEntry.getBigDecimal("excellentindex"))) == null) continue;
                    this.getModel().setValue("indexwarnlight", (Object)indexWarnLight, rowIndex);
                }
                break;
            }
            case "projectkind": {
                DynamicObject newValue = (DynamicObject)changeData.getNewValue();
                if (newValue == null) break;
                DynamicObject kindControlSetting = BusinessDataServiceHelper.loadSingle((String)"pmbs_prokindctrlsetting", (String)"id", (QFilter[])new QFilter[]{new QFilter("projectkind", "=", newValue.getPkValue())});
                kindControlSetting = BusinessDataServiceHelper.loadSingle((Object)kindControlSetting.getPkValue(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmbs_prokindctrlsetting"));
                DynamicObjectCollection settingIndexEntries = kindControlSetting.getDynamicObjectCollection("indexentry");
                this.getModel().deleteEntryData("indexentry");
                if (settingIndexEntries.size() <= 0) break;
                DynamicObjectCollection indexEntry = this.getModel().getEntryEntity("indexentry");
                for (DynamicObject settingIndexEntry : settingIndexEntries) {
                    DynamicObject entry = new DynamicObject(indexEntry.getDynamicObjectType());
                    entry.set("indexname", settingIndexEntry.get("indexname"));
                    entry.set("declarevalue", (Object)0);
                    indexEntry.add((Object)entry);
                }
                this.getModel().updateEntryCache(indexEntry);
                this.getView().updateView("indexentry");
                break;
            }
        }
    }

    protected void deleteProjectData() {
        String projectSource = (String)this.getModel().getValue("projectsource");
        this.updateProjectData(projectSource, null);
    }

    private void updateProjectData(String projectSource, DynamicObject newValue) {
        if (newValue != null) {
            QFilter billStatusFilter;
            QFilter projectFilter;
            DynamicObject[] projectReports;
            if (StringUtils.equals((CharSequence)PROJECT_APPROVAL, (CharSequence)projectSource)) {
                DynamicObject projectApproval = BusinessDataServiceHelper.loadSingle((Object)newValue.getPkValue(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmas_pro_approval"));
                this.getModel().setValue("projectname", (Object)projectApproval.getString("billname"));
                this.getModel().setValue("reportorg", (Object)projectApproval.getDynamicObject("org"));
                this.getModel().setValue("projectkind", (Object)projectApproval.getDynamicObject("kind"));
                this.getModel().setValue("investdirection", (Object)projectApproval.getString("investdirection"));
                this.getModel().setValue("industrykind", (Object)projectApproval.getDynamicObject("industrykind"));
                this.getModel().setValue("industry", (Object)projectApproval.getDynamicObject("industry"));
                this.getModel().setValue("proregion", (Object)projectApproval.getString("projectarea"));
                this.getModel().setValue("projectcurrency", (Object)projectApproval.getDynamicObject("currencyfield"));
                this.getModel().setValue("totalamount", (Object)projectApproval.getBigDecimal("projcetbugamt"));
                this.getModel().setValue("annualamount", (Object)projectApproval.getBigDecimal("proyearbudgetamt"));
                this.getModel().setValue("projectorg", (Object)projectApproval.getDynamicObject("syscreateorg"));
                this.getModel().setValue("implementorg", (Object)projectApproval.getDynamicObject("department"));
                this.getModel().setValue("proleader", (Object)projectApproval.getDynamicObject("proleader"));
                this.getModel().setValue("leaderconttype", (Object)projectApproval.getString("leaderconttype"));
                this.getModel().setValue("iscopypro", (Object)projectApproval.getBoolean("Iscopypro"));
                this.getModel().setValue("copytype", (Object)projectApproval.getString("copytype"));
                this.getModel().setValue("isprovincialpro", (Object)projectApproval.getBoolean("isprovincialpro"));
                this.getModel().setValue("isspecialpro", (Object)projectApproval.getBoolean("isspecialpro"));
                this.getModel().setValue("isplanpro", (Object)projectApproval.getBoolean("isplanpro"));
                this.getModel().setValue("introduction", (Object)projectApproval.getString("description"));
                this.getModel().setValue("background", (Object)projectApproval.getString("procondition"));
                this.getModel().setValue("purpose", (Object)projectApproval.getString("purpose"));
                Date planBeginDate = projectApproval.getDate("planbegindate");
                Date planEndDate = projectApproval.getDate("planenddate");
                if (planBeginDate != null && planEndDate != null) {
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(planBeginDate);
                    int startYear = calendar.get(1);
                    int startMonth = calendar.get(2) + 1;
                    int startDay = calendar.get(5);
                    calendar.clear();
                    calendar.setTime(planEndDate);
                    int endYear = calendar.get(1);
                    int endMonth = calendar.get(2) + 1;
                    int endDay = calendar.get(5);
                    if (endMonth == startMonth && endDay > startDay) {
                        ++endMonth;
                    }
                    this.getModel().setValue("investperiod", (Object)String.format(ResManager.loadKDString((String)"%1$s\u5e74%2$s\u6708", (String)"ProjectReportEditPlugin_1", (String)"pmgt-pmfs-formplugin", (Object[])new Object[0]), endYear - startYear, endMonth - startMonth));
                }
                DynamicObjectCollection currencyEntry = projectApproval.getDynamicObjectCollection("fundsourceentry");
                this.getModel().deleteEntryData("sourceentry");
                if (currencyEntry.size() > 0) {
                    for (int i = 0; i < currencyEntry.size(); ++i) {
                        DynamicObject currencyDynamicObject2 = (DynamicObject)currencyEntry.get(i);
                        int newEntryRow = this.getModel().createNewEntryRow("sourceentry");
                        this.getModel().setValue("currency", currencyDynamicObject2.get("currency"), newEntryRow);
                        this.getModel().setValue("entrytotalamount", currencyDynamicObject2.get("sumamount"), newEntryRow);
                        this.getModel().setValue("entryannualamt", currencyDynamicObject2.get("amount"), newEntryRow);
                        this.getModel().setValue("captialform", currencyDynamicObject2.get("formofinvest"), newEntryRow);
                        this.getModel().setValue("fundsourcetype", currencyDynamicObject2.get("sourcetype"), newEntryRow);
                        this.getModel().setValue("entryremark", currencyDynamicObject2.get("funddescription"), newEntryRow);
                        this.getModel().setValue("entryscale", (Object)currencyDynamicObject2.getBigDecimal("scale"), newEntryRow);
                    }
                }
            } else if (StringUtils.equals((CharSequence)APPROVAl_APPLY, (CharSequence)projectSource)) {
                DynamicObject projectApply = BusinessDataServiceHelper.loadSingle((Object)newValue.getPkValue(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmas_approval_apply"));
                this.getModel().setValue("projectname", (Object)projectApply.getString("billname"));
                this.getModel().setValue("reportorg", (Object)projectApply.getDynamicObject("company"));
                this.getModel().setValue("projectkind", (Object)projectApply.getDynamicObject("group"));
                this.getModel().setValue("investdirection", (Object)projectApply.getString("investdirection"));
                this.getModel().setValue("industrykind", (Object)projectApply.getDynamicObject("industrykind"));
                this.getModel().setValue("investperiod", (Object)projectApply.getString("investperiod"));
                this.getModel().setValue("industry", (Object)projectApply.getDynamicObject("industry"));
                this.getModel().setValue("proregion", (Object)projectApply.getString("proregion"));
                this.getModel().setValue("projectcurrency", (Object)projectApply.getDynamicObject("projectcurrency"));
                this.getModel().setValue("totalamount", (Object)projectApply.getBigDecimal("totalamount"));
                this.getModel().setValue("annualamount", (Object)projectApply.getBigDecimal("annualamount"));
                this.getModel().setValue("projectorg", (Object)projectApply.getDynamicObject("projectorg"));
                this.getModel().setValue("implementorg", (Object)projectApply.getDynamicObject("implementorg"));
                this.getModel().setValue("proleader", (Object)projectApply.getDynamicObject("proleader"));
                this.getModel().setValue("leaderconttype", (Object)projectApply.getString("leaderconttype"));
                this.getModel().setValue("iscopypro", (Object)projectApply.getBoolean("iscopypro"));
                this.getModel().setValue("copytype", (Object)projectApply.getString("copytype"));
                this.getModel().setValue("isprovincialpro", (Object)projectApply.getBoolean("isprovincialpro"));
                this.getModel().setValue("isspecialpro", (Object)projectApply.getBoolean("isspecialpro"));
                this.getModel().setValue("isplanpro", (Object)projectApply.getBoolean("isplanpro"));
                this.getModel().setValue("introduction", (Object)projectApply.getString("introduction"));
                this.getModel().setValue("background", (Object)projectApply.getString("background"));
                this.getModel().setValue("purpose", (Object)projectApply.getString("purpose"));
                this.getModel().setValue("projectrisk", (Object)projectApply.getString("projectrisk"));
                DynamicObjectCollection currencyEntry = projectApply.getDynamicObjectCollection("sourceentry");
                this.getModel().deleteEntryData("sourceentry");
                if (currencyEntry.size() > 0) {
                    BigDecimal entryTotalAmountSum = currencyEntry.stream().map(currencyDynamicObject -> currencyDynamicObject.getBigDecimal("entrytotalamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
                    for (int i = 0; i < currencyEntry.size(); ++i) {
                        DynamicObject currencyDynamicObject3 = (DynamicObject)currencyEntry.get(i);
                        int newEntryRow = this.getModel().createNewEntryRow("sourceentry");
                        this.getModel().setValue("currency", currencyDynamicObject3.get("entrycurrency"), newEntryRow);
                        this.getModel().setValue("entryannualamt", currencyDynamicObject3.get("entryannualamt"), newEntryRow);
                        this.getModel().setValue("captialform", currencyDynamicObject3.get("entrycaptialform"), newEntryRow);
                        this.getModel().setValue("fundsourcetype", currencyDynamicObject3.get("entryfundresource"), newEntryRow);
                        this.getModel().setValue("entryremark", currencyDynamicObject3.get("entryremark"), newEntryRow);
                        BigDecimal totalAmout = currencyDynamicObject3.getBigDecimal("entrytotalamount");
                        this.getModel().setValue("entrytotalamount", (Object)totalAmout, newEntryRow);
                        if (totalAmout.compareTo(BigDecimal.ZERO) == 0 || entryTotalAmountSum.compareTo(BigDecimal.ZERO) == 0) continue;
                        this.getModel().setValue("entryscale", (Object)totalAmout.divide(entryTotalAmountSum, RoundingMode.HALF_UP).multiply(BigDecimal.valueOf(100L)), newEntryRow);
                    }
                }
            }
            if ((projectReports = BusinessDataServiceHelper.load((String)"pmfs_projectreport", (String)"auditdate", (QFilter[])new QFilter[]{projectFilter = new QFilter("project", "=", newValue.getPkValue()), billStatusFilter = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue())}, (String)"auditdate desc")).length > 0) {
                DynamicObject projectReport = BusinessDataServiceHelper.loadSingle((Object)projectReports[0].getPkValue(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmfs_projectreport"));
                this.getModel().deleteEntryData("indexentry");
                DynamicObjectCollection indexEntry = projectReport.getDynamicObjectCollection("indexentry");
                for (DynamicObject indexObject : indexEntry) {
                    int newEntryRow = this.getModel().createNewEntryRow("indexentry");
                    this.getModel().setValue("indexname", (Object)indexObject.getDynamicObject("indexname"), newEntryRow);
                    this.getModel().setValue("declarevalue", (Object)indexObject.getBigDecimal("declarevalue"), newEntryRow);
                }
                this.getModel().setValue("isself", projectReport.get("isself"));
                this.getModel().setValue("feasreportorg", projectReport.get("feasreportorg"));
                this.getModel().setValue("feasreportdate", projectReport.get("feasreportdate"));
                this.getModel().setValue("riskcontrolorg", projectReport.get("riskcontrolorg"));
                this.getModel().setValue("riskcontroldate", projectReport.get("riskcontroldate"));
                this.getModel().setValue("legalproposalorg", projectReport.get("legalproposalorg"));
                this.getModel().setValue("legalproposaldate", projectReport.get("legalproposaldate"));
                this.getModel().setValue("fulfilreportorg", projectReport.get("fulfilreportorg"));
                this.getModel().setValue("fulfilreportdate", projectReport.get("fulfilreportdate"));
                this.getModel().setValue("markresearch", projectReport.get("markresearch"));
                this.getModel().setValue("technicalresearch", projectReport.get("technicalresearch"));
                this.getModel().setValue("financialresearch", projectReport.get("financialresearch"));
                this.getModel().setValue("lawresearch", projectReport.get("lawresearch"));
                this.getModel().setValue("researchresult", projectReport.get("researchresult"));
            }
        } else {
            this.getModel().deleteEntryData("sourceentry");
            this.getModel().deleteEntryData("indexentry");
            this.clearProjectFields();
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if (StringUtils.equals((CharSequence)OPERATE_VIEWLATESTINCICATOR, (CharSequence)operateKey)) {
            DynamicObjectCollection indexEntry = this.getModel().getEntryEntity("indexentry");
            DynamicObject projectKind = (DynamicObject)this.getModel().getValue("projectkind");
            if (projectKind == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9879\u76ee\u3002", (String)"ProjectReportEditPlugin_12", (String)"pmgt-pmfs-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject kindControlSetting = BusinessDataServiceHelper.loadSingle((String)"pmbs_prokindctrlsetting", (String)"id", (QFilter[])new QFilter[]{new QFilter("projectkind", "=", projectKind.getPkValue())});
            DynamicObjectCollection settingIndexEntries = (kindControlSetting = BusinessDataServiceHelper.loadSingle((Object)kindControlSetting.getPkValue(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmbs_prokindctrlsetting"))).getDynamicObjectCollection("indexentry");
            if (settingIndexEntries.size() == 0) {
                for (int i = 0; i < indexEntry.size(); ++i) {
                    this.getModel().setValue("indexwarnlight", null, i);
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u9879\u76ee\u5206\u7c7b\u672a\u7ef4\u62a4\u8003\u91cf\u6307\u6807\u4fe1\u606f\uff0c\u65e0\u6570\u636e\u66f4\u65b0\u3002", (String)"ProjectReportEditPlugin_13", (String)"pmgt-pmfs-formplugin", (Object[])new Object[0]));
                return;
            }
            Map<Object, BigDecimal> valueMap = indexEntry.stream().filter(key -> key.getDynamicObject("indexname") != null).collect(Collectors.toMap(key -> key.getDynamicObject("indexname").getPkValue(), value -> value.getBigDecimal("declarevalue")));
            this.getModel().deleteEntryData("indexentry");
            for (DynamicObject settingIndex : settingIndexEntries) {
                BigDecimal excellent;
                DynamicObject settingIndexName = settingIndex.getDynamicObject("indexname");
                int newEntryRow = this.getModel().createNewEntryRow("indexentry");
                this.getModel().setValue("indexname", (Object)settingIndexName, newEntryRow);
                if (settingIndexName == null || !valueMap.containsKey(settingIndexName.getPkValue())) continue;
                BigDecimal declareValue = valueMap.get(settingIndexName.getPkValue());
                this.getModel().setValue("declarevalue", (Object)declareValue, newEntryRow);
                BigDecimal standard = settingIndex.getBigDecimal("standardindex");
                String indexWarnLight = this.getIndexWarnLight(standard, declareValue, excellent = settingIndex.getBigDecimal("excellentindex"));
                if (indexWarnLight == null) continue;
                this.getModel().setValue("indexwarnlight", (Object)indexWarnLight, newEntryRow);
            }
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6700\u65b0\u6307\u6807\u4fe1\u606f\u5df2\u83b7\u53d6\u3002", (String)"ProjectReportEditPlugin_14", (String)"pmgt-pmfs-formplugin", (Object[])new Object[0]));
        }
    }

    private String getIndexWarnLight(BigDecimal standard, BigDecimal declareValue, BigDecimal excellent) {
        String indexWarnLight = null;
        if (excellent.compareTo(BigDecimal.ZERO) > 0 && excellent.compareTo(standard) > 0) {
            if (declareValue.compareTo(excellent) >= 0) {
                indexWarnLight = IndexWarnLightEnum.PASS.getValue();
            } else if (declareValue.compareTo(excellent) < 0) {
                indexWarnLight = IndexWarnLightEnum.RISK.getValue();
            }
        }
        if (standard.compareTo(BigDecimal.ZERO) > 0) {
            if (declareValue.compareTo(excellent) < 0 && declareValue.compareTo(standard) >= 0) {
                indexWarnLight = IndexWarnLightEnum.RISK.getValue();
            } else if (declareValue.compareTo(standard) < 0) {
                indexWarnLight = IndexWarnLightEnum.NO_PASS.getValue();
            }
        }
        return indexWarnLight;
    }

    protected void clearProjectFields() {
        this.getModel().setValue("projectname", null);
        this.getModel().setValue("reportorg", null);
        this.getModel().setValue("projectkind", null);
        this.getModel().setValue("investdirection", null);
        this.getModel().setValue("industrykind", null);
        this.getModel().setValue("industry", null);
        this.getModel().setValue("proregion", null);
        this.getModel().setValue("projectcurrency", null);
        this.getModel().setValue("totalamount", null);
        this.getModel().setValue("annualamount", null);
        this.getModel().setValue("projectorg", null);
        this.getModel().setValue("implementorg", null);
        this.getModel().setValue("proleader", null);
        this.getModel().setValue("leaderconttype", null);
        this.getModel().setValue("iscopypro", null);
        this.getModel().setValue("copytype", null);
        this.getModel().setValue("isprovincialpro", null);
        this.getModel().setValue("isspecialpro", null);
        this.getModel().setValue("isplanpro", null);
        this.getModel().setValue("introduction", null);
        this.getModel().setValue("background", null);
        this.getModel().setValue("purpose", null);
    }
}

