/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmfs.formplugin;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.pmgt.pmfs.formplugin.base.AbstractPmfsFormPlugin;

public class RiskTractEditPlugin
extends AbstractPmfsFormPlugin
implements ClickListener {
    private static final String Operate_TREATRISK = "treatrisk";
    private static final String ConfirmCallBack_PROJECT = "projectCallBack";
    private static final String Flag_BREAK = "isBreak";

    public void afterBindData(EventObject e) {
        String billName;
        super.afterBindData(e);
        DynamicObject project = (DynamicObject)this.getModel().getValue("project");
        DynamicObjectCollection riskEntry = this.getModel().getEntryEntity("risktrackentry");
        if (!riskEntry.isEmpty() && project != null && StringUtils.isEmpty((CharSequence)(billName = (String)this.getModel().getValue("billname")))) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("MM-dd");
            this.getModel().setValue("billname", (Object)String.format(ResManager.loadKDString((String)"\u9879\u76ee%1$s\u7684\u98ce\u9669\u8ddf\u8e2a%2$s", (String)"RiskTractEditPlugin_0", (String)"pmgt-pmfs-formplugin", (Object[])new Object[0]), project.getString("name"), dateFormat.format(new Date())));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String key;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        switch (key = operate.getOperateKey()) {
            case "treatrisk": {
                EntryGrid grid = (EntryGrid)this.getView().getControl("risktrackentry");
                int[] rows = grid.getEntryState().getSelectedRows();
                if (rows.length > 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6279\u91cf\u5904\u7406\u98ce\u9669\u8bb0\u5f55\uff0c\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"RiskTractEditPlugin_4", (String)"pmgt-pmfs-formplugin", (Object[])new Object[0]));
                    break;
                }
                if (rows.length < 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5904\u7406\u7684\u98ce\u9669\u8bb0\u5f55\u3002", (String)"RiskTractEditPlugin_5", (String)"pmgt-pmfs-formplugin", (Object[])new Object[0]));
                    break;
                }
                DynamicObject riskTrack = this.getModel().getEntryRowEntity("risktrackentry", rows[0]);
                String treatMeasures = riskTrack.getString("treatmeasures");
                String treatResults = riskTrack.getString("treatresults");
                DynamicObject operator = riskTrack.getDynamicObject("operator");
                Date treatTime = riskTrack.getDate("treattime");
                FormShowParameter param = new FormShowParameter();
                if (operator != null) {
                    param.setCustomParam("treatmeasures", (Object)treatMeasures);
                    param.setCustomParam("treatresults", (Object)treatResults);
                    param.setCustomParam("operator", (Object)operator.getPkValue().toString());
                    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
                    param.setCustomParam("treattime", (Object)dateFormat.format(treatTime));
                }
                param.setFormId("pmfs_risktreat");
                param.getOpenStyle().setShowType(ShowType.Modal);
                CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "risktrackentry");
                param.setCloseCallBack(callBack);
                this.getView().showForm(param);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        String actionId;
        super.closedCallBack(event);
        switch (actionId = event.getActionId()) {
            case "risktrackentry": {
                this.getView().invokeOperation("refresh");
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        ChangeData changeData = e.getChangeSet()[0];
        String ctrlName = e.getProperty().getName();
        if (StringUtils.equals((CharSequence)"project", (CharSequence)ctrlName)) {
            DynamicObject oldValue = (DynamicObject)changeData.getOldValue();
            String isBreak = this.getView().getPageCache().get(Flag_BREAK);
            this.getView().getPageCache().remove(Flag_BREAK);
            if (StringUtils.isEmpty((CharSequence)isBreak) && oldValue != null) {
                this.getView().getPageCache().put("project", oldValue.getPkValue().toString());
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u9879\u76ee\u540e\uff0c\u5206\u5f55\u98ce\u9669\u8ddf\u8e2a\u5217\u8868\u4fe1\u606f\u5c06\u88ab\u6e05\u7a7a\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\uff1f", (String)"RiskTractEditPlugin_6", (String)"pmgt-pmfs-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(ConfirmCallBack_PROJECT));
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        if (StringUtils.equals((CharSequence)ConfirmCallBack_PROJECT, (CharSequence)callBackId)) {
            if (MessageBoxResult.Yes.equals((Object)result)) {
                this.getModel().deleteEntryData("risktrackentry");
            } else {
                String projectId = this.getView().getPageCache().get("project");
                this.getView().getPageCache().put(Flag_BREAK, "true");
                this.getModel().setValue("project", (Object)Long.parseLong(projectId));
            }
        }
    }
}

