/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmfs.formplugin;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EventObject;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmgt.pmbs.common.enums.OperationEnum;
import kd.pmgt.pmfs.formplugin.base.AbstractPmfsFormPlugin;

public class RiskTreatEditPlugin
extends AbstractPmfsFormPlugin {
    private static final String TREAT_MEASURES = "treatmeasures";
    private static final String TREAT_RESULTS = "treatresults";
    private static final String OPERATOR = "operator";
    private static final String TREAT_TIME = "treattime";
    private static final String OPERATE_FLAG_SAVE = "btnok";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String operatorId = (String)parameter.getCustomParam(OPERATOR);
        long currUserId = RequestContext.get().getCurrUserId();
        if (StringUtils.isNotEmpty((CharSequence)operatorId)) {
            long userId = Long.parseLong(operatorId);
            if (currUserId != userId) {
                this.getView().setEnable(Boolean.FALSE, new String[]{TREAT_MEASURES});
                this.getView().setEnable(Boolean.FALSE, new String[]{TREAT_RESULTS});
                this.getView().setEnable(Boolean.FALSE, new String[]{OPERATE_FLAG_SAVE});
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u98ce\u9669\u5904\u7406\u4eba\u5fc5\u987b\u4e0e\u521b\u5efa\u4eba\u4e3a\u540c\u4e00\u4eba\u3002", (String)"RiskTreatEditPlugin_2", (String)"pmgt-pmfs-formplugin", (Object[])new Object[0]));
            }
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
            String treatMeasures = (String)parameter.getCustomParam(TREAT_MEASURES);
            String treatResults = (String)parameter.getCustomParam(TREAT_RESULTS);
            String treatTime = (String)parameter.getCustomParam(TREAT_TIME);
            this.getModel().setValue(TREAT_MEASURES, (Object)treatMeasures);
            this.getModel().setValue(TREAT_RESULTS, (Object)treatResults);
            this.getModel().setValue(OPERATOR, (Object)userId);
            try {
                if (StringUtils.isNotEmpty((CharSequence)treatTime)) {
                    this.getModel().setValue(TREAT_TIME, (Object)dateFormat.parse(treatTime));
                }
            }
            catch (ParseException parseException) {
                this.getView().showErrorNotification(String.valueOf(parseException));
            }
            this.getView().updateView(TREAT_MEASURES);
            this.getView().updateView(TREAT_RESULTS);
            this.getView().updateView(OPERATOR);
            this.getView().updateView(TREAT_TIME);
        } else {
            this.getModel().setValue(OPERATOR, (Object)currUserId);
            this.getModel().setValue(TREAT_TIME, (Object)new Date());
            this.getView().updateView(OPERATOR);
            this.getView().updateView(TREAT_TIME);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String key = operate.getOperateKey();
        if (OperationEnum.SAVE.getValue().equals(key)) {
            String treatMeasures = (String)this.getModel().getValue(TREAT_MEASURES);
            String treatResults = (String)this.getModel().getValue(TREAT_RESULTS);
            if (StringUtils.isEmpty((CharSequence)treatMeasures) && StringUtils.isEmpty((CharSequence)treatResults)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u5f55\u5165\u4e00\u9879\u5904\u7406\u63aa\u65bd\u6216\u5904\u7406\u7ed3\u679c\u3002", (String)"RiskTreatEditPlugin_3", (String)"pmgt-pmfs-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String key = operate.getOperateKey();
        if (OperationEnum.SAVE.getValue().equals(key)) {
            IFormView parentView = this.getView().getParentView();
            int rowIndex = parentView.getModel().getEntryCurrentRowIndex("risktrackentry");
            DynamicObject riskTrack = parentView.getModel().getDataEntity();
            riskTrack = BusinessDataServiceHelper.loadSingle((Object)riskTrack.getPkValue(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmfs_risktrack"));
            DynamicObjectCollection riskTrackEntry = riskTrack.getDynamicObjectCollection("risktrackentry");
            DynamicObject riskTreat = (DynamicObject)riskTrackEntry.get(rowIndex);
            riskTreat.set(TREAT_MEASURES, this.getModel().getValue(TREAT_MEASURES));
            riskTreat.set(TREAT_RESULTS, this.getModel().getValue(TREAT_RESULTS));
            riskTreat.set(OPERATOR, this.getModel().getValue(OPERATOR));
            riskTreat.set(TREAT_TIME, (Object)new Date());
            riskTreat.set("treatstatus", (Object)"HANDLED");
            SaveServiceHelper.update((DynamicObject)riskTrack);
        }
    }
}

