/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmfs.formplugin;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.pmgt.pmbs.common.enums.ProjectStatusEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmbs.common.utils.StringUtils;
import kd.pmgt.pmfs.formplugin.base.AbstractPmfsFormPlugin;

public class SelfResearchEditPlugin
extends AbstractPmfsFormPlugin
implements BeforeF7SelectListener {
    private static final String PROJECT_APPROVAL = "pmas_proappf7";
    private static final String APPROVAl_APPLY = "pmas_approval_apply_f7";

    public void afterCreateNewData(EventObject e) {
        long orgId = RequestContext.get().getOrgId();
        Map mapOrg = OrgUnitServiceHelper.getCompanyByOrg((Long)orgId, (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE);
        if (mapOrg.size() > 0) {
            orgId = (Long)mapOrg.get("id");
        }
        this.getModel().setValue("org", (Object)orgId);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit project = (BasedataEdit)this.getControl("project");
        project.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        project.addBeforeF7ViewDetailListener(beforeF7ViewDetailEvent -> {
            beforeF7ViewDetailEvent.setCancel(true);
            this.getView().showForm(this.buildShowProject(beforeF7ViewDetailEvent.getPkId()));
        });
    }

    private FormShowParameter buildShowProject(Object pkId) {
        boolean existApply = QueryServiceHelper.exists((String)"pmas_approval_apply", (Object)pkId);
        boolean existApproval = QueryServiceHelper.exists((String)"pmas_pro_approval", (Object)pkId);
        BillShowParameter showParameter = new BillShowParameter();
        if (existApply) {
            showParameter.setPkId(pkId);
            showParameter.setFormId("pmas_approval_apply");
        } else if (existApproval) {
            showParameter.setPkId(pkId);
            showParameter.setFormId("pmas_pro_approval");
        }
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setStatus(OperationStatus.VIEW);
        return showParameter;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData changeData = e.getChangeSet()[0];
        String name = e.getProperty().getName();
        if (kd.bos.dataentity.utils.StringUtils.equals((CharSequence)"project", (CharSequence)name)) {
            String projectSource = (String)this.getModel().getValue("projectsource");
            DynamicObject newValue = (DynamicObject)changeData.getNewValue();
            if (newValue != null) {
                if (kd.bos.dataentity.utils.StringUtils.equals((CharSequence)PROJECT_APPROVAL, (CharSequence)projectSource)) {
                    DynamicObject project = BusinessDataServiceHelper.loadSingle((Object)newValue.getPkValue(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmas_pro_approval"));
                    this.getModel().setValue("projectname", (Object)project.getString("billname"));
                    this.getModel().setValue("reportorg", (Object)project.getDynamicObject("org"));
                    this.getModel().setValue("projectbillstatus", (Object)project.getString("billstatus"));
                    this.getModel().setValue("projectkind", (Object)project.getDynamicObject("kind"));
                    this.getModel().setValue("investdirection", (Object)project.getString("investdirection"));
                    this.getModel().setValue("industrykind", (Object)project.getDynamicObject("industrykind"));
                    this.getModel().setValue("industry", (Object)project.getDynamicObject("industry"));
                    this.getModel().setValue("proregion", (Object)project.getString("projectarea"));
                    this.getModel().setValue("projectcurrency", (Object)project.getDynamicObject("currencyfield"));
                    this.getModel().setValue("totalamount", (Object)project.getBigDecimal("projcetbugamt"));
                    this.getModel().setValue("projectorg", (Object)project.getDynamicObject("syscreateorg"));
                    this.getModel().setValue("implementorg", (Object)project.getDynamicObject("department"));
                    this.getModel().setValue("proleader", (Object)project.getDynamicObject("proleader"));
                    this.getModel().setValue("leaderconttype", (Object)project.getString("leaderconttype"));
                    this.getModel().setValue("iscopypro", (Object)project.getBoolean("Iscopypro"));
                    this.getModel().setValue("copytype", (Object)project.getString("copytype"));
                    this.getModel().setValue("isprovincialpro", (Object)project.getBoolean("isprovincialpro"));
                    this.getModel().setValue("isspecialpro", (Object)project.getBoolean("isspecialpro"));
                    this.getModel().setValue("isplanpro", (Object)project.getBoolean("isplanpro"));
                    Date planBeginDate = project.getDate("planbegindate");
                    Date planEndDate = project.getDate("planenddate");
                    if (planBeginDate != null && planEndDate != null) {
                        Calendar calendar = Calendar.getInstance();
                        calendar.setTime(planBeginDate);
                        int startYear = calendar.get(1);
                        int startMonth = calendar.get(2) + 1;
                        int startDay = calendar.get(5);
                        calendar.clear();
                        calendar.setTime(planEndDate);
                        int endYear = calendar.get(1);
                        int endMonth = calendar.get(2) + 1;
                        int endDay = calendar.get(5);
                        if (endMonth == startMonth && endDay > startDay) {
                            ++endMonth;
                        }
                        this.getModel().setValue("investperiod", (Object)String.format(ResManager.loadKDString((String)"%1$s\u5e74%2$s\u6708", (String)"SelfResearchEditPlugin_1", (String)"pmgt-pmfs-formplugin", (Object[])new Object[0]), endYear - startYear, endMonth - startMonth));
                    }
                } else if (kd.bos.dataentity.utils.StringUtils.equals((CharSequence)APPROVAl_APPLY, (CharSequence)projectSource)) {
                    DynamicObject projectApply = BusinessDataServiceHelper.loadSingle((Object)newValue.getPkValue(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmas_approval_apply"));
                    this.getModel().setValue("projectname", (Object)projectApply.getString("billname"));
                    this.getModel().setValue("reportorg", (Object)projectApply.getDynamicObject("company"));
                    this.getModel().setValue("projectbillstatus", (Object)projectApply.getString("billstatus"));
                    this.getModel().setValue("projectkind", (Object)projectApply.getDynamicObject("group"));
                    this.getModel().setValue("investdirection", (Object)projectApply.getString("investdirection"));
                    this.getModel().setValue("industrykind", (Object)projectApply.getDynamicObject("industrykind"));
                    this.getModel().setValue("investperiod", (Object)projectApply.getString("investperiod"));
                    this.getModel().setValue("industry", (Object)projectApply.getDynamicObject("industry"));
                    this.getModel().setValue("proregion", (Object)projectApply.getString("proregion"));
                    this.getModel().setValue("projectcurrency", (Object)projectApply.getDynamicObject("projectcurrency"));
                    this.getModel().setValue("totalamount", (Object)projectApply.getBigDecimal("totalamount"));
                    this.getModel().setValue("projectorg", (Object)projectApply.getDynamicObject("projectorg"));
                    this.getModel().setValue("implementorg", (Object)projectApply.getDynamicObject("implementorg"));
                    this.getModel().setValue("proleader", (Object)projectApply.getDynamicObject("proleader"));
                    this.getModel().setValue("leaderconttype", (Object)projectApply.getString("leaderconttype"));
                    this.getModel().setValue("iscopypro", (Object)projectApply.getBoolean("iscopypro"));
                    this.getModel().setValue("copytype", (Object)projectApply.getString("copytype"));
                    this.getModel().setValue("isprovincialpro", (Object)projectApply.getBoolean("isprovincialpro"));
                    this.getModel().setValue("isspecialpro", (Object)projectApply.getBoolean("isspecialpro"));
                    this.getModel().setValue("isplanpro", (Object)projectApply.getBoolean("isplanpro"));
                }
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        super.beforeF7Select(event);
        String propertyName = event.getProperty().getName();
        if (kd.bos.dataentity.utils.StringUtils.equals((CharSequence)"project", (CharSequence)propertyName)) {
            String projectSource = (String)this.getModel().getValue("projectsource");
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            if (org != null) {
                ListShowParameter param = (ListShowParameter)event.getFormShowParameter();
                List qFilters = param.getListFilterParameter().getQFilters();
                if (kd.bos.dataentity.utils.StringUtils.equals((CharSequence)PROJECT_APPROVAL, (CharSequence)projectSource)) {
                    qFilters.add(new QFilter("createorg", "=", org.getPkValue()));
                    qFilters.add(new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue()));
                    ArrayList<String> excludeStatusIds = new ArrayList<String>();
                    excludeStatusIds.add(ProjectStatusEnum.BUSSINESS_CLOSE.getId());
                    excludeStatusIds.add(ProjectStatusEnum.FINANCIAL_CLOSE.getId());
                    excludeStatusIds.add(ProjectStatusEnum.SUSPEND.getId());
                    excludeStatusIds.add(ProjectStatusEnum.QUIT.getId());
                    qFilters.add(new QFilter("prostatus", "not in", (Object)StringUtils.stringArrToLongArr((String[])excludeStatusIds.toArray(new String[excludeStatusIds.size()]))));
                    qFilters.add(new QFilter("prostatus", "!=", (Object)0));
                } else if (kd.bos.dataentity.utils.StringUtils.equals((CharSequence)APPROVAl_APPLY, (CharSequence)projectSource)) {
                    qFilters.add(new QFilter("company", "=", org.getPkValue()));
                    qFilters.add(new QFilter("status", "=", (Object)StatusEnum.CHECKED.getValue()));
                    qFilters.add(new QFilter("iscopypro", "=", (Object)Boolean.FALSE));
                }
            }
        }
    }
}

