/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmfs.formplugin.initialize;

import com.alibaba.fastjson.JSONArray;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleDynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.DateTimeEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.pmgt.pmbs.business.helper.FileAttachmentHelper;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmbs.common.enums.projectinitialize.SplitDimensionEnum;
import kd.pmgt.pmbs.common.enums.projectinitialize.SplitMethodEnum;
import kd.pmgt.pmbs.common.enums.projectinitialize.WBSTypeEnum;
import kd.pmgt.pmbs.common.utils.DateUtil;
import kd.pmgt.pmfs.business.helper.ProjectInitializeHelper;
import kd.pmgt.pmfs.business.manage.ProjectInitializeSubEntryExcelSupport;
import kd.pmgt.pmfs.common.enums.TimeTypeEnum;
import kd.pmgt.pmfs.formplugin.base.AbstractPmfsBillPlugin;

public class ProjectInitializeBillPlugin
extends AbstractPmfsBillPlugin
implements RowClickEventListener {
    protected static final Log LOG = LogFactory.getLog(ProjectInitializeBillPlugin.class);
    protected static final String PMFS_PROJECTINITEXCELIMP = "pmfs_projectinitexcelimp";
    protected static final String ATTACHMENTPANEL = "attachmentpanel";
    protected static final String CUR_SPLIT_ENTRY_ROW = "curListRow";
    protected static final String IMPORT_SUB_EXCEL = "importsubexcel";
    protected static final String EXPORT_SUB_EXCEL = "exportsubexcel";
    protected static final String CALL_BACK_IMPORT_SUB_EXCEL = "callBackImportExcel";
    private static final String NEW_SUB_ENTRY = "newsubentry";
    private static final String OLD_PROJECT = "oldProject";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TreeEntryGrid splitEntry = (TreeEntryGrid)this.getControl("splitentry");
        if (splitEntry != null) {
            splitEntry.addRowClickListener((RowClickEventListener)this);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.changeEntryDateMaskByTimeType();
        this.changeSplitDimensionComboItemByTimeType();
        this.changeSubEntryDateMaskBySplitDimension();
        this.getPageCache().put(CUR_SPLIT_ENTRY_ROW, String.valueOf(0));
        DynamicObject project = (DynamicObject)this.getModel().getValue("project");
        String billStatus = (String)this.getModel().getValue("billstatus");
        if (project != null && StringUtils.equals((CharSequence)billStatus, (CharSequence)StatusEnum.TEMPSAVE.getValue())) {
            this.updateProjectStageStatusEntry();
        }
    }

    protected void updateProjectStageStatusEntry() {
        boolean needUpdate = false;
        DynamicObjectCollection wbsEntries = this.getModel().getDataEntity(true).getDynamicObjectCollection("splitentry");
        StringBuilder tipsMsg = new StringBuilder();
        for (DynamicObject wbsEntry : wbsEntries) {
            BigDecimal schedule;
            BigDecimal statusPercent;
            DynamicObject projectStatus = wbsEntry.getDynamicObject("splitentry_projectstatus");
            if (projectStatus == null || (statusPercent = projectStatus.getBigDecimal("statuspercent")).compareTo(schedule = wbsEntry.getBigDecimal("splitentry_schedule")) == 0) continue;
            needUpdate = true;
            tipsMsg.append(String.format(ResManager.loadKDString((String)"WBS\uff1a%1$s\u3001%2$s\uff0c\u8fdb\u5ea6\u5df2\u66f4\u65b0\uff0c\u5df2\u52a0\u8f7d\u4e3a\u6700\u65b0\u6570\u636e\u3002", (String)"ProjectInitializeBillPlugin_39", (String)"pmgt-pmfs-formplugin", (Object[])new Object[0]), wbsEntry.getString("splitentry_wbsnumber"), wbsEntry.getLocaleString("splitentry_wbsname").getLocaleValue()));
            tipsMsg.append("\n");
            wbsEntry.set("splitentry_schedule", (Object)statusPercent);
        }
        if (needUpdate) {
            this.getView().showTipNotification(tipsMsg.toString());
            this.getModel().updateEntryCache(wbsEntries);
            this.getView().updateView("splitentry");
        }
    }

    protected void changeEntryDateMaskByTimeType() {
        String timeType = (String)this.getModel().getValue("timetype");
        HashMap<String, String> map = new HashMap<String, String>();
        TreeEntryGrid treeGrid = (TreeEntryGrid)this.getView().getControl("splitentry");
        if (TimeTypeEnum.FORMAT2DAY.getValue().equals(timeType)) {
            map.put("mask", "YYYY-MM-DD");
        } else {
            map.put("mask", "YYYY-MM-DD HH:mm:ss");
        }
        map.put("type", "datetime");
        treeGrid.setColumnProperty("splitentry_planstarttime", "editor", map);
        treeGrid.setColumnProperty("splitentry_planendtime", "editor", map);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getModel().setValue("version", (Object)1);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        if (null != formShowParameter.getCustomParam("pmfs_projectinitialize")) {
            this.getModel().setValue("id", (Object)ORM.create().genLongId((IDataEntityType)this.getModel().getDataEntityType()));
            Long resourceID = (Long)formShowParameter.getCustomParam("pmfs_projectinitialize");
            DynamicObject project = BusinessDataServiceHelper.loadSingle((Object)resourceID, (String)"pmfs_projectinitialize").getDynamicObject("project");
            DynamicObject resourceModel = ProjectInitializeHelper.getInstance().getProjectInitialize(project);
            if (resourceModel != null) {
                this.fillReviseModel(resourceModel);
                boolean wbsIsReferenced = (Boolean)formShowParameter.getCustomParam("wbsIsRefenced");
                if (wbsIsReferenced) {
                    this.getView().setEnable(Boolean.valueOf(false), new String[]{"splitbycount", "splitdimension", "splitmethod"});
                }
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        Object newValue = e.getChangeSet()[0].getNewValue();
        Object oldValue = e.getChangeSet()[0].getOldValue();
        block13 : switch (propertyName) {
            case "timetype": {
                DynamicObjectCollection subSplitEntries;
                this.getPageCache().put("timetype", changeData.getOldValue().toString());
                this.changeSplitDimensionComboItemByTimeType();
                DynamicObject model = this.getModel().getDataEntity(true);
                DynamicObjectCollection splitEntries = null != model.getDynamicObjectType().getProperty("splitentry") ? model.getDynamicObjectCollection("splitentry") : new DynamicObjectCollection();
                DynamicObjectCollection dynamicObjectCollection = subSplitEntries = null != model.getDynamicObjectType().getProperty("subsplitentry") ? model.getDynamicObjectCollection("subsplitentry") : new DynamicObjectCollection();
                if (splitEntries.isEmpty() && subSplitEntries.isEmpty()) break;
                this.getView().showConfirm(ResManager.loadKDString((String)"\u53d8\u66f4\u8ba1\u5212\u65f6\u95f4\u7c7b\u578b\u5c06\u6e05\u7a7a\u9879\u76ee\u62c6\u5206\u8bbe\u7f6e\u548cWBS\u6570\u91cf\u62c6\u5206\u8bbe\u7f6e\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"ProjectInitializeBillPlugin_40", (String)"pmgt-pmfs-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("timetype", (IFormPlugin)this));
                break;
            }
            case "splitdimension": {
                if (this.checkSubEntryIsEmpty()) {
                    this.changeSubEntryDateMaskBySplitDimension();
                    break;
                }
                this.getPageCache().put("splitdimension", (String)oldValue);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u53d8\u66f4\u201c\u6570\u91cf\u62c6\u5206\u7ef4\u5ea6\u201d\u5c06\u6e05\u7a7a\u73b0\u6709WBS\u6570\u91cf\u62c6\u5206\u8bbe\u7f6e\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"ProjectInitializeBillPlugin_41", (String)"pmgt-pmfs-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("splitdimension", (IFormPlugin)this));
                break;
            }
            case "splitmethod": {
                if (this.checkSubEntryIsEmpty()) break;
                this.getPageCache().put("splitmethod", (String)oldValue);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u53d8\u66f4\u4e3a\u6570\u91cf\u62c6\u5206\u65b9\u5f0f\u5c06\u6e05\u7a7a\u73b0\u6709WBS\u6570\u91cf\u62c6\u5206\u8bbe\u7f6e\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"ProjectInitializeBillPlugin_42", (String)"pmgt-pmfs-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("splitmethod", (IFormPlugin)this));
                break;
            }
            case "project": {
                DynamicObject project = (DynamicObject)this.getModel().getValue("project");
                if (project == null) {
                    DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("splitentry");
                    if (entryEntity.isEmpty()) {
                        this.getModel().deleteEntryData("splitentry");
                        break;
                    }
                    this.getPageCache().put(OLD_PROJECT, ((DynamicObject)oldValue).get("id").toString());
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u5df2\u6709\u9879\u76ee\u62c6\u5206\u8bbe\u7f6e\u660e\u7ec6\u3002\u6b64\u64cd\u4f5c\u5c06\u6e05\u7a7a\u62c6\u5206\u6570\u636e\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\u3002", (String)"ProjectInitializeBillPlugin_43", (String)"pmgt-pmfs-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("project", (IFormPlugin)this));
                    break;
                }
                DynamicObject projectApproval = BusinessDataServiceHelper.loadSingle((String)"pmas_pro_approval", (String)String.join((CharSequence)",", "id", "currencyfield"), (QFilter[])new QFilter[]{new QFilter("pro", "=", project.getPkValue())});
                if (projectApproval != null) {
                    this.getModel().setValue("currency", (Object)projectApproval.getDynamicObject("currencyfield"));
                }
                DynamicObjectCollection splitEntries = this.getModel().getDataEntity(true).getDynamicObjectCollection("splitentry");
                splitEntries.clear();
                QFilter projectIdFilter = new QFilter("project", "=", project.getPkValue());
                String selectProperties = String.join((CharSequence)",", "projectstage", "statuspercent");
                DynamicObject[] proStatusArray = BusinessDataServiceHelper.load((String)"pmas_prostatus", (String)selectProperties, (QFilter[])projectIdFilter.toArray(), (String)"projectstage.serial");
                if (proStatusArray.length > 0) {
                    long[] splitEntryIds = DB.genLongIds((String)"t_pmfs_splitentry", (int)proStatusArray.length);
                    for (int i = 0; i < proStatusArray.length; ++i) {
                        DynamicObject proStatus = proStatusArray[i];
                        DynamicObject splitEntry = splitEntries.addNew();
                        DecimalFormat df = new DecimalFormat("000");
                        DynamicObject projectStage = proStatus.getDynamicObject("projectstage");
                        splitEntry.set("id", (Object)splitEntryIds[i]);
                        splitEntry.set("splitentry_wbsnumber", (Object)String.format("W%s", df.format(i + 1)));
                        splitEntry.set("splitentry_wbsname", projectStage.get("name"));
                        splitEntry.set("splitentry_projectstatus", (Object)proStatus);
                        splitEntry.set("splitentry_type", (Object)WBSTypeEnum.Single_Project.getValue());
                        splitEntry.set("splitentry_schedule", (Object)proStatus.getBigDecimal("statuspercent"));
                        splitEntry.set("splitentry_milestone", (Object)"YES");
                        splitEntry.set("resourcewbsid", (Object)splitEntryIds[i]);
                    }
                }
                this.getModel().updateEntryCache(splitEntries);
                this.getView().updateView("splitentry");
                break;
            }
            case "splitentry_planstarttime": 
            case "splitentry_planendtime": {
                this.checkPlanTimeAndInitSub(propertyName, rowIndex);
                break;
            }
            case "subcount": {
                String splitMethod = (String)this.getModel().getValue("splitmethod");
                if (!SplitMethodEnum.BY_COUNT.getValue().equals(splitMethod)) break;
                int curSplitEntryRow = Integer.parseInt(this.getPageCache().get(CUR_SPLIT_ENTRY_ROW));
                this.culSplitEntryCount(curSplitEntryRow);
                this.culSubSplitEntryPercentage(curSplitEntryRow);
                break;
            }
            case "subdate": {
                if (newValue == null) break;
                this.checkSameSubDate((Date)newValue, rowIndex);
                break;
            }
            case "splitbycount": {
                if (((Boolean)newValue).booleanValue() || this.checkSubEntryIsEmpty()) break;
                this.getView().showConfirm(ResManager.loadKDString((String)"WBS\u6570\u91cf\u62c6\u5206\u660e\u7ec6\u5df2\u5b58\u5728\uff0c\u7ee7\u7eed\u64cd\u4f5c\u5c06\u6e05\u7a7a\u62c6\u5206\u6570\u636e\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"ProjectInitializeBillPlugin_44", (String)"pmgt-pmfs-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("splitbycount", (IFormPlugin)this));
                break;
            }
            case "splitentry_wbsnumber": {
                this.checkWbsNumberIsExist((String)newValue, rowIndex);
                break;
            }
            case "splitentry_wbsname": {
                if (newValue == null) {
                    return;
                }
                LocaleDynamicObjectCollection newName = (LocaleDynamicObjectCollection)newValue;
                HashMap<String, String> nameMap = new HashMap<String, String>(16);
                for (DynamicObject dyn : newName) {
                    nameMap.put(dyn.getString("localeid"), dyn.getString("splitentry_wbsname"));
                }
                LocaleString newLocale = LocaleString.fromMap(nameMap);
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("splitentry");
                for (int i = 0; i < entryEntity.size(); ++i) {
                    DynamicObject dyn = (DynamicObject)entryEntity.get(i);
                    ILocaleString oldLocale = dyn.getLocaleString("splitentry_wbsname");
                    String sameName = this.getSameName(newLocale, oldLocale);
                    if (sameName == null || i == rowIndex) continue;
                    String detail = String.format(ResManager.loadKDString((String)"\u7b2c%2$s\u884c\u4e0e\u7b2c%3$s\u884c\u7684WBS\u540d\u79f0\u201c%1$s\u201d\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ProjectInitializeBillPlugin_45", (String)"pmgt-pmfs-formplugin", (Object[])new Object[0]), sameName, rowIndex + 1, i + 1);
                    this.getView().showConfirm(ResManager.loadKDString((String)"WBS\u540d\u79f0\u5df2\u5b58\u5728\u3002", (String)"ProjectInitializeBillPlugin_46", (String)"pmgt-pmfs-formplugin", (Object[])new Object[0]), detail, MessageBoxOptions.OK, ConfirmTypes.Default, new ConfirmCallBackListener("splitentry_wbsname", (IFormPlugin)this));
                    this.getModel().setValue("splitentry_wbsname", null, rowIndex);
                    this.getModel().updateEntryCache(entryEntity);
                    this.getView().updateView();
                    break block13;
                }
                break;
            }
        }
    }

    private String getSameName(LocaleString newLocale, ILocaleString oldLocale) {
        if (StringUtils.equals((CharSequence)newLocale.getLocaleValue_zh_CN(), (CharSequence)oldLocale.getLocaleValue_zh_CN())) {
            return newLocale.getLocaleValue_zh_CN();
        }
        if (StringUtils.equals((CharSequence)newLocale.getLocaleValue_zh_TW(), (CharSequence)oldLocale.getLocaleValue_zh_TW())) {
            return newLocale.getLocaleValue_zh_TW();
        }
        if (StringUtils.equals((CharSequence)newLocale.getLocaleValue_en(), (CharSequence)oldLocale.getLocaleValue_en())) {
            return newLocale.getLocaleValue_en();
        }
        return null;
    }

    protected void checkWbsNumberIsExist(String newValue, int rowIndex) {
        DynamicObjectCollection splitEntries = this.getModel().getEntryEntity("splitentry");
        for (int i = 0; i < splitEntries.size(); ++i) {
            if (i == rowIndex || newValue == null || !newValue.equals(((DynamicObject)splitEntries.get(i)).get("splitentry_wbsnumber"))) continue;
            this.getView().showConfirm(ResManager.loadKDString((String)"WBS\u7f16\u7801\u5df2\u5b58\u5728\u3002", (String)"ProjectInitializeBillPlugin_47", (String)"pmgt-pmfs-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("splitentry_wbsnumber", (IFormPlugin)this));
        }
    }

    protected void clearSubSplitEntry() {
        DynamicObjectCollection splitEntry = this.getModel().getEntryEntity("splitentry");
        for (DynamicObject entry : splitEntry) {
            DynamicObjectCollection subSplitEntry = entry.getDynamicObjectCollection("subsplitentry");
            subSplitEntry.clear();
        }
        this.getModel().updateEntryCache(splitEntry);
        this.getView().updateView("subsplitentry");
    }

    protected boolean checkSubEntryIsEmpty() {
        DynamicObjectCollection splitEntry = this.getModel().getEntryEntity("splitentry");
        for (DynamicObject entry : splitEntry) {
            DynamicObjectCollection subSplitEntries = entry.getDynamicObjectCollection("subsplitentry");
            if (CollectionUtils.isEmpty((Collection)subSplitEntries)) continue;
            return false;
        }
        return true;
    }

    protected void culSubSplitEntryPercentage(int curSplitEntryRow) {
        BigDecimal qty = (BigDecimal)this.getModel().getValue("splitentry_qty", curSplitEntryRow);
        DynamicObjectCollection subSplitEntry = this.getModel().getEntryRowEntity("splitentry", curSplitEntryRow).getDynamicObjectCollection("subsplitentry");
        for (DynamicObject subWbs : subSplitEntry) {
            BigDecimal subCount = subWbs.getBigDecimal("subcount") == null ? BigDecimal.ZERO : subWbs.getBigDecimal("subcount");
            BigDecimal subPercentage = qty.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : subCount.multiply(new BigDecimal(100)).divide(qty, 2, RoundingMode.HALF_UP);
            subWbs.set("subpercentage", (Object)subPercentage);
        }
        this.getView().updateView("subsplitentry");
    }

    protected void culSubSplitEntryCount(int curSplitEntryRow) {
        BigDecimal qty = (BigDecimal)this.getModel().getValue("splitentry_qty", curSplitEntryRow);
        DynamicObjectCollection subSplitEntry = this.getModel().getEntryRowEntity("splitentry", curSplitEntryRow).getDynamicObjectCollection("subsplitentry");
        for (DynamicObject subWbs : subSplitEntry) {
            BigDecimal subPercentage = subWbs.getBigDecimal("subpercentage") == null ? BigDecimal.ZERO : subWbs.getBigDecimal("subpercentage");
            BigDecimal subCount = qty.divide(new BigDecimal(100)).multiply(subPercentage);
            subWbs.set("subcount", (Object)subCount);
        }
        this.getView().updateView("subsplitentry");
    }

    protected void checkSameSubDate(Date newValue, int rowIndex) {
        String splitDimension = (String)this.getModel().getValue("splitdimension");
        DynamicObjectCollection subSplitEntry = this.getModel().getEntryEntity("subsplitentry");
        for (int i = 0; i < subSplitEntry.size(); ++i) {
            Date subDate = ((DynamicObject)subSplitEntry.get(i)).getDate("subdate");
            if (subDate == null || i == rowIndex || !(SplitDimensionEnum.BY_MONTH.getValue().equals(splitDimension) && DateUtil.compareByMonth((Date)newValue, (Date)subDate) == 0 || SplitDimensionEnum.BY_DAY.getValue().equals(splitDimension) && DateUtil.compareByDay((Date)newValue, (Date)subDate) == 0) && (!SplitDimensionEnum.BY_HOUR.getValue().equals(splitDimension) || DateUtil.compareByHour((Date)newValue, (Date)subDate) != 0)) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"WBS\u7684\u201c\u671f\u95f4\u201d\u503c\u4e0d\u80fd\u6709\u91cd\u590d\u884c\u3002", (String)"ProjectInitializeBillPlugin_11", (String)"pmgt-pmfs-formplugin", (Object[])new Object[0]));
            int curSplitEntryRow = Integer.parseInt(this.getPageCache().get(CUR_SPLIT_ENTRY_ROW));
            this.getModel().setValue("subdate", null, rowIndex, curSplitEntryRow);
            return;
        }
    }

    protected void culSplitEntryCount(int curSplitEntryRow) {
        DynamicObject wbsSplit = this.getModel().getEntryRowEntity("splitentry", curSplitEntryRow);
        DynamicObjectCollection subEntry = wbsSplit.getDynamicObjectCollection("subsplitentry");
        BigDecimal allCount = BigDecimal.ZERO;
        for (DynamicObject subWbsSplit : subEntry) {
            BigDecimal subCount = subWbsSplit.getBigDecimal("subcount") == null ? BigDecimal.ZERO : subWbsSplit.getBigDecimal("subcount");
            allCount = allCount.add(subCount);
        }
        this.getModel().setValue("splitentry_qty", (Object)allCount, curSplitEntryRow);
    }

    protected void changeSplitDimensionComboItemByTimeType() {
        String timeType = (String)this.getModel().getValue("timetype");
        ComboEdit splitDimension = (ComboEdit)this.getControl("splitdimension");
        ArrayList<ComboItem> comboItemList = new ArrayList<ComboItem>(3);
        if (TimeTypeEnum.FORMAT2DAY.getValue().equals(timeType)) {
            comboItemList.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u6309\u6708", (String)"ProjectInitializeBillPlugin_12", (String)"pmgt-pmfs-formplugin", (Object[])new Object[0])), SplitDimensionEnum.BY_MONTH.getValue()));
            comboItemList.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u6309\u65e5", (String)"ProjectInitializeBillPlugin_13", (String)"pmgt-pmfs-formplugin", (Object[])new Object[0])), SplitDimensionEnum.BY_DAY.getValue()));
        } else if (TimeTypeEnum.FORMAT2HOUR.getValue().equals(timeType)) {
            comboItemList.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u6309\u5c0f\u65f6", (String)"ProjectInitializeBillPlugin_14", (String)"pmgt-pmfs-formplugin", (Object[])new Object[0])), SplitDimensionEnum.BY_HOUR.getValue()));
        }
        splitDimension.setComboItems(comboItemList);
    }

    protected void changeSplitDimensionValueByTimeType() {
        String timeType = (String)this.getModel().getValue("timetype");
        if (TimeTypeEnum.FORMAT2DAY.getValue().equals(timeType)) {
            this.getModel().setValue("splitdimension", (Object)SplitDimensionEnum.BY_MONTH.getValue());
        } else if (TimeTypeEnum.FORMAT2HOUR.getValue().equals(timeType)) {
            this.getModel().setValue("splitdimension", (Object)SplitDimensionEnum.BY_HOUR.getValue());
        }
    }

    protected void checkPlanTimeAndInitSub(String propertyName, int rowIndex) {
        Date planStartTime = (Date)this.getModel().getValue("splitentry_planstarttime", rowIndex);
        Date planEndTime = (Date)this.getModel().getValue("splitentry_planendtime", rowIndex);
        String timeType = (String)this.getModel().getValue("timetype");
        if (planStartTime != null && planEndTime != null) {
            if (TimeTypeEnum.FORMAT2DAY.getValue().equals(timeType) && DateUtil.compareByDay((Date)planStartTime, (Date)planEndTime) > 0 || TimeTypeEnum.FORMAT2HOUR.getValue().equals(timeType) && DateUtil.compareByHour((Date)planStartTime, (Date)planEndTime) > 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u8ba1\u5212\u5f00\u59cb\u65f6\u95f4\u201d\u4e0d\u80fd\u665a\u4e8e\u201c\u8ba1\u5212\u5b8c\u6210\u65f6\u95f4\u201d\u3002", (String)"ProjectInitializeBillPlugin_48", (String)"pmgt-pmfs-formplugin", (Object[])new Object[0]));
                this.getModel().setValue(propertyName, null);
                return;
            }
            this.initSubEntry(rowIndex, planStartTime, planEndTime);
        }
    }

    protected void initSubEntry(int rowIndex, Date planStartTime, Date planEndTime) {
        Boolean splitByCount = (Boolean)this.getModel().getValue("splitbycount");
        String splitDimension = (String)this.getModel().getValue("splitdimension");
        DynamicObjectCollection subSplitEntry = this.getModel().getEntryRowEntity("splitentry", rowIndex).getDynamicObjectCollection("subsplitentry");
        if (splitByCount.booleanValue() && subSplitEntry.size() == 0 && SplitDimensionEnum.BY_MONTH.getValue().equals(splitDimension)) {
            int diffMonth = DateUtil.getDaysBetweenMonth((Date)planStartTime, (Date)planEndTime);
            String wbsNumber = (String)this.getModel().getValue("splitentry_wbsnumber", rowIndex);
            Object wbsName = this.getModel().getValue("splitentry_wbsname", rowIndex);
            for (int i = 0; i < diffMonth + 1; ++i) {
                DynamicObject subWbs = new DynamicObject(subSplitEntry.getDynamicObjectType());
                subWbs.set("subdate", (Object)DateUtil.getDateAfterAddMonth((Date)planStartTime, (int)i));
                subWbs.set("subwbsnumber", (Object)wbsNumber);
                subWbs.set("subwbsname", wbsName);
                subSplitEntry.add((Object)subWbs);
            }
            this.getView().updateView("subsplitentry");
        }
    }

    protected void changeSubEntryDateMaskBySplitDimension() {
        String splitDimension = (String)this.getModel().getValue("splitdimension");
        HashMap<String, String> map = new HashMap<String, String>();
        EntryGrid subSplitEntry = (EntryGrid)this.getView().getControl("subsplitentry");
        if (SplitDimensionEnum.BY_MONTH.getValue().equals(splitDimension)) {
            map.put("mask", "YYYY-MM");
        } else if (SplitDimensionEnum.BY_DAY.getValue().equals(splitDimension)) {
            map.put("mask", "YYYY-MM-DD");
        } else if (SplitDimensionEnum.BY_HOUR.getValue().equals(splitDimension)) {
            map.put("mask", "YYYY-MM-DD HH");
        }
        map.put("type", "datetime");
        subSplitEntry.setColumnProperty("subdate", "editor", map);
        DateTimeEdit subDate = (DateTimeEdit)this.getControl("subdate");
        subDate.setMustInput(true);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "audit": {
                this.refreshCollectionLevel(this.getModel().getEntryEntity("splitentry"));
                this.getModel().setValue("executiveversion", (Object)true);
                this.getModel().updateCache();
                break;
            }
            case "deleteentry": {
                int[] selRows = ((TreeEntryGrid)this.getControl("splitentry")).getSelectRows();
                if (this.checkProStageRow(selRows)) {
                    args.setCancel(true);
                    return;
                }
                this.checkWBSIsRefenced(selRows);
                this.updateHeadAmount(selRows);
                break;
            }
            case "deletesubentry": {
                int[] selRows = new int[]{Integer.parseInt(this.getPageCache().get(CUR_SPLIT_ENTRY_ROW))};
                this.checkWBSIsRefenced(selRows);
                break;
            }
            case "newsubentry": {
                DynamicObjectCollection splitEntry = this.getModel().getEntryEntity("splitentry");
                int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("splitentry");
                if (splitEntry.size() != 0 && entryCurrentRowIndex >= 0) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e00\u4e2a\u9879\u76ee\u62c6\u5206\u8bbe\u7f6e\u884c\u3002", (String)"ProjectInitializeBillPlugin_49", (String)"pmgt-pmfs-formplugin", (Object[])new Object[0]));
                break;
            }
            case "addsubordinate": {
                EntryGrid entryGrid = (EntryGrid)this.getView().getControl("splitentry");
                int[] selRows = entryGrid.getSelectRows();
                if (selRows.length >= 1) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"ProjectInitializeBillPlugin_31", (String)"pmgt-pmfs-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                break;
            }
        }
    }

    private boolean checkProStageRow(int[] selRows) {
        DynamicObjectCollection splitEntry = this.getModel().getEntryEntity("splitentry");
        HashSet<String> errorMsg = new HashSet<String>();
        for (int row : selRows) {
            DynamicObject entry = (DynamicObject)splitEntry.get(row);
            DynamicObject proStage = entry.getDynamicObject("splitentry_projectstatus");
            if (proStage == null) continue;
            errorMsg.add(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u8282\u70b9\u4e3a\u9879\u76ee\u9636\u6bb5\u6570\u636e\uff0c\u4e0d\u53ef\u5220\u9664\u3002", (String)"ProjectInitializeBillPlugin_50", (String)"pmgt-pmfs-formplugin", (Object[])new Object[0]), entry.getString("splitentry_wbsnumber")));
        }
        if (!CollectionUtils.isEmpty(errorMsg)) {
            StringBuilder sb = new StringBuilder();
            for (String msg : errorMsg) {
                sb.append(msg);
                sb.append("\n");
            }
            this.getView().showTipNotification(sb.toString());
            return true;
        }
        return false;
    }

    protected void updateHeadAmount(int[] selRows) {
        BigDecimal totalAmount = (BigDecimal)this.getModel().getValue("estamount");
        for (int i : selRows) {
            DynamicObject entry = this.getModel().getEntryRowEntity("splitentry", i);
            totalAmount = totalAmount.subtract(entry.getBigDecimal("splitentry_amount"));
        }
        this.getModel().setValue("estamount", (Object)totalAmount);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        switch (operateKey = args.getOperateKey()) {
            case "levelup": {
                this.upgradeRow(this.getView(), this.getModel());
                break;
            }
            case "leveldown": {
                this.downgradeRow(this.getView(), this.getModel());
                break;
            }
            case "importexcel": {
                this.importTaskOperation();
                break;
            }
            case "exportexcel": {
                ProjectInitializeHelper.getInstance().exportModelEntry2Task(this.getView(), this.getModel().getDataEntity(true));
                break;
            }
            case "newentry": {
                this.handleNewEntryRowData();
                break;
            }
            case "addsubordinate": {
                DynamicObject model = this.getModel().getDataEntity(true);
                EntryGrid entryGrid = (EntryGrid)this.getView().getControl("splitentry");
                int[] selRows = entryGrid.getSelectRows();
                DynamicObjectCollection splitEntry = model.getDynamicObjectCollection("splitentry");
                DynamicObject newEntry = new DynamicObject(splitEntry.getDynamicObjectType());
                Long newEntryId = ProjectInitializeHelper.getInstance().createID(newEntry.getDynamicObjectType());
                newEntry.set("id", (Object)newEntryId);
                newEntry.set("resourcewbsid", (Object)String.valueOf(newEntryId));
                int currentIndex = selRows[0];
                DynamicObject currentEntry = (DynamicObject)splitEntry.get(currentIndex);
                newEntry.set("pid", currentEntry.getPkValue());
                int maxRow = this.getMaxRowsByPid(currentEntry.getPkValue(), splitEntry);
                splitEntry.add(maxRow == 0 ? currentIndex + 1 : maxRow + 1, newEntry);
                this.refreshCollectionLevel(splitEntry);
                this.getModel().updateCache();
                entryGrid.setCollapse(false);
                this.getView().updateView("splitentry");
                break;
            }
            case "deletesubentry": {
                int curSplitEntryRow = Integer.parseInt(this.getPageCache().get(CUR_SPLIT_ENTRY_ROW));
                this.culSplitEntryCount(curSplitEntryRow);
                String splitMethod = (String)this.getModel().getValue("splitmethod");
                if (!SplitMethodEnum.BY_COUNT.getValue().equals(splitMethod)) break;
                this.culSubSplitEntryPercentage(curSplitEntryRow);
                break;
            }
            case "importsubexcel": {
                FormShowParameter importExcelFormParameter = new FormShowParameter();
                importExcelFormParameter.setFormId("pmfs_proinitsubentryimp");
                importExcelFormParameter.setCustomParam(CUR_SPLIT_ENTRY_ROW, (Object)this.getPageCache().get(CUR_SPLIT_ENTRY_ROW));
                importExcelFormParameter.getOpenStyle().setShowType(ShowType.Modal);
                importExcelFormParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALL_BACK_IMPORT_SUB_EXCEL));
                this.getView().showForm(importExcelFormParameter);
                break;
            }
            case "exportsubexcel": {
                ProjectInitializeSubEntryExcelSupport projectInitializeSubEntryExcelSupport = new ProjectInitializeSubEntryExcelSupport();
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("parentpageid", this.getView().getPageId());
                params.put("isExportData", true);
                params.put("entitynumber", "pmfs_projectinitialize");
                params.put("entryKey", "subsplitentry");
                String url = projectInitializeSubEntryExcelSupport.executeExportTask(params);
                this.getView().download(url);
                break;
            }
        }
    }

    public void upgradeRow(IFormView view, IDataModel model) {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("splitentry");
        int[] selRows = entryGrid.getSelectRows();
        if (selRows.length <= 0) {
            view.showMessage(ResManager.loadKDStringExt((String)"\u8bf7\u5148\u9009\u4e2d\u884c", (String)"ProjectInitializeBillPlugin_1", (String)"pmgt-pmfs-formplugin", (Object[])new Object[0]));
        } else {
            DynamicObjectCollection splitEntries = model.getEntryEntity("splitentry");
            StringBuilder sb = new StringBuilder();
            Long oldParentEntryId = 0L;
            ArrayList<Integer> finalSelRows = new ArrayList<Integer>(10);
            for (int selRow : selRows) {
                DynamicObject currentEntry = (DynamicObject)splitEntries.get(selRow);
                oldParentEntryId = currentEntry.getLong("pid");
                if (oldParentEntryId == 0L) {
                    sb.append(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u4e3a\u6839\u8282\u70b9\uff0c\u65e0\u6cd5\u5347\u7ea7\u3002", (String)"ProjectInitializeBillPlugin_51", (String)"pmgt-pmfs-formplugin", (Object[])new Object[0]), currentEntry.getString("splitentry_wbsnumber")));
                    sb.append("\n");
                    continue;
                }
                finalSelRows.add(selRow);
                int preIndex = selRow - 1;
                while (!oldParentEntryId.equals(((DynamicObject)splitEntries.get(preIndex)).getLong("id"))) {
                    --preIndex;
                }
                DynamicObject parentEntry = (DynamicObject)splitEntries.get(preIndex);
                Long newParentEntryID = parentEntry.getLong("pid");
                currentEntry.set("pid", (Object)newParentEntryID);
            }
            Object object = finalSelRows.iterator();
            while (object.hasNext()) {
                int selRow = (Integer)object.next();
                this.refreshCollectionLevel(selRow, oldParentEntryId, splitEntries);
            }
            this.refreshCollectionLevel(splitEntries);
            model.updateCache();
            entryGrid.setCollapse(false);
            view.updateView("splitentry");
            if (StringUtils.isNotEmpty((CharSequence)sb.toString())) {
                view.showTipNotification(sb.toString());
            }
        }
    }

    public void downgradeRow(IFormView view, IDataModel model) {
        EntryGrid entryGrid = (EntryGrid)view.getControl("splitentry");
        int[] selRows = entryGrid.getSelectRows();
        if (selRows.length <= 0) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u4e2d\u884c", (String)"ProjectInitializeBillPlugin_1", (String)"pmgt-pmfs-formplugin", (Object[])new Object[0]));
        } else {
            DynamicObjectCollection splitEntries = model.getEntryEntity("splitentry");
            for (int selRow : selRows) {
                DynamicObject splitEntry = (DynamicObject)splitEntries.get(selRow);
                Long parentId = splitEntry.getLong("pid");
                DynamicObject proStage = splitEntry.getDynamicObject("splitentry_projectstatus");
                if (proStage != null) {
                    view.showTipNotification(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u8282\u70b9\u4e3a\u9879\u76ee\u9636\u6bb5\u6570\u636e\uff0c\u4e0d\u53ef\u964d\u7ea7\u3002", (String)"ProjectInitializeBillPlugin_52", (String)"pmgt-pmfs-formplugin", (Object[])new Object[0]), splitEntry.getString("splitentry_wbsnumber")));
                    continue;
                }
                if (selRow == 0) {
                    view.showTipNotification(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u4e3a\u672c\u7ea7\u8282\u70b9\u7684\u9996\u4e2a\u8282\u70b9\uff0c\u4e0d\u53ef\u964d\u7ea7\u3002", (String)"ProjectInitializeBillPlugin_53", (String)"pmgt-pmfs-formplugin", (Object[])new Object[0]), splitEntry.getString("splitentry_wbsnumber")));
                    continue;
                }
                DynamicObject preEntry = (DynamicObject)splitEntries.get(selRow - 1);
                Long preEntryId = preEntry.getLong("id");
                if (parentId.equals(preEntryId)) {
                    view.showTipNotification(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u8282\u70b9\u4e3a\u672c\u7ea7\u8282\u70b9\u7684\u9996\u4e2a\u8282\u70b9\uff0c\u4e0d\u53ef\u964d\u7ea7\u3002", (String)"ProjectInitializeBillPlugin_54", (String)"pmgt-pmfs-formplugin", (Object[])new Object[0]), splitEntry.getString("splitentry_wbsnumber")));
                    continue;
                }
                int currentLevel = splitEntry.getInt("level");
                int preIndex = selRow - 1;
                while (currentLevel != preEntry.getInt("level")) {
                    preEntry = (DynamicObject)splitEntries.get(--preIndex);
                    if (preIndex != -1) continue;
                }
                preEntry = (DynamicObject)splitEntries.get(preIndex);
                preEntryId = preEntry.getLong("id");
                splitEntry.set("pid", (Object)preEntryId);
                splitEntry.set("level", (Object)(currentLevel + 1));
            }
            this.refreshCollectionLevel(splitEntries);
            model.updateCache();
            entryGrid.setCollapse(false);
            view.updateView("splitentry");
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId;
        super.closedCallBack(evt);
        switch (actionId = evt.getActionId()) {
            case "pmfs_projectinitexcelimp": {
                if (null == evt.getReturnData()) break;
                JSONArray jasonArray = JSONArray.parseArray((String)evt.getReturnData().toString());
                ProjectInitializeHelper.getInstance().importTask2ModelEntry(this.getModel(), this.getView(), jasonArray);
                boolean splitByCount = (Boolean)this.getModel().getValue("splitbycount");
                String splitDimension = (String)this.getModel().getValue("splitdimension");
                if (!splitByCount || !SplitDimensionEnum.BY_MONTH.getValue().equals(splitDimension)) break;
                DynamicObjectCollection splitEntry = this.getModel().getEntryEntity("splitentry");
                for (int index = 0; index < splitEntry.size(); ++index) {
                    Date planStartTime = (Date)this.getModel().getValue("splitentry_planstarttime", index);
                    Date planEndTime = (Date)this.getModel().getValue("splitentry_planendtime", index);
                    if (planStartTime == null || planEndTime == null) continue;
                    this.initSubEntry(index, planStartTime, planEndTime);
                }
                break;
            }
            case "callBackImportExcel": {
                if (null == evt.getReturnData()) break;
                this.subExcelCloseCallBack(String.valueOf(evt.getReturnData()));
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f\u3002", (String)"ProjectInitializeBillPlugin_36", (String)"pmgt-pmfs-formplugin", (Object[])new Object[0]));
                break;
            }
        }
    }

    protected void subExcelCloseCallBack(String returnData) {
        if (null != returnData) {
            DynamicObjectCollection entries = this.getModel().getEntryEntity("splitentry");
            for (DynamicObject entry : entries) {
                DynamicObjectCollection subEntries = entry.getDynamicObjectCollection("subsplitentry");
                subEntries.clear();
            }
            DynamicObjectType subEntryDt = ((DynamicObject)entries.get(0)).getDynamicObjectCollection("subsplitentry").getDynamicObjectType();
            Object[] customObjectEntries = DynamicObjectSerializeUtil.deserialize((String)returnData, (DynamicObjectType)subEntryDt);
            List importEntities = Arrays.stream(customObjectEntries).map(item -> (DynamicObject)item).collect(Collectors.toList());
            for (DynamicObject importSubEntry : importEntities) {
                for (DynamicObject entry : entries) {
                    if (!importSubEntry.getString("subwbsnumber").equals(entry.getString("splitentry_wbsnumber"))) continue;
                    DynamicObjectCollection subEntries = entry.getDynamicObjectCollection("subsplitentry");
                    DynamicObject newSubEntry = subEntries.addNew();
                    newSubEntry.set("subdate", importSubEntry.get("subdate"));
                    newSubEntry.set("subcount", importSubEntry.get("subcount"));
                    newSubEntry.set("subpercentage", importSubEntry.get("subpercentage"));
                    newSubEntry.set("subwbsnumber", importSubEntry.get("subwbsnumber"));
                    newSubEntry.set("subwbsname", entry.get("splitentry_wbsname"));
                    newSubEntry.set("subremark", importSubEntry.get("subremark"));
                }
            }
            for (int rowIndex = 0; rowIndex < entries.size(); ++rowIndex) {
                DynamicObjectCollection subEntries = ((DynamicObject)entries.get(rowIndex)).getDynamicObjectCollection("subsplitentry");
                String splitMethod = (String)this.getModel().getValue("splitmethod");
                if (SplitMethodEnum.BY_COUNT.getValue().equals(splitMethod)) {
                    this.culSplitEntryCount(rowIndex);
                    this.culSubSplitEntryPercentage(rowIndex);
                    continue;
                }
                if (!SplitMethodEnum.BY_PERCENTAGE.getValue().equals(splitMethod)) continue;
                this.culSubSplitEntryCount(rowIndex);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        String actionId;
        super.confirmCallBack(evt);
        switch (actionId = evt.getCallBackId()) {
            case "pmfs_projectinitexcelimp": {
                if (!MessageBoxResult.Yes.equals((Object)evt.getResult())) break;
                this.showImportExcelForm();
                break;
            }
            case "timetype": {
                if (MessageBoxResult.Yes.equals((Object)evt.getResult())) {
                    this.getModel().deleteEntryData("splitentry");
                    this.getModel().deleteEntryData("subsplitentry");
                    this.changeEntryDateMaskByTimeType();
                    this.changeSplitDimensionComboItemByTimeType();
                    this.changeSplitDimensionValueByTimeType();
                    break;
                }
                this.getModel().beginInit();
                this.getModel().setValue("timetype", (Object)this.getPageCache().get("timetype"));
                this.getModel().endInit();
                this.getView().updateView();
                break;
            }
            case "splitmethod": {
                if (MessageBoxResult.Yes.equals((Object)evt.getResult())) {
                    this.clearSubSplitEntry();
                    break;
                }
                String splitMethod = this.getPageCache().get("splitmethod");
                this.getModel().beginInit();
                this.getModel().setValue("splitmethod", (Object)splitMethod);
                this.getModel().endInit();
                this.getView().updateView("splitmethod");
                break;
            }
            case "splitdimension": {
                if (MessageBoxResult.Yes.equals((Object)evt.getResult())) {
                    this.changeSubEntryDateMaskBySplitDimension();
                    this.clearSubSplitEntry();
                    break;
                }
                String splitDimension = this.getPageCache().get("splitdimension");
                this.getModel().beginInit();
                this.getModel().setValue("splitdimension", (Object)splitDimension);
                this.getModel().endInit();
                this.getView().updateView("splitdimension");
                break;
            }
            case "splitbycount": {
                if (MessageBoxResult.Yes.equals((Object)evt.getResult())) {
                    this.clearSubSplitEntry();
                    break;
                }
                this.getModel().setValue("splitbycount", (Object)true);
                break;
            }
            case "splitentry_wbsnumber": {
                if (MessageBoxResult.Yes.equals((Object)evt.getResult())) break;
                this.getModel().beginInit();
                this.getModel().setValue("splitentry_wbsnumber", null);
                this.getModel().endInit();
                this.getView().updateView("splitentry_wbsnumber", Integer.parseInt(this.getPageCache().get(CUR_SPLIT_ENTRY_ROW)));
                break;
            }
            case "project": {
                if (MessageBoxResult.Yes.equals((Object)evt.getResult())) {
                    this.getModel().deleteEntryData("splitentry");
                    break;
                }
                this.getModel().beginInit();
                this.getModel().setValue("project", (Object)this.getPageCache().get(OLD_PROJECT));
                this.getModel().endInit();
                this.getView().updateView("project");
                break;
            }
        }
    }

    protected void handleNewEntryRowData() {
        DynamicObject model = this.getModel().getDataEntity(true);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("splitentry");
        int[] selRows = entryGrid.getSelectRows();
        DynamicObjectCollection splitEntry = model.getDynamicObjectCollection("splitentry");
        DynamicObject newEntry = new DynamicObject(splitEntry.getDynamicObjectType());
        Long newEntryId = ProjectInitializeHelper.getInstance().createID(newEntry.getDynamicObjectType());
        newEntry.set("id", (Object)newEntryId);
        newEntry.set("resourcewbsid", (Object)String.valueOf(newEntryId));
        splitEntry.add(splitEntry.size(), newEntry);
        this.refreshCollectionLevel(splitEntry);
        this.getModel().updateCache();
        entryGrid.setCollapse(false);
        this.getView().updateView("splitentry");
        if (selRows.length > 0) {
            entryGrid.selectRows(selRows[0]);
        }
    }

    protected int getMaxRowsByPid(Object pkValue, DynamicObjectCollection splitEntry) {
        int maxRow = 0;
        for (int i = 0; i < splitEntry.size(); ++i) {
            if (((DynamicObject)splitEntry.get(i)).getLong("pid") != ((Long)pkValue).longValue() || i <= maxRow) continue;
            maxRow = i;
        }
        return maxRow;
    }

    protected void fillReviseModel(DynamicObject resourceModel) {
        this.getModel().setValue("resourceprojectinitid", resourceModel.getPkValue());
        this.getModel().setValue("project", resourceModel.get("project"));
        this.getModel().setValue("projectkind", resourceModel.get("projectkind"));
        this.getModel().setValue("org", resourceModel.get("org"));
        this.getModel().setValue("version", (Object)(resourceModel.getInt("version") + 1));
        this.getModel().setValue("estamount", resourceModel.get("estamount"));
        this.getModel().setValue("currency", resourceModel.get("currency"));
        this.getModel().setValue("timetype", resourceModel.get("timetype"));
        this.getModel().setValue("description", resourceModel.get("description"));
        this.getModel().setValue("executiveversion", (Object)false);
        this.getModel().setValue("splitbycount", resourceModel.get("splitbycount"));
        this.getModel().beginInit();
        this.getModel().setValue("splitdimension", resourceModel.get("splitdimension"));
        this.getModel().setValue("splitmethod", resourceModel.get("splitmethod"));
        this.getModel().endInit();
        DynamicObjectCollection resourceSplitEntry = resourceModel.getDynamicObjectCollection("splitentry");
        DynamicObjectCollection splitEntry = this.getModel().getEntryEntity("splitentry");
        splitEntry.clear();
        HashMap<Long, Long> newIdMapping = new HashMap<Long, Long>(10);
        HashMap<Long, Long> newIdOldParentMapping = new HashMap<Long, Long>(10);
        for (DynamicObject resourceEntry : resourceSplitEntry) {
            Long newId = ProjectInitializeHelper.getInstance().createID(resourceEntry.getDynamicObjectType());
            newIdMapping.put(resourceEntry.getLong("id"), newId);
            newIdOldParentMapping.put(newId, resourceEntry.getLong("pid"));
            DynamicObject entry = splitEntry.addNew();
            entry.set("id", (Object)newId);
            this.fillReviseEntryModel(entry, resourceEntry);
        }
        for (DynamicObject entry : splitEntry) {
            Long oldParentId = (Long)newIdOldParentMapping.get(Long.valueOf(entry.getPkValue().toString()));
            if (oldParentId == null) continue;
            entry.set("pid", newIdMapping.get(oldParentId));
        }
        TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getView().getControl("splitentry");
        treeEntryGrid.setCollapse(false);
        FileAttachmentHelper.copyFileFromAToB((String)resourceModel.getDynamicObjectType().toString(), (Object)resourceModel.getPkValue(), (String)ATTACHMENTPANEL, (String)this.getView().getEntityId(), (Object)this.getModel().getDataEntity().getPkValue(), (String)ATTACHMENTPANEL);
    }

    protected void fillReviseEntryModel(DynamicObject newEntry, DynamicObject resourceEntry) {
        newEntry.set("level", resourceEntry.get("level"));
        newEntry.set("isleaf", resourceEntry.get("isleaf"));
        long resourceWbsId = resourceEntry.getLong("resourcewbsid");
        if (resourceWbsId == 0L) {
            newEntry.set("resourcewbsid", resourceEntry.getPkValue());
        } else {
            newEntry.set("resourcewbsid", (Object)resourceWbsId);
        }
        newEntry.set("splitentry_wbsnumber", resourceEntry.get("splitentry_wbsnumber"));
        newEntry.set("splitentry_wbsname", resourceEntry.get("splitentry_wbsname"));
        newEntry.set("splitentry_projectstatus", resourceEntry.get("splitentry_projectstatus"));
        newEntry.set("splitentry_type", resourceEntry.get("splitentry_type"));
        newEntry.set("splitentry_milestone", resourceEntry.get("splitentry_milestone"));
        newEntry.set("splitentry_planstarttime", resourceEntry.get("splitentry_planstarttime"));
        newEntry.set("splitentry_planendtime", resourceEntry.get("splitentry_planendtime"));
        newEntry.set("splitentry_qty", resourceEntry.get("splitentry_qty"));
        newEntry.set("splitentry_unit", resourceEntry.get("splitentry_unit"));
        newEntry.set("splitentry_price", resourceEntry.get("splitentry_price"));
        newEntry.set("splitentry_amount", resourceEntry.get("splitentry_amount"));
        newEntry.set("splitentry_remark", resourceEntry.get("splitentry_remark"));
        newEntry.set("splitentry_schedule", resourceEntry.get("splitentry_schedule"));
        newEntry.set("splitentry_completeamt", resourceEntry.get("splitentry_completeamt"));
        DynamicObjectCollection newSubSplitEntry = newEntry.getDynamicObjectCollection("subsplitentry");
        for (DynamicObject resourceSubWbs : resourceEntry.getDynamicObjectCollection("subsplitentry")) {
            DynamicObject newSubWbs = newSubSplitEntry.addNew();
            newSubWbs.set("subdate", resourceSubWbs.get("subdate"));
            newSubWbs.set("subcount", resourceSubWbs.get("subcount"));
            newSubWbs.set("subpercentage", resourceSubWbs.get("subpercentage"));
            newSubWbs.set("subwbsnumber", resourceSubWbs.get("subwbsnumber"));
            newSubWbs.set("subwbsname", resourceSubWbs.get("subwbsname"));
            newSubWbs.set("subremark", resourceSubWbs.get("subremark"));
        }
    }

    protected void showImportExcelForm() {
        FormShowParameter importExcelFormParameter = new FormShowParameter();
        importExcelFormParameter.setFormId(PMFS_PROJECTINITEXCELIMP);
        importExcelFormParameter.getOpenStyle().setShowType(ShowType.Modal);
        importExcelFormParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, PMFS_PROJECTINITEXCELIMP));
        this.getView().showForm(importExcelFormParameter);
    }

    protected void refreshCollectionLevel(int rowIndex, long oldParentEntryId, DynamicObjectCollection splitEntries) {
        int oldParentIndex = 0;
        DynamicObject currentRow = (DynamicObject)splitEntries.get(rowIndex);
        DynamicObjectCollection childChildren = new DynamicObjectCollection();
        DynamicObjectCollection parentChildren = new DynamicObjectCollection();
        this.getAllChildren(childChildren, currentRow, splitEntries);
        splitEntries.remove((Object)currentRow);
        splitEntries.removeAll((Collection)childChildren);
        for (int i = 0; i < splitEntries.size(); ++i) {
            DynamicObject wbsEntry = (DynamicObject)splitEntries.get(i);
            if (wbsEntry.getLong("id") != oldParentEntryId) continue;
            oldParentIndex = i;
            break;
        }
        this.getAllChildren(parentChildren, (DynamicObject)splitEntries.get(oldParentIndex), splitEntries);
        int newIndex = 0;
        int newChildIndex = 0;
        newIndex = oldParentIndex == splitEntries.size() ? oldParentIndex : oldParentIndex + parentChildren.size() + 1;
        newChildIndex = newIndex + 1;
        splitEntries.add(newIndex, currentRow);
        if (!childChildren.isEmpty()) {
            splitEntries.addAll(newChildIndex, (Collection)childChildren);
        }
    }

    protected void getAllChildren(DynamicObjectCollection children, DynamicObject parentObject, DynamicObjectCollection entities) {
        if (parentObject == null || parentObject.getLong("id") == 0L) {
            return;
        }
        for (DynamicObject entity : entities) {
            if (parentObject.getLong("id") != entity.getLong("pid")) continue;
            children.add((Object)entity);
            this.getAllChildren(children, entity, entities);
        }
    }

    protected void refreshCollectionLevel(DynamicObjectCollection splitEntries) {
        HashMap<Long, DynamicObject> data = new HashMap<Long, DynamicObject>(splitEntries.size());
        int index = 1;
        for (DynamicObject entry : splitEntries) {
            Long parentEntryID = entry.getLong("pid");
            if (data.get(parentEntryID) != null) {
                entry.set("level", (Object)(((DynamicObject)data.get(parentEntryID)).getInt("level") + 1));
                ((DynamicObject)data.get(parentEntryID)).set("isleaf", (Object)Boolean.FALSE);
            } else {
                entry.set("level", (Object)1);
                entry.set("isleaf", (Object)Boolean.TRUE);
            }
            entry.set("seq", (Object)index);
            data.put(entry.getLong("id"), entry);
            ++index;
        }
    }

    protected void checkWBSIsRefenced(int[] selRows) {
        DynamicObjectCollection splitEntry = this.getModel().getEntryEntity("splitentry");
        HashSet<String> errorMsg = new HashSet<String>();
        for (int row : selRows) {
            DynamicObject entry = (DynamicObject)splitEntry.get(row);
            long wbsId = entry.getLong("resourcewbsid");
            if (wbsId == 0L || !ProjectInitializeHelper.getInstance().checkWBSIsRefenced(Long.valueOf(wbsId))) continue;
            errorMsg.add(entry.getString("splitentry_wbsnumber"));
        }
        if (!CollectionUtils.isEmpty(errorMsg)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"WBS\u7f16\u53f7\u201c%s\u201d\u5df2\u5f15\u7528\uff0c\u4e0d\u53ef\u5220\u9664\u3002", (String)"ProjectInitializeBillPlugin_55", (String)"pmgt-pmfs-formplugin", (Object[])new Object[0]), String.join((CharSequence)",", errorMsg.toArray(new String[0]))));
        }
    }

    protected void importTaskOperation() {
        int size = this.getModel().getEntryRowCount("splitentry");
        if (size == 0) {
            this.showImportExcelForm();
        } else {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5bfc\u5165\u9879\u76ee\u62c6\u5206\u8bbe\u7f6e\u5c06\u6e05\u7a7a\u73b0\u6709\u8bbe\u7f6e\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"ProjectInitializeBillPlugin_56", (String)"pmgt-pmfs-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(PMFS_PROJECTINITEXCELIMP, (IFormPlugin)this));
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        Control control = (Control)evt.getSource();
        if (StringUtils.equals((CharSequence)"splitentry", (CharSequence)control.getKey())) {
            int curSplitEntryRow = evt.getRow() == -1 ? 0 : evt.getRow();
            this.getPageCache().put(CUR_SPLIT_ENTRY_ROW, String.valueOf(curSplitEntryRow));
        }
    }
}

