/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmfs.formplugin.initialize;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.pmgt.pmbs.common.enums.projectinitialize.SplitDimensionEnum;
import kd.pmgt.pmbs.common.utils.DateUtil;
import kd.pmgt.pmfs.business.manage.ProjectInitializeSubEntryExcelSupport;
import kd.pmgt.pmfs.formplugin.base.AbstractPmfsFormPlugin;

public class ProjectInitializeSubEntryImport
extends AbstractPmfsFormPlugin
implements UploadListener {
    private static final String KEY_ATTACHMENTPANEL = "attachmentpanel";
    private static final String OPERATION_DOWNLOAD_TEMPLATE = "downloadtemplate";
    private static final String OPERATION_CONFIRM = "confirm";
    private static final String PAGE_CACHE_UPLOAD_FILE_URL = "uploadfileurl";
    private ProjectInitializeSubEntryExcelSupport excelSupport = new ProjectInitializeSubEntryExcelSupport();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getView().getControl(KEY_ATTACHMENTPANEL);
        attachmentPanel.addUploadListener((UploadListener)this);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "downloadtemplate": {
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("isExportData", false);
                params.put("entryKey", "subsplitentry");
                params.put("entitynumber", this.getView().getParentView().getEntityId());
                params.put("parentpageid", this.getView().getParentView().getPageId());
                String url = this.excelSupport.executeExportTask(params);
                this.getView().download(url);
                break;
            }
            case "confirm": {
                HashMap<String, Object> params = new HashMap<String, Object>();
                String url = this.getPageCache().get(PAGE_CACHE_UPLOAD_FILE_URL);
                params.put("url", url);
                params.put("entryKey", "subsplitentry");
                params.put("entitynumber", this.getView().getParentView().getEntityId());
                params.put("parentpageid", this.getView().getParentView().getPageId());
                params.put("appId", this.getView().getParentView().getEntityId());
                params.put("pageid", this.getView().getPageId());
                params.put("curListRow", this.getView().getFormShowParameter().getCustomParam("curListRow"));
                DynamicObjectCollection importDataList = this.excelSupport.executeImportTask(params);
                if (importDataList == null) {
                    this.getView().showErrorNotification(ResManager.loadKDStringExt((String)"\u5bfc\u5165\u6570\u636e\u6709\u8bef\uff0c\u8bf7\u4fee\u6539\u6570\u636e\u540e\u91cd\u65b0\u5bfc\u5165\u3002", (String)"ProjectInitializeSubEntryImport_6", (String)"pmgt-pmfs-formplugin", (Object[])new Object[0]));
                    return;
                }
                HashMap<Object, Integer> wbsNumberCount = new HashMap<Object, Integer>(16);
                DynamicObjectCollection entrys = this.getView().getParentView().getModel().getEntryEntity("splitentry");
                for (DynamicObject entry : entrys) {
                    String wbsNumber = entry.getString("splitentry_wbsnumber");
                    Integer count = (Integer)wbsNumberCount.get(wbsNumber);
                    if (count == null) {
                        wbsNumberCount.put(wbsNumber, 1);
                        continue;
                    }
                    wbsNumberCount.put(wbsNumber, count + 1);
                }
                StringBuilder errorMsg = new StringBuilder();
                int index = 5;
                for (DynamicObject subEntry : importDataList) {
                    String subWbsNumber = subEntry.getString("subwbsnumber");
                    Integer count = (Integer)wbsNumberCount.get(subWbsNumber);
                    if (count == null) {
                        errorMsg.append(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c&%2$s\uff1a\u627e\u4e0d\u5230WBS\u7f16\u7801\uff0c\u8bf7\u68c0\u67e5\u9879\u76ee\u62c6\u5206\u8bbe\u7f6e\u4e2d\u7684WBS\u7f16\u7801\u662f\u5426\u5b58\u5728\u3002", (String)"ProjectInitializeSubEntryImport_3", (String)"pmgt-pmfs-formplugin", (Object[])new Object[0]), index, subWbsNumber));
                        errorMsg.append("\r\n");
                    } else if (count > 1) {
                        errorMsg.append(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c&%2$s\uff1a\u627e\u4e0d\u5230WBS\u7f16\u7801\uff0c\u8bf7\u68c0\u67e5\u9879\u76ee\u62c6\u5206\u8bbe\u7f6e\u4e2d\u7684WBS\u7f16\u7801\u662f\u5426\u5b58\u5728\u3002", (String)"ProjectInitializeSubEntryImport_3", (String)"pmgt-pmfs-formplugin", (Object[])new Object[0]), index, subWbsNumber));
                        errorMsg.append("\r\n");
                    }
                    ++index;
                }
                if (errorMsg.length() > 0) {
                    this.getView().showErrorNotification(errorMsg.toString());
                    return;
                }
                String splitDimension = this.getView().getParentView().getModel().getDataEntity().getString("splitdimension");
                HashMap wbsNumberDate = new HashMap(16);
                index = 5;
                for (DynamicObject subEntry : importDataList) {
                    String subWbsNumber = subEntry.getString("subwbsnumber");
                    Date subDate = subEntry.getDate("subdate");
                    ArrayList<Date> subDates = (ArrayList<Date>)wbsNumberDate.get(subWbsNumber);
                    if (subDates == null) {
                        subDates = new ArrayList<Date>(10);
                        wbsNumberDate.put(subWbsNumber, subDates);
                    } else {
                        for (Date date : subDates) {
                            if (!(SplitDimensionEnum.BY_MONTH.getValue().equals(splitDimension) && DateUtil.compareByMonth((Date)date, (Date)subDate) == 0 || SplitDimensionEnum.BY_DAY.getValue().equals(splitDimension) && DateUtil.compareByDay((Date)date, (Date)subDate) == 0) && (!SplitDimensionEnum.BY_HOUR.getValue().equals(splitDimension) || DateUtil.compareByHour((Date)date, (Date)subDate) != 0)) continue;
                            errorMsg.append(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c&%2$s\uff1a\u540c\u4e00\u4e2aWBS\u7f16\u7801\uff0c\u5bfc\u5165\u671f\u95f4\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ProjectInitializeSubEntryImport_7", (String)"pmgt-pmfs-formplugin", (Object[])new Object[0]), index, subWbsNumber));
                            errorMsg.append("\r\n");
                            break;
                        }
                    }
                    subDates.add(subDate);
                    ++index;
                }
                if (errorMsg.length() > 0) {
                    this.getView().showErrorNotification(errorMsg.toString());
                    return;
                }
                DynamicObjectType subEntryDt = ((DynamicObject)entrys.get(0)).getDynamicObjectCollection("subsplitentry").getDynamicObjectType();
                String returnData = DynamicObjectSerializeUtil.serialize((Object[])importDataList.toArray(), (DynamicObjectType)subEntryDt);
                this.getView().returnDataToParent((Object)returnData);
                this.getView().invokeOperation("close");
                break;
            }
        }
    }

    public void upload(UploadEvent evt) {
        Object[] urls = evt.getUrls();
        if (urls != null && urls.length == 1) {
            String url = (String)((Map)urls[0]).get("url");
            this.getPageCache().put(PAGE_CACHE_UPLOAD_FILE_URL, url);
        }
    }
}

