/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmfs.formplugin.process;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pmgt.pmfs.formplugin.base.AbstractPmfsBillPlugin;

public class ProjectProcessDocBillPlugin
extends AbstractPmfsBillPlugin
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.registerAttachTypeF7();
        this.registerProjectF7();
    }

    private void registerProjectF7() {
        BasedataEdit projectEdit = (BasedataEdit)this.getView().getControl("project");
        projectEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        projectEdit.closedCallBack(new ClosedCallBackEvent((Object)this, "project", null));
    }

    protected void registerAttachTypeF7() {
        BasedataEdit attachTypeEdit = (BasedataEdit)this.getView().getControl("attachtype");
        attachTypeEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterBindData(EventObject e) {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject attachType = dataEntity.getDynamicObject("attachtype");
        if (attachType == null) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"attachmentinfo"});
        } else {
            DynamicObjectCollection attachments = dataEntity.getDynamicObjectCollection("attachment");
            if (attachments.size() > 0) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"attachmentinfo"});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"attachmentinfo"});
            }
        }
        super.afterBindData(e);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String fieldKey;
        super.beforeF7Select(evt);
        BasedataEdit basedataEdit = (BasedataEdit)evt.getSource();
        switch (fieldKey = basedataEdit.getFieldKey()) {
            case "attachtype": {
                this.filterAttachType(evt);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        super.closedCallBack(closedCallBackEvent);
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "attachtype": {
                ListSelectedRowCollection selRows = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
                if (selRows == null) break;
                ListSelectedRow selRow = selRows.get(0);
                String attachTypeId = selRow.getPrimaryKeyValue().toString();
                this.handleAttachment(attachTypeId);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData changeData = e.getChangeSet()[0];
        String name = e.getProperty().getName();
        Object newValue = changeData.getNewValue();
        Object oldValue = changeData.getOldValue();
        if ("attachtype".equals(name)) {
            if (newValue == null) {
                this.getModel().setValue("attachment", null);
                this.getView().setVisible(Boolean.FALSE, new String[]{"attachmentinfo"});
            } else {
                DynamicObject attachType = (DynamicObject)newValue;
                this.handleAttachment(attachType.getPkValue().toString());
            }
        } else if (StringUtils.equals((CharSequence)name, (CharSequence)"project")) {
            String flag = this.getView().getPageCache().get("project");
            this.getView().getPageCache().remove("project");
            if (null != this.getModel().getValue("attachtype") && StringUtils.isEmpty((CharSequence)flag)) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u91cd\u65b0\u9009\u62e9\u9879\u76ee\uff0c\u5c06\u6e05\u9664\u6587\u4ef6\u7c7b\u578b\u6570\u636e\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"ProjectProcessDocBillPlugin_4", (String)"pmgt-pmfs-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("project", (IFormPlugin)this));
                if (oldValue != null) {
                    DynamicObject project = (DynamicObject)oldValue;
                    this.getView().getPageCache().put("project", project.getPkValue().toString());
                }
            }
        }
    }

    private void handleAttachment(String attachTypeId) {
        DynamicObject attachType = BusinessDataServiceHelper.loadSingle((Object)attachTypeId, (String)"pmbs_attachtype");
        this.getModel().setValue("attachtype", (Object)attachType);
        DynamicObjectCollection attachments = attachType.getDynamicObjectCollection("attachmentfield");
        ArrayList attachIdSet = new ArrayList();
        if (attachments != null && attachments.size() > 0) {
            attachments.forEach(attach -> attachIdSet.add(attach.getLong("fbasedataid_id")));
            this.getModel().setValue("attachment", (Object)attachIdSet.toArray());
            this.getView().setVisible(Boolean.TRUE, new String[]{"attachmentinfo"});
        } else {
            this.getModel().setValue("attachment", null);
            this.getView().setVisible(Boolean.FALSE, new String[]{"attachmentinfo"});
        }
    }

    protected void filterProject(BeforeF7SelectEvent evt) {
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "project"));
    }

    protected void filterAttachType(BeforeF7SelectEvent evt) {
        DynamicObjectCollection fileTypeEntries;
        QFilter projectKindFilter;
        DynamicObject setting;
        DynamicObject model = this.getModel().getDataEntity();
        if (null == model.get("project")) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9879\u76ee\uff0c\u518d\u9009\u62e9\u6587\u4ef6\u7c7b\u578b\u3002", (String)"ProjectProcessDocBillPlugin_5", (String)"pmgt-pmfs-formplugin", (Object[])new Object[0]));
        }
        DynamicObject project = model.getDynamicObject("project");
        DynamicObject projectKind = project.getDynamicObject("group");
        HashSet<Long> attachTypeIds = new HashSet<Long>(1);
        attachTypeIds.add(0L);
        if (null != projectKind && (setting = BusinessDataServiceHelper.loadSingleFromCache((String)"pmbs_prokindctrlsetting", (QFilter[])new QFilter[]{projectKindFilter = new QFilter("projectkind", "=", projectKind.getPkValue())})).getBoolean("enable") && !(fileTypeEntries = setting.getDynamicObjectCollection("filetypeentry")).isEmpty()) {
            attachTypeIds = new HashSet(fileTypeEntries.size());
            for (DynamicObject fileTypeEntry : fileTypeEntries) {
                DynamicObject fileType = fileTypeEntry.getDynamicObject("filetype");
                if (fileType == null) continue;
                attachTypeIds.add(fileType.getLong("id"));
            }
        }
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        List qFilters = showParameter.getListFilterParameter().getQFilters();
        qFilters.add(new QFilter("id", "in", (Object)attachTypeIds.toArray()));
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "attachtype"));
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        String callbackId;
        super.confirmCallBack(evt);
        switch (callbackId = evt.getCallBackId()) {
            case "project": {
                String project = this.getView().getPageCache().get("project");
                if (evt.getResult().getValue() == MessageBoxResult.Yes.getValue()) {
                    this.getModel().setValue("attachtype", null);
                    break;
                }
                if (StringUtils.isNotEmpty((CharSequence)project)) {
                    this.getModel().setValue("project", (Object)Long.parseLong(project));
                    break;
                }
                this.getModel().setValue("project", null);
            }
        }
    }
}

