/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmfs.formplugin.supervision;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pmgt.pmbs.business.helper.SupervisionPropertyHelper;
import kd.pmgt.pmfs.formplugin.base.AbstractPmfsFormPlugin;

public class SelectSupervisionBuisBill
extends AbstractPmfsFormPlugin
implements SearchEnterListener {
    private static final String OPERATE_CLOSE = "close";
    private static final String OPERATE_RETURNBILLDATA = "returnbilldata";
    private static final String OPERATE_SEARCHAP = "searchap";
    public static String[] PROJECT_ARR = new String[]{"pmas_pro_approval"};

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Search search = (Search)this.getControl(OPERATE_SEARCHAP);
        search.addEnterListener((SearchEnterListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
        this.loadData(qFilters);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "returnbilldata": {
                DynamicObjectCollection dynamicObjectCollection = this.getModel().getEntryEntity("entryentity");
                EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
                int[] selectRows = entryGrid.getSelectRows();
                if (selectRows.length == 0) {
                    this.getView().showMessage(ResManager.loadKDStringExt((String)"\u6ca1\u6709\u9009\u4e2d\u884c\u3002", (String)"SelectSupervisionBuisBill_0", (String)"pmgt-pmfs-formplugin", (Object[])new Object[0]));
                    return;
                }
                DynamicObject dynamicObject = (DynamicObject)dynamicObjectCollection.get(selectRows[0]);
                this.getView().returnDataToParent((Object)dynamicObject.getString("billid"));
                this.getView().invokeOperation(OPERATE_CLOSE);
                break;
            }
        }
    }

    public void search(SearchEnterEvent evt) {
        String searchText = evt.getText();
        Search search = (Search)evt.getSource();
        if (OPERATE_SEARCHAP.equals(search.getKey())) {
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
            DynamicObjectCollection dynamicObjectCollection = this.getModel().getEntryEntity("entryentity");
            int[] indexs = new int[dynamicObjectCollection.size()];
            for (int i = 0; i < dynamicObjectCollection.size(); ++i) {
                indexs[i] = i;
            }
            this.getModel().deleteEntryRows("entryentity", indexs);
            this.getView().updateView("entryentity");
            if (!searchText.isEmpty()) {
                this.loadData(qFilters, searchText);
            } else {
                this.loadData(qFilters);
            }
        }
    }

    public void loadData(List<QFilter> qFilters) {
        String sysBillNum = (String)this.getView().getFormShowParameter().getCustomParam("sysBill");
        QFilter specialBillFilter = SupervisionPropertyHelper.getSpecialBillFilter((String)sysBillNum);
        Object projectId = this.getView().getFormShowParameter().getCustomParam("projectId");
        DynamicObject sysBillObj = BusinessDataServiceHelper.loadSingle((String)"pmbs_spvprop", (String)"profieldnum", (QFilter[])new QFilter[]{new QFilter("sysbill.number", "=", (Object)sysBillNum)});
        String proFieldNum = sysBillObj.getString("profieldnum");
        QFilter projectFilter = new QFilter(proFieldNum, "=", projectId);
        qFilters.add(projectFilter);
        qFilters.add(specialBillFilter);
        DynamicObject[] bizBillObj = BusinessDataServiceHelper.load((String)sysBillNum, (String)"id", (QFilter[])qFilters.toArray(new QFilter[qFilters.size()]));
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)sysBillNum);
        DataEntityPropertyCollection properties = dt.getProperties();
        String billNo = null;
        String billName = null;
        boolean billNoFlag = false;
        boolean billNameFlag = false;
        for (IMetadata property : properties) {
            if (billNoFlag && billNameFlag) break;
            if (!billNoFlag && !property.getName().isEmpty() && (property.getName().matches(".*billno.*") || property.getName().matches(".*number.*"))) {
                billNo = property.getName();
                billNoFlag = true;
                continue;
            }
            if (billNameFlag || property.getName().isEmpty() || !property.getName().matches(".*billname.*") && !property.getName().matches(".*name.*")) continue;
            billName = property.getName();
            billNameFlag = true;
        }
        if (billNo == null && billName == null) {
            this.getView().showErrorNotification(ResManager.loadKDStringExt((String)"\u8be5\u5355\u636e\u7684\u5355\u636e\u7f16\u53f7\u548c\u540d\u79f0\u6807\u8bc6\u672a\u6309\u4e8c\u5f00\u6807\u51c6\u8981\u6c42\u8bbe\u7f6e\uff0c\u65e0\u6cd5\u652f\u6301\u672c\u914d\u7f6e\u8981\u6c42\u3002\u5982\u6709\u9700\u8981\uff0c\u8bf7\u627e\u6280\u672f\u4eba\u5458\u89e3\u51b3\u3002", (String)"SelectSupervisionBuisBill_2", (String)"pmgt-pmfs-formplugin", (Object[])new Object[0]));
            return;
        }
        for (int i = 0; i < bizBillObj.length; ++i) {
            DynamicObject bizBill = BusinessDataServiceHelper.loadSingle((Object)bizBillObj[i].getPkValue(), (DynamicObjectType)dt);
            if (bizBill == null) continue;
            this.getModel().createNewEntryRow("entryentity");
            this.getModel().setValue("billid", bizBill.getPkValue(), i);
            if (billNoFlag) {
                this.getModel().setValue("billno", (Object)bizBill.getString(billNo), i);
            }
            if (billNameFlag) {
                this.getModel().setValue("name", (Object)bizBill.getString(billName), i);
            }
            this.getModel().setValue("creator", (Object)bizBill.getDynamicObject("creator"), i);
            this.getModel().setValue("createtime", (Object)bizBill.getDate("createtime"), i);
            this.getModel().setValue("auditor", (Object)bizBill.getDynamicObject("auditor"), i);
            this.getModel().setValue("auditdate", (Object)bizBill.getDate("auditdate"), i);
            this.getModel().setValue("status", (Object)bizBill.getString("billstatus"), i);
        }
    }

    public void loadData(List<QFilter> qFilters, String searchText) {
        String sysBillNum = (String)this.getView().getFormShowParameter().getCustomParam("sysBill");
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)sysBillNum);
        DataEntityPropertyCollection properties = dt.getProperties();
        String billNo = null;
        String billName = null;
        boolean billNoFlag = false;
        boolean billNameFlag = false;
        for (IMetadata property : properties) {
            if (billNoFlag && billNameFlag) break;
            if (!billNoFlag && !property.getName().isEmpty() && (property.getName().matches(".*billno.*") || property.getName().matches(".*number.*"))) {
                billNo = property.getName();
                billNoFlag = true;
                continue;
            }
            if (billNameFlag || property.getName().isEmpty() || !property.getName().matches(".*billname.*") && !property.getName().matches(".*name.*")) continue;
            billName = property.getName();
            billNameFlag = true;
        }
        if (billNoFlag && billNameFlag) {
            qFilters.add(new QFilter(billNo, "like", (Object)("%" + searchText + "%")).or(billName, "like", (Object)("%" + searchText + "%")));
        } else if (billNoFlag) {
            qFilters.add(new QFilter(billNo, "like", (Object)("%" + searchText + "%")));
        } else if (billNameFlag) {
            qFilters.add(new QFilter(billName, "like", (Object)("%" + searchText + "%")));
        }
        QFilter specialBillFilter = SupervisionPropertyHelper.getSpecialBillFilter((String)sysBillNum);
        Object projectId = this.getView().getFormShowParameter().getCustomParam("projectId");
        DynamicObject sysBillObj = BusinessDataServiceHelper.loadSingle((String)"pmbs_spvprop", (String)"profieldnum", (QFilter[])new QFilter[]{new QFilter("sysbill.number", "=", (Object)sysBillNum)});
        String proFieldNum = sysBillObj.getString("profieldnum");
        QFilter projectFilter = new QFilter(proFieldNum, "=", projectId);
        qFilters.add(projectFilter);
        qFilters.add(specialBillFilter);
        DynamicObject[] bizBillObj = BusinessDataServiceHelper.load((String)sysBillNum, (String)"id", (QFilter[])qFilters.toArray(new QFilter[qFilters.size()]));
        for (int i = 0; i < bizBillObj.length; ++i) {
            DynamicObject bizBill = BusinessDataServiceHelper.loadSingle((Object)bizBillObj[i].getPkValue(), (DynamicObjectType)dt);
            if (bizBill == null) continue;
            this.getModel().createNewEntryRow("entryentity");
            this.getModel().setValue("billid", bizBill.getPkValue(), i);
            if (billNoFlag) {
                this.getModel().setValue("billno", (Object)bizBill.getString(billNo), i);
            }
            if (billNameFlag) {
                this.getModel().setValue("name", (Object)bizBill.getString(billName), i);
            }
            this.getModel().setValue("creator", (Object)bizBill.getDynamicObject("creator"), i);
            this.getModel().setValue("createtime", (Object)bizBill.getDate("createtime"), i);
            this.getModel().setValue("auditor", (Object)bizBill.getDynamicObject("auditor"), i);
            this.getModel().setValue("auditdate", (Object)bizBill.getDate("auditdate"), i);
            this.getModel().setValue("status", (Object)bizBill.getString("billstatus"), i);
        }
    }
}

